/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.cache;

import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.Flushable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import okhttp3.internal.Util;
import okhttp3.internal.cache.DiskLruCache;
import okhttp3.internal.cache.FaultHidingSink;
import okhttp3.internal.concurrent.TaskQueue;
import okhttp3.internal.io.FileSystem;
import okhttp3.internal.platform.Platform;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ForwardingSource;
import okio.Okio;
import okio.Sink;
import okio.Source;

public final class DiskLruCache
implements Closeable,
Flushable {
    public static final Companion Companion = new Companion(null);
    private final FileSystem fileSystem;
    private final File directory;
    private final int appVersion;
    private final int valueCount;
    private long maxSize;
    private final File journalFile;
    private final File journalFileTmp;
    private final File journalFileBackup;
    private long size;
    private BufferedSink journalWriter;
    private final LinkedHashMap<String, Entry> lruEntries;
    private int redundantOpCount;
    private boolean hasJournalErrors;
    private boolean civilizedFileSystem;
    private boolean initialized;
    private boolean closed;
    private boolean mostRecentTrimFailed;
    private boolean mostRecentRebuildFailed;
    private long nextSequenceNumber;
    private final TaskQueue cleanupQueue;
    private final cleanupTask.1 cleanupTask;
    public static final String JOURNAL_FILE = "journal";
    public static final String JOURNAL_FILE_TEMP = "journal.tmp";
    public static final String JOURNAL_FILE_BACKUP = "journal.bkp";
    public static final String MAGIC = "libcore.io.DiskLruCache";
    public static final String VERSION_1 = "1";
    public static final long ANY_SEQUENCE_NUMBER = -1L;
    public static final Regex LEGAL_KEY_PATTERN = new Regex("[a-z0-9_-]{1,120}");
    public static final String CLEAN = "CLEAN";
    public static final String DIRTY = "DIRTY";
    public static final String REMOVE = "REMOVE";
    public static final String READ = "READ";

    public final FileSystem getFileSystem$okhttp() {
        return this.fileSystem;
    }

    public final File getDirectory() {
        return this.directory;
    }

    public final int getValueCount$okhttp() {
        return this.valueCount;
    }

    public final LinkedHashMap<String, Entry> getLruEntries$okhttp() {
        return this.lruEntries;
    }

    public final boolean getClosed$okhttp() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void initialize() throws IOException {
        DiskLruCache $this$assertThreadHoldsLock$iv = this;
        boolean $i$f$assertThreadHoldsLock = false;
        if (Util.assertionsEnabled && !Thread.holdsLock($this$assertThreadHoldsLock$iv)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + $this$assertThreadHoldsLock$iv));
        }
        if (this.initialized) {
            return;
        }
        if (this.fileSystem.exists(this.journalFileBackup)) {
            if (this.fileSystem.exists(this.journalFile)) {
                this.fileSystem.delete(this.journalFileBackup);
            } else {
                this.fileSystem.rename(this.journalFileBackup, this.journalFile);
            }
        }
        this.civilizedFileSystem = Util.isCivilized(this.fileSystem, this.journalFileBackup);
        if (this.fileSystem.exists(this.journalFile)) {
            try {
                this.readJournal();
                this.processJournal();
                this.initialized = true;
                return;
            }
            catch (IOException journalIsCorrupt) {
                Platform.Companion.get().log("DiskLruCache " + this.directory + " is corrupt: " + journalIsCorrupt.getMessage() + ", removing", 5, journalIsCorrupt);
                try {
                    this.delete();
                }
                finally {
                    this.closed = false;
                }
            }
        }
        this.rebuildJournal$okhttp();
        this.initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void readJournal() throws IOException {
        Closeable closeable = Okio.buffer(this.fileSystem.source(this.journalFile));
        Throwable throwable = null;
        try {
            BufferedSource source2 = (BufferedSource)closeable;
            boolean bl = false;
            String magic = source2.readUtf8LineStrict();
            String version = source2.readUtf8LineStrict();
            String appVersionString = source2.readUtf8LineStrict();
            String valueCountString = source2.readUtf8LineStrict();
            String blank = source2.readUtf8LineStrict();
            if (!Intrinsics.areEqual(MAGIC, magic)) throw new IOException("unexpected journal header: [" + magic + ", " + version + ", " + valueCountString + ", " + blank + ']');
            if (!Intrinsics.areEqual(VERSION_1, version)) throw new IOException("unexpected journal header: [" + magic + ", " + version + ", " + valueCountString + ", " + blank + ']');
            if (!Intrinsics.areEqual(String.valueOf(this.appVersion), appVersionString)) throw new IOException("unexpected journal header: [" + magic + ", " + version + ", " + valueCountString + ", " + blank + ']');
            if (!Intrinsics.areEqual(String.valueOf(this.getValueCount$okhttp()), valueCountString)) throw new IOException("unexpected journal header: [" + magic + ", " + version + ", " + valueCountString + ", " + blank + ']');
            if (((CharSequence)blank).length() > 0) {
                throw new IOException("unexpected journal header: [" + magic + ", " + version + ", " + valueCountString + ", " + blank + ']');
            }
            int lineCount = 0;
            try {
                while (true) {
                    this.readJournalLine(source2.readUtf8LineStrict());
                    int n = lineCount;
                    lineCount = n + 1;
                }
            }
            catch (EOFException _) {
                this.redundantOpCount = lineCount - this.getLruEntries$okhttp().size();
                if (!source2.exhausted()) {
                    this.rebuildJournal$okhttp();
                } else {
                    this.journalWriter = this.newJournalWriter();
                }
                Unit unit = Unit.INSTANCE;
                return;
            }
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }

    private final BufferedSink newJournalWriter() throws FileNotFoundException {
        Sink fileSink = this.fileSystem.appendingSink(this.journalFile);
        FaultHidingSink faultHidingSink2 = new FaultHidingSink(fileSink, (Function1<? super IOException, Unit>)new Function1<IOException, Unit>(this){
            final /* synthetic */ DiskLruCache this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(IOException it) {
                Intrinsics.checkNotNullParameter(it, "it");
                DiskLruCache $this$assertThreadHoldsLock$iv = this.this$0;
                boolean $i$f$assertThreadHoldsLock = false;
                if (Util.assertionsEnabled && !Thread.holdsLock($this$assertThreadHoldsLock$iv)) {
                    throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + $this$assertThreadHoldsLock$iv));
                }
                DiskLruCache.access$setHasJournalErrors$p(this.this$0, true);
            }
        });
        return Okio.buffer(faultHidingSink2);
    }

    private final void readJournalLine(String line) throws IOException {
        Entry entry;
        int firstSpace = StringsKt.indexOf$default((CharSequence)line, ' ', 0, false, 6, null);
        if (firstSpace == -1) {
            throw new IOException(Intrinsics.stringPlus("unexpected journal line: ", line));
        }
        int keyBegin = firstSpace + 1;
        int secondSpace = StringsKt.indexOf$default((CharSequence)line, ' ', keyBegin, false, 4, null);
        String key = null;
        if (secondSpace == -1) {
            String string = line.substring(keyBegin);
            Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).substring(startIndex)");
            key = string;
            if (firstSpace == REMOVE.length() && StringsKt.startsWith$default(line, REMOVE, false, 2, null)) {
                this.lruEntries.remove(key);
                return;
            }
        } else {
            String string = line.substring(keyBegin, secondSpace);
            Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String\u2026ing(startIndex, endIndex)");
            key = string;
        }
        if ((entry = this.lruEntries.get(key)) == null) {
            entry = new Entry(key);
            ((Map)this.lruEntries).put(key, entry);
        }
        if (secondSpace != -1 && firstSpace == CLEAN.length() && StringsKt.startsWith$default(line, CLEAN, false, 2, null)) {
            Object object = line;
            int n = secondSpace + 1;
            String string = ((String)object).substring(n);
            Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).substring(startIndex)");
            object = new char[1];
            object[0] = 32;
            List parts = StringsKt.split$default(string, (char[])object, false, 0, 6, null);
            entry.setReadable$okhttp(true);
            entry.setCurrentEditor$okhttp(null);
            entry.setLengths$okhttp(parts);
        } else if (secondSpace == -1 && firstSpace == DIRTY.length() && StringsKt.startsWith$default(line, DIRTY, false, 2, null)) {
            entry.setCurrentEditor$okhttp(new Editor(entry));
        } else if (secondSpace != -1 || firstSpace != READ.length() || !StringsKt.startsWith$default(line, READ, false, 2, null)) {
            throw new IOException(Intrinsics.stringPlus("unexpected journal line: ", line));
        }
    }

    private final void processJournal() throws IOException {
        this.fileSystem.delete(this.journalFileTmp);
        Iterator<Entry> i = this.lruEntries.values().iterator();
        while (i.hasNext()) {
            int t;
            int n;
            int n2;
            Entry entry = i.next();
            Intrinsics.checkNotNullExpressionValue(entry, "i.next()");
            Entry entry2 = entry;
            if (entry2.getCurrentEditor$okhttp() == null) {
                n2 = 0;
                n = this.valueCount;
                while (n2 < n) {
                    t = n2++;
                    this.size += entry2.getLengths$okhttp()[t];
                }
                continue;
            }
            entry2.setCurrentEditor$okhttp(null);
            n2 = 0;
            n = this.valueCount;
            while (n2 < n) {
                t = n2++;
                this.fileSystem.delete(entry2.getCleanFiles$okhttp().get(t));
                this.fileSystem.delete(entry2.getDirtyFiles$okhttp().get(t));
            }
            i.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void rebuildJournal$okhttp() throws IOException {
        BufferedSink bufferedSink = this.journalWriter;
        if (bufferedSink != null) {
            bufferedSink.close();
        }
        Closeable closeable = Okio.buffer(this.fileSystem.sink(this.journalFileTmp));
        Throwable throwable = null;
        try {
            BufferedSink sink2 = (BufferedSink)closeable;
            boolean bl = false;
            sink2.writeUtf8(MAGIC).writeByte(10);
            sink2.writeUtf8(VERSION_1).writeByte(10);
            sink2.writeDecimalLong(this.appVersion).writeByte(10);
            sink2.writeDecimalLong(this.getValueCount$okhttp()).writeByte(10);
            sink2.writeByte(10);
            for (Entry entry : this.getLruEntries$okhttp().values()) {
                if (entry.getCurrentEditor$okhttp() != null) {
                    sink2.writeUtf8(DIRTY).writeByte(32);
                    sink2.writeUtf8(entry.getKey$okhttp());
                    sink2.writeByte(10);
                    continue;
                }
                sink2.writeUtf8(CLEAN).writeByte(32);
                sink2.writeUtf8(entry.getKey$okhttp());
                entry.writeLengths$okhttp(sink2);
                sink2.writeByte(10);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        if (this.fileSystem.exists(this.journalFile)) {
            this.fileSystem.rename(this.journalFile, this.journalFileBackup);
        }
        this.fileSystem.rename(this.journalFileTmp, this.journalFile);
        this.fileSystem.delete(this.journalFileBackup);
        this.journalWriter = this.newJournalWriter();
        this.hasJournalErrors = false;
        this.mostRecentRebuildFailed = false;
    }

    public final synchronized Snapshot get(String key) throws IOException {
        Intrinsics.checkNotNullParameter(key, "key");
        this.initialize();
        this.checkNotClosed();
        this.validateKey(key);
        Entry entry = this.lruEntries.get(key);
        if (entry == null) {
            return null;
        }
        Entry entry2 = entry;
        Snapshot snapshot = entry2.snapshot$okhttp();
        if (snapshot == null) {
            return null;
        }
        Snapshot snapshot2 = snapshot;
        int n = this.redundantOpCount;
        this.redundantOpCount = n + 1;
        BufferedSink bufferedSink = this.journalWriter;
        Intrinsics.checkNotNull(bufferedSink);
        bufferedSink.writeUtf8(READ).writeByte(32).writeUtf8(key).writeByte(10);
        if (this.journalRebuildRequired()) {
            TaskQueue.schedule$default(this.cleanupQueue, this.cleanupTask, 0L, 2, null);
        }
        return snapshot2;
    }

    public final synchronized Editor edit(String key, long expectedSequenceNumber) throws IOException {
        Intrinsics.checkNotNullParameter(key, "key");
        this.initialize();
        this.checkNotClosed();
        this.validateKey(key);
        Entry entry = this.lruEntries.get(key);
        if (expectedSequenceNumber != ANY_SEQUENCE_NUMBER && (entry == null || entry.getSequenceNumber$okhttp() != expectedSequenceNumber)) {
            return null;
        }
        Entry entry2 = entry;
        if ((entry2 == null ? null : entry2.getCurrentEditor$okhttp()) != null) {
            return null;
        }
        if (entry != null && entry.getLockingSourceCount$okhttp() != 0) {
            return null;
        }
        if (this.mostRecentTrimFailed || this.mostRecentRebuildFailed) {
            TaskQueue.schedule$default(this.cleanupQueue, this.cleanupTask, 0L, 2, null);
            return null;
        }
        BufferedSink bufferedSink = this.journalWriter;
        Intrinsics.checkNotNull(bufferedSink);
        BufferedSink journalWriter = bufferedSink;
        journalWriter.writeUtf8(DIRTY).writeByte(32).writeUtf8(key).writeByte(10);
        journalWriter.flush();
        if (this.hasJournalErrors) {
            return null;
        }
        if (entry == null) {
            entry = new Entry(key);
            ((Map)this.lruEntries).put(key, entry);
        }
        Editor editor = new Editor(entry);
        entry.setCurrentEditor$okhttp(editor);
        return editor;
    }

    public static /* synthetic */ Editor edit$default(DiskLruCache diskLruCache, String string, long l, int n, Object object) throws IOException {
        if ((n & 2) != 0) {
            l = ANY_SEQUENCE_NUMBER;
        }
        return diskLruCache.edit(string, l);
    }

    public final synchronized void completeEdit$okhttp(Editor editor, boolean success) throws IOException {
        BufferedSink bufferedSink;
        int i;
        int n;
        int n2;
        Intrinsics.checkNotNullParameter(editor, "editor");
        Entry entry = editor.getEntry$okhttp();
        if (!Intrinsics.areEqual(entry.getCurrentEditor$okhttp(), editor)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        if (success && !entry.getReadable$okhttp()) {
            n2 = 0;
            n = this.valueCount;
            while (n2 < n) {
                i = n2++;
                boolean[] blArray = editor.getWritten$okhttp();
                Intrinsics.checkNotNull(blArray);
                if (!blArray[i]) {
                    editor.abort();
                    throw new IllegalStateException(Intrinsics.stringPlus("Newly created entry didn't create value for index ", i));
                }
                if (this.fileSystem.exists(entry.getDirtyFiles$okhttp().get(i))) continue;
                editor.abort();
                return;
            }
        }
        n2 = 0;
        n = this.valueCount;
        while (n2 < n) {
            i = n2++;
            File dirty = entry.getDirtyFiles$okhttp().get(i);
            if (success && !entry.getZombie$okhttp()) {
                long newLength;
                if (!this.fileSystem.exists(dirty)) continue;
                File clean = entry.getCleanFiles$okhttp().get(i);
                this.fileSystem.rename(dirty, clean);
                long oldLength = entry.getLengths$okhttp()[i];
                entry.getLengths$okhttp()[i] = newLength = this.fileSystem.size(clean);
                this.size = this.size - oldLength + newLength;
                continue;
            }
            this.fileSystem.delete(dirty);
        }
        entry.setCurrentEditor$okhttp(null);
        if (entry.getZombie$okhttp()) {
            this.removeEntry$okhttp(entry);
            return;
        }
        n2 = this.redundantOpCount;
        this.redundantOpCount = n2 + 1;
        BufferedSink bufferedSink2 = this.journalWriter;
        Intrinsics.checkNotNull(bufferedSink2);
        BufferedSink $this$completeEdit_u24lambda_u2d4 = bufferedSink = bufferedSink2;
        boolean bl = false;
        if (entry.getReadable$okhttp() || success) {
            entry.setReadable$okhttp(true);
            $this$completeEdit_u24lambda_u2d4.writeUtf8(CLEAN).writeByte(32);
            $this$completeEdit_u24lambda_u2d4.writeUtf8(entry.getKey$okhttp());
            entry.writeLengths$okhttp($this$completeEdit_u24lambda_u2d4);
            $this$completeEdit_u24lambda_u2d4.writeByte(10);
            if (success) {
                long l = this.nextSequenceNumber;
                this.nextSequenceNumber = l + 1L;
                entry.setSequenceNumber$okhttp(l);
            }
        } else {
            this.getLruEntries$okhttp().remove(entry.getKey$okhttp());
            $this$completeEdit_u24lambda_u2d4.writeUtf8(REMOVE).writeByte(32);
            $this$completeEdit_u24lambda_u2d4.writeUtf8(entry.getKey$okhttp());
            $this$completeEdit_u24lambda_u2d4.writeByte(10);
        }
        $this$completeEdit_u24lambda_u2d4.flush();
        if (this.size > this.maxSize || this.journalRebuildRequired()) {
            TaskQueue.schedule$default(this.cleanupQueue, this.cleanupTask, 0L, 2, null);
        }
    }

    private final boolean journalRebuildRequired() {
        int redundantOpCompactThreshold = 2000;
        return this.redundantOpCount >= redundantOpCompactThreshold && this.redundantOpCount >= this.lruEntries.size();
    }

    public final synchronized boolean remove(String key) throws IOException {
        Intrinsics.checkNotNullParameter(key, "key");
        this.initialize();
        this.checkNotClosed();
        this.validateKey(key);
        Entry entry = this.lruEntries.get(key);
        if (entry == null) {
            return false;
        }
        Entry entry2 = entry;
        boolean removed = this.removeEntry$okhttp(entry2);
        if (removed && this.size <= this.maxSize) {
            this.mostRecentTrimFailed = false;
        }
        return removed;
    }

    public final boolean removeEntry$okhttp(Entry entry) throws IOException {
        BufferedSink it;
        Intrinsics.checkNotNullParameter(entry, "entry");
        if (!this.civilizedFileSystem) {
            if (entry.getLockingSourceCount$okhttp() > 0) {
                BufferedSink bufferedSink = this.journalWriter;
                if (bufferedSink != null) {
                    it = bufferedSink;
                    boolean bl = false;
                    it.writeUtf8(DIRTY);
                    it.writeByte(32);
                    it.writeUtf8(entry.getKey$okhttp());
                    it.writeByte(10);
                    it.flush();
                }
            }
            if (entry.getLockingSourceCount$okhttp() > 0 || entry.getCurrentEditor$okhttp() != null) {
                entry.setZombie$okhttp(true);
                return true;
            }
        }
        Editor editor = entry.getCurrentEditor$okhttp();
        if (editor != null) {
            editor.detach$okhttp();
        }
        int n = 0;
        int n2 = this.valueCount;
        while (n < n2) {
            int i = n++;
            this.fileSystem.delete(entry.getCleanFiles$okhttp().get(i));
            this.size -= entry.getLengths$okhttp()[i];
            entry.getLengths$okhttp()[i] = 0L;
        }
        n = this.redundantOpCount;
        this.redundantOpCount = n + 1;
        BufferedSink bufferedSink = this.journalWriter;
        if (bufferedSink != null) {
            it = bufferedSink;
            boolean bl = false;
            it.writeUtf8(REMOVE);
            it.writeByte(32);
            it.writeUtf8(entry.getKey$okhttp());
            it.writeByte(10);
        }
        this.lruEntries.remove(entry.getKey$okhttp());
        if (this.journalRebuildRequired()) {
            TaskQueue.schedule$default(this.cleanupQueue, this.cleanupTask, 0L, 2, null);
        }
        return true;
    }

    private final synchronized void checkNotClosed() {
        if (!(!this.closed)) {
            boolean bl = false;
            String string = "cache is closed";
            throw new IllegalStateException(string.toString());
        }
    }

    @Override
    public synchronized void flush() throws IOException {
        if (!this.initialized) {
            return;
        }
        this.checkNotClosed();
        this.trimToSize();
        BufferedSink bufferedSink = this.journalWriter;
        Intrinsics.checkNotNull(bufferedSink);
        bufferedSink.flush();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void close() throws IOException {
        void $this$toTypedArray$iv;
        if (!this.initialized || this.closed) {
            this.closed = true;
            return;
        }
        Collection<Entry> collection = this.lruEntries.values();
        Intrinsics.checkNotNullExpressionValue(collection, "lruEntries.values");
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        Entry[] entryArray = thisCollection$iv.toArray(new Entry[0]);
        if (entryArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        for (Entry entry : entryArray) {
            if (entry.getCurrentEditor$okhttp() == null) continue;
            Editor editor = entry.getCurrentEditor$okhttp();
            if (editor == null) continue;
            editor.detach$okhttp();
        }
        this.trimToSize();
        BufferedSink bufferedSink = this.journalWriter;
        Intrinsics.checkNotNull(bufferedSink);
        bufferedSink.close();
        this.journalWriter = null;
        this.closed = true;
    }

    public final void trimToSize() throws IOException {
        while (this.size > this.maxSize) {
            if (this.removeOldestEntry()) continue;
            return;
        }
        this.mostRecentTrimFailed = false;
    }

    private final boolean removeOldestEntry() {
        for (Entry toEvict : this.lruEntries.values()) {
            if (toEvict.getZombie$okhttp()) continue;
            Intrinsics.checkNotNullExpressionValue(toEvict, "toEvict");
            this.removeEntry$okhttp(toEvict);
            return true;
        }
        return false;
    }

    public final void delete() throws IOException {
        this.close();
        this.fileSystem.deleteContents(this.directory);
    }

    private final void validateKey(String key) {
        if (!LEGAL_KEY_PATTERN.matches(key)) {
            boolean bl = false;
            String string = "keys must match regex [a-z0-9_-]{1,120}: \"" + key + '\"';
            throw new IllegalArgumentException(string.toString());
        }
    }

    public static final /* synthetic */ void access$setHasJournalErrors$p(DiskLruCache $this, boolean bl) {
        $this.hasJournalErrors = bl;
    }

    public static final /* synthetic */ boolean access$getInitialized$p(DiskLruCache $this) {
        return $this.initialized;
    }

    public static final /* synthetic */ void access$setMostRecentTrimFailed$p(DiskLruCache $this, boolean bl) {
        $this.mostRecentTrimFailed = bl;
    }

    public static final /* synthetic */ boolean access$journalRebuildRequired(DiskLruCache $this) {
        return $this.journalRebuildRequired();
    }

    public static final /* synthetic */ void access$setRedundantOpCount$p(DiskLruCache $this, int n) {
        $this.redundantOpCount = n;
    }

    public static final /* synthetic */ void access$setMostRecentRebuildFailed$p(DiskLruCache $this, boolean bl) {
        $this.mostRecentRebuildFailed = bl;
    }

    public static final /* synthetic */ void access$setJournalWriter$p(DiskLruCache $this, BufferedSink bufferedSink) {
        $this.journalWriter = bufferedSink;
    }

    public final class Snapshot
    implements Closeable {
        private final String key;
        private final long sequenceNumber;
        private final List<Source> sources;
        private final long[] lengths;

        public Snapshot(String key, long sequenceNumber, List<? extends Source> sources, long[] lengths) {
            Intrinsics.checkNotNullParameter(DiskLruCache.this, "this$0");
            Intrinsics.checkNotNullParameter(key, "key");
            Intrinsics.checkNotNullParameter(sources, "sources");
            Intrinsics.checkNotNullParameter(lengths, "lengths");
            this.key = key;
            this.sequenceNumber = sequenceNumber;
            this.sources = sources;
            this.lengths = lengths;
        }

        public final Editor edit() throws IOException {
            return DiskLruCache.this.edit(this.key, this.sequenceNumber);
        }

        public final Source getSource(int index) {
            return this.sources.get(index);
        }

        @Override
        public void close() {
            for (Source source2 : this.sources) {
                Util.closeQuietly(source2);
            }
        }
    }

    public final class Editor {
        private final Entry entry;
        private final boolean[] written;
        private boolean done;

        public Editor(Entry entry) {
            Intrinsics.checkNotNullParameter(DiskLruCache.this, "this$0");
            Intrinsics.checkNotNullParameter(entry, "entry");
            this.entry = entry;
            this.written = this.entry.getReadable$okhttp() ? null : new boolean[DiskLruCache.this.getValueCount$okhttp()];
        }

        public final Entry getEntry$okhttp() {
            return this.entry;
        }

        public final boolean[] getWritten$okhttp() {
            return this.written;
        }

        public final void detach$okhttp() {
            if (Intrinsics.areEqual(this.entry.getCurrentEditor$okhttp(), this)) {
                if (DiskLruCache.this.civilizedFileSystem) {
                    DiskLruCache.this.completeEdit$okhttp(this, false);
                } else {
                    this.entry.setZombie$okhttp(true);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final Sink newSink(int index) {
            DiskLruCache diskLruCache = DiskLruCache.this;
            DiskLruCache diskLruCache2 = DiskLruCache.this;
            DiskLruCache diskLruCache3 = diskLruCache;
            synchronized (diskLruCache3) {
                block9: {
                    boolean bl = false;
                    if (!(!this.done)) {
                        String string = "Check failed.";
                        throw new IllegalStateException(string.toString());
                    }
                    if (Intrinsics.areEqual(this.getEntry$okhttp().getCurrentEditor$okhttp(), this)) break block9;
                    Sink sink2 = Okio.blackhole();
                    return sink2;
                }
                if (!this.getEntry$okhttp().getReadable$okhttp()) {
                    boolean[] blArray = this.getWritten$okhttp();
                    Intrinsics.checkNotNull(blArray);
                    blArray[index] = true;
                }
                File dirtyFile = this.getEntry$okhttp().getDirtyFiles$okhttp().get(index);
                Sink sink3 = null;
                try {
                    sink3 = diskLruCache2.getFileSystem$okhttp().sink(dirtyFile);
                }
                catch (FileNotFoundException _) {
                    Sink sink4 = Okio.blackhole();
                    return sink4;
                }
                Sink sink5 = new FaultHidingSink(sink3, (Function1<? super IOException, Unit>)new Function1<IOException, Unit>(diskLruCache2, this){
                    final /* synthetic */ DiskLruCache this$0;
                    final /* synthetic */ Editor this$1;
                    {
                        this.this$0 = $receiver;
                        this.this$1 = $receiver2;
                        super(1);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public final void invoke(IOException it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        DiskLruCache diskLruCache = this.this$0;
                        Editor editor = this.this$1;
                        DiskLruCache diskLruCache2 = diskLruCache;
                        synchronized (diskLruCache2) {
                            boolean bl = false;
                            editor.detach$okhttp();
                            Unit unit = Unit.INSTANCE;
                        }
                    }
                });
                return sink5;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void commit() throws IOException {
            DiskLruCache diskLruCache = DiskLruCache.this;
            DiskLruCache diskLruCache2 = DiskLruCache.this;
            DiskLruCache diskLruCache3 = diskLruCache;
            synchronized (diskLruCache3) {
                boolean bl = false;
                if (!(!this.done)) {
                    String string = "Check failed.";
                    throw new IllegalStateException(string.toString());
                }
                if (Intrinsics.areEqual(this.getEntry$okhttp().getCurrentEditor$okhttp(), this)) {
                    diskLruCache2.completeEdit$okhttp(this, true);
                }
                this.done = true;
                Unit unit = Unit.INSTANCE;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void abort() throws IOException {
            DiskLruCache diskLruCache = DiskLruCache.this;
            DiskLruCache diskLruCache2 = DiskLruCache.this;
            DiskLruCache diskLruCache3 = diskLruCache;
            synchronized (diskLruCache3) {
                boolean bl = false;
                if (!(!this.done)) {
                    String string = "Check failed.";
                    throw new IllegalStateException(string.toString());
                }
                if (Intrinsics.areEqual(this.getEntry$okhttp().getCurrentEditor$okhttp(), this)) {
                    diskLruCache2.completeEdit$okhttp(this, false);
                }
                this.done = true;
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    public final class Entry {
        private final String key;
        private final long[] lengths;
        private final List<File> cleanFiles;
        private final List<File> dirtyFiles;
        private boolean readable;
        private boolean zombie;
        private Editor currentEditor;
        private int lockingSourceCount;
        private long sequenceNumber;

        public Entry(String key) {
            Intrinsics.checkNotNullParameter(DiskLruCache.this, "this$0");
            Intrinsics.checkNotNullParameter(key, "key");
            this.key = key;
            this.lengths = new long[DiskLruCache.this.getValueCount$okhttp()];
            this.cleanFiles = new ArrayList();
            this.dirtyFiles = new ArrayList();
            StringBuilder fileBuilder = new StringBuilder(this.key).append('.');
            int truncateTo = fileBuilder.length();
            int n = 0;
            int n2 = DiskLruCache.this.getValueCount$okhttp();
            while (n < n2) {
                int i = n++;
                fileBuilder.append(i);
                ((Collection)this.cleanFiles).add(new File(DiskLruCache.this.getDirectory(), fileBuilder.toString()));
                fileBuilder.append(".tmp");
                ((Collection)this.dirtyFiles).add(new File(DiskLruCache.this.getDirectory(), fileBuilder.toString()));
                fileBuilder.setLength(truncateTo);
            }
        }

        public final String getKey$okhttp() {
            return this.key;
        }

        public final long[] getLengths$okhttp() {
            return this.lengths;
        }

        public final List<File> getCleanFiles$okhttp() {
            return this.cleanFiles;
        }

        public final List<File> getDirtyFiles$okhttp() {
            return this.dirtyFiles;
        }

        public final boolean getReadable$okhttp() {
            return this.readable;
        }

        public final void setReadable$okhttp(boolean bl) {
            this.readable = bl;
        }

        public final boolean getZombie$okhttp() {
            return this.zombie;
        }

        public final void setZombie$okhttp(boolean bl) {
            this.zombie = bl;
        }

        public final Editor getCurrentEditor$okhttp() {
            return this.currentEditor;
        }

        public final void setCurrentEditor$okhttp(Editor editor) {
            this.currentEditor = editor;
        }

        public final int getLockingSourceCount$okhttp() {
            return this.lockingSourceCount;
        }

        public final void setLockingSourceCount$okhttp(int n) {
            this.lockingSourceCount = n;
        }

        public final long getSequenceNumber$okhttp() {
            return this.sequenceNumber;
        }

        public final void setSequenceNumber$okhttp(long l) {
            this.sequenceNumber = l;
        }

        public final void setLengths$okhttp(List<String> strings) throws IOException {
            Intrinsics.checkNotNullParameter(strings, "strings");
            if (strings.size() != DiskLruCache.this.getValueCount$okhttp()) {
                this.invalidLengths(strings);
                throw new KotlinNothingValueException();
            }
            try {
                int n = 0;
                int n2 = strings.size();
                while (n < n2) {
                    int i = n++;
                    this.lengths[i] = Long.parseLong(strings.get(i));
                }
            }
            catch (NumberFormatException _) {
                this.invalidLengths(strings);
                throw new KotlinNothingValueException();
            }
        }

        public final void writeLengths$okhttp(BufferedSink writer) throws IOException {
            Intrinsics.checkNotNullParameter(writer, "writer");
            for (long length : this.lengths) {
                writer.writeByte(32).writeDecimalLong(length);
            }
        }

        private final Void invalidLengths(List<String> strings) throws IOException {
            throw new IOException(Intrinsics.stringPlus("unexpected journal line: ", strings));
        }

        public final Snapshot snapshot$okhttp() {
            DiskLruCache $this$assertThreadHoldsLock$iv = DiskLruCache.this;
            boolean $i$f$assertThreadHoldsLock = false;
            if (Util.assertionsEnabled && !Thread.holdsLock($this$assertThreadHoldsLock$iv)) {
                throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + $this$assertThreadHoldsLock$iv));
            }
            if (!this.readable) {
                return null;
            }
            if (!DiskLruCache.this.civilizedFileSystem && (this.currentEditor != null || this.zombie)) {
                return null;
            }
            List sources = new ArrayList();
            long[] lengths = (long[])this.lengths.clone();
            try {
                int n = 0;
                int n2 = DiskLruCache.this.getValueCount$okhttp();
                while (n < n2) {
                    int i = n++;
                    ((Collection)sources).add(this.newSource(i));
                }
                return new Snapshot(this.key, this.sequenceNumber, sources, lengths);
            }
            catch (FileNotFoundException _) {
                for (Source source2 : sources) {
                    Util.closeQuietly(source2);
                }
                try {
                    DiskLruCache.this.removeEntry$okhttp(this);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return null;
            }
        }

        private final Source newSource(int index) {
            Source fileSource = DiskLruCache.this.getFileSystem$okhttp().source(this.cleanFiles.get(index));
            if (DiskLruCache.this.civilizedFileSystem) {
                return fileSource;
            }
            int n = this.lockingSourceCount;
            this.lockingSourceCount = n + 1;
            return new ForwardingSource(fileSource, DiskLruCache.this, this){
                private boolean closed;
                final /* synthetic */ Source $fileSource;
                final /* synthetic */ DiskLruCache this$0;
                final /* synthetic */ Entry this$1;
                {
                    this.$fileSource = $fileSource;
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    super($fileSource);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void close() {
                    super.close();
                    if (!this.closed) {
                        this.closed = true;
                        DiskLruCache diskLruCache = this.this$0;
                        Entry entry = this.this$1;
                        DiskLruCache diskLruCache2 = this.this$0;
                        DiskLruCache diskLruCache3 = diskLruCache;
                        synchronized (diskLruCache3) {
                            boolean bl = false;
                            int n = entry.getLockingSourceCount$okhttp();
                            entry.setLockingSourceCount$okhttp(n + -1);
                            if (entry.getLockingSourceCount$okhttp() == 0 && entry.getZombie$okhttp()) {
                                diskLruCache2.removeEntry$okhttp(entry);
                            }
                            Unit unit = Unit.INSTANCE;
                        }
                    }
                }
            };
        }
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

