/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.platform;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.SSLSocket;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Protocol;
import okhttp3.internal.platform.Platform;

public final class Jdk8WithJettyBootPlatform
extends Platform {
    public static final Companion Companion = new Companion(null);
    private final Method putMethod;
    private final Method getMethod;
    private final Method removeMethod;
    private final Class<?> clientProviderClass;
    private final Class<?> serverProviderClass;

    public Jdk8WithJettyBootPlatform(Method putMethod, Method getMethod, Method removeMethod, Class<?> clientProviderClass, Class<?> serverProviderClass) {
        Intrinsics.checkNotNullParameter(putMethod, "putMethod");
        Intrinsics.checkNotNullParameter(getMethod, "getMethod");
        Intrinsics.checkNotNullParameter(removeMethod, "removeMethod");
        Intrinsics.checkNotNullParameter(clientProviderClass, "clientProviderClass");
        Intrinsics.checkNotNullParameter(serverProviderClass, "serverProviderClass");
        this.putMethod = putMethod;
        this.getMethod = getMethod;
        this.removeMethod = removeMethod;
        this.clientProviderClass = clientProviderClass;
        this.serverProviderClass = serverProviderClass;
    }

    public void configureTlsExtensions(SSLSocket sslSocket, String hostname, List<? extends Protocol> protocols) {
        Intrinsics.checkNotNullParameter(sslSocket, "sslSocket");
        Intrinsics.checkNotNullParameter(protocols, "protocols");
        List<String> names = Platform.Companion.alpnProtocolNames(protocols);
        try {
            Object[] objectArray = new Class[]{this.clientProviderClass, this.serverProviderClass};
            Object alpnProvider = Proxy.newProxyInstance(Platform.class.getClassLoader(), objectArray, (InvocationHandler)new AlpnProvider(names));
            objectArray = new Object[]{sslSocket, alpnProvider};
            this.putMethod.invoke(null, objectArray);
        }
        catch (InvocationTargetException e) {
            throw new AssertionError("failed to set ALPN", e);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError("failed to set ALPN", e);
        }
    }

    @Override
    public void afterHandshake(SSLSocket sslSocket) {
        Intrinsics.checkNotNullParameter(sslSocket, "sslSocket");
        try {
            Object[] objectArray = new Object[]{sslSocket};
            this.removeMethod.invoke(null, objectArray);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError("failed to remove ALPN", e);
        }
        catch (InvocationTargetException e) {
            throw new AssertionError("failed to remove ALPN", e);
        }
    }

    @Override
    public String getSelectedProtocol(SSLSocket sslSocket) {
        Intrinsics.checkNotNullParameter(sslSocket, "sslSocket");
        try {
            Object[] objectArray = new Object[]{sslSocket};
            InvocationHandler invocationHandler = Proxy.getInvocationHandler(this.getMethod.invoke(null, objectArray));
            if (invocationHandler == null) {
                throw new NullPointerException("null cannot be cast to non-null type okhttp3.internal.platform.Jdk8WithJettyBootPlatform.AlpnProvider");
            }
            AlpnProvider provider = (AlpnProvider)invocationHandler;
            if (!provider.getUnsupported() && provider.getSelected() == null) {
                Platform.log$default(this, "ALPN callback dropped: HTTP/2 is disabled. Is alpn-boot on the boot class path?", 0, null, 6, null);
                return null;
            }
            return provider.getUnsupported() ? null : provider.getSelected();
        }
        catch (InvocationTargetException e) {
            throw new AssertionError("failed to get ALPN selected protocol", e);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError("failed to get ALPN selected protocol", e);
        }
    }

    private static final class AlpnProvider
    implements InvocationHandler {
        private final List<String> protocols;
        private boolean unsupported;
        private String selected;

        public AlpnProvider(List<String> protocols) {
            Intrinsics.checkNotNullParameter(protocols, "protocols");
            this.protocols = protocols;
        }

        public final boolean getUnsupported() {
            return this.unsupported;
        }

        public final String getSelected() {
            return this.selected;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Intrinsics.checkNotNullParameter(proxy, "proxy");
            Intrinsics.checkNotNullParameter(method, "method");
            Object[] objectArray = args;
            if (args == null) {
                objectArray = new Object[]{};
            }
            Object[] callArgs = objectArray;
            String methodName = method.getName();
            Class<?> returnType = method.getReturnType();
            if (Intrinsics.areEqual(methodName, "supports") && Intrinsics.areEqual(Boolean.TYPE, returnType)) {
                return true;
            }
            if (Intrinsics.areEqual(methodName, "unsupported") && Intrinsics.areEqual(Void.TYPE, returnType)) {
                this.unsupported = true;
                return null;
            }
            if (Intrinsics.areEqual(methodName, "protocols") && callArgs.length == 0) {
                return this.protocols;
            }
            if ((Intrinsics.areEqual(methodName, "selectProtocol") || Intrinsics.areEqual(methodName, "select")) && Intrinsics.areEqual(String.class, returnType) && callArgs.length == 1 && callArgs[0] instanceof List) {
                Object object = callArgs[0];
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.List<*>");
                }
                int n = 0;
                List peerProtocols = (List)object;
                int n2 = peerProtocols.size();
                if (n <= n2) {
                    int i;
                    do {
                        i = n++;
                        Object e = peerProtocols.get(i);
                        if (e == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                        }
                        String protocol = (String)e;
                        if (!this.protocols.contains(protocol)) continue;
                        this.selected = protocol;
                        return this.selected;
                    } while (i != n2);
                }
                this.selected = this.protocols.get(0);
                return this.selected;
            }
            if ((Intrinsics.areEqual(methodName, "protocolSelected") || Intrinsics.areEqual(methodName, "selected")) && callArgs.length == 1) {
                Object object = callArgs[0];
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                }
                this.selected = (String)object;
                return null;
            }
            return method.invoke((Object)this, Arrays.copyOf(callArgs, callArgs.length));
        }
    }

    public static final class Companion {
        private Companion() {
        }

        public final Platform buildIfSupported() {
            String jvmVersion = System.getProperty("java.specification.version", "unknown");
            try {
                Intrinsics.checkNotNullExpressionValue(jvmVersion, "jvmVersion");
                int version = Integer.parseInt(jvmVersion);
                if (version >= 9) {
                    return null;
                }
            }
            catch (NumberFormatException version) {
                // empty catch block
            }
            try {
                String alpnClassName = "org.eclipse.jetty.alpn.ALPN";
                Class<?> alpnClass = Class.forName(alpnClassName, true, null);
                Class<?> providerClass = Class.forName(Intrinsics.stringPlus(alpnClassName, "$Provider"), true, null);
                Class<?> clientProviderClass = Class.forName(Intrinsics.stringPlus(alpnClassName, "$ClientProvider"), true, null);
                Class<?> serverProviderClass = Class.forName(Intrinsics.stringPlus(alpnClassName, "$ServerProvider"), true, null);
                Class[] classArray = new Class[]{SSLSocket.class, providerClass};
                Method putMethod = alpnClass.getMethod("put", classArray);
                Class[] classArray2 = new Class[]{SSLSocket.class};
                Method getMethod = alpnClass.getMethod("get", classArray2);
                Class[] classArray3 = new Class[]{SSLSocket.class};
                Method removeMethod = alpnClass.getMethod("remove", classArray3);
                Intrinsics.checkNotNullExpressionValue(putMethod, "putMethod");
                Intrinsics.checkNotNullExpressionValue(getMethod, "getMethod");
                Intrinsics.checkNotNullExpressionValue(removeMethod, "removeMethod");
                Intrinsics.checkNotNullExpressionValue(clientProviderClass, "clientProviderClass");
                Intrinsics.checkNotNullExpressionValue(serverProviderClass, "serverProviderClass");
                return new Jdk8WithJettyBootPlatform(putMethod, getMethod, removeMethod, clientProviderClass, serverProviderClass);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

