/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.revwalk;

import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.BitmapIndex;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;

public class AddToBitmapWithCacheFilter
extends RevFilter {
    private final AnyObjectId cachedCommit;
    private final BitmapIndex.Bitmap cachedBitmap;
    private final BitmapIndex.BitmapBuilder bitmap;

    public AddToBitmapWithCacheFilter(AnyObjectId cachedCommit, BitmapIndex.Bitmap cachedBitmap, BitmapIndex.BitmapBuilder bitmap) {
        this.cachedCommit = cachedCommit;
        this.cachedBitmap = cachedBitmap;
        this.bitmap = bitmap;
    }

    @Override
    public final boolean include(RevWalk rw, RevCommit c) {
        if (!this.bitmap.contains(c)) {
            BitmapIndex.Bitmap visitedBitmap = this.bitmap.getBitmapIndex().getBitmap(c);
            if (visitedBitmap != null) {
                this.bitmap.or(visitedBitmap);
            } else if (this.cachedCommit.equals(c)) {
                this.bitmap.or(this.cachedBitmap);
            } else {
                this.bitmap.addObject(c, 1);
                return true;
            }
        }
        for (RevCommit p : c.getParents()) {
            p.add(RevFlag.SEEN);
        }
        return false;
    }

    @Override
    public final RevFilter clone() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean requiresCommitBody() {
        return false;
    }
}

