// Copyright (c) HashiCorp, Inc.
// SPDX-License-Identifier: MPL-2.0

// Terraform Plugin RPC protocol version 6.10
//
// This file defines version 6.10 of the RPC protocol. To implement a plugin
// against this protocol, copy this definition into your own codebase and
// use protoc to generate stubs for your target language.
//
// Any minor versions of protocol 6 to follow should modify this file while
// maintaining backwards compatibility. Breaking changes, if any are required,
// will come in a subsequent major version with its own separate proto definition.
//
// Note that only the proto files included in a release tag of Terraform are
// official protocol releases. Proto files taken from other commits may include
// incomplete changes or features that did not make it into a final release.
// In all reasonable cases, plugin developers should take the proto file from
// the tag of the most recent release of Terraform, and not from the main
// branch or any other development branch.
//

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.6
// 	protoc        v3.15.6
// source: tfplugin6.proto

package tfplugin6

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type StringKind int32

const (
	StringKind_PLAIN    StringKind = 0
	StringKind_MARKDOWN StringKind = 1
)

// Enum value maps for StringKind.
var (
	StringKind_name = map[int32]string{
		0: "PLAIN",
		1: "MARKDOWN",
	}
	StringKind_value = map[string]int32{
		"PLAIN":    0,
		"MARKDOWN": 1,
	}
)

func (x StringKind) Enum() *StringKind {
	p := new(StringKind)
	*p = x
	return p
}

func (x StringKind) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (StringKind) Descriptor() protoreflect.EnumDescriptor {
	return file_tfplugin6_proto_enumTypes[0].Descriptor()
}

func (StringKind) Type() protoreflect.EnumType {
	return &file_tfplugin6_proto_enumTypes[0]
}

func (x StringKind) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use StringKind.Descriptor instead.
func (StringKind) EnumDescriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{0}
}

type Diagnostic_Severity int32

const (
	Diagnostic_INVALID Diagnostic_Severity = 0
	Diagnostic_ERROR   Diagnostic_Severity = 1
	Diagnostic_WARNING Diagnostic_Severity = 2
)

// Enum value maps for Diagnostic_Severity.
var (
	Diagnostic_Severity_name = map[int32]string{
		0: "INVALID",
		1: "ERROR",
		2: "WARNING",
	}
	Diagnostic_Severity_value = map[string]int32{
		"INVALID": 0,
		"ERROR":   1,
		"WARNING": 2,
	}
)

func (x Diagnostic_Severity) Enum() *Diagnostic_Severity {
	p := new(Diagnostic_Severity)
	*p = x
	return p
}

func (x Diagnostic_Severity) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Diagnostic_Severity) Descriptor() protoreflect.EnumDescriptor {
	return file_tfplugin6_proto_enumTypes[1].Descriptor()
}

func (Diagnostic_Severity) Type() protoreflect.EnumType {
	return &file_tfplugin6_proto_enumTypes[1]
}

func (x Diagnostic_Severity) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Diagnostic_Severity.Descriptor instead.
func (Diagnostic_Severity) EnumDescriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{1, 0}
}

type Schema_NestedBlock_NestingMode int32

const (
	Schema_NestedBlock_INVALID Schema_NestedBlock_NestingMode = 0
	Schema_NestedBlock_SINGLE  Schema_NestedBlock_NestingMode = 1
	Schema_NestedBlock_LIST    Schema_NestedBlock_NestingMode = 2
	Schema_NestedBlock_SET     Schema_NestedBlock_NestingMode = 3
	Schema_NestedBlock_MAP     Schema_NestedBlock_NestingMode = 4
	Schema_NestedBlock_GROUP   Schema_NestedBlock_NestingMode = 5
)

// Enum value maps for Schema_NestedBlock_NestingMode.
var (
	Schema_NestedBlock_NestingMode_name = map[int32]string{
		0: "INVALID",
		1: "SINGLE",
		2: "LIST",
		3: "SET",
		4: "MAP",
		5: "GROUP",
	}
	Schema_NestedBlock_NestingMode_value = map[string]int32{
		"INVALID": 0,
		"SINGLE":  1,
		"LIST":    2,
		"SET":     3,
		"MAP":     4,
		"GROUP":   5,
	}
)

func (x Schema_NestedBlock_NestingMode) Enum() *Schema_NestedBlock_NestingMode {
	p := new(Schema_NestedBlock_NestingMode)
	*p = x
	return p
}

func (x Schema_NestedBlock_NestingMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Schema_NestedBlock_NestingMode) Descriptor() protoreflect.EnumDescriptor {
	return file_tfplugin6_proto_enumTypes[2].Descriptor()
}

func (Schema_NestedBlock_NestingMode) Type() protoreflect.EnumType {
	return &file_tfplugin6_proto_enumTypes[2]
}

func (x Schema_NestedBlock_NestingMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Schema_NestedBlock_NestingMode.Descriptor instead.
func (Schema_NestedBlock_NestingMode) EnumDescriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{9, 2, 0}
}

type Schema_Object_NestingMode int32

const (
	Schema_Object_INVALID Schema_Object_NestingMode = 0
	Schema_Object_SINGLE  Schema_Object_NestingMode = 1
	Schema_Object_LIST    Schema_Object_NestingMode = 2
	Schema_Object_SET     Schema_Object_NestingMode = 3
	Schema_Object_MAP     Schema_Object_NestingMode = 4
)

// Enum value maps for Schema_Object_NestingMode.
var (
	Schema_Object_NestingMode_name = map[int32]string{
		0: "INVALID",
		1: "SINGLE",
		2: "LIST",
		3: "SET",
		4: "MAP",
	}
	Schema_Object_NestingMode_value = map[string]int32{
		"INVALID": 0,
		"SINGLE":  1,
		"LIST":    2,
		"SET":     3,
		"MAP":     4,
	}
)

func (x Schema_Object_NestingMode) Enum() *Schema_Object_NestingMode {
	p := new(Schema_Object_NestingMode)
	*p = x
	return p
}

func (x Schema_Object_NestingMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Schema_Object_NestingMode) Descriptor() protoreflect.EnumDescriptor {
	return file_tfplugin6_proto_enumTypes[3].Descriptor()
}

func (Schema_Object_NestingMode) Type() protoreflect.EnumType {
	return &file_tfplugin6_proto_enumTypes[3]
}

func (x Schema_Object_NestingMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Schema_Object_NestingMode.Descriptor instead.
func (Schema_Object_NestingMode) EnumDescriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{9, 3, 0}
}

// Reason is the reason for deferring the change.
type Deferred_Reason int32

const (
	// UNKNOWN is the default value, and should not be used.
	Deferred_UNKNOWN Deferred_Reason = 0
	// RESOURCE_CONFIG_UNKNOWN is used when the config is partially unknown and the real
	// values need to be known before the change can be planned.
	Deferred_RESOURCE_CONFIG_UNKNOWN Deferred_Reason = 1
	// PROVIDER_CONFIG_UNKNOWN is used when parts of the provider configuration
	// are unknown, e.g. the provider configuration is only known after the apply is done.
	Deferred_PROVIDER_CONFIG_UNKNOWN Deferred_Reason = 2
	// ABSENT_PREREQ is used when a hard dependency has not been satisfied.
	Deferred_ABSENT_PREREQ Deferred_Reason = 3
)

// Enum value maps for Deferred_Reason.
var (
	Deferred_Reason_name = map[int32]string{
		0: "UNKNOWN",
		1: "RESOURCE_CONFIG_UNKNOWN",
		2: "PROVIDER_CONFIG_UNKNOWN",
		3: "ABSENT_PREREQ",
	}
	Deferred_Reason_value = map[string]int32{
		"UNKNOWN":                 0,
		"RESOURCE_CONFIG_UNKNOWN": 1,
		"PROVIDER_CONFIG_UNKNOWN": 2,
		"ABSENT_PREREQ":           3,
	}
)

func (x Deferred_Reason) Enum() *Deferred_Reason {
	p := new(Deferred_Reason)
	*p = x
	return p
}

func (x Deferred_Reason) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Deferred_Reason) Descriptor() protoreflect.EnumDescriptor {
	return file_tfplugin6_proto_enumTypes[4].Descriptor()
}

func (Deferred_Reason) Type() protoreflect.EnumType {
	return &file_tfplugin6_proto_enumTypes[4]
}

func (x Deferred_Reason) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Deferred_Reason.Descriptor instead.
func (Deferred_Reason) EnumDescriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{13, 0}
}

// DynamicValue is an opaque encoding of terraform data, with the field name
// indicating the encoding scheme used.
type DynamicValue struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Msgpack       []byte                 `protobuf:"bytes,1,opt,name=msgpack,proto3" json:"msgpack,omitempty"`
	Json          []byte                 `protobuf:"bytes,2,opt,name=json,proto3" json:"json,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DynamicValue) Reset() {
	*x = DynamicValue{}
	mi := &file_tfplugin6_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DynamicValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DynamicValue) ProtoMessage() {}

func (x *DynamicValue) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DynamicValue.ProtoReflect.Descriptor instead.
func (*DynamicValue) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{0}
}

func (x *DynamicValue) GetMsgpack() []byte {
	if x != nil {
		return x.Msgpack
	}
	return nil
}

func (x *DynamicValue) GetJson() []byte {
	if x != nil {
		return x.Json
	}
	return nil
}

type Diagnostic struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Severity      Diagnostic_Severity    `protobuf:"varint,1,opt,name=severity,proto3,enum=tfplugin6.Diagnostic_Severity" json:"severity,omitempty"`
	Summary       string                 `protobuf:"bytes,2,opt,name=summary,proto3" json:"summary,omitempty"`
	Detail        string                 `protobuf:"bytes,3,opt,name=detail,proto3" json:"detail,omitempty"`
	Attribute     *AttributePath         `protobuf:"bytes,4,opt,name=attribute,proto3" json:"attribute,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Diagnostic) Reset() {
	*x = Diagnostic{}
	mi := &file_tfplugin6_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Diagnostic) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Diagnostic) ProtoMessage() {}

func (x *Diagnostic) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Diagnostic.ProtoReflect.Descriptor instead.
func (*Diagnostic) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{1}
}

func (x *Diagnostic) GetSeverity() Diagnostic_Severity {
	if x != nil {
		return x.Severity
	}
	return Diagnostic_INVALID
}

func (x *Diagnostic) GetSummary() string {
	if x != nil {
		return x.Summary
	}
	return ""
}

func (x *Diagnostic) GetDetail() string {
	if x != nil {
		return x.Detail
	}
	return ""
}

func (x *Diagnostic) GetAttribute() *AttributePath {
	if x != nil {
		return x.Attribute
	}
	return nil
}

type FunctionError struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	Text  string                 `protobuf:"bytes,1,opt,name=text,proto3" json:"text,omitempty"`
	// The optional function_argument records the index position of the
	// argument which caused the error.
	FunctionArgument *int64 `protobuf:"varint,2,opt,name=function_argument,json=functionArgument,proto3,oneof" json:"function_argument,omitempty"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *FunctionError) Reset() {
	*x = FunctionError{}
	mi := &file_tfplugin6_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FunctionError) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FunctionError) ProtoMessage() {}

func (x *FunctionError) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FunctionError.ProtoReflect.Descriptor instead.
func (*FunctionError) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{2}
}

func (x *FunctionError) GetText() string {
	if x != nil {
		return x.Text
	}
	return ""
}

func (x *FunctionError) GetFunctionArgument() int64 {
	if x != nil && x.FunctionArgument != nil {
		return *x.FunctionArgument
	}
	return 0
}

type AttributePath struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Steps         []*AttributePath_Step  `protobuf:"bytes,1,rep,name=steps,proto3" json:"steps,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AttributePath) Reset() {
	*x = AttributePath{}
	mi := &file_tfplugin6_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AttributePath) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AttributePath) ProtoMessage() {}

func (x *AttributePath) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AttributePath.ProtoReflect.Descriptor instead.
func (*AttributePath) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{3}
}

func (x *AttributePath) GetSteps() []*AttributePath_Step {
	if x != nil {
		return x.Steps
	}
	return nil
}

type StopProvider struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *StopProvider) Reset() {
	*x = StopProvider{}
	mi := &file_tfplugin6_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StopProvider) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StopProvider) ProtoMessage() {}

func (x *StopProvider) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StopProvider.ProtoReflect.Descriptor instead.
func (*StopProvider) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{4}
}

// RawState holds the stored state for a resource to be upgraded by the
// provider. It can be in one of two formats, the current json encoded format
// in bytes, or the legacy flatmap format as a map of strings.
type RawState struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Json          []byte                 `protobuf:"bytes,1,opt,name=json,proto3" json:"json,omitempty"`
	Flatmap       map[string]string      `protobuf:"bytes,2,rep,name=flatmap,proto3" json:"flatmap,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RawState) Reset() {
	*x = RawState{}
	mi := &file_tfplugin6_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RawState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RawState) ProtoMessage() {}

func (x *RawState) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RawState.ProtoReflect.Descriptor instead.
func (*RawState) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{5}
}

func (x *RawState) GetJson() []byte {
	if x != nil {
		return x.Json
	}
	return nil
}

func (x *RawState) GetFlatmap() map[string]string {
	if x != nil {
		return x.Flatmap
	}
	return nil
}

// ResourceIdentitySchema represents the structure and types of data used to identify
// a managed resource type. Effectively, resource identity is a versioned object
// that can be used to compare resources, whether already managed and/or being
// discovered.
type ResourceIdentitySchema struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// version is the identity version and separate from the Schema version.
	// Any time the structure or format of identity_attributes changes, this version
	// should be incremented. Versioning implicitly starts at 0 and by convention
	// should be incremented by 1 each change.
	//
	// When comparing identity_attributes data, differing versions should always be treated
	// as inequal.
	Version int64 `protobuf:"varint,1,opt,name=version,proto3" json:"version,omitempty"`
	// identity_attributes are the individual value definitions which define identity data
	// for a managed resource type. This information is used to decode DynamicValue of
	// identity data.
	//
	// These attributes are intended for permanent identity data and must be wholly
	// representative of all data necessary to compare two managed resource instances
	// with no other data. This generally should include account, endpoint, location,
	// and automatically generated identifiers. For some resources, this may include
	// configuration-based data, such as a required name which must be unique.
	IdentityAttributes []*ResourceIdentitySchema_IdentityAttribute `protobuf:"bytes,2,rep,name=identity_attributes,json=identityAttributes,proto3" json:"identity_attributes,omitempty"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *ResourceIdentitySchema) Reset() {
	*x = ResourceIdentitySchema{}
	mi := &file_tfplugin6_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ResourceIdentitySchema) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourceIdentitySchema) ProtoMessage() {}

func (x *ResourceIdentitySchema) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourceIdentitySchema.ProtoReflect.Descriptor instead.
func (*ResourceIdentitySchema) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{6}
}

func (x *ResourceIdentitySchema) GetVersion() int64 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *ResourceIdentitySchema) GetIdentityAttributes() []*ResourceIdentitySchema_IdentityAttribute {
	if x != nil {
		return x.IdentityAttributes
	}
	return nil
}

type ResourceIdentityData struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// identity_data is the resource identity data for the given definition. It should
	// be decoded using the identity schema.
	//
	// This data is considered permanent for the identity version and suitable for
	// longer-term storage.
	IdentityData  *DynamicValue `protobuf:"bytes,1,opt,name=identity_data,json=identityData,proto3" json:"identity_data,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ResourceIdentityData) Reset() {
	*x = ResourceIdentityData{}
	mi := &file_tfplugin6_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ResourceIdentityData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourceIdentityData) ProtoMessage() {}

func (x *ResourceIdentityData) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourceIdentityData.ProtoReflect.Descriptor instead.
func (*ResourceIdentityData) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{7}
}

func (x *ResourceIdentityData) GetIdentityData() *DynamicValue {
	if x != nil {
		return x.IdentityData
	}
	return nil
}

// ActionSchema defines the schema for an action that can be invoked by Terraform.
type ActionSchema struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Schema        *Schema                `protobuf:"bytes,1,opt,name=schema,proto3" json:"schema,omitempty"` // of the action itself
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ActionSchema) Reset() {
	*x = ActionSchema{}
	mi := &file_tfplugin6_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ActionSchema) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ActionSchema) ProtoMessage() {}

func (x *ActionSchema) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ActionSchema.ProtoReflect.Descriptor instead.
func (*ActionSchema) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{8}
}

func (x *ActionSchema) GetSchema() *Schema {
	if x != nil {
		return x.Schema
	}
	return nil
}

// Schema is the configuration schema for a Resource or Provider.
type Schema struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The version of the schema.
	// Schemas are versioned, so that providers can upgrade a saved resource
	// state when the schema is changed.
	Version int64 `protobuf:"varint,1,opt,name=version,proto3" json:"version,omitempty"`
	// Block is the top level configuration block for this schema.
	Block         *Schema_Block `protobuf:"bytes,2,opt,name=block,proto3" json:"block,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Schema) Reset() {
	*x = Schema{}
	mi := &file_tfplugin6_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Schema) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Schema) ProtoMessage() {}

func (x *Schema) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Schema.ProtoReflect.Descriptor instead.
func (*Schema) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{9}
}

func (x *Schema) GetVersion() int64 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *Schema) GetBlock() *Schema_Block {
	if x != nil {
		return x.Block
	}
	return nil
}

type Function struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// parameters is the ordered list of positional function parameters.
	Parameters []*Function_Parameter `protobuf:"bytes,1,rep,name=parameters,proto3" json:"parameters,omitempty"`
	// variadic_parameter is an optional final parameter which accepts
	// zero or more argument values, in which Terraform will send an
	// ordered list of the parameter type.
	VariadicParameter *Function_Parameter `protobuf:"bytes,2,opt,name=variadic_parameter,json=variadicParameter,proto3" json:"variadic_parameter,omitempty"`
	// Return is the function return parameter.
	Return *Function_Return `protobuf:"bytes,3,opt,name=return,proto3" json:"return,omitempty"`
	// summary is the human-readable shortened documentation for the function.
	Summary string `protobuf:"bytes,4,opt,name=summary,proto3" json:"summary,omitempty"`
	// description is human-readable documentation for the function.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// description_kind is the formatting of the description.
	DescriptionKind StringKind `protobuf:"varint,6,opt,name=description_kind,json=descriptionKind,proto3,enum=tfplugin6.StringKind" json:"description_kind,omitempty"`
	// deprecation_message is human-readable documentation if the
	// function is deprecated.
	DeprecationMessage string `protobuf:"bytes,7,opt,name=deprecation_message,json=deprecationMessage,proto3" json:"deprecation_message,omitempty"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *Function) Reset() {
	*x = Function{}
	mi := &file_tfplugin6_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Function) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Function) ProtoMessage() {}

func (x *Function) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Function.ProtoReflect.Descriptor instead.
func (*Function) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{10}
}

func (x *Function) GetParameters() []*Function_Parameter {
	if x != nil {
		return x.Parameters
	}
	return nil
}

func (x *Function) GetVariadicParameter() *Function_Parameter {
	if x != nil {
		return x.VariadicParameter
	}
	return nil
}

func (x *Function) GetReturn() *Function_Return {
	if x != nil {
		return x.Return
	}
	return nil
}

func (x *Function) GetSummary() string {
	if x != nil {
		return x.Summary
	}
	return ""
}

func (x *Function) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Function) GetDescriptionKind() StringKind {
	if x != nil {
		return x.DescriptionKind
	}
	return StringKind_PLAIN
}

func (x *Function) GetDeprecationMessage() string {
	if x != nil {
		return x.DeprecationMessage
	}
	return ""
}

// ServerCapabilities allows providers to communicate extra information
// regarding supported protocol features. This is used to indicate
// availability of certain forward-compatible changes which may be optional
// in a major protocol version, but cannot be tested for directly.
type ServerCapabilities struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The plan_destroy capability signals that a provider expects a call
	// to PlanResourceChange when a resource is going to be destroyed.
	PlanDestroy bool `protobuf:"varint,1,opt,name=plan_destroy,json=planDestroy,proto3" json:"plan_destroy,omitempty"`
	// The get_provider_schema_optional capability indicates that this
	// provider does not require calling GetProviderSchema to operate
	// normally, and the caller can used a cached copy of the provider's
	// schema.
	GetProviderSchemaOptional bool `protobuf:"varint,2,opt,name=get_provider_schema_optional,json=getProviderSchemaOptional,proto3" json:"get_provider_schema_optional,omitempty"`
	// The move_resource_state capability signals that a provider supports the
	// MoveResourceState RPC.
	MoveResourceState bool `protobuf:"varint,3,opt,name=move_resource_state,json=moveResourceState,proto3" json:"move_resource_state,omitempty"`
	// The generate_resource_config capability signals that a provider supports
	// GenerateResourceConfig.
	GenerateResourceConfig bool `protobuf:"varint,4,opt,name=generate_resource_config,json=generateResourceConfig,proto3" json:"generate_resource_config,omitempty"`
	unknownFields          protoimpl.UnknownFields
	sizeCache              protoimpl.SizeCache
}

func (x *ServerCapabilities) Reset() {
	*x = ServerCapabilities{}
	mi := &file_tfplugin6_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ServerCapabilities) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServerCapabilities) ProtoMessage() {}

func (x *ServerCapabilities) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServerCapabilities.ProtoReflect.Descriptor instead.
func (*ServerCapabilities) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{11}
}

func (x *ServerCapabilities) GetPlanDestroy() bool {
	if x != nil {
		return x.PlanDestroy
	}
	return false
}

func (x *ServerCapabilities) GetGetProviderSchemaOptional() bool {
	if x != nil {
		return x.GetProviderSchemaOptional
	}
	return false
}

func (x *ServerCapabilities) GetMoveResourceState() bool {
	if x != nil {
		return x.MoveResourceState
	}
	return false
}

func (x *ServerCapabilities) GetGenerateResourceConfig() bool {
	if x != nil {
		return x.GenerateResourceConfig
	}
	return false
}

// ClientCapabilities allows Terraform to publish information regarding
// supported protocol features. This is used to indicate availability of
// certain forward-compatible changes which may be optional in a major
// protocol version, but cannot be tested for directly.
type ClientCapabilities struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The deferral_allowed capability signals that the client is able to
	// handle deferred responses from the provider.
	DeferralAllowed bool `protobuf:"varint,1,opt,name=deferral_allowed,json=deferralAllowed,proto3" json:"deferral_allowed,omitempty"`
	// The write_only_attributes_allowed capability signals that the client
	// is able to handle write_only attributes for managed resources.
	WriteOnlyAttributesAllowed bool `protobuf:"varint,2,opt,name=write_only_attributes_allowed,json=writeOnlyAttributesAllowed,proto3" json:"write_only_attributes_allowed,omitempty"`
	unknownFields              protoimpl.UnknownFields
	sizeCache                  protoimpl.SizeCache
}

func (x *ClientCapabilities) Reset() {
	*x = ClientCapabilities{}
	mi := &file_tfplugin6_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ClientCapabilities) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClientCapabilities) ProtoMessage() {}

func (x *ClientCapabilities) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClientCapabilities.ProtoReflect.Descriptor instead.
func (*ClientCapabilities) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{12}
}

func (x *ClientCapabilities) GetDeferralAllowed() bool {
	if x != nil {
		return x.DeferralAllowed
	}
	return false
}

func (x *ClientCapabilities) GetWriteOnlyAttributesAllowed() bool {
	if x != nil {
		return x.WriteOnlyAttributesAllowed
	}
	return false
}

// Deferred is a message that indicates that change is deferred for a reason.
type Deferred struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// reason is the reason for deferring the change.
	Reason        Deferred_Reason `protobuf:"varint,1,opt,name=reason,proto3,enum=tfplugin6.Deferred_Reason" json:"reason,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Deferred) Reset() {
	*x = Deferred{}
	mi := &file_tfplugin6_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Deferred) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Deferred) ProtoMessage() {}

func (x *Deferred) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Deferred.ProtoReflect.Descriptor instead.
func (*Deferred) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{13}
}

func (x *Deferred) GetReason() Deferred_Reason {
	if x != nil {
		return x.Reason
	}
	return Deferred_UNKNOWN
}

type GetMetadata struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetMetadata) Reset() {
	*x = GetMetadata{}
	mi := &file_tfplugin6_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetMetadata) ProtoMessage() {}

func (x *GetMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetMetadata.ProtoReflect.Descriptor instead.
func (*GetMetadata) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{14}
}

type GetProviderSchema struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetProviderSchema) Reset() {
	*x = GetProviderSchema{}
	mi := &file_tfplugin6_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetProviderSchema) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetProviderSchema) ProtoMessage() {}

func (x *GetProviderSchema) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetProviderSchema.ProtoReflect.Descriptor instead.
func (*GetProviderSchema) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{15}
}

type ValidateProviderConfig struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ValidateProviderConfig) Reset() {
	*x = ValidateProviderConfig{}
	mi := &file_tfplugin6_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ValidateProviderConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValidateProviderConfig) ProtoMessage() {}

func (x *ValidateProviderConfig) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValidateProviderConfig.ProtoReflect.Descriptor instead.
func (*ValidateProviderConfig) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{16}
}

type UpgradeResourceState struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UpgradeResourceState) Reset() {
	*x = UpgradeResourceState{}
	mi := &file_tfplugin6_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpgradeResourceState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpgradeResourceState) ProtoMessage() {}

func (x *UpgradeResourceState) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpgradeResourceState.ProtoReflect.Descriptor instead.
func (*UpgradeResourceState) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{17}
}

type GetResourceIdentitySchemas struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetResourceIdentitySchemas) Reset() {
	*x = GetResourceIdentitySchemas{}
	mi := &file_tfplugin6_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetResourceIdentitySchemas) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetResourceIdentitySchemas) ProtoMessage() {}

func (x *GetResourceIdentitySchemas) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetResourceIdentitySchemas.ProtoReflect.Descriptor instead.
func (*GetResourceIdentitySchemas) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{18}
}

type UpgradeResourceIdentity struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UpgradeResourceIdentity) Reset() {
	*x = UpgradeResourceIdentity{}
	mi := &file_tfplugin6_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpgradeResourceIdentity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpgradeResourceIdentity) ProtoMessage() {}

func (x *UpgradeResourceIdentity) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpgradeResourceIdentity.ProtoReflect.Descriptor instead.
func (*UpgradeResourceIdentity) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{19}
}

type ValidateResourceConfig struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ValidateResourceConfig) Reset() {
	*x = ValidateResourceConfig{}
	mi := &file_tfplugin6_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ValidateResourceConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValidateResourceConfig) ProtoMessage() {}

func (x *ValidateResourceConfig) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValidateResourceConfig.ProtoReflect.Descriptor instead.
func (*ValidateResourceConfig) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{20}
}

type ValidateDataResourceConfig struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ValidateDataResourceConfig) Reset() {
	*x = ValidateDataResourceConfig{}
	mi := &file_tfplugin6_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ValidateDataResourceConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValidateDataResourceConfig) ProtoMessage() {}

func (x *ValidateDataResourceConfig) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValidateDataResourceConfig.ProtoReflect.Descriptor instead.
func (*ValidateDataResourceConfig) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{21}
}

type ValidateEphemeralResourceConfig struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ValidateEphemeralResourceConfig) Reset() {
	*x = ValidateEphemeralResourceConfig{}
	mi := &file_tfplugin6_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ValidateEphemeralResourceConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValidateEphemeralResourceConfig) ProtoMessage() {}

func (x *ValidateEphemeralResourceConfig) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValidateEphemeralResourceConfig.ProtoReflect.Descriptor instead.
func (*ValidateEphemeralResourceConfig) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{22}
}

type ConfigureProvider struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ConfigureProvider) Reset() {
	*x = ConfigureProvider{}
	mi := &file_tfplugin6_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ConfigureProvider) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConfigureProvider) ProtoMessage() {}

func (x *ConfigureProvider) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConfigureProvider.ProtoReflect.Descriptor instead.
func (*ConfigureProvider) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{23}
}

type ReadResource struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ReadResource) Reset() {
	*x = ReadResource{}
	mi := &file_tfplugin6_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReadResource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadResource) ProtoMessage() {}

func (x *ReadResource) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadResource.ProtoReflect.Descriptor instead.
func (*ReadResource) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{24}
}

type PlanResourceChange struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PlanResourceChange) Reset() {
	*x = PlanResourceChange{}
	mi := &file_tfplugin6_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PlanResourceChange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlanResourceChange) ProtoMessage() {}

func (x *PlanResourceChange) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlanResourceChange.ProtoReflect.Descriptor instead.
func (*PlanResourceChange) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{25}
}

type ApplyResourceChange struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ApplyResourceChange) Reset() {
	*x = ApplyResourceChange{}
	mi := &file_tfplugin6_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ApplyResourceChange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplyResourceChange) ProtoMessage() {}

func (x *ApplyResourceChange) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplyResourceChange.ProtoReflect.Descriptor instead.
func (*ApplyResourceChange) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{26}
}

type ImportResourceState struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ImportResourceState) Reset() {
	*x = ImportResourceState{}
	mi := &file_tfplugin6_proto_msgTypes[27]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImportResourceState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportResourceState) ProtoMessage() {}

func (x *ImportResourceState) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[27]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportResourceState.ProtoReflect.Descriptor instead.
func (*ImportResourceState) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{27}
}

type GenerateResourceConfig struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GenerateResourceConfig) Reset() {
	*x = GenerateResourceConfig{}
	mi := &file_tfplugin6_proto_msgTypes[28]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GenerateResourceConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateResourceConfig) ProtoMessage() {}

func (x *GenerateResourceConfig) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[28]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateResourceConfig.ProtoReflect.Descriptor instead.
func (*GenerateResourceConfig) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{28}
}

type MoveResourceState struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *MoveResourceState) Reset() {
	*x = MoveResourceState{}
	mi := &file_tfplugin6_proto_msgTypes[29]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MoveResourceState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MoveResourceState) ProtoMessage() {}

func (x *MoveResourceState) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[29]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MoveResourceState.ProtoReflect.Descriptor instead.
func (*MoveResourceState) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{29}
}

type ReadDataSource struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ReadDataSource) Reset() {
	*x = ReadDataSource{}
	mi := &file_tfplugin6_proto_msgTypes[30]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReadDataSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadDataSource) ProtoMessage() {}

func (x *ReadDataSource) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[30]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadDataSource.ProtoReflect.Descriptor instead.
func (*ReadDataSource) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{30}
}

type OpenEphemeralResource struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OpenEphemeralResource) Reset() {
	*x = OpenEphemeralResource{}
	mi := &file_tfplugin6_proto_msgTypes[31]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OpenEphemeralResource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OpenEphemeralResource) ProtoMessage() {}

func (x *OpenEphemeralResource) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[31]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OpenEphemeralResource.ProtoReflect.Descriptor instead.
func (*OpenEphemeralResource) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{31}
}

type RenewEphemeralResource struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RenewEphemeralResource) Reset() {
	*x = RenewEphemeralResource{}
	mi := &file_tfplugin6_proto_msgTypes[32]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RenewEphemeralResource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RenewEphemeralResource) ProtoMessage() {}

func (x *RenewEphemeralResource) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[32]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RenewEphemeralResource.ProtoReflect.Descriptor instead.
func (*RenewEphemeralResource) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{32}
}

type CloseEphemeralResource struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CloseEphemeralResource) Reset() {
	*x = CloseEphemeralResource{}
	mi := &file_tfplugin6_proto_msgTypes[33]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CloseEphemeralResource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloseEphemeralResource) ProtoMessage() {}

func (x *CloseEphemeralResource) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[33]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloseEphemeralResource.ProtoReflect.Descriptor instead.
func (*CloseEphemeralResource) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{33}
}

type GetFunctions struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetFunctions) Reset() {
	*x = GetFunctions{}
	mi := &file_tfplugin6_proto_msgTypes[34]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetFunctions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetFunctions) ProtoMessage() {}

func (x *GetFunctions) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[34]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetFunctions.ProtoReflect.Descriptor instead.
func (*GetFunctions) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{34}
}

type CallFunction struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CallFunction) Reset() {
	*x = CallFunction{}
	mi := &file_tfplugin6_proto_msgTypes[35]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CallFunction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CallFunction) ProtoMessage() {}

func (x *CallFunction) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[35]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CallFunction.ProtoReflect.Descriptor instead.
func (*CallFunction) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{35}
}

type ListResource struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListResource) Reset() {
	*x = ListResource{}
	mi := &file_tfplugin6_proto_msgTypes[36]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListResource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListResource) ProtoMessage() {}

func (x *ListResource) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[36]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListResource.ProtoReflect.Descriptor instead.
func (*ListResource) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{36}
}

type ValidateListResourceConfig struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ValidateListResourceConfig) Reset() {
	*x = ValidateListResourceConfig{}
	mi := &file_tfplugin6_proto_msgTypes[37]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ValidateListResourceConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValidateListResourceConfig) ProtoMessage() {}

func (x *ValidateListResourceConfig) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[37]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValidateListResourceConfig.ProtoReflect.Descriptor instead.
func (*ValidateListResourceConfig) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{37}
}

type ValidateStateStore struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ValidateStateStore) Reset() {
	*x = ValidateStateStore{}
	mi := &file_tfplugin6_proto_msgTypes[38]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ValidateStateStore) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValidateStateStore) ProtoMessage() {}

func (x *ValidateStateStore) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[38]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValidateStateStore.ProtoReflect.Descriptor instead.
func (*ValidateStateStore) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{38}
}

type ConfigureStateStore struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ConfigureStateStore) Reset() {
	*x = ConfigureStateStore{}
	mi := &file_tfplugin6_proto_msgTypes[39]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ConfigureStateStore) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConfigureStateStore) ProtoMessage() {}

func (x *ConfigureStateStore) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[39]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConfigureStateStore.ProtoReflect.Descriptor instead.
func (*ConfigureStateStore) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{39}
}

type GetStates struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetStates) Reset() {
	*x = GetStates{}
	mi := &file_tfplugin6_proto_msgTypes[40]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetStates) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetStates) ProtoMessage() {}

func (x *GetStates) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[40]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetStates.ProtoReflect.Descriptor instead.
func (*GetStates) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{40}
}

type DeleteState struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DeleteState) Reset() {
	*x = DeleteState{}
	mi := &file_tfplugin6_proto_msgTypes[41]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteState) ProtoMessage() {}

func (x *DeleteState) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[41]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteState.ProtoReflect.Descriptor instead.
func (*DeleteState) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{41}
}

type PlanAction struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PlanAction) Reset() {
	*x = PlanAction{}
	mi := &file_tfplugin6_proto_msgTypes[42]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PlanAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlanAction) ProtoMessage() {}

func (x *PlanAction) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[42]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlanAction.ProtoReflect.Descriptor instead.
func (*PlanAction) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{42}
}

type InvokeAction struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *InvokeAction) Reset() {
	*x = InvokeAction{}
	mi := &file_tfplugin6_proto_msgTypes[43]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *InvokeAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InvokeAction) ProtoMessage() {}

func (x *InvokeAction) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[43]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InvokeAction.ProtoReflect.Descriptor instead.
func (*InvokeAction) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{43}
}

type ValidateActionConfig struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ValidateActionConfig) Reset() {
	*x = ValidateActionConfig{}
	mi := &file_tfplugin6_proto_msgTypes[44]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ValidateActionConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValidateActionConfig) ProtoMessage() {}

func (x *ValidateActionConfig) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[44]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValidateActionConfig.ProtoReflect.Descriptor instead.
func (*ValidateActionConfig) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{44}
}

type AttributePath_Step struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Types that are valid to be assigned to Selector:
	//
	//	*AttributePath_Step_AttributeName
	//	*AttributePath_Step_ElementKeyString
	//	*AttributePath_Step_ElementKeyInt
	Selector      isAttributePath_Step_Selector `protobuf_oneof:"selector"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AttributePath_Step) Reset() {
	*x = AttributePath_Step{}
	mi := &file_tfplugin6_proto_msgTypes[45]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AttributePath_Step) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AttributePath_Step) ProtoMessage() {}

func (x *AttributePath_Step) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[45]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AttributePath_Step.ProtoReflect.Descriptor instead.
func (*AttributePath_Step) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{3, 0}
}

func (x *AttributePath_Step) GetSelector() isAttributePath_Step_Selector {
	if x != nil {
		return x.Selector
	}
	return nil
}

func (x *AttributePath_Step) GetAttributeName() string {
	if x != nil {
		if x, ok := x.Selector.(*AttributePath_Step_AttributeName); ok {
			return x.AttributeName
		}
	}
	return ""
}

func (x *AttributePath_Step) GetElementKeyString() string {
	if x != nil {
		if x, ok := x.Selector.(*AttributePath_Step_ElementKeyString); ok {
			return x.ElementKeyString
		}
	}
	return ""
}

func (x *AttributePath_Step) GetElementKeyInt() int64 {
	if x != nil {
		if x, ok := x.Selector.(*AttributePath_Step_ElementKeyInt); ok {
			return x.ElementKeyInt
		}
	}
	return 0
}

type isAttributePath_Step_Selector interface {
	isAttributePath_Step_Selector()
}

type AttributePath_Step_AttributeName struct {
	// Set "attribute_name" to represent looking up an attribute
	// in the current object value.
	AttributeName string `protobuf:"bytes,1,opt,name=attribute_name,json=attributeName,proto3,oneof"`
}

type AttributePath_Step_ElementKeyString struct {
	// Set "element_key_*" to represent looking up an element in
	// an indexable collection type.
	ElementKeyString string `protobuf:"bytes,2,opt,name=element_key_string,json=elementKeyString,proto3,oneof"`
}

type AttributePath_Step_ElementKeyInt struct {
	ElementKeyInt int64 `protobuf:"varint,3,opt,name=element_key_int,json=elementKeyInt,proto3,oneof"`
}

func (*AttributePath_Step_AttributeName) isAttributePath_Step_Selector() {}

func (*AttributePath_Step_ElementKeyString) isAttributePath_Step_Selector() {}

func (*AttributePath_Step_ElementKeyInt) isAttributePath_Step_Selector() {}

type StopProvider_Request struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *StopProvider_Request) Reset() {
	*x = StopProvider_Request{}
	mi := &file_tfplugin6_proto_msgTypes[46]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StopProvider_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StopProvider_Request) ProtoMessage() {}

func (x *StopProvider_Request) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[46]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StopProvider_Request.ProtoReflect.Descriptor instead.
func (*StopProvider_Request) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{4, 0}
}

type StopProvider_Response struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Error         string                 `protobuf:"bytes,1,opt,name=Error,proto3" json:"Error,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *StopProvider_Response) Reset() {
	*x = StopProvider_Response{}
	mi := &file_tfplugin6_proto_msgTypes[47]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StopProvider_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StopProvider_Response) ProtoMessage() {}

func (x *StopProvider_Response) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[47]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StopProvider_Response.ProtoReflect.Descriptor instead.
func (*StopProvider_Response) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{4, 1}
}

func (x *StopProvider_Response) GetError() string {
	if x != nil {
		return x.Error
	}
	return ""
}

// IdentityAttribute represents one value of data within resource identity. These
// are always used in resource identity comparisons.
type ResourceIdentitySchema_IdentityAttribute struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// name is the identity attribute name
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// type is the identity attribute type
	Type []byte `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
	// required_for_import when enabled signifies that this attribute must be
	// defined for ImportResourceState to complete successfully
	RequiredForImport bool `protobuf:"varint,3,opt,name=required_for_import,json=requiredForImport,proto3" json:"required_for_import,omitempty"`
	// optional_for_import when enabled signifies that this attribute is not
	// required for ImportResourceState, because it can be supplied by the
	// provider. It is still possible to supply this attribute during import.
	OptionalForImport bool `protobuf:"varint,4,opt,name=optional_for_import,json=optionalForImport,proto3" json:"optional_for_import,omitempty"`
	// description is a human-readable description of the attribute in Markdown
	Description   string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ResourceIdentitySchema_IdentityAttribute) Reset() {
	*x = ResourceIdentitySchema_IdentityAttribute{}
	mi := &file_tfplugin6_proto_msgTypes[49]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ResourceIdentitySchema_IdentityAttribute) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourceIdentitySchema_IdentityAttribute) ProtoMessage() {}

func (x *ResourceIdentitySchema_IdentityAttribute) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[49]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourceIdentitySchema_IdentityAttribute.ProtoReflect.Descriptor instead.
func (*ResourceIdentitySchema_IdentityAttribute) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{6, 0}
}

func (x *ResourceIdentitySchema_IdentityAttribute) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ResourceIdentitySchema_IdentityAttribute) GetType() []byte {
	if x != nil {
		return x.Type
	}
	return nil
}

func (x *ResourceIdentitySchema_IdentityAttribute) GetRequiredForImport() bool {
	if x != nil {
		return x.RequiredForImport
	}
	return false
}

func (x *ResourceIdentitySchema_IdentityAttribute) GetOptionalForImport() bool {
	if x != nil {
		return x.OptionalForImport
	}
	return false
}

func (x *ResourceIdentitySchema_IdentityAttribute) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

type Schema_Block struct {
	state           protoimpl.MessageState `protogen:"open.v1"`
	Version         int64                  `protobuf:"varint,1,opt,name=version,proto3" json:"version,omitempty"`
	Attributes      []*Schema_Attribute    `protobuf:"bytes,2,rep,name=attributes,proto3" json:"attributes,omitempty"`
	BlockTypes      []*Schema_NestedBlock  `protobuf:"bytes,3,rep,name=block_types,json=blockTypes,proto3" json:"block_types,omitempty"`
	Description     string                 `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	DescriptionKind StringKind             `protobuf:"varint,5,opt,name=description_kind,json=descriptionKind,proto3,enum=tfplugin6.StringKind" json:"description_kind,omitempty"`
	Deprecated      bool                   `protobuf:"varint,6,opt,name=deprecated,proto3" json:"deprecated,omitempty"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *Schema_Block) Reset() {
	*x = Schema_Block{}
	mi := &file_tfplugin6_proto_msgTypes[50]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Schema_Block) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Schema_Block) ProtoMessage() {}

func (x *Schema_Block) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[50]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Schema_Block.ProtoReflect.Descriptor instead.
func (*Schema_Block) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{9, 0}
}

func (x *Schema_Block) GetVersion() int64 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *Schema_Block) GetAttributes() []*Schema_Attribute {
	if x != nil {
		return x.Attributes
	}
	return nil
}

func (x *Schema_Block) GetBlockTypes() []*Schema_NestedBlock {
	if x != nil {
		return x.BlockTypes
	}
	return nil
}

func (x *Schema_Block) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Schema_Block) GetDescriptionKind() StringKind {
	if x != nil {
		return x.DescriptionKind
	}
	return StringKind_PLAIN
}

func (x *Schema_Block) GetDeprecated() bool {
	if x != nil {
		return x.Deprecated
	}
	return false
}

type Schema_Attribute struct {
	state           protoimpl.MessageState `protogen:"open.v1"`
	Name            string                 `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Type            []byte                 `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
	NestedType      *Schema_Object         `protobuf:"bytes,10,opt,name=nested_type,json=nestedType,proto3" json:"nested_type,omitempty"`
	Description     string                 `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	Required        bool                   `protobuf:"varint,4,opt,name=required,proto3" json:"required,omitempty"`
	Optional        bool                   `protobuf:"varint,5,opt,name=optional,proto3" json:"optional,omitempty"`
	Computed        bool                   `protobuf:"varint,6,opt,name=computed,proto3" json:"computed,omitempty"`
	Sensitive       bool                   `protobuf:"varint,7,opt,name=sensitive,proto3" json:"sensitive,omitempty"`
	DescriptionKind StringKind             `protobuf:"varint,8,opt,name=description_kind,json=descriptionKind,proto3,enum=tfplugin6.StringKind" json:"description_kind,omitempty"`
	Deprecated      bool                   `protobuf:"varint,9,opt,name=deprecated,proto3" json:"deprecated,omitempty"`
	WriteOnly       bool                   `protobuf:"varint,11,opt,name=write_only,json=writeOnly,proto3" json:"write_only,omitempty"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *Schema_Attribute) Reset() {
	*x = Schema_Attribute{}
	mi := &file_tfplugin6_proto_msgTypes[51]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Schema_Attribute) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Schema_Attribute) ProtoMessage() {}

func (x *Schema_Attribute) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[51]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Schema_Attribute.ProtoReflect.Descriptor instead.
func (*Schema_Attribute) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{9, 1}
}

func (x *Schema_Attribute) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Schema_Attribute) GetType() []byte {
	if x != nil {
		return x.Type
	}
	return nil
}

func (x *Schema_Attribute) GetNestedType() *Schema_Object {
	if x != nil {
		return x.NestedType
	}
	return nil
}

func (x *Schema_Attribute) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Schema_Attribute) GetRequired() bool {
	if x != nil {
		return x.Required
	}
	return false
}

func (x *Schema_Attribute) GetOptional() bool {
	if x != nil {
		return x.Optional
	}
	return false
}

func (x *Schema_Attribute) GetComputed() bool {
	if x != nil {
		return x.Computed
	}
	return false
}

func (x *Schema_Attribute) GetSensitive() bool {
	if x != nil {
		return x.Sensitive
	}
	return false
}

func (x *Schema_Attribute) GetDescriptionKind() StringKind {
	if x != nil {
		return x.DescriptionKind
	}
	return StringKind_PLAIN
}

func (x *Schema_Attribute) GetDeprecated() bool {
	if x != nil {
		return x.Deprecated
	}
	return false
}

func (x *Schema_Attribute) GetWriteOnly() bool {
	if x != nil {
		return x.WriteOnly
	}
	return false
}

type Schema_NestedBlock struct {
	state         protoimpl.MessageState         `protogen:"open.v1"`
	TypeName      string                         `protobuf:"bytes,1,opt,name=type_name,json=typeName,proto3" json:"type_name,omitempty"`
	Block         *Schema_Block                  `protobuf:"bytes,2,opt,name=block,proto3" json:"block,omitempty"`
	Nesting       Schema_NestedBlock_NestingMode `protobuf:"varint,3,opt,name=nesting,proto3,enum=tfplugin6.Schema_NestedBlock_NestingMode" json:"nesting,omitempty"`
	MinItems      int64                          `protobuf:"varint,4,opt,name=min_items,json=minItems,proto3" json:"min_items,omitempty"`
	MaxItems      int64                          `protobuf:"varint,5,opt,name=max_items,json=maxItems,proto3" json:"max_items,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Schema_NestedBlock) Reset() {
	*x = Schema_NestedBlock{}
	mi := &file_tfplugin6_proto_msgTypes[52]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Schema_NestedBlock) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Schema_NestedBlock) ProtoMessage() {}

func (x *Schema_NestedBlock) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[52]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Schema_NestedBlock.ProtoReflect.Descriptor instead.
func (*Schema_NestedBlock) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{9, 2}
}

func (x *Schema_NestedBlock) GetTypeName() string {
	if x != nil {
		return x.TypeName
	}
	return ""
}

func (x *Schema_NestedBlock) GetBlock() *Schema_Block {
	if x != nil {
		return x.Block
	}
	return nil
}

func (x *Schema_NestedBlock) GetNesting() Schema_NestedBlock_NestingMode {
	if x != nil {
		return x.Nesting
	}
	return Schema_NestedBlock_INVALID
}

func (x *Schema_NestedBlock) GetMinItems() int64 {
	if x != nil {
		return x.MinItems
	}
	return 0
}

func (x *Schema_NestedBlock) GetMaxItems() int64 {
	if x != nil {
		return x.MaxItems
	}
	return 0
}

type Schema_Object struct {
	state      protoimpl.MessageState    `protogen:"open.v1"`
	Attributes []*Schema_Attribute       `protobuf:"bytes,1,rep,name=attributes,proto3" json:"attributes,omitempty"`
	Nesting    Schema_Object_NestingMode `protobuf:"varint,3,opt,name=nesting,proto3,enum=tfplugin6.Schema_Object_NestingMode" json:"nesting,omitempty"`
	// MinItems and MaxItems were never used in the protocol, and have no
	// effect on validation.
	//
	// Deprecated: Marked as deprecated in tfplugin6.proto.
	MinItems int64 `protobuf:"varint,4,opt,name=min_items,json=minItems,proto3" json:"min_items,omitempty"`
	// Deprecated: Marked as deprecated in tfplugin6.proto.
	MaxItems      int64 `protobuf:"varint,5,opt,name=max_items,json=maxItems,proto3" json:"max_items,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Schema_Object) Reset() {
	*x = Schema_Object{}
	mi := &file_tfplugin6_proto_msgTypes[53]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Schema_Object) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Schema_Object) ProtoMessage() {}

func (x *Schema_Object) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[53]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Schema_Object.ProtoReflect.Descriptor instead.
func (*Schema_Object) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{9, 3}
}

func (x *Schema_Object) GetAttributes() []*Schema_Attribute {
	if x != nil {
		return x.Attributes
	}
	return nil
}

func (x *Schema_Object) GetNesting() Schema_Object_NestingMode {
	if x != nil {
		return x.Nesting
	}
	return Schema_Object_INVALID
}

// Deprecated: Marked as deprecated in tfplugin6.proto.
func (x *Schema_Object) GetMinItems() int64 {
	if x != nil {
		return x.MinItems
	}
	return 0
}

// Deprecated: Marked as deprecated in tfplugin6.proto.
func (x *Schema_Object) GetMaxItems() int64 {
	if x != nil {
		return x.MaxItems
	}
	return 0
}

type Function_Parameter struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// name is the human-readable display name for the parameter.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// type is the type constraint for the parameter.
	Type []byte `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
	// allow_null_value when enabled denotes that a null argument value can
	// be passed to the provider. When disabled, Terraform returns an error
	// if the argument value is null.
	AllowNullValue bool `protobuf:"varint,3,opt,name=allow_null_value,json=allowNullValue,proto3" json:"allow_null_value,omitempty"`
	// allow_unknown_values when enabled denotes that only wholly known
	// argument values will be passed to the provider. When disabled,
	// Terraform skips the function call entirely and assumes an unknown
	// value result from the function.
	AllowUnknownValues bool `protobuf:"varint,4,opt,name=allow_unknown_values,json=allowUnknownValues,proto3" json:"allow_unknown_values,omitempty"`
	// description is human-readable documentation for the parameter.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// description_kind is the formatting of the description.
	DescriptionKind StringKind `protobuf:"varint,6,opt,name=description_kind,json=descriptionKind,proto3,enum=tfplugin6.StringKind" json:"description_kind,omitempty"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *Function_Parameter) Reset() {
	*x = Function_Parameter{}
	mi := &file_tfplugin6_proto_msgTypes[54]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Function_Parameter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Function_Parameter) ProtoMessage() {}

func (x *Function_Parameter) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[54]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Function_Parameter.ProtoReflect.Descriptor instead.
func (*Function_Parameter) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{10, 0}
}

func (x *Function_Parameter) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Function_Parameter) GetType() []byte {
	if x != nil {
		return x.Type
	}
	return nil
}

func (x *Function_Parameter) GetAllowNullValue() bool {
	if x != nil {
		return x.AllowNullValue
	}
	return false
}

func (x *Function_Parameter) GetAllowUnknownValues() bool {
	if x != nil {
		return x.AllowUnknownValues
	}
	return false
}

func (x *Function_Parameter) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Function_Parameter) GetDescriptionKind() StringKind {
	if x != nil {
		return x.DescriptionKind
	}
	return StringKind_PLAIN
}

type Function_Return struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// type is the type constraint for the function result.
	Type          []byte `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Function_Return) Reset() {
	*x = Function_Return{}
	mi := &file_tfplugin6_proto_msgTypes[55]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Function_Return) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Function_Return) ProtoMessage() {}

func (x *Function_Return) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[55]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Function_Return.ProtoReflect.Descriptor instead.
func (*Function_Return) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{10, 1}
}

func (x *Function_Return) GetType() []byte {
	if x != nil {
		return x.Type
	}
	return nil
}

type GetMetadata_Request struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetMetadata_Request) Reset() {
	*x = GetMetadata_Request{}
	mi := &file_tfplugin6_proto_msgTypes[56]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetMetadata_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetMetadata_Request) ProtoMessage() {}

func (x *GetMetadata_Request) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[56]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetMetadata_Request.ProtoReflect.Descriptor instead.
func (*GetMetadata_Request) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{14, 0}
}

type GetMetadata_Response struct {
	state              protoimpl.MessageState            `protogen:"open.v1"`
	ServerCapabilities *ServerCapabilities               `protobuf:"bytes,1,opt,name=server_capabilities,json=serverCapabilities,proto3" json:"server_capabilities,omitempty"`
	Diagnostics        []*Diagnostic                     `protobuf:"bytes,2,rep,name=diagnostics,proto3" json:"diagnostics,omitempty"`
	DataSources        []*GetMetadata_DataSourceMetadata `protobuf:"bytes,3,rep,name=data_sources,json=dataSources,proto3" json:"data_sources,omitempty"`
	Resources          []*GetMetadata_ResourceMetadata   `protobuf:"bytes,4,rep,name=resources,proto3" json:"resources,omitempty"`
	// functions returns metadata for any functions.
	Functions          []*GetMetadata_FunctionMetadata     `protobuf:"bytes,5,rep,name=functions,proto3" json:"functions,omitempty"`
	EphemeralResources []*GetMetadata_EphemeralMetadata    `protobuf:"bytes,6,rep,name=ephemeral_resources,json=ephemeralResources,proto3" json:"ephemeral_resources,omitempty"`
	ListResources      []*GetMetadata_ListResourceMetadata `protobuf:"bytes,7,rep,name=list_resources,json=listResources,proto3" json:"list_resources,omitempty"`
	StateStores        []*GetMetadata_StateStoreMetadata   `protobuf:"bytes,8,rep,name=state_stores,json=stateStores,proto3" json:"state_stores,omitempty"`
	Actions            []*GetMetadata_ActionMetadata       `protobuf:"bytes,9,rep,name=actions,proto3" json:"actions,omitempty"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *GetMetadata_Response) Reset() {
	*x = GetMetadata_Response{}
	mi := &file_tfplugin6_proto_msgTypes[57]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetMetadata_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetMetadata_Response) ProtoMessage() {}

func (x *GetMetadata_Response) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[57]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetMetadata_Response.ProtoReflect.Descriptor instead.
func (*GetMetadata_Response) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{14, 1}
}

func (x *GetMetadata_Response) GetServerCapabilities() *ServerCapabilities {
	if x != nil {
		return x.ServerCapabilities
	}
	return nil
}

func (x *GetMetadata_Response) GetDiagnostics() []*Diagnostic {
	if x != nil {
		return x.Diagnostics
	}
	return nil
}

func (x *GetMetadata_Response) GetDataSources() []*GetMetadata_DataSourceMetadata {
	if x != nil {
		return x.DataSources
	}
	return nil
}

func (x *GetMetadata_Response) GetResources() []*GetMetadata_ResourceMetadata {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *GetMetadata_Response) GetFunctions() []*GetMetadata_FunctionMetadata {
	if x != nil {
		return x.Functions
	}
	return nil
}

func (x *GetMetadata_Response) GetEphemeralResources() []*GetMetadata_EphemeralMetadata {
	if x != nil {
		return x.EphemeralResources
	}
	return nil
}

func (x *GetMetadata_Response) GetListResources() []*GetMetadata_ListResourceMetadata {
	if x != nil {
		return x.ListResources
	}
	return nil
}

func (x *GetMetadata_Response) GetStateStores() []*GetMetadata_StateStoreMetadata {
	if x != nil {
		return x.StateStores
	}
	return nil
}

func (x *GetMetadata_Response) GetActions() []*GetMetadata_ActionMetadata {
	if x != nil {
		return x.Actions
	}
	return nil
}

type GetMetadata_EphemeralMetadata struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	TypeName      string                 `protobuf:"bytes,1,opt,name=type_name,json=typeName,proto3" json:"type_name,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetMetadata_EphemeralMetadata) Reset() {
	*x = GetMetadata_EphemeralMetadata{}
	mi := &file_tfplugin6_proto_msgTypes[58]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetMetadata_EphemeralMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetMetadata_EphemeralMetadata) ProtoMessage() {}

func (x *GetMetadata_EphemeralMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[58]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetMetadata_EphemeralMetadata.ProtoReflect.Descriptor instead.
func (*GetMetadata_EphemeralMetadata) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{14, 2}
}

func (x *GetMetadata_EphemeralMetadata) GetTypeName() string {
	if x != nil {
		return x.TypeName
	}
	return ""
}

type GetMetadata_FunctionMetadata struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// name is the function name.
	Name          string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetMetadata_FunctionMetadata) Reset() {
	*x = GetMetadata_FunctionMetadata{}
	mi := &file_tfplugin6_proto_msgTypes[59]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetMetadata_FunctionMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetMetadata_FunctionMetadata) ProtoMessage() {}

func (x *GetMetadata_FunctionMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[59]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetMetadata_FunctionMetadata.ProtoReflect.Descriptor instead.
func (*GetMetadata_FunctionMetadata) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{14, 3}
}

func (x *GetMetadata_FunctionMetadata) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

type GetMetadata_DataSourceMetadata struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	TypeName      string                 `protobuf:"bytes,1,opt,name=type_name,json=typeName,proto3" json:"type_name,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetMetadata_DataSourceMetadata) Reset() {
	*x = GetMetadata_DataSourceMetadata{}
	mi := &file_tfplugin6_proto_msgTypes[60]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetMetadata_DataSourceMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetMetadata_DataSourceMetadata) ProtoMessage() {}

func (x *GetMetadata_DataSourceMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[60]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetMetadata_DataSourceMetadata.ProtoReflect.Descriptor instead.
func (*GetMetadata_DataSourceMetadata) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{14, 4}
}

func (x *GetMetadata_DataSourceMetadata) GetTypeName() string {
	if x != nil {
		return x.TypeName
	}
	return ""
}

type GetMetadata_ResourceMetadata struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	TypeName      string                 `protobuf:"bytes,1,opt,name=type_name,json=typeName,proto3" json:"type_name,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetMetadata_ResourceMetadata) Reset() {
	*x = GetMetadata_ResourceMetadata{}
	mi := &file_tfplugin6_proto_msgTypes[61]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetMetadata_ResourceMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetMetadata_ResourceMetadata) ProtoMessage() {}

func (x *GetMetadata_ResourceMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[61]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetMetadata_ResourceMetadata.ProtoReflect.Descriptor instead.
func (*GetMetadata_ResourceMetadata) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{14, 5}
}

func (x *GetMetadata_ResourceMetadata) GetTypeName() string {
	if x != nil {
		return x.TypeName
	}
	return ""
}

type GetMetadata_ListResourceMetadata struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	TypeName      string                 `protobuf:"bytes,1,opt,name=type_name,json=typeName,proto3" json:"type_name,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetMetadata_ListResourceMetadata) Reset() {
	*x = GetMetadata_ListResourceMetadata{}
	mi := &file_tfplugin6_proto_msgTypes[62]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetMetadata_ListResourceMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetMetadata_ListResourceMetadata) ProtoMessage() {}

func (x *GetMetadata_ListResourceMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[62]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetMetadata_ListResourceMetadata.ProtoReflect.Descriptor instead.
func (*GetMetadata_ListResourceMetadata) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{14, 6}
}

func (x *GetMetadata_ListResourceMetadata) GetTypeName() string {
	if x != nil {
		return x.TypeName
	}
	return ""
}

type GetMetadata_StateStoreMetadata struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	TypeName      string                 `protobuf:"bytes,1,opt,name=type_name,json=typeName,proto3" json:"type_name,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetMetadata_StateStoreMetadata) Reset() {
	*x = GetMetadata_StateStoreMetadata{}
	mi := &file_tfplugin6_proto_msgTypes[63]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetMetadata_StateStoreMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetMetadata_StateStoreMetadata) ProtoMessage() {}

func (x *GetMetadata_StateStoreMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[63]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetMetadata_StateStoreMetadata.ProtoReflect.Descriptor instead.
func (*GetMetadata_StateStoreMetadata) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{14, 7}
}

func (x *GetMetadata_StateStoreMetadata) GetTypeName() string {
	if x != nil {
		return x.TypeName
	}
	return ""
}

type GetMetadata_ActionMetadata struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	TypeName      string                 `protobuf:"bytes,1,opt,name=type_name,json=typeName,proto3" json:"type_name,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetMetadata_ActionMetadata) Reset() {
	*x = GetMetadata_ActionMetadata{}
	mi := &file_tfplugin6_proto_msgTypes[64]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetMetadata_ActionMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetMetadata_ActionMetadata) ProtoMessage() {}

func (x *GetMetadata_ActionMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[64]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetMetadata_ActionMetadata.ProtoReflect.Descriptor instead.
func (*GetMetadata_ActionMetadata) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{14, 8}
}

func (x *GetMetadata_ActionMetadata) GetTypeName() string {
	if x != nil {
		return x.TypeName
	}
	return ""
}

type GetProviderSchema_Request struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetProviderSchema_Request) Reset() {
	*x = GetProviderSchema_Request{}
	mi := &file_tfplugin6_proto_msgTypes[65]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetProviderSchema_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetProviderSchema_Request) ProtoMessage() {}

func (x *GetProviderSchema_Request) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[65]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetProviderSchema_Request.ProtoReflect.Descriptor instead.
func (*GetProviderSchema_Request) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{15, 0}
}

type GetProviderSchema_Response struct {
	state                    protoimpl.MessageState   `protogen:"open.v1"`
	Provider                 *Schema                  `protobuf:"bytes,1,opt,name=provider,proto3" json:"provider,omitempty"`
	ResourceSchemas          map[string]*Schema       `protobuf:"bytes,2,rep,name=resource_schemas,json=resourceSchemas,proto3" json:"resource_schemas,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	DataSourceSchemas        map[string]*Schema       `protobuf:"bytes,3,rep,name=data_source_schemas,json=dataSourceSchemas,proto3" json:"data_source_schemas,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	Functions                map[string]*Function     `protobuf:"bytes,7,rep,name=functions,proto3" json:"functions,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	EphemeralResourceSchemas map[string]*Schema       `protobuf:"bytes,8,rep,name=ephemeral_resource_schemas,json=ephemeralResourceSchemas,proto3" json:"ephemeral_resource_schemas,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	ListResourceSchemas      map[string]*Schema       `protobuf:"bytes,9,rep,name=list_resource_schemas,json=listResourceSchemas,proto3" json:"list_resource_schemas,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	StateStoreSchemas        map[string]*Schema       `protobuf:"bytes,10,rep,name=state_store_schemas,json=stateStoreSchemas,proto3" json:"state_store_schemas,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	ActionSchemas            map[string]*ActionSchema `protobuf:"bytes,11,rep,name=action_schemas,json=actionSchemas,proto3" json:"action_schemas,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	Diagnostics              []*Diagnostic            `protobuf:"bytes,4,rep,name=diagnostics,proto3" json:"diagnostics,omitempty"`
	ProviderMeta             *Schema                  `protobuf:"bytes,5,opt,name=provider_meta,json=providerMeta,proto3" json:"provider_meta,omitempty"`
	ServerCapabilities       *ServerCapabilities      `protobuf:"bytes,6,opt,name=server_capabilities,json=serverCapabilities,proto3" json:"server_capabilities,omitempty"`
	unknownFields            protoimpl.UnknownFields
	sizeCache                protoimpl.SizeCache
}

func (x *GetProviderSchema_Response) Reset() {
	*x = GetProviderSchema_Response{}
	mi := &file_tfplugin6_proto_msgTypes[66]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetProviderSchema_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetProviderSchema_Response) ProtoMessage() {}

func (x *GetProviderSchema_Response) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[66]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetProviderSchema_Response.ProtoReflect.Descriptor instead.
func (*GetProviderSchema_Response) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{15, 1}
}

func (x *GetProviderSchema_Response) GetProvider() *Schema {
	if x != nil {
		return x.Provider
	}
	return nil
}

func (x *GetProviderSchema_Response) GetResourceSchemas() map[string]*Schema {
	if x != nil {
		return x.ResourceSchemas
	}
	return nil
}

func (x *GetProviderSchema_Response) GetDataSourceSchemas() map[string]*Schema {
	if x != nil {
		return x.DataSourceSchemas
	}
	return nil
}

func (x *GetProviderSchema_Response) GetFunctions() map[string]*Function {
	if x != nil {
		return x.Functions
	}
	return nil
}

func (x *GetProviderSchema_Response) GetEphemeralResourceSchemas() map[string]*Schema {
	if x != nil {
		return x.EphemeralResourceSchemas
	}
	return nil
}

func (x *GetProviderSchema_Response) GetListResourceSchemas() map[string]*Schema {
	if x != nil {
		return x.ListResourceSchemas
	}
	return nil
}

func (x *GetProviderSchema_Response) GetStateStoreSchemas() map[string]*Schema {
	if x != nil {
		return x.StateStoreSchemas
	}
	return nil
}

func (x *GetProviderSchema_Response) GetActionSchemas() map[string]*ActionSchema {
	if x != nil {
		return x.ActionSchemas
	}
	return nil
}

func (x *GetProviderSchema_Response) GetDiagnostics() []*Diagnostic {
	if x != nil {
		return x.Diagnostics
	}
	return nil
}

func (x *GetProviderSchema_Response) GetProviderMeta() *Schema {
	if x != nil {
		return x.ProviderMeta
	}
	return nil
}

func (x *GetProviderSchema_Response) GetServerCapabilities() *ServerCapabilities {
	if x != nil {
		return x.ServerCapabilities
	}
	return nil
}

type ValidateProviderConfig_Request struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Config        *DynamicValue          `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ValidateProviderConfig_Request) Reset() {
	*x = ValidateProviderConfig_Request{}
	mi := &file_tfplugin6_proto_msgTypes[74]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ValidateProviderConfig_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValidateProviderConfig_Request) ProtoMessage() {}

func (x *ValidateProviderConfig_Request) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[74]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValidateProviderConfig_Request.ProtoReflect.Descriptor instead.
func (*ValidateProviderConfig_Request) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{16, 0}
}

func (x *ValidateProviderConfig_Request) GetConfig() *DynamicValue {
	if x != nil {
		return x.Config
	}
	return nil
}

type ValidateProviderConfig_Response struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Diagnostics   []*Diagnostic          `protobuf:"bytes,2,rep,name=diagnostics,proto3" json:"diagnostics,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ValidateProviderConfig_Response) Reset() {
	*x = ValidateProviderConfig_Response{}
	mi := &file_tfplugin6_proto_msgTypes[75]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ValidateProviderConfig_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValidateProviderConfig_Response) ProtoMessage() {}

func (x *ValidateProviderConfig_Response) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[75]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValidateProviderConfig_Response.ProtoReflect.Descriptor instead.
func (*ValidateProviderConfig_Response) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{16, 1}
}

func (x *ValidateProviderConfig_Response) GetDiagnostics() []*Diagnostic {
	if x != nil {
		return x.Diagnostics
	}
	return nil
}

// Request is the message that is sent to the provider during the
// UpgradeResourceState RPC.
//
// This message intentionally does not include configuration data as any
// configuration-based or configuration-conditional changes should occur
// during the PlanResourceChange RPC. Additionally, the configuration is
// not guaranteed to exist (in the case of resource destruction), be wholly
// known, nor match the given prior state, which could lead to unexpected
// provider behaviors for practitioners.
type UpgradeResourceState_Request struct {
	state    protoimpl.MessageState `protogen:"open.v1"`
	TypeName string                 `protobuf:"bytes,1,opt,name=type_name,json=typeName,proto3" json:"type_name,omitempty"`
	// version is the schema_version number recorded in the state file
	Version int64 `protobuf:"varint,2,opt,name=version,proto3" json:"version,omitempty"`
	// raw_state is the raw states as stored for the resource.  Core does
	// not have access to the schema of prior_version, so it's the
	// provider's responsibility to interpret this value using the
	// appropriate older schema. The raw_state will be the json encoded
	// state, or a legacy flat-mapped format.
	RawState      *RawState `protobuf:"bytes,3,opt,name=raw_state,json=rawState,proto3" json:"raw_state,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UpgradeResourceState_Request) Reset() {
	*x = UpgradeResourceState_Request{}
	mi := &file_tfplugin6_proto_msgTypes[76]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpgradeResourceState_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpgradeResourceState_Request) ProtoMessage() {}

func (x *UpgradeResourceState_Request) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[76]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpgradeResourceState_Request.ProtoReflect.Descriptor instead.
func (*UpgradeResourceState_Request) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{17, 0}
}

func (x *UpgradeResourceState_Request) GetTypeName() string {
	if x != nil {
		return x.TypeName
	}
	return ""
}

func (x *UpgradeResourceState_Request) GetVersion() int64 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *UpgradeResourceState_Request) GetRawState() *RawState {
	if x != nil {
		return x.RawState
	}
	return nil
}

type UpgradeResourceState_Response struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// new_state is a msgpack-encoded data structure that, when interpreted with
	// the _current_ schema for this resource type, is functionally equivalent to
	// that which was given in prior_state_raw.
	UpgradedState *DynamicValue `protobuf:"bytes,1,opt,name=upgraded_state,json=upgradedState,proto3" json:"upgraded_state,omitempty"`
	// diagnostics describes any errors encountered during migration that could not
	// be safely resolved, and warnings about any possibly-risky assumptions made
	// in the upgrade process.
	Diagnostics   []*Diagnostic `protobuf:"bytes,2,rep,name=diagnostics,proto3" json:"diagnostics,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UpgradeResourceState_Response) Reset() {
	*x = UpgradeResourceState_Response{}
	mi := &file_tfplugin6_proto_msgTypes[77]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpgradeResourceState_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpgradeResourceState_Response) ProtoMessage() {}

func (x *UpgradeResourceState_Response) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[77]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpgradeResourceState_Response.ProtoReflect.Descriptor instead.
func (*UpgradeResourceState_Response) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{17, 1}
}

func (x *UpgradeResourceState_Response) GetUpgradedState() *DynamicValue {
	if x != nil {
		return x.UpgradedState
	}
	return nil
}

func (x *UpgradeResourceState_Response) GetDiagnostics() []*Diagnostic {
	if x != nil {
		return x.Diagnostics
	}
	return nil
}

type GetResourceIdentitySchemas_Request struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetResourceIdentitySchemas_Request) Reset() {
	*x = GetResourceIdentitySchemas_Request{}
	mi := &file_tfplugin6_proto_msgTypes[78]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetResourceIdentitySchemas_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetResourceIdentitySchemas_Request) ProtoMessage() {}

func (x *GetResourceIdentitySchemas_Request) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[78]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetResourceIdentitySchemas_Request.ProtoReflect.Descriptor instead.
func (*GetResourceIdentitySchemas_Request) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{18, 0}
}

type GetResourceIdentitySchemas_Response struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// identity_schemas is a mapping of resource type names to their identity schemas.
	IdentitySchemas map[string]*ResourceIdentitySchema `protobuf:"bytes,1,rep,name=identity_schemas,json=identitySchemas,proto3" json:"identity_schemas,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// diagnostics is the collection of warning and error diagnostics for this request.
	Diagnostics   []*Diagnostic `protobuf:"bytes,2,rep,name=diagnostics,proto3" json:"diagnostics,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetResourceIdentitySchemas_Response) Reset() {
	*x = GetResourceIdentitySchemas_Response{}
	mi := &file_tfplugin6_proto_msgTypes[79]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetResourceIdentitySchemas_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetResourceIdentitySchemas_Response) ProtoMessage() {}

func (x *GetResourceIdentitySchemas_Response) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[79]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetResourceIdentitySchemas_Response.ProtoReflect.Descriptor instead.
func (*GetResourceIdentitySchemas_Response) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{18, 1}
}

func (x *GetResourceIdentitySchemas_Response) GetIdentitySchemas() map[string]*ResourceIdentitySchema {
	if x != nil {
		return x.IdentitySchemas
	}
	return nil
}

func (x *GetResourceIdentitySchemas_Response) GetDiagnostics() []*Diagnostic {
	if x != nil {
		return x.Diagnostics
	}
	return nil
}

type UpgradeResourceIdentity_Request struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// type_name is the managed resource type name
	TypeName string `protobuf:"bytes,1,opt,name=type_name,json=typeName,proto3" json:"type_name,omitempty"`
	// version is the version of the resource identity data to upgrade
	Version int64 `protobuf:"varint,2,opt,name=version,proto3" json:"version,omitempty"`
	// raw_identity is the raw identity as stored for the resource. Core does
	// not have access to the identity schema of prior_version, so it's the
	// provider's responsibility to interpret this value using the
	// appropriate older schema. The raw_identity will be json encoded.
	RawIdentity   *RawState `protobuf:"bytes,3,opt,name=raw_identity,json=rawIdentity,proto3" json:"raw_identity,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UpgradeResourceIdentity_Request) Reset() {
	*x = UpgradeResourceIdentity_Request{}
	mi := &file_tfplugin6_proto_msgTypes[81]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpgradeResourceIdentity_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpgradeResourceIdentity_Request) ProtoMessage() {}

func (x *UpgradeResourceIdentity_Request) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[81]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpgradeResourceIdentity_Request.ProtoReflect.Descriptor instead.
func (*UpgradeResourceIdentity_Request) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{19, 0}
}

func (x *UpgradeResourceIdentity_Request) GetTypeName() string {
	if x != nil {
		return x.TypeName
	}
	return ""
}

func (x *UpgradeResourceIdentity_Request) GetVersion() int64 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *UpgradeResourceIdentity_Request) GetRawIdentity() *RawState {
	if x != nil {
		return x.RawIdentity
	}
	return nil
}

type UpgradeResourceIdentity_Response struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// upgraded_identity returns the upgraded resource identity data
	UpgradedIdentity *ResourceIdentityData `protobuf:"bytes,1,opt,name=upgraded_identity,json=upgradedIdentity,proto3" json:"upgraded_identity,omitempty"`
	// diagnostics is the collection of warning and error diagnostics for this request
	Diagnostics   []*Diagnostic `protobuf:"bytes,2,rep,name=diagnostics,proto3" json:"diagnostics,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UpgradeResourceIdentity_Response) Reset() {
	*x = UpgradeResourceIdentity_Response{}
	mi := &file_tfplugin6_proto_msgTypes[82]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpgradeResourceIdentity_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpgradeResourceIdentity_Response) ProtoMessage() {}

func (x *UpgradeResourceIdentity_Response) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[82]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpgradeResourceIdentity_Response.ProtoReflect.Descriptor instead.
func (*UpgradeResourceIdentity_Response) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{19, 1}
}

func (x *UpgradeResourceIdentity_Response) GetUpgradedIdentity() *ResourceIdentityData {
	if x != nil {
		return x.UpgradedIdentity
	}
	return nil
}

func (x *UpgradeResourceIdentity_Response) GetDiagnostics() []*Diagnostic {
	if x != nil {
		return x.Diagnostics
	}
	return nil
}

type ValidateResourceConfig_Request struct {
	state              protoimpl.MessageState `protogen:"open.v1"`
	TypeName           string                 `protobuf:"bytes,1,opt,name=type_name,json=typeName,proto3" json:"type_name,omitempty"`
	Config             *DynamicValue          `protobuf:"bytes,2,opt,name=config,proto3" json:"config,omitempty"`
	ClientCapabilities *ClientCapabilities    `protobuf:"bytes,3,opt,name=client_capabilities,json=clientCapabilities,proto3" json:"client_capabilities,omitempty"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *ValidateResourceConfig_Request) Reset() {
	*x = ValidateResourceConfig_Request{}
	mi := &file_tfplugin6_proto_msgTypes[83]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ValidateResourceConfig_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValidateResourceConfig_Request) ProtoMessage() {}

func (x *ValidateResourceConfig_Request) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[83]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValidateResourceConfig_Request.ProtoReflect.Descriptor instead.
func (*ValidateResourceConfig_Request) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{20, 0}
}

func (x *ValidateResourceConfig_Request) GetTypeName() string {
	if x != nil {
		return x.TypeName
	}
	return ""
}

func (x *ValidateResourceConfig_Request) GetConfig() *DynamicValue {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *ValidateResourceConfig_Request) GetClientCapabilities() *ClientCapabilities {
	if x != nil {
		return x.ClientCapabilities
	}
	return nil
}

type ValidateResourceConfig_Response struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Diagnostics   []*Diagnostic          `protobuf:"bytes,1,rep,name=diagnostics,proto3" json:"diagnostics,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ValidateResourceConfig_Response) Reset() {
	*x = ValidateResourceConfig_Response{}
	mi := &file_tfplugin6_proto_msgTypes[84]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ValidateResourceConfig_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValidateResourceConfig_Response) ProtoMessage() {}

func (x *ValidateResourceConfig_Response) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[84]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValidateResourceConfig_Response.ProtoReflect.Descriptor instead.
func (*ValidateResourceConfig_Response) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{20, 1}
}

func (x *ValidateResourceConfig_Response) GetDiagnostics() []*Diagnostic {
	if x != nil {
		return x.Diagnostics
	}
	return nil
}

type ValidateDataResourceConfig_Request struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	TypeName      string                 `protobuf:"bytes,1,opt,name=type_name,json=typeName,proto3" json:"type_name,omitempty"`
	Config        *DynamicValue          `protobuf:"bytes,2,opt,name=config,proto3" json:"config,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ValidateDataResourceConfig_Request) Reset() {
	*x = ValidateDataResourceConfig_Request{}
	mi := &file_tfplugin6_proto_msgTypes[85]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ValidateDataResourceConfig_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValidateDataResourceConfig_Request) ProtoMessage() {}

func (x *ValidateDataResourceConfig_Request) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[85]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValidateDataResourceConfig_Request.ProtoReflect.Descriptor instead.
func (*ValidateDataResourceConfig_Request) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{21, 0}
}

func (x *ValidateDataResourceConfig_Request) GetTypeName() string {
	if x != nil {
		return x.TypeName
	}
	return ""
}

func (x *ValidateDataResourceConfig_Request) GetConfig() *DynamicValue {
	if x != nil {
		return x.Config
	}
	return nil
}

type ValidateDataResourceConfig_Response struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Diagnostics   []*Diagnostic          `protobuf:"bytes,1,rep,name=diagnostics,proto3" json:"diagnostics,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ValidateDataResourceConfig_Response) Reset() {
	*x = ValidateDataResourceConfig_Response{}
	mi := &file_tfplugin6_proto_msgTypes[86]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ValidateDataResourceConfig_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValidateDataResourceConfig_Response) ProtoMessage() {}

func (x *ValidateDataResourceConfig_Response) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[86]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValidateDataResourceConfig_Response.ProtoReflect.Descriptor instead.
func (*ValidateDataResourceConfig_Response) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{21, 1}
}

func (x *ValidateDataResourceConfig_Response) GetDiagnostics() []*Diagnostic {
	if x != nil {
		return x.Diagnostics
	}
	return nil
}

type ValidateEphemeralResourceConfig_Request struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	TypeName      string                 `protobuf:"bytes,1,opt,name=type_name,json=typeName,proto3" json:"type_name,omitempty"`
	Config        *DynamicValue          `protobuf:"bytes,2,opt,name=config,proto3" json:"config,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ValidateEphemeralResourceConfig_Request) Reset() {
	*x = ValidateEphemeralResourceConfig_Request{}
	mi := &file_tfplugin6_proto_msgTypes[87]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ValidateEphemeralResourceConfig_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValidateEphemeralResourceConfig_Request) ProtoMessage() {}

func (x *ValidateEphemeralResourceConfig_Request) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[87]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValidateEphemeralResourceConfig_Request.ProtoReflect.Descriptor instead.
func (*ValidateEphemeralResourceConfig_Request) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{22, 0}
}

func (x *ValidateEphemeralResourceConfig_Request) GetTypeName() string {
	if x != nil {
		return x.TypeName
	}
	return ""
}

func (x *ValidateEphemeralResourceConfig_Request) GetConfig() *DynamicValue {
	if x != nil {
		return x.Config
	}
	return nil
}

type ValidateEphemeralResourceConfig_Response struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Diagnostics   []*Diagnostic          `protobuf:"bytes,1,rep,name=diagnostics,proto3" json:"diagnostics,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ValidateEphemeralResourceConfig_Response) Reset() {
	*x = ValidateEphemeralResourceConfig_Response{}
	mi := &file_tfplugin6_proto_msgTypes[88]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ValidateEphemeralResourceConfig_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValidateEphemeralResourceConfig_Response) ProtoMessage() {}

func (x *ValidateEphemeralResourceConfig_Response) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[88]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValidateEphemeralResourceConfig_Response.ProtoReflect.Descriptor instead.
func (*ValidateEphemeralResourceConfig_Response) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{22, 1}
}

func (x *ValidateEphemeralResourceConfig_Response) GetDiagnostics() []*Diagnostic {
	if x != nil {
		return x.Diagnostics
	}
	return nil
}

type ConfigureProvider_Request struct {
	state              protoimpl.MessageState `protogen:"open.v1"`
	TerraformVersion   string                 `protobuf:"bytes,1,opt,name=terraform_version,json=terraformVersion,proto3" json:"terraform_version,omitempty"`
	Config             *DynamicValue          `protobuf:"bytes,2,opt,name=config,proto3" json:"config,omitempty"`
	ClientCapabilities *ClientCapabilities    `protobuf:"bytes,3,opt,name=client_capabilities,json=clientCapabilities,proto3" json:"client_capabilities,omitempty"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *ConfigureProvider_Request) Reset() {
	*x = ConfigureProvider_Request{}
	mi := &file_tfplugin6_proto_msgTypes[89]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ConfigureProvider_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConfigureProvider_Request) ProtoMessage() {}

func (x *ConfigureProvider_Request) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[89]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConfigureProvider_Request.ProtoReflect.Descriptor instead.
func (*ConfigureProvider_Request) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{23, 0}
}

func (x *ConfigureProvider_Request) GetTerraformVersion() string {
	if x != nil {
		return x.TerraformVersion
	}
	return ""
}

func (x *ConfigureProvider_Request) GetConfig() *DynamicValue {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *ConfigureProvider_Request) GetClientCapabilities() *ClientCapabilities {
	if x != nil {
		return x.ClientCapabilities
	}
	return nil
}

type ConfigureProvider_Response struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Diagnostics   []*Diagnostic          `protobuf:"bytes,1,rep,name=diagnostics,proto3" json:"diagnostics,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ConfigureProvider_Response) Reset() {
	*x = ConfigureProvider_Response{}
	mi := &file_tfplugin6_proto_msgTypes[90]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ConfigureProvider_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConfigureProvider_Response) ProtoMessage() {}

func (x *ConfigureProvider_Response) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[90]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConfigureProvider_Response.ProtoReflect.Descriptor instead.
func (*ConfigureProvider_Response) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{23, 1}
}

func (x *ConfigureProvider_Response) GetDiagnostics() []*Diagnostic {
	if x != nil {
		return x.Diagnostics
	}
	return nil
}

// Request is the message that is sent to the provider during the
// ReadResource RPC.
//
// This message intentionally does not include configuration data as any
// configuration-based or configuration-conditional changes should occur
// during the PlanResourceChange RPC. Additionally, the configuration is
// not guaranteed to be wholly known nor match the given prior state, which
// could lead to unexpected provider behaviors for practitioners.
type ReadResource_Request struct {
	state              protoimpl.MessageState `protogen:"open.v1"`
	TypeName           string                 `protobuf:"bytes,1,opt,name=type_name,json=typeName,proto3" json:"type_name,omitempty"`
	CurrentState       *DynamicValue          `protobuf:"bytes,2,opt,name=current_state,json=currentState,proto3" json:"current_state,omitempty"`
	Private            []byte                 `protobuf:"bytes,3,opt,name=private,proto3" json:"private,omitempty"`
	ProviderMeta       *DynamicValue          `protobuf:"bytes,4,opt,name=provider_meta,json=providerMeta,proto3" json:"provider_meta,omitempty"`
	ClientCapabilities *ClientCapabilities    `protobuf:"bytes,5,opt,name=client_capabilities,json=clientCapabilities,proto3" json:"client_capabilities,omitempty"`
	CurrentIdentity    *ResourceIdentityData  `protobuf:"bytes,6,opt,name=current_identity,json=currentIdentity,proto3" json:"current_identity,omitempty"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *ReadResource_Request) Reset() {
	*x = ReadResource_Request{}
	mi := &file_tfplugin6_proto_msgTypes[91]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReadResource_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadResource_Request) ProtoMessage() {}

func (x *ReadResource_Request) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[91]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadResource_Request.ProtoReflect.Descriptor instead.
func (*ReadResource_Request) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{24, 0}
}

func (x *ReadResource_Request) GetTypeName() string {
	if x != nil {
		return x.TypeName
	}
	return ""
}

func (x *ReadResource_Request) GetCurrentState() *DynamicValue {
	if x != nil {
		return x.CurrentState
	}
	return nil
}

func (x *ReadResource_Request) GetPrivate() []byte {
	if x != nil {
		return x.Private
	}
	return nil
}

func (x *ReadResource_Request) GetProviderMeta() *DynamicValue {
	if x != nil {
		return x.ProviderMeta
	}
	return nil
}

func (x *ReadResource_Request) GetClientCapabilities() *ClientCapabilities {
	if x != nil {
		return x.ClientCapabilities
	}
	return nil
}

func (x *ReadResource_Request) GetCurrentIdentity() *ResourceIdentityData {
	if x != nil {
		return x.CurrentIdentity
	}
	return nil
}

type ReadResource_Response struct {
	state       protoimpl.MessageState `protogen:"open.v1"`
	NewState    *DynamicValue          `protobuf:"bytes,1,opt,name=new_state,json=newState,proto3" json:"new_state,omitempty"`
	Diagnostics []*Diagnostic          `protobuf:"bytes,2,rep,name=diagnostics,proto3" json:"diagnostics,omitempty"`
	Private     []byte                 `protobuf:"bytes,3,opt,name=private,proto3" json:"private,omitempty"`
	// deferred is set if the provider is deferring the change. If set the caller
	// needs to handle the deferral.
	Deferred      *Deferred             `protobuf:"bytes,4,opt,name=deferred,proto3" json:"deferred,omitempty"`
	NewIdentity   *ResourceIdentityData `protobuf:"bytes,5,opt,name=new_identity,json=newIdentity,proto3" json:"new_identity,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ReadResource_Response) Reset() {
	*x = ReadResource_Response{}
	mi := &file_tfplugin6_proto_msgTypes[92]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReadResource_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadResource_Response) ProtoMessage() {}

func (x *ReadResource_Response) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[92]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadResource_Response.ProtoReflect.Descriptor instead.
func (*ReadResource_Response) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{24, 1}
}

func (x *ReadResource_Response) GetNewState() *DynamicValue {
	if x != nil {
		return x.NewState
	}
	return nil
}

func (x *ReadResource_Response) GetDiagnostics() []*Diagnostic {
	if x != nil {
		return x.Diagnostics
	}
	return nil
}

func (x *ReadResource_Response) GetPrivate() []byte {
	if x != nil {
		return x.Private
	}
	return nil
}

func (x *ReadResource_Response) GetDeferred() *Deferred {
	if x != nil {
		return x.Deferred
	}
	return nil
}

func (x *ReadResource_Response) GetNewIdentity() *ResourceIdentityData {
	if x != nil {
		return x.NewIdentity
	}
	return nil
}

type PlanResourceChange_Request struct {
	state              protoimpl.MessageState `protogen:"open.v1"`
	TypeName           string                 `protobuf:"bytes,1,opt,name=type_name,json=typeName,proto3" json:"type_name,omitempty"`
	PriorState         *DynamicValue          `protobuf:"bytes,2,opt,name=prior_state,json=priorState,proto3" json:"prior_state,omitempty"`
	ProposedNewState   *DynamicValue          `protobuf:"bytes,3,opt,name=proposed_new_state,json=proposedNewState,proto3" json:"proposed_new_state,omitempty"`
	Config             *DynamicValue          `protobuf:"bytes,4,opt,name=config,proto3" json:"config,omitempty"`
	PriorPrivate       []byte                 `protobuf:"bytes,5,opt,name=prior_private,json=priorPrivate,proto3" json:"prior_private,omitempty"`
	ProviderMeta       *DynamicValue          `protobuf:"bytes,6,opt,name=provider_meta,json=providerMeta,proto3" json:"provider_meta,omitempty"`
	ClientCapabilities *ClientCapabilities    `protobuf:"bytes,7,opt,name=client_capabilities,json=clientCapabilities,proto3" json:"client_capabilities,omitempty"`
	PriorIdentity      *ResourceIdentityData  `protobuf:"bytes,8,opt,name=prior_identity,json=priorIdentity,proto3" json:"prior_identity,omitempty"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *PlanResourceChange_Request) Reset() {
	*x = PlanResourceChange_Request{}
	mi := &file_tfplugin6_proto_msgTypes[93]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PlanResourceChange_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlanResourceChange_Request) ProtoMessage() {}

func (x *PlanResourceChange_Request) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[93]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlanResourceChange_Request.ProtoReflect.Descriptor instead.
func (*PlanResourceChange_Request) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{25, 0}
}

func (x *PlanResourceChange_Request) GetTypeName() string {
	if x != nil {
		return x.TypeName
	}
	return ""
}

func (x *PlanResourceChange_Request) GetPriorState() *DynamicValue {
	if x != nil {
		return x.PriorState
	}
	return nil
}

func (x *PlanResourceChange_Request) GetProposedNewState() *DynamicValue {
	if x != nil {
		return x.ProposedNewState
	}
	return nil
}

func (x *PlanResourceChange_Request) GetConfig() *DynamicValue {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *PlanResourceChange_Request) GetPriorPrivate() []byte {
	if x != nil {
		return x.PriorPrivate
	}
	return nil
}

func (x *PlanResourceChange_Request) GetProviderMeta() *DynamicValue {
	if x != nil {
		return x.ProviderMeta
	}
	return nil
}

func (x *PlanResourceChange_Request) GetClientCapabilities() *ClientCapabilities {
	if x != nil {
		return x.ClientCapabilities
	}
	return nil
}

func (x *PlanResourceChange_Request) GetPriorIdentity() *ResourceIdentityData {
	if x != nil {
		return x.PriorIdentity
	}
	return nil
}

type PlanResourceChange_Response struct {
	state           protoimpl.MessageState `protogen:"open.v1"`
	PlannedState    *DynamicValue          `protobuf:"bytes,1,opt,name=planned_state,json=plannedState,proto3" json:"planned_state,omitempty"`
	RequiresReplace []*AttributePath       `protobuf:"bytes,2,rep,name=requires_replace,json=requiresReplace,proto3" json:"requires_replace,omitempty"`
	PlannedPrivate  []byte                 `protobuf:"bytes,3,opt,name=planned_private,json=plannedPrivate,proto3" json:"planned_private,omitempty"`
	Diagnostics     []*Diagnostic          `protobuf:"bytes,4,rep,name=diagnostics,proto3" json:"diagnostics,omitempty"`
	// This may be set only by the helper/schema "SDK" in the main Terraform
	// repository, to request that Terraform Core >=0.12 permit additional
	// inconsistencies that can result from the legacy SDK type system
	// and its imprecise mapping to the >=0.12 type system.
	// The change in behavior implied by this flag makes sense only for the
	// specific details of the legacy SDK type system, and are not a general
	// mechanism to avoid proper type handling in providers.
	//
	//	====              DO NOT USE THIS              ====
	//	==== THIS MUST BE LEFT UNSET IN ALL OTHER SDKS ====
	//	====              DO NOT USE THIS              ====
	LegacyTypeSystem bool `protobuf:"varint,5,opt,name=legacy_type_system,json=legacyTypeSystem,proto3" json:"legacy_type_system,omitempty"`
	// deferred is set if the provider is deferring the change. If set the caller
	// needs to handle the deferral.
	Deferred        *Deferred             `protobuf:"bytes,6,opt,name=deferred,proto3" json:"deferred,omitempty"`
	PlannedIdentity *ResourceIdentityData `protobuf:"bytes,7,opt,name=planned_identity,json=plannedIdentity,proto3" json:"planned_identity,omitempty"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *PlanResourceChange_Response) Reset() {
	*x = PlanResourceChange_Response{}
	mi := &file_tfplugin6_proto_msgTypes[94]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PlanResourceChange_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlanResourceChange_Response) ProtoMessage() {}

func (x *PlanResourceChange_Response) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[94]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlanResourceChange_Response.ProtoReflect.Descriptor instead.
func (*PlanResourceChange_Response) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{25, 1}
}

func (x *PlanResourceChange_Response) GetPlannedState() *DynamicValue {
	if x != nil {
		return x.PlannedState
	}
	return nil
}

func (x *PlanResourceChange_Response) GetRequiresReplace() []*AttributePath {
	if x != nil {
		return x.RequiresReplace
	}
	return nil
}

func (x *PlanResourceChange_Response) GetPlannedPrivate() []byte {
	if x != nil {
		return x.PlannedPrivate
	}
	return nil
}

func (x *PlanResourceChange_Response) GetDiagnostics() []*Diagnostic {
	if x != nil {
		return x.Diagnostics
	}
	return nil
}

func (x *PlanResourceChange_Response) GetLegacyTypeSystem() bool {
	if x != nil {
		return x.LegacyTypeSystem
	}
	return false
}

func (x *PlanResourceChange_Response) GetDeferred() *Deferred {
	if x != nil {
		return x.Deferred
	}
	return nil
}

func (x *PlanResourceChange_Response) GetPlannedIdentity() *ResourceIdentityData {
	if x != nil {
		return x.PlannedIdentity
	}
	return nil
}

type ApplyResourceChange_Request struct {
	state           protoimpl.MessageState `protogen:"open.v1"`
	TypeName        string                 `protobuf:"bytes,1,opt,name=type_name,json=typeName,proto3" json:"type_name,omitempty"`
	PriorState      *DynamicValue          `protobuf:"bytes,2,opt,name=prior_state,json=priorState,proto3" json:"prior_state,omitempty"`
	PlannedState    *DynamicValue          `protobuf:"bytes,3,opt,name=planned_state,json=plannedState,proto3" json:"planned_state,omitempty"`
	Config          *DynamicValue          `protobuf:"bytes,4,opt,name=config,proto3" json:"config,omitempty"`
	PlannedPrivate  []byte                 `protobuf:"bytes,5,opt,name=planned_private,json=plannedPrivate,proto3" json:"planned_private,omitempty"`
	ProviderMeta    *DynamicValue          `protobuf:"bytes,6,opt,name=provider_meta,json=providerMeta,proto3" json:"provider_meta,omitempty"`
	PlannedIdentity *ResourceIdentityData  `protobuf:"bytes,7,opt,name=planned_identity,json=plannedIdentity,proto3" json:"planned_identity,omitempty"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *ApplyResourceChange_Request) Reset() {
	*x = ApplyResourceChange_Request{}
	mi := &file_tfplugin6_proto_msgTypes[95]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ApplyResourceChange_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplyResourceChange_Request) ProtoMessage() {}

func (x *ApplyResourceChange_Request) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[95]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplyResourceChange_Request.ProtoReflect.Descriptor instead.
func (*ApplyResourceChange_Request) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{26, 0}
}

func (x *ApplyResourceChange_Request) GetTypeName() string {
	if x != nil {
		return x.TypeName
	}
	return ""
}

func (x *ApplyResourceChange_Request) GetPriorState() *DynamicValue {
	if x != nil {
		return x.PriorState
	}
	return nil
}

func (x *ApplyResourceChange_Request) GetPlannedState() *DynamicValue {
	if x != nil {
		return x.PlannedState
	}
	return nil
}

func (x *ApplyResourceChange_Request) GetConfig() *DynamicValue {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *ApplyResourceChange_Request) GetPlannedPrivate() []byte {
	if x != nil {
		return x.PlannedPrivate
	}
	return nil
}

func (x *ApplyResourceChange_Request) GetProviderMeta() *DynamicValue {
	if x != nil {
		return x.ProviderMeta
	}
	return nil
}

func (x *ApplyResourceChange_Request) GetPlannedIdentity() *ResourceIdentityData {
	if x != nil {
		return x.PlannedIdentity
	}
	return nil
}

type ApplyResourceChange_Response struct {
	state       protoimpl.MessageState `protogen:"open.v1"`
	NewState    *DynamicValue          `protobuf:"bytes,1,opt,name=new_state,json=newState,proto3" json:"new_state,omitempty"`
	Private     []byte                 `protobuf:"bytes,2,opt,name=private,proto3" json:"private,omitempty"`
	Diagnostics []*Diagnostic          `protobuf:"bytes,3,rep,name=diagnostics,proto3" json:"diagnostics,omitempty"`
	// This may be set only by the helper/schema "SDK" in the main Terraform
	// repository, to request that Terraform Core >=0.12 permit additional
	// inconsistencies that can result from the legacy SDK type system
	// and its imprecise mapping to the >=0.12 type system.
	// The change in behavior implied by this flag makes sense only for the
	// specific details of the legacy SDK type system, and are not a general
	// mechanism to avoid proper type handling in providers.
	//
	//	====              DO NOT USE THIS              ====
	//	==== THIS MUST BE LEFT UNSET IN ALL OTHER SDKS ====
	//	====              DO NOT USE THIS              ====
	LegacyTypeSystem bool                  `protobuf:"varint,4,opt,name=legacy_type_system,json=legacyTypeSystem,proto3" json:"legacy_type_system,omitempty"`
	NewIdentity      *ResourceIdentityData `protobuf:"bytes,5,opt,name=new_identity,json=newIdentity,proto3" json:"new_identity,omitempty"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *ApplyResourceChange_Response) Reset() {
	*x = ApplyResourceChange_Response{}
	mi := &file_tfplugin6_proto_msgTypes[96]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ApplyResourceChange_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplyResourceChange_Response) ProtoMessage() {}

func (x *ApplyResourceChange_Response) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[96]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplyResourceChange_Response.ProtoReflect.Descriptor instead.
func (*ApplyResourceChange_Response) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{26, 1}
}

func (x *ApplyResourceChange_Response) GetNewState() *DynamicValue {
	if x != nil {
		return x.NewState
	}
	return nil
}

func (x *ApplyResourceChange_Response) GetPrivate() []byte {
	if x != nil {
		return x.Private
	}
	return nil
}

func (x *ApplyResourceChange_Response) GetDiagnostics() []*Diagnostic {
	if x != nil {
		return x.Diagnostics
	}
	return nil
}

func (x *ApplyResourceChange_Response) GetLegacyTypeSystem() bool {
	if x != nil {
		return x.LegacyTypeSystem
	}
	return false
}

func (x *ApplyResourceChange_Response) GetNewIdentity() *ResourceIdentityData {
	if x != nil {
		return x.NewIdentity
	}
	return nil
}

type ImportResourceState_Request struct {
	state              protoimpl.MessageState `protogen:"open.v1"`
	TypeName           string                 `protobuf:"bytes,1,opt,name=type_name,json=typeName,proto3" json:"type_name,omitempty"`
	Id                 string                 `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
	ClientCapabilities *ClientCapabilities    `protobuf:"bytes,3,opt,name=client_capabilities,json=clientCapabilities,proto3" json:"client_capabilities,omitempty"`
	Identity           *ResourceIdentityData  `protobuf:"bytes,4,opt,name=identity,proto3" json:"identity,omitempty"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *ImportResourceState_Request) Reset() {
	*x = ImportResourceState_Request{}
	mi := &file_tfplugin6_proto_msgTypes[97]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImportResourceState_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportResourceState_Request) ProtoMessage() {}

func (x *ImportResourceState_Request) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[97]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportResourceState_Request.ProtoReflect.Descriptor instead.
func (*ImportResourceState_Request) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{27, 0}
}

func (x *ImportResourceState_Request) GetTypeName() string {
	if x != nil {
		return x.TypeName
	}
	return ""
}

func (x *ImportResourceState_Request) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *ImportResourceState_Request) GetClientCapabilities() *ClientCapabilities {
	if x != nil {
		return x.ClientCapabilities
	}
	return nil
}

func (x *ImportResourceState_Request) GetIdentity() *ResourceIdentityData {
	if x != nil {
		return x.Identity
	}
	return nil
}

type ImportResourceState_ImportedResource struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	TypeName      string                 `protobuf:"bytes,1,opt,name=type_name,json=typeName,proto3" json:"type_name,omitempty"`
	State         *DynamicValue          `protobuf:"bytes,2,opt,name=state,proto3" json:"state,omitempty"`
	Private       []byte                 `protobuf:"bytes,3,opt,name=private,proto3" json:"private,omitempty"`
	Identity      *ResourceIdentityData  `protobuf:"bytes,4,opt,name=identity,proto3" json:"identity,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ImportResourceState_ImportedResource) Reset() {
	*x = ImportResourceState_ImportedResource{}
	mi := &file_tfplugin6_proto_msgTypes[98]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImportResourceState_ImportedResource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportResourceState_ImportedResource) ProtoMessage() {}

func (x *ImportResourceState_ImportedResource) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[98]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportResourceState_ImportedResource.ProtoReflect.Descriptor instead.
func (*ImportResourceState_ImportedResource) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{27, 1}
}

func (x *ImportResourceState_ImportedResource) GetTypeName() string {
	if x != nil {
		return x.TypeName
	}
	return ""
}

func (x *ImportResourceState_ImportedResource) GetState() *DynamicValue {
	if x != nil {
		return x.State
	}
	return nil
}

func (x *ImportResourceState_ImportedResource) GetPrivate() []byte {
	if x != nil {
		return x.Private
	}
	return nil
}

func (x *ImportResourceState_ImportedResource) GetIdentity() *ResourceIdentityData {
	if x != nil {
		return x.Identity
	}
	return nil
}

type ImportResourceState_Response struct {
	state             protoimpl.MessageState                  `protogen:"open.v1"`
	ImportedResources []*ImportResourceState_ImportedResource `protobuf:"bytes,1,rep,name=imported_resources,json=importedResources,proto3" json:"imported_resources,omitempty"`
	Diagnostics       []*Diagnostic                           `protobuf:"bytes,2,rep,name=diagnostics,proto3" json:"diagnostics,omitempty"`
	// deferred is set if the provider is deferring the change. If set the caller
	// needs to handle the deferral.
	Deferred      *Deferred `protobuf:"bytes,3,opt,name=deferred,proto3" json:"deferred,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ImportResourceState_Response) Reset() {
	*x = ImportResourceState_Response{}
	mi := &file_tfplugin6_proto_msgTypes[99]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImportResourceState_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportResourceState_Response) ProtoMessage() {}

func (x *ImportResourceState_Response) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[99]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportResourceState_Response.ProtoReflect.Descriptor instead.
func (*ImportResourceState_Response) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{27, 2}
}

func (x *ImportResourceState_Response) GetImportedResources() []*ImportResourceState_ImportedResource {
	if x != nil {
		return x.ImportedResources
	}
	return nil
}

func (x *ImportResourceState_Response) GetDiagnostics() []*Diagnostic {
	if x != nil {
		return x.Diagnostics
	}
	return nil
}

func (x *ImportResourceState_Response) GetDeferred() *Deferred {
	if x != nil {
		return x.Deferred
	}
	return nil
}

type GenerateResourceConfig_Request struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	TypeName      string                 `protobuf:"bytes,1,opt,name=type_name,json=typeName,proto3" json:"type_name,omitempty"`
	State         *DynamicValue          `protobuf:"bytes,2,opt,name=state,proto3" json:"state,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GenerateResourceConfig_Request) Reset() {
	*x = GenerateResourceConfig_Request{}
	mi := &file_tfplugin6_proto_msgTypes[100]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GenerateResourceConfig_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateResourceConfig_Request) ProtoMessage() {}

func (x *GenerateResourceConfig_Request) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[100]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateResourceConfig_Request.ProtoReflect.Descriptor instead.
func (*GenerateResourceConfig_Request) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{28, 0}
}

func (x *GenerateResourceConfig_Request) GetTypeName() string {
	if x != nil {
		return x.TypeName
	}
	return ""
}

func (x *GenerateResourceConfig_Request) GetState() *DynamicValue {
	if x != nil {
		return x.State
	}
	return nil
}

type GenerateResourceConfig_Response struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// config is the provided state modified such that it represents a valid resource configuration value.
	Config        *DynamicValue `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	Diagnostics   []*Diagnostic `protobuf:"bytes,2,rep,name=diagnostics,proto3" json:"diagnostics,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GenerateResourceConfig_Response) Reset() {
	*x = GenerateResourceConfig_Response{}
	mi := &file_tfplugin6_proto_msgTypes[101]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GenerateResourceConfig_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateResourceConfig_Response) ProtoMessage() {}

func (x *GenerateResourceConfig_Response) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[101]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateResourceConfig_Response.ProtoReflect.Descriptor instead.
func (*GenerateResourceConfig_Response) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{28, 1}
}

func (x *GenerateResourceConfig_Response) GetConfig() *DynamicValue {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *GenerateResourceConfig_Response) GetDiagnostics() []*Diagnostic {
	if x != nil {
		return x.Diagnostics
	}
	return nil
}

type MoveResourceState_Request struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The address of the provider the resource is being moved from.
	SourceProviderAddress string `protobuf:"bytes,1,opt,name=source_provider_address,json=sourceProviderAddress,proto3" json:"source_provider_address,omitempty"`
	// The resource type that the resource is being moved from.
	SourceTypeName string `protobuf:"bytes,2,opt,name=source_type_name,json=sourceTypeName,proto3" json:"source_type_name,omitempty"`
	// The schema version of the resource type that the resource is being
	// moved from.
	SourceSchemaVersion int64 `protobuf:"varint,3,opt,name=source_schema_version,json=sourceSchemaVersion,proto3" json:"source_schema_version,omitempty"`
	// The raw state of the resource being moved. Only the json field is
	// populated, as there should be no legacy providers using the flatmap
	// format that support newly introduced RPCs.
	SourceState *RawState `protobuf:"bytes,4,opt,name=source_state,json=sourceState,proto3" json:"source_state,omitempty"`
	// The resource type that the resource is being moved to.
	TargetTypeName string `protobuf:"bytes,5,opt,name=target_type_name,json=targetTypeName,proto3" json:"target_type_name,omitempty"`
	// The private state of the resource being moved.
	SourcePrivate []byte `protobuf:"bytes,6,opt,name=source_private,json=sourcePrivate,proto3" json:"source_private,omitempty"`
	// The raw identity of the resource being moved. Only the json field is
	// populated, as there should be no legacy providers using the flatmap
	// format that support newly introduced RPCs.
	SourceIdentity *RawState `protobuf:"bytes,7,opt,name=source_identity,json=sourceIdentity,proto3" json:"source_identity,omitempty"`
	// The identity schema version of the resource type that the resource
	// is being moved from.
	SourceIdentitySchemaVersion int64 `protobuf:"varint,8,opt,name=source_identity_schema_version,json=sourceIdentitySchemaVersion,proto3" json:"source_identity_schema_version,omitempty"`
	unknownFields               protoimpl.UnknownFields
	sizeCache                   protoimpl.SizeCache
}

func (x *MoveResourceState_Request) Reset() {
	*x = MoveResourceState_Request{}
	mi := &file_tfplugin6_proto_msgTypes[102]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MoveResourceState_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MoveResourceState_Request) ProtoMessage() {}

func (x *MoveResourceState_Request) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[102]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MoveResourceState_Request.ProtoReflect.Descriptor instead.
func (*MoveResourceState_Request) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{29, 0}
}

func (x *MoveResourceState_Request) GetSourceProviderAddress() string {
	if x != nil {
		return x.SourceProviderAddress
	}
	return ""
}

func (x *MoveResourceState_Request) GetSourceTypeName() string {
	if x != nil {
		return x.SourceTypeName
	}
	return ""
}

func (x *MoveResourceState_Request) GetSourceSchemaVersion() int64 {
	if x != nil {
		return x.SourceSchemaVersion
	}
	return 0
}

func (x *MoveResourceState_Request) GetSourceState() *RawState {
	if x != nil {
		return x.SourceState
	}
	return nil
}

func (x *MoveResourceState_Request) GetTargetTypeName() string {
	if x != nil {
		return x.TargetTypeName
	}
	return ""
}

func (x *MoveResourceState_Request) GetSourcePrivate() []byte {
	if x != nil {
		return x.SourcePrivate
	}
	return nil
}

func (x *MoveResourceState_Request) GetSourceIdentity() *RawState {
	if x != nil {
		return x.SourceIdentity
	}
	return nil
}

func (x *MoveResourceState_Request) GetSourceIdentitySchemaVersion() int64 {
	if x != nil {
		return x.SourceIdentitySchemaVersion
	}
	return 0
}

type MoveResourceState_Response struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The state of the resource after it has been moved.
	TargetState *DynamicValue `protobuf:"bytes,1,opt,name=target_state,json=targetState,proto3" json:"target_state,omitempty"`
	// Any diagnostics that occurred during the move.
	Diagnostics []*Diagnostic `protobuf:"bytes,2,rep,name=diagnostics,proto3" json:"diagnostics,omitempty"`
	// The private state of the resource after it has been moved.
	TargetPrivate  []byte                `protobuf:"bytes,3,opt,name=target_private,json=targetPrivate,proto3" json:"target_private,omitempty"`
	TargetIdentity *ResourceIdentityData `protobuf:"bytes,4,opt,name=target_identity,json=targetIdentity,proto3" json:"target_identity,omitempty"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *MoveResourceState_Response) Reset() {
	*x = MoveResourceState_Response{}
	mi := &file_tfplugin6_proto_msgTypes[103]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MoveResourceState_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MoveResourceState_Response) ProtoMessage() {}

func (x *MoveResourceState_Response) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[103]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MoveResourceState_Response.ProtoReflect.Descriptor instead.
func (*MoveResourceState_Response) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{29, 1}
}

func (x *MoveResourceState_Response) GetTargetState() *DynamicValue {
	if x != nil {
		return x.TargetState
	}
	return nil
}

func (x *MoveResourceState_Response) GetDiagnostics() []*Diagnostic {
	if x != nil {
		return x.Diagnostics
	}
	return nil
}

func (x *MoveResourceState_Response) GetTargetPrivate() []byte {
	if x != nil {
		return x.TargetPrivate
	}
	return nil
}

func (x *MoveResourceState_Response) GetTargetIdentity() *ResourceIdentityData {
	if x != nil {
		return x.TargetIdentity
	}
	return nil
}

type ReadDataSource_Request struct {
	state              protoimpl.MessageState `protogen:"open.v1"`
	TypeName           string                 `protobuf:"bytes,1,opt,name=type_name,json=typeName,proto3" json:"type_name,omitempty"`
	Config             *DynamicValue          `protobuf:"bytes,2,opt,name=config,proto3" json:"config,omitempty"`
	ProviderMeta       *DynamicValue          `protobuf:"bytes,3,opt,name=provider_meta,json=providerMeta,proto3" json:"provider_meta,omitempty"`
	ClientCapabilities *ClientCapabilities    `protobuf:"bytes,4,opt,name=client_capabilities,json=clientCapabilities,proto3" json:"client_capabilities,omitempty"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *ReadDataSource_Request) Reset() {
	*x = ReadDataSource_Request{}
	mi := &file_tfplugin6_proto_msgTypes[104]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReadDataSource_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadDataSource_Request) ProtoMessage() {}

func (x *ReadDataSource_Request) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[104]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadDataSource_Request.ProtoReflect.Descriptor instead.
func (*ReadDataSource_Request) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{30, 0}
}

func (x *ReadDataSource_Request) GetTypeName() string {
	if x != nil {
		return x.TypeName
	}
	return ""
}

func (x *ReadDataSource_Request) GetConfig() *DynamicValue {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *ReadDataSource_Request) GetProviderMeta() *DynamicValue {
	if x != nil {
		return x.ProviderMeta
	}
	return nil
}

func (x *ReadDataSource_Request) GetClientCapabilities() *ClientCapabilities {
	if x != nil {
		return x.ClientCapabilities
	}
	return nil
}

type ReadDataSource_Response struct {
	state       protoimpl.MessageState `protogen:"open.v1"`
	State       *DynamicValue          `protobuf:"bytes,1,opt,name=state,proto3" json:"state,omitempty"`
	Diagnostics []*Diagnostic          `protobuf:"bytes,2,rep,name=diagnostics,proto3" json:"diagnostics,omitempty"`
	// deferred is set if the provider is deferring the change. If set the caller
	// needs to handle the deferral.
	Deferred      *Deferred `protobuf:"bytes,3,opt,name=deferred,proto3" json:"deferred,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ReadDataSource_Response) Reset() {
	*x = ReadDataSource_Response{}
	mi := &file_tfplugin6_proto_msgTypes[105]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReadDataSource_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadDataSource_Response) ProtoMessage() {}

func (x *ReadDataSource_Response) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[105]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadDataSource_Response.ProtoReflect.Descriptor instead.
func (*ReadDataSource_Response) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{30, 1}
}

func (x *ReadDataSource_Response) GetState() *DynamicValue {
	if x != nil {
		return x.State
	}
	return nil
}

func (x *ReadDataSource_Response) GetDiagnostics() []*Diagnostic {
	if x != nil {
		return x.Diagnostics
	}
	return nil
}

func (x *ReadDataSource_Response) GetDeferred() *Deferred {
	if x != nil {
		return x.Deferred
	}
	return nil
}

type OpenEphemeralResource_Request struct {
	state              protoimpl.MessageState `protogen:"open.v1"`
	TypeName           string                 `protobuf:"bytes,1,opt,name=type_name,json=typeName,proto3" json:"type_name,omitempty"`
	Config             *DynamicValue          `protobuf:"bytes,2,opt,name=config,proto3" json:"config,omitempty"`
	ClientCapabilities *ClientCapabilities    `protobuf:"bytes,3,opt,name=client_capabilities,json=clientCapabilities,proto3" json:"client_capabilities,omitempty"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *OpenEphemeralResource_Request) Reset() {
	*x = OpenEphemeralResource_Request{}
	mi := &file_tfplugin6_proto_msgTypes[106]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OpenEphemeralResource_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OpenEphemeralResource_Request) ProtoMessage() {}

func (x *OpenEphemeralResource_Request) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[106]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OpenEphemeralResource_Request.ProtoReflect.Descriptor instead.
func (*OpenEphemeralResource_Request) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{31, 0}
}

func (x *OpenEphemeralResource_Request) GetTypeName() string {
	if x != nil {
		return x.TypeName
	}
	return ""
}

func (x *OpenEphemeralResource_Request) GetConfig() *DynamicValue {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *OpenEphemeralResource_Request) GetClientCapabilities() *ClientCapabilities {
	if x != nil {
		return x.ClientCapabilities
	}
	return nil
}

type OpenEphemeralResource_Response struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Diagnostics   []*Diagnostic          `protobuf:"bytes,1,rep,name=diagnostics,proto3" json:"diagnostics,omitempty"`
	RenewAt       *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=renew_at,json=renewAt,proto3,oneof" json:"renew_at,omitempty"`
	Result        *DynamicValue          `protobuf:"bytes,3,opt,name=result,proto3" json:"result,omitempty"`
	Private       []byte                 `protobuf:"bytes,4,opt,name=private,proto3,oneof" json:"private,omitempty"`
	Deferred      *Deferred              `protobuf:"bytes,5,opt,name=deferred,proto3" json:"deferred,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OpenEphemeralResource_Response) Reset() {
	*x = OpenEphemeralResource_Response{}
	mi := &file_tfplugin6_proto_msgTypes[107]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OpenEphemeralResource_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OpenEphemeralResource_Response) ProtoMessage() {}

func (x *OpenEphemeralResource_Response) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[107]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OpenEphemeralResource_Response.ProtoReflect.Descriptor instead.
func (*OpenEphemeralResource_Response) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{31, 1}
}

func (x *OpenEphemeralResource_Response) GetDiagnostics() []*Diagnostic {
	if x != nil {
		return x.Diagnostics
	}
	return nil
}

func (x *OpenEphemeralResource_Response) GetRenewAt() *timestamppb.Timestamp {
	if x != nil {
		return x.RenewAt
	}
	return nil
}

func (x *OpenEphemeralResource_Response) GetResult() *DynamicValue {
	if x != nil {
		return x.Result
	}
	return nil
}

func (x *OpenEphemeralResource_Response) GetPrivate() []byte {
	if x != nil {
		return x.Private
	}
	return nil
}

func (x *OpenEphemeralResource_Response) GetDeferred() *Deferred {
	if x != nil {
		return x.Deferred
	}
	return nil
}

type RenewEphemeralResource_Request struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	TypeName      string                 `protobuf:"bytes,1,opt,name=type_name,json=typeName,proto3" json:"type_name,omitempty"`
	Private       []byte                 `protobuf:"bytes,2,opt,name=private,proto3,oneof" json:"private,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RenewEphemeralResource_Request) Reset() {
	*x = RenewEphemeralResource_Request{}
	mi := &file_tfplugin6_proto_msgTypes[108]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RenewEphemeralResource_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RenewEphemeralResource_Request) ProtoMessage() {}

func (x *RenewEphemeralResource_Request) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[108]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RenewEphemeralResource_Request.ProtoReflect.Descriptor instead.
func (*RenewEphemeralResource_Request) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{32, 0}
}

func (x *RenewEphemeralResource_Request) GetTypeName() string {
	if x != nil {
		return x.TypeName
	}
	return ""
}

func (x *RenewEphemeralResource_Request) GetPrivate() []byte {
	if x != nil {
		return x.Private
	}
	return nil
}

type RenewEphemeralResource_Response struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Diagnostics   []*Diagnostic          `protobuf:"bytes,1,rep,name=diagnostics,proto3" json:"diagnostics,omitempty"`
	RenewAt       *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=renew_at,json=renewAt,proto3,oneof" json:"renew_at,omitempty"`
	Private       []byte                 `protobuf:"bytes,3,opt,name=private,proto3,oneof" json:"private,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RenewEphemeralResource_Response) Reset() {
	*x = RenewEphemeralResource_Response{}
	mi := &file_tfplugin6_proto_msgTypes[109]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RenewEphemeralResource_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RenewEphemeralResource_Response) ProtoMessage() {}

func (x *RenewEphemeralResource_Response) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[109]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RenewEphemeralResource_Response.ProtoReflect.Descriptor instead.
func (*RenewEphemeralResource_Response) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{32, 1}
}

func (x *RenewEphemeralResource_Response) GetDiagnostics() []*Diagnostic {
	if x != nil {
		return x.Diagnostics
	}
	return nil
}

func (x *RenewEphemeralResource_Response) GetRenewAt() *timestamppb.Timestamp {
	if x != nil {
		return x.RenewAt
	}
	return nil
}

func (x *RenewEphemeralResource_Response) GetPrivate() []byte {
	if x != nil {
		return x.Private
	}
	return nil
}

type CloseEphemeralResource_Request struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	TypeName      string                 `protobuf:"bytes,1,opt,name=type_name,json=typeName,proto3" json:"type_name,omitempty"`
	Private       []byte                 `protobuf:"bytes,2,opt,name=private,proto3,oneof" json:"private,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CloseEphemeralResource_Request) Reset() {
	*x = CloseEphemeralResource_Request{}
	mi := &file_tfplugin6_proto_msgTypes[110]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CloseEphemeralResource_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloseEphemeralResource_Request) ProtoMessage() {}

func (x *CloseEphemeralResource_Request) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[110]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloseEphemeralResource_Request.ProtoReflect.Descriptor instead.
func (*CloseEphemeralResource_Request) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{33, 0}
}

func (x *CloseEphemeralResource_Request) GetTypeName() string {
	if x != nil {
		return x.TypeName
	}
	return ""
}

func (x *CloseEphemeralResource_Request) GetPrivate() []byte {
	if x != nil {
		return x.Private
	}
	return nil
}

type CloseEphemeralResource_Response struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Diagnostics   []*Diagnostic          `protobuf:"bytes,1,rep,name=diagnostics,proto3" json:"diagnostics,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CloseEphemeralResource_Response) Reset() {
	*x = CloseEphemeralResource_Response{}
	mi := &file_tfplugin6_proto_msgTypes[111]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CloseEphemeralResource_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloseEphemeralResource_Response) ProtoMessage() {}

func (x *CloseEphemeralResource_Response) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[111]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloseEphemeralResource_Response.ProtoReflect.Descriptor instead.
func (*CloseEphemeralResource_Response) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{33, 1}
}

func (x *CloseEphemeralResource_Response) GetDiagnostics() []*Diagnostic {
	if x != nil {
		return x.Diagnostics
	}
	return nil
}

type GetFunctions_Request struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetFunctions_Request) Reset() {
	*x = GetFunctions_Request{}
	mi := &file_tfplugin6_proto_msgTypes[112]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetFunctions_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetFunctions_Request) ProtoMessage() {}

func (x *GetFunctions_Request) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[112]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetFunctions_Request.ProtoReflect.Descriptor instead.
func (*GetFunctions_Request) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{34, 0}
}

type GetFunctions_Response struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// functions is a mapping of function names to definitions.
	Functions map[string]*Function `protobuf:"bytes,1,rep,name=functions,proto3" json:"functions,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// diagnostics is any warnings or errors.
	Diagnostics   []*Diagnostic `protobuf:"bytes,2,rep,name=diagnostics,proto3" json:"diagnostics,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetFunctions_Response) Reset() {
	*x = GetFunctions_Response{}
	mi := &file_tfplugin6_proto_msgTypes[113]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetFunctions_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetFunctions_Response) ProtoMessage() {}

func (x *GetFunctions_Response) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[113]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetFunctions_Response.ProtoReflect.Descriptor instead.
func (*GetFunctions_Response) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{34, 1}
}

func (x *GetFunctions_Response) GetFunctions() map[string]*Function {
	if x != nil {
		return x.Functions
	}
	return nil
}

func (x *GetFunctions_Response) GetDiagnostics() []*Diagnostic {
	if x != nil {
		return x.Diagnostics
	}
	return nil
}

type CallFunction_Request struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Name          string                 `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Arguments     []*DynamicValue        `protobuf:"bytes,2,rep,name=arguments,proto3" json:"arguments,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CallFunction_Request) Reset() {
	*x = CallFunction_Request{}
	mi := &file_tfplugin6_proto_msgTypes[115]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CallFunction_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CallFunction_Request) ProtoMessage() {}

func (x *CallFunction_Request) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[115]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CallFunction_Request.ProtoReflect.Descriptor instead.
func (*CallFunction_Request) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{35, 0}
}

func (x *CallFunction_Request) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CallFunction_Request) GetArguments() []*DynamicValue {
	if x != nil {
		return x.Arguments
	}
	return nil
}

type CallFunction_Response struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Result        *DynamicValue          `protobuf:"bytes,1,opt,name=result,proto3" json:"result,omitempty"`
	Error         *FunctionError         `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CallFunction_Response) Reset() {
	*x = CallFunction_Response{}
	mi := &file_tfplugin6_proto_msgTypes[116]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CallFunction_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CallFunction_Response) ProtoMessage() {}

func (x *CallFunction_Response) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[116]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CallFunction_Response.ProtoReflect.Descriptor instead.
func (*CallFunction_Response) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{35, 1}
}

func (x *CallFunction_Response) GetResult() *DynamicValue {
	if x != nil {
		return x.Result
	}
	return nil
}

func (x *CallFunction_Response) GetError() *FunctionError {
	if x != nil {
		return x.Error
	}
	return nil
}

type ListResource_Request struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// type_name is the list resource type name.
	TypeName string `protobuf:"bytes,1,opt,name=type_name,json=typeName,proto3" json:"type_name,omitempty"`
	// configuration is the list ConfigSchema-based configuration data.
	Config *DynamicValue `protobuf:"bytes,2,opt,name=config,proto3" json:"config,omitempty"`
	// when include_resource_object is set to true, the provider should
	// include the full resource object for each result
	IncludeResourceObject bool `protobuf:"varint,3,opt,name=include_resource_object,json=includeResourceObject,proto3" json:"include_resource_object,omitempty"`
	// The maximum number of results that Terraform is expecting.
	// The stream will stop, once this limit is reached.
	Limit         int64 `protobuf:"varint,4,opt,name=limit,proto3" json:"limit,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListResource_Request) Reset() {
	*x = ListResource_Request{}
	mi := &file_tfplugin6_proto_msgTypes[117]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListResource_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListResource_Request) ProtoMessage() {}

func (x *ListResource_Request) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[117]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListResource_Request.ProtoReflect.Descriptor instead.
func (*ListResource_Request) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{36, 0}
}

func (x *ListResource_Request) GetTypeName() string {
	if x != nil {
		return x.TypeName
	}
	return ""
}

func (x *ListResource_Request) GetConfig() *DynamicValue {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *ListResource_Request) GetIncludeResourceObject() bool {
	if x != nil {
		return x.IncludeResourceObject
	}
	return false
}

func (x *ListResource_Request) GetLimit() int64 {
	if x != nil {
		return x.Limit
	}
	return 0
}

type ListResource_Event struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// identity is the resource identity data of the resource instance.
	Identity *ResourceIdentityData `protobuf:"bytes,1,opt,name=identity,proto3" json:"identity,omitempty"`
	// display_name can be displayed in a UI to make it easier for humans to identify a resource
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// optional resource object which can be useful when combining list blocks in configuration
	ResourceObject *DynamicValue `protobuf:"bytes,3,opt,name=resource_object,json=resourceObject,proto3,oneof" json:"resource_object,omitempty"`
	// A warning or error diagnostics for this event
	Diagnostic    []*Diagnostic `protobuf:"bytes,4,rep,name=diagnostic,proto3" json:"diagnostic,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListResource_Event) Reset() {
	*x = ListResource_Event{}
	mi := &file_tfplugin6_proto_msgTypes[118]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListResource_Event) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListResource_Event) ProtoMessage() {}

func (x *ListResource_Event) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[118]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListResource_Event.ProtoReflect.Descriptor instead.
func (*ListResource_Event) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{36, 1}
}

func (x *ListResource_Event) GetIdentity() *ResourceIdentityData {
	if x != nil {
		return x.Identity
	}
	return nil
}

func (x *ListResource_Event) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *ListResource_Event) GetResourceObject() *DynamicValue {
	if x != nil {
		return x.ResourceObject
	}
	return nil
}

func (x *ListResource_Event) GetDiagnostic() []*Diagnostic {
	if x != nil {
		return x.Diagnostic
	}
	return nil
}

type ValidateListResourceConfig_Request struct {
	state                 protoimpl.MessageState `protogen:"open.v1"`
	TypeName              string                 `protobuf:"bytes,1,opt,name=type_name,json=typeName,proto3" json:"type_name,omitempty"`
	Config                *DynamicValue          `protobuf:"bytes,2,opt,name=config,proto3" json:"config,omitempty"`
	IncludeResourceObject *DynamicValue          `protobuf:"bytes,3,opt,name=include_resource_object,json=includeResourceObject,proto3" json:"include_resource_object,omitempty"`
	Limit                 *DynamicValue          `protobuf:"bytes,4,opt,name=limit,proto3" json:"limit,omitempty"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *ValidateListResourceConfig_Request) Reset() {
	*x = ValidateListResourceConfig_Request{}
	mi := &file_tfplugin6_proto_msgTypes[119]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ValidateListResourceConfig_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValidateListResourceConfig_Request) ProtoMessage() {}

func (x *ValidateListResourceConfig_Request) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[119]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValidateListResourceConfig_Request.ProtoReflect.Descriptor instead.
func (*ValidateListResourceConfig_Request) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{37, 0}
}

func (x *ValidateListResourceConfig_Request) GetTypeName() string {
	if x != nil {
		return x.TypeName
	}
	return ""
}

func (x *ValidateListResourceConfig_Request) GetConfig() *DynamicValue {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *ValidateListResourceConfig_Request) GetIncludeResourceObject() *DynamicValue {
	if x != nil {
		return x.IncludeResourceObject
	}
	return nil
}

func (x *ValidateListResourceConfig_Request) GetLimit() *DynamicValue {
	if x != nil {
		return x.Limit
	}
	return nil
}

type ValidateListResourceConfig_Response struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Diagnostics   []*Diagnostic          `protobuf:"bytes,1,rep,name=diagnostics,proto3" json:"diagnostics,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ValidateListResourceConfig_Response) Reset() {
	*x = ValidateListResourceConfig_Response{}
	mi := &file_tfplugin6_proto_msgTypes[120]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ValidateListResourceConfig_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValidateListResourceConfig_Response) ProtoMessage() {}

func (x *ValidateListResourceConfig_Response) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[120]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValidateListResourceConfig_Response.ProtoReflect.Descriptor instead.
func (*ValidateListResourceConfig_Response) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{37, 1}
}

func (x *ValidateListResourceConfig_Response) GetDiagnostics() []*Diagnostic {
	if x != nil {
		return x.Diagnostics
	}
	return nil
}

type ValidateStateStore_Request struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	TypeName      string                 `protobuf:"bytes,1,opt,name=type_name,json=typeName,proto3" json:"type_name,omitempty"`
	Config        *DynamicValue          `protobuf:"bytes,2,opt,name=config,proto3" json:"config,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ValidateStateStore_Request) Reset() {
	*x = ValidateStateStore_Request{}
	mi := &file_tfplugin6_proto_msgTypes[121]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ValidateStateStore_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValidateStateStore_Request) ProtoMessage() {}

func (x *ValidateStateStore_Request) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[121]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValidateStateStore_Request.ProtoReflect.Descriptor instead.
func (*ValidateStateStore_Request) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{38, 0}
}

func (x *ValidateStateStore_Request) GetTypeName() string {
	if x != nil {
		return x.TypeName
	}
	return ""
}

func (x *ValidateStateStore_Request) GetConfig() *DynamicValue {
	if x != nil {
		return x.Config
	}
	return nil
}

type ValidateStateStore_Response struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Diagnostics   []*Diagnostic          `protobuf:"bytes,1,rep,name=diagnostics,proto3" json:"diagnostics,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ValidateStateStore_Response) Reset() {
	*x = ValidateStateStore_Response{}
	mi := &file_tfplugin6_proto_msgTypes[122]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ValidateStateStore_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValidateStateStore_Response) ProtoMessage() {}

func (x *ValidateStateStore_Response) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[122]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValidateStateStore_Response.ProtoReflect.Descriptor instead.
func (*ValidateStateStore_Response) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{38, 1}
}

func (x *ValidateStateStore_Response) GetDiagnostics() []*Diagnostic {
	if x != nil {
		return x.Diagnostics
	}
	return nil
}

type ConfigureStateStore_Request struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	TypeName      string                 `protobuf:"bytes,1,opt,name=type_name,json=typeName,proto3" json:"type_name,omitempty"`
	Config        *DynamicValue          `protobuf:"bytes,2,opt,name=config,proto3" json:"config,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ConfigureStateStore_Request) Reset() {
	*x = ConfigureStateStore_Request{}
	mi := &file_tfplugin6_proto_msgTypes[123]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ConfigureStateStore_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConfigureStateStore_Request) ProtoMessage() {}

func (x *ConfigureStateStore_Request) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[123]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConfigureStateStore_Request.ProtoReflect.Descriptor instead.
func (*ConfigureStateStore_Request) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{39, 0}
}

func (x *ConfigureStateStore_Request) GetTypeName() string {
	if x != nil {
		return x.TypeName
	}
	return ""
}

func (x *ConfigureStateStore_Request) GetConfig() *DynamicValue {
	if x != nil {
		return x.Config
	}
	return nil
}

type ConfigureStateStore_Response struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Diagnostics   []*Diagnostic          `protobuf:"bytes,1,rep,name=diagnostics,proto3" json:"diagnostics,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ConfigureStateStore_Response) Reset() {
	*x = ConfigureStateStore_Response{}
	mi := &file_tfplugin6_proto_msgTypes[124]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ConfigureStateStore_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConfigureStateStore_Response) ProtoMessage() {}

func (x *ConfigureStateStore_Response) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[124]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConfigureStateStore_Response.ProtoReflect.Descriptor instead.
func (*ConfigureStateStore_Response) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{39, 1}
}

func (x *ConfigureStateStore_Response) GetDiagnostics() []*Diagnostic {
	if x != nil {
		return x.Diagnostics
	}
	return nil
}

type GetStates_Request struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	TypeName      string                 `protobuf:"bytes,1,opt,name=type_name,json=typeName,proto3" json:"type_name,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetStates_Request) Reset() {
	*x = GetStates_Request{}
	mi := &file_tfplugin6_proto_msgTypes[125]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetStates_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetStates_Request) ProtoMessage() {}

func (x *GetStates_Request) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[125]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetStates_Request.ProtoReflect.Descriptor instead.
func (*GetStates_Request) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{40, 0}
}

func (x *GetStates_Request) GetTypeName() string {
	if x != nil {
		return x.TypeName
	}
	return ""
}

type GetStates_Response struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	StateId       []string               `protobuf:"bytes,1,rep,name=state_id,json=stateId,proto3" json:"state_id,omitempty"`
	Diagnostics   []*Diagnostic          `protobuf:"bytes,2,rep,name=diagnostics,proto3" json:"diagnostics,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetStates_Response) Reset() {
	*x = GetStates_Response{}
	mi := &file_tfplugin6_proto_msgTypes[126]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetStates_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetStates_Response) ProtoMessage() {}

func (x *GetStates_Response) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[126]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetStates_Response.ProtoReflect.Descriptor instead.
func (*GetStates_Response) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{40, 1}
}

func (x *GetStates_Response) GetStateId() []string {
	if x != nil {
		return x.StateId
	}
	return nil
}

func (x *GetStates_Response) GetDiagnostics() []*Diagnostic {
	if x != nil {
		return x.Diagnostics
	}
	return nil
}

type DeleteState_Request struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	TypeName      string                 `protobuf:"bytes,1,opt,name=type_name,json=typeName,proto3" json:"type_name,omitempty"`
	StateId       string                 `protobuf:"bytes,2,opt,name=state_id,json=stateId,proto3" json:"state_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DeleteState_Request) Reset() {
	*x = DeleteState_Request{}
	mi := &file_tfplugin6_proto_msgTypes[127]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteState_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteState_Request) ProtoMessage() {}

func (x *DeleteState_Request) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[127]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteState_Request.ProtoReflect.Descriptor instead.
func (*DeleteState_Request) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{41, 0}
}

func (x *DeleteState_Request) GetTypeName() string {
	if x != nil {
		return x.TypeName
	}
	return ""
}

func (x *DeleteState_Request) GetStateId() string {
	if x != nil {
		return x.StateId
	}
	return ""
}

type DeleteState_Response struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Diagnostics   []*Diagnostic          `protobuf:"bytes,1,rep,name=diagnostics,proto3" json:"diagnostics,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DeleteState_Response) Reset() {
	*x = DeleteState_Response{}
	mi := &file_tfplugin6_proto_msgTypes[128]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteState_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteState_Response) ProtoMessage() {}

func (x *DeleteState_Response) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[128]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteState_Response.ProtoReflect.Descriptor instead.
func (*DeleteState_Response) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{41, 1}
}

func (x *DeleteState_Response) GetDiagnostics() []*Diagnostic {
	if x != nil {
		return x.Diagnostics
	}
	return nil
}

type PlanAction_Request struct {
	state      protoimpl.MessageState `protogen:"open.v1"`
	ActionType string                 `protobuf:"bytes,1,opt,name=action_type,json=actionType,proto3" json:"action_type,omitempty"`
	// config of the action, based on the schema of the actual action
	Config *DynamicValue `protobuf:"bytes,2,opt,name=config,proto3" json:"config,omitempty"`
	// metadata
	ClientCapabilities *ClientCapabilities `protobuf:"bytes,3,opt,name=client_capabilities,json=clientCapabilities,proto3" json:"client_capabilities,omitempty"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *PlanAction_Request) Reset() {
	*x = PlanAction_Request{}
	mi := &file_tfplugin6_proto_msgTypes[129]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PlanAction_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlanAction_Request) ProtoMessage() {}

func (x *PlanAction_Request) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[129]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlanAction_Request.ProtoReflect.Descriptor instead.
func (*PlanAction_Request) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{42, 0}
}

func (x *PlanAction_Request) GetActionType() string {
	if x != nil {
		return x.ActionType
	}
	return ""
}

func (x *PlanAction_Request) GetConfig() *DynamicValue {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *PlanAction_Request) GetClientCapabilities() *ClientCapabilities {
	if x != nil {
		return x.ClientCapabilities
	}
	return nil
}

type PlanAction_Response struct {
	state       protoimpl.MessageState `protogen:"open.v1"`
	Diagnostics []*Diagnostic          `protobuf:"bytes,1,rep,name=diagnostics,proto3" json:"diagnostics,omitempty"`
	// metadata
	Deferred      *Deferred `protobuf:"bytes,2,opt,name=deferred,proto3" json:"deferred,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PlanAction_Response) Reset() {
	*x = PlanAction_Response{}
	mi := &file_tfplugin6_proto_msgTypes[130]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PlanAction_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlanAction_Response) ProtoMessage() {}

func (x *PlanAction_Response) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[130]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlanAction_Response.ProtoReflect.Descriptor instead.
func (*PlanAction_Response) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{42, 1}
}

func (x *PlanAction_Response) GetDiagnostics() []*Diagnostic {
	if x != nil {
		return x.Diagnostics
	}
	return nil
}

func (x *PlanAction_Response) GetDeferred() *Deferred {
	if x != nil {
		return x.Deferred
	}
	return nil
}

type InvokeAction_Request struct {
	state      protoimpl.MessageState `protogen:"open.v1"`
	ActionType string                 `protobuf:"bytes,1,opt,name=action_type,json=actionType,proto3" json:"action_type,omitempty"`
	// response from the plan
	Config *DynamicValue `protobuf:"bytes,2,opt,name=config,proto3" json:"config,omitempty"`
	// metadata
	ClientCapabilities *ClientCapabilities `protobuf:"bytes,3,opt,name=client_capabilities,json=clientCapabilities,proto3" json:"client_capabilities,omitempty"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *InvokeAction_Request) Reset() {
	*x = InvokeAction_Request{}
	mi := &file_tfplugin6_proto_msgTypes[131]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *InvokeAction_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InvokeAction_Request) ProtoMessage() {}

func (x *InvokeAction_Request) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[131]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InvokeAction_Request.ProtoReflect.Descriptor instead.
func (*InvokeAction_Request) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{43, 0}
}

func (x *InvokeAction_Request) GetActionType() string {
	if x != nil {
		return x.ActionType
	}
	return ""
}

func (x *InvokeAction_Request) GetConfig() *DynamicValue {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *InvokeAction_Request) GetClientCapabilities() *ClientCapabilities {
	if x != nil {
		return x.ClientCapabilities
	}
	return nil
}

type InvokeAction_Event struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Types that are valid to be assigned to Type:
	//
	//	*InvokeAction_Event_Progress_
	//	*InvokeAction_Event_Completed_
	Type          isInvokeAction_Event_Type `protobuf_oneof:"type"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *InvokeAction_Event) Reset() {
	*x = InvokeAction_Event{}
	mi := &file_tfplugin6_proto_msgTypes[132]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *InvokeAction_Event) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InvokeAction_Event) ProtoMessage() {}

func (x *InvokeAction_Event) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[132]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InvokeAction_Event.ProtoReflect.Descriptor instead.
func (*InvokeAction_Event) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{43, 1}
}

func (x *InvokeAction_Event) GetType() isInvokeAction_Event_Type {
	if x != nil {
		return x.Type
	}
	return nil
}

func (x *InvokeAction_Event) GetProgress() *InvokeAction_Event_Progress {
	if x != nil {
		if x, ok := x.Type.(*InvokeAction_Event_Progress_); ok {
			return x.Progress
		}
	}
	return nil
}

func (x *InvokeAction_Event) GetCompleted() *InvokeAction_Event_Completed {
	if x != nil {
		if x, ok := x.Type.(*InvokeAction_Event_Completed_); ok {
			return x.Completed
		}
	}
	return nil
}

type isInvokeAction_Event_Type interface {
	isInvokeAction_Event_Type()
}

type InvokeAction_Event_Progress_ struct {
	Progress *InvokeAction_Event_Progress `protobuf:"bytes,1,opt,name=progress,proto3,oneof"`
}

type InvokeAction_Event_Completed_ struct {
	Completed *InvokeAction_Event_Completed `protobuf:"bytes,2,opt,name=completed,proto3,oneof"`
}

func (*InvokeAction_Event_Progress_) isInvokeAction_Event_Type() {}

func (*InvokeAction_Event_Completed_) isInvokeAction_Event_Type() {}

type InvokeAction_Event_Progress struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// message to be printed in the console / HCPT
	Message       string `protobuf:"bytes,1,opt,name=message,proto3" json:"message,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *InvokeAction_Event_Progress) Reset() {
	*x = InvokeAction_Event_Progress{}
	mi := &file_tfplugin6_proto_msgTypes[133]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *InvokeAction_Event_Progress) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InvokeAction_Event_Progress) ProtoMessage() {}

func (x *InvokeAction_Event_Progress) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[133]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InvokeAction_Event_Progress.ProtoReflect.Descriptor instead.
func (*InvokeAction_Event_Progress) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{43, 1, 0}
}

func (x *InvokeAction_Event_Progress) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

type InvokeAction_Event_Completed struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Diagnostics   []*Diagnostic          `protobuf:"bytes,1,rep,name=diagnostics,proto3" json:"diagnostics,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *InvokeAction_Event_Completed) Reset() {
	*x = InvokeAction_Event_Completed{}
	mi := &file_tfplugin6_proto_msgTypes[134]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *InvokeAction_Event_Completed) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InvokeAction_Event_Completed) ProtoMessage() {}

func (x *InvokeAction_Event_Completed) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[134]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InvokeAction_Event_Completed.ProtoReflect.Descriptor instead.
func (*InvokeAction_Event_Completed) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{43, 1, 1}
}

func (x *InvokeAction_Event_Completed) GetDiagnostics() []*Diagnostic {
	if x != nil {
		return x.Diagnostics
	}
	return nil
}

type ValidateActionConfig_Request struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	TypeName      string                 `protobuf:"bytes,1,opt,name=type_name,json=typeName,proto3" json:"type_name,omitempty"`
	Config        *DynamicValue          `protobuf:"bytes,2,opt,name=config,proto3" json:"config,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ValidateActionConfig_Request) Reset() {
	*x = ValidateActionConfig_Request{}
	mi := &file_tfplugin6_proto_msgTypes[135]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ValidateActionConfig_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValidateActionConfig_Request) ProtoMessage() {}

func (x *ValidateActionConfig_Request) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[135]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValidateActionConfig_Request.ProtoReflect.Descriptor instead.
func (*ValidateActionConfig_Request) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{44, 0}
}

func (x *ValidateActionConfig_Request) GetTypeName() string {
	if x != nil {
		return x.TypeName
	}
	return ""
}

func (x *ValidateActionConfig_Request) GetConfig() *DynamicValue {
	if x != nil {
		return x.Config
	}
	return nil
}

type ValidateActionConfig_Response struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Diagnostics   []*Diagnostic          `protobuf:"bytes,1,rep,name=diagnostics,proto3" json:"diagnostics,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ValidateActionConfig_Response) Reset() {
	*x = ValidateActionConfig_Response{}
	mi := &file_tfplugin6_proto_msgTypes[136]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ValidateActionConfig_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValidateActionConfig_Response) ProtoMessage() {}

func (x *ValidateActionConfig_Response) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[136]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValidateActionConfig_Response.ProtoReflect.Descriptor instead.
func (*ValidateActionConfig_Response) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{44, 1}
}

func (x *ValidateActionConfig_Response) GetDiagnostics() []*Diagnostic {
	if x != nil {
		return x.Diagnostics
	}
	return nil
}

var File_tfplugin6_proto protoreflect.FileDescriptor

const file_tfplugin6_proto_rawDesc = "" +
	"\n" +
	"\x0ftfplugin6.proto\x12\ttfplugin6\x1a\x1fgoogle/protobuf/timestamp.proto\"<\n" +
	"\fDynamicValue\x12\x18\n" +
	"\amsgpack\x18\x01 \x01(\fR\amsgpack\x12\x12\n" +
	"\x04json\x18\x02 \x01(\fR\x04json\"\xe3\x01\n" +
	"\n" +
	"Diagnostic\x12:\n" +
	"\bseverity\x18\x01 \x01(\x0e2\x1e.tfplugin6.Diagnostic.SeverityR\bseverity\x12\x18\n" +
	"\asummary\x18\x02 \x01(\tR\asummary\x12\x16\n" +
	"\x06detail\x18\x03 \x01(\tR\x06detail\x126\n" +
	"\tattribute\x18\x04 \x01(\v2\x18.tfplugin6.AttributePathR\tattribute\"/\n" +
	"\bSeverity\x12\v\n" +
	"\aINVALID\x10\x00\x12\t\n" +
	"\x05ERROR\x10\x01\x12\v\n" +
	"\aWARNING\x10\x02\"k\n" +
	"\rFunctionError\x12\x12\n" +
	"\x04text\x18\x01 \x01(\tR\x04text\x120\n" +
	"\x11function_argument\x18\x02 \x01(\x03H\x00R\x10functionArgument\x88\x01\x01B\x14\n" +
	"\x12_function_argument\"\xdc\x01\n" +
	"\rAttributePath\x123\n" +
	"\x05steps\x18\x01 \x03(\v2\x1d.tfplugin6.AttributePath.StepR\x05steps\x1a\x95\x01\n" +
	"\x04Step\x12'\n" +
	"\x0eattribute_name\x18\x01 \x01(\tH\x00R\rattributeName\x12.\n" +
	"\x12element_key_string\x18\x02 \x01(\tH\x00R\x10elementKeyString\x12(\n" +
	"\x0felement_key_int\x18\x03 \x01(\x03H\x00R\relementKeyIntB\n" +
	"\n" +
	"\bselector\";\n" +
	"\fStopProvider\x1a\t\n" +
	"\aRequest\x1a \n" +
	"\bResponse\x12\x14\n" +
	"\x05Error\x18\x01 \x01(\tR\x05Error\"\x96\x01\n" +
	"\bRawState\x12\x12\n" +
	"\x04json\x18\x01 \x01(\fR\x04json\x12:\n" +
	"\aflatmap\x18\x02 \x03(\v2 .tfplugin6.RawState.FlatmapEntryR\aflatmap\x1a:\n" +
	"\fFlatmapEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01\"\xd8\x02\n" +
	"\x16ResourceIdentitySchema\x12\x18\n" +
	"\aversion\x18\x01 \x01(\x03R\aversion\x12d\n" +
	"\x13identity_attributes\x18\x02 \x03(\v23.tfplugin6.ResourceIdentitySchema.IdentityAttributeR\x12identityAttributes\x1a\xbd\x01\n" +
	"\x11IdentityAttribute\x12\x12\n" +
	"\x04name\x18\x01 \x01(\tR\x04name\x12\x12\n" +
	"\x04type\x18\x02 \x01(\fR\x04type\x12.\n" +
	"\x13required_for_import\x18\x03 \x01(\bR\x11requiredForImport\x12.\n" +
	"\x13optional_for_import\x18\x04 \x01(\bR\x11optionalForImport\x12 \n" +
	"\vdescription\x18\x05 \x01(\tR\vdescription\"T\n" +
	"\x14ResourceIdentityData\x12<\n" +
	"\ridentity_data\x18\x01 \x01(\v2\x17.tfplugin6.DynamicValueR\fidentityData\"9\n" +
	"\fActionSchema\x12)\n" +
	"\x06schema\x18\x01 \x01(\v2\x11.tfplugin6.SchemaR\x06schema\"\xb4\n" +
	"\n" +
	"\x06Schema\x12\x18\n" +
	"\aversion\x18\x01 \x01(\x03R\aversion\x12-\n" +
	"\x05block\x18\x02 \x01(\v2\x17.tfplugin6.Schema.BlockR\x05block\x1a\xa2\x02\n" +
	"\x05Block\x12\x18\n" +
	"\aversion\x18\x01 \x01(\x03R\aversion\x12;\n" +
	"\n" +
	"attributes\x18\x02 \x03(\v2\x1b.tfplugin6.Schema.AttributeR\n" +
	"attributes\x12>\n" +
	"\vblock_types\x18\x03 \x03(\v2\x1d.tfplugin6.Schema.NestedBlockR\n" +
	"blockTypes\x12 \n" +
	"\vdescription\x18\x04 \x01(\tR\vdescription\x12@\n" +
	"\x10description_kind\x18\x05 \x01(\x0e2\x15.tfplugin6.StringKindR\x0fdescriptionKind\x12\x1e\n" +
	"\n" +
	"deprecated\x18\x06 \x01(\bR\n" +
	"deprecated\x1a\x83\x03\n" +
	"\tAttribute\x12\x12\n" +
	"\x04name\x18\x01 \x01(\tR\x04name\x12\x12\n" +
	"\x04type\x18\x02 \x01(\fR\x04type\x129\n" +
	"\vnested_type\x18\n" +
	" \x01(\v2\x18.tfplugin6.Schema.ObjectR\n" +
	"nestedType\x12 \n" +
	"\vdescription\x18\x03 \x01(\tR\vdescription\x12\x1a\n" +
	"\brequired\x18\x04 \x01(\bR\brequired\x12\x1a\n" +
	"\boptional\x18\x05 \x01(\bR\boptional\x12\x1a\n" +
	"\bcomputed\x18\x06 \x01(\bR\bcomputed\x12\x1c\n" +
	"\tsensitive\x18\a \x01(\bR\tsensitive\x12@\n" +
	"\x10description_kind\x18\b \x01(\x0e2\x15.tfplugin6.StringKindR\x0fdescriptionKind\x12\x1e\n" +
	"\n" +
	"deprecated\x18\t \x01(\bR\n" +
	"deprecated\x12\x1d\n" +
	"\n" +
	"write_only\x18\v \x01(\bR\twriteOnly\x1a\xa7\x02\n" +
	"\vNestedBlock\x12\x1b\n" +
	"\ttype_name\x18\x01 \x01(\tR\btypeName\x12-\n" +
	"\x05block\x18\x02 \x01(\v2\x17.tfplugin6.Schema.BlockR\x05block\x12C\n" +
	"\anesting\x18\x03 \x01(\x0e2).tfplugin6.Schema.NestedBlock.NestingModeR\anesting\x12\x1b\n" +
	"\tmin_items\x18\x04 \x01(\x03R\bminItems\x12\x1b\n" +
	"\tmax_items\x18\x05 \x01(\x03R\bmaxItems\"M\n" +
	"\vNestingMode\x12\v\n" +
	"\aINVALID\x10\x00\x12\n" +
	"\n" +
	"\x06SINGLE\x10\x01\x12\b\n" +
	"\x04LIST\x10\x02\x12\a\n" +
	"\x03SET\x10\x03\x12\a\n" +
	"\x03MAP\x10\x04\x12\t\n" +
	"\x05GROUP\x10\x05\x1a\x8b\x02\n" +
	"\x06Object\x12;\n" +
	"\n" +
	"attributes\x18\x01 \x03(\v2\x1b.tfplugin6.Schema.AttributeR\n" +
	"attributes\x12>\n" +
	"\anesting\x18\x03 \x01(\x0e2$.tfplugin6.Schema.Object.NestingModeR\anesting\x12\x1f\n" +
	"\tmin_items\x18\x04 \x01(\x03B\x02\x18\x01R\bminItems\x12\x1f\n" +
	"\tmax_items\x18\x05 \x01(\x03B\x02\x18\x01R\bmaxItems\"B\n" +
	"\vNestingMode\x12\v\n" +
	"\aINVALID\x10\x00\x12\n" +
	"\n" +
	"\x06SINGLE\x10\x01\x12\b\n" +
	"\x04LIST\x10\x02\x12\a\n" +
	"\x03SET\x10\x03\x12\a\n" +
	"\x03MAP\x10\x04\"\x8e\x05\n" +
	"\bFunction\x12=\n" +
	"\n" +
	"parameters\x18\x01 \x03(\v2\x1d.tfplugin6.Function.ParameterR\n" +
	"parameters\x12L\n" +
	"\x12variadic_parameter\x18\x02 \x01(\v2\x1d.tfplugin6.Function.ParameterR\x11variadicParameter\x122\n" +
	"\x06return\x18\x03 \x01(\v2\x1a.tfplugin6.Function.ReturnR\x06return\x12\x18\n" +
	"\asummary\x18\x04 \x01(\tR\asummary\x12 \n" +
	"\vdescription\x18\x05 \x01(\tR\vdescription\x12@\n" +
	"\x10description_kind\x18\x06 \x01(\x0e2\x15.tfplugin6.StringKindR\x0fdescriptionKind\x12/\n" +
	"\x13deprecation_message\x18\a \x01(\tR\x12deprecationMessage\x1a\xf3\x01\n" +
	"\tParameter\x12\x12\n" +
	"\x04name\x18\x01 \x01(\tR\x04name\x12\x12\n" +
	"\x04type\x18\x02 \x01(\fR\x04type\x12(\n" +
	"\x10allow_null_value\x18\x03 \x01(\bR\x0eallowNullValue\x120\n" +
	"\x14allow_unknown_values\x18\x04 \x01(\bR\x12allowUnknownValues\x12 \n" +
	"\vdescription\x18\x05 \x01(\tR\vdescription\x12@\n" +
	"\x10description_kind\x18\x06 \x01(\x0e2\x15.tfplugin6.StringKindR\x0fdescriptionKind\x1a\x1c\n" +
	"\x06Return\x12\x12\n" +
	"\x04type\x18\x01 \x01(\fR\x04type\"\xe2\x01\n" +
	"\x12ServerCapabilities\x12!\n" +
	"\fplan_destroy\x18\x01 \x01(\bR\vplanDestroy\x12?\n" +
	"\x1cget_provider_schema_optional\x18\x02 \x01(\bR\x19getProviderSchemaOptional\x12.\n" +
	"\x13move_resource_state\x18\x03 \x01(\bR\x11moveResourceState\x128\n" +
	"\x18generate_resource_config\x18\x04 \x01(\bR\x16generateResourceConfig\"\x82\x01\n" +
	"\x12ClientCapabilities\x12)\n" +
	"\x10deferral_allowed\x18\x01 \x01(\bR\x0fdeferralAllowed\x12A\n" +
	"\x1dwrite_only_attributes_allowed\x18\x02 \x01(\bR\x1awriteOnlyAttributesAllowed\"\xa2\x01\n" +
	"\bDeferred\x122\n" +
	"\x06reason\x18\x01 \x01(\x0e2\x1a.tfplugin6.Deferred.ReasonR\x06reason\"b\n" +
	"\x06Reason\x12\v\n" +
	"\aUNKNOWN\x10\x00\x12\x1b\n" +
	"\x17RESOURCE_CONFIG_UNKNOWN\x10\x01\x12\x1b\n" +
	"\x17PROVIDER_CONFIG_UNKNOWN\x10\x02\x12\x11\n" +
	"\rABSENT_PREREQ\x10\x03\"\x9d\b\n" +
	"\vGetMetadata\x1a\t\n" +
	"\aRequest\x1a\xad\x05\n" +
	"\bResponse\x12N\n" +
	"\x13server_capabilities\x18\x01 \x01(\v2\x1d.tfplugin6.ServerCapabilitiesR\x12serverCapabilities\x127\n" +
	"\vdiagnostics\x18\x02 \x03(\v2\x15.tfplugin6.DiagnosticR\vdiagnostics\x12L\n" +
	"\fdata_sources\x18\x03 \x03(\v2).tfplugin6.GetMetadata.DataSourceMetadataR\vdataSources\x12E\n" +
	"\tresources\x18\x04 \x03(\v2'.tfplugin6.GetMetadata.ResourceMetadataR\tresources\x12E\n" +
	"\tfunctions\x18\x05 \x03(\v2'.tfplugin6.GetMetadata.FunctionMetadataR\tfunctions\x12Y\n" +
	"\x13ephemeral_resources\x18\x06 \x03(\v2(.tfplugin6.GetMetadata.EphemeralMetadataR\x12ephemeralResources\x12R\n" +
	"\x0elist_resources\x18\a \x03(\v2+.tfplugin6.GetMetadata.ListResourceMetadataR\rlistResources\x12L\n" +
	"\fstate_stores\x18\b \x03(\v2).tfplugin6.GetMetadata.StateStoreMetadataR\vstateStores\x12?\n" +
	"\aactions\x18\t \x03(\v2%.tfplugin6.GetMetadata.ActionMetadataR\aactions\x1a0\n" +
	"\x11EphemeralMetadata\x12\x1b\n" +
	"\ttype_name\x18\x01 \x01(\tR\btypeName\x1a&\n" +
	"\x10FunctionMetadata\x12\x12\n" +
	"\x04name\x18\x01 \x01(\tR\x04name\x1a1\n" +
	"\x12DataSourceMetadata\x12\x1b\n" +
	"\ttype_name\x18\x01 \x01(\tR\btypeName\x1a/\n" +
	"\x10ResourceMetadata\x12\x1b\n" +
	"\ttype_name\x18\x01 \x01(\tR\btypeName\x1a3\n" +
	"\x14ListResourceMetadata\x12\x1b\n" +
	"\ttype_name\x18\x01 \x01(\tR\btypeName\x1a1\n" +
	"\x12StateStoreMetadata\x12\x1b\n" +
	"\ttype_name\x18\x01 \x01(\tR\btypeName\x1a-\n" +
	"\x0eActionMetadata\x12\x1b\n" +
	"\ttype_name\x18\x01 \x01(\tR\btypeName\"\xfd\f\n" +
	"\x11GetProviderSchema\x1a\t\n" +
	"\aRequest\x1a\xdc\f\n" +
	"\bResponse\x12-\n" +
	"\bprovider\x18\x01 \x01(\v2\x11.tfplugin6.SchemaR\bprovider\x12e\n" +
	"\x10resource_schemas\x18\x02 \x03(\v2:.tfplugin6.GetProviderSchema.Response.ResourceSchemasEntryR\x0fresourceSchemas\x12l\n" +
	"\x13data_source_schemas\x18\x03 \x03(\v2<.tfplugin6.GetProviderSchema.Response.DataSourceSchemasEntryR\x11dataSourceSchemas\x12R\n" +
	"\tfunctions\x18\a \x03(\v24.tfplugin6.GetProviderSchema.Response.FunctionsEntryR\tfunctions\x12\x81\x01\n" +
	"\x1aephemeral_resource_schemas\x18\b \x03(\v2C.tfplugin6.GetProviderSchema.Response.EphemeralResourceSchemasEntryR\x18ephemeralResourceSchemas\x12r\n" +
	"\x15list_resource_schemas\x18\t \x03(\v2>.tfplugin6.GetProviderSchema.Response.ListResourceSchemasEntryR\x13listResourceSchemas\x12l\n" +
	"\x13state_store_schemas\x18\n" +
	" \x03(\v2<.tfplugin6.GetProviderSchema.Response.StateStoreSchemasEntryR\x11stateStoreSchemas\x12_\n" +
	"\x0eaction_schemas\x18\v \x03(\v28.tfplugin6.GetProviderSchema.Response.ActionSchemasEntryR\ractionSchemas\x127\n" +
	"\vdiagnostics\x18\x04 \x03(\v2\x15.tfplugin6.DiagnosticR\vdiagnostics\x126\n" +
	"\rprovider_meta\x18\x05 \x01(\v2\x11.tfplugin6.SchemaR\fproviderMeta\x12N\n" +
	"\x13server_capabilities\x18\x06 \x01(\v2\x1d.tfplugin6.ServerCapabilitiesR\x12serverCapabilities\x1aU\n" +
	"\x14ResourceSchemasEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12'\n" +
	"\x05value\x18\x02 \x01(\v2\x11.tfplugin6.SchemaR\x05value:\x028\x01\x1aW\n" +
	"\x16DataSourceSchemasEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12'\n" +
	"\x05value\x18\x02 \x01(\v2\x11.tfplugin6.SchemaR\x05value:\x028\x01\x1aQ\n" +
	"\x0eFunctionsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12)\n" +
	"\x05value\x18\x02 \x01(\v2\x13.tfplugin6.FunctionR\x05value:\x028\x01\x1a^\n" +
	"\x1dEphemeralResourceSchemasEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12'\n" +
	"\x05value\x18\x02 \x01(\v2\x11.tfplugin6.SchemaR\x05value:\x028\x01\x1aY\n" +
	"\x18ListResourceSchemasEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12'\n" +
	"\x05value\x18\x02 \x01(\v2\x11.tfplugin6.SchemaR\x05value:\x028\x01\x1aW\n" +
	"\x16StateStoreSchemasEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12'\n" +
	"\x05value\x18\x02 \x01(\v2\x11.tfplugin6.SchemaR\x05value:\x028\x01\x1aY\n" +
	"\x12ActionSchemasEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12-\n" +
	"\x05value\x18\x02 \x01(\v2\x17.tfplugin6.ActionSchemaR\x05value:\x028\x01\"\x99\x01\n" +
	"\x16ValidateProviderConfig\x1a:\n" +
	"\aRequest\x12/\n" +
	"\x06config\x18\x01 \x01(\v2\x17.tfplugin6.DynamicValueR\x06config\x1aC\n" +
	"\bResponse\x127\n" +
	"\vdiagnostics\x18\x02 \x03(\v2\x15.tfplugin6.DiagnosticR\vdiagnostics\"\x90\x02\n" +
	"\x14UpgradeResourceState\x1ar\n" +
	"\aRequest\x12\x1b\n" +
	"\ttype_name\x18\x01 \x01(\tR\btypeName\x12\x18\n" +
	"\aversion\x18\x02 \x01(\x03R\aversion\x120\n" +
	"\traw_state\x18\x03 \x01(\v2\x13.tfplugin6.RawStateR\brawState\x1a\x83\x01\n" +
	"\bResponse\x12>\n" +
	"\x0eupgraded_state\x18\x01 \x01(\v2\x17.tfplugin6.DynamicValueR\rupgradedState\x127\n" +
	"\vdiagnostics\x18\x02 \x03(\v2\x15.tfplugin6.DiagnosticR\vdiagnostics\"\xc4\x02\n" +
	"\x1aGetResourceIdentitySchemas\x1a\t\n" +
	"\aRequest\x1a\x9a\x02\n" +
	"\bResponse\x12n\n" +
	"\x10identity_schemas\x18\x01 \x03(\v2C.tfplugin6.GetResourceIdentitySchemas.Response.IdentitySchemasEntryR\x0fidentitySchemas\x127\n" +
	"\vdiagnostics\x18\x02 \x03(\v2\x15.tfplugin6.DiagnosticR\vdiagnostics\x1ae\n" +
	"\x14IdentitySchemasEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x127\n" +
	"\x05value\x18\x02 \x01(\v2!.tfplugin6.ResourceIdentitySchemaR\x05value:\x028\x01\"\xa7\x02\n" +
	"\x17UpgradeResourceIdentity\x1ax\n" +
	"\aRequest\x12\x1b\n" +
	"\ttype_name\x18\x01 \x01(\tR\btypeName\x12\x18\n" +
	"\aversion\x18\x02 \x01(\x03R\aversion\x126\n" +
	"\fraw_identity\x18\x03 \x01(\v2\x13.tfplugin6.RawStateR\vrawIdentity\x1a\x91\x01\n" +
	"\bResponse\x12L\n" +
	"\x11upgraded_identity\x18\x01 \x01(\v2\x1f.tfplugin6.ResourceIdentityDataR\x10upgradedIdentity\x127\n" +
	"\vdiagnostics\x18\x02 \x03(\v2\x15.tfplugin6.DiagnosticR\vdiagnostics\"\x87\x02\n" +
	"\x16ValidateResourceConfig\x1a\xa7\x01\n" +
	"\aRequest\x12\x1b\n" +
	"\ttype_name\x18\x01 \x01(\tR\btypeName\x12/\n" +
	"\x06config\x18\x02 \x01(\v2\x17.tfplugin6.DynamicValueR\x06config\x12N\n" +
	"\x13client_capabilities\x18\x03 \x01(\v2\x1d.tfplugin6.ClientCapabilitiesR\x12clientCapabilities\x1aC\n" +
	"\bResponse\x127\n" +
	"\vdiagnostics\x18\x01 \x03(\v2\x15.tfplugin6.DiagnosticR\vdiagnostics\"\xba\x01\n" +
	"\x1aValidateDataResourceConfig\x1aW\n" +
	"\aRequest\x12\x1b\n" +
	"\ttype_name\x18\x01 \x01(\tR\btypeName\x12/\n" +
	"\x06config\x18\x02 \x01(\v2\x17.tfplugin6.DynamicValueR\x06config\x1aC\n" +
	"\bResponse\x127\n" +
	"\vdiagnostics\x18\x01 \x03(\v2\x15.tfplugin6.DiagnosticR\vdiagnostics\"\xbf\x01\n" +
	"\x1fValidateEphemeralResourceConfig\x1aW\n" +
	"\aRequest\x12\x1b\n" +
	"\ttype_name\x18\x01 \x01(\tR\btypeName\x12/\n" +
	"\x06config\x18\x02 \x01(\v2\x17.tfplugin6.DynamicValueR\x06config\x1aC\n" +
	"\bResponse\x127\n" +
	"\vdiagnostics\x18\x01 \x03(\v2\x15.tfplugin6.DiagnosticR\vdiagnostics\"\x92\x02\n" +
	"\x11ConfigureProvider\x1a\xb7\x01\n" +
	"\aRequest\x12+\n" +
	"\x11terraform_version\x18\x01 \x01(\tR\x10terraformVersion\x12/\n" +
	"\x06config\x18\x02 \x01(\v2\x17.tfplugin6.DynamicValueR\x06config\x12N\n" +
	"\x13client_capabilities\x18\x03 \x01(\v2\x1d.tfplugin6.ClientCapabilitiesR\x12clientCapabilities\x1aC\n" +
	"\bResponse\x127\n" +
	"\vdiagnostics\x18\x01 \x03(\v2\x15.tfplugin6.DiagnosticR\vdiagnostics\"\xf4\x04\n" +
	"\fReadResource\x1a\xd8\x02\n" +
	"\aRequest\x12\x1b\n" +
	"\ttype_name\x18\x01 \x01(\tR\btypeName\x12<\n" +
	"\rcurrent_state\x18\x02 \x01(\v2\x17.tfplugin6.DynamicValueR\fcurrentState\x12\x18\n" +
	"\aprivate\x18\x03 \x01(\fR\aprivate\x12<\n" +
	"\rprovider_meta\x18\x04 \x01(\v2\x17.tfplugin6.DynamicValueR\fproviderMeta\x12N\n" +
	"\x13client_capabilities\x18\x05 \x01(\v2\x1d.tfplugin6.ClientCapabilitiesR\x12clientCapabilities\x12J\n" +
	"\x10current_identity\x18\x06 \x01(\v2\x1f.tfplugin6.ResourceIdentityDataR\x0fcurrentIdentity\x1a\x88\x02\n" +
	"\bResponse\x124\n" +
	"\tnew_state\x18\x01 \x01(\v2\x17.tfplugin6.DynamicValueR\bnewState\x127\n" +
	"\vdiagnostics\x18\x02 \x03(\v2\x15.tfplugin6.DiagnosticR\vdiagnostics\x12\x18\n" +
	"\aprivate\x18\x03 \x01(\fR\aprivate\x12/\n" +
	"\bdeferred\x18\x04 \x01(\v2\x13.tfplugin6.DeferredR\bdeferred\x12B\n" +
	"\fnew_identity\x18\x05 \x01(\v2\x1f.tfplugin6.ResourceIdentityDataR\vnewIdentity\"\x87\a\n" +
	"\x12PlanResourceChange\x1a\xd3\x03\n" +
	"\aRequest\x12\x1b\n" +
	"\ttype_name\x18\x01 \x01(\tR\btypeName\x128\n" +
	"\vprior_state\x18\x02 \x01(\v2\x17.tfplugin6.DynamicValueR\n" +
	"priorState\x12E\n" +
	"\x12proposed_new_state\x18\x03 \x01(\v2\x17.tfplugin6.DynamicValueR\x10proposedNewState\x12/\n" +
	"\x06config\x18\x04 \x01(\v2\x17.tfplugin6.DynamicValueR\x06config\x12#\n" +
	"\rprior_private\x18\x05 \x01(\fR\fpriorPrivate\x12<\n" +
	"\rprovider_meta\x18\x06 \x01(\v2\x17.tfplugin6.DynamicValueR\fproviderMeta\x12N\n" +
	"\x13client_capabilities\x18\a \x01(\v2\x1d.tfplugin6.ClientCapabilitiesR\x12clientCapabilities\x12F\n" +
	"\x0eprior_identity\x18\b \x01(\v2\x1f.tfplugin6.ResourceIdentityDataR\rpriorIdentity\x1a\x9a\x03\n" +
	"\bResponse\x12<\n" +
	"\rplanned_state\x18\x01 \x01(\v2\x17.tfplugin6.DynamicValueR\fplannedState\x12C\n" +
	"\x10requires_replace\x18\x02 \x03(\v2\x18.tfplugin6.AttributePathR\x0frequiresReplace\x12'\n" +
	"\x0fplanned_private\x18\x03 \x01(\fR\x0eplannedPrivate\x127\n" +
	"\vdiagnostics\x18\x04 \x03(\v2\x15.tfplugin6.DiagnosticR\vdiagnostics\x12,\n" +
	"\x12legacy_type_system\x18\x05 \x01(\bR\x10legacyTypeSystem\x12/\n" +
	"\bdeferred\x18\x06 \x01(\v2\x13.tfplugin6.DeferredR\bdeferred\x12J\n" +
	"\x10planned_identity\x18\a \x01(\v2\x1f.tfplugin6.ResourceIdentityDataR\x0fplannedIdentity\"\xa2\x05\n" +
	"\x13ApplyResourceChange\x1a\x82\x03\n" +
	"\aRequest\x12\x1b\n" +
	"\ttype_name\x18\x01 \x01(\tR\btypeName\x128\n" +
	"\vprior_state\x18\x02 \x01(\v2\x17.tfplugin6.DynamicValueR\n" +
	"priorState\x12<\n" +
	"\rplanned_state\x18\x03 \x01(\v2\x17.tfplugin6.DynamicValueR\fplannedState\x12/\n" +
	"\x06config\x18\x04 \x01(\v2\x17.tfplugin6.DynamicValueR\x06config\x12'\n" +
	"\x0fplanned_private\x18\x05 \x01(\fR\x0eplannedPrivate\x12<\n" +
	"\rprovider_meta\x18\x06 \x01(\v2\x17.tfplugin6.DynamicValueR\fproviderMeta\x12J\n" +
	"\x10planned_identity\x18\a \x01(\v2\x1f.tfplugin6.ResourceIdentityDataR\x0fplannedIdentity\x1a\x85\x02\n" +
	"\bResponse\x124\n" +
	"\tnew_state\x18\x01 \x01(\v2\x17.tfplugin6.DynamicValueR\bnewState\x12\x18\n" +
	"\aprivate\x18\x02 \x01(\fR\aprivate\x127\n" +
	"\vdiagnostics\x18\x03 \x03(\v2\x15.tfplugin6.DiagnosticR\vdiagnostics\x12,\n" +
	"\x12legacy_type_system\x18\x04 \x01(\bR\x10legacyTypeSystem\x12B\n" +
	"\fnew_identity\x18\x05 \x01(\v2\x1f.tfplugin6.ResourceIdentityDataR\vnewIdentity\"\xea\x04\n" +
	"\x13ImportResourceState\x1a\xc3\x01\n" +
	"\aRequest\x12\x1b\n" +
	"\ttype_name\x18\x01 \x01(\tR\btypeName\x12\x0e\n" +
	"\x02id\x18\x02 \x01(\tR\x02id\x12N\n" +
	"\x13client_capabilities\x18\x03 \x01(\v2\x1d.tfplugin6.ClientCapabilitiesR\x12clientCapabilities\x12;\n" +
	"\bidentity\x18\x04 \x01(\v2\x1f.tfplugin6.ResourceIdentityDataR\bidentity\x1a\xb5\x01\n" +
	"\x10ImportedResource\x12\x1b\n" +
	"\ttype_name\x18\x01 \x01(\tR\btypeName\x12-\n" +
	"\x05state\x18\x02 \x01(\v2\x17.tfplugin6.DynamicValueR\x05state\x12\x18\n" +
	"\aprivate\x18\x03 \x01(\fR\aprivate\x12;\n" +
	"\bidentity\x18\x04 \x01(\v2\x1f.tfplugin6.ResourceIdentityDataR\bidentity\x1a\xd4\x01\n" +
	"\bResponse\x12^\n" +
	"\x12imported_resources\x18\x01 \x03(\v2/.tfplugin6.ImportResourceState.ImportedResourceR\x11importedResources\x127\n" +
	"\vdiagnostics\x18\x02 \x03(\v2\x15.tfplugin6.DiagnosticR\vdiagnostics\x12/\n" +
	"\bdeferred\x18\x03 \x01(\v2\x13.tfplugin6.DeferredR\bdeferred\"\xe5\x01\n" +
	"\x16GenerateResourceConfig\x1aU\n" +
	"\aRequest\x12\x1b\n" +
	"\ttype_name\x18\x01 \x01(\tR\btypeName\x12-\n" +
	"\x05state\x18\x02 \x01(\v2\x17.tfplugin6.DynamicValueR\x05state\x1at\n" +
	"\bResponse\x12/\n" +
	"\x06config\x18\x01 \x01(\v2\x17.tfplugin6.DynamicValueR\x06config\x127\n" +
	"\vdiagnostics\x18\x02 \x03(\v2\x15.tfplugin6.DiagnosticR\vdiagnostics\"\xb4\x05\n" +
	"\x11MoveResourceState\x1a\xab\x03\n" +
	"\aRequest\x126\n" +
	"\x17source_provider_address\x18\x01 \x01(\tR\x15sourceProviderAddress\x12(\n" +
	"\x10source_type_name\x18\x02 \x01(\tR\x0esourceTypeName\x122\n" +
	"\x15source_schema_version\x18\x03 \x01(\x03R\x13sourceSchemaVersion\x126\n" +
	"\fsource_state\x18\x04 \x01(\v2\x13.tfplugin6.RawStateR\vsourceState\x12(\n" +
	"\x10target_type_name\x18\x05 \x01(\tR\x0etargetTypeName\x12%\n" +
	"\x0esource_private\x18\x06 \x01(\fR\rsourcePrivate\x12<\n" +
	"\x0fsource_identity\x18\a \x01(\v2\x13.tfplugin6.RawStateR\x0esourceIdentity\x12C\n" +
	"\x1esource_identity_schema_version\x18\b \x01(\x03R\x1bsourceIdentitySchemaVersion\x1a\xf0\x01\n" +
	"\bResponse\x12:\n" +
	"\ftarget_state\x18\x01 \x01(\v2\x17.tfplugin6.DynamicValueR\vtargetState\x127\n" +
	"\vdiagnostics\x18\x02 \x03(\v2\x15.tfplugin6.DiagnosticR\vdiagnostics\x12%\n" +
	"\x0etarget_private\x18\x03 \x01(\fR\rtargetPrivate\x12H\n" +
	"\x0ftarget_identity\x18\x04 \x01(\v2\x1f.tfplugin6.ResourceIdentityDataR\x0etargetIdentity\"\x9e\x03\n" +
	"\x0eReadDataSource\x1a\xe5\x01\n" +
	"\aRequest\x12\x1b\n" +
	"\ttype_name\x18\x01 \x01(\tR\btypeName\x12/\n" +
	"\x06config\x18\x02 \x01(\v2\x17.tfplugin6.DynamicValueR\x06config\x12<\n" +
	"\rprovider_meta\x18\x03 \x01(\v2\x17.tfplugin6.DynamicValueR\fproviderMeta\x12N\n" +
	"\x13client_capabilities\x18\x04 \x01(\v2\x1d.tfplugin6.ClientCapabilitiesR\x12clientCapabilities\x1a\xa3\x01\n" +
	"\bResponse\x12-\n" +
	"\x05state\x18\x01 \x01(\v2\x17.tfplugin6.DynamicValueR\x05state\x127\n" +
	"\vdiagnostics\x18\x02 \x03(\v2\x15.tfplugin6.DiagnosticR\vdiagnostics\x12/\n" +
	"\bdeferred\x18\x03 \x01(\v2\x13.tfplugin6.DeferredR\bdeferred\"\xdd\x03\n" +
	"\x15OpenEphemeralResource\x1a\xa7\x01\n" +
	"\aRequest\x12\x1b\n" +
	"\ttype_name\x18\x01 \x01(\tR\btypeName\x12/\n" +
	"\x06config\x18\x02 \x01(\v2\x17.tfplugin6.DynamicValueR\x06config\x12N\n" +
	"\x13client_capabilities\x18\x03 \x01(\v2\x1d.tfplugin6.ClientCapabilitiesR\x12clientCapabilities\x1a\x99\x02\n" +
	"\bResponse\x127\n" +
	"\vdiagnostics\x18\x01 \x03(\v2\x15.tfplugin6.DiagnosticR\vdiagnostics\x12:\n" +
	"\brenew_at\x18\x02 \x01(\v2\x1a.google.protobuf.TimestampH\x00R\arenewAt\x88\x01\x01\x12/\n" +
	"\x06result\x18\x03 \x01(\v2\x17.tfplugin6.DynamicValueR\x06result\x12\x1d\n" +
	"\aprivate\x18\x04 \x01(\fH\x01R\aprivate\x88\x01\x01\x12/\n" +
	"\bdeferred\x18\x05 \x01(\v2\x13.tfplugin6.DeferredR\bdeferredB\v\n" +
	"\t_renew_atB\n" +
	"\n" +
	"\b_private\"\xa5\x02\n" +
	"\x16RenewEphemeralResource\x1aQ\n" +
	"\aRequest\x12\x1b\n" +
	"\ttype_name\x18\x01 \x01(\tR\btypeName\x12\x1d\n" +
	"\aprivate\x18\x02 \x01(\fH\x00R\aprivate\x88\x01\x01B\n" +
	"\n" +
	"\b_private\x1a\xb7\x01\n" +
	"\bResponse\x127\n" +
	"\vdiagnostics\x18\x01 \x03(\v2\x15.tfplugin6.DiagnosticR\vdiagnostics\x12:\n" +
	"\brenew_at\x18\x02 \x01(\v2\x1a.google.protobuf.TimestampH\x00R\arenewAt\x88\x01\x01\x12\x1d\n" +
	"\aprivate\x18\x03 \x01(\fH\x01R\aprivate\x88\x01\x01B\v\n" +
	"\t_renew_atB\n" +
	"\n" +
	"\b_private\"\xb0\x01\n" +
	"\x16CloseEphemeralResource\x1aQ\n" +
	"\aRequest\x12\x1b\n" +
	"\ttype_name\x18\x01 \x01(\tR\btypeName\x12\x1d\n" +
	"\aprivate\x18\x02 \x01(\fH\x00R\aprivate\x88\x01\x01B\n" +
	"\n" +
	"\b_private\x1aC\n" +
	"\bResponse\x127\n" +
	"\vdiagnostics\x18\x01 \x03(\v2\x15.tfplugin6.DiagnosticR\vdiagnostics\"\x81\x02\n" +
	"\fGetFunctions\x1a\t\n" +
	"\aRequest\x1a\xe5\x01\n" +
	"\bResponse\x12M\n" +
	"\tfunctions\x18\x01 \x03(\v2/.tfplugin6.GetFunctions.Response.FunctionsEntryR\tfunctions\x127\n" +
	"\vdiagnostics\x18\x02 \x03(\v2\x15.tfplugin6.DiagnosticR\vdiagnostics\x1aQ\n" +
	"\x0eFunctionsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12)\n" +
	"\x05value\x18\x02 \x01(\v2\x13.tfplugin6.FunctionR\x05value:\x028\x01\"\xd1\x01\n" +
	"\fCallFunction\x1aT\n" +
	"\aRequest\x12\x12\n" +
	"\x04name\x18\x01 \x01(\tR\x04name\x125\n" +
	"\targuments\x18\x02 \x03(\v2\x17.tfplugin6.DynamicValueR\targuments\x1ak\n" +
	"\bResponse\x12/\n" +
	"\x06result\x18\x01 \x01(\v2\x17.tfplugin6.DynamicValueR\x06result\x12.\n" +
	"\x05error\x18\x02 \x01(\v2\x18.tfplugin6.FunctionErrorR\x05error\"\xb2\x03\n" +
	"\fListResource\x1a\xa5\x01\n" +
	"\aRequest\x12\x1b\n" +
	"\ttype_name\x18\x01 \x01(\tR\btypeName\x12/\n" +
	"\x06config\x18\x02 \x01(\v2\x17.tfplugin6.DynamicValueR\x06config\x126\n" +
	"\x17include_resource_object\x18\x03 \x01(\bR\x15includeResourceObject\x12\x14\n" +
	"\x05limit\x18\x04 \x01(\x03R\x05limit\x1a\xf9\x01\n" +
	"\x05Event\x12;\n" +
	"\bidentity\x18\x01 \x01(\v2\x1f.tfplugin6.ResourceIdentityDataR\bidentity\x12!\n" +
	"\fdisplay_name\x18\x02 \x01(\tR\vdisplayName\x12E\n" +
	"\x0fresource_object\x18\x03 \x01(\v2\x17.tfplugin6.DynamicValueH\x00R\x0eresourceObject\x88\x01\x01\x125\n" +
	"\n" +
	"diagnostic\x18\x04 \x03(\v2\x15.tfplugin6.DiagnosticR\n" +
	"diagnosticB\x12\n" +
	"\x10_resource_object\"\xbb\x02\n" +
	"\x1aValidateListResourceConfig\x1a\xd7\x01\n" +
	"\aRequest\x12\x1b\n" +
	"\ttype_name\x18\x01 \x01(\tR\btypeName\x12/\n" +
	"\x06config\x18\x02 \x01(\v2\x17.tfplugin6.DynamicValueR\x06config\x12O\n" +
	"\x17include_resource_object\x18\x03 \x01(\v2\x17.tfplugin6.DynamicValueR\x15includeResourceObject\x12-\n" +
	"\x05limit\x18\x04 \x01(\v2\x17.tfplugin6.DynamicValueR\x05limit\x1aC\n" +
	"\bResponse\x127\n" +
	"\vdiagnostics\x18\x01 \x03(\v2\x15.tfplugin6.DiagnosticR\vdiagnostics\"\xb2\x01\n" +
	"\x12ValidateStateStore\x1aW\n" +
	"\aRequest\x12\x1b\n" +
	"\ttype_name\x18\x01 \x01(\tR\btypeName\x12/\n" +
	"\x06config\x18\x02 \x01(\v2\x17.tfplugin6.DynamicValueR\x06config\x1aC\n" +
	"\bResponse\x127\n" +
	"\vdiagnostics\x18\x01 \x03(\v2\x15.tfplugin6.DiagnosticR\vdiagnostics\"\xb3\x01\n" +
	"\x13ConfigureStateStore\x1aW\n" +
	"\aRequest\x12\x1b\n" +
	"\ttype_name\x18\x01 \x01(\tR\btypeName\x12/\n" +
	"\x06config\x18\x02 \x01(\v2\x17.tfplugin6.DynamicValueR\x06config\x1aC\n" +
	"\bResponse\x127\n" +
	"\vdiagnostics\x18\x01 \x03(\v2\x15.tfplugin6.DiagnosticR\vdiagnostics\"\x93\x01\n" +
	"\tGetStates\x1a&\n" +
	"\aRequest\x12\x1b\n" +
	"\ttype_name\x18\x01 \x01(\tR\btypeName\x1a^\n" +
	"\bResponse\x12\x19\n" +
	"\bstate_id\x18\x01 \x03(\tR\astateId\x127\n" +
	"\vdiagnostics\x18\x02 \x03(\v2\x15.tfplugin6.DiagnosticR\vdiagnostics\"\x95\x01\n" +
	"\vDeleteState\x1aA\n" +
	"\aRequest\x12\x1b\n" +
	"\ttype_name\x18\x01 \x01(\tR\btypeName\x12\x19\n" +
	"\bstate_id\x18\x02 \x01(\tR\astateId\x1aC\n" +
	"\bResponse\x127\n" +
	"\vdiagnostics\x18\x01 \x03(\v2\x15.tfplugin6.DiagnosticR\vdiagnostics\"\xb0\x02\n" +
	"\n" +
	"PlanAction\x1a\xab\x01\n" +
	"\aRequest\x12\x1f\n" +
	"\vaction_type\x18\x01 \x01(\tR\n" +
	"actionType\x12/\n" +
	"\x06config\x18\x02 \x01(\v2\x17.tfplugin6.DynamicValueR\x06config\x12N\n" +
	"\x13client_capabilities\x18\x03 \x01(\v2\x1d.tfplugin6.ClientCapabilitiesR\x12clientCapabilities\x1at\n" +
	"\bResponse\x127\n" +
	"\vdiagnostics\x18\x01 \x03(\v2\x15.tfplugin6.DiagnosticR\vdiagnostics\x12/\n" +
	"\bdeferred\x18\x02 \x01(\v2\x13.tfplugin6.DeferredR\bdeferred\"\xc9\x03\n" +
	"\fInvokeAction\x1a\xab\x01\n" +
	"\aRequest\x12\x1f\n" +
	"\vaction_type\x18\x01 \x01(\tR\n" +
	"actionType\x12/\n" +
	"\x06config\x18\x02 \x01(\v2\x17.tfplugin6.DynamicValueR\x06config\x12N\n" +
	"\x13client_capabilities\x18\x03 \x01(\v2\x1d.tfplugin6.ClientCapabilitiesR\x12clientCapabilities\x1a\x8a\x02\n" +
	"\x05Event\x12D\n" +
	"\bprogress\x18\x01 \x01(\v2&.tfplugin6.InvokeAction.Event.ProgressH\x00R\bprogress\x12G\n" +
	"\tcompleted\x18\x02 \x01(\v2'.tfplugin6.InvokeAction.Event.CompletedH\x00R\tcompleted\x1a$\n" +
	"\bProgress\x12\x18\n" +
	"\amessage\x18\x01 \x01(\tR\amessage\x1aD\n" +
	"\tCompleted\x127\n" +
	"\vdiagnostics\x18\x01 \x03(\v2\x15.tfplugin6.DiagnosticR\vdiagnosticsB\x06\n" +
	"\x04type\"\xb4\x01\n" +
	"\x14ValidateActionConfig\x1aW\n" +
	"\aRequest\x12\x1b\n" +
	"\ttype_name\x18\x01 \x01(\tR\btypeName\x12/\n" +
	"\x06config\x18\x02 \x01(\v2\x17.tfplugin6.DynamicValueR\x06config\x1aC\n" +
	"\bResponse\x127\n" +
	"\vdiagnostics\x18\x01 \x03(\v2\x15.tfplugin6.DiagnosticR\vdiagnostics*%\n" +
	"\n" +
	"StringKind\x12\t\n" +
	"\x05PLAIN\x10\x00\x12\f\n" +
	"\bMARKDOWN\x10\x012\xa9\x19\n" +
	"\bProvider\x12N\n" +
	"\vGetMetadata\x12\x1e.tfplugin6.GetMetadata.Request\x1a\x1f.tfplugin6.GetMetadata.Response\x12`\n" +
	"\x11GetProviderSchema\x12$.tfplugin6.GetProviderSchema.Request\x1a%.tfplugin6.GetProviderSchema.Response\x12o\n" +
	"\x16ValidateProviderConfig\x12).tfplugin6.ValidateProviderConfig.Request\x1a*.tfplugin6.ValidateProviderConfig.Response\x12o\n" +
	"\x16ValidateResourceConfig\x12).tfplugin6.ValidateResourceConfig.Request\x1a*.tfplugin6.ValidateResourceConfig.Response\x12{\n" +
	"\x1aValidateDataResourceConfig\x12-.tfplugin6.ValidateDataResourceConfig.Request\x1a..tfplugin6.ValidateDataResourceConfig.Response\x12i\n" +
	"\x14UpgradeResourceState\x12'.tfplugin6.UpgradeResourceState.Request\x1a(.tfplugin6.UpgradeResourceState.Response\x12{\n" +
	"\x1aGetResourceIdentitySchemas\x12-.tfplugin6.GetResourceIdentitySchemas.Request\x1a..tfplugin6.GetResourceIdentitySchemas.Response\x12r\n" +
	"\x17UpgradeResourceIdentity\x12*.tfplugin6.UpgradeResourceIdentity.Request\x1a+.tfplugin6.UpgradeResourceIdentity.Response\x12`\n" +
	"\x11ConfigureProvider\x12$.tfplugin6.ConfigureProvider.Request\x1a%.tfplugin6.ConfigureProvider.Response\x12Q\n" +
	"\fReadResource\x12\x1f.tfplugin6.ReadResource.Request\x1a .tfplugin6.ReadResource.Response\x12c\n" +
	"\x12PlanResourceChange\x12%.tfplugin6.PlanResourceChange.Request\x1a&.tfplugin6.PlanResourceChange.Response\x12f\n" +
	"\x13ApplyResourceChange\x12&.tfplugin6.ApplyResourceChange.Request\x1a'.tfplugin6.ApplyResourceChange.Response\x12f\n" +
	"\x13ImportResourceState\x12&.tfplugin6.ImportResourceState.Request\x1a'.tfplugin6.ImportResourceState.Response\x12`\n" +
	"\x11MoveResourceState\x12$.tfplugin6.MoveResourceState.Request\x1a%.tfplugin6.MoveResourceState.Response\x12W\n" +
	"\x0eReadDataSource\x12!.tfplugin6.ReadDataSource.Request\x1a\".tfplugin6.ReadDataSource.Response\x12o\n" +
	"\x16GenerateResourceConfig\x12).tfplugin6.GenerateResourceConfig.Request\x1a*.tfplugin6.GenerateResourceConfig.Response\x12\x8a\x01\n" +
	"\x1fValidateEphemeralResourceConfig\x122.tfplugin6.ValidateEphemeralResourceConfig.Request\x1a3.tfplugin6.ValidateEphemeralResourceConfig.Response\x12l\n" +
	"\x15OpenEphemeralResource\x12(.tfplugin6.OpenEphemeralResource.Request\x1a).tfplugin6.OpenEphemeralResource.Response\x12o\n" +
	"\x16RenewEphemeralResource\x12).tfplugin6.RenewEphemeralResource.Request\x1a*.tfplugin6.RenewEphemeralResource.Response\x12o\n" +
	"\x16CloseEphemeralResource\x12).tfplugin6.CloseEphemeralResource.Request\x1a*.tfplugin6.CloseEphemeralResource.Response\x12P\n" +
	"\fListResource\x12\x1f.tfplugin6.ListResource.Request\x1a\x1d.tfplugin6.ListResource.Event0\x01\x12{\n" +
	"\x1aValidateListResourceConfig\x12-.tfplugin6.ValidateListResourceConfig.Request\x1a..tfplugin6.ValidateListResourceConfig.Response\x12Q\n" +
	"\fGetFunctions\x12\x1f.tfplugin6.GetFunctions.Request\x1a .tfplugin6.GetFunctions.Response\x12Q\n" +
	"\fCallFunction\x12\x1f.tfplugin6.CallFunction.Request\x1a .tfplugin6.CallFunction.Response\x12i\n" +
	"\x18ValidateStateStoreConfig\x12%.tfplugin6.ValidateStateStore.Request\x1a&.tfplugin6.ValidateStateStore.Response\x12f\n" +
	"\x13ConfigureStateStore\x12&.tfplugin6.ConfigureStateStore.Request\x1a'.tfplugin6.ConfigureStateStore.Response\x12H\n" +
	"\tGetStates\x12\x1c.tfplugin6.GetStates.Request\x1a\x1d.tfplugin6.GetStates.Response\x12N\n" +
	"\vDeleteState\x12\x1e.tfplugin6.DeleteState.Request\x1a\x1f.tfplugin6.DeleteState.Response\x12K\n" +
	"\n" +
	"PlanAction\x12\x1d.tfplugin6.PlanAction.Request\x1a\x1e.tfplugin6.PlanAction.Response\x12P\n" +
	"\fInvokeAction\x12\x1f.tfplugin6.InvokeAction.Request\x1a\x1d.tfplugin6.InvokeAction.Event0\x01\x12i\n" +
	"\x14ValidateActionConfig\x12'.tfplugin6.ValidateActionConfig.Request\x1a(.tfplugin6.ValidateActionConfig.Response\x12Q\n" +
	"\fStopProvider\x12\x1f.tfplugin6.StopProvider.Request\x1a .tfplugin6.StopProvider.ResponseB3Z1github.com/hashicorp/terraform/internal/tfplugin6b\x06proto3"

var (
	file_tfplugin6_proto_rawDescOnce sync.Once
	file_tfplugin6_proto_rawDescData []byte
)

func file_tfplugin6_proto_rawDescGZIP() []byte {
	file_tfplugin6_proto_rawDescOnce.Do(func() {
		file_tfplugin6_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_tfplugin6_proto_rawDesc), len(file_tfplugin6_proto_rawDesc)))
	})
	return file_tfplugin6_proto_rawDescData
}

var file_tfplugin6_proto_enumTypes = make([]protoimpl.EnumInfo, 5)
var file_tfplugin6_proto_msgTypes = make([]protoimpl.MessageInfo, 137)
var file_tfplugin6_proto_goTypes = []any{
	(StringKind)(0),                                  // 0: tfplugin6.StringKind
	(Diagnostic_Severity)(0),                         // 1: tfplugin6.Diagnostic.Severity
	(Schema_NestedBlock_NestingMode)(0),              // 2: tfplugin6.Schema.NestedBlock.NestingMode
	(Schema_Object_NestingMode)(0),                   // 3: tfplugin6.Schema.Object.NestingMode
	(Deferred_Reason)(0),                             // 4: tfplugin6.Deferred.Reason
	(*DynamicValue)(nil),                             // 5: tfplugin6.DynamicValue
	(*Diagnostic)(nil),                               // 6: tfplugin6.Diagnostic
	(*FunctionError)(nil),                            // 7: tfplugin6.FunctionError
	(*AttributePath)(nil),                            // 8: tfplugin6.AttributePath
	(*StopProvider)(nil),                             // 9: tfplugin6.StopProvider
	(*RawState)(nil),                                 // 10: tfplugin6.RawState
	(*ResourceIdentitySchema)(nil),                   // 11: tfplugin6.ResourceIdentitySchema
	(*ResourceIdentityData)(nil),                     // 12: tfplugin6.ResourceIdentityData
	(*ActionSchema)(nil),                             // 13: tfplugin6.ActionSchema
	(*Schema)(nil),                                   // 14: tfplugin6.Schema
	(*Function)(nil),                                 // 15: tfplugin6.Function
	(*ServerCapabilities)(nil),                       // 16: tfplugin6.ServerCapabilities
	(*ClientCapabilities)(nil),                       // 17: tfplugin6.ClientCapabilities
	(*Deferred)(nil),                                 // 18: tfplugin6.Deferred
	(*GetMetadata)(nil),                              // 19: tfplugin6.GetMetadata
	(*GetProviderSchema)(nil),                        // 20: tfplugin6.GetProviderSchema
	(*ValidateProviderConfig)(nil),                   // 21: tfplugin6.ValidateProviderConfig
	(*UpgradeResourceState)(nil),                     // 22: tfplugin6.UpgradeResourceState
	(*GetResourceIdentitySchemas)(nil),               // 23: tfplugin6.GetResourceIdentitySchemas
	(*UpgradeResourceIdentity)(nil),                  // 24: tfplugin6.UpgradeResourceIdentity
	(*ValidateResourceConfig)(nil),                   // 25: tfplugin6.ValidateResourceConfig
	(*ValidateDataResourceConfig)(nil),               // 26: tfplugin6.ValidateDataResourceConfig
	(*ValidateEphemeralResourceConfig)(nil),          // 27: tfplugin6.ValidateEphemeralResourceConfig
	(*ConfigureProvider)(nil),                        // 28: tfplugin6.ConfigureProvider
	(*ReadResource)(nil),                             // 29: tfplugin6.ReadResource
	(*PlanResourceChange)(nil),                       // 30: tfplugin6.PlanResourceChange
	(*ApplyResourceChange)(nil),                      // 31: tfplugin6.ApplyResourceChange
	(*ImportResourceState)(nil),                      // 32: tfplugin6.ImportResourceState
	(*GenerateResourceConfig)(nil),                   // 33: tfplugin6.GenerateResourceConfig
	(*MoveResourceState)(nil),                        // 34: tfplugin6.MoveResourceState
	(*ReadDataSource)(nil),                           // 35: tfplugin6.ReadDataSource
	(*OpenEphemeralResource)(nil),                    // 36: tfplugin6.OpenEphemeralResource
	(*RenewEphemeralResource)(nil),                   // 37: tfplugin6.RenewEphemeralResource
	(*CloseEphemeralResource)(nil),                   // 38: tfplugin6.CloseEphemeralResource
	(*GetFunctions)(nil),                             // 39: tfplugin6.GetFunctions
	(*CallFunction)(nil),                             // 40: tfplugin6.CallFunction
	(*ListResource)(nil),                             // 41: tfplugin6.ListResource
	(*ValidateListResourceConfig)(nil),               // 42: tfplugin6.ValidateListResourceConfig
	(*ValidateStateStore)(nil),                       // 43: tfplugin6.ValidateStateStore
	(*ConfigureStateStore)(nil),                      // 44: tfplugin6.ConfigureStateStore
	(*GetStates)(nil),                                // 45: tfplugin6.GetStates
	(*DeleteState)(nil),                              // 46: tfplugin6.DeleteState
	(*PlanAction)(nil),                               // 47: tfplugin6.PlanAction
	(*InvokeAction)(nil),                             // 48: tfplugin6.InvokeAction
	(*ValidateActionConfig)(nil),                     // 49: tfplugin6.ValidateActionConfig
	(*AttributePath_Step)(nil),                       // 50: tfplugin6.AttributePath.Step
	(*StopProvider_Request)(nil),                     // 51: tfplugin6.StopProvider.Request
	(*StopProvider_Response)(nil),                    // 52: tfplugin6.StopProvider.Response
	nil,                                              // 53: tfplugin6.RawState.FlatmapEntry
	(*ResourceIdentitySchema_IdentityAttribute)(nil), // 54: tfplugin6.ResourceIdentitySchema.IdentityAttribute
	(*Schema_Block)(nil),                             // 55: tfplugin6.Schema.Block
	(*Schema_Attribute)(nil),                         // 56: tfplugin6.Schema.Attribute
	(*Schema_NestedBlock)(nil),                       // 57: tfplugin6.Schema.NestedBlock
	(*Schema_Object)(nil),                            // 58: tfplugin6.Schema.Object
	(*Function_Parameter)(nil),                       // 59: tfplugin6.Function.Parameter
	(*Function_Return)(nil),                          // 60: tfplugin6.Function.Return
	(*GetMetadata_Request)(nil),                      // 61: tfplugin6.GetMetadata.Request
	(*GetMetadata_Response)(nil),                     // 62: tfplugin6.GetMetadata.Response
	(*GetMetadata_EphemeralMetadata)(nil),            // 63: tfplugin6.GetMetadata.EphemeralMetadata
	(*GetMetadata_FunctionMetadata)(nil),             // 64: tfplugin6.GetMetadata.FunctionMetadata
	(*GetMetadata_DataSourceMetadata)(nil),           // 65: tfplugin6.GetMetadata.DataSourceMetadata
	(*GetMetadata_ResourceMetadata)(nil),             // 66: tfplugin6.GetMetadata.ResourceMetadata
	(*GetMetadata_ListResourceMetadata)(nil),         // 67: tfplugin6.GetMetadata.ListResourceMetadata
	(*GetMetadata_StateStoreMetadata)(nil),           // 68: tfplugin6.GetMetadata.StateStoreMetadata
	(*GetMetadata_ActionMetadata)(nil),               // 69: tfplugin6.GetMetadata.ActionMetadata
	(*GetProviderSchema_Request)(nil),                // 70: tfplugin6.GetProviderSchema.Request
	(*GetProviderSchema_Response)(nil),               // 71: tfplugin6.GetProviderSchema.Response
	nil,                                              // 72: tfplugin6.GetProviderSchema.Response.ResourceSchemasEntry
	nil,                                              // 73: tfplugin6.GetProviderSchema.Response.DataSourceSchemasEntry
	nil,                                              // 74: tfplugin6.GetProviderSchema.Response.FunctionsEntry
	nil,                                              // 75: tfplugin6.GetProviderSchema.Response.EphemeralResourceSchemasEntry
	nil,                                              // 76: tfplugin6.GetProviderSchema.Response.ListResourceSchemasEntry
	nil,                                              // 77: tfplugin6.GetProviderSchema.Response.StateStoreSchemasEntry
	nil,                                              // 78: tfplugin6.GetProviderSchema.Response.ActionSchemasEntry
	(*ValidateProviderConfig_Request)(nil),           // 79: tfplugin6.ValidateProviderConfig.Request
	(*ValidateProviderConfig_Response)(nil),          // 80: tfplugin6.ValidateProviderConfig.Response
	(*UpgradeResourceState_Request)(nil),             // 81: tfplugin6.UpgradeResourceState.Request
	(*UpgradeResourceState_Response)(nil),            // 82: tfplugin6.UpgradeResourceState.Response
	(*GetResourceIdentitySchemas_Request)(nil),       // 83: tfplugin6.GetResourceIdentitySchemas.Request
	(*GetResourceIdentitySchemas_Response)(nil),      // 84: tfplugin6.GetResourceIdentitySchemas.Response
	nil,                                              // 85: tfplugin6.GetResourceIdentitySchemas.Response.IdentitySchemasEntry
	(*UpgradeResourceIdentity_Request)(nil),          // 86: tfplugin6.UpgradeResourceIdentity.Request
	(*UpgradeResourceIdentity_Response)(nil),         // 87: tfplugin6.UpgradeResourceIdentity.Response
	(*ValidateResourceConfig_Request)(nil),           // 88: tfplugin6.ValidateResourceConfig.Request
	(*ValidateResourceConfig_Response)(nil),          // 89: tfplugin6.ValidateResourceConfig.Response
	(*ValidateDataResourceConfig_Request)(nil),       // 90: tfplugin6.ValidateDataResourceConfig.Request
	(*ValidateDataResourceConfig_Response)(nil),      // 91: tfplugin6.ValidateDataResourceConfig.Response
	(*ValidateEphemeralResourceConfig_Request)(nil),  // 92: tfplugin6.ValidateEphemeralResourceConfig.Request
	(*ValidateEphemeralResourceConfig_Response)(nil), // 93: tfplugin6.ValidateEphemeralResourceConfig.Response
	(*ConfigureProvider_Request)(nil),                // 94: tfplugin6.ConfigureProvider.Request
	(*ConfigureProvider_Response)(nil),               // 95: tfplugin6.ConfigureProvider.Response
	(*ReadResource_Request)(nil),                     // 96: tfplugin6.ReadResource.Request
	(*ReadResource_Response)(nil),                    // 97: tfplugin6.ReadResource.Response
	(*PlanResourceChange_Request)(nil),               // 98: tfplugin6.PlanResourceChange.Request
	(*PlanResourceChange_Response)(nil),              // 99: tfplugin6.PlanResourceChange.Response
	(*ApplyResourceChange_Request)(nil),              // 100: tfplugin6.ApplyResourceChange.Request
	(*ApplyResourceChange_Response)(nil),             // 101: tfplugin6.ApplyResourceChange.Response
	(*ImportResourceState_Request)(nil),              // 102: tfplugin6.ImportResourceState.Request
	(*ImportResourceState_ImportedResource)(nil),     // 103: tfplugin6.ImportResourceState.ImportedResource
	(*ImportResourceState_Response)(nil),             // 104: tfplugin6.ImportResourceState.Response
	(*GenerateResourceConfig_Request)(nil),           // 105: tfplugin6.GenerateResourceConfig.Request
	(*GenerateResourceConfig_Response)(nil),          // 106: tfplugin6.GenerateResourceConfig.Response
	(*MoveResourceState_Request)(nil),                // 107: tfplugin6.MoveResourceState.Request
	(*MoveResourceState_Response)(nil),               // 108: tfplugin6.MoveResourceState.Response
	(*ReadDataSource_Request)(nil),                   // 109: tfplugin6.ReadDataSource.Request
	(*ReadDataSource_Response)(nil),                  // 110: tfplugin6.ReadDataSource.Response
	(*OpenEphemeralResource_Request)(nil),            // 111: tfplugin6.OpenEphemeralResource.Request
	(*OpenEphemeralResource_Response)(nil),           // 112: tfplugin6.OpenEphemeralResource.Response
	(*RenewEphemeralResource_Request)(nil),           // 113: tfplugin6.RenewEphemeralResource.Request
	(*RenewEphemeralResource_Response)(nil),          // 114: tfplugin6.RenewEphemeralResource.Response
	(*CloseEphemeralResource_Request)(nil),           // 115: tfplugin6.CloseEphemeralResource.Request
	(*CloseEphemeralResource_Response)(nil),          // 116: tfplugin6.CloseEphemeralResource.Response
	(*GetFunctions_Request)(nil),                     // 117: tfplugin6.GetFunctions.Request
	(*GetFunctions_Response)(nil),                    // 118: tfplugin6.GetFunctions.Response
	nil,                                              // 119: tfplugin6.GetFunctions.Response.FunctionsEntry
	(*CallFunction_Request)(nil),                     // 120: tfplugin6.CallFunction.Request
	(*CallFunction_Response)(nil),                    // 121: tfplugin6.CallFunction.Response
	(*ListResource_Request)(nil),                     // 122: tfplugin6.ListResource.Request
	(*ListResource_Event)(nil),                       // 123: tfplugin6.ListResource.Event
	(*ValidateListResourceConfig_Request)(nil),       // 124: tfplugin6.ValidateListResourceConfig.Request
	(*ValidateListResourceConfig_Response)(nil),      // 125: tfplugin6.ValidateListResourceConfig.Response
	(*ValidateStateStore_Request)(nil),               // 126: tfplugin6.ValidateStateStore.Request
	(*ValidateStateStore_Response)(nil),              // 127: tfplugin6.ValidateStateStore.Response
	(*ConfigureStateStore_Request)(nil),              // 128: tfplugin6.ConfigureStateStore.Request
	(*ConfigureStateStore_Response)(nil),             // 129: tfplugin6.ConfigureStateStore.Response
	(*GetStates_Request)(nil),                        // 130: tfplugin6.GetStates.Request
	(*GetStates_Response)(nil),                       // 131: tfplugin6.GetStates.Response
	(*DeleteState_Request)(nil),                      // 132: tfplugin6.DeleteState.Request
	(*DeleteState_Response)(nil),                     // 133: tfplugin6.DeleteState.Response
	(*PlanAction_Request)(nil),                       // 134: tfplugin6.PlanAction.Request
	(*PlanAction_Response)(nil),                      // 135: tfplugin6.PlanAction.Response
	(*InvokeAction_Request)(nil),                     // 136: tfplugin6.InvokeAction.Request
	(*InvokeAction_Event)(nil),                       // 137: tfplugin6.InvokeAction.Event
	(*InvokeAction_Event_Progress)(nil),              // 138: tfplugin6.InvokeAction.Event.Progress
	(*InvokeAction_Event_Completed)(nil),             // 139: tfplugin6.InvokeAction.Event.Completed
	(*ValidateActionConfig_Request)(nil),             // 140: tfplugin6.ValidateActionConfig.Request
	(*ValidateActionConfig_Response)(nil),            // 141: tfplugin6.ValidateActionConfig.Response
	(*timestamppb.Timestamp)(nil),                    // 142: google.protobuf.Timestamp
}
var file_tfplugin6_proto_depIdxs = []int32{
	1,   // 0: tfplugin6.Diagnostic.severity:type_name -> tfplugin6.Diagnostic.Severity
	8,   // 1: tfplugin6.Diagnostic.attribute:type_name -> tfplugin6.AttributePath
	50,  // 2: tfplugin6.AttributePath.steps:type_name -> tfplugin6.AttributePath.Step
	53,  // 3: tfplugin6.RawState.flatmap:type_name -> tfplugin6.RawState.FlatmapEntry
	54,  // 4: tfplugin6.ResourceIdentitySchema.identity_attributes:type_name -> tfplugin6.ResourceIdentitySchema.IdentityAttribute
	5,   // 5: tfplugin6.ResourceIdentityData.identity_data:type_name -> tfplugin6.DynamicValue
	14,  // 6: tfplugin6.ActionSchema.schema:type_name -> tfplugin6.Schema
	55,  // 7: tfplugin6.Schema.block:type_name -> tfplugin6.Schema.Block
	59,  // 8: tfplugin6.Function.parameters:type_name -> tfplugin6.Function.Parameter
	59,  // 9: tfplugin6.Function.variadic_parameter:type_name -> tfplugin6.Function.Parameter
	60,  // 10: tfplugin6.Function.return:type_name -> tfplugin6.Function.Return
	0,   // 11: tfplugin6.Function.description_kind:type_name -> tfplugin6.StringKind
	4,   // 12: tfplugin6.Deferred.reason:type_name -> tfplugin6.Deferred.Reason
	56,  // 13: tfplugin6.Schema.Block.attributes:type_name -> tfplugin6.Schema.Attribute
	57,  // 14: tfplugin6.Schema.Block.block_types:type_name -> tfplugin6.Schema.NestedBlock
	0,   // 15: tfplugin6.Schema.Block.description_kind:type_name -> tfplugin6.StringKind
	58,  // 16: tfplugin6.Schema.Attribute.nested_type:type_name -> tfplugin6.Schema.Object
	0,   // 17: tfplugin6.Schema.Attribute.description_kind:type_name -> tfplugin6.StringKind
	55,  // 18: tfplugin6.Schema.NestedBlock.block:type_name -> tfplugin6.Schema.Block
	2,   // 19: tfplugin6.Schema.NestedBlock.nesting:type_name -> tfplugin6.Schema.NestedBlock.NestingMode
	56,  // 20: tfplugin6.Schema.Object.attributes:type_name -> tfplugin6.Schema.Attribute
	3,   // 21: tfplugin6.Schema.Object.nesting:type_name -> tfplugin6.Schema.Object.NestingMode
	0,   // 22: tfplugin6.Function.Parameter.description_kind:type_name -> tfplugin6.StringKind
	16,  // 23: tfplugin6.GetMetadata.Response.server_capabilities:type_name -> tfplugin6.ServerCapabilities
	6,   // 24: tfplugin6.GetMetadata.Response.diagnostics:type_name -> tfplugin6.Diagnostic
	65,  // 25: tfplugin6.GetMetadata.Response.data_sources:type_name -> tfplugin6.GetMetadata.DataSourceMetadata
	66,  // 26: tfplugin6.GetMetadata.Response.resources:type_name -> tfplugin6.GetMetadata.ResourceMetadata
	64,  // 27: tfplugin6.GetMetadata.Response.functions:type_name -> tfplugin6.GetMetadata.FunctionMetadata
	63,  // 28: tfplugin6.GetMetadata.Response.ephemeral_resources:type_name -> tfplugin6.GetMetadata.EphemeralMetadata
	67,  // 29: tfplugin6.GetMetadata.Response.list_resources:type_name -> tfplugin6.GetMetadata.ListResourceMetadata
	68,  // 30: tfplugin6.GetMetadata.Response.state_stores:type_name -> tfplugin6.GetMetadata.StateStoreMetadata
	69,  // 31: tfplugin6.GetMetadata.Response.actions:type_name -> tfplugin6.GetMetadata.ActionMetadata
	14,  // 32: tfplugin6.GetProviderSchema.Response.provider:type_name -> tfplugin6.Schema
	72,  // 33: tfplugin6.GetProviderSchema.Response.resource_schemas:type_name -> tfplugin6.GetProviderSchema.Response.ResourceSchemasEntry
	73,  // 34: tfplugin6.GetProviderSchema.Response.data_source_schemas:type_name -> tfplugin6.GetProviderSchema.Response.DataSourceSchemasEntry
	74,  // 35: tfplugin6.GetProviderSchema.Response.functions:type_name -> tfplugin6.GetProviderSchema.Response.FunctionsEntry
	75,  // 36: tfplugin6.GetProviderSchema.Response.ephemeral_resource_schemas:type_name -> tfplugin6.GetProviderSchema.Response.EphemeralResourceSchemasEntry
	76,  // 37: tfplugin6.GetProviderSchema.Response.list_resource_schemas:type_name -> tfplugin6.GetProviderSchema.Response.ListResourceSchemasEntry
	77,  // 38: tfplugin6.GetProviderSchema.Response.state_store_schemas:type_name -> tfplugin6.GetProviderSchema.Response.StateStoreSchemasEntry
	78,  // 39: tfplugin6.GetProviderSchema.Response.action_schemas:type_name -> tfplugin6.GetProviderSchema.Response.ActionSchemasEntry
	6,   // 40: tfplugin6.GetProviderSchema.Response.diagnostics:type_name -> tfplugin6.Diagnostic
	14,  // 41: tfplugin6.GetProviderSchema.Response.provider_meta:type_name -> tfplugin6.Schema
	16,  // 42: tfplugin6.GetProviderSchema.Response.server_capabilities:type_name -> tfplugin6.ServerCapabilities
	14,  // 43: tfplugin6.GetProviderSchema.Response.ResourceSchemasEntry.value:type_name -> tfplugin6.Schema
	14,  // 44: tfplugin6.GetProviderSchema.Response.DataSourceSchemasEntry.value:type_name -> tfplugin6.Schema
	15,  // 45: tfplugin6.GetProviderSchema.Response.FunctionsEntry.value:type_name -> tfplugin6.Function
	14,  // 46: tfplugin6.GetProviderSchema.Response.EphemeralResourceSchemasEntry.value:type_name -> tfplugin6.Schema
	14,  // 47: tfplugin6.GetProviderSchema.Response.ListResourceSchemasEntry.value:type_name -> tfplugin6.Schema
	14,  // 48: tfplugin6.GetProviderSchema.Response.StateStoreSchemasEntry.value:type_name -> tfplugin6.Schema
	13,  // 49: tfplugin6.GetProviderSchema.Response.ActionSchemasEntry.value:type_name -> tfplugin6.ActionSchema
	5,   // 50: tfplugin6.ValidateProviderConfig.Request.config:type_name -> tfplugin6.DynamicValue
	6,   // 51: tfplugin6.ValidateProviderConfig.Response.diagnostics:type_name -> tfplugin6.Diagnostic
	10,  // 52: tfplugin6.UpgradeResourceState.Request.raw_state:type_name -> tfplugin6.RawState
	5,   // 53: tfplugin6.UpgradeResourceState.Response.upgraded_state:type_name -> tfplugin6.DynamicValue
	6,   // 54: tfplugin6.UpgradeResourceState.Response.diagnostics:type_name -> tfplugin6.Diagnostic
	85,  // 55: tfplugin6.GetResourceIdentitySchemas.Response.identity_schemas:type_name -> tfplugin6.GetResourceIdentitySchemas.Response.IdentitySchemasEntry
	6,   // 56: tfplugin6.GetResourceIdentitySchemas.Response.diagnostics:type_name -> tfplugin6.Diagnostic
	11,  // 57: tfplugin6.GetResourceIdentitySchemas.Response.IdentitySchemasEntry.value:type_name -> tfplugin6.ResourceIdentitySchema
	10,  // 58: tfplugin6.UpgradeResourceIdentity.Request.raw_identity:type_name -> tfplugin6.RawState
	12,  // 59: tfplugin6.UpgradeResourceIdentity.Response.upgraded_identity:type_name -> tfplugin6.ResourceIdentityData
	6,   // 60: tfplugin6.UpgradeResourceIdentity.Response.diagnostics:type_name -> tfplugin6.Diagnostic
	5,   // 61: tfplugin6.ValidateResourceConfig.Request.config:type_name -> tfplugin6.DynamicValue
	17,  // 62: tfplugin6.ValidateResourceConfig.Request.client_capabilities:type_name -> tfplugin6.ClientCapabilities
	6,   // 63: tfplugin6.ValidateResourceConfig.Response.diagnostics:type_name -> tfplugin6.Diagnostic
	5,   // 64: tfplugin6.ValidateDataResourceConfig.Request.config:type_name -> tfplugin6.DynamicValue
	6,   // 65: tfplugin6.ValidateDataResourceConfig.Response.diagnostics:type_name -> tfplugin6.Diagnostic
	5,   // 66: tfplugin6.ValidateEphemeralResourceConfig.Request.config:type_name -> tfplugin6.DynamicValue
	6,   // 67: tfplugin6.ValidateEphemeralResourceConfig.Response.diagnostics:type_name -> tfplugin6.Diagnostic
	5,   // 68: tfplugin6.ConfigureProvider.Request.config:type_name -> tfplugin6.DynamicValue
	17,  // 69: tfplugin6.ConfigureProvider.Request.client_capabilities:type_name -> tfplugin6.ClientCapabilities
	6,   // 70: tfplugin6.ConfigureProvider.Response.diagnostics:type_name -> tfplugin6.Diagnostic
	5,   // 71: tfplugin6.ReadResource.Request.current_state:type_name -> tfplugin6.DynamicValue
	5,   // 72: tfplugin6.ReadResource.Request.provider_meta:type_name -> tfplugin6.DynamicValue
	17,  // 73: tfplugin6.ReadResource.Request.client_capabilities:type_name -> tfplugin6.ClientCapabilities
	12,  // 74: tfplugin6.ReadResource.Request.current_identity:type_name -> tfplugin6.ResourceIdentityData
	5,   // 75: tfplugin6.ReadResource.Response.new_state:type_name -> tfplugin6.DynamicValue
	6,   // 76: tfplugin6.ReadResource.Response.diagnostics:type_name -> tfplugin6.Diagnostic
	18,  // 77: tfplugin6.ReadResource.Response.deferred:type_name -> tfplugin6.Deferred
	12,  // 78: tfplugin6.ReadResource.Response.new_identity:type_name -> tfplugin6.ResourceIdentityData
	5,   // 79: tfplugin6.PlanResourceChange.Request.prior_state:type_name -> tfplugin6.DynamicValue
	5,   // 80: tfplugin6.PlanResourceChange.Request.proposed_new_state:type_name -> tfplugin6.DynamicValue
	5,   // 81: tfplugin6.PlanResourceChange.Request.config:type_name -> tfplugin6.DynamicValue
	5,   // 82: tfplugin6.PlanResourceChange.Request.provider_meta:type_name -> tfplugin6.DynamicValue
	17,  // 83: tfplugin6.PlanResourceChange.Request.client_capabilities:type_name -> tfplugin6.ClientCapabilities
	12,  // 84: tfplugin6.PlanResourceChange.Request.prior_identity:type_name -> tfplugin6.ResourceIdentityData
	5,   // 85: tfplugin6.PlanResourceChange.Response.planned_state:type_name -> tfplugin6.DynamicValue
	8,   // 86: tfplugin6.PlanResourceChange.Response.requires_replace:type_name -> tfplugin6.AttributePath
	6,   // 87: tfplugin6.PlanResourceChange.Response.diagnostics:type_name -> tfplugin6.Diagnostic
	18,  // 88: tfplugin6.PlanResourceChange.Response.deferred:type_name -> tfplugin6.Deferred
	12,  // 89: tfplugin6.PlanResourceChange.Response.planned_identity:type_name -> tfplugin6.ResourceIdentityData
	5,   // 90: tfplugin6.ApplyResourceChange.Request.prior_state:type_name -> tfplugin6.DynamicValue
	5,   // 91: tfplugin6.ApplyResourceChange.Request.planned_state:type_name -> tfplugin6.DynamicValue
	5,   // 92: tfplugin6.ApplyResourceChange.Request.config:type_name -> tfplugin6.DynamicValue
	5,   // 93: tfplugin6.ApplyResourceChange.Request.provider_meta:type_name -> tfplugin6.DynamicValue
	12,  // 94: tfplugin6.ApplyResourceChange.Request.planned_identity:type_name -> tfplugin6.ResourceIdentityData
	5,   // 95: tfplugin6.ApplyResourceChange.Response.new_state:type_name -> tfplugin6.DynamicValue
	6,   // 96: tfplugin6.ApplyResourceChange.Response.diagnostics:type_name -> tfplugin6.Diagnostic
	12,  // 97: tfplugin6.ApplyResourceChange.Response.new_identity:type_name -> tfplugin6.ResourceIdentityData
	17,  // 98: tfplugin6.ImportResourceState.Request.client_capabilities:type_name -> tfplugin6.ClientCapabilities
	12,  // 99: tfplugin6.ImportResourceState.Request.identity:type_name -> tfplugin6.ResourceIdentityData
	5,   // 100: tfplugin6.ImportResourceState.ImportedResource.state:type_name -> tfplugin6.DynamicValue
	12,  // 101: tfplugin6.ImportResourceState.ImportedResource.identity:type_name -> tfplugin6.ResourceIdentityData
	103, // 102: tfplugin6.ImportResourceState.Response.imported_resources:type_name -> tfplugin6.ImportResourceState.ImportedResource
	6,   // 103: tfplugin6.ImportResourceState.Response.diagnostics:type_name -> tfplugin6.Diagnostic
	18,  // 104: tfplugin6.ImportResourceState.Response.deferred:type_name -> tfplugin6.Deferred
	5,   // 105: tfplugin6.GenerateResourceConfig.Request.state:type_name -> tfplugin6.DynamicValue
	5,   // 106: tfplugin6.GenerateResourceConfig.Response.config:type_name -> tfplugin6.DynamicValue
	6,   // 107: tfplugin6.GenerateResourceConfig.Response.diagnostics:type_name -> tfplugin6.Diagnostic
	10,  // 108: tfplugin6.MoveResourceState.Request.source_state:type_name -> tfplugin6.RawState
	10,  // 109: tfplugin6.MoveResourceState.Request.source_identity:type_name -> tfplugin6.RawState
	5,   // 110: tfplugin6.MoveResourceState.Response.target_state:type_name -> tfplugin6.DynamicValue
	6,   // 111: tfplugin6.MoveResourceState.Response.diagnostics:type_name -> tfplugin6.Diagnostic
	12,  // 112: tfplugin6.MoveResourceState.Response.target_identity:type_name -> tfplugin6.ResourceIdentityData
	5,   // 113: tfplugin6.ReadDataSource.Request.config:type_name -> tfplugin6.DynamicValue
	5,   // 114: tfplugin6.ReadDataSource.Request.provider_meta:type_name -> tfplugin6.DynamicValue
	17,  // 115: tfplugin6.ReadDataSource.Request.client_capabilities:type_name -> tfplugin6.ClientCapabilities
	5,   // 116: tfplugin6.ReadDataSource.Response.state:type_name -> tfplugin6.DynamicValue
	6,   // 117: tfplugin6.ReadDataSource.Response.diagnostics:type_name -> tfplugin6.Diagnostic
	18,  // 118: tfplugin6.ReadDataSource.Response.deferred:type_name -> tfplugin6.Deferred
	5,   // 119: tfplugin6.OpenEphemeralResource.Request.config:type_name -> tfplugin6.DynamicValue
	17,  // 120: tfplugin6.OpenEphemeralResource.Request.client_capabilities:type_name -> tfplugin6.ClientCapabilities
	6,   // 121: tfplugin6.OpenEphemeralResource.Response.diagnostics:type_name -> tfplugin6.Diagnostic
	142, // 122: tfplugin6.OpenEphemeralResource.Response.renew_at:type_name -> google.protobuf.Timestamp
	5,   // 123: tfplugin6.OpenEphemeralResource.Response.result:type_name -> tfplugin6.DynamicValue
	18,  // 124: tfplugin6.OpenEphemeralResource.Response.deferred:type_name -> tfplugin6.Deferred
	6,   // 125: tfplugin6.RenewEphemeralResource.Response.diagnostics:type_name -> tfplugin6.Diagnostic
	142, // 126: tfplugin6.RenewEphemeralResource.Response.renew_at:type_name -> google.protobuf.Timestamp
	6,   // 127: tfplugin6.CloseEphemeralResource.Response.diagnostics:type_name -> tfplugin6.Diagnostic
	119, // 128: tfplugin6.GetFunctions.Response.functions:type_name -> tfplugin6.GetFunctions.Response.FunctionsEntry
	6,   // 129: tfplugin6.GetFunctions.Response.diagnostics:type_name -> tfplugin6.Diagnostic
	15,  // 130: tfplugin6.GetFunctions.Response.FunctionsEntry.value:type_name -> tfplugin6.Function
	5,   // 131: tfplugin6.CallFunction.Request.arguments:type_name -> tfplugin6.DynamicValue
	5,   // 132: tfplugin6.CallFunction.Response.result:type_name -> tfplugin6.DynamicValue
	7,   // 133: tfplugin6.CallFunction.Response.error:type_name -> tfplugin6.FunctionError
	5,   // 134: tfplugin6.ListResource.Request.config:type_name -> tfplugin6.DynamicValue
	12,  // 135: tfplugin6.ListResource.Event.identity:type_name -> tfplugin6.ResourceIdentityData
	5,   // 136: tfplugin6.ListResource.Event.resource_object:type_name -> tfplugin6.DynamicValue
	6,   // 137: tfplugin6.ListResource.Event.diagnostic:type_name -> tfplugin6.Diagnostic
	5,   // 138: tfplugin6.ValidateListResourceConfig.Request.config:type_name -> tfplugin6.DynamicValue
	5,   // 139: tfplugin6.ValidateListResourceConfig.Request.include_resource_object:type_name -> tfplugin6.DynamicValue
	5,   // 140: tfplugin6.ValidateListResourceConfig.Request.limit:type_name -> tfplugin6.DynamicValue
	6,   // 141: tfplugin6.ValidateListResourceConfig.Response.diagnostics:type_name -> tfplugin6.Diagnostic
	5,   // 142: tfplugin6.ValidateStateStore.Request.config:type_name -> tfplugin6.DynamicValue
	6,   // 143: tfplugin6.ValidateStateStore.Response.diagnostics:type_name -> tfplugin6.Diagnostic
	5,   // 144: tfplugin6.ConfigureStateStore.Request.config:type_name -> tfplugin6.DynamicValue
	6,   // 145: tfplugin6.ConfigureStateStore.Response.diagnostics:type_name -> tfplugin6.Diagnostic
	6,   // 146: tfplugin6.GetStates.Response.diagnostics:type_name -> tfplugin6.Diagnostic
	6,   // 147: tfplugin6.DeleteState.Response.diagnostics:type_name -> tfplugin6.Diagnostic
	5,   // 148: tfplugin6.PlanAction.Request.config:type_name -> tfplugin6.DynamicValue
	17,  // 149: tfplugin6.PlanAction.Request.client_capabilities:type_name -> tfplugin6.ClientCapabilities
	6,   // 150: tfplugin6.PlanAction.Response.diagnostics:type_name -> tfplugin6.Diagnostic
	18,  // 151: tfplugin6.PlanAction.Response.deferred:type_name -> tfplugin6.Deferred
	5,   // 152: tfplugin6.InvokeAction.Request.config:type_name -> tfplugin6.DynamicValue
	17,  // 153: tfplugin6.InvokeAction.Request.client_capabilities:type_name -> tfplugin6.ClientCapabilities
	138, // 154: tfplugin6.InvokeAction.Event.progress:type_name -> tfplugin6.InvokeAction.Event.Progress
	139, // 155: tfplugin6.InvokeAction.Event.completed:type_name -> tfplugin6.InvokeAction.Event.Completed
	6,   // 156: tfplugin6.InvokeAction.Event.Completed.diagnostics:type_name -> tfplugin6.Diagnostic
	5,   // 157: tfplugin6.ValidateActionConfig.Request.config:type_name -> tfplugin6.DynamicValue
	6,   // 158: tfplugin6.ValidateActionConfig.Response.diagnostics:type_name -> tfplugin6.Diagnostic
	61,  // 159: tfplugin6.Provider.GetMetadata:input_type -> tfplugin6.GetMetadata.Request
	70,  // 160: tfplugin6.Provider.GetProviderSchema:input_type -> tfplugin6.GetProviderSchema.Request
	79,  // 161: tfplugin6.Provider.ValidateProviderConfig:input_type -> tfplugin6.ValidateProviderConfig.Request
	88,  // 162: tfplugin6.Provider.ValidateResourceConfig:input_type -> tfplugin6.ValidateResourceConfig.Request
	90,  // 163: tfplugin6.Provider.ValidateDataResourceConfig:input_type -> tfplugin6.ValidateDataResourceConfig.Request
	81,  // 164: tfplugin6.Provider.UpgradeResourceState:input_type -> tfplugin6.UpgradeResourceState.Request
	83,  // 165: tfplugin6.Provider.GetResourceIdentitySchemas:input_type -> tfplugin6.GetResourceIdentitySchemas.Request
	86,  // 166: tfplugin6.Provider.UpgradeResourceIdentity:input_type -> tfplugin6.UpgradeResourceIdentity.Request
	94,  // 167: tfplugin6.Provider.ConfigureProvider:input_type -> tfplugin6.ConfigureProvider.Request
	96,  // 168: tfplugin6.Provider.ReadResource:input_type -> tfplugin6.ReadResource.Request
	98,  // 169: tfplugin6.Provider.PlanResourceChange:input_type -> tfplugin6.PlanResourceChange.Request
	100, // 170: tfplugin6.Provider.ApplyResourceChange:input_type -> tfplugin6.ApplyResourceChange.Request
	102, // 171: tfplugin6.Provider.ImportResourceState:input_type -> tfplugin6.ImportResourceState.Request
	107, // 172: tfplugin6.Provider.MoveResourceState:input_type -> tfplugin6.MoveResourceState.Request
	109, // 173: tfplugin6.Provider.ReadDataSource:input_type -> tfplugin6.ReadDataSource.Request
	105, // 174: tfplugin6.Provider.GenerateResourceConfig:input_type -> tfplugin6.GenerateResourceConfig.Request
	92,  // 175: tfplugin6.Provider.ValidateEphemeralResourceConfig:input_type -> tfplugin6.ValidateEphemeralResourceConfig.Request
	111, // 176: tfplugin6.Provider.OpenEphemeralResource:input_type -> tfplugin6.OpenEphemeralResource.Request
	113, // 177: tfplugin6.Provider.RenewEphemeralResource:input_type -> tfplugin6.RenewEphemeralResource.Request
	115, // 178: tfplugin6.Provider.CloseEphemeralResource:input_type -> tfplugin6.CloseEphemeralResource.Request
	122, // 179: tfplugin6.Provider.ListResource:input_type -> tfplugin6.ListResource.Request
	124, // 180: tfplugin6.Provider.ValidateListResourceConfig:input_type -> tfplugin6.ValidateListResourceConfig.Request
	117, // 181: tfplugin6.Provider.GetFunctions:input_type -> tfplugin6.GetFunctions.Request
	120, // 182: tfplugin6.Provider.CallFunction:input_type -> tfplugin6.CallFunction.Request
	126, // 183: tfplugin6.Provider.ValidateStateStoreConfig:input_type -> tfplugin6.ValidateStateStore.Request
	128, // 184: tfplugin6.Provider.ConfigureStateStore:input_type -> tfplugin6.ConfigureStateStore.Request
	130, // 185: tfplugin6.Provider.GetStates:input_type -> tfplugin6.GetStates.Request
	132, // 186: tfplugin6.Provider.DeleteState:input_type -> tfplugin6.DeleteState.Request
	134, // 187: tfplugin6.Provider.PlanAction:input_type -> tfplugin6.PlanAction.Request
	136, // 188: tfplugin6.Provider.InvokeAction:input_type -> tfplugin6.InvokeAction.Request
	140, // 189: tfplugin6.Provider.ValidateActionConfig:input_type -> tfplugin6.ValidateActionConfig.Request
	51,  // 190: tfplugin6.Provider.StopProvider:input_type -> tfplugin6.StopProvider.Request
	62,  // 191: tfplugin6.Provider.GetMetadata:output_type -> tfplugin6.GetMetadata.Response
	71,  // 192: tfplugin6.Provider.GetProviderSchema:output_type -> tfplugin6.GetProviderSchema.Response
	80,  // 193: tfplugin6.Provider.ValidateProviderConfig:output_type -> tfplugin6.ValidateProviderConfig.Response
	89,  // 194: tfplugin6.Provider.ValidateResourceConfig:output_type -> tfplugin6.ValidateResourceConfig.Response
	91,  // 195: tfplugin6.Provider.ValidateDataResourceConfig:output_type -> tfplugin6.ValidateDataResourceConfig.Response
	82,  // 196: tfplugin6.Provider.UpgradeResourceState:output_type -> tfplugin6.UpgradeResourceState.Response
	84,  // 197: tfplugin6.Provider.GetResourceIdentitySchemas:output_type -> tfplugin6.GetResourceIdentitySchemas.Response
	87,  // 198: tfplugin6.Provider.UpgradeResourceIdentity:output_type -> tfplugin6.UpgradeResourceIdentity.Response
	95,  // 199: tfplugin6.Provider.ConfigureProvider:output_type -> tfplugin6.ConfigureProvider.Response
	97,  // 200: tfplugin6.Provider.ReadResource:output_type -> tfplugin6.ReadResource.Response
	99,  // 201: tfplugin6.Provider.PlanResourceChange:output_type -> tfplugin6.PlanResourceChange.Response
	101, // 202: tfplugin6.Provider.ApplyResourceChange:output_type -> tfplugin6.ApplyResourceChange.Response
	104, // 203: tfplugin6.Provider.ImportResourceState:output_type -> tfplugin6.ImportResourceState.Response
	108, // 204: tfplugin6.Provider.MoveResourceState:output_type -> tfplugin6.MoveResourceState.Response
	110, // 205: tfplugin6.Provider.ReadDataSource:output_type -> tfplugin6.ReadDataSource.Response
	106, // 206: tfplugin6.Provider.GenerateResourceConfig:output_type -> tfplugin6.GenerateResourceConfig.Response
	93,  // 207: tfplugin6.Provider.ValidateEphemeralResourceConfig:output_type -> tfplugin6.ValidateEphemeralResourceConfig.Response
	112, // 208: tfplugin6.Provider.OpenEphemeralResource:output_type -> tfplugin6.OpenEphemeralResource.Response
	114, // 209: tfplugin6.Provider.RenewEphemeralResource:output_type -> tfplugin6.RenewEphemeralResource.Response
	116, // 210: tfplugin6.Provider.CloseEphemeralResource:output_type -> tfplugin6.CloseEphemeralResource.Response
	123, // 211: tfplugin6.Provider.ListResource:output_type -> tfplugin6.ListResource.Event
	125, // 212: tfplugin6.Provider.ValidateListResourceConfig:output_type -> tfplugin6.ValidateListResourceConfig.Response
	118, // 213: tfplugin6.Provider.GetFunctions:output_type -> tfplugin6.GetFunctions.Response
	121, // 214: tfplugin6.Provider.CallFunction:output_type -> tfplugin6.CallFunction.Response
	127, // 215: tfplugin6.Provider.ValidateStateStoreConfig:output_type -> tfplugin6.ValidateStateStore.Response
	129, // 216: tfplugin6.Provider.ConfigureStateStore:output_type -> tfplugin6.ConfigureStateStore.Response
	131, // 217: tfplugin6.Provider.GetStates:output_type -> tfplugin6.GetStates.Response
	133, // 218: tfplugin6.Provider.DeleteState:output_type -> tfplugin6.DeleteState.Response
	135, // 219: tfplugin6.Provider.PlanAction:output_type -> tfplugin6.PlanAction.Response
	137, // 220: tfplugin6.Provider.InvokeAction:output_type -> tfplugin6.InvokeAction.Event
	141, // 221: tfplugin6.Provider.ValidateActionConfig:output_type -> tfplugin6.ValidateActionConfig.Response
	52,  // 222: tfplugin6.Provider.StopProvider:output_type -> tfplugin6.StopProvider.Response
	191, // [191:223] is the sub-list for method output_type
	159, // [159:191] is the sub-list for method input_type
	159, // [159:159] is the sub-list for extension type_name
	159, // [159:159] is the sub-list for extension extendee
	0,   // [0:159] is the sub-list for field type_name
}

func init() { file_tfplugin6_proto_init() }
func file_tfplugin6_proto_init() {
	if File_tfplugin6_proto != nil {
		return
	}
	file_tfplugin6_proto_msgTypes[2].OneofWrappers = []any{}
	file_tfplugin6_proto_msgTypes[45].OneofWrappers = []any{
		(*AttributePath_Step_AttributeName)(nil),
		(*AttributePath_Step_ElementKeyString)(nil),
		(*AttributePath_Step_ElementKeyInt)(nil),
	}
	file_tfplugin6_proto_msgTypes[107].OneofWrappers = []any{}
	file_tfplugin6_proto_msgTypes[108].OneofWrappers = []any{}
	file_tfplugin6_proto_msgTypes[109].OneofWrappers = []any{}
	file_tfplugin6_proto_msgTypes[110].OneofWrappers = []any{}
	file_tfplugin6_proto_msgTypes[118].OneofWrappers = []any{}
	file_tfplugin6_proto_msgTypes[132].OneofWrappers = []any{
		(*InvokeAction_Event_Progress_)(nil),
		(*InvokeAction_Event_Completed_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_tfplugin6_proto_rawDesc), len(file_tfplugin6_proto_rawDesc)),
			NumEnums:      5,
			NumMessages:   137,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_tfplugin6_proto_goTypes,
		DependencyIndexes: file_tfplugin6_proto_depIdxs,
		EnumInfos:         file_tfplugin6_proto_enumTypes,
		MessageInfos:      file_tfplugin6_proto_msgTypes,
	}.Build()
	File_tfplugin6_proto = out.File
	file_tfplugin6_proto_goTypes = nil
	file_tfplugin6_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ProviderClient is the client API for Provider service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ProviderClient interface {
	// GetMetadata returns upfront information about server capabilities and
	// supported resource types without requiring the server to instantiate all
	// schema information, which may be memory intensive.
	// This method is CURRENTLY UNUSED and it serves mostly for convenience
	// of code generation inside of terraform-plugin-mux.
	GetMetadata(ctx context.Context, in *GetMetadata_Request, opts ...grpc.CallOption) (*GetMetadata_Response, error)
	// GetSchema returns schema information for the provider, data resources,
	// and managed resources.
	GetProviderSchema(ctx context.Context, in *GetProviderSchema_Request, opts ...grpc.CallOption) (*GetProviderSchema_Response, error)
	ValidateProviderConfig(ctx context.Context, in *ValidateProviderConfig_Request, opts ...grpc.CallOption) (*ValidateProviderConfig_Response, error)
	ValidateResourceConfig(ctx context.Context, in *ValidateResourceConfig_Request, opts ...grpc.CallOption) (*ValidateResourceConfig_Response, error)
	ValidateDataResourceConfig(ctx context.Context, in *ValidateDataResourceConfig_Request, opts ...grpc.CallOption) (*ValidateDataResourceConfig_Response, error)
	UpgradeResourceState(ctx context.Context, in *UpgradeResourceState_Request, opts ...grpc.CallOption) (*UpgradeResourceState_Response, error)
	// GetResourceIdentitySchemas returns the identity schemas for all managed
	// resources.
	GetResourceIdentitySchemas(ctx context.Context, in *GetResourceIdentitySchemas_Request, opts ...grpc.CallOption) (*GetResourceIdentitySchemas_Response, error)
	// UpgradeResourceIdentityData should return the upgraded resource identity
	// data for a managed resource type.
	UpgradeResourceIdentity(ctx context.Context, in *UpgradeResourceIdentity_Request, opts ...grpc.CallOption) (*UpgradeResourceIdentity_Response, error)
	// ////// One-time initialization, called before other functions below
	ConfigureProvider(ctx context.Context, in *ConfigureProvider_Request, opts ...grpc.CallOption) (*ConfigureProvider_Response, error)
	// ////// Managed Resource Lifecycle
	ReadResource(ctx context.Context, in *ReadResource_Request, opts ...grpc.CallOption) (*ReadResource_Response, error)
	PlanResourceChange(ctx context.Context, in *PlanResourceChange_Request, opts ...grpc.CallOption) (*PlanResourceChange_Response, error)
	ApplyResourceChange(ctx context.Context, in *ApplyResourceChange_Request, opts ...grpc.CallOption) (*ApplyResourceChange_Response, error)
	ImportResourceState(ctx context.Context, in *ImportResourceState_Request, opts ...grpc.CallOption) (*ImportResourceState_Response, error)
	MoveResourceState(ctx context.Context, in *MoveResourceState_Request, opts ...grpc.CallOption) (*MoveResourceState_Response, error)
	ReadDataSource(ctx context.Context, in *ReadDataSource_Request, opts ...grpc.CallOption) (*ReadDataSource_Response, error)
	GenerateResourceConfig(ctx context.Context, in *GenerateResourceConfig_Request, opts ...grpc.CallOption) (*GenerateResourceConfig_Response, error)
	// ////// Ephemeral Resource Lifecycle
	ValidateEphemeralResourceConfig(ctx context.Context, in *ValidateEphemeralResourceConfig_Request, opts ...grpc.CallOption) (*ValidateEphemeralResourceConfig_Response, error)
	OpenEphemeralResource(ctx context.Context, in *OpenEphemeralResource_Request, opts ...grpc.CallOption) (*OpenEphemeralResource_Response, error)
	RenewEphemeralResource(ctx context.Context, in *RenewEphemeralResource_Request, opts ...grpc.CallOption) (*RenewEphemeralResource_Response, error)
	CloseEphemeralResource(ctx context.Context, in *CloseEphemeralResource_Request, opts ...grpc.CallOption) (*CloseEphemeralResource_Response, error)
	// ///// List
	ListResource(ctx context.Context, in *ListResource_Request, opts ...grpc.CallOption) (Provider_ListResourceClient, error)
	ValidateListResourceConfig(ctx context.Context, in *ValidateListResourceConfig_Request, opts ...grpc.CallOption) (*ValidateListResourceConfig_Response, error)
	// GetFunctions returns the definitions of all functions.
	GetFunctions(ctx context.Context, in *GetFunctions_Request, opts ...grpc.CallOption) (*GetFunctions_Response, error)
	// ////// Provider-contributed Functions
	CallFunction(ctx context.Context, in *CallFunction_Request, opts ...grpc.CallOption) (*CallFunction_Response, error)
	// ValidateStateStoreConfig performs configuration validation
	ValidateStateStoreConfig(ctx context.Context, in *ValidateStateStore_Request, opts ...grpc.CallOption) (*ValidateStateStore_Response, error)
	// ConfigureStateStore configures the state store, such as S3 connection in the context of already configured provider
	ConfigureStateStore(ctx context.Context, in *ConfigureStateStore_Request, opts ...grpc.CallOption) (*ConfigureStateStore_Response, error)
	// GetStates returns a list of all states (i.e. CE workspaces) managed by a given state store
	GetStates(ctx context.Context, in *GetStates_Request, opts ...grpc.CallOption) (*GetStates_Response, error)
	// DeleteState instructs a given state store to delete a specific state (i.e. a CE workspace)
	DeleteState(ctx context.Context, in *DeleteState_Request, opts ...grpc.CallOption) (*DeleteState_Response, error)
	// ////// Actions
	PlanAction(ctx context.Context, in *PlanAction_Request, opts ...grpc.CallOption) (*PlanAction_Response, error)
	InvokeAction(ctx context.Context, in *InvokeAction_Request, opts ...grpc.CallOption) (Provider_InvokeActionClient, error)
	ValidateActionConfig(ctx context.Context, in *ValidateActionConfig_Request, opts ...grpc.CallOption) (*ValidateActionConfig_Response, error)
	// ////// Graceful Shutdown
	StopProvider(ctx context.Context, in *StopProvider_Request, opts ...grpc.CallOption) (*StopProvider_Response, error)
}

type providerClient struct {
	cc grpc.ClientConnInterface
}

func NewProviderClient(cc grpc.ClientConnInterface) ProviderClient {
	return &providerClient{cc}
}

func (c *providerClient) GetMetadata(ctx context.Context, in *GetMetadata_Request, opts ...grpc.CallOption) (*GetMetadata_Response, error) {
	out := new(GetMetadata_Response)
	err := c.cc.Invoke(ctx, "/tfplugin6.Provider/GetMetadata", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *providerClient) GetProviderSchema(ctx context.Context, in *GetProviderSchema_Request, opts ...grpc.CallOption) (*GetProviderSchema_Response, error) {
	out := new(GetProviderSchema_Response)
	err := c.cc.Invoke(ctx, "/tfplugin6.Provider/GetProviderSchema", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *providerClient) ValidateProviderConfig(ctx context.Context, in *ValidateProviderConfig_Request, opts ...grpc.CallOption) (*ValidateProviderConfig_Response, error) {
	out := new(ValidateProviderConfig_Response)
	err := c.cc.Invoke(ctx, "/tfplugin6.Provider/ValidateProviderConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *providerClient) ValidateResourceConfig(ctx context.Context, in *ValidateResourceConfig_Request, opts ...grpc.CallOption) (*ValidateResourceConfig_Response, error) {
	out := new(ValidateResourceConfig_Response)
	err := c.cc.Invoke(ctx, "/tfplugin6.Provider/ValidateResourceConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *providerClient) ValidateDataResourceConfig(ctx context.Context, in *ValidateDataResourceConfig_Request, opts ...grpc.CallOption) (*ValidateDataResourceConfig_Response, error) {
	out := new(ValidateDataResourceConfig_Response)
	err := c.cc.Invoke(ctx, "/tfplugin6.Provider/ValidateDataResourceConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *providerClient) UpgradeResourceState(ctx context.Context, in *UpgradeResourceState_Request, opts ...grpc.CallOption) (*UpgradeResourceState_Response, error) {
	out := new(UpgradeResourceState_Response)
	err := c.cc.Invoke(ctx, "/tfplugin6.Provider/UpgradeResourceState", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *providerClient) GetResourceIdentitySchemas(ctx context.Context, in *GetResourceIdentitySchemas_Request, opts ...grpc.CallOption) (*GetResourceIdentitySchemas_Response, error) {
	out := new(GetResourceIdentitySchemas_Response)
	err := c.cc.Invoke(ctx, "/tfplugin6.Provider/GetResourceIdentitySchemas", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *providerClient) UpgradeResourceIdentity(ctx context.Context, in *UpgradeResourceIdentity_Request, opts ...grpc.CallOption) (*UpgradeResourceIdentity_Response, error) {
	out := new(UpgradeResourceIdentity_Response)
	err := c.cc.Invoke(ctx, "/tfplugin6.Provider/UpgradeResourceIdentity", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *providerClient) ConfigureProvider(ctx context.Context, in *ConfigureProvider_Request, opts ...grpc.CallOption) (*ConfigureProvider_Response, error) {
	out := new(ConfigureProvider_Response)
	err := c.cc.Invoke(ctx, "/tfplugin6.Provider/ConfigureProvider", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *providerClient) ReadResource(ctx context.Context, in *ReadResource_Request, opts ...grpc.CallOption) (*ReadResource_Response, error) {
	out := new(ReadResource_Response)
	err := c.cc.Invoke(ctx, "/tfplugin6.Provider/ReadResource", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *providerClient) PlanResourceChange(ctx context.Context, in *PlanResourceChange_Request, opts ...grpc.CallOption) (*PlanResourceChange_Response, error) {
	out := new(PlanResourceChange_Response)
	err := c.cc.Invoke(ctx, "/tfplugin6.Provider/PlanResourceChange", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *providerClient) ApplyResourceChange(ctx context.Context, in *ApplyResourceChange_Request, opts ...grpc.CallOption) (*ApplyResourceChange_Response, error) {
	out := new(ApplyResourceChange_Response)
	err := c.cc.Invoke(ctx, "/tfplugin6.Provider/ApplyResourceChange", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *providerClient) ImportResourceState(ctx context.Context, in *ImportResourceState_Request, opts ...grpc.CallOption) (*ImportResourceState_Response, error) {
	out := new(ImportResourceState_Response)
	err := c.cc.Invoke(ctx, "/tfplugin6.Provider/ImportResourceState", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *providerClient) MoveResourceState(ctx context.Context, in *MoveResourceState_Request, opts ...grpc.CallOption) (*MoveResourceState_Response, error) {
	out := new(MoveResourceState_Response)
	err := c.cc.Invoke(ctx, "/tfplugin6.Provider/MoveResourceState", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *providerClient) ReadDataSource(ctx context.Context, in *ReadDataSource_Request, opts ...grpc.CallOption) (*ReadDataSource_Response, error) {
	out := new(ReadDataSource_Response)
	err := c.cc.Invoke(ctx, "/tfplugin6.Provider/ReadDataSource", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *providerClient) GenerateResourceConfig(ctx context.Context, in *GenerateResourceConfig_Request, opts ...grpc.CallOption) (*GenerateResourceConfig_Response, error) {
	out := new(GenerateResourceConfig_Response)
	err := c.cc.Invoke(ctx, "/tfplugin6.Provider/GenerateResourceConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *providerClient) ValidateEphemeralResourceConfig(ctx context.Context, in *ValidateEphemeralResourceConfig_Request, opts ...grpc.CallOption) (*ValidateEphemeralResourceConfig_Response, error) {
	out := new(ValidateEphemeralResourceConfig_Response)
	err := c.cc.Invoke(ctx, "/tfplugin6.Provider/ValidateEphemeralResourceConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *providerClient) OpenEphemeralResource(ctx context.Context, in *OpenEphemeralResource_Request, opts ...grpc.CallOption) (*OpenEphemeralResource_Response, error) {
	out := new(OpenEphemeralResource_Response)
	err := c.cc.Invoke(ctx, "/tfplugin6.Provider/OpenEphemeralResource", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *providerClient) RenewEphemeralResource(ctx context.Context, in *RenewEphemeralResource_Request, opts ...grpc.CallOption) (*RenewEphemeralResource_Response, error) {
	out := new(RenewEphemeralResource_Response)
	err := c.cc.Invoke(ctx, "/tfplugin6.Provider/RenewEphemeralResource", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *providerClient) CloseEphemeralResource(ctx context.Context, in *CloseEphemeralResource_Request, opts ...grpc.CallOption) (*CloseEphemeralResource_Response, error) {
	out := new(CloseEphemeralResource_Response)
	err := c.cc.Invoke(ctx, "/tfplugin6.Provider/CloseEphemeralResource", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *providerClient) ListResource(ctx context.Context, in *ListResource_Request, opts ...grpc.CallOption) (Provider_ListResourceClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Provider_serviceDesc.Streams[0], "/tfplugin6.Provider/ListResource", opts...)
	if err != nil {
		return nil, err
	}
	x := &providerListResourceClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Provider_ListResourceClient interface {
	Recv() (*ListResource_Event, error)
	grpc.ClientStream
}

type providerListResourceClient struct {
	grpc.ClientStream
}

func (x *providerListResourceClient) Recv() (*ListResource_Event, error) {
	m := new(ListResource_Event)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *providerClient) ValidateListResourceConfig(ctx context.Context, in *ValidateListResourceConfig_Request, opts ...grpc.CallOption) (*ValidateListResourceConfig_Response, error) {
	out := new(ValidateListResourceConfig_Response)
	err := c.cc.Invoke(ctx, "/tfplugin6.Provider/ValidateListResourceConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *providerClient) GetFunctions(ctx context.Context, in *GetFunctions_Request, opts ...grpc.CallOption) (*GetFunctions_Response, error) {
	out := new(GetFunctions_Response)
	err := c.cc.Invoke(ctx, "/tfplugin6.Provider/GetFunctions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *providerClient) CallFunction(ctx context.Context, in *CallFunction_Request, opts ...grpc.CallOption) (*CallFunction_Response, error) {
	out := new(CallFunction_Response)
	err := c.cc.Invoke(ctx, "/tfplugin6.Provider/CallFunction", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *providerClient) ValidateStateStoreConfig(ctx context.Context, in *ValidateStateStore_Request, opts ...grpc.CallOption) (*ValidateStateStore_Response, error) {
	out := new(ValidateStateStore_Response)
	err := c.cc.Invoke(ctx, "/tfplugin6.Provider/ValidateStateStoreConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *providerClient) ConfigureStateStore(ctx context.Context, in *ConfigureStateStore_Request, opts ...grpc.CallOption) (*ConfigureStateStore_Response, error) {
	out := new(ConfigureStateStore_Response)
	err := c.cc.Invoke(ctx, "/tfplugin6.Provider/ConfigureStateStore", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *providerClient) GetStates(ctx context.Context, in *GetStates_Request, opts ...grpc.CallOption) (*GetStates_Response, error) {
	out := new(GetStates_Response)
	err := c.cc.Invoke(ctx, "/tfplugin6.Provider/GetStates", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *providerClient) DeleteState(ctx context.Context, in *DeleteState_Request, opts ...grpc.CallOption) (*DeleteState_Response, error) {
	out := new(DeleteState_Response)
	err := c.cc.Invoke(ctx, "/tfplugin6.Provider/DeleteState", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *providerClient) PlanAction(ctx context.Context, in *PlanAction_Request, opts ...grpc.CallOption) (*PlanAction_Response, error) {
	out := new(PlanAction_Response)
	err := c.cc.Invoke(ctx, "/tfplugin6.Provider/PlanAction", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *providerClient) InvokeAction(ctx context.Context, in *InvokeAction_Request, opts ...grpc.CallOption) (Provider_InvokeActionClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Provider_serviceDesc.Streams[1], "/tfplugin6.Provider/InvokeAction", opts...)
	if err != nil {
		return nil, err
	}
	x := &providerInvokeActionClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Provider_InvokeActionClient interface {
	Recv() (*InvokeAction_Event, error)
	grpc.ClientStream
}

type providerInvokeActionClient struct {
	grpc.ClientStream
}

func (x *providerInvokeActionClient) Recv() (*InvokeAction_Event, error) {
	m := new(InvokeAction_Event)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *providerClient) ValidateActionConfig(ctx context.Context, in *ValidateActionConfig_Request, opts ...grpc.CallOption) (*ValidateActionConfig_Response, error) {
	out := new(ValidateActionConfig_Response)
	err := c.cc.Invoke(ctx, "/tfplugin6.Provider/ValidateActionConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *providerClient) StopProvider(ctx context.Context, in *StopProvider_Request, opts ...grpc.CallOption) (*StopProvider_Response, error) {
	out := new(StopProvider_Response)
	err := c.cc.Invoke(ctx, "/tfplugin6.Provider/StopProvider", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ProviderServer is the server API for Provider service.
type ProviderServer interface {
	// GetMetadata returns upfront information about server capabilities and
	// supported resource types without requiring the server to instantiate all
	// schema information, which may be memory intensive.
	// This method is CURRENTLY UNUSED and it serves mostly for convenience
	// of code generation inside of terraform-plugin-mux.
	GetMetadata(context.Context, *GetMetadata_Request) (*GetMetadata_Response, error)
	// GetSchema returns schema information for the provider, data resources,
	// and managed resources.
	GetProviderSchema(context.Context, *GetProviderSchema_Request) (*GetProviderSchema_Response, error)
	ValidateProviderConfig(context.Context, *ValidateProviderConfig_Request) (*ValidateProviderConfig_Response, error)
	ValidateResourceConfig(context.Context, *ValidateResourceConfig_Request) (*ValidateResourceConfig_Response, error)
	ValidateDataResourceConfig(context.Context, *ValidateDataResourceConfig_Request) (*ValidateDataResourceConfig_Response, error)
	UpgradeResourceState(context.Context, *UpgradeResourceState_Request) (*UpgradeResourceState_Response, error)
	// GetResourceIdentitySchemas returns the identity schemas for all managed
	// resources.
	GetResourceIdentitySchemas(context.Context, *GetResourceIdentitySchemas_Request) (*GetResourceIdentitySchemas_Response, error)
	// UpgradeResourceIdentityData should return the upgraded resource identity
	// data for a managed resource type.
	UpgradeResourceIdentity(context.Context, *UpgradeResourceIdentity_Request) (*UpgradeResourceIdentity_Response, error)
	// ////// One-time initialization, called before other functions below
	ConfigureProvider(context.Context, *ConfigureProvider_Request) (*ConfigureProvider_Response, error)
	// ////// Managed Resource Lifecycle
	ReadResource(context.Context, *ReadResource_Request) (*ReadResource_Response, error)
	PlanResourceChange(context.Context, *PlanResourceChange_Request) (*PlanResourceChange_Response, error)
	ApplyResourceChange(context.Context, *ApplyResourceChange_Request) (*ApplyResourceChange_Response, error)
	ImportResourceState(context.Context, *ImportResourceState_Request) (*ImportResourceState_Response, error)
	MoveResourceState(context.Context, *MoveResourceState_Request) (*MoveResourceState_Response, error)
	ReadDataSource(context.Context, *ReadDataSource_Request) (*ReadDataSource_Response, error)
	GenerateResourceConfig(context.Context, *GenerateResourceConfig_Request) (*GenerateResourceConfig_Response, error)
	// ////// Ephemeral Resource Lifecycle
	ValidateEphemeralResourceConfig(context.Context, *ValidateEphemeralResourceConfig_Request) (*ValidateEphemeralResourceConfig_Response, error)
	OpenEphemeralResource(context.Context, *OpenEphemeralResource_Request) (*OpenEphemeralResource_Response, error)
	RenewEphemeralResource(context.Context, *RenewEphemeralResource_Request) (*RenewEphemeralResource_Response, error)
	CloseEphemeralResource(context.Context, *CloseEphemeralResource_Request) (*CloseEphemeralResource_Response, error)
	// ///// List
	ListResource(*ListResource_Request, Provider_ListResourceServer) error
	ValidateListResourceConfig(context.Context, *ValidateListResourceConfig_Request) (*ValidateListResourceConfig_Response, error)
	// GetFunctions returns the definitions of all functions.
	GetFunctions(context.Context, *GetFunctions_Request) (*GetFunctions_Response, error)
	// ////// Provider-contributed Functions
	CallFunction(context.Context, *CallFunction_Request) (*CallFunction_Response, error)
	// ValidateStateStoreConfig performs configuration validation
	ValidateStateStoreConfig(context.Context, *ValidateStateStore_Request) (*ValidateStateStore_Response, error)
	// ConfigureStateStore configures the state store, such as S3 connection in the context of already configured provider
	ConfigureStateStore(context.Context, *ConfigureStateStore_Request) (*ConfigureStateStore_Response, error)
	// GetStates returns a list of all states (i.e. CE workspaces) managed by a given state store
	GetStates(context.Context, *GetStates_Request) (*GetStates_Response, error)
	// DeleteState instructs a given state store to delete a specific state (i.e. a CE workspace)
	DeleteState(context.Context, *DeleteState_Request) (*DeleteState_Response, error)
	// ////// Actions
	PlanAction(context.Context, *PlanAction_Request) (*PlanAction_Response, error)
	InvokeAction(*InvokeAction_Request, Provider_InvokeActionServer) error
	ValidateActionConfig(context.Context, *ValidateActionConfig_Request) (*ValidateActionConfig_Response, error)
	// ////// Graceful Shutdown
	StopProvider(context.Context, *StopProvider_Request) (*StopProvider_Response, error)
}

// UnimplementedProviderServer can be embedded to have forward compatible implementations.
type UnimplementedProviderServer struct {
}

func (*UnimplementedProviderServer) GetMetadata(context.Context, *GetMetadata_Request) (*GetMetadata_Response, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetMetadata not implemented")
}
func (*UnimplementedProviderServer) GetProviderSchema(context.Context, *GetProviderSchema_Request) (*GetProviderSchema_Response, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetProviderSchema not implemented")
}
func (*UnimplementedProviderServer) ValidateProviderConfig(context.Context, *ValidateProviderConfig_Request) (*ValidateProviderConfig_Response, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ValidateProviderConfig not implemented")
}
func (*UnimplementedProviderServer) ValidateResourceConfig(context.Context, *ValidateResourceConfig_Request) (*ValidateResourceConfig_Response, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ValidateResourceConfig not implemented")
}
func (*UnimplementedProviderServer) ValidateDataResourceConfig(context.Context, *ValidateDataResourceConfig_Request) (*ValidateDataResourceConfig_Response, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ValidateDataResourceConfig not implemented")
}
func (*UnimplementedProviderServer) UpgradeResourceState(context.Context, *UpgradeResourceState_Request) (*UpgradeResourceState_Response, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpgradeResourceState not implemented")
}
func (*UnimplementedProviderServer) GetResourceIdentitySchemas(context.Context, *GetResourceIdentitySchemas_Request) (*GetResourceIdentitySchemas_Response, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetResourceIdentitySchemas not implemented")
}
func (*UnimplementedProviderServer) UpgradeResourceIdentity(context.Context, *UpgradeResourceIdentity_Request) (*UpgradeResourceIdentity_Response, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpgradeResourceIdentity not implemented")
}
func (*UnimplementedProviderServer) ConfigureProvider(context.Context, *ConfigureProvider_Request) (*ConfigureProvider_Response, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ConfigureProvider not implemented")
}
func (*UnimplementedProviderServer) ReadResource(context.Context, *ReadResource_Request) (*ReadResource_Response, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReadResource not implemented")
}
func (*UnimplementedProviderServer) PlanResourceChange(context.Context, *PlanResourceChange_Request) (*PlanResourceChange_Response, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PlanResourceChange not implemented")
}
func (*UnimplementedProviderServer) ApplyResourceChange(context.Context, *ApplyResourceChange_Request) (*ApplyResourceChange_Response, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ApplyResourceChange not implemented")
}
func (*UnimplementedProviderServer) ImportResourceState(context.Context, *ImportResourceState_Request) (*ImportResourceState_Response, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ImportResourceState not implemented")
}
func (*UnimplementedProviderServer) MoveResourceState(context.Context, *MoveResourceState_Request) (*MoveResourceState_Response, error) {
	return nil, status.Errorf(codes.Unimplemented, "method MoveResourceState not implemented")
}
func (*UnimplementedProviderServer) ReadDataSource(context.Context, *ReadDataSource_Request) (*ReadDataSource_Response, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReadDataSource not implemented")
}
func (*UnimplementedProviderServer) GenerateResourceConfig(context.Context, *GenerateResourceConfig_Request) (*GenerateResourceConfig_Response, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GenerateResourceConfig not implemented")
}
func (*UnimplementedProviderServer) ValidateEphemeralResourceConfig(context.Context, *ValidateEphemeralResourceConfig_Request) (*ValidateEphemeralResourceConfig_Response, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ValidateEphemeralResourceConfig not implemented")
}
func (*UnimplementedProviderServer) OpenEphemeralResource(context.Context, *OpenEphemeralResource_Request) (*OpenEphemeralResource_Response, error) {
	return nil, status.Errorf(codes.Unimplemented, "method OpenEphemeralResource not implemented")
}
func (*UnimplementedProviderServer) RenewEphemeralResource(context.Context, *RenewEphemeralResource_Request) (*RenewEphemeralResource_Response, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RenewEphemeralResource not implemented")
}
func (*UnimplementedProviderServer) CloseEphemeralResource(context.Context, *CloseEphemeralResource_Request) (*CloseEphemeralResource_Response, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CloseEphemeralResource not implemented")
}
func (*UnimplementedProviderServer) ListResource(*ListResource_Request, Provider_ListResourceServer) error {
	return status.Errorf(codes.Unimplemented, "method ListResource not implemented")
}
func (*UnimplementedProviderServer) ValidateListResourceConfig(context.Context, *ValidateListResourceConfig_Request) (*ValidateListResourceConfig_Response, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ValidateListResourceConfig not implemented")
}
func (*UnimplementedProviderServer) GetFunctions(context.Context, *GetFunctions_Request) (*GetFunctions_Response, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetFunctions not implemented")
}
func (*UnimplementedProviderServer) CallFunction(context.Context, *CallFunction_Request) (*CallFunction_Response, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CallFunction not implemented")
}
func (*UnimplementedProviderServer) ValidateStateStoreConfig(context.Context, *ValidateStateStore_Request) (*ValidateStateStore_Response, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ValidateStateStoreConfig not implemented")
}
func (*UnimplementedProviderServer) ConfigureStateStore(context.Context, *ConfigureStateStore_Request) (*ConfigureStateStore_Response, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ConfigureStateStore not implemented")
}
func (*UnimplementedProviderServer) GetStates(context.Context, *GetStates_Request) (*GetStates_Response, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetStates not implemented")
}
func (*UnimplementedProviderServer) DeleteState(context.Context, *DeleteState_Request) (*DeleteState_Response, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteState not implemented")
}
func (*UnimplementedProviderServer) PlanAction(context.Context, *PlanAction_Request) (*PlanAction_Response, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PlanAction not implemented")
}
func (*UnimplementedProviderServer) InvokeAction(*InvokeAction_Request, Provider_InvokeActionServer) error {
	return status.Errorf(codes.Unimplemented, "method InvokeAction not implemented")
}
func (*UnimplementedProviderServer) ValidateActionConfig(context.Context, *ValidateActionConfig_Request) (*ValidateActionConfig_Response, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ValidateActionConfig not implemented")
}
func (*UnimplementedProviderServer) StopProvider(context.Context, *StopProvider_Request) (*StopProvider_Response, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StopProvider not implemented")
}

func RegisterProviderServer(s *grpc.Server, srv ProviderServer) {
	s.RegisterService(&_Provider_serviceDesc, srv)
}

func _Provider_GetMetadata_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetMetadata_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProviderServer).GetMetadata(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tfplugin6.Provider/GetMetadata",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProviderServer).GetMetadata(ctx, req.(*GetMetadata_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _Provider_GetProviderSchema_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetProviderSchema_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProviderServer).GetProviderSchema(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tfplugin6.Provider/GetProviderSchema",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProviderServer).GetProviderSchema(ctx, req.(*GetProviderSchema_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _Provider_ValidateProviderConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ValidateProviderConfig_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProviderServer).ValidateProviderConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tfplugin6.Provider/ValidateProviderConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProviderServer).ValidateProviderConfig(ctx, req.(*ValidateProviderConfig_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _Provider_ValidateResourceConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ValidateResourceConfig_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProviderServer).ValidateResourceConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tfplugin6.Provider/ValidateResourceConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProviderServer).ValidateResourceConfig(ctx, req.(*ValidateResourceConfig_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _Provider_ValidateDataResourceConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ValidateDataResourceConfig_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProviderServer).ValidateDataResourceConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tfplugin6.Provider/ValidateDataResourceConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProviderServer).ValidateDataResourceConfig(ctx, req.(*ValidateDataResourceConfig_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _Provider_UpgradeResourceState_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpgradeResourceState_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProviderServer).UpgradeResourceState(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tfplugin6.Provider/UpgradeResourceState",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProviderServer).UpgradeResourceState(ctx, req.(*UpgradeResourceState_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _Provider_GetResourceIdentitySchemas_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetResourceIdentitySchemas_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProviderServer).GetResourceIdentitySchemas(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tfplugin6.Provider/GetResourceIdentitySchemas",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProviderServer).GetResourceIdentitySchemas(ctx, req.(*GetResourceIdentitySchemas_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _Provider_UpgradeResourceIdentity_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpgradeResourceIdentity_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProviderServer).UpgradeResourceIdentity(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tfplugin6.Provider/UpgradeResourceIdentity",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProviderServer).UpgradeResourceIdentity(ctx, req.(*UpgradeResourceIdentity_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _Provider_ConfigureProvider_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ConfigureProvider_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProviderServer).ConfigureProvider(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tfplugin6.Provider/ConfigureProvider",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProviderServer).ConfigureProvider(ctx, req.(*ConfigureProvider_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _Provider_ReadResource_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReadResource_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProviderServer).ReadResource(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tfplugin6.Provider/ReadResource",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProviderServer).ReadResource(ctx, req.(*ReadResource_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _Provider_PlanResourceChange_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PlanResourceChange_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProviderServer).PlanResourceChange(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tfplugin6.Provider/PlanResourceChange",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProviderServer).PlanResourceChange(ctx, req.(*PlanResourceChange_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _Provider_ApplyResourceChange_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ApplyResourceChange_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProviderServer).ApplyResourceChange(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tfplugin6.Provider/ApplyResourceChange",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProviderServer).ApplyResourceChange(ctx, req.(*ApplyResourceChange_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _Provider_ImportResourceState_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportResourceState_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProviderServer).ImportResourceState(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tfplugin6.Provider/ImportResourceState",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProviderServer).ImportResourceState(ctx, req.(*ImportResourceState_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _Provider_MoveResourceState_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MoveResourceState_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProviderServer).MoveResourceState(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tfplugin6.Provider/MoveResourceState",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProviderServer).MoveResourceState(ctx, req.(*MoveResourceState_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _Provider_ReadDataSource_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReadDataSource_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProviderServer).ReadDataSource(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tfplugin6.Provider/ReadDataSource",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProviderServer).ReadDataSource(ctx, req.(*ReadDataSource_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _Provider_GenerateResourceConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GenerateResourceConfig_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProviderServer).GenerateResourceConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tfplugin6.Provider/GenerateResourceConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProviderServer).GenerateResourceConfig(ctx, req.(*GenerateResourceConfig_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _Provider_ValidateEphemeralResourceConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ValidateEphemeralResourceConfig_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProviderServer).ValidateEphemeralResourceConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tfplugin6.Provider/ValidateEphemeralResourceConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProviderServer).ValidateEphemeralResourceConfig(ctx, req.(*ValidateEphemeralResourceConfig_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _Provider_OpenEphemeralResource_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(OpenEphemeralResource_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProviderServer).OpenEphemeralResource(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tfplugin6.Provider/OpenEphemeralResource",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProviderServer).OpenEphemeralResource(ctx, req.(*OpenEphemeralResource_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _Provider_RenewEphemeralResource_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RenewEphemeralResource_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProviderServer).RenewEphemeralResource(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tfplugin6.Provider/RenewEphemeralResource",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProviderServer).RenewEphemeralResource(ctx, req.(*RenewEphemeralResource_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _Provider_CloseEphemeralResource_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CloseEphemeralResource_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProviderServer).CloseEphemeralResource(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tfplugin6.Provider/CloseEphemeralResource",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProviderServer).CloseEphemeralResource(ctx, req.(*CloseEphemeralResource_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _Provider_ListResource_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ListResource_Request)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ProviderServer).ListResource(m, &providerListResourceServer{stream})
}

type Provider_ListResourceServer interface {
	Send(*ListResource_Event) error
	grpc.ServerStream
}

type providerListResourceServer struct {
	grpc.ServerStream
}

func (x *providerListResourceServer) Send(m *ListResource_Event) error {
	return x.ServerStream.SendMsg(m)
}

func _Provider_ValidateListResourceConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ValidateListResourceConfig_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProviderServer).ValidateListResourceConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tfplugin6.Provider/ValidateListResourceConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProviderServer).ValidateListResourceConfig(ctx, req.(*ValidateListResourceConfig_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _Provider_GetFunctions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetFunctions_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProviderServer).GetFunctions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tfplugin6.Provider/GetFunctions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProviderServer).GetFunctions(ctx, req.(*GetFunctions_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _Provider_CallFunction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CallFunction_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProviderServer).CallFunction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tfplugin6.Provider/CallFunction",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProviderServer).CallFunction(ctx, req.(*CallFunction_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _Provider_ValidateStateStoreConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ValidateStateStore_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProviderServer).ValidateStateStoreConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tfplugin6.Provider/ValidateStateStoreConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProviderServer).ValidateStateStoreConfig(ctx, req.(*ValidateStateStore_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _Provider_ConfigureStateStore_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ConfigureStateStore_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProviderServer).ConfigureStateStore(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tfplugin6.Provider/ConfigureStateStore",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProviderServer).ConfigureStateStore(ctx, req.(*ConfigureStateStore_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _Provider_GetStates_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetStates_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProviderServer).GetStates(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tfplugin6.Provider/GetStates",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProviderServer).GetStates(ctx, req.(*GetStates_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _Provider_DeleteState_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteState_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProviderServer).DeleteState(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tfplugin6.Provider/DeleteState",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProviderServer).DeleteState(ctx, req.(*DeleteState_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _Provider_PlanAction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PlanAction_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProviderServer).PlanAction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tfplugin6.Provider/PlanAction",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProviderServer).PlanAction(ctx, req.(*PlanAction_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _Provider_InvokeAction_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(InvokeAction_Request)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ProviderServer).InvokeAction(m, &providerInvokeActionServer{stream})
}

type Provider_InvokeActionServer interface {
	Send(*InvokeAction_Event) error
	grpc.ServerStream
}

type providerInvokeActionServer struct {
	grpc.ServerStream
}

func (x *providerInvokeActionServer) Send(m *InvokeAction_Event) error {
	return x.ServerStream.SendMsg(m)
}

func _Provider_ValidateActionConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ValidateActionConfig_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProviderServer).ValidateActionConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tfplugin6.Provider/ValidateActionConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProviderServer).ValidateActionConfig(ctx, req.(*ValidateActionConfig_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _Provider_StopProvider_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StopProvider_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProviderServer).StopProvider(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tfplugin6.Provider/StopProvider",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProviderServer).StopProvider(ctx, req.(*StopProvider_Request))
	}
	return interceptor(ctx, in, info, handler)
}

var _Provider_serviceDesc = grpc.ServiceDesc{
	ServiceName: "tfplugin6.Provider",
	HandlerType: (*ProviderServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetMetadata",
			Handler:    _Provider_GetMetadata_Handler,
		},
		{
			MethodName: "GetProviderSchema",
			Handler:    _Provider_GetProviderSchema_Handler,
		},
		{
			MethodName: "ValidateProviderConfig",
			Handler:    _Provider_ValidateProviderConfig_Handler,
		},
		{
			MethodName: "ValidateResourceConfig",
			Handler:    _Provider_ValidateResourceConfig_Handler,
		},
		{
			MethodName: "ValidateDataResourceConfig",
			Handler:    _Provider_ValidateDataResourceConfig_Handler,
		},
		{
			MethodName: "UpgradeResourceState",
			Handler:    _Provider_UpgradeResourceState_Handler,
		},
		{
			MethodName: "GetResourceIdentitySchemas",
			Handler:    _Provider_GetResourceIdentitySchemas_Handler,
		},
		{
			MethodName: "UpgradeResourceIdentity",
			Handler:    _Provider_UpgradeResourceIdentity_Handler,
		},
		{
			MethodName: "ConfigureProvider",
			Handler:    _Provider_ConfigureProvider_Handler,
		},
		{
			MethodName: "ReadResource",
			Handler:    _Provider_ReadResource_Handler,
		},
		{
			MethodName: "PlanResourceChange",
			Handler:    _Provider_PlanResourceChange_Handler,
		},
		{
			MethodName: "ApplyResourceChange",
			Handler:    _Provider_ApplyResourceChange_Handler,
		},
		{
			MethodName: "ImportResourceState",
			Handler:    _Provider_ImportResourceState_Handler,
		},
		{
			MethodName: "MoveResourceState",
			Handler:    _Provider_MoveResourceState_Handler,
		},
		{
			MethodName: "ReadDataSource",
			Handler:    _Provider_ReadDataSource_Handler,
		},
		{
			MethodName: "GenerateResourceConfig",
			Handler:    _Provider_GenerateResourceConfig_Handler,
		},
		{
			MethodName: "ValidateEphemeralResourceConfig",
			Handler:    _Provider_ValidateEphemeralResourceConfig_Handler,
		},
		{
			MethodName: "OpenEphemeralResource",
			Handler:    _Provider_OpenEphemeralResource_Handler,
		},
		{
			MethodName: "RenewEphemeralResource",
			Handler:    _Provider_RenewEphemeralResource_Handler,
		},
		{
			MethodName: "CloseEphemeralResource",
			Handler:    _Provider_CloseEphemeralResource_Handler,
		},
		{
			MethodName: "ValidateListResourceConfig",
			Handler:    _Provider_ValidateListResourceConfig_Handler,
		},
		{
			MethodName: "GetFunctions",
			Handler:    _Provider_GetFunctions_Handler,
		},
		{
			MethodName: "CallFunction",
			Handler:    _Provider_CallFunction_Handler,
		},
		{
			MethodName: "ValidateStateStoreConfig",
			Handler:    _Provider_ValidateStateStoreConfig_Handler,
		},
		{
			MethodName: "ConfigureStateStore",
			Handler:    _Provider_ConfigureStateStore_Handler,
		},
		{
			MethodName: "GetStates",
			Handler:    _Provider_GetStates_Handler,
		},
		{
			MethodName: "DeleteState",
			Handler:    _Provider_DeleteState_Handler,
		},
		{
			MethodName: "PlanAction",
			Handler:    _Provider_PlanAction_Handler,
		},
		{
			MethodName: "ValidateActionConfig",
			Handler:    _Provider_ValidateActionConfig_Handler,
		},
		{
			MethodName: "StopProvider",
			Handler:    _Provider_StopProvider_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "ListResource",
			Handler:       _Provider_ListResource_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "InvokeAction",
			Handler:       _Provider_InvokeAction_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "tfplugin6.proto",
}
