/* Copyright 2009-2022
 * Kaz Kylheku <kaz@kylheku.com>
 * Vancouver, Canada
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#define filters (deref(lookup_var_l(nil, filters_s)))

extern val filters_s;
extern val filter_k, lfilt_k, rfilt_k, to_html_k, from_html_k;
extern val upcase_k, downcase_k;
extern val topercent_k, frompercent_k, tourl_k, fromurl_k;
extern val tonumber_k, toint_k, tofloat_k, hextoint_k;

val trie_lookup_begin(val trie);
val trie_value_at(val node);
val trie_lookup_feed_char(val node, val ch);
val get_filter(val sym);
val filter_string_tree(val trie, val str_tree);
val filter_equal(val lfilt, val rfilt, val left, val right);
val register_filter(val sym, val table);

val url_encode(val str, val space_plus);
val url_decode(val str, val space_plus);

val base64_stream_enc(val out_stream, val in_stream, val nbytes, val wrap_cols);
val base64_stream_dec(val out_stream, val in_stream);

val base64_encode(val str, val wrap_cols);
val base64_decode(val str);
val base64_decode_buf(val str);

val base64url_stream_enc(val out_stream, val in_stream, val nbytes, val wrap_cols);
val base64url_stream_dec(val out_stream, val in_stream);

val base64url_encode(val str, val wrap_cols);
val base64url_decode(val str);
val base64url_decode_buf(val str);

void filter_init(void);

