# getDirectoryToWatchFailedLookupLocationAtTypesInsubDir

Determines whether to watch given failed lookup location (file that didnt exist) when resolving module.
It also determines the directory to watch and whether to watch it recursively or not.

## Testing for UncDos root: //vda1cs4850/c$

## RootDirForResolution: //vda1cs4850/c$

| Location                                                                                                                        | getDirectoryToWatchFailedLookupLocation                                                                                         | Recursive | Location if not symlink                                                                                                         |
| ------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------- | --------- | ------------------------------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/node_modules/@types/dir                                                                            | true      | //vda1cs4850/c$/folderAtRoot/node_modules                                                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types/dir                                                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/node_modules                                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                            | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules                                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                            | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               |
| //vda1cs4850/c$/users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types/dir                                                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/node_modules                                                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types/dir                                                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules                                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules                                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                |
| //vda1cs4850/c$/user/node_modules/@types/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/node_modules/@types/dir                                                                                    | true      | //vda1cs4850/c$/user/node_modules                                                                                               |
| //vda1cs4850/c$/user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/node_modules/@types/dir                                                                           | true      | //vda1cs4850/c$/user/username/node_modules                                                                                      |
| //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types/dir                                                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/node_modules                                                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules                                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| //vda1cs4850/c$/usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/node_modules/@types/dir                                                                                     | true      | //vda1cs4850/c$/usr/node_modules                                                                                                |
| //vda1cs4850/c$/usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/node_modules/@types/dir                                                                            | true      | //vda1cs4850/c$/usr/username/node_modules                                                                                       |
| //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types/dir                                                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules                                                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types/dir                                                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules                                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  |
| //vda1cs4850/c$/home/node_modules/@types/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/node_modules/@types/dir                                                                                    | true      | //vda1cs4850/c$/home/node_modules                                                                                               |
| //vda1cs4850/c$/home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/node_modules/@types/dir                                                                           | true      | //vda1cs4850/c$/home/username/node_modules                                                                                      |
| //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types/dir                                                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/node_modules                                                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules                                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| //vda1cs4850/c$/workspaces/node_modules/@types/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/c$/workspaces/node_modules/@types/dir                                                                              | true      | //vda1cs4850/c$/workspaces/node_modules                                                                                         |
| //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                            | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types/dir                                                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules                                                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types/dir                                                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules                                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules                                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                    |

## RootDirForResolution: //vda1cs4850/c$/folderAtRoot

| Location                                                                                                                        | getDirectoryToWatchFailedLookupLocation                                                                                         | Recursive | Location if not symlink                                                                                                         |
| ------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------- | --------- | ------------------------------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/node_modules/@types/dir                                                                            | true      | //vda1cs4850/c$/folderAtRoot/node_modules                                                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types/dir                                                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/node_modules                                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                            | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules                                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                            | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               |
| //vda1cs4850/c$/users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types/dir                                                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/node_modules                                                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types/dir                                                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules                                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules                                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                |
| //vda1cs4850/c$/user/node_modules/@types/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/node_modules/@types/dir                                                                                    | true      | //vda1cs4850/c$/user/node_modules                                                                                               |
| //vda1cs4850/c$/user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/node_modules/@types/dir                                                                           | true      | //vda1cs4850/c$/user/username/node_modules                                                                                      |
| //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types/dir                                                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/node_modules                                                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules                                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| //vda1cs4850/c$/usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/node_modules/@types/dir                                                                                     | true      | //vda1cs4850/c$/usr/node_modules                                                                                                |
| //vda1cs4850/c$/usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/node_modules/@types/dir                                                                            | true      | //vda1cs4850/c$/usr/username/node_modules                                                                                       |
| //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types/dir                                                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules                                                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types/dir                                                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules                                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  |
| //vda1cs4850/c$/home/node_modules/@types/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/node_modules/@types/dir                                                                                    | true      | //vda1cs4850/c$/home/node_modules                                                                                               |
| //vda1cs4850/c$/home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/node_modules/@types/dir                                                                           | true      | //vda1cs4850/c$/home/username/node_modules                                                                                      |
| //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types/dir                                                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/node_modules                                                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules                                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| //vda1cs4850/c$/workspaces/node_modules/@types/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/c$/workspaces/node_modules/@types/dir                                                                              | true      | //vda1cs4850/c$/workspaces/node_modules                                                                                         |
| //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                            | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types/dir                                                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules                                                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types/dir                                                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules                                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules                                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                    |

## RootDirForResolution: //vda1cs4850/c$/folderAtRoot/folder1

| Location                                                                                                                        | getDirectoryToWatchFailedLookupLocation                                                                                         | Recursive | Location if not symlink                                                                                                         |
| ------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------- | --------- | ------------------------------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/node_modules/@types/dir                                                                            | true      | //vda1cs4850/c$/folderAtRoot/node_modules                                                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types/dir                                                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/node_modules                                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                            | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2                                                                                    |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2                                                                                    |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                            | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2                                                                                    |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2                                                                                    |
| //vda1cs4850/c$/users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types/dir                                                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/node_modules                                                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types/dir                                                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules                                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules                                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                |
| //vda1cs4850/c$/user/node_modules/@types/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/node_modules/@types/dir                                                                                    | true      | //vda1cs4850/c$/user/node_modules                                                                                               |
| //vda1cs4850/c$/user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/node_modules/@types/dir                                                                           | true      | //vda1cs4850/c$/user/username/node_modules                                                                                      |
| //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types/dir                                                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/node_modules                                                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules                                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| //vda1cs4850/c$/usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/node_modules/@types/dir                                                                                     | true      | //vda1cs4850/c$/usr/node_modules                                                                                                |
| //vda1cs4850/c$/usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/node_modules/@types/dir                                                                            | true      | //vda1cs4850/c$/usr/username/node_modules                                                                                       |
| //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types/dir                                                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules                                                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types/dir                                                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules                                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  |
| //vda1cs4850/c$/home/node_modules/@types/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/node_modules/@types/dir                                                                                    | true      | //vda1cs4850/c$/home/node_modules                                                                                               |
| //vda1cs4850/c$/home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/node_modules/@types/dir                                                                           | true      | //vda1cs4850/c$/home/username/node_modules                                                                                      |
| //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types/dir                                                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/node_modules                                                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules                                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| //vda1cs4850/c$/workspaces/node_modules/@types/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/c$/workspaces/node_modules/@types/dir                                                                              | true      | //vda1cs4850/c$/workspaces/node_modules                                                                                         |
| //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                            | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types/dir                                                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules                                                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types/dir                                                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules                                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules                                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                    |

## RootDirForResolution: //vda1cs4850/c$/folderAtRoot/folder1/folder2

| Location                                                                                                                        | getDirectoryToWatchFailedLookupLocation                                                                                         | Recursive | Location if not symlink                                                                                                         |
| ------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------- | --------- | ------------------------------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/node_modules/@types/dir                                                                            | true      | //vda1cs4850/c$/folderAtRoot/node_modules                                                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types/dir                                                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/node_modules                                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                            | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules                                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3                                                                            |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                            | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3                                                                            |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3                                                                            |
| //vda1cs4850/c$/users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types/dir                                                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/node_modules                                                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types/dir                                                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules                                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules                                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                |
| //vda1cs4850/c$/user/node_modules/@types/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/node_modules/@types/dir                                                                                    | true      | //vda1cs4850/c$/user/node_modules                                                                                               |
| //vda1cs4850/c$/user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/node_modules/@types/dir                                                                           | true      | //vda1cs4850/c$/user/username/node_modules                                                                                      |
| //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types/dir                                                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/node_modules                                                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules                                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| //vda1cs4850/c$/usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/node_modules/@types/dir                                                                                     | true      | //vda1cs4850/c$/usr/node_modules                                                                                                |
| //vda1cs4850/c$/usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/node_modules/@types/dir                                                                            | true      | //vda1cs4850/c$/usr/username/node_modules                                                                                       |
| //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types/dir                                                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules                                                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types/dir                                                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules                                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  |
| //vda1cs4850/c$/home/node_modules/@types/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/node_modules/@types/dir                                                                                    | true      | //vda1cs4850/c$/home/node_modules                                                                                               |
| //vda1cs4850/c$/home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/node_modules/@types/dir                                                                           | true      | //vda1cs4850/c$/home/username/node_modules                                                                                      |
| //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types/dir                                                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/node_modules                                                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules                                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| //vda1cs4850/c$/workspaces/node_modules/@types/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/c$/workspaces/node_modules/@types/dir                                                                              | true      | //vda1cs4850/c$/workspaces/node_modules                                                                                         |
| //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                            | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types/dir                                                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules                                                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types/dir                                                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules                                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules                                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                    |

## RootDirForResolution: //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3

| Location                                                                                                                        | getDirectoryToWatchFailedLookupLocation                                                                                         | Recursive | Location if not symlink                                                                                                         |
| ------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------- | --------- | ------------------------------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/node_modules/@types/dir                                                                            | true      | //vda1cs4850/c$/folderAtRoot/node_modules                                                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types/dir                                                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/node_modules                                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                            | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules                                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                            | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4                                                                    |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4                                                                    |
| //vda1cs4850/c$/users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types/dir                                                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/node_modules                                                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types/dir                                                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules                                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules                                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                |
| //vda1cs4850/c$/user/node_modules/@types/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/node_modules/@types/dir                                                                                    | true      | //vda1cs4850/c$/user/node_modules                                                                                               |
| //vda1cs4850/c$/user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/node_modules/@types/dir                                                                           | true      | //vda1cs4850/c$/user/username/node_modules                                                                                      |
| //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types/dir                                                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/node_modules                                                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules                                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| //vda1cs4850/c$/usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/node_modules/@types/dir                                                                                     | true      | //vda1cs4850/c$/usr/node_modules                                                                                                |
| //vda1cs4850/c$/usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/node_modules/@types/dir                                                                            | true      | //vda1cs4850/c$/usr/username/node_modules                                                                                       |
| //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types/dir                                                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules                                                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types/dir                                                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules                                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  |
| //vda1cs4850/c$/home/node_modules/@types/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/node_modules/@types/dir                                                                                    | true      | //vda1cs4850/c$/home/node_modules                                                                                               |
| //vda1cs4850/c$/home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/node_modules/@types/dir                                                                           | true      | //vda1cs4850/c$/home/username/node_modules                                                                                      |
| //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types/dir                                                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/node_modules                                                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules                                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| //vda1cs4850/c$/workspaces/node_modules/@types/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/c$/workspaces/node_modules/@types/dir                                                                              | true      | //vda1cs4850/c$/workspaces/node_modules                                                                                         |
| //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                            | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types/dir                                                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules                                                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types/dir                                                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules                                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules                                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                    |

## RootDirForResolution: //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                                                        | getDirectoryToWatchFailedLookupLocation                                                                                         | Recursive | Location if not symlink                                                                                                         |
| ------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------- | --------- | ------------------------------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/node_modules/@types/dir                                                                            | true      | //vda1cs4850/c$/folderAtRoot/node_modules                                                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types/dir                                                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/node_modules                                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                            | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules                                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                            | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                                            |
| //vda1cs4850/c$/users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types/dir                                                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/node_modules                                                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types/dir                                                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules                                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules                                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                |
| //vda1cs4850/c$/user/node_modules/@types/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/node_modules/@types/dir                                                                                    | true      | //vda1cs4850/c$/user/node_modules                                                                                               |
| //vda1cs4850/c$/user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/node_modules/@types/dir                                                                           | true      | //vda1cs4850/c$/user/username/node_modules                                                                                      |
| //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types/dir                                                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/node_modules                                                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules                                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| //vda1cs4850/c$/usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/node_modules/@types/dir                                                                                     | true      | //vda1cs4850/c$/usr/node_modules                                                                                                |
| //vda1cs4850/c$/usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/node_modules/@types/dir                                                                            | true      | //vda1cs4850/c$/usr/username/node_modules                                                                                       |
| //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types/dir                                                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules                                                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types/dir                                                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules                                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  |
| //vda1cs4850/c$/home/node_modules/@types/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/node_modules/@types/dir                                                                                    | true      | //vda1cs4850/c$/home/node_modules                                                                                               |
| //vda1cs4850/c$/home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/node_modules/@types/dir                                                                           | true      | //vda1cs4850/c$/home/username/node_modules                                                                                      |
| //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types/dir                                                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/node_modules                                                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules                                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| //vda1cs4850/c$/workspaces/node_modules/@types/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/c$/workspaces/node_modules/@types/dir                                                                              | true      | //vda1cs4850/c$/workspaces/node_modules                                                                                         |
| //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                            | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types/dir                                                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules                                                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types/dir                                                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules                                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules                                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                    |

## RootDirForResolution: //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                                                        | getDirectoryToWatchFailedLookupLocation                                                                                         | Recursive | Location if not symlink                                                                                                         |
| ------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------- | --------- | ------------------------------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/node_modules/@types/dir                                                                            | true      | //vda1cs4850/c$/folderAtRoot/node_modules                                                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types/dir                                                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/node_modules                                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                            | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules                                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                            | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               |
| //vda1cs4850/c$/users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types/dir                                                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/node_modules                                                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types/dir                                                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules                                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules                                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                |
| //vda1cs4850/c$/user/node_modules/@types/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/node_modules/@types/dir                                                                                    | true      | //vda1cs4850/c$/user/node_modules                                                                                               |
| //vda1cs4850/c$/user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/node_modules/@types/dir                                                                           | true      | //vda1cs4850/c$/user/username/node_modules                                                                                      |
| //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types/dir                                                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/node_modules                                                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules                                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| //vda1cs4850/c$/usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/node_modules/@types/dir                                                                                     | true      | //vda1cs4850/c$/usr/node_modules                                                                                                |
| //vda1cs4850/c$/usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/node_modules/@types/dir                                                                            | true      | //vda1cs4850/c$/usr/username/node_modules                                                                                       |
| //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types/dir                                                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules                                                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types/dir                                                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules                                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  |
| //vda1cs4850/c$/home/node_modules/@types/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/node_modules/@types/dir                                                                                    | true      | //vda1cs4850/c$/home/node_modules                                                                                               |
| //vda1cs4850/c$/home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/node_modules/@types/dir                                                                           | true      | //vda1cs4850/c$/home/username/node_modules                                                                                      |
| //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types/dir                                                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/node_modules                                                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules                                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| //vda1cs4850/c$/workspaces/node_modules/@types/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/c$/workspaces/node_modules/@types/dir                                                                              | true      | //vda1cs4850/c$/workspaces/node_modules                                                                                         |
| //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                            | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types/dir                                                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules                                                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types/dir                                                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules                                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules                                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                    |

## RootDirForResolution: //vda1cs4850/c$/users

| Location                                                                                                                        | getDirectoryToWatchFailedLookupLocation                                                                                         | Recursive | Location if not symlink                                                                                                         |
| ------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------- | --------- | ------------------------------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/node_modules/@types/dir                                                                            | true      | //vda1cs4850/c$/folderAtRoot/node_modules                                                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types/dir                                                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/node_modules                                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                            | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules                                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                            | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               |
| //vda1cs4850/c$/users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types/dir                                                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/node_modules                                                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types/dir                                                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules                                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules                                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                |
| //vda1cs4850/c$/user/node_modules/@types/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/node_modules/@types/dir                                                                                    | true      | //vda1cs4850/c$/user/node_modules                                                                                               |
| //vda1cs4850/c$/user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/node_modules/@types/dir                                                                           | true      | //vda1cs4850/c$/user/username/node_modules                                                                                      |
| //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types/dir                                                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/node_modules                                                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules                                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| //vda1cs4850/c$/usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/node_modules/@types/dir                                                                                     | true      | //vda1cs4850/c$/usr/node_modules                                                                                                |
| //vda1cs4850/c$/usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/node_modules/@types/dir                                                                            | true      | //vda1cs4850/c$/usr/username/node_modules                                                                                       |
| //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types/dir                                                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules                                                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types/dir                                                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules                                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  |
| //vda1cs4850/c$/home/node_modules/@types/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/node_modules/@types/dir                                                                                    | true      | //vda1cs4850/c$/home/node_modules                                                                                               |
| //vda1cs4850/c$/home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/node_modules/@types/dir                                                                           | true      | //vda1cs4850/c$/home/username/node_modules                                                                                      |
| //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types/dir                                                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/node_modules                                                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules                                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| //vda1cs4850/c$/workspaces/node_modules/@types/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/c$/workspaces/node_modules/@types/dir                                                                              | true      | //vda1cs4850/c$/workspaces/node_modules                                                                                         |
| //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                            | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types/dir                                                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules                                                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types/dir                                                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules                                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules                                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                    |

## RootDirForResolution: //vda1cs4850/c$/users/username

| Location                                                                                                                        | getDirectoryToWatchFailedLookupLocation                                                                                         | Recursive | Location if not symlink                                                                                                         |
| ------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------- | --------- | ------------------------------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/node_modules/@types/dir                                                                            | true      | //vda1cs4850/c$/folderAtRoot/node_modules                                                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types/dir                                                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/node_modules                                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                            | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules                                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                            | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               |
| //vda1cs4850/c$/users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types/dir                                                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/node_modules                                                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types/dir                                                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules                                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules                                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                |
| //vda1cs4850/c$/user/node_modules/@types/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/node_modules/@types/dir                                                                                    | true      | //vda1cs4850/c$/user/node_modules                                                                                               |
| //vda1cs4850/c$/user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/node_modules/@types/dir                                                                           | true      | //vda1cs4850/c$/user/username/node_modules                                                                                      |
| //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types/dir                                                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/node_modules                                                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules                                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| //vda1cs4850/c$/usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/node_modules/@types/dir                                                                                     | true      | //vda1cs4850/c$/usr/node_modules                                                                                                |
| //vda1cs4850/c$/usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/node_modules/@types/dir                                                                            | true      | //vda1cs4850/c$/usr/username/node_modules                                                                                       |
| //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types/dir                                                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules                                                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types/dir                                                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules                                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  |
| //vda1cs4850/c$/home/node_modules/@types/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/node_modules/@types/dir                                                                                    | true      | //vda1cs4850/c$/home/node_modules                                                                                               |
| //vda1cs4850/c$/home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/node_modules/@types/dir                                                                           | true      | //vda1cs4850/c$/home/username/node_modules                                                                                      |
| //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types/dir                                                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/node_modules                                                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules                                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| //vda1cs4850/c$/workspaces/node_modules/@types/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/c$/workspaces/node_modules/@types/dir                                                                              | true      | //vda1cs4850/c$/workspaces/node_modules                                                                                         |
| //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                            | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types/dir                                                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules                                                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types/dir                                                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules                                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules                                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                    |

## RootDirForResolution: //vda1cs4850/c$/users/username/folderAtRoot

| Location                                                                                                                        | getDirectoryToWatchFailedLookupLocation                                                                                         | Recursive | Location if not symlink                                                                                                         |
| ------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------- | --------- | ------------------------------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/node_modules/@types/dir                                                                            | true      | //vda1cs4850/c$/folderAtRoot/node_modules                                                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types/dir                                                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/node_modules                                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                            | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules                                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                            | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               |
| //vda1cs4850/c$/users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types/dir                                                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/node_modules                                                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types/dir                                                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules                                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules                                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                |
| //vda1cs4850/c$/user/node_modules/@types/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/node_modules/@types/dir                                                                                    | true      | //vda1cs4850/c$/user/node_modules                                                                                               |
| //vda1cs4850/c$/user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/node_modules/@types/dir                                                                           | true      | //vda1cs4850/c$/user/username/node_modules                                                                                      |
| //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types/dir                                                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/node_modules                                                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules                                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| //vda1cs4850/c$/usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/node_modules/@types/dir                                                                                     | true      | //vda1cs4850/c$/usr/node_modules                                                                                                |
| //vda1cs4850/c$/usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/node_modules/@types/dir                                                                            | true      | //vda1cs4850/c$/usr/username/node_modules                                                                                       |
| //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types/dir                                                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules                                                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types/dir                                                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules                                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  |
| //vda1cs4850/c$/home/node_modules/@types/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/node_modules/@types/dir                                                                                    | true      | //vda1cs4850/c$/home/node_modules                                                                                               |
| //vda1cs4850/c$/home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/node_modules/@types/dir                                                                           | true      | //vda1cs4850/c$/home/username/node_modules                                                                                      |
| //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types/dir                                                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/node_modules                                                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules                                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| //vda1cs4850/c$/workspaces/node_modules/@types/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/c$/workspaces/node_modules/@types/dir                                                                              | true      | //vda1cs4850/c$/workspaces/node_modules                                                                                         |
| //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                            | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types/dir                                                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules                                                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types/dir                                                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules                                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules                                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                    |

## RootDirForResolution: //vda1cs4850/c$/users/username/folderAtRoot/folder1

| Location                                                                                                                        | getDirectoryToWatchFailedLookupLocation                                                                                         | Recursive | Location if not symlink                                                                                                         |
| ------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------- | --------- | ------------------------------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/node_modules/@types/dir                                                                            | true      | //vda1cs4850/c$/folderAtRoot/node_modules                                                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types/dir                                                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/node_modules                                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                            | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules                                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                            | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               |
| //vda1cs4850/c$/users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types/dir                                                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/node_modules                                                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types/dir                                                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules                                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2                                                                     |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2                                                                     |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2                                                                     |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2                                                                     |
| //vda1cs4850/c$/user/node_modules/@types/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/node_modules/@types/dir                                                                                    | true      | //vda1cs4850/c$/user/node_modules                                                                                               |
| //vda1cs4850/c$/user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/node_modules/@types/dir                                                                           | true      | //vda1cs4850/c$/user/username/node_modules                                                                                      |
| //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types/dir                                                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/node_modules                                                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules                                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| //vda1cs4850/c$/usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/node_modules/@types/dir                                                                                     | true      | //vda1cs4850/c$/usr/node_modules                                                                                                |
| //vda1cs4850/c$/usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/node_modules/@types/dir                                                                            | true      | //vda1cs4850/c$/usr/username/node_modules                                                                                       |
| //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types/dir                                                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules                                                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types/dir                                                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules                                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  |
| //vda1cs4850/c$/home/node_modules/@types/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/node_modules/@types/dir                                                                                    | true      | //vda1cs4850/c$/home/node_modules                                                                                               |
| //vda1cs4850/c$/home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/node_modules/@types/dir                                                                           | true      | //vda1cs4850/c$/home/username/node_modules                                                                                      |
| //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types/dir                                                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/node_modules                                                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules                                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| //vda1cs4850/c$/workspaces/node_modules/@types/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/c$/workspaces/node_modules/@types/dir                                                                              | true      | //vda1cs4850/c$/workspaces/node_modules                                                                                         |
| //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                            | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types/dir                                                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules                                                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types/dir                                                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules                                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules                                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                    |

## RootDirForResolution: //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2

| Location                                                                                                                        | getDirectoryToWatchFailedLookupLocation                                                                                         | Recursive | Location if not symlink                                                                                                         |
| ------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------- | --------- | ------------------------------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/node_modules/@types/dir                                                                            | true      | //vda1cs4850/c$/folderAtRoot/node_modules                                                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types/dir                                                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/node_modules                                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                            | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules                                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                            | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               |
| //vda1cs4850/c$/users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types/dir                                                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/node_modules                                                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types/dir                                                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules                                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules                                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3                                                             |
| //vda1cs4850/c$/user/node_modules/@types/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/node_modules/@types/dir                                                                                    | true      | //vda1cs4850/c$/user/node_modules                                                                                               |
| //vda1cs4850/c$/user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/node_modules/@types/dir                                                                           | true      | //vda1cs4850/c$/user/username/node_modules                                                                                      |
| //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types/dir                                                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/node_modules                                                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules                                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| //vda1cs4850/c$/usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/node_modules/@types/dir                                                                                     | true      | //vda1cs4850/c$/usr/node_modules                                                                                                |
| //vda1cs4850/c$/usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/node_modules/@types/dir                                                                            | true      | //vda1cs4850/c$/usr/username/node_modules                                                                                       |
| //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types/dir                                                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules                                                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types/dir                                                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules                                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  |
| //vda1cs4850/c$/home/node_modules/@types/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/node_modules/@types/dir                                                                                    | true      | //vda1cs4850/c$/home/node_modules                                                                                               |
| //vda1cs4850/c$/home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/node_modules/@types/dir                                                                           | true      | //vda1cs4850/c$/home/username/node_modules                                                                                      |
| //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types/dir                                                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/node_modules                                                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules                                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| //vda1cs4850/c$/workspaces/node_modules/@types/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/c$/workspaces/node_modules/@types/dir                                                                              | true      | //vda1cs4850/c$/workspaces/node_modules                                                                                         |
| //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                            | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types/dir                                                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules                                                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types/dir                                                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules                                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules                                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                    |

## RootDirForResolution: //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3

| Location                                                                                                                        | getDirectoryToWatchFailedLookupLocation                                                                                         | Recursive | Location if not symlink                                                                                                         |
| ------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------- | --------- | ------------------------------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/node_modules/@types/dir                                                                            | true      | //vda1cs4850/c$/folderAtRoot/node_modules                                                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types/dir                                                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/node_modules                                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                            | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules                                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                            | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               |
| //vda1cs4850/c$/users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types/dir                                                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/node_modules                                                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types/dir                                                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules                                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules                                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                                     |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                                     |
| //vda1cs4850/c$/user/node_modules/@types/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/node_modules/@types/dir                                                                                    | true      | //vda1cs4850/c$/user/node_modules                                                                                               |
| //vda1cs4850/c$/user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/node_modules/@types/dir                                                                           | true      | //vda1cs4850/c$/user/username/node_modules                                                                                      |
| //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types/dir                                                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/node_modules                                                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules                                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| //vda1cs4850/c$/usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/node_modules/@types/dir                                                                                     | true      | //vda1cs4850/c$/usr/node_modules                                                                                                |
| //vda1cs4850/c$/usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/node_modules/@types/dir                                                                            | true      | //vda1cs4850/c$/usr/username/node_modules                                                                                       |
| //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types/dir                                                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules                                                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types/dir                                                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules                                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  |
| //vda1cs4850/c$/home/node_modules/@types/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/node_modules/@types/dir                                                                                    | true      | //vda1cs4850/c$/home/node_modules                                                                                               |
| //vda1cs4850/c$/home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/node_modules/@types/dir                                                                           | true      | //vda1cs4850/c$/home/username/node_modules                                                                                      |
| //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types/dir                                                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/node_modules                                                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules                                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| //vda1cs4850/c$/workspaces/node_modules/@types/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/c$/workspaces/node_modules/@types/dir                                                                              | true      | //vda1cs4850/c$/workspaces/node_modules                                                                                         |
| //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                            | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types/dir                                                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules                                                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types/dir                                                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules                                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules                                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                    |

## RootDirForResolution: //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                                                        | getDirectoryToWatchFailedLookupLocation                                                                                         | Recursive | Location if not symlink                                                                                                         |
| ------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------- | --------- | ------------------------------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/node_modules/@types/dir                                                                            | true      | //vda1cs4850/c$/folderAtRoot/node_modules                                                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types/dir                                                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/node_modules                                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                            | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules                                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                            | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               |
| //vda1cs4850/c$/users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types/dir                                                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/node_modules                                                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types/dir                                                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules                                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules                                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                             |
| //vda1cs4850/c$/user/node_modules/@types/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/node_modules/@types/dir                                                                                    | true      | //vda1cs4850/c$/user/node_modules                                                                                               |
| //vda1cs4850/c$/user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/node_modules/@types/dir                                                                           | true      | //vda1cs4850/c$/user/username/node_modules                                                                                      |
| //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types/dir                                                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/node_modules                                                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules                                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| //vda1cs4850/c$/usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/node_modules/@types/dir                                                                                     | true      | //vda1cs4850/c$/usr/node_modules                                                                                                |
| //vda1cs4850/c$/usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/node_modules/@types/dir                                                                            | true      | //vda1cs4850/c$/usr/username/node_modules                                                                                       |
| //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types/dir                                                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules                                                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types/dir                                                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules                                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  |
| //vda1cs4850/c$/home/node_modules/@types/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/node_modules/@types/dir                                                                                    | true      | //vda1cs4850/c$/home/node_modules                                                                                               |
| //vda1cs4850/c$/home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/node_modules/@types/dir                                                                           | true      | //vda1cs4850/c$/home/username/node_modules                                                                                      |
| //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types/dir                                                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/node_modules                                                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules                                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| //vda1cs4850/c$/workspaces/node_modules/@types/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/c$/workspaces/node_modules/@types/dir                                                                              | true      | //vda1cs4850/c$/workspaces/node_modules                                                                                         |
| //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                            | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types/dir                                                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules                                                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types/dir                                                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules                                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules                                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                    |

## RootDirForResolution: //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                                                        | getDirectoryToWatchFailedLookupLocation                                                                                         | Recursive | Location if not symlink                                                                                                         |
| ------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------- | --------- | ------------------------------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/node_modules/@types/dir                                                                            | true      | //vda1cs4850/c$/folderAtRoot/node_modules                                                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types/dir                                                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/node_modules                                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                            | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules                                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                            | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               |
| //vda1cs4850/c$/users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types/dir                                                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/node_modules                                                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types/dir                                                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules                                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules                                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                |
| //vda1cs4850/c$/user/node_modules/@types/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/node_modules/@types/dir                                                                                    | true      | //vda1cs4850/c$/user/node_modules                                                                                               |
| //vda1cs4850/c$/user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/node_modules/@types/dir                                                                           | true      | //vda1cs4850/c$/user/username/node_modules                                                                                      |
| //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types/dir                                                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/node_modules                                                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules                                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| //vda1cs4850/c$/usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/node_modules/@types/dir                                                                                     | true      | //vda1cs4850/c$/usr/node_modules                                                                                                |
| //vda1cs4850/c$/usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/node_modules/@types/dir                                                                            | true      | //vda1cs4850/c$/usr/username/node_modules                                                                                       |
| //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types/dir                                                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules                                                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types/dir                                                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules                                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  |
| //vda1cs4850/c$/home/node_modules/@types/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/node_modules/@types/dir                                                                                    | true      | //vda1cs4850/c$/home/node_modules                                                                                               |
| //vda1cs4850/c$/home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/node_modules/@types/dir                                                                           | true      | //vda1cs4850/c$/home/username/node_modules                                                                                      |
| //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types/dir                                                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/node_modules                                                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules                                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| //vda1cs4850/c$/workspaces/node_modules/@types/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/c$/workspaces/node_modules/@types/dir                                                                              | true      | //vda1cs4850/c$/workspaces/node_modules                                                                                         |
| //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                            | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types/dir                                                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules                                                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types/dir                                                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules                                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules                                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                    |

## RootDirForResolution: //vda1cs4850/c$/user

| Location                                                                                                                        | getDirectoryToWatchFailedLookupLocation                                                                                         | Recursive | Location if not symlink                                                                                                         |
| ------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------- | --------- | ------------------------------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/node_modules/@types/dir                                                                            | true      | //vda1cs4850/c$/folderAtRoot/node_modules                                                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types/dir                                                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/node_modules                                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                            | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules                                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                            | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               |
| //vda1cs4850/c$/users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types/dir                                                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/node_modules                                                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types/dir                                                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules                                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules                                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                |
| //vda1cs4850/c$/user/node_modules/@types/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/node_modules/@types/dir                                                                                    | true      | //vda1cs4850/c$/user/node_modules                                                                                               |
| //vda1cs4850/c$/user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/node_modules/@types/dir                                                                           | true      | //vda1cs4850/c$/user/username/node_modules                                                                                      |
| //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types/dir                                                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/node_modules                                                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules                                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| //vda1cs4850/c$/usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/node_modules/@types/dir                                                                                     | true      | //vda1cs4850/c$/usr/node_modules                                                                                                |
| //vda1cs4850/c$/usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/node_modules/@types/dir                                                                            | true      | //vda1cs4850/c$/usr/username/node_modules                                                                                       |
| //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types/dir                                                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules                                                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types/dir                                                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules                                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  |
| //vda1cs4850/c$/home/node_modules/@types/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/node_modules/@types/dir                                                                                    | true      | //vda1cs4850/c$/home/node_modules                                                                                               |
| //vda1cs4850/c$/home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/node_modules/@types/dir                                                                           | true      | //vda1cs4850/c$/home/username/node_modules                                                                                      |
| //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types/dir                                                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/node_modules                                                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules                                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| //vda1cs4850/c$/workspaces/node_modules/@types/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/c$/workspaces/node_modules/@types/dir                                                                              | true      | //vda1cs4850/c$/workspaces/node_modules                                                                                         |
| //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                            | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types/dir                                                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules                                                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types/dir                                                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules                                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules                                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                    |

## RootDirForResolution: //vda1cs4850/c$/user/username

| Location                                                                                                                        | getDirectoryToWatchFailedLookupLocation                                                                                         | Recursive | Location if not symlink                                                                                                         |
| ------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------- | --------- | ------------------------------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/node_modules/@types/dir                                                                            | true      | //vda1cs4850/c$/folderAtRoot/node_modules                                                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types/dir                                                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/node_modules                                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                            | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules                                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                            | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               |
| //vda1cs4850/c$/users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types/dir                                                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/node_modules                                                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types/dir                                                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules                                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules                                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                |
| //vda1cs4850/c$/user/node_modules/@types/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/node_modules/@types/dir                                                                                    | true      | //vda1cs4850/c$/user/node_modules                                                                                               |
| //vda1cs4850/c$/user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/node_modules/@types/dir                                                                           | true      | //vda1cs4850/c$/user/username/node_modules                                                                                      |
| //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types/dir                                                              | true      | //vda1cs4850/c$/user/username/folderAtRoot                                                                                      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | //vda1cs4850/c$/user/username/folderAtRoot                                                                                      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | //vda1cs4850/c$/user/username/folderAtRoot                                                                                      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | //vda1cs4850/c$/user/username/folderAtRoot                                                                                      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | //vda1cs4850/c$/user/username/folderAtRoot                                                                                      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | //vda1cs4850/c$/user/username/folderAtRoot                                                                                      |
| //vda1cs4850/c$/usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/node_modules/@types/dir                                                                                     | true      | //vda1cs4850/c$/usr/node_modules                                                                                                |
| //vda1cs4850/c$/usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/node_modules/@types/dir                                                                            | true      | //vda1cs4850/c$/usr/username/node_modules                                                                                       |
| //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types/dir                                                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules                                                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types/dir                                                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules                                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  |
| //vda1cs4850/c$/home/node_modules/@types/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/node_modules/@types/dir                                                                                    | true      | //vda1cs4850/c$/home/node_modules                                                                                               |
| //vda1cs4850/c$/home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/node_modules/@types/dir                                                                           | true      | //vda1cs4850/c$/home/username/node_modules                                                                                      |
| //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types/dir                                                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/node_modules                                                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules                                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| //vda1cs4850/c$/workspaces/node_modules/@types/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/c$/workspaces/node_modules/@types/dir                                                                              | true      | //vda1cs4850/c$/workspaces/node_modules                                                                                         |
| //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                            | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types/dir                                                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules                                                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types/dir                                                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules                                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules                                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                    |

## RootDirForResolution: //vda1cs4850/c$/user/username/folderAtRoot

| Location                                                                                                                        | getDirectoryToWatchFailedLookupLocation                                                                                         | Recursive | Location if not symlink                                                                                                         |
| ------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------- | --------- | ------------------------------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/node_modules/@types/dir                                                                            | true      | //vda1cs4850/c$/folderAtRoot/node_modules                                                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types/dir                                                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/node_modules                                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                            | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules                                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                            | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               |
| //vda1cs4850/c$/users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types/dir                                                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/node_modules                                                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types/dir                                                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules                                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules                                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                |
| //vda1cs4850/c$/user/node_modules/@types/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/node_modules/@types/dir                                                                                    | true      | //vda1cs4850/c$/user/node_modules                                                                                               |
| //vda1cs4850/c$/user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/node_modules/@types/dir                                                                           | true      | //vda1cs4850/c$/user/username/node_modules                                                                                      |
| //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types/dir                                                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/node_modules                                                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1                                                                              |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1                                                                              |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1                                                                              |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1                                                                              |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1                                                                              |
| //vda1cs4850/c$/usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/node_modules/@types/dir                                                                                     | true      | //vda1cs4850/c$/usr/node_modules                                                                                                |
| //vda1cs4850/c$/usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/node_modules/@types/dir                                                                            | true      | //vda1cs4850/c$/usr/username/node_modules                                                                                       |
| //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types/dir                                                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules                                                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types/dir                                                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules                                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  |
| //vda1cs4850/c$/home/node_modules/@types/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/node_modules/@types/dir                                                                                    | true      | //vda1cs4850/c$/home/node_modules                                                                                               |
| //vda1cs4850/c$/home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/node_modules/@types/dir                                                                           | true      | //vda1cs4850/c$/home/username/node_modules                                                                                      |
| //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types/dir                                                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/node_modules                                                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules                                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| //vda1cs4850/c$/workspaces/node_modules/@types/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/c$/workspaces/node_modules/@types/dir                                                                              | true      | //vda1cs4850/c$/workspaces/node_modules                                                                                         |
| //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                            | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types/dir                                                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules                                                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types/dir                                                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules                                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules                                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                    |

## RootDirForResolution: //vda1cs4850/c$/user/username/folderAtRoot/folder1

| Location                                                                                                                        | getDirectoryToWatchFailedLookupLocation                                                                                         | Recursive | Location if not symlink                                                                                                         |
| ------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------- | --------- | ------------------------------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/node_modules/@types/dir                                                                            | true      | //vda1cs4850/c$/folderAtRoot/node_modules                                                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types/dir                                                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/node_modules                                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                            | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules                                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                            | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               |
| //vda1cs4850/c$/users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types/dir                                                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/node_modules                                                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types/dir                                                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules                                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules                                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                |
| //vda1cs4850/c$/user/node_modules/@types/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/node_modules/@types/dir                                                                                    | true      | //vda1cs4850/c$/user/node_modules                                                                                               |
| //vda1cs4850/c$/user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/node_modules/@types/dir                                                                           | true      | //vda1cs4850/c$/user/username/node_modules                                                                                      |
| //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types/dir                                                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/node_modules                                                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules                                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2                                                                      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2                                                                      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2                                                                      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2                                                                      |
| //vda1cs4850/c$/usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/node_modules/@types/dir                                                                                     | true      | //vda1cs4850/c$/usr/node_modules                                                                                                |
| //vda1cs4850/c$/usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/node_modules/@types/dir                                                                            | true      | //vda1cs4850/c$/usr/username/node_modules                                                                                       |
| //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types/dir                                                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules                                                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types/dir                                                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules                                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  |
| //vda1cs4850/c$/home/node_modules/@types/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/node_modules/@types/dir                                                                                    | true      | //vda1cs4850/c$/home/node_modules                                                                                               |
| //vda1cs4850/c$/home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/node_modules/@types/dir                                                                           | true      | //vda1cs4850/c$/home/username/node_modules                                                                                      |
| //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types/dir                                                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/node_modules                                                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules                                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| //vda1cs4850/c$/workspaces/node_modules/@types/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/c$/workspaces/node_modules/@types/dir                                                                              | true      | //vda1cs4850/c$/workspaces/node_modules                                                                                         |
| //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                            | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types/dir                                                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules                                                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types/dir                                                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules                                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules                                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                    |

## RootDirForResolution: //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2

| Location                                                                                                                        | getDirectoryToWatchFailedLookupLocation                                                                                         | Recursive | Location if not symlink                                                                                                         |
| ------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------- | --------- | ------------------------------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/node_modules/@types/dir                                                                            | true      | //vda1cs4850/c$/folderAtRoot/node_modules                                                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types/dir                                                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/node_modules                                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                            | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules                                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                            | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               |
| //vda1cs4850/c$/users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types/dir                                                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/node_modules                                                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types/dir                                                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules                                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules                                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                |
| //vda1cs4850/c$/user/node_modules/@types/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/node_modules/@types/dir                                                                                    | true      | //vda1cs4850/c$/user/node_modules                                                                                               |
| //vda1cs4850/c$/user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/node_modules/@types/dir                                                                           | true      | //vda1cs4850/c$/user/username/node_modules                                                                                      |
| //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types/dir                                                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/node_modules                                                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules                                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3                                                              |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3                                                              |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3                                                              |
| //vda1cs4850/c$/usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/node_modules/@types/dir                                                                                     | true      | //vda1cs4850/c$/usr/node_modules                                                                                                |
| //vda1cs4850/c$/usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/node_modules/@types/dir                                                                            | true      | //vda1cs4850/c$/usr/username/node_modules                                                                                       |
| //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types/dir                                                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules                                                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types/dir                                                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules                                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  |
| //vda1cs4850/c$/home/node_modules/@types/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/node_modules/@types/dir                                                                                    | true      | //vda1cs4850/c$/home/node_modules                                                                                               |
| //vda1cs4850/c$/home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/node_modules/@types/dir                                                                           | true      | //vda1cs4850/c$/home/username/node_modules                                                                                      |
| //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types/dir                                                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/node_modules                                                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules                                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| //vda1cs4850/c$/workspaces/node_modules/@types/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/c$/workspaces/node_modules/@types/dir                                                                              | true      | //vda1cs4850/c$/workspaces/node_modules                                                                                         |
| //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                            | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types/dir                                                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules                                                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types/dir                                                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules                                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules                                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                    |

## RootDirForResolution: //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3

| Location                                                                                                                        | getDirectoryToWatchFailedLookupLocation                                                                                         | Recursive | Location if not symlink                                                                                                         |
| ------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------- | --------- | ------------------------------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/node_modules/@types/dir                                                                            | true      | //vda1cs4850/c$/folderAtRoot/node_modules                                                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types/dir                                                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/node_modules                                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                            | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules                                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                            | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               |
| //vda1cs4850/c$/users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types/dir                                                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/node_modules                                                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types/dir                                                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules                                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules                                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                |
| //vda1cs4850/c$/user/node_modules/@types/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/node_modules/@types/dir                                                                                    | true      | //vda1cs4850/c$/user/node_modules                                                                                               |
| //vda1cs4850/c$/user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/node_modules/@types/dir                                                                           | true      | //vda1cs4850/c$/user/username/node_modules                                                                                      |
| //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types/dir                                                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/node_modules                                                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules                                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                                      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                                      |
| //vda1cs4850/c$/usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/node_modules/@types/dir                                                                                     | true      | //vda1cs4850/c$/usr/node_modules                                                                                                |
| //vda1cs4850/c$/usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/node_modules/@types/dir                                                                            | true      | //vda1cs4850/c$/usr/username/node_modules                                                                                       |
| //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types/dir                                                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules                                                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types/dir                                                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules                                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  |
| //vda1cs4850/c$/home/node_modules/@types/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/node_modules/@types/dir                                                                                    | true      | //vda1cs4850/c$/home/node_modules                                                                                               |
| //vda1cs4850/c$/home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/node_modules/@types/dir                                                                           | true      | //vda1cs4850/c$/home/username/node_modules                                                                                      |
| //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types/dir                                                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/node_modules                                                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules                                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| //vda1cs4850/c$/workspaces/node_modules/@types/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/c$/workspaces/node_modules/@types/dir                                                                              | true      | //vda1cs4850/c$/workspaces/node_modules                                                                                         |
| //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                            | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types/dir                                                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules                                                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types/dir                                                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules                                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules                                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                    |

## RootDirForResolution: //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                                                        | getDirectoryToWatchFailedLookupLocation                                                                                         | Recursive | Location if not symlink                                                                                                         |
| ------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------- | --------- | ------------------------------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/node_modules/@types/dir                                                                            | true      | //vda1cs4850/c$/folderAtRoot/node_modules                                                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types/dir                                                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/node_modules                                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                            | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules                                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                            | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               |
| //vda1cs4850/c$/users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types/dir                                                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/node_modules                                                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types/dir                                                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules                                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules                                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                |
| //vda1cs4850/c$/user/node_modules/@types/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/node_modules/@types/dir                                                                                    | true      | //vda1cs4850/c$/user/node_modules                                                                                               |
| //vda1cs4850/c$/user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/node_modules/@types/dir                                                                           | true      | //vda1cs4850/c$/user/username/node_modules                                                                                      |
| //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types/dir                                                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/node_modules                                                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules                                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                              |
| //vda1cs4850/c$/usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/node_modules/@types/dir                                                                                     | true      | //vda1cs4850/c$/usr/node_modules                                                                                                |
| //vda1cs4850/c$/usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/node_modules/@types/dir                                                                            | true      | //vda1cs4850/c$/usr/username/node_modules                                                                                       |
| //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types/dir                                                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules                                                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types/dir                                                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules                                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  |
| //vda1cs4850/c$/home/node_modules/@types/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/node_modules/@types/dir                                                                                    | true      | //vda1cs4850/c$/home/node_modules                                                                                               |
| //vda1cs4850/c$/home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/node_modules/@types/dir                                                                           | true      | //vda1cs4850/c$/home/username/node_modules                                                                                      |
| //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types/dir                                                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/node_modules                                                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules                                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| //vda1cs4850/c$/workspaces/node_modules/@types/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/c$/workspaces/node_modules/@types/dir                                                                              | true      | //vda1cs4850/c$/workspaces/node_modules                                                                                         |
| //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                            | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types/dir                                                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules                                                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types/dir                                                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules                                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules                                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                    |

## RootDirForResolution: //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                                                        | getDirectoryToWatchFailedLookupLocation                                                                                         | Recursive | Location if not symlink                                                                                                         |
| ------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------- | --------- | ------------------------------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/node_modules/@types/dir                                                                            | true      | //vda1cs4850/c$/folderAtRoot/node_modules                                                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types/dir                                                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/node_modules                                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                            | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules                                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                            | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               |
| //vda1cs4850/c$/users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types/dir                                                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/node_modules                                                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types/dir                                                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules                                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules                                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                |
| //vda1cs4850/c$/user/node_modules/@types/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/node_modules/@types/dir                                                                                    | true      | //vda1cs4850/c$/user/node_modules                                                                                               |
| //vda1cs4850/c$/user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/node_modules/@types/dir                                                                           | true      | //vda1cs4850/c$/user/username/node_modules                                                                                      |
| //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types/dir                                                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/node_modules                                                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules                                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| //vda1cs4850/c$/usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/node_modules/@types/dir                                                                                     | true      | //vda1cs4850/c$/usr/node_modules                                                                                                |
| //vda1cs4850/c$/usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/node_modules/@types/dir                                                                            | true      | //vda1cs4850/c$/usr/username/node_modules                                                                                       |
| //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types/dir                                                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules                                                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types/dir                                                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules                                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  |
| //vda1cs4850/c$/home/node_modules/@types/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/node_modules/@types/dir                                                                                    | true      | //vda1cs4850/c$/home/node_modules                                                                                               |
| //vda1cs4850/c$/home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/node_modules/@types/dir                                                                           | true      | //vda1cs4850/c$/home/username/node_modules                                                                                      |
| //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types/dir                                                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/node_modules                                                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules                                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| //vda1cs4850/c$/workspaces/node_modules/@types/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/c$/workspaces/node_modules/@types/dir                                                                              | true      | //vda1cs4850/c$/workspaces/node_modules                                                                                         |
| //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                            | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types/dir                                                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules                                                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types/dir                                                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules                                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules                                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                    |

## RootDirForResolution: //vda1cs4850/c$/usr

| Location                                                                                                                        | getDirectoryToWatchFailedLookupLocation                                                                                         | Recursive | Location if not symlink                                                                                                         |
| ------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------- | --------- | ------------------------------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/node_modules/@types/dir                                                                            | true      | //vda1cs4850/c$/folderAtRoot/node_modules                                                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types/dir                                                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/node_modules                                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                            | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules                                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                            | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               |
| //vda1cs4850/c$/users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types/dir                                                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/node_modules                                                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types/dir                                                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules                                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules                                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                |
| //vda1cs4850/c$/user/node_modules/@types/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/node_modules/@types/dir                                                                                    | true      | //vda1cs4850/c$/user/node_modules                                                                                               |
| //vda1cs4850/c$/user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/node_modules/@types/dir                                                                           | true      | //vda1cs4850/c$/user/username/node_modules                                                                                      |
| //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types/dir                                                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/node_modules                                                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules                                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| //vda1cs4850/c$/usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/node_modules/@types/dir                                                                                     | true      | //vda1cs4850/c$/usr/node_modules                                                                                                |
| //vda1cs4850/c$/usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/node_modules/@types/dir                                                                            | true      | //vda1cs4850/c$/usr/username/node_modules                                                                                       |
| //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types/dir                                                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules                                                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types/dir                                                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules                                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  |
| //vda1cs4850/c$/home/node_modules/@types/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/node_modules/@types/dir                                                                                    | true      | //vda1cs4850/c$/home/node_modules                                                                                               |
| //vda1cs4850/c$/home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/node_modules/@types/dir                                                                           | true      | //vda1cs4850/c$/home/username/node_modules                                                                                      |
| //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types/dir                                                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/node_modules                                                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules                                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| //vda1cs4850/c$/workspaces/node_modules/@types/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/c$/workspaces/node_modules/@types/dir                                                                              | true      | //vda1cs4850/c$/workspaces/node_modules                                                                                         |
| //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                            | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types/dir                                                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules                                                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types/dir                                                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules                                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules                                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                    |

## RootDirForResolution: //vda1cs4850/c$/usr/username

| Location                                                                                                                        | getDirectoryToWatchFailedLookupLocation                                                                                         | Recursive | Location if not symlink                                                                                                         |
| ------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------- | --------- | ------------------------------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/node_modules/@types/dir                                                                            | true      | //vda1cs4850/c$/folderAtRoot/node_modules                                                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types/dir                                                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/node_modules                                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                            | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules                                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                            | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               |
| //vda1cs4850/c$/users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types/dir                                                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/node_modules                                                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types/dir                                                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules                                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules                                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                |
| //vda1cs4850/c$/user/node_modules/@types/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/node_modules/@types/dir                                                                                    | true      | //vda1cs4850/c$/user/node_modules                                                                                               |
| //vda1cs4850/c$/user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/node_modules/@types/dir                                                                           | true      | //vda1cs4850/c$/user/username/node_modules                                                                                      |
| //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types/dir                                                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/node_modules                                                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules                                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| //vda1cs4850/c$/usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/node_modules/@types/dir                                                                                     | true      | //vda1cs4850/c$/usr/node_modules                                                                                                |
| //vda1cs4850/c$/usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/node_modules/@types/dir                                                                            | true      | //vda1cs4850/c$/usr/username/node_modules                                                                                       |
| //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types/dir                                                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot                                                                                       |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types/dir                                                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot                                                                                       |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot                                                                                       |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot                                                                                       |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot                                                                                       |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot                                                                                       |
| //vda1cs4850/c$/home/node_modules/@types/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/node_modules/@types/dir                                                                                    | true      | //vda1cs4850/c$/home/node_modules                                                                                               |
| //vda1cs4850/c$/home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/node_modules/@types/dir                                                                           | true      | //vda1cs4850/c$/home/username/node_modules                                                                                      |
| //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types/dir                                                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/node_modules                                                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules                                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| //vda1cs4850/c$/workspaces/node_modules/@types/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/c$/workspaces/node_modules/@types/dir                                                                              | true      | //vda1cs4850/c$/workspaces/node_modules                                                                                         |
| //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                            | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types/dir                                                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules                                                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types/dir                                                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules                                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules                                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                    |

## RootDirForResolution: //vda1cs4850/c$/usr/username/folderAtRoot

| Location                                                                                                                        | getDirectoryToWatchFailedLookupLocation                                                                                         | Recursive | Location if not symlink                                                                                                         |
| ------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------- | --------- | ------------------------------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/node_modules/@types/dir                                                                            | true      | //vda1cs4850/c$/folderAtRoot/node_modules                                                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types/dir                                                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/node_modules                                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                            | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules                                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                            | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               |
| //vda1cs4850/c$/users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types/dir                                                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/node_modules                                                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types/dir                                                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules                                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules                                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                |
| //vda1cs4850/c$/user/node_modules/@types/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/node_modules/@types/dir                                                                                    | true      | //vda1cs4850/c$/user/node_modules                                                                                               |
| //vda1cs4850/c$/user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/node_modules/@types/dir                                                                           | true      | //vda1cs4850/c$/user/username/node_modules                                                                                      |
| //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types/dir                                                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/node_modules                                                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules                                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| //vda1cs4850/c$/usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/node_modules/@types/dir                                                                                     | true      | //vda1cs4850/c$/usr/node_modules                                                                                                |
| //vda1cs4850/c$/usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/node_modules/@types/dir                                                                            | true      | //vda1cs4850/c$/usr/username/node_modules                                                                                       |
| //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types/dir                                                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules                                                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types/dir                                                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1                                                                               |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1                                                                               |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1                                                                               |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1                                                                               |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1                                                                               |
| //vda1cs4850/c$/home/node_modules/@types/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/node_modules/@types/dir                                                                                    | true      | //vda1cs4850/c$/home/node_modules                                                                                               |
| //vda1cs4850/c$/home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/node_modules/@types/dir                                                                           | true      | //vda1cs4850/c$/home/username/node_modules                                                                                      |
| //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types/dir                                                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/node_modules                                                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules                                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| //vda1cs4850/c$/workspaces/node_modules/@types/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/c$/workspaces/node_modules/@types/dir                                                                              | true      | //vda1cs4850/c$/workspaces/node_modules                                                                                         |
| //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                            | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types/dir                                                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules                                                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types/dir                                                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules                                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules                                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                    |

## RootDirForResolution: //vda1cs4850/c$/usr/username/folderAtRoot/folder1

| Location                                                                                                                        | getDirectoryToWatchFailedLookupLocation                                                                                         | Recursive | Location if not symlink                                                                                                         |
| ------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------- | --------- | ------------------------------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/node_modules/@types/dir                                                                            | true      | //vda1cs4850/c$/folderAtRoot/node_modules                                                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types/dir                                                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/node_modules                                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                            | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules                                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                            | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               |
| //vda1cs4850/c$/users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types/dir                                                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/node_modules                                                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types/dir                                                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules                                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules                                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                |
| //vda1cs4850/c$/user/node_modules/@types/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/node_modules/@types/dir                                                                                    | true      | //vda1cs4850/c$/user/node_modules                                                                                               |
| //vda1cs4850/c$/user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/node_modules/@types/dir                                                                           | true      | //vda1cs4850/c$/user/username/node_modules                                                                                      |
| //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types/dir                                                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/node_modules                                                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules                                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| //vda1cs4850/c$/usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/node_modules/@types/dir                                                                                     | true      | //vda1cs4850/c$/usr/node_modules                                                                                                |
| //vda1cs4850/c$/usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/node_modules/@types/dir                                                                            | true      | //vda1cs4850/c$/usr/username/node_modules                                                                                       |
| //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types/dir                                                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules                                                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types/dir                                                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules                                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2                                                                       |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2                                                                       |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2                                                                       |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2                                                                       |
| //vda1cs4850/c$/home/node_modules/@types/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/node_modules/@types/dir                                                                                    | true      | //vda1cs4850/c$/home/node_modules                                                                                               |
| //vda1cs4850/c$/home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/node_modules/@types/dir                                                                           | true      | //vda1cs4850/c$/home/username/node_modules                                                                                      |
| //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types/dir                                                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/node_modules                                                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules                                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| //vda1cs4850/c$/workspaces/node_modules/@types/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/c$/workspaces/node_modules/@types/dir                                                                              | true      | //vda1cs4850/c$/workspaces/node_modules                                                                                         |
| //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                            | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types/dir                                                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules                                                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types/dir                                                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules                                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules                                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                    |

## RootDirForResolution: //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2

| Location                                                                                                                        | getDirectoryToWatchFailedLookupLocation                                                                                         | Recursive | Location if not symlink                                                                                                         |
| ------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------- | --------- | ------------------------------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/node_modules/@types/dir                                                                            | true      | //vda1cs4850/c$/folderAtRoot/node_modules                                                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types/dir                                                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/node_modules                                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                            | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules                                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                            | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               |
| //vda1cs4850/c$/users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types/dir                                                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/node_modules                                                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types/dir                                                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules                                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules                                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                |
| //vda1cs4850/c$/user/node_modules/@types/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/node_modules/@types/dir                                                                                    | true      | //vda1cs4850/c$/user/node_modules                                                                                               |
| //vda1cs4850/c$/user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/node_modules/@types/dir                                                                           | true      | //vda1cs4850/c$/user/username/node_modules                                                                                      |
| //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types/dir                                                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/node_modules                                                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules                                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| //vda1cs4850/c$/usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/node_modules/@types/dir                                                                                     | true      | //vda1cs4850/c$/usr/node_modules                                                                                                |
| //vda1cs4850/c$/usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/node_modules/@types/dir                                                                            | true      | //vda1cs4850/c$/usr/username/node_modules                                                                                       |
| //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types/dir                                                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules                                                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types/dir                                                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules                                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3                                                               |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3                                                               |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3                                                               |
| //vda1cs4850/c$/home/node_modules/@types/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/node_modules/@types/dir                                                                                    | true      | //vda1cs4850/c$/home/node_modules                                                                                               |
| //vda1cs4850/c$/home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/node_modules/@types/dir                                                                           | true      | //vda1cs4850/c$/home/username/node_modules                                                                                      |
| //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types/dir                                                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/node_modules                                                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules                                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| //vda1cs4850/c$/workspaces/node_modules/@types/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/c$/workspaces/node_modules/@types/dir                                                                              | true      | //vda1cs4850/c$/workspaces/node_modules                                                                                         |
| //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                            | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types/dir                                                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules                                                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types/dir                                                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules                                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules                                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                    |

## RootDirForResolution: //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3

| Location                                                                                                                        | getDirectoryToWatchFailedLookupLocation                                                                                         | Recursive | Location if not symlink                                                                                                         |
| ------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------- | --------- | ------------------------------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/node_modules/@types/dir                                                                            | true      | //vda1cs4850/c$/folderAtRoot/node_modules                                                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types/dir                                                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/node_modules                                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                            | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules                                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                            | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               |
| //vda1cs4850/c$/users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types/dir                                                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/node_modules                                                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types/dir                                                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules                                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules                                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                |
| //vda1cs4850/c$/user/node_modules/@types/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/node_modules/@types/dir                                                                                    | true      | //vda1cs4850/c$/user/node_modules                                                                                               |
| //vda1cs4850/c$/user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/node_modules/@types/dir                                                                           | true      | //vda1cs4850/c$/user/username/node_modules                                                                                      |
| //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types/dir                                                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/node_modules                                                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules                                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| //vda1cs4850/c$/usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/node_modules/@types/dir                                                                                     | true      | //vda1cs4850/c$/usr/node_modules                                                                                                |
| //vda1cs4850/c$/usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/node_modules/@types/dir                                                                            | true      | //vda1cs4850/c$/usr/username/node_modules                                                                                       |
| //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types/dir                                                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules                                                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types/dir                                                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules                                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                                       |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                                       |
| //vda1cs4850/c$/home/node_modules/@types/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/node_modules/@types/dir                                                                                    | true      | //vda1cs4850/c$/home/node_modules                                                                                               |
| //vda1cs4850/c$/home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/node_modules/@types/dir                                                                           | true      | //vda1cs4850/c$/home/username/node_modules                                                                                      |
| //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types/dir                                                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/node_modules                                                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules                                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| //vda1cs4850/c$/workspaces/node_modules/@types/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/c$/workspaces/node_modules/@types/dir                                                                              | true      | //vda1cs4850/c$/workspaces/node_modules                                                                                         |
| //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                            | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types/dir                                                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules                                                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types/dir                                                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules                                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules                                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                    |

## RootDirForResolution: //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                                                        | getDirectoryToWatchFailedLookupLocation                                                                                         | Recursive | Location if not symlink                                                                                                         |
| ------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------- | --------- | ------------------------------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/node_modules/@types/dir                                                                            | true      | //vda1cs4850/c$/folderAtRoot/node_modules                                                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types/dir                                                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/node_modules                                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                            | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules                                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                            | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               |
| //vda1cs4850/c$/users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types/dir                                                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/node_modules                                                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types/dir                                                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules                                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules                                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                |
| //vda1cs4850/c$/user/node_modules/@types/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/node_modules/@types/dir                                                                                    | true      | //vda1cs4850/c$/user/node_modules                                                                                               |
| //vda1cs4850/c$/user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/node_modules/@types/dir                                                                           | true      | //vda1cs4850/c$/user/username/node_modules                                                                                      |
| //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types/dir                                                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/node_modules                                                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules                                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| //vda1cs4850/c$/usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/node_modules/@types/dir                                                                                     | true      | //vda1cs4850/c$/usr/node_modules                                                                                                |
| //vda1cs4850/c$/usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/node_modules/@types/dir                                                                            | true      | //vda1cs4850/c$/usr/username/node_modules                                                                                       |
| //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types/dir                                                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules                                                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types/dir                                                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules                                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                               |
| //vda1cs4850/c$/home/node_modules/@types/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/node_modules/@types/dir                                                                                    | true      | //vda1cs4850/c$/home/node_modules                                                                                               |
| //vda1cs4850/c$/home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/node_modules/@types/dir                                                                           | true      | //vda1cs4850/c$/home/username/node_modules                                                                                      |
| //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types/dir                                                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/node_modules                                                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules                                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| //vda1cs4850/c$/workspaces/node_modules/@types/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/c$/workspaces/node_modules/@types/dir                                                                              | true      | //vda1cs4850/c$/workspaces/node_modules                                                                                         |
| //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                            | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types/dir                                                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules                                                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types/dir                                                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules                                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules                                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                    |

## RootDirForResolution: //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                                                        | getDirectoryToWatchFailedLookupLocation                                                                                         | Recursive | Location if not symlink                                                                                                         |
| ------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------- | --------- | ------------------------------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/node_modules/@types/dir                                                                            | true      | //vda1cs4850/c$/folderAtRoot/node_modules                                                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types/dir                                                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/node_modules                                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                            | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules                                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                            | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               |
| //vda1cs4850/c$/users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types/dir                                                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/node_modules                                                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types/dir                                                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules                                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules                                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                |
| //vda1cs4850/c$/user/node_modules/@types/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/node_modules/@types/dir                                                                                    | true      | //vda1cs4850/c$/user/node_modules                                                                                               |
| //vda1cs4850/c$/user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/node_modules/@types/dir                                                                           | true      | //vda1cs4850/c$/user/username/node_modules                                                                                      |
| //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types/dir                                                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/node_modules                                                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules                                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| //vda1cs4850/c$/usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/node_modules/@types/dir                                                                                     | true      | //vda1cs4850/c$/usr/node_modules                                                                                                |
| //vda1cs4850/c$/usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/node_modules/@types/dir                                                                            | true      | //vda1cs4850/c$/usr/username/node_modules                                                                                       |
| //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types/dir                                                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules                                                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types/dir                                                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules                                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  |
| //vda1cs4850/c$/home/node_modules/@types/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/node_modules/@types/dir                                                                                    | true      | //vda1cs4850/c$/home/node_modules                                                                                               |
| //vda1cs4850/c$/home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/node_modules/@types/dir                                                                           | true      | //vda1cs4850/c$/home/username/node_modules                                                                                      |
| //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types/dir                                                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/node_modules                                                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules                                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| //vda1cs4850/c$/workspaces/node_modules/@types/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/c$/workspaces/node_modules/@types/dir                                                                              | true      | //vda1cs4850/c$/workspaces/node_modules                                                                                         |
| //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                            | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types/dir                                                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules                                                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types/dir                                                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules                                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules                                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                    |

## RootDirForResolution: //vda1cs4850/c$/home

| Location                                                                                                                        | getDirectoryToWatchFailedLookupLocation                                                                                         | Recursive | Location if not symlink                                                                                                         |
| ------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------- | --------- | ------------------------------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/node_modules/@types/dir                                                                            | true      | //vda1cs4850/c$/folderAtRoot/node_modules                                                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types/dir                                                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/node_modules                                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                            | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules                                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                            | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               |
| //vda1cs4850/c$/users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types/dir                                                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/node_modules                                                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types/dir                                                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules                                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules                                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                |
| //vda1cs4850/c$/user/node_modules/@types/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/node_modules/@types/dir                                                                                    | true      | //vda1cs4850/c$/user/node_modules                                                                                               |
| //vda1cs4850/c$/user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/node_modules/@types/dir                                                                           | true      | //vda1cs4850/c$/user/username/node_modules                                                                                      |
| //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types/dir                                                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/node_modules                                                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules                                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| //vda1cs4850/c$/usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/node_modules/@types/dir                                                                                     | true      | //vda1cs4850/c$/usr/node_modules                                                                                                |
| //vda1cs4850/c$/usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/node_modules/@types/dir                                                                            | true      | //vda1cs4850/c$/usr/username/node_modules                                                                                       |
| //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types/dir                                                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules                                                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types/dir                                                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules                                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  |
| //vda1cs4850/c$/home/node_modules/@types/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/node_modules/@types/dir                                                                                    | true      | //vda1cs4850/c$/home/node_modules                                                                                               |
| //vda1cs4850/c$/home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/node_modules/@types/dir                                                                           | true      | //vda1cs4850/c$/home/username/node_modules                                                                                      |
| //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types/dir                                                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/node_modules                                                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules                                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| //vda1cs4850/c$/workspaces/node_modules/@types/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/c$/workspaces/node_modules/@types/dir                                                                              | true      | //vda1cs4850/c$/workspaces/node_modules                                                                                         |
| //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                            | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types/dir                                                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules                                                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types/dir                                                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules                                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules                                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                    |

## RootDirForResolution: //vda1cs4850/c$/home/username

| Location                                                                                                                        | getDirectoryToWatchFailedLookupLocation                                                                                         | Recursive | Location if not symlink                                                                                                         |
| ------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------- | --------- | ------------------------------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/node_modules/@types/dir                                                                            | true      | //vda1cs4850/c$/folderAtRoot/node_modules                                                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types/dir                                                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/node_modules                                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                            | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules                                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                            | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               |
| //vda1cs4850/c$/users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types/dir                                                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/node_modules                                                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types/dir                                                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules                                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules                                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                |
| //vda1cs4850/c$/user/node_modules/@types/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/node_modules/@types/dir                                                                                    | true      | //vda1cs4850/c$/user/node_modules                                                                                               |
| //vda1cs4850/c$/user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/node_modules/@types/dir                                                                           | true      | //vda1cs4850/c$/user/username/node_modules                                                                                      |
| //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types/dir                                                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/node_modules                                                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules                                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| //vda1cs4850/c$/usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/node_modules/@types/dir                                                                                     | true      | //vda1cs4850/c$/usr/node_modules                                                                                                |
| //vda1cs4850/c$/usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/node_modules/@types/dir                                                                            | true      | //vda1cs4850/c$/usr/username/node_modules                                                                                       |
| //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types/dir                                                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules                                                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types/dir                                                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules                                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  |
| //vda1cs4850/c$/home/node_modules/@types/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/node_modules/@types/dir                                                                                    | true      | //vda1cs4850/c$/home/node_modules                                                                                               |
| //vda1cs4850/c$/home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/node_modules/@types/dir                                                                           | true      | //vda1cs4850/c$/home/username/node_modules                                                                                      |
| //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types/dir                                                              | true      | //vda1cs4850/c$/home/username/folderAtRoot                                                                                      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | //vda1cs4850/c$/home/username/folderAtRoot                                                                                      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | //vda1cs4850/c$/home/username/folderAtRoot                                                                                      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | //vda1cs4850/c$/home/username/folderAtRoot                                                                                      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | //vda1cs4850/c$/home/username/folderAtRoot                                                                                      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | //vda1cs4850/c$/home/username/folderAtRoot                                                                                      |
| //vda1cs4850/c$/workspaces/node_modules/@types/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/c$/workspaces/node_modules/@types/dir                                                                              | true      | //vda1cs4850/c$/workspaces/node_modules                                                                                         |
| //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                            | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types/dir                                                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules                                                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types/dir                                                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules                                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules                                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                    |

## RootDirForResolution: //vda1cs4850/c$/home/username/folderAtRoot

| Location                                                                                                                        | getDirectoryToWatchFailedLookupLocation                                                                                         | Recursive | Location if not symlink                                                                                                         |
| ------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------- | --------- | ------------------------------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/node_modules/@types/dir                                                                            | true      | //vda1cs4850/c$/folderAtRoot/node_modules                                                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types/dir                                                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/node_modules                                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                            | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules                                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                            | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               |
| //vda1cs4850/c$/users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types/dir                                                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/node_modules                                                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types/dir                                                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules                                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules                                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                |
| //vda1cs4850/c$/user/node_modules/@types/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/node_modules/@types/dir                                                                                    | true      | //vda1cs4850/c$/user/node_modules                                                                                               |
| //vda1cs4850/c$/user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/node_modules/@types/dir                                                                           | true      | //vda1cs4850/c$/user/username/node_modules                                                                                      |
| //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types/dir                                                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/node_modules                                                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules                                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| //vda1cs4850/c$/usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/node_modules/@types/dir                                                                                     | true      | //vda1cs4850/c$/usr/node_modules                                                                                                |
| //vda1cs4850/c$/usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/node_modules/@types/dir                                                                            | true      | //vda1cs4850/c$/usr/username/node_modules                                                                                       |
| //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types/dir                                                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules                                                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types/dir                                                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules                                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  |
| //vda1cs4850/c$/home/node_modules/@types/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/node_modules/@types/dir                                                                                    | true      | //vda1cs4850/c$/home/node_modules                                                                                               |
| //vda1cs4850/c$/home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/node_modules/@types/dir                                                                           | true      | //vda1cs4850/c$/home/username/node_modules                                                                                      |
| //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types/dir                                                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/node_modules                                                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1                                                                              |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1                                                                              |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1                                                                              |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1                                                                              |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1                                                                              |
| //vda1cs4850/c$/workspaces/node_modules/@types/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/c$/workspaces/node_modules/@types/dir                                                                              | true      | //vda1cs4850/c$/workspaces/node_modules                                                                                         |
| //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                            | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types/dir                                                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules                                                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types/dir                                                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules                                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules                                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                    |

## RootDirForResolution: //vda1cs4850/c$/home/username/folderAtRoot/folder1

| Location                                                                                                                        | getDirectoryToWatchFailedLookupLocation                                                                                         | Recursive | Location if not symlink                                                                                                         |
| ------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------- | --------- | ------------------------------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/node_modules/@types/dir                                                                            | true      | //vda1cs4850/c$/folderAtRoot/node_modules                                                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types/dir                                                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/node_modules                                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                            | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules                                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                            | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               |
| //vda1cs4850/c$/users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types/dir                                                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/node_modules                                                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types/dir                                                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules                                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules                                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                |
| //vda1cs4850/c$/user/node_modules/@types/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/node_modules/@types/dir                                                                                    | true      | //vda1cs4850/c$/user/node_modules                                                                                               |
| //vda1cs4850/c$/user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/node_modules/@types/dir                                                                           | true      | //vda1cs4850/c$/user/username/node_modules                                                                                      |
| //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types/dir                                                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/node_modules                                                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules                                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| //vda1cs4850/c$/usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/node_modules/@types/dir                                                                                     | true      | //vda1cs4850/c$/usr/node_modules                                                                                                |
| //vda1cs4850/c$/usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/node_modules/@types/dir                                                                            | true      | //vda1cs4850/c$/usr/username/node_modules                                                                                       |
| //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types/dir                                                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules                                                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types/dir                                                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules                                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  |
| //vda1cs4850/c$/home/node_modules/@types/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/node_modules/@types/dir                                                                                    | true      | //vda1cs4850/c$/home/node_modules                                                                                               |
| //vda1cs4850/c$/home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/node_modules/@types/dir                                                                           | true      | //vda1cs4850/c$/home/username/node_modules                                                                                      |
| //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types/dir                                                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/node_modules                                                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules                                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2                                                                      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2                                                                      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2                                                                      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2                                                                      |
| //vda1cs4850/c$/workspaces/node_modules/@types/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/c$/workspaces/node_modules/@types/dir                                                                              | true      | //vda1cs4850/c$/workspaces/node_modules                                                                                         |
| //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                            | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types/dir                                                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules                                                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types/dir                                                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules                                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules                                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                    |

## RootDirForResolution: //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2

| Location                                                                                                                        | getDirectoryToWatchFailedLookupLocation                                                                                         | Recursive | Location if not symlink                                                                                                         |
| ------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------- | --------- | ------------------------------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/node_modules/@types/dir                                                                            | true      | //vda1cs4850/c$/folderAtRoot/node_modules                                                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types/dir                                                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/node_modules                                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                            | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules                                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                            | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               |
| //vda1cs4850/c$/users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types/dir                                                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/node_modules                                                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types/dir                                                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules                                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules                                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                |
| //vda1cs4850/c$/user/node_modules/@types/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/node_modules/@types/dir                                                                                    | true      | //vda1cs4850/c$/user/node_modules                                                                                               |
| //vda1cs4850/c$/user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/node_modules/@types/dir                                                                           | true      | //vda1cs4850/c$/user/username/node_modules                                                                                      |
| //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types/dir                                                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/node_modules                                                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules                                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| //vda1cs4850/c$/usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/node_modules/@types/dir                                                                                     | true      | //vda1cs4850/c$/usr/node_modules                                                                                                |
| //vda1cs4850/c$/usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/node_modules/@types/dir                                                                            | true      | //vda1cs4850/c$/usr/username/node_modules                                                                                       |
| //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types/dir                                                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules                                                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types/dir                                                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules                                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  |
| //vda1cs4850/c$/home/node_modules/@types/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/node_modules/@types/dir                                                                                    | true      | //vda1cs4850/c$/home/node_modules                                                                                               |
| //vda1cs4850/c$/home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/node_modules/@types/dir                                                                           | true      | //vda1cs4850/c$/home/username/node_modules                                                                                      |
| //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types/dir                                                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/node_modules                                                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules                                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3                                                              |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3                                                              |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3                                                              |
| //vda1cs4850/c$/workspaces/node_modules/@types/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/c$/workspaces/node_modules/@types/dir                                                                              | true      | //vda1cs4850/c$/workspaces/node_modules                                                                                         |
| //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                            | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types/dir                                                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules                                                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types/dir                                                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules                                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules                                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                    |

## RootDirForResolution: //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3

| Location                                                                                                                        | getDirectoryToWatchFailedLookupLocation                                                                                         | Recursive | Location if not symlink                                                                                                         |
| ------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------- | --------- | ------------------------------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/node_modules/@types/dir                                                                            | true      | //vda1cs4850/c$/folderAtRoot/node_modules                                                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types/dir                                                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/node_modules                                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                            | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules                                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                            | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               |
| //vda1cs4850/c$/users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types/dir                                                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/node_modules                                                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types/dir                                                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules                                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules                                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                |
| //vda1cs4850/c$/user/node_modules/@types/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/node_modules/@types/dir                                                                                    | true      | //vda1cs4850/c$/user/node_modules                                                                                               |
| //vda1cs4850/c$/user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/node_modules/@types/dir                                                                           | true      | //vda1cs4850/c$/user/username/node_modules                                                                                      |
| //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types/dir                                                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/node_modules                                                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules                                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| //vda1cs4850/c$/usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/node_modules/@types/dir                                                                                     | true      | //vda1cs4850/c$/usr/node_modules                                                                                                |
| //vda1cs4850/c$/usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/node_modules/@types/dir                                                                            | true      | //vda1cs4850/c$/usr/username/node_modules                                                                                       |
| //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types/dir                                                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules                                                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types/dir                                                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules                                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  |
| //vda1cs4850/c$/home/node_modules/@types/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/node_modules/@types/dir                                                                                    | true      | //vda1cs4850/c$/home/node_modules                                                                                               |
| //vda1cs4850/c$/home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/node_modules/@types/dir                                                                           | true      | //vda1cs4850/c$/home/username/node_modules                                                                                      |
| //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types/dir                                                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/node_modules                                                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules                                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                                      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                                      |
| //vda1cs4850/c$/workspaces/node_modules/@types/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/c$/workspaces/node_modules/@types/dir                                                                              | true      | //vda1cs4850/c$/workspaces/node_modules                                                                                         |
| //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                            | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types/dir                                                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules                                                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types/dir                                                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules                                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules                                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                    |

## RootDirForResolution: //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                                                        | getDirectoryToWatchFailedLookupLocation                                                                                         | Recursive | Location if not symlink                                                                                                         |
| ------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------- | --------- | ------------------------------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/node_modules/@types/dir                                                                            | true      | //vda1cs4850/c$/folderAtRoot/node_modules                                                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types/dir                                                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/node_modules                                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                            | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules                                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                            | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               |
| //vda1cs4850/c$/users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types/dir                                                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/node_modules                                                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types/dir                                                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules                                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules                                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                |
| //vda1cs4850/c$/user/node_modules/@types/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/node_modules/@types/dir                                                                                    | true      | //vda1cs4850/c$/user/node_modules                                                                                               |
| //vda1cs4850/c$/user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/node_modules/@types/dir                                                                           | true      | //vda1cs4850/c$/user/username/node_modules                                                                                      |
| //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types/dir                                                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/node_modules                                                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules                                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| //vda1cs4850/c$/usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/node_modules/@types/dir                                                                                     | true      | //vda1cs4850/c$/usr/node_modules                                                                                                |
| //vda1cs4850/c$/usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/node_modules/@types/dir                                                                            | true      | //vda1cs4850/c$/usr/username/node_modules                                                                                       |
| //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types/dir                                                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules                                                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types/dir                                                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules                                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  |
| //vda1cs4850/c$/home/node_modules/@types/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/node_modules/@types/dir                                                                                    | true      | //vda1cs4850/c$/home/node_modules                                                                                               |
| //vda1cs4850/c$/home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/node_modules/@types/dir                                                                           | true      | //vda1cs4850/c$/home/username/node_modules                                                                                      |
| //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types/dir                                                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/node_modules                                                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules                                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                              |
| //vda1cs4850/c$/workspaces/node_modules/@types/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/c$/workspaces/node_modules/@types/dir                                                                              | true      | //vda1cs4850/c$/workspaces/node_modules                                                                                         |
| //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                            | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types/dir                                                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules                                                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types/dir                                                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules                                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules                                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                    |

## RootDirForResolution: //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                                                        | getDirectoryToWatchFailedLookupLocation                                                                                         | Recursive | Location if not symlink                                                                                                         |
| ------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------- | --------- | ------------------------------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/node_modules/@types/dir                                                                            | true      | //vda1cs4850/c$/folderAtRoot/node_modules                                                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types/dir                                                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/node_modules                                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                            | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules                                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                            | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               |
| //vda1cs4850/c$/users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types/dir                                                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/node_modules                                                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types/dir                                                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules                                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules                                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                |
| //vda1cs4850/c$/user/node_modules/@types/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/node_modules/@types/dir                                                                                    | true      | //vda1cs4850/c$/user/node_modules                                                                                               |
| //vda1cs4850/c$/user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/node_modules/@types/dir                                                                           | true      | //vda1cs4850/c$/user/username/node_modules                                                                                      |
| //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types/dir                                                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/node_modules                                                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules                                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| //vda1cs4850/c$/usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/node_modules/@types/dir                                                                                     | true      | //vda1cs4850/c$/usr/node_modules                                                                                                |
| //vda1cs4850/c$/usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/node_modules/@types/dir                                                                            | true      | //vda1cs4850/c$/usr/username/node_modules                                                                                       |
| //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types/dir                                                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules                                                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types/dir                                                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules                                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  |
| //vda1cs4850/c$/home/node_modules/@types/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/node_modules/@types/dir                                                                                    | true      | //vda1cs4850/c$/home/node_modules                                                                                               |
| //vda1cs4850/c$/home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/node_modules/@types/dir                                                                           | true      | //vda1cs4850/c$/home/username/node_modules                                                                                      |
| //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types/dir                                                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/node_modules                                                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules                                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| //vda1cs4850/c$/workspaces/node_modules/@types/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/c$/workspaces/node_modules/@types/dir                                                                              | true      | //vda1cs4850/c$/workspaces/node_modules                                                                                         |
| //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                            | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types/dir                                                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules                                                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types/dir                                                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules                                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules                                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                    |

## RootDirForResolution: //vda1cs4850/c$/workspaces

| Location                                                                                                                        | getDirectoryToWatchFailedLookupLocation                                                                                         | Recursive | Location if not symlink                                                                                                         |
| ------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------- | --------- | ------------------------------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/node_modules/@types/dir                                                                            | true      | //vda1cs4850/c$/folderAtRoot/node_modules                                                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types/dir                                                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/node_modules                                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                            | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules                                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                            | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               |
| //vda1cs4850/c$/users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types/dir                                                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/node_modules                                                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types/dir                                                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules                                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules                                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                |
| //vda1cs4850/c$/user/node_modules/@types/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/node_modules/@types/dir                                                                                    | true      | //vda1cs4850/c$/user/node_modules                                                                                               |
| //vda1cs4850/c$/user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/node_modules/@types/dir                                                                           | true      | //vda1cs4850/c$/user/username/node_modules                                                                                      |
| //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types/dir                                                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/node_modules                                                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules                                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| //vda1cs4850/c$/usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/node_modules/@types/dir                                                                                     | true      | //vda1cs4850/c$/usr/node_modules                                                                                                |
| //vda1cs4850/c$/usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/node_modules/@types/dir                                                                            | true      | //vda1cs4850/c$/usr/username/node_modules                                                                                       |
| //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types/dir                                                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules                                                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types/dir                                                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules                                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  |
| //vda1cs4850/c$/home/node_modules/@types/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/node_modules/@types/dir                                                                                    | true      | //vda1cs4850/c$/home/node_modules                                                                                               |
| //vda1cs4850/c$/home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/node_modules/@types/dir                                                                           | true      | //vda1cs4850/c$/home/username/node_modules                                                                                      |
| //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types/dir                                                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/node_modules                                                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules                                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| //vda1cs4850/c$/workspaces/node_modules/@types/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/c$/workspaces/node_modules/@types/dir                                                                              | true      | //vda1cs4850/c$/workspaces/node_modules                                                                                         |
| //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                            | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types/dir                                                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules                                                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types/dir                                                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules                                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules                                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                    |

## RootDirForResolution: //vda1cs4850/c$/workspaces/folderAtRoot

| Location                                                                                                                        | getDirectoryToWatchFailedLookupLocation                                                                                         | Recursive | Location if not symlink                                                                                                         |
| ------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------- | --------- | ------------------------------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/node_modules/@types/dir                                                                            | true      | //vda1cs4850/c$/folderAtRoot/node_modules                                                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types/dir                                                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/node_modules                                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                            | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules                                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                            | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               |
| //vda1cs4850/c$/users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types/dir                                                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/node_modules                                                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types/dir                                                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules                                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules                                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                |
| //vda1cs4850/c$/user/node_modules/@types/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/node_modules/@types/dir                                                                                    | true      | //vda1cs4850/c$/user/node_modules                                                                                               |
| //vda1cs4850/c$/user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/node_modules/@types/dir                                                                           | true      | //vda1cs4850/c$/user/username/node_modules                                                                                      |
| //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types/dir                                                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/node_modules                                                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules                                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| //vda1cs4850/c$/usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/node_modules/@types/dir                                                                                     | true      | //vda1cs4850/c$/usr/node_modules                                                                                                |
| //vda1cs4850/c$/usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/node_modules/@types/dir                                                                            | true      | //vda1cs4850/c$/usr/username/node_modules                                                                                       |
| //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types/dir                                                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules                                                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types/dir                                                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules                                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  |
| //vda1cs4850/c$/home/node_modules/@types/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/node_modules/@types/dir                                                                                    | true      | //vda1cs4850/c$/home/node_modules                                                                                               |
| //vda1cs4850/c$/home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/node_modules/@types/dir                                                                           | true      | //vda1cs4850/c$/home/username/node_modules                                                                                      |
| //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types/dir                                                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/node_modules                                                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules                                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| //vda1cs4850/c$/workspaces/node_modules/@types/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/c$/workspaces/node_modules/@types/dir                                                                              | true      | //vda1cs4850/c$/workspaces/node_modules                                                                                         |
| //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                            | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types/dir                                                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules                                                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types/dir                                                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1                                                                                 |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1                                                                                 |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1                                                                                 |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1                                                                                 |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1                                                                                 |

## RootDirForResolution: //vda1cs4850/c$/workspaces/folderAtRoot/folder1

| Location                                                                                                                        | getDirectoryToWatchFailedLookupLocation                                                                                         | Recursive | Location if not symlink                                                                                                         |
| ------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------- | --------- | ------------------------------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/node_modules/@types/dir                                                                            | true      | //vda1cs4850/c$/folderAtRoot/node_modules                                                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types/dir                                                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/node_modules                                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                            | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules                                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                            | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               |
| //vda1cs4850/c$/users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types/dir                                                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/node_modules                                                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types/dir                                                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules                                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules                                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                |
| //vda1cs4850/c$/user/node_modules/@types/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/node_modules/@types/dir                                                                                    | true      | //vda1cs4850/c$/user/node_modules                                                                                               |
| //vda1cs4850/c$/user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/node_modules/@types/dir                                                                           | true      | //vda1cs4850/c$/user/username/node_modules                                                                                      |
| //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types/dir                                                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/node_modules                                                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules                                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| //vda1cs4850/c$/usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/node_modules/@types/dir                                                                                     | true      | //vda1cs4850/c$/usr/node_modules                                                                                                |
| //vda1cs4850/c$/usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/node_modules/@types/dir                                                                            | true      | //vda1cs4850/c$/usr/username/node_modules                                                                                       |
| //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types/dir                                                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules                                                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types/dir                                                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules                                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  |
| //vda1cs4850/c$/home/node_modules/@types/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/node_modules/@types/dir                                                                                    | true      | //vda1cs4850/c$/home/node_modules                                                                                               |
| //vda1cs4850/c$/home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/node_modules/@types/dir                                                                           | true      | //vda1cs4850/c$/home/username/node_modules                                                                                      |
| //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types/dir                                                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/node_modules                                                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules                                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| //vda1cs4850/c$/workspaces/node_modules/@types/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/c$/workspaces/node_modules/@types/dir                                                                              | true      | //vda1cs4850/c$/workspaces/node_modules                                                                                         |
| //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                            | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types/dir                                                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules                                                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types/dir                                                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules                                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2                                                                         |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2                                                                         |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2                                                                         |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2                                                                         |

## RootDirForResolution: //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2

| Location                                                                                                                        | getDirectoryToWatchFailedLookupLocation                                                                                         | Recursive | Location if not symlink                                                                                                         |
| ------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------- | --------- | ------------------------------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/node_modules/@types/dir                                                                            | true      | //vda1cs4850/c$/folderAtRoot/node_modules                                                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types/dir                                                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/node_modules                                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                            | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules                                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                            | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               |
| //vda1cs4850/c$/users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types/dir                                                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/node_modules                                                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types/dir                                                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules                                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules                                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                |
| //vda1cs4850/c$/user/node_modules/@types/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/node_modules/@types/dir                                                                                    | true      | //vda1cs4850/c$/user/node_modules                                                                                               |
| //vda1cs4850/c$/user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/node_modules/@types/dir                                                                           | true      | //vda1cs4850/c$/user/username/node_modules                                                                                      |
| //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types/dir                                                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/node_modules                                                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules                                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| //vda1cs4850/c$/usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/node_modules/@types/dir                                                                                     | true      | //vda1cs4850/c$/usr/node_modules                                                                                                |
| //vda1cs4850/c$/usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/node_modules/@types/dir                                                                            | true      | //vda1cs4850/c$/usr/username/node_modules                                                                                       |
| //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types/dir                                                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules                                                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types/dir                                                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules                                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  |
| //vda1cs4850/c$/home/node_modules/@types/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/node_modules/@types/dir                                                                                    | true      | //vda1cs4850/c$/home/node_modules                                                                                               |
| //vda1cs4850/c$/home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/node_modules/@types/dir                                                                           | true      | //vda1cs4850/c$/home/username/node_modules                                                                                      |
| //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types/dir                                                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/node_modules                                                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules                                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| //vda1cs4850/c$/workspaces/node_modules/@types/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/c$/workspaces/node_modules/@types/dir                                                                              | true      | //vda1cs4850/c$/workspaces/node_modules                                                                                         |
| //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                            | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types/dir                                                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules                                                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types/dir                                                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules                                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules                                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3                                                                 |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3                                                                 |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3                                                                 |

## RootDirForResolution: //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3

| Location                                                                                                                        | getDirectoryToWatchFailedLookupLocation                                                                                         | Recursive | Location if not symlink                                                                                                         |
| ------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------- | --------- | ------------------------------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/node_modules/@types/dir                                                                            | true      | //vda1cs4850/c$/folderAtRoot/node_modules                                                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types/dir                                                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/node_modules                                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                            | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules                                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                            | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               |
| //vda1cs4850/c$/users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types/dir                                                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/node_modules                                                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types/dir                                                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules                                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules                                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                |
| //vda1cs4850/c$/user/node_modules/@types/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/node_modules/@types/dir                                                                                    | true      | //vda1cs4850/c$/user/node_modules                                                                                               |
| //vda1cs4850/c$/user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/node_modules/@types/dir                                                                           | true      | //vda1cs4850/c$/user/username/node_modules                                                                                      |
| //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types/dir                                                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/node_modules                                                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules                                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| //vda1cs4850/c$/usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/node_modules/@types/dir                                                                                     | true      | //vda1cs4850/c$/usr/node_modules                                                                                                |
| //vda1cs4850/c$/usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/node_modules/@types/dir                                                                            | true      | //vda1cs4850/c$/usr/username/node_modules                                                                                       |
| //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types/dir                                                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules                                                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types/dir                                                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules                                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  |
| //vda1cs4850/c$/home/node_modules/@types/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/node_modules/@types/dir                                                                                    | true      | //vda1cs4850/c$/home/node_modules                                                                                               |
| //vda1cs4850/c$/home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/node_modules/@types/dir                                                                           | true      | //vda1cs4850/c$/home/username/node_modules                                                                                      |
| //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types/dir                                                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/node_modules                                                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules                                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| //vda1cs4850/c$/workspaces/node_modules/@types/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/c$/workspaces/node_modules/@types/dir                                                                              | true      | //vda1cs4850/c$/workspaces/node_modules                                                                                         |
| //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                            | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types/dir                                                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules                                                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types/dir                                                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules                                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules                                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                                         |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                                         |

## RootDirForResolution: //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                                                        | getDirectoryToWatchFailedLookupLocation                                                                                         | Recursive | Location if not symlink                                                                                                         |
| ------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------- | --------- | ------------------------------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/node_modules/@types/dir                                                                            | true      | //vda1cs4850/c$/folderAtRoot/node_modules                                                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types/dir                                                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/node_modules                                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                            | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules                                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                            | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               |
| //vda1cs4850/c$/users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types/dir                                                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/node_modules                                                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types/dir                                                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules                                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules                                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                |
| //vda1cs4850/c$/user/node_modules/@types/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/node_modules/@types/dir                                                                                    | true      | //vda1cs4850/c$/user/node_modules                                                                                               |
| //vda1cs4850/c$/user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/node_modules/@types/dir                                                                           | true      | //vda1cs4850/c$/user/username/node_modules                                                                                      |
| //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types/dir                                                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/node_modules                                                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules                                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| //vda1cs4850/c$/usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/node_modules/@types/dir                                                                                     | true      | //vda1cs4850/c$/usr/node_modules                                                                                                |
| //vda1cs4850/c$/usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/node_modules/@types/dir                                                                            | true      | //vda1cs4850/c$/usr/username/node_modules                                                                                       |
| //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types/dir                                                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules                                                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types/dir                                                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules                                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  |
| //vda1cs4850/c$/home/node_modules/@types/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/node_modules/@types/dir                                                                                    | true      | //vda1cs4850/c$/home/node_modules                                                                                               |
| //vda1cs4850/c$/home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/node_modules/@types/dir                                                                           | true      | //vda1cs4850/c$/home/username/node_modules                                                                                      |
| //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types/dir                                                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/node_modules                                                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules                                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| //vda1cs4850/c$/workspaces/node_modules/@types/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/c$/workspaces/node_modules/@types/dir                                                                              | true      | //vda1cs4850/c$/workspaces/node_modules                                                                                         |
| //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                            | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types/dir                                                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules                                                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types/dir                                                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules                                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules                                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                                 |

## RootDirForResolution: //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                                                        | getDirectoryToWatchFailedLookupLocation                                                                                         | Recursive | Location if not symlink                                                                                                         |
| ------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------- | --------- | ------------------------------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/node_modules/@types/dir                                                                            | true      | //vda1cs4850/c$/folderAtRoot/node_modules                                                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types/dir                                                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/node_modules                                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                            | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules                                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                            | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                                    | true      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               |
| //vda1cs4850/c$/users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                                 |           |                                                                                                                                 |
| //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types/dir                                                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/node_modules                                                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types/dir                                                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules                                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules                                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                             | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                     | true      | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                |
| //vda1cs4850/c$/user/node_modules/@types/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/node_modules/@types/dir                                                                                    | true      | //vda1cs4850/c$/user/node_modules                                                                                               |
| //vda1cs4850/c$/user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/node_modules/@types/dir                                                                           | true      | //vda1cs4850/c$/user/username/node_modules                                                                                      |
| //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types/dir                                                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/node_modules                                                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules                                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| //vda1cs4850/c$/usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/node_modules/@types/dir                                                                                     | true      | //vda1cs4850/c$/usr/node_modules                                                                                                |
| //vda1cs4850/c$/usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/node_modules/@types/dir                                                                            | true      | //vda1cs4850/c$/usr/username/node_modules                                                                                       |
| //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types/dir                                                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules                                                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types/dir                                                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules                                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                               | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                       | true      | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  |
| //vda1cs4850/c$/home/node_modules/@types/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/node_modules/@types/dir                                                                                    | true      | //vda1cs4850/c$/home/node_modules                                                                                               |
| //vda1cs4850/c$/home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/node_modules/@types/dir                                                                           | true      | //vda1cs4850/c$/home/username/node_modules                                                                                      |
| //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types/dir                                                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/node_modules                                                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types/dir                                                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules                                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir                                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules                                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                              | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                      | true      | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 |
| //vda1cs4850/c$/workspaces/node_modules/@types/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/c$/workspaces/node_modules/@types/dir                                                                              | true      | //vda1cs4850/c$/workspaces/node_modules                                                                                         |
| //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                            | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types/dir                                                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules                                                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types/dir                                                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules                                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types/dir                                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules                                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir                                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts            | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir                                 | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts    | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir                         | true      | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                    |

