# getDirectoryToWatchFailedLookupLocationInfileNonRecursive

Determines whether to watch given failed lookup location (file that didnt exist) when resolving module.
It also determines the directory to watch and whether to watch it recursively or not.

## Testing for Unc root: //vda1cs4850/

## RootDirForResolution: //vda1cs4850/

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive | Location if not symlink                                                                                  |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/somefile.d.ts                                                                               |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/somefile.d.ts                                                                  |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                          |
| //vda1cs4850/users/somefile.d.ts                                                                         |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/users/username/somefile.d.ts                                                                |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                          |
| //vda1cs4850/user/somefile.d.ts                                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/user/username/somefile.d.ts                                                                 |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                          |
| //vda1cs4850/usr/somefile.d.ts                                                                           |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/usr/username/somefile.d.ts                                                                  |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                          |
| //vda1cs4850/home/somefile.d.ts                                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/home/username/somefile.d.ts                                                                 |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/somefile.d.ts                                                                    |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/somefile.d.ts                                                       | //vda1cs4850/workspaces/folderAtRoot                                                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | //vda1cs4850/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                          |

## RootDirForResolution: //vda1cs4850/folderAtRoot

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive | Location if not symlink                                                                                  |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/somefile.d.ts                                                                               |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/somefile.d.ts                                                                  |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                          |
| //vda1cs4850/users/somefile.d.ts                                                                         |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/users/username/somefile.d.ts                                                                |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                          |
| //vda1cs4850/user/somefile.d.ts                                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/user/username/somefile.d.ts                                                                 |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                          |
| //vda1cs4850/usr/somefile.d.ts                                                                           |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/usr/username/somefile.d.ts                                                                  |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                          |
| //vda1cs4850/home/somefile.d.ts                                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/home/username/somefile.d.ts                                                                 |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/somefile.d.ts                                                                    |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/somefile.d.ts                                                       | //vda1cs4850/workspaces/folderAtRoot                                                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | //vda1cs4850/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                          |

## RootDirForResolution: //vda1cs4850/folderAtRoot/folder1

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive | Location if not symlink                                                                                  |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/somefile.d.ts                                                                               |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/somefile.d.ts                                                                  |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                          |
| //vda1cs4850/users/somefile.d.ts                                                                         |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/users/username/somefile.d.ts                                                                |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                          |
| //vda1cs4850/user/somefile.d.ts                                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/user/username/somefile.d.ts                                                                 |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                          |
| //vda1cs4850/usr/somefile.d.ts                                                                           |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/usr/username/somefile.d.ts                                                                  |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                          |
| //vda1cs4850/home/somefile.d.ts                                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/home/username/somefile.d.ts                                                                 |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/somefile.d.ts                                                                    |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/somefile.d.ts                                                       | //vda1cs4850/workspaces/folderAtRoot                                                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | //vda1cs4850/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                          |

## RootDirForResolution: //vda1cs4850/folderAtRoot/folder1/folder2

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive | Location if not symlink                                                                                  |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/somefile.d.ts                                                                               |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/somefile.d.ts                                                                  |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                          |
| //vda1cs4850/users/somefile.d.ts                                                                         |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/users/username/somefile.d.ts                                                                |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                          |
| //vda1cs4850/user/somefile.d.ts                                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/user/username/somefile.d.ts                                                                 |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                          |
| //vda1cs4850/usr/somefile.d.ts                                                                           |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/usr/username/somefile.d.ts                                                                  |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                          |
| //vda1cs4850/home/somefile.d.ts                                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/home/username/somefile.d.ts                                                                 |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/somefile.d.ts                                                                    |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/somefile.d.ts                                                       | //vda1cs4850/workspaces/folderAtRoot                                                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | //vda1cs4850/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                          |

## RootDirForResolution: //vda1cs4850/folderAtRoot/folder1/folder2/folder3

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive | Location if not symlink                                                                                  |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/somefile.d.ts                                                                               |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/somefile.d.ts                                                                  |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4                                                | true      |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4                                                | true      |                                                                                                          |
| //vda1cs4850/users/somefile.d.ts                                                                         |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/users/username/somefile.d.ts                                                                |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                          |
| //vda1cs4850/user/somefile.d.ts                                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/user/username/somefile.d.ts                                                                 |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                          |
| //vda1cs4850/usr/somefile.d.ts                                                                           |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/usr/username/somefile.d.ts                                                                  |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                          |
| //vda1cs4850/home/somefile.d.ts                                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/home/username/somefile.d.ts                                                                 |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/somefile.d.ts                                                                    |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/somefile.d.ts                                                       | //vda1cs4850/workspaces/folderAtRoot                                                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | //vda1cs4850/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                          |

## RootDirForResolution: //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive | Location if not symlink                                                                                  |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/somefile.d.ts                                                                               |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/somefile.d.ts                                                                  |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | true      |                                                                                                          |
| //vda1cs4850/users/somefile.d.ts                                                                         |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/users/username/somefile.d.ts                                                                |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                          |
| //vda1cs4850/user/somefile.d.ts                                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/user/username/somefile.d.ts                                                                 |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                          |
| //vda1cs4850/usr/somefile.d.ts                                                                           |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/usr/username/somefile.d.ts                                                                  |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                          |
| //vda1cs4850/home/somefile.d.ts                                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/home/username/somefile.d.ts                                                                 |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/somefile.d.ts                                                                    |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/somefile.d.ts                                                       | //vda1cs4850/workspaces/folderAtRoot                                                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | //vda1cs4850/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                          |

## RootDirForResolution: //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive | Location if not symlink                                                                                  |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/somefile.d.ts                                                                               |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/somefile.d.ts                                                                  |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                          |
| //vda1cs4850/users/somefile.d.ts                                                                         |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/users/username/somefile.d.ts                                                                |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                          |
| //vda1cs4850/user/somefile.d.ts                                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/user/username/somefile.d.ts                                                                 |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                          |
| //vda1cs4850/usr/somefile.d.ts                                                                           |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/usr/username/somefile.d.ts                                                                  |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                          |
| //vda1cs4850/home/somefile.d.ts                                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/home/username/somefile.d.ts                                                                 |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/somefile.d.ts                                                                    |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/somefile.d.ts                                                       | //vda1cs4850/workspaces/folderAtRoot                                                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | //vda1cs4850/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                          |

## RootDirForResolution: //vda1cs4850/users

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive | Location if not symlink                                                                                  |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/somefile.d.ts                                                                               |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/somefile.d.ts                                                                  |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                          |
| //vda1cs4850/users/somefile.d.ts                                                                         |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/users/username/somefile.d.ts                                                                |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                          |
| //vda1cs4850/user/somefile.d.ts                                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/user/username/somefile.d.ts                                                                 |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                          |
| //vda1cs4850/usr/somefile.d.ts                                                                           |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/usr/username/somefile.d.ts                                                                  |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                          |
| //vda1cs4850/home/somefile.d.ts                                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/home/username/somefile.d.ts                                                                 |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/somefile.d.ts                                                                    |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/somefile.d.ts                                                       | //vda1cs4850/workspaces/folderAtRoot                                                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | //vda1cs4850/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                          |

## RootDirForResolution: //vda1cs4850/users/username

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive | Location if not symlink                                                                                  |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/somefile.d.ts                                                                               |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/somefile.d.ts                                                                  |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                          |
| //vda1cs4850/users/somefile.d.ts                                                                         |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/users/username/somefile.d.ts                                                                |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                          |
| //vda1cs4850/user/somefile.d.ts                                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/user/username/somefile.d.ts                                                                 |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                          |
| //vda1cs4850/usr/somefile.d.ts                                                                           |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/usr/username/somefile.d.ts                                                                  |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                          |
| //vda1cs4850/home/somefile.d.ts                                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/home/username/somefile.d.ts                                                                 |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/somefile.d.ts                                                                    |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/somefile.d.ts                                                       | //vda1cs4850/workspaces/folderAtRoot                                                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | //vda1cs4850/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                          |

## RootDirForResolution: //vda1cs4850/users/username/folderAtRoot

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive | Location if not symlink                                                                                  |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/somefile.d.ts                                                                               |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/somefile.d.ts                                                                  |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                          |
| //vda1cs4850/users/somefile.d.ts                                                                         |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/users/username/somefile.d.ts                                                                |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                          |
| //vda1cs4850/user/somefile.d.ts                                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/user/username/somefile.d.ts                                                                 |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                          |
| //vda1cs4850/usr/somefile.d.ts                                                                           |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/usr/username/somefile.d.ts                                                                  |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                          |
| //vda1cs4850/home/somefile.d.ts                                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/home/username/somefile.d.ts                                                                 |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/somefile.d.ts                                                                    |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/somefile.d.ts                                                       | //vda1cs4850/workspaces/folderAtRoot                                                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | //vda1cs4850/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                          |

## RootDirForResolution: //vda1cs4850/users/username/folderAtRoot/folder1

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive | Location if not symlink                                                                                  |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/somefile.d.ts                                                                               |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/somefile.d.ts                                                                  |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                          |
| //vda1cs4850/users/somefile.d.ts                                                                         |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/users/username/somefile.d.ts                                                                |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2                                                 | true      |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2                                                 | true      |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2                                                 | true      |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2                                                 | true      |                                                                                                          |
| //vda1cs4850/user/somefile.d.ts                                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/user/username/somefile.d.ts                                                                 |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                          |
| //vda1cs4850/usr/somefile.d.ts                                                                           |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/usr/username/somefile.d.ts                                                                  |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                          |
| //vda1cs4850/home/somefile.d.ts                                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/home/username/somefile.d.ts                                                                 |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/somefile.d.ts                                                                    |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/somefile.d.ts                                                       | //vda1cs4850/workspaces/folderAtRoot                                                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | //vda1cs4850/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                          |

## RootDirForResolution: //vda1cs4850/users/username/folderAtRoot/folder1/folder2

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive | Location if not symlink                                                                                  |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/somefile.d.ts                                                                               |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/somefile.d.ts                                                                  |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                          |
| //vda1cs4850/users/somefile.d.ts                                                                         |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/users/username/somefile.d.ts                                                                |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3                                         | true      |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3                                         | true      |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3                                         | true      |                                                                                                          |
| //vda1cs4850/user/somefile.d.ts                                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/user/username/somefile.d.ts                                                                 |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                          |
| //vda1cs4850/usr/somefile.d.ts                                                                           |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/usr/username/somefile.d.ts                                                                  |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                          |
| //vda1cs4850/home/somefile.d.ts                                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/home/username/somefile.d.ts                                                                 |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/somefile.d.ts                                                                    |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/somefile.d.ts                                                       | //vda1cs4850/workspaces/folderAtRoot                                                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | //vda1cs4850/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                          |

## RootDirForResolution: //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive | Location if not symlink                                                                                  |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/somefile.d.ts                                                                               |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/somefile.d.ts                                                                  |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                          |
| //vda1cs4850/users/somefile.d.ts                                                                         |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/users/username/somefile.d.ts                                                                |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | true      |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | true      |                                                                                                          |
| //vda1cs4850/user/somefile.d.ts                                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/user/username/somefile.d.ts                                                                 |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                          |
| //vda1cs4850/usr/somefile.d.ts                                                                           |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/usr/username/somefile.d.ts                                                                  |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                          |
| //vda1cs4850/home/somefile.d.ts                                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/home/username/somefile.d.ts                                                                 |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/somefile.d.ts                                                                    |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/somefile.d.ts                                                       | //vda1cs4850/workspaces/folderAtRoot                                                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | //vda1cs4850/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                          |

## RootDirForResolution: //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive | Location if not symlink                                                                                  |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/somefile.d.ts                                                                               |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/somefile.d.ts                                                                  |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                          |
| //vda1cs4850/users/somefile.d.ts                                                                         |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/users/username/somefile.d.ts                                                                |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | true      |                                                                                                          |
| //vda1cs4850/user/somefile.d.ts                                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/user/username/somefile.d.ts                                                                 |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                          |
| //vda1cs4850/usr/somefile.d.ts                                                                           |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/usr/username/somefile.d.ts                                                                  |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                          |
| //vda1cs4850/home/somefile.d.ts                                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/home/username/somefile.d.ts                                                                 |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/somefile.d.ts                                                                    |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/somefile.d.ts                                                       | //vda1cs4850/workspaces/folderAtRoot                                                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | //vda1cs4850/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                          |

## RootDirForResolution: //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive | Location if not symlink                                                                                  |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/somefile.d.ts                                                                               |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/somefile.d.ts                                                                  |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                          |
| //vda1cs4850/users/somefile.d.ts                                                                         |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/users/username/somefile.d.ts                                                                |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                          |
| //vda1cs4850/user/somefile.d.ts                                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/user/username/somefile.d.ts                                                                 |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                          |
| //vda1cs4850/usr/somefile.d.ts                                                                           |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/usr/username/somefile.d.ts                                                                  |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                          |
| //vda1cs4850/home/somefile.d.ts                                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/home/username/somefile.d.ts                                                                 |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/somefile.d.ts                                                                    |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/somefile.d.ts                                                       | //vda1cs4850/workspaces/folderAtRoot                                                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | //vda1cs4850/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                          |

## RootDirForResolution: //vda1cs4850/user

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive | Location if not symlink                                                                                  |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/somefile.d.ts                                                                               |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/somefile.d.ts                                                                  |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                          |
| //vda1cs4850/users/somefile.d.ts                                                                         |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/users/username/somefile.d.ts                                                                |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                          |
| //vda1cs4850/user/somefile.d.ts                                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/user/username/somefile.d.ts                                                                 |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                          |
| //vda1cs4850/usr/somefile.d.ts                                                                           |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/usr/username/somefile.d.ts                                                                  |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                          |
| //vda1cs4850/home/somefile.d.ts                                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/home/username/somefile.d.ts                                                                 |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/somefile.d.ts                                                                    |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/somefile.d.ts                                                       | //vda1cs4850/workspaces/folderAtRoot                                                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | //vda1cs4850/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                          |

## RootDirForResolution: //vda1cs4850/user/username

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive | Location if not symlink                                                                                  |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/somefile.d.ts                                                                               |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/somefile.d.ts                                                                  |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                          |
| //vda1cs4850/users/somefile.d.ts                                                                         |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/users/username/somefile.d.ts                                                                |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                          |
| //vda1cs4850/user/somefile.d.ts                                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/user/username/somefile.d.ts                                                                 |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                          |
| //vda1cs4850/usr/somefile.d.ts                                                                           |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/usr/username/somefile.d.ts                                                                  |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                          |
| //vda1cs4850/home/somefile.d.ts                                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/home/username/somefile.d.ts                                                                 |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/somefile.d.ts                                                                    |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/somefile.d.ts                                                       | //vda1cs4850/workspaces/folderAtRoot                                                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | //vda1cs4850/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                          |

## RootDirForResolution: //vda1cs4850/user/username/folderAtRoot

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive | Location if not symlink                                                                                  |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/somefile.d.ts                                                                               |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/somefile.d.ts                                                                  |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                          |
| //vda1cs4850/users/somefile.d.ts                                                                         |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/users/username/somefile.d.ts                                                                |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                          |
| //vda1cs4850/user/somefile.d.ts                                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/user/username/somefile.d.ts                                                                 |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                          |
| //vda1cs4850/usr/somefile.d.ts                                                                           |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/usr/username/somefile.d.ts                                                                  |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                          |
| //vda1cs4850/home/somefile.d.ts                                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/home/username/somefile.d.ts                                                                 |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/somefile.d.ts                                                                    |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/somefile.d.ts                                                       | //vda1cs4850/workspaces/folderAtRoot                                                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | //vda1cs4850/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                          |

## RootDirForResolution: //vda1cs4850/user/username/folderAtRoot/folder1

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive | Location if not symlink                                                                                  |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/somefile.d.ts                                                                               |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/somefile.d.ts                                                                  |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                          |
| //vda1cs4850/users/somefile.d.ts                                                                         |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/users/username/somefile.d.ts                                                                |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                          |
| //vda1cs4850/user/somefile.d.ts                                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/user/username/somefile.d.ts                                                                 |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2                                                  | true      |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2                                                  | true      |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2                                                  | true      |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2                                                  | true      |                                                                                                          |
| //vda1cs4850/usr/somefile.d.ts                                                                           |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/usr/username/somefile.d.ts                                                                  |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                          |
| //vda1cs4850/home/somefile.d.ts                                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/home/username/somefile.d.ts                                                                 |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/somefile.d.ts                                                                    |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/somefile.d.ts                                                       | //vda1cs4850/workspaces/folderAtRoot                                                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | //vda1cs4850/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                          |

## RootDirForResolution: //vda1cs4850/user/username/folderAtRoot/folder1/folder2

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive | Location if not symlink                                                                                  |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/somefile.d.ts                                                                               |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/somefile.d.ts                                                                  |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                          |
| //vda1cs4850/users/somefile.d.ts                                                                         |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/users/username/somefile.d.ts                                                                |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                          |
| //vda1cs4850/user/somefile.d.ts                                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/user/username/somefile.d.ts                                                                 |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3                                          | true      |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3                                          | true      |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3                                          | true      |                                                                                                          |
| //vda1cs4850/usr/somefile.d.ts                                                                           |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/usr/username/somefile.d.ts                                                                  |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                          |
| //vda1cs4850/home/somefile.d.ts                                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/home/username/somefile.d.ts                                                                 |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/somefile.d.ts                                                                    |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/somefile.d.ts                                                       | //vda1cs4850/workspaces/folderAtRoot                                                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | //vda1cs4850/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                          |

## RootDirForResolution: //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive | Location if not symlink                                                                                  |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/somefile.d.ts                                                                               |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/somefile.d.ts                                                                  |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                          |
| //vda1cs4850/users/somefile.d.ts                                                                         |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/users/username/somefile.d.ts                                                                |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                          |
| //vda1cs4850/user/somefile.d.ts                                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/user/username/somefile.d.ts                                                                 |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | true      |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | true      |                                                                                                          |
| //vda1cs4850/usr/somefile.d.ts                                                                           |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/usr/username/somefile.d.ts                                                                  |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                          |
| //vda1cs4850/home/somefile.d.ts                                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/home/username/somefile.d.ts                                                                 |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/somefile.d.ts                                                                    |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/somefile.d.ts                                                       | //vda1cs4850/workspaces/folderAtRoot                                                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | //vda1cs4850/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                          |

## RootDirForResolution: //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive | Location if not symlink                                                                                  |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/somefile.d.ts                                                                               |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/somefile.d.ts                                                                  |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                          |
| //vda1cs4850/users/somefile.d.ts                                                                         |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/users/username/somefile.d.ts                                                                |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                          |
| //vda1cs4850/user/somefile.d.ts                                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/user/username/somefile.d.ts                                                                 |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | true      |                                                                                                          |
| //vda1cs4850/usr/somefile.d.ts                                                                           |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/usr/username/somefile.d.ts                                                                  |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                          |
| //vda1cs4850/home/somefile.d.ts                                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/home/username/somefile.d.ts                                                                 |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/somefile.d.ts                                                                    |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/somefile.d.ts                                                       | //vda1cs4850/workspaces/folderAtRoot                                                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | //vda1cs4850/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                          |

## RootDirForResolution: //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive | Location if not symlink                                                                                  |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/somefile.d.ts                                                                               |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/somefile.d.ts                                                                  |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                          |
| //vda1cs4850/users/somefile.d.ts                                                                         |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/users/username/somefile.d.ts                                                                |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                          |
| //vda1cs4850/user/somefile.d.ts                                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/user/username/somefile.d.ts                                                                 |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                          |
| //vda1cs4850/usr/somefile.d.ts                                                                           |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/usr/username/somefile.d.ts                                                                  |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                          |
| //vda1cs4850/home/somefile.d.ts                                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/home/username/somefile.d.ts                                                                 |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/somefile.d.ts                                                                    |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/somefile.d.ts                                                       | //vda1cs4850/workspaces/folderAtRoot                                                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | //vda1cs4850/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                          |

## RootDirForResolution: //vda1cs4850/usr

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive | Location if not symlink                                                                                  |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/somefile.d.ts                                                                               |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/somefile.d.ts                                                                  |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                          |
| //vda1cs4850/users/somefile.d.ts                                                                         |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/users/username/somefile.d.ts                                                                |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                          |
| //vda1cs4850/user/somefile.d.ts                                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/user/username/somefile.d.ts                                                                 |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                          |
| //vda1cs4850/usr/somefile.d.ts                                                                           |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/usr/username/somefile.d.ts                                                                  |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                          |
| //vda1cs4850/home/somefile.d.ts                                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/home/username/somefile.d.ts                                                                 |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/somefile.d.ts                                                                    |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/somefile.d.ts                                                       | //vda1cs4850/workspaces/folderAtRoot                                                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | //vda1cs4850/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                          |

## RootDirForResolution: //vda1cs4850/usr/username

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive | Location if not symlink                                                                                  |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/somefile.d.ts                                                                               |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/somefile.d.ts                                                                  |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                          |
| //vda1cs4850/users/somefile.d.ts                                                                         |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/users/username/somefile.d.ts                                                                |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                          |
| //vda1cs4850/user/somefile.d.ts                                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/user/username/somefile.d.ts                                                                 |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                          |
| //vda1cs4850/usr/somefile.d.ts                                                                           |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/usr/username/somefile.d.ts                                                                  |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                          |
| //vda1cs4850/home/somefile.d.ts                                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/home/username/somefile.d.ts                                                                 |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/somefile.d.ts                                                                    |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/somefile.d.ts                                                       | //vda1cs4850/workspaces/folderAtRoot                                                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | //vda1cs4850/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                          |

## RootDirForResolution: //vda1cs4850/usr/username/folderAtRoot

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive | Location if not symlink                                                                                  |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/somefile.d.ts                                                                               |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/somefile.d.ts                                                                  |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                          |
| //vda1cs4850/users/somefile.d.ts                                                                         |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/users/username/somefile.d.ts                                                                |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                          |
| //vda1cs4850/user/somefile.d.ts                                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/user/username/somefile.d.ts                                                                 |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                          |
| //vda1cs4850/usr/somefile.d.ts                                                                           |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/usr/username/somefile.d.ts                                                                  |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                          |
| //vda1cs4850/home/somefile.d.ts                                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/home/username/somefile.d.ts                                                                 |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/somefile.d.ts                                                                    |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/somefile.d.ts                                                       | //vda1cs4850/workspaces/folderAtRoot                                                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | //vda1cs4850/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                          |

## RootDirForResolution: //vda1cs4850/usr/username/folderAtRoot/folder1

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive | Location if not symlink                                                                                  |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/somefile.d.ts                                                                               |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/somefile.d.ts                                                                  |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                          |
| //vda1cs4850/users/somefile.d.ts                                                                         |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/users/username/somefile.d.ts                                                                |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                          |
| //vda1cs4850/user/somefile.d.ts                                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/user/username/somefile.d.ts                                                                 |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                          |
| //vda1cs4850/usr/somefile.d.ts                                                                           |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/usr/username/somefile.d.ts                                                                  |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2                                                   | true      |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2                                                   | true      |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2                                                   | true      |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2                                                   | true      |                                                                                                          |
| //vda1cs4850/home/somefile.d.ts                                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/home/username/somefile.d.ts                                                                 |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/somefile.d.ts                                                                    |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/somefile.d.ts                                                       | //vda1cs4850/workspaces/folderAtRoot                                                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | //vda1cs4850/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                          |

## RootDirForResolution: //vda1cs4850/usr/username/folderAtRoot/folder1/folder2

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive | Location if not symlink                                                                                  |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/somefile.d.ts                                                                               |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/somefile.d.ts                                                                  |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                          |
| //vda1cs4850/users/somefile.d.ts                                                                         |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/users/username/somefile.d.ts                                                                |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                          |
| //vda1cs4850/user/somefile.d.ts                                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/user/username/somefile.d.ts                                                                 |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                          |
| //vda1cs4850/usr/somefile.d.ts                                                                           |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/usr/username/somefile.d.ts                                                                  |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3                                           | true      |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3                                           | true      |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3                                           | true      |                                                                                                          |
| //vda1cs4850/home/somefile.d.ts                                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/home/username/somefile.d.ts                                                                 |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/somefile.d.ts                                                                    |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/somefile.d.ts                                                       | //vda1cs4850/workspaces/folderAtRoot                                                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | //vda1cs4850/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                          |

## RootDirForResolution: //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive | Location if not symlink                                                                                  |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/somefile.d.ts                                                                               |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/somefile.d.ts                                                                  |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                          |
| //vda1cs4850/users/somefile.d.ts                                                                         |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/users/username/somefile.d.ts                                                                |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                          |
| //vda1cs4850/user/somefile.d.ts                                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/user/username/somefile.d.ts                                                                 |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                          |
| //vda1cs4850/usr/somefile.d.ts                                                                           |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/usr/username/somefile.d.ts                                                                  |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | true      |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | true      |                                                                                                          |
| //vda1cs4850/home/somefile.d.ts                                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/home/username/somefile.d.ts                                                                 |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/somefile.d.ts                                                                    |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/somefile.d.ts                                                       | //vda1cs4850/workspaces/folderAtRoot                                                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | //vda1cs4850/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                          |

## RootDirForResolution: //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive | Location if not symlink                                                                                  |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/somefile.d.ts                                                                               |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/somefile.d.ts                                                                  |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                          |
| //vda1cs4850/users/somefile.d.ts                                                                         |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/users/username/somefile.d.ts                                                                |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                          |
| //vda1cs4850/user/somefile.d.ts                                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/user/username/somefile.d.ts                                                                 |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                          |
| //vda1cs4850/usr/somefile.d.ts                                                                           |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/usr/username/somefile.d.ts                                                                  |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | true      |                                                                                                          |
| //vda1cs4850/home/somefile.d.ts                                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/home/username/somefile.d.ts                                                                 |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/somefile.d.ts                                                                    |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/somefile.d.ts                                                       | //vda1cs4850/workspaces/folderAtRoot                                                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | //vda1cs4850/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                          |

## RootDirForResolution: //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive | Location if not symlink                                                                                  |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/somefile.d.ts                                                                               |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/somefile.d.ts                                                                  |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                          |
| //vda1cs4850/users/somefile.d.ts                                                                         |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/users/username/somefile.d.ts                                                                |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                          |
| //vda1cs4850/user/somefile.d.ts                                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/user/username/somefile.d.ts                                                                 |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                          |
| //vda1cs4850/usr/somefile.d.ts                                                                           |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/usr/username/somefile.d.ts                                                                  |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                          |
| //vda1cs4850/home/somefile.d.ts                                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/home/username/somefile.d.ts                                                                 |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/somefile.d.ts                                                                    |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/somefile.d.ts                                                       | //vda1cs4850/workspaces/folderAtRoot                                                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | //vda1cs4850/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                          |

## RootDirForResolution: //vda1cs4850/home

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive | Location if not symlink                                                                                  |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/somefile.d.ts                                                                               |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/somefile.d.ts                                                                  |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                          |
| //vda1cs4850/users/somefile.d.ts                                                                         |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/users/username/somefile.d.ts                                                                |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                          |
| //vda1cs4850/user/somefile.d.ts                                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/user/username/somefile.d.ts                                                                 |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                          |
| //vda1cs4850/usr/somefile.d.ts                                                                           |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/usr/username/somefile.d.ts                                                                  |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                          |
| //vda1cs4850/home/somefile.d.ts                                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/home/username/somefile.d.ts                                                                 |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/somefile.d.ts                                                                    |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/somefile.d.ts                                                       | //vda1cs4850/workspaces/folderAtRoot                                                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | //vda1cs4850/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                          |

## RootDirForResolution: //vda1cs4850/home/username

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive | Location if not symlink                                                                                  |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/somefile.d.ts                                                                               |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/somefile.d.ts                                                                  |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                          |
| //vda1cs4850/users/somefile.d.ts                                                                         |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/users/username/somefile.d.ts                                                                |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                          |
| //vda1cs4850/user/somefile.d.ts                                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/user/username/somefile.d.ts                                                                 |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                          |
| //vda1cs4850/usr/somefile.d.ts                                                                           |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/usr/username/somefile.d.ts                                                                  |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                          |
| //vda1cs4850/home/somefile.d.ts                                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/home/username/somefile.d.ts                                                                 |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/somefile.d.ts                                                                    |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/somefile.d.ts                                                       | //vda1cs4850/workspaces/folderAtRoot                                                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | //vda1cs4850/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                          |

## RootDirForResolution: //vda1cs4850/home/username/folderAtRoot

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive | Location if not symlink                                                                                  |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/somefile.d.ts                                                                               |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/somefile.d.ts                                                                  |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                          |
| //vda1cs4850/users/somefile.d.ts                                                                         |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/users/username/somefile.d.ts                                                                |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                          |
| //vda1cs4850/user/somefile.d.ts                                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/user/username/somefile.d.ts                                                                 |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                          |
| //vda1cs4850/usr/somefile.d.ts                                                                           |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/usr/username/somefile.d.ts                                                                  |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                          |
| //vda1cs4850/home/somefile.d.ts                                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/home/username/somefile.d.ts                                                                 |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/somefile.d.ts                                                                    |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/somefile.d.ts                                                       | //vda1cs4850/workspaces/folderAtRoot                                                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | //vda1cs4850/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                          |

## RootDirForResolution: //vda1cs4850/home/username/folderAtRoot/folder1

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive | Location if not symlink                                                                                  |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/somefile.d.ts                                                                               |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/somefile.d.ts                                                                  |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                          |
| //vda1cs4850/users/somefile.d.ts                                                                         |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/users/username/somefile.d.ts                                                                |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                          |
| //vda1cs4850/user/somefile.d.ts                                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/user/username/somefile.d.ts                                                                 |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                          |
| //vda1cs4850/usr/somefile.d.ts                                                                           |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/usr/username/somefile.d.ts                                                                  |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                          |
| //vda1cs4850/home/somefile.d.ts                                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/home/username/somefile.d.ts                                                                 |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2                                                  | true      |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2                                                  | true      |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2                                                  | true      |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2                                                  | true      |                                                                                                          |
| //vda1cs4850/workspaces/somefile.d.ts                                                                    |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/somefile.d.ts                                                       | //vda1cs4850/workspaces/folderAtRoot                                                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | //vda1cs4850/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                          |

## RootDirForResolution: //vda1cs4850/home/username/folderAtRoot/folder1/folder2

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive | Location if not symlink                                                                                  |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/somefile.d.ts                                                                               |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/somefile.d.ts                                                                  |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                          |
| //vda1cs4850/users/somefile.d.ts                                                                         |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/users/username/somefile.d.ts                                                                |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                          |
| //vda1cs4850/user/somefile.d.ts                                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/user/username/somefile.d.ts                                                                 |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                          |
| //vda1cs4850/usr/somefile.d.ts                                                                           |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/usr/username/somefile.d.ts                                                                  |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                          |
| //vda1cs4850/home/somefile.d.ts                                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/home/username/somefile.d.ts                                                                 |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3                                          | true      |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3                                          | true      |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3                                          | true      |                                                                                                          |
| //vda1cs4850/workspaces/somefile.d.ts                                                                    |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/somefile.d.ts                                                       | //vda1cs4850/workspaces/folderAtRoot                                                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | //vda1cs4850/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                          |

## RootDirForResolution: //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive | Location if not symlink                                                                                  |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/somefile.d.ts                                                                               |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/somefile.d.ts                                                                  |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                          |
| //vda1cs4850/users/somefile.d.ts                                                                         |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/users/username/somefile.d.ts                                                                |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                          |
| //vda1cs4850/user/somefile.d.ts                                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/user/username/somefile.d.ts                                                                 |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                          |
| //vda1cs4850/usr/somefile.d.ts                                                                           |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/usr/username/somefile.d.ts                                                                  |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                          |
| //vda1cs4850/home/somefile.d.ts                                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/home/username/somefile.d.ts                                                                 |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | true      |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | true      |                                                                                                          |
| //vda1cs4850/workspaces/somefile.d.ts                                                                    |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/somefile.d.ts                                                       | //vda1cs4850/workspaces/folderAtRoot                                                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | //vda1cs4850/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                          |

## RootDirForResolution: //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive | Location if not symlink                                                                                  |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/somefile.d.ts                                                                               |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/somefile.d.ts                                                                  |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                          |
| //vda1cs4850/users/somefile.d.ts                                                                         |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/users/username/somefile.d.ts                                                                |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                          |
| //vda1cs4850/user/somefile.d.ts                                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/user/username/somefile.d.ts                                                                 |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                          |
| //vda1cs4850/usr/somefile.d.ts                                                                           |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/usr/username/somefile.d.ts                                                                  |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                          |
| //vda1cs4850/home/somefile.d.ts                                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/home/username/somefile.d.ts                                                                 |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | true      |                                                                                                          |
| //vda1cs4850/workspaces/somefile.d.ts                                                                    |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/somefile.d.ts                                                       | //vda1cs4850/workspaces/folderAtRoot                                                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | //vda1cs4850/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                          |

## RootDirForResolution: //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive | Location if not symlink                                                                                  |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/somefile.d.ts                                                                               |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/somefile.d.ts                                                                  |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                          |
| //vda1cs4850/users/somefile.d.ts                                                                         |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/users/username/somefile.d.ts                                                                |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                          |
| //vda1cs4850/user/somefile.d.ts                                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/user/username/somefile.d.ts                                                                 |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                          |
| //vda1cs4850/usr/somefile.d.ts                                                                           |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/usr/username/somefile.d.ts                                                                  |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                          |
| //vda1cs4850/home/somefile.d.ts                                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/home/username/somefile.d.ts                                                                 |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/somefile.d.ts                                                                    |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/somefile.d.ts                                                       | //vda1cs4850/workspaces/folderAtRoot                                                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | //vda1cs4850/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                          |

## RootDirForResolution: //vda1cs4850/workspaces

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive | Location if not symlink                                                                                  |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/somefile.d.ts                                                                               |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/somefile.d.ts                                                                  |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                          |
| //vda1cs4850/users/somefile.d.ts                                                                         |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/users/username/somefile.d.ts                                                                |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                          |
| //vda1cs4850/user/somefile.d.ts                                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/user/username/somefile.d.ts                                                                 |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                          |
| //vda1cs4850/usr/somefile.d.ts                                                                           |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/usr/username/somefile.d.ts                                                                  |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                          |
| //vda1cs4850/home/somefile.d.ts                                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/home/username/somefile.d.ts                                                                 |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/somefile.d.ts                                                                    |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/somefile.d.ts                                                       | //vda1cs4850/workspaces/folderAtRoot                                                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | //vda1cs4850/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                          |

## RootDirForResolution: //vda1cs4850/workspaces/folderAtRoot

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive | Location if not symlink                                                                                  |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/somefile.d.ts                                                                               |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/somefile.d.ts                                                                  |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                          |
| //vda1cs4850/users/somefile.d.ts                                                                         |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/users/username/somefile.d.ts                                                                |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                          |
| //vda1cs4850/user/somefile.d.ts                                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/user/username/somefile.d.ts                                                                 |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                          |
| //vda1cs4850/usr/somefile.d.ts                                                                           |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/usr/username/somefile.d.ts                                                                  |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                          |
| //vda1cs4850/home/somefile.d.ts                                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/home/username/somefile.d.ts                                                                 |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/somefile.d.ts                                                                    |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/somefile.d.ts                                                       | //vda1cs4850/workspaces/folderAtRoot                                                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | //vda1cs4850/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                          |

## RootDirForResolution: //vda1cs4850/workspaces/folderAtRoot/folder1

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive | Location if not symlink                                                                                  |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/somefile.d.ts                                                                               |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/somefile.d.ts                                                                  |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                          |
| //vda1cs4850/users/somefile.d.ts                                                                         |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/users/username/somefile.d.ts                                                                |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                          |
| //vda1cs4850/user/somefile.d.ts                                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/user/username/somefile.d.ts                                                                 |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                          |
| //vda1cs4850/usr/somefile.d.ts                                                                           |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/usr/username/somefile.d.ts                                                                  |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                          |
| //vda1cs4850/home/somefile.d.ts                                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/home/username/somefile.d.ts                                                                 |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/somefile.d.ts                                                                    |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/somefile.d.ts                                                       | //vda1cs4850/workspaces/folderAtRoot                                                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | //vda1cs4850/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2                                                     | true      |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2                                                     | true      |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2                                                     | true      |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2                                                     | true      |                                                                                                          |

## RootDirForResolution: //vda1cs4850/workspaces/folderAtRoot/folder1/folder2

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive | Location if not symlink                                                                                  |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/somefile.d.ts                                                                               |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/somefile.d.ts                                                                  |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                          |
| //vda1cs4850/users/somefile.d.ts                                                                         |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/users/username/somefile.d.ts                                                                |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                          |
| //vda1cs4850/user/somefile.d.ts                                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/user/username/somefile.d.ts                                                                 |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                          |
| //vda1cs4850/usr/somefile.d.ts                                                                           |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/usr/username/somefile.d.ts                                                                  |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                          |
| //vda1cs4850/home/somefile.d.ts                                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/home/username/somefile.d.ts                                                                 |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/somefile.d.ts                                                                    |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/somefile.d.ts                                                       | //vda1cs4850/workspaces/folderAtRoot                                                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | //vda1cs4850/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3                                             | true      |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3                                             | true      |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3                                             | true      |                                                                                                          |

## RootDirForResolution: //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive | Location if not symlink                                                                                  |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/somefile.d.ts                                                                               |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/somefile.d.ts                                                                  |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                          |
| //vda1cs4850/users/somefile.d.ts                                                                         |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/users/username/somefile.d.ts                                                                |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                          |
| //vda1cs4850/user/somefile.d.ts                                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/user/username/somefile.d.ts                                                                 |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                          |
| //vda1cs4850/usr/somefile.d.ts                                                                           |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/usr/username/somefile.d.ts                                                                  |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                          |
| //vda1cs4850/home/somefile.d.ts                                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/home/username/somefile.d.ts                                                                 |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/somefile.d.ts                                                                    |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/somefile.d.ts                                                       | //vda1cs4850/workspaces/folderAtRoot                                                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | //vda1cs4850/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | true      |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | true      |                                                                                                          |

## RootDirForResolution: //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive | Location if not symlink                                                                                  |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/somefile.d.ts                                                                               |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/somefile.d.ts                                                                  |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                          |
| //vda1cs4850/users/somefile.d.ts                                                                         |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/users/username/somefile.d.ts                                                                |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                          |
| //vda1cs4850/user/somefile.d.ts                                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/user/username/somefile.d.ts                                                                 |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                          |
| //vda1cs4850/usr/somefile.d.ts                                                                           |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/usr/username/somefile.d.ts                                                                  |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                          |
| //vda1cs4850/home/somefile.d.ts                                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/home/username/somefile.d.ts                                                                 |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/somefile.d.ts                                                                    |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/somefile.d.ts                                                       | //vda1cs4850/workspaces/folderAtRoot                                                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | //vda1cs4850/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | true      |                                                                                                          |

## RootDirForResolution: //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive | Location if not symlink                                                                                  |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/somefile.d.ts                                                                               |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/somefile.d.ts                                                                  |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                          |
| //vda1cs4850/users/somefile.d.ts                                                                         |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/users/username/somefile.d.ts                                                                |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                          |
| //vda1cs4850/user/somefile.d.ts                                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/user/username/somefile.d.ts                                                                 |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                          |
| //vda1cs4850/usr/somefile.d.ts                                                                           |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/usr/username/somefile.d.ts                                                                  |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                          |
| //vda1cs4850/home/somefile.d.ts                                                                          |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/home/username/somefile.d.ts                                                                 |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/somefile.d.ts                                                                    |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/somefile.d.ts                                                       | //vda1cs4850/workspaces/folderAtRoot                                                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | //vda1cs4850/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                          |

