# getDirectoryToWatchFailedLookupLocationInfileNonRecursive

Determines whether to watch given failed lookup location (file that didnt exist) when resolving module.
It also determines the directory to watch and whether to watch it recursively or not.

## Testing for UncDos root: //vda1cs4850/c$

## RootDirForResolution: //vda1cs4850/c$

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive | Location if not symlink                                                                                     |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- | ----------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/somefile.d.ts                                                                               |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/somefile.d.ts                                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/somefile.d.ts                                                          | //vda1cs4850/c$/folderAtRoot/folder1                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                             |
| //vda1cs4850/c$/users/somefile.d.ts                                                                         |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/users/username/somefile.d.ts                                                                |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                             |
| //vda1cs4850/c$/user/somefile.d.ts                                                                          | //vda1cs4850/c$/user                                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/somefile.d.ts                                                                 | //vda1cs4850/c$/user/username                                                                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/user/username/folderAtRoot                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                             |
| //vda1cs4850/c$/usr/somefile.d.ts                                                                           | //vda1cs4850/c$/usr                                                                                         | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/somefile.d.ts                                                                  | //vda1cs4850/c$/usr/username                                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/c$/usr/username/folderAtRoot                                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                             |
| //vda1cs4850/c$/home/somefile.d.ts                                                                          | //vda1cs4850/c$/home                                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/somefile.d.ts                                                                 | //vda1cs4850/c$/home/username                                                                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/home/username/folderAtRoot                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/somefile.d.ts                                                                    | //vda1cs4850/c$/workspaces                                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/somefile.d.ts                                                       | //vda1cs4850/c$/workspaces/folderAtRoot                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                             |

## RootDirForResolution: //vda1cs4850/c$/folderAtRoot

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive | Location if not symlink                                                                                     |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- | ----------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/somefile.d.ts                                                                               |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/somefile.d.ts                                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/somefile.d.ts                                                          | //vda1cs4850/c$/folderAtRoot/folder1                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                             |
| //vda1cs4850/c$/users/somefile.d.ts                                                                         |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/users/username/somefile.d.ts                                                                |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                             |
| //vda1cs4850/c$/user/somefile.d.ts                                                                          | //vda1cs4850/c$/user                                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/somefile.d.ts                                                                 | //vda1cs4850/c$/user/username                                                                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/user/username/folderAtRoot                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                             |
| //vda1cs4850/c$/usr/somefile.d.ts                                                                           | //vda1cs4850/c$/usr                                                                                         | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/somefile.d.ts                                                                  | //vda1cs4850/c$/usr/username                                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/c$/usr/username/folderAtRoot                                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                             |
| //vda1cs4850/c$/home/somefile.d.ts                                                                          | //vda1cs4850/c$/home                                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/somefile.d.ts                                                                 | //vda1cs4850/c$/home/username                                                                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/home/username/folderAtRoot                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/somefile.d.ts                                                                    | //vda1cs4850/c$/workspaces                                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/somefile.d.ts                                                       | //vda1cs4850/c$/workspaces/folderAtRoot                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                             |

## RootDirForResolution: //vda1cs4850/c$/folderAtRoot/folder1

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive | Location if not symlink                                                                                     |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- | ----------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/somefile.d.ts                                                                               |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/somefile.d.ts                                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/somefile.d.ts                                                          | //vda1cs4850/c$/folderAtRoot/folder1                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2                                                                | true      |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2                                                                | true      |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2                                                                | true      |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2                                                                | true      |                                                                                                             |
| //vda1cs4850/c$/users/somefile.d.ts                                                                         |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/users/username/somefile.d.ts                                                                |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                             |
| //vda1cs4850/c$/user/somefile.d.ts                                                                          | //vda1cs4850/c$/user                                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/somefile.d.ts                                                                 | //vda1cs4850/c$/user/username                                                                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/user/username/folderAtRoot                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                             |
| //vda1cs4850/c$/usr/somefile.d.ts                                                                           | //vda1cs4850/c$/usr                                                                                         | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/somefile.d.ts                                                                  | //vda1cs4850/c$/usr/username                                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/c$/usr/username/folderAtRoot                                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                             |
| //vda1cs4850/c$/home/somefile.d.ts                                                                          | //vda1cs4850/c$/home                                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/somefile.d.ts                                                                 | //vda1cs4850/c$/home/username                                                                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/home/username/folderAtRoot                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/somefile.d.ts                                                                    | //vda1cs4850/c$/workspaces                                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/somefile.d.ts                                                       | //vda1cs4850/c$/workspaces/folderAtRoot                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                             |

## RootDirForResolution: //vda1cs4850/c$/folderAtRoot/folder1/folder2

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive | Location if not symlink                                                                                     |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- | ----------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/somefile.d.ts                                                                               |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/somefile.d.ts                                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/somefile.d.ts                                                          | //vda1cs4850/c$/folderAtRoot/folder1                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3                                                        | true      |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3                                                        | true      |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3                                                        | true      |                                                                                                             |
| //vda1cs4850/c$/users/somefile.d.ts                                                                         |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/users/username/somefile.d.ts                                                                |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                             |
| //vda1cs4850/c$/user/somefile.d.ts                                                                          | //vda1cs4850/c$/user                                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/somefile.d.ts                                                                 | //vda1cs4850/c$/user/username                                                                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/user/username/folderAtRoot                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                             |
| //vda1cs4850/c$/usr/somefile.d.ts                                                                           | //vda1cs4850/c$/usr                                                                                         | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/somefile.d.ts                                                                  | //vda1cs4850/c$/usr/username                                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/c$/usr/username/folderAtRoot                                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                             |
| //vda1cs4850/c$/home/somefile.d.ts                                                                          | //vda1cs4850/c$/home                                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/somefile.d.ts                                                                 | //vda1cs4850/c$/home/username                                                                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/home/username/folderAtRoot                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/somefile.d.ts                                                                    | //vda1cs4850/c$/workspaces                                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/somefile.d.ts                                                       | //vda1cs4850/c$/workspaces/folderAtRoot                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                             |

## RootDirForResolution: //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive | Location if not symlink                                                                                     |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- | ----------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/somefile.d.ts                                                                               |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/somefile.d.ts                                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/somefile.d.ts                                                          | //vda1cs4850/c$/folderAtRoot/folder1                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4                                                | true      |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4                                                | true      |                                                                                                             |
| //vda1cs4850/c$/users/somefile.d.ts                                                                         |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/users/username/somefile.d.ts                                                                |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                             |
| //vda1cs4850/c$/user/somefile.d.ts                                                                          | //vda1cs4850/c$/user                                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/somefile.d.ts                                                                 | //vda1cs4850/c$/user/username                                                                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/user/username/folderAtRoot                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                             |
| //vda1cs4850/c$/usr/somefile.d.ts                                                                           | //vda1cs4850/c$/usr                                                                                         | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/somefile.d.ts                                                                  | //vda1cs4850/c$/usr/username                                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/c$/usr/username/folderAtRoot                                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                             |
| //vda1cs4850/c$/home/somefile.d.ts                                                                          | //vda1cs4850/c$/home                                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/somefile.d.ts                                                                 | //vda1cs4850/c$/home/username                                                                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/home/username/folderAtRoot                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/somefile.d.ts                                                                    | //vda1cs4850/c$/workspaces                                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/somefile.d.ts                                                       | //vda1cs4850/c$/workspaces/folderAtRoot                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                             |

## RootDirForResolution: //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive | Location if not symlink                                                                                     |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- | ----------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/somefile.d.ts                                                                               |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/somefile.d.ts                                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/somefile.d.ts                                                          | //vda1cs4850/c$/folderAtRoot/folder1                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | true      |                                                                                                             |
| //vda1cs4850/c$/users/somefile.d.ts                                                                         |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/users/username/somefile.d.ts                                                                |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                             |
| //vda1cs4850/c$/user/somefile.d.ts                                                                          | //vda1cs4850/c$/user                                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/somefile.d.ts                                                                 | //vda1cs4850/c$/user/username                                                                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/user/username/folderAtRoot                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                             |
| //vda1cs4850/c$/usr/somefile.d.ts                                                                           | //vda1cs4850/c$/usr                                                                                         | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/somefile.d.ts                                                                  | //vda1cs4850/c$/usr/username                                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/c$/usr/username/folderAtRoot                                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                             |
| //vda1cs4850/c$/home/somefile.d.ts                                                                          | //vda1cs4850/c$/home                                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/somefile.d.ts                                                                 | //vda1cs4850/c$/home/username                                                                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/home/username/folderAtRoot                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/somefile.d.ts                                                                    | //vda1cs4850/c$/workspaces                                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/somefile.d.ts                                                       | //vda1cs4850/c$/workspaces/folderAtRoot                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                             |

## RootDirForResolution: //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive | Location if not symlink                                                                                     |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- | ----------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/somefile.d.ts                                                                               |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/somefile.d.ts                                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/somefile.d.ts                                                          | //vda1cs4850/c$/folderAtRoot/folder1                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                             |
| //vda1cs4850/c$/users/somefile.d.ts                                                                         |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/users/username/somefile.d.ts                                                                |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                             |
| //vda1cs4850/c$/user/somefile.d.ts                                                                          | //vda1cs4850/c$/user                                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/somefile.d.ts                                                                 | //vda1cs4850/c$/user/username                                                                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/user/username/folderAtRoot                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                             |
| //vda1cs4850/c$/usr/somefile.d.ts                                                                           | //vda1cs4850/c$/usr                                                                                         | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/somefile.d.ts                                                                  | //vda1cs4850/c$/usr/username                                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/c$/usr/username/folderAtRoot                                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                             |
| //vda1cs4850/c$/home/somefile.d.ts                                                                          | //vda1cs4850/c$/home                                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/somefile.d.ts                                                                 | //vda1cs4850/c$/home/username                                                                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/home/username/folderAtRoot                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/somefile.d.ts                                                                    | //vda1cs4850/c$/workspaces                                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/somefile.d.ts                                                       | //vda1cs4850/c$/workspaces/folderAtRoot                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                             |

## RootDirForResolution: //vda1cs4850/c$/users

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive | Location if not symlink                                                                                     |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- | ----------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/somefile.d.ts                                                                               |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/somefile.d.ts                                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/somefile.d.ts                                                          | //vda1cs4850/c$/folderAtRoot/folder1                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                             |
| //vda1cs4850/c$/users/somefile.d.ts                                                                         |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/users/username/somefile.d.ts                                                                |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                             |
| //vda1cs4850/c$/user/somefile.d.ts                                                                          | //vda1cs4850/c$/user                                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/somefile.d.ts                                                                 | //vda1cs4850/c$/user/username                                                                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/user/username/folderAtRoot                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                             |
| //vda1cs4850/c$/usr/somefile.d.ts                                                                           | //vda1cs4850/c$/usr                                                                                         | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/somefile.d.ts                                                                  | //vda1cs4850/c$/usr/username                                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/c$/usr/username/folderAtRoot                                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                             |
| //vda1cs4850/c$/home/somefile.d.ts                                                                          | //vda1cs4850/c$/home                                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/somefile.d.ts                                                                 | //vda1cs4850/c$/home/username                                                                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/home/username/folderAtRoot                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/somefile.d.ts                                                                    | //vda1cs4850/c$/workspaces                                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/somefile.d.ts                                                       | //vda1cs4850/c$/workspaces/folderAtRoot                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                             |

## RootDirForResolution: //vda1cs4850/c$/users/username

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive | Location if not symlink                                                                                     |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- | ----------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/somefile.d.ts                                                                               |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/somefile.d.ts                                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/somefile.d.ts                                                          | //vda1cs4850/c$/folderAtRoot/folder1                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                             |
| //vda1cs4850/c$/users/somefile.d.ts                                                                         |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/users/username/somefile.d.ts                                                                |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                             |
| //vda1cs4850/c$/user/somefile.d.ts                                                                          | //vda1cs4850/c$/user                                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/somefile.d.ts                                                                 | //vda1cs4850/c$/user/username                                                                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/user/username/folderAtRoot                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                             |
| //vda1cs4850/c$/usr/somefile.d.ts                                                                           | //vda1cs4850/c$/usr                                                                                         | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/somefile.d.ts                                                                  | //vda1cs4850/c$/usr/username                                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/c$/usr/username/folderAtRoot                                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                             |
| //vda1cs4850/c$/home/somefile.d.ts                                                                          | //vda1cs4850/c$/home                                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/somefile.d.ts                                                                 | //vda1cs4850/c$/home/username                                                                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/home/username/folderAtRoot                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/somefile.d.ts                                                                    | //vda1cs4850/c$/workspaces                                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/somefile.d.ts                                                       | //vda1cs4850/c$/workspaces/folderAtRoot                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                             |

## RootDirForResolution: //vda1cs4850/c$/users/username/folderAtRoot

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive | Location if not symlink                                                                                     |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- | ----------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/somefile.d.ts                                                                               |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/somefile.d.ts                                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/somefile.d.ts                                                          | //vda1cs4850/c$/folderAtRoot/folder1                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                             |
| //vda1cs4850/c$/users/somefile.d.ts                                                                         |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/users/username/somefile.d.ts                                                                |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                             |
| //vda1cs4850/c$/user/somefile.d.ts                                                                          | //vda1cs4850/c$/user                                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/somefile.d.ts                                                                 | //vda1cs4850/c$/user/username                                                                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/user/username/folderAtRoot                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                             |
| //vda1cs4850/c$/usr/somefile.d.ts                                                                           | //vda1cs4850/c$/usr                                                                                         | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/somefile.d.ts                                                                  | //vda1cs4850/c$/usr/username                                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/c$/usr/username/folderAtRoot                                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                             |
| //vda1cs4850/c$/home/somefile.d.ts                                                                          | //vda1cs4850/c$/home                                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/somefile.d.ts                                                                 | //vda1cs4850/c$/home/username                                                                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/home/username/folderAtRoot                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/somefile.d.ts                                                                    | //vda1cs4850/c$/workspaces                                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/somefile.d.ts                                                       | //vda1cs4850/c$/workspaces/folderAtRoot                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                             |

## RootDirForResolution: //vda1cs4850/c$/users/username/folderAtRoot/folder1

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive | Location if not symlink                                                                                     |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- | ----------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/somefile.d.ts                                                                               |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/somefile.d.ts                                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/somefile.d.ts                                                          | //vda1cs4850/c$/folderAtRoot/folder1                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                             |
| //vda1cs4850/c$/users/somefile.d.ts                                                                         |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/users/username/somefile.d.ts                                                                |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2                                                 | true      |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2                                                 | true      |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2                                                 | true      |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2                                                 | true      |                                                                                                             |
| //vda1cs4850/c$/user/somefile.d.ts                                                                          | //vda1cs4850/c$/user                                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/somefile.d.ts                                                                 | //vda1cs4850/c$/user/username                                                                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/user/username/folderAtRoot                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                             |
| //vda1cs4850/c$/usr/somefile.d.ts                                                                           | //vda1cs4850/c$/usr                                                                                         | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/somefile.d.ts                                                                  | //vda1cs4850/c$/usr/username                                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/c$/usr/username/folderAtRoot                                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                             |
| //vda1cs4850/c$/home/somefile.d.ts                                                                          | //vda1cs4850/c$/home                                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/somefile.d.ts                                                                 | //vda1cs4850/c$/home/username                                                                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/home/username/folderAtRoot                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/somefile.d.ts                                                                    | //vda1cs4850/c$/workspaces                                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/somefile.d.ts                                                       | //vda1cs4850/c$/workspaces/folderAtRoot                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                             |

## RootDirForResolution: //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive | Location if not symlink                                                                                     |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- | ----------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/somefile.d.ts                                                                               |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/somefile.d.ts                                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/somefile.d.ts                                                          | //vda1cs4850/c$/folderAtRoot/folder1                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                             |
| //vda1cs4850/c$/users/somefile.d.ts                                                                         |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/users/username/somefile.d.ts                                                                |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3                                         | true      |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3                                         | true      |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3                                         | true      |                                                                                                             |
| //vda1cs4850/c$/user/somefile.d.ts                                                                          | //vda1cs4850/c$/user                                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/somefile.d.ts                                                                 | //vda1cs4850/c$/user/username                                                                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/user/username/folderAtRoot                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                             |
| //vda1cs4850/c$/usr/somefile.d.ts                                                                           | //vda1cs4850/c$/usr                                                                                         | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/somefile.d.ts                                                                  | //vda1cs4850/c$/usr/username                                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/c$/usr/username/folderAtRoot                                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                             |
| //vda1cs4850/c$/home/somefile.d.ts                                                                          | //vda1cs4850/c$/home                                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/somefile.d.ts                                                                 | //vda1cs4850/c$/home/username                                                                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/home/username/folderAtRoot                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/somefile.d.ts                                                                    | //vda1cs4850/c$/workspaces                                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/somefile.d.ts                                                       | //vda1cs4850/c$/workspaces/folderAtRoot                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                             |

## RootDirForResolution: //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive | Location if not symlink                                                                                     |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- | ----------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/somefile.d.ts                                                                               |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/somefile.d.ts                                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/somefile.d.ts                                                          | //vda1cs4850/c$/folderAtRoot/folder1                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                             |
| //vda1cs4850/c$/users/somefile.d.ts                                                                         |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/users/username/somefile.d.ts                                                                |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | true      |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | true      |                                                                                                             |
| //vda1cs4850/c$/user/somefile.d.ts                                                                          | //vda1cs4850/c$/user                                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/somefile.d.ts                                                                 | //vda1cs4850/c$/user/username                                                                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/user/username/folderAtRoot                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                             |
| //vda1cs4850/c$/usr/somefile.d.ts                                                                           | //vda1cs4850/c$/usr                                                                                         | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/somefile.d.ts                                                                  | //vda1cs4850/c$/usr/username                                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/c$/usr/username/folderAtRoot                                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                             |
| //vda1cs4850/c$/home/somefile.d.ts                                                                          | //vda1cs4850/c$/home                                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/somefile.d.ts                                                                 | //vda1cs4850/c$/home/username                                                                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/home/username/folderAtRoot                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/somefile.d.ts                                                                    | //vda1cs4850/c$/workspaces                                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/somefile.d.ts                                                       | //vda1cs4850/c$/workspaces/folderAtRoot                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                             |

## RootDirForResolution: //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive | Location if not symlink                                                                                     |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- | ----------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/somefile.d.ts                                                                               |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/somefile.d.ts                                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/somefile.d.ts                                                          | //vda1cs4850/c$/folderAtRoot/folder1                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                             |
| //vda1cs4850/c$/users/somefile.d.ts                                                                         |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/users/username/somefile.d.ts                                                                |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | true      |                                                                                                             |
| //vda1cs4850/c$/user/somefile.d.ts                                                                          | //vda1cs4850/c$/user                                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/somefile.d.ts                                                                 | //vda1cs4850/c$/user/username                                                                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/user/username/folderAtRoot                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                             |
| //vda1cs4850/c$/usr/somefile.d.ts                                                                           | //vda1cs4850/c$/usr                                                                                         | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/somefile.d.ts                                                                  | //vda1cs4850/c$/usr/username                                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/c$/usr/username/folderAtRoot                                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                             |
| //vda1cs4850/c$/home/somefile.d.ts                                                                          | //vda1cs4850/c$/home                                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/somefile.d.ts                                                                 | //vda1cs4850/c$/home/username                                                                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/home/username/folderAtRoot                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/somefile.d.ts                                                                    | //vda1cs4850/c$/workspaces                                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/somefile.d.ts                                                       | //vda1cs4850/c$/workspaces/folderAtRoot                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                             |

## RootDirForResolution: //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive | Location if not symlink                                                                                     |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- | ----------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/somefile.d.ts                                                                               |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/somefile.d.ts                                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/somefile.d.ts                                                          | //vda1cs4850/c$/folderAtRoot/folder1                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                             |
| //vda1cs4850/c$/users/somefile.d.ts                                                                         |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/users/username/somefile.d.ts                                                                |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                             |
| //vda1cs4850/c$/user/somefile.d.ts                                                                          | //vda1cs4850/c$/user                                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/somefile.d.ts                                                                 | //vda1cs4850/c$/user/username                                                                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/user/username/folderAtRoot                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                             |
| //vda1cs4850/c$/usr/somefile.d.ts                                                                           | //vda1cs4850/c$/usr                                                                                         | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/somefile.d.ts                                                                  | //vda1cs4850/c$/usr/username                                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/c$/usr/username/folderAtRoot                                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                             |
| //vda1cs4850/c$/home/somefile.d.ts                                                                          | //vda1cs4850/c$/home                                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/somefile.d.ts                                                                 | //vda1cs4850/c$/home/username                                                                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/home/username/folderAtRoot                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/somefile.d.ts                                                                    | //vda1cs4850/c$/workspaces                                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/somefile.d.ts                                                       | //vda1cs4850/c$/workspaces/folderAtRoot                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                             |

## RootDirForResolution: //vda1cs4850/c$/user

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive | Location if not symlink                                                                                     |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- | ----------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/somefile.d.ts                                                                               |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/somefile.d.ts                                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/somefile.d.ts                                                          | //vda1cs4850/c$/folderAtRoot/folder1                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                             |
| //vda1cs4850/c$/users/somefile.d.ts                                                                         |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/users/username/somefile.d.ts                                                                |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                             |
| //vda1cs4850/c$/user/somefile.d.ts                                                                          | //vda1cs4850/c$/user                                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/somefile.d.ts                                                                 | //vda1cs4850/c$/user/username                                                                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/user/username/folderAtRoot                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                             |
| //vda1cs4850/c$/usr/somefile.d.ts                                                                           | //vda1cs4850/c$/usr                                                                                         | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/somefile.d.ts                                                                  | //vda1cs4850/c$/usr/username                                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/c$/usr/username/folderAtRoot                                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                             |
| //vda1cs4850/c$/home/somefile.d.ts                                                                          | //vda1cs4850/c$/home                                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/somefile.d.ts                                                                 | //vda1cs4850/c$/home/username                                                                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/home/username/folderAtRoot                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/somefile.d.ts                                                                    | //vda1cs4850/c$/workspaces                                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/somefile.d.ts                                                       | //vda1cs4850/c$/workspaces/folderAtRoot                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                             |

## RootDirForResolution: //vda1cs4850/c$/user/username

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive | Location if not symlink                                                                                     |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- | ----------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/somefile.d.ts                                                                               |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/somefile.d.ts                                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/somefile.d.ts                                                          | //vda1cs4850/c$/folderAtRoot/folder1                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                             |
| //vda1cs4850/c$/users/somefile.d.ts                                                                         |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/users/username/somefile.d.ts                                                                |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                             |
| //vda1cs4850/c$/user/somefile.d.ts                                                                          | //vda1cs4850/c$/user                                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/somefile.d.ts                                                                 | //vda1cs4850/c$/user/username                                                                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/user/username/folderAtRoot                                                                  | true      |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/user/username/folderAtRoot                                                                  | true      |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/user/username/folderAtRoot                                                                  | true      |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/user/username/folderAtRoot                                                                  | true      |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/user/username/folderAtRoot                                                                  | true      |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/user/username/folderAtRoot                                                                  | true      |                                                                                                             |
| //vda1cs4850/c$/usr/somefile.d.ts                                                                           | //vda1cs4850/c$/usr                                                                                         | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/somefile.d.ts                                                                  | //vda1cs4850/c$/usr/username                                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/c$/usr/username/folderAtRoot                                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                             |
| //vda1cs4850/c$/home/somefile.d.ts                                                                          | //vda1cs4850/c$/home                                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/somefile.d.ts                                                                 | //vda1cs4850/c$/home/username                                                                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/home/username/folderAtRoot                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/somefile.d.ts                                                                    | //vda1cs4850/c$/workspaces                                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/somefile.d.ts                                                       | //vda1cs4850/c$/workspaces/folderAtRoot                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                             |

## RootDirForResolution: //vda1cs4850/c$/user/username/folderAtRoot

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive | Location if not symlink                                                                                     |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- | ----------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/somefile.d.ts                                                                               |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/somefile.d.ts                                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/somefile.d.ts                                                          | //vda1cs4850/c$/folderAtRoot/folder1                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                             |
| //vda1cs4850/c$/users/somefile.d.ts                                                                         |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/users/username/somefile.d.ts                                                                |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                             |
| //vda1cs4850/c$/user/somefile.d.ts                                                                          | //vda1cs4850/c$/user                                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/somefile.d.ts                                                                 | //vda1cs4850/c$/user/username                                                                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/user/username/folderAtRoot                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1                                                          | true      |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1                                                          | true      |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1                                                          | true      |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1                                                          | true      |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/user/username/folderAtRoot/folder1                                                          | true      |                                                                                                             |
| //vda1cs4850/c$/usr/somefile.d.ts                                                                           | //vda1cs4850/c$/usr                                                                                         | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/somefile.d.ts                                                                  | //vda1cs4850/c$/usr/username                                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/c$/usr/username/folderAtRoot                                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                             |
| //vda1cs4850/c$/home/somefile.d.ts                                                                          | //vda1cs4850/c$/home                                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/somefile.d.ts                                                                 | //vda1cs4850/c$/home/username                                                                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/home/username/folderAtRoot                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/somefile.d.ts                                                                    | //vda1cs4850/c$/workspaces                                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/somefile.d.ts                                                       | //vda1cs4850/c$/workspaces/folderAtRoot                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                             |

## RootDirForResolution: //vda1cs4850/c$/user/username/folderAtRoot/folder1

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive | Location if not symlink                                                                                     |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- | ----------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/somefile.d.ts                                                                               |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/somefile.d.ts                                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/somefile.d.ts                                                          | //vda1cs4850/c$/folderAtRoot/folder1                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                             |
| //vda1cs4850/c$/users/somefile.d.ts                                                                         |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/users/username/somefile.d.ts                                                                |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                             |
| //vda1cs4850/c$/user/somefile.d.ts                                                                          | //vda1cs4850/c$/user                                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/somefile.d.ts                                                                 | //vda1cs4850/c$/user/username                                                                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/user/username/folderAtRoot                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2                                                  | true      |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2                                                  | true      |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2                                                  | true      |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2                                                  | true      |                                                                                                             |
| //vda1cs4850/c$/usr/somefile.d.ts                                                                           | //vda1cs4850/c$/usr                                                                                         | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/somefile.d.ts                                                                  | //vda1cs4850/c$/usr/username                                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/c$/usr/username/folderAtRoot                                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                             |
| //vda1cs4850/c$/home/somefile.d.ts                                                                          | //vda1cs4850/c$/home                                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/somefile.d.ts                                                                 | //vda1cs4850/c$/home/username                                                                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/home/username/folderAtRoot                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/somefile.d.ts                                                                    | //vda1cs4850/c$/workspaces                                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/somefile.d.ts                                                       | //vda1cs4850/c$/workspaces/folderAtRoot                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                             |

## RootDirForResolution: //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive | Location if not symlink                                                                                     |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- | ----------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/somefile.d.ts                                                                               |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/somefile.d.ts                                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/somefile.d.ts                                                          | //vda1cs4850/c$/folderAtRoot/folder1                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                             |
| //vda1cs4850/c$/users/somefile.d.ts                                                                         |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/users/username/somefile.d.ts                                                                |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                             |
| //vda1cs4850/c$/user/somefile.d.ts                                                                          | //vda1cs4850/c$/user                                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/somefile.d.ts                                                                 | //vda1cs4850/c$/user/username                                                                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/user/username/folderAtRoot                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3                                          | true      |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3                                          | true      |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3                                          | true      |                                                                                                             |
| //vda1cs4850/c$/usr/somefile.d.ts                                                                           | //vda1cs4850/c$/usr                                                                                         | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/somefile.d.ts                                                                  | //vda1cs4850/c$/usr/username                                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/c$/usr/username/folderAtRoot                                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                             |
| //vda1cs4850/c$/home/somefile.d.ts                                                                          | //vda1cs4850/c$/home                                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/somefile.d.ts                                                                 | //vda1cs4850/c$/home/username                                                                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/home/username/folderAtRoot                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/somefile.d.ts                                                                    | //vda1cs4850/c$/workspaces                                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/somefile.d.ts                                                       | //vda1cs4850/c$/workspaces/folderAtRoot                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                             |

## RootDirForResolution: //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive | Location if not symlink                                                                                     |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- | ----------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/somefile.d.ts                                                                               |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/somefile.d.ts                                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/somefile.d.ts                                                          | //vda1cs4850/c$/folderAtRoot/folder1                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                             |
| //vda1cs4850/c$/users/somefile.d.ts                                                                         |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/users/username/somefile.d.ts                                                                |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                             |
| //vda1cs4850/c$/user/somefile.d.ts                                                                          | //vda1cs4850/c$/user                                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/somefile.d.ts                                                                 | //vda1cs4850/c$/user/username                                                                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/user/username/folderAtRoot                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | true      |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | true      |                                                                                                             |
| //vda1cs4850/c$/usr/somefile.d.ts                                                                           | //vda1cs4850/c$/usr                                                                                         | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/somefile.d.ts                                                                  | //vda1cs4850/c$/usr/username                                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/c$/usr/username/folderAtRoot                                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                             |
| //vda1cs4850/c$/home/somefile.d.ts                                                                          | //vda1cs4850/c$/home                                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/somefile.d.ts                                                                 | //vda1cs4850/c$/home/username                                                                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/home/username/folderAtRoot                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/somefile.d.ts                                                                    | //vda1cs4850/c$/workspaces                                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/somefile.d.ts                                                       | //vda1cs4850/c$/workspaces/folderAtRoot                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                             |

## RootDirForResolution: //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive | Location if not symlink                                                                                     |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- | ----------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/somefile.d.ts                                                                               |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/somefile.d.ts                                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/somefile.d.ts                                                          | //vda1cs4850/c$/folderAtRoot/folder1                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                             |
| //vda1cs4850/c$/users/somefile.d.ts                                                                         |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/users/username/somefile.d.ts                                                                |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                             |
| //vda1cs4850/c$/user/somefile.d.ts                                                                          | //vda1cs4850/c$/user                                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/somefile.d.ts                                                                 | //vda1cs4850/c$/user/username                                                                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/user/username/folderAtRoot                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | true      |                                                                                                             |
| //vda1cs4850/c$/usr/somefile.d.ts                                                                           | //vda1cs4850/c$/usr                                                                                         | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/somefile.d.ts                                                                  | //vda1cs4850/c$/usr/username                                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/c$/usr/username/folderAtRoot                                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                             |
| //vda1cs4850/c$/home/somefile.d.ts                                                                          | //vda1cs4850/c$/home                                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/somefile.d.ts                                                                 | //vda1cs4850/c$/home/username                                                                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/home/username/folderAtRoot                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/somefile.d.ts                                                                    | //vda1cs4850/c$/workspaces                                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/somefile.d.ts                                                       | //vda1cs4850/c$/workspaces/folderAtRoot                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                             |

## RootDirForResolution: //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive | Location if not symlink                                                                                     |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- | ----------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/somefile.d.ts                                                                               |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/somefile.d.ts                                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/somefile.d.ts                                                          | //vda1cs4850/c$/folderAtRoot/folder1                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                             |
| //vda1cs4850/c$/users/somefile.d.ts                                                                         |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/users/username/somefile.d.ts                                                                |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                             |
| //vda1cs4850/c$/user/somefile.d.ts                                                                          | //vda1cs4850/c$/user                                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/somefile.d.ts                                                                 | //vda1cs4850/c$/user/username                                                                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/user/username/folderAtRoot                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                             |
| //vda1cs4850/c$/usr/somefile.d.ts                                                                           | //vda1cs4850/c$/usr                                                                                         | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/somefile.d.ts                                                                  | //vda1cs4850/c$/usr/username                                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/c$/usr/username/folderAtRoot                                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                             |
| //vda1cs4850/c$/home/somefile.d.ts                                                                          | //vda1cs4850/c$/home                                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/somefile.d.ts                                                                 | //vda1cs4850/c$/home/username                                                                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/home/username/folderAtRoot                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/somefile.d.ts                                                                    | //vda1cs4850/c$/workspaces                                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/somefile.d.ts                                                       | //vda1cs4850/c$/workspaces/folderAtRoot                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                             |

## RootDirForResolution: //vda1cs4850/c$/usr

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive | Location if not symlink                                                                                     |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- | ----------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/somefile.d.ts                                                                               |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/somefile.d.ts                                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/somefile.d.ts                                                          | //vda1cs4850/c$/folderAtRoot/folder1                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                             |
| //vda1cs4850/c$/users/somefile.d.ts                                                                         |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/users/username/somefile.d.ts                                                                |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                             |
| //vda1cs4850/c$/user/somefile.d.ts                                                                          | //vda1cs4850/c$/user                                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/somefile.d.ts                                                                 | //vda1cs4850/c$/user/username                                                                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/user/username/folderAtRoot                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                             |
| //vda1cs4850/c$/usr/somefile.d.ts                                                                           | //vda1cs4850/c$/usr                                                                                         | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/somefile.d.ts                                                                  | //vda1cs4850/c$/usr/username                                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/c$/usr/username/folderAtRoot                                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                             |
| //vda1cs4850/c$/home/somefile.d.ts                                                                          | //vda1cs4850/c$/home                                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/somefile.d.ts                                                                 | //vda1cs4850/c$/home/username                                                                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/home/username/folderAtRoot                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/somefile.d.ts                                                                    | //vda1cs4850/c$/workspaces                                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/somefile.d.ts                                                       | //vda1cs4850/c$/workspaces/folderAtRoot                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                             |

## RootDirForResolution: //vda1cs4850/c$/usr/username

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive | Location if not symlink                                                                                     |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- | ----------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/somefile.d.ts                                                                               |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/somefile.d.ts                                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/somefile.d.ts                                                          | //vda1cs4850/c$/folderAtRoot/folder1                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                             |
| //vda1cs4850/c$/users/somefile.d.ts                                                                         |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/users/username/somefile.d.ts                                                                |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                             |
| //vda1cs4850/c$/user/somefile.d.ts                                                                          | //vda1cs4850/c$/user                                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/somefile.d.ts                                                                 | //vda1cs4850/c$/user/username                                                                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/user/username/folderAtRoot                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                             |
| //vda1cs4850/c$/usr/somefile.d.ts                                                                           | //vda1cs4850/c$/usr                                                                                         | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/somefile.d.ts                                                                  | //vda1cs4850/c$/usr/username                                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/c$/usr/username/folderAtRoot                                                                   | true      |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/c$/usr/username/folderAtRoot                                                                   | true      |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/c$/usr/username/folderAtRoot                                                                   | true      |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/c$/usr/username/folderAtRoot                                                                   | true      |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/c$/usr/username/folderAtRoot                                                                   | true      |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/c$/usr/username/folderAtRoot                                                                   | true      |                                                                                                             |
| //vda1cs4850/c$/home/somefile.d.ts                                                                          | //vda1cs4850/c$/home                                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/somefile.d.ts                                                                 | //vda1cs4850/c$/home/username                                                                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/home/username/folderAtRoot                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/somefile.d.ts                                                                    | //vda1cs4850/c$/workspaces                                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/somefile.d.ts                                                       | //vda1cs4850/c$/workspaces/folderAtRoot                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                             |

## RootDirForResolution: //vda1cs4850/c$/usr/username/folderAtRoot

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive | Location if not symlink                                                                                     |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- | ----------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/somefile.d.ts                                                                               |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/somefile.d.ts                                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/somefile.d.ts                                                          | //vda1cs4850/c$/folderAtRoot/folder1                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                             |
| //vda1cs4850/c$/users/somefile.d.ts                                                                         |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/users/username/somefile.d.ts                                                                |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                             |
| //vda1cs4850/c$/user/somefile.d.ts                                                                          | //vda1cs4850/c$/user                                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/somefile.d.ts                                                                 | //vda1cs4850/c$/user/username                                                                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/user/username/folderAtRoot                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                             |
| //vda1cs4850/c$/usr/somefile.d.ts                                                                           | //vda1cs4850/c$/usr                                                                                         | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/somefile.d.ts                                                                  | //vda1cs4850/c$/usr/username                                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/c$/usr/username/folderAtRoot                                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1                                                           | true      |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1                                                           | true      |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1                                                           | true      |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1                                                           | true      |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1                                                           | true      |                                                                                                             |
| //vda1cs4850/c$/home/somefile.d.ts                                                                          | //vda1cs4850/c$/home                                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/somefile.d.ts                                                                 | //vda1cs4850/c$/home/username                                                                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/home/username/folderAtRoot                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/somefile.d.ts                                                                    | //vda1cs4850/c$/workspaces                                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/somefile.d.ts                                                       | //vda1cs4850/c$/workspaces/folderAtRoot                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                             |

## RootDirForResolution: //vda1cs4850/c$/usr/username/folderAtRoot/folder1

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive | Location if not symlink                                                                                     |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- | ----------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/somefile.d.ts                                                                               |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/somefile.d.ts                                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/somefile.d.ts                                                          | //vda1cs4850/c$/folderAtRoot/folder1                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                             |
| //vda1cs4850/c$/users/somefile.d.ts                                                                         |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/users/username/somefile.d.ts                                                                |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                             |
| //vda1cs4850/c$/user/somefile.d.ts                                                                          | //vda1cs4850/c$/user                                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/somefile.d.ts                                                                 | //vda1cs4850/c$/user/username                                                                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/user/username/folderAtRoot                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                             |
| //vda1cs4850/c$/usr/somefile.d.ts                                                                           | //vda1cs4850/c$/usr                                                                                         | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/somefile.d.ts                                                                  | //vda1cs4850/c$/usr/username                                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/c$/usr/username/folderAtRoot                                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2                                                   | true      |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2                                                   | true      |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2                                                   | true      |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2                                                   | true      |                                                                                                             |
| //vda1cs4850/c$/home/somefile.d.ts                                                                          | //vda1cs4850/c$/home                                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/somefile.d.ts                                                                 | //vda1cs4850/c$/home/username                                                                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/home/username/folderAtRoot                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/somefile.d.ts                                                                    | //vda1cs4850/c$/workspaces                                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/somefile.d.ts                                                       | //vda1cs4850/c$/workspaces/folderAtRoot                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                             |

## RootDirForResolution: //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive | Location if not symlink                                                                                     |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- | ----------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/somefile.d.ts                                                                               |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/somefile.d.ts                                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/somefile.d.ts                                                          | //vda1cs4850/c$/folderAtRoot/folder1                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                             |
| //vda1cs4850/c$/users/somefile.d.ts                                                                         |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/users/username/somefile.d.ts                                                                |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                             |
| //vda1cs4850/c$/user/somefile.d.ts                                                                          | //vda1cs4850/c$/user                                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/somefile.d.ts                                                                 | //vda1cs4850/c$/user/username                                                                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/user/username/folderAtRoot                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                             |
| //vda1cs4850/c$/usr/somefile.d.ts                                                                           | //vda1cs4850/c$/usr                                                                                         | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/somefile.d.ts                                                                  | //vda1cs4850/c$/usr/username                                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/c$/usr/username/folderAtRoot                                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3                                           | true      |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3                                           | true      |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3                                           | true      |                                                                                                             |
| //vda1cs4850/c$/home/somefile.d.ts                                                                          | //vda1cs4850/c$/home                                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/somefile.d.ts                                                                 | //vda1cs4850/c$/home/username                                                                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/home/username/folderAtRoot                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/somefile.d.ts                                                                    | //vda1cs4850/c$/workspaces                                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/somefile.d.ts                                                       | //vda1cs4850/c$/workspaces/folderAtRoot                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                             |

## RootDirForResolution: //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive | Location if not symlink                                                                                     |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- | ----------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/somefile.d.ts                                                                               |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/somefile.d.ts                                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/somefile.d.ts                                                          | //vda1cs4850/c$/folderAtRoot/folder1                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                             |
| //vda1cs4850/c$/users/somefile.d.ts                                                                         |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/users/username/somefile.d.ts                                                                |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                             |
| //vda1cs4850/c$/user/somefile.d.ts                                                                          | //vda1cs4850/c$/user                                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/somefile.d.ts                                                                 | //vda1cs4850/c$/user/username                                                                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/user/username/folderAtRoot                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                             |
| //vda1cs4850/c$/usr/somefile.d.ts                                                                           | //vda1cs4850/c$/usr                                                                                         | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/somefile.d.ts                                                                  | //vda1cs4850/c$/usr/username                                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/c$/usr/username/folderAtRoot                                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | true      |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | true      |                                                                                                             |
| //vda1cs4850/c$/home/somefile.d.ts                                                                          | //vda1cs4850/c$/home                                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/somefile.d.ts                                                                 | //vda1cs4850/c$/home/username                                                                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/home/username/folderAtRoot                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/somefile.d.ts                                                                    | //vda1cs4850/c$/workspaces                                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/somefile.d.ts                                                       | //vda1cs4850/c$/workspaces/folderAtRoot                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                             |

## RootDirForResolution: //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive | Location if not symlink                                                                                     |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- | ----------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/somefile.d.ts                                                                               |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/somefile.d.ts                                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/somefile.d.ts                                                          | //vda1cs4850/c$/folderAtRoot/folder1                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                             |
| //vda1cs4850/c$/users/somefile.d.ts                                                                         |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/users/username/somefile.d.ts                                                                |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                             |
| //vda1cs4850/c$/user/somefile.d.ts                                                                          | //vda1cs4850/c$/user                                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/somefile.d.ts                                                                 | //vda1cs4850/c$/user/username                                                                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/user/username/folderAtRoot                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                             |
| //vda1cs4850/c$/usr/somefile.d.ts                                                                           | //vda1cs4850/c$/usr                                                                                         | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/somefile.d.ts                                                                  | //vda1cs4850/c$/usr/username                                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/c$/usr/username/folderAtRoot                                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | true      |                                                                                                             |
| //vda1cs4850/c$/home/somefile.d.ts                                                                          | //vda1cs4850/c$/home                                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/somefile.d.ts                                                                 | //vda1cs4850/c$/home/username                                                                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/home/username/folderAtRoot                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/somefile.d.ts                                                                    | //vda1cs4850/c$/workspaces                                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/somefile.d.ts                                                       | //vda1cs4850/c$/workspaces/folderAtRoot                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                             |

## RootDirForResolution: //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive | Location if not symlink                                                                                     |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- | ----------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/somefile.d.ts                                                                               |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/somefile.d.ts                                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/somefile.d.ts                                                          | //vda1cs4850/c$/folderAtRoot/folder1                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                             |
| //vda1cs4850/c$/users/somefile.d.ts                                                                         |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/users/username/somefile.d.ts                                                                |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                             |
| //vda1cs4850/c$/user/somefile.d.ts                                                                          | //vda1cs4850/c$/user                                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/somefile.d.ts                                                                 | //vda1cs4850/c$/user/username                                                                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/user/username/folderAtRoot                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                             |
| //vda1cs4850/c$/usr/somefile.d.ts                                                                           | //vda1cs4850/c$/usr                                                                                         | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/somefile.d.ts                                                                  | //vda1cs4850/c$/usr/username                                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/c$/usr/username/folderAtRoot                                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                             |
| //vda1cs4850/c$/home/somefile.d.ts                                                                          | //vda1cs4850/c$/home                                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/somefile.d.ts                                                                 | //vda1cs4850/c$/home/username                                                                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/home/username/folderAtRoot                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/somefile.d.ts                                                                    | //vda1cs4850/c$/workspaces                                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/somefile.d.ts                                                       | //vda1cs4850/c$/workspaces/folderAtRoot                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                             |

## RootDirForResolution: //vda1cs4850/c$/home

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive | Location if not symlink                                                                                     |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- | ----------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/somefile.d.ts                                                                               |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/somefile.d.ts                                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/somefile.d.ts                                                          | //vda1cs4850/c$/folderAtRoot/folder1                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                             |
| //vda1cs4850/c$/users/somefile.d.ts                                                                         |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/users/username/somefile.d.ts                                                                |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                             |
| //vda1cs4850/c$/user/somefile.d.ts                                                                          | //vda1cs4850/c$/user                                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/somefile.d.ts                                                                 | //vda1cs4850/c$/user/username                                                                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/user/username/folderAtRoot                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                             |
| //vda1cs4850/c$/usr/somefile.d.ts                                                                           | //vda1cs4850/c$/usr                                                                                         | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/somefile.d.ts                                                                  | //vda1cs4850/c$/usr/username                                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/c$/usr/username/folderAtRoot                                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                             |
| //vda1cs4850/c$/home/somefile.d.ts                                                                          | //vda1cs4850/c$/home                                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/somefile.d.ts                                                                 | //vda1cs4850/c$/home/username                                                                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/home/username/folderAtRoot                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/somefile.d.ts                                                                    | //vda1cs4850/c$/workspaces                                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/somefile.d.ts                                                       | //vda1cs4850/c$/workspaces/folderAtRoot                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                             |

## RootDirForResolution: //vda1cs4850/c$/home/username

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive | Location if not symlink                                                                                     |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- | ----------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/somefile.d.ts                                                                               |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/somefile.d.ts                                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/somefile.d.ts                                                          | //vda1cs4850/c$/folderAtRoot/folder1                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                             |
| //vda1cs4850/c$/users/somefile.d.ts                                                                         |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/users/username/somefile.d.ts                                                                |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                             |
| //vda1cs4850/c$/user/somefile.d.ts                                                                          | //vda1cs4850/c$/user                                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/somefile.d.ts                                                                 | //vda1cs4850/c$/user/username                                                                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/user/username/folderAtRoot                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                             |
| //vda1cs4850/c$/usr/somefile.d.ts                                                                           | //vda1cs4850/c$/usr                                                                                         | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/somefile.d.ts                                                                  | //vda1cs4850/c$/usr/username                                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/c$/usr/username/folderAtRoot                                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                             |
| //vda1cs4850/c$/home/somefile.d.ts                                                                          | //vda1cs4850/c$/home                                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/somefile.d.ts                                                                 | //vda1cs4850/c$/home/username                                                                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/home/username/folderAtRoot                                                                  | true      |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/home/username/folderAtRoot                                                                  | true      |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/home/username/folderAtRoot                                                                  | true      |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/home/username/folderAtRoot                                                                  | true      |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/home/username/folderAtRoot                                                                  | true      |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/home/username/folderAtRoot                                                                  | true      |                                                                                                             |
| //vda1cs4850/c$/workspaces/somefile.d.ts                                                                    | //vda1cs4850/c$/workspaces                                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/somefile.d.ts                                                       | //vda1cs4850/c$/workspaces/folderAtRoot                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                             |

## RootDirForResolution: //vda1cs4850/c$/home/username/folderAtRoot

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive | Location if not symlink                                                                                     |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- | ----------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/somefile.d.ts                                                                               |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/somefile.d.ts                                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/somefile.d.ts                                                          | //vda1cs4850/c$/folderAtRoot/folder1                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                             |
| //vda1cs4850/c$/users/somefile.d.ts                                                                         |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/users/username/somefile.d.ts                                                                |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                             |
| //vda1cs4850/c$/user/somefile.d.ts                                                                          | //vda1cs4850/c$/user                                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/somefile.d.ts                                                                 | //vda1cs4850/c$/user/username                                                                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/user/username/folderAtRoot                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                             |
| //vda1cs4850/c$/usr/somefile.d.ts                                                                           | //vda1cs4850/c$/usr                                                                                         | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/somefile.d.ts                                                                  | //vda1cs4850/c$/usr/username                                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/c$/usr/username/folderAtRoot                                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                             |
| //vda1cs4850/c$/home/somefile.d.ts                                                                          | //vda1cs4850/c$/home                                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/somefile.d.ts                                                                 | //vda1cs4850/c$/home/username                                                                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/home/username/folderAtRoot                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/home/username/folderAtRoot/folder1                                                          | true      |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/home/username/folderAtRoot/folder1                                                          | true      |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/home/username/folderAtRoot/folder1                                                          | true      |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/home/username/folderAtRoot/folder1                                                          | true      |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/home/username/folderAtRoot/folder1                                                          | true      |                                                                                                             |
| //vda1cs4850/c$/workspaces/somefile.d.ts                                                                    | //vda1cs4850/c$/workspaces                                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/somefile.d.ts                                                       | //vda1cs4850/c$/workspaces/folderAtRoot                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                             |

## RootDirForResolution: //vda1cs4850/c$/home/username/folderAtRoot/folder1

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive | Location if not symlink                                                                                     |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- | ----------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/somefile.d.ts                                                                               |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/somefile.d.ts                                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/somefile.d.ts                                                          | //vda1cs4850/c$/folderAtRoot/folder1                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                             |
| //vda1cs4850/c$/users/somefile.d.ts                                                                         |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/users/username/somefile.d.ts                                                                |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                             |
| //vda1cs4850/c$/user/somefile.d.ts                                                                          | //vda1cs4850/c$/user                                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/somefile.d.ts                                                                 | //vda1cs4850/c$/user/username                                                                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/user/username/folderAtRoot                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                             |
| //vda1cs4850/c$/usr/somefile.d.ts                                                                           | //vda1cs4850/c$/usr                                                                                         | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/somefile.d.ts                                                                  | //vda1cs4850/c$/usr/username                                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/c$/usr/username/folderAtRoot                                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                             |
| //vda1cs4850/c$/home/somefile.d.ts                                                                          | //vda1cs4850/c$/home                                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/somefile.d.ts                                                                 | //vda1cs4850/c$/home/username                                                                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/home/username/folderAtRoot                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2                                                  | true      |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2                                                  | true      |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2                                                  | true      |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2                                                  | true      |                                                                                                             |
| //vda1cs4850/c$/workspaces/somefile.d.ts                                                                    | //vda1cs4850/c$/workspaces                                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/somefile.d.ts                                                       | //vda1cs4850/c$/workspaces/folderAtRoot                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                             |

## RootDirForResolution: //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive | Location if not symlink                                                                                     |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- | ----------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/somefile.d.ts                                                                               |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/somefile.d.ts                                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/somefile.d.ts                                                          | //vda1cs4850/c$/folderAtRoot/folder1                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                             |
| //vda1cs4850/c$/users/somefile.d.ts                                                                         |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/users/username/somefile.d.ts                                                                |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                             |
| //vda1cs4850/c$/user/somefile.d.ts                                                                          | //vda1cs4850/c$/user                                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/somefile.d.ts                                                                 | //vda1cs4850/c$/user/username                                                                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/user/username/folderAtRoot                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                             |
| //vda1cs4850/c$/usr/somefile.d.ts                                                                           | //vda1cs4850/c$/usr                                                                                         | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/somefile.d.ts                                                                  | //vda1cs4850/c$/usr/username                                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/c$/usr/username/folderAtRoot                                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                             |
| //vda1cs4850/c$/home/somefile.d.ts                                                                          | //vda1cs4850/c$/home                                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/somefile.d.ts                                                                 | //vda1cs4850/c$/home/username                                                                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/home/username/folderAtRoot                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3                                          | true      |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3                                          | true      |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3                                          | true      |                                                                                                             |
| //vda1cs4850/c$/workspaces/somefile.d.ts                                                                    | //vda1cs4850/c$/workspaces                                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/somefile.d.ts                                                       | //vda1cs4850/c$/workspaces/folderAtRoot                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                             |

## RootDirForResolution: //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive | Location if not symlink                                                                                     |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- | ----------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/somefile.d.ts                                                                               |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/somefile.d.ts                                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/somefile.d.ts                                                          | //vda1cs4850/c$/folderAtRoot/folder1                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                             |
| //vda1cs4850/c$/users/somefile.d.ts                                                                         |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/users/username/somefile.d.ts                                                                |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                             |
| //vda1cs4850/c$/user/somefile.d.ts                                                                          | //vda1cs4850/c$/user                                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/somefile.d.ts                                                                 | //vda1cs4850/c$/user/username                                                                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/user/username/folderAtRoot                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                             |
| //vda1cs4850/c$/usr/somefile.d.ts                                                                           | //vda1cs4850/c$/usr                                                                                         | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/somefile.d.ts                                                                  | //vda1cs4850/c$/usr/username                                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/c$/usr/username/folderAtRoot                                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                             |
| //vda1cs4850/c$/home/somefile.d.ts                                                                          | //vda1cs4850/c$/home                                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/somefile.d.ts                                                                 | //vda1cs4850/c$/home/username                                                                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/home/username/folderAtRoot                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | true      |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | true      |                                                                                                             |
| //vda1cs4850/c$/workspaces/somefile.d.ts                                                                    | //vda1cs4850/c$/workspaces                                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/somefile.d.ts                                                       | //vda1cs4850/c$/workspaces/folderAtRoot                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                             |

## RootDirForResolution: //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive | Location if not symlink                                                                                     |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- | ----------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/somefile.d.ts                                                                               |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/somefile.d.ts                                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/somefile.d.ts                                                          | //vda1cs4850/c$/folderAtRoot/folder1                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                             |
| //vda1cs4850/c$/users/somefile.d.ts                                                                         |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/users/username/somefile.d.ts                                                                |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                             |
| //vda1cs4850/c$/user/somefile.d.ts                                                                          | //vda1cs4850/c$/user                                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/somefile.d.ts                                                                 | //vda1cs4850/c$/user/username                                                                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/user/username/folderAtRoot                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                             |
| //vda1cs4850/c$/usr/somefile.d.ts                                                                           | //vda1cs4850/c$/usr                                                                                         | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/somefile.d.ts                                                                  | //vda1cs4850/c$/usr/username                                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/c$/usr/username/folderAtRoot                                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                             |
| //vda1cs4850/c$/home/somefile.d.ts                                                                          | //vda1cs4850/c$/home                                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/somefile.d.ts                                                                 | //vda1cs4850/c$/home/username                                                                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/home/username/folderAtRoot                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | true      |                                                                                                             |
| //vda1cs4850/c$/workspaces/somefile.d.ts                                                                    | //vda1cs4850/c$/workspaces                                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/somefile.d.ts                                                       | //vda1cs4850/c$/workspaces/folderAtRoot                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                             |

## RootDirForResolution: //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive | Location if not symlink                                                                                     |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- | ----------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/somefile.d.ts                                                                               |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/somefile.d.ts                                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/somefile.d.ts                                                          | //vda1cs4850/c$/folderAtRoot/folder1                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                             |
| //vda1cs4850/c$/users/somefile.d.ts                                                                         |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/users/username/somefile.d.ts                                                                |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                             |
| //vda1cs4850/c$/user/somefile.d.ts                                                                          | //vda1cs4850/c$/user                                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/somefile.d.ts                                                                 | //vda1cs4850/c$/user/username                                                                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/user/username/folderAtRoot                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                             |
| //vda1cs4850/c$/usr/somefile.d.ts                                                                           | //vda1cs4850/c$/usr                                                                                         | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/somefile.d.ts                                                                  | //vda1cs4850/c$/usr/username                                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/c$/usr/username/folderAtRoot                                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                             |
| //vda1cs4850/c$/home/somefile.d.ts                                                                          | //vda1cs4850/c$/home                                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/somefile.d.ts                                                                 | //vda1cs4850/c$/home/username                                                                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/home/username/folderAtRoot                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/somefile.d.ts                                                                    | //vda1cs4850/c$/workspaces                                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/somefile.d.ts                                                       | //vda1cs4850/c$/workspaces/folderAtRoot                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                             |

## RootDirForResolution: //vda1cs4850/c$/workspaces

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive | Location if not symlink                                                                                     |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- | ----------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/somefile.d.ts                                                                               |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/somefile.d.ts                                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/somefile.d.ts                                                          | //vda1cs4850/c$/folderAtRoot/folder1                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                             |
| //vda1cs4850/c$/users/somefile.d.ts                                                                         |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/users/username/somefile.d.ts                                                                |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                             |
| //vda1cs4850/c$/user/somefile.d.ts                                                                          | //vda1cs4850/c$/user                                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/somefile.d.ts                                                                 | //vda1cs4850/c$/user/username                                                                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/user/username/folderAtRoot                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                             |
| //vda1cs4850/c$/usr/somefile.d.ts                                                                           | //vda1cs4850/c$/usr                                                                                         | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/somefile.d.ts                                                                  | //vda1cs4850/c$/usr/username                                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/c$/usr/username/folderAtRoot                                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                             |
| //vda1cs4850/c$/home/somefile.d.ts                                                                          | //vda1cs4850/c$/home                                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/somefile.d.ts                                                                 | //vda1cs4850/c$/home/username                                                                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/home/username/folderAtRoot                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/somefile.d.ts                                                                    | //vda1cs4850/c$/workspaces                                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/somefile.d.ts                                                       | //vda1cs4850/c$/workspaces/folderAtRoot                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                             |

## RootDirForResolution: //vda1cs4850/c$/workspaces/folderAtRoot

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive | Location if not symlink                                                                                     |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- | ----------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/somefile.d.ts                                                                               |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/somefile.d.ts                                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/somefile.d.ts                                                          | //vda1cs4850/c$/folderAtRoot/folder1                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                             |
| //vda1cs4850/c$/users/somefile.d.ts                                                                         |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/users/username/somefile.d.ts                                                                |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                             |
| //vda1cs4850/c$/user/somefile.d.ts                                                                          | //vda1cs4850/c$/user                                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/somefile.d.ts                                                                 | //vda1cs4850/c$/user/username                                                                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/user/username/folderAtRoot                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                             |
| //vda1cs4850/c$/usr/somefile.d.ts                                                                           | //vda1cs4850/c$/usr                                                                                         | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/somefile.d.ts                                                                  | //vda1cs4850/c$/usr/username                                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/c$/usr/username/folderAtRoot                                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                             |
| //vda1cs4850/c$/home/somefile.d.ts                                                                          | //vda1cs4850/c$/home                                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/somefile.d.ts                                                                 | //vda1cs4850/c$/home/username                                                                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/home/username/folderAtRoot                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/somefile.d.ts                                                                    | //vda1cs4850/c$/workspaces                                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/somefile.d.ts                                                       | //vda1cs4850/c$/workspaces/folderAtRoot                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1                                                             | true      |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | //vda1cs4850/c$/workspaces/folderAtRoot/folder1                                                             | true      |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1                                                             | true      |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | //vda1cs4850/c$/workspaces/folderAtRoot/folder1                                                             | true      |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1                                                             | true      |                                                                                                             |

## RootDirForResolution: //vda1cs4850/c$/workspaces/folderAtRoot/folder1

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive | Location if not symlink                                                                                     |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- | ----------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/somefile.d.ts                                                                               |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/somefile.d.ts                                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/somefile.d.ts                                                          | //vda1cs4850/c$/folderAtRoot/folder1                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                             |
| //vda1cs4850/c$/users/somefile.d.ts                                                                         |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/users/username/somefile.d.ts                                                                |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                             |
| //vda1cs4850/c$/user/somefile.d.ts                                                                          | //vda1cs4850/c$/user                                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/somefile.d.ts                                                                 | //vda1cs4850/c$/user/username                                                                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/user/username/folderAtRoot                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                             |
| //vda1cs4850/c$/usr/somefile.d.ts                                                                           | //vda1cs4850/c$/usr                                                                                         | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/somefile.d.ts                                                                  | //vda1cs4850/c$/usr/username                                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/c$/usr/username/folderAtRoot                                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                             |
| //vda1cs4850/c$/home/somefile.d.ts                                                                          | //vda1cs4850/c$/home                                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/somefile.d.ts                                                                 | //vda1cs4850/c$/home/username                                                                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/home/username/folderAtRoot                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/somefile.d.ts                                                                    | //vda1cs4850/c$/workspaces                                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/somefile.d.ts                                                       | //vda1cs4850/c$/workspaces/folderAtRoot                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2                                                     | true      |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2                                                     | true      |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2                                                     | true      |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2                                                     | true      |                                                                                                             |

## RootDirForResolution: //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive | Location if not symlink                                                                                     |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- | ----------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/somefile.d.ts                                                                               |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/somefile.d.ts                                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/somefile.d.ts                                                          | //vda1cs4850/c$/folderAtRoot/folder1                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                             |
| //vda1cs4850/c$/users/somefile.d.ts                                                                         |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/users/username/somefile.d.ts                                                                |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                             |
| //vda1cs4850/c$/user/somefile.d.ts                                                                          | //vda1cs4850/c$/user                                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/somefile.d.ts                                                                 | //vda1cs4850/c$/user/username                                                                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/user/username/folderAtRoot                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                             |
| //vda1cs4850/c$/usr/somefile.d.ts                                                                           | //vda1cs4850/c$/usr                                                                                         | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/somefile.d.ts                                                                  | //vda1cs4850/c$/usr/username                                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/c$/usr/username/folderAtRoot                                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                             |
| //vda1cs4850/c$/home/somefile.d.ts                                                                          | //vda1cs4850/c$/home                                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/somefile.d.ts                                                                 | //vda1cs4850/c$/home/username                                                                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/home/username/folderAtRoot                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/somefile.d.ts                                                                    | //vda1cs4850/c$/workspaces                                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/somefile.d.ts                                                       | //vda1cs4850/c$/workspaces/folderAtRoot                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3                                             | true      |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3                                             | true      |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3                                             | true      |                                                                                                             |

## RootDirForResolution: //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive | Location if not symlink                                                                                     |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- | ----------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/somefile.d.ts                                                                               |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/somefile.d.ts                                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/somefile.d.ts                                                          | //vda1cs4850/c$/folderAtRoot/folder1                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                             |
| //vda1cs4850/c$/users/somefile.d.ts                                                                         |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/users/username/somefile.d.ts                                                                |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                             |
| //vda1cs4850/c$/user/somefile.d.ts                                                                          | //vda1cs4850/c$/user                                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/somefile.d.ts                                                                 | //vda1cs4850/c$/user/username                                                                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/user/username/folderAtRoot                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                             |
| //vda1cs4850/c$/usr/somefile.d.ts                                                                           | //vda1cs4850/c$/usr                                                                                         | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/somefile.d.ts                                                                  | //vda1cs4850/c$/usr/username                                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/c$/usr/username/folderAtRoot                                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                             |
| //vda1cs4850/c$/home/somefile.d.ts                                                                          | //vda1cs4850/c$/home                                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/somefile.d.ts                                                                 | //vda1cs4850/c$/home/username                                                                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/home/username/folderAtRoot                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/somefile.d.ts                                                                    | //vda1cs4850/c$/workspaces                                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/somefile.d.ts                                                       | //vda1cs4850/c$/workspaces/folderAtRoot                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | true      |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | true      |                                                                                                             |

## RootDirForResolution: //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive | Location if not symlink                                                                                     |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- | ----------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/somefile.d.ts                                                                               |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/somefile.d.ts                                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/somefile.d.ts                                                          | //vda1cs4850/c$/folderAtRoot/folder1                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                             |
| //vda1cs4850/c$/users/somefile.d.ts                                                                         |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/users/username/somefile.d.ts                                                                |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                             |
| //vda1cs4850/c$/user/somefile.d.ts                                                                          | //vda1cs4850/c$/user                                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/somefile.d.ts                                                                 | //vda1cs4850/c$/user/username                                                                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/user/username/folderAtRoot                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                             |
| //vda1cs4850/c$/usr/somefile.d.ts                                                                           | //vda1cs4850/c$/usr                                                                                         | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/somefile.d.ts                                                                  | //vda1cs4850/c$/usr/username                                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/c$/usr/username/folderAtRoot                                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                             |
| //vda1cs4850/c$/home/somefile.d.ts                                                                          | //vda1cs4850/c$/home                                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/somefile.d.ts                                                                 | //vda1cs4850/c$/home/username                                                                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/home/username/folderAtRoot                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/somefile.d.ts                                                                    | //vda1cs4850/c$/workspaces                                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/somefile.d.ts                                                       | //vda1cs4850/c$/workspaces/folderAtRoot                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | true      |                                                                                                             |

## RootDirForResolution: //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive | Location if not symlink                                                                                     |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- | ----------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/somefile.d.ts                                                                               |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/somefile.d.ts                                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/somefile.d.ts                                                          | //vda1cs4850/c$/folderAtRoot/folder1                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                             |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                             |
| //vda1cs4850/c$/users/somefile.d.ts                                                                         |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/users/username/somefile.d.ts                                                                |                                                                                                             |           |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                             |
| //vda1cs4850/c$/user/somefile.d.ts                                                                          | //vda1cs4850/c$/user                                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/somefile.d.ts                                                                 | //vda1cs4850/c$/user/username                                                                               | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/user/username/folderAtRoot                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                             |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                             |
| //vda1cs4850/c$/usr/somefile.d.ts                                                                           | //vda1cs4850/c$/usr                                                                                         | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/somefile.d.ts                                                                  | //vda1cs4850/c$/usr/username                                                                                | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/c$/usr/username/folderAtRoot                                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                             |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                             |
| //vda1cs4850/c$/home/somefile.d.ts                                                                          | //vda1cs4850/c$/home                                                                                        | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/somefile.d.ts                                                                 | //vda1cs4850/c$/home/username                                                                               | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/home/username/folderAtRoot                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                             |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/somefile.d.ts                                                                    | //vda1cs4850/c$/workspaces                                                                                  | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/somefile.d.ts                                                       | //vda1cs4850/c$/workspaces/folderAtRoot                                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                             |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                             |

