# getDirectoryToWatchFailedLookupLocationInsubDirNonRecursive

Determines whether to watch given failed lookup location (file that didnt exist) when resolving module.
It also determines the directory to watch and whether to watch it recursively or not.

## Testing for Posix root: /

## RootDirForResolution: /

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /dir/subdir/somefile.d.ts                                                                    |                                                                                              |           |                                                                                              |
| /folderAtRoot/dir/subdir/somefile.d.ts                                                       | /folderAtRoot/dir/subdir                                                                     | false     |                                                                                              |
| /folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | /folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                              |
| /users/dir/subdir/somefile.d.ts                                                              | /users/dir/subdir                                                                            | false     |                                                                                              |
| /users/username/dir/subdir/somefile.d.ts                                                     | /users/username/dir/subdir                                                                   | false     |                                                                                              |
| /users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                              |
| /user/dir/subdir/somefile.d.ts                                                               | /user/dir/subdir                                                                             | false     |                                                                                              |
| /user/username/dir/subdir/somefile.d.ts                                                      | /user/username/dir/subdir                                                                    | false     |                                                                                              |
| /user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                              |
| /usr/dir/subdir/somefile.d.ts                                                                | /usr/dir/subdir                                                                              | false     |                                                                                              |
| /usr/username/dir/subdir/somefile.d.ts                                                       | /usr/username/dir/subdir                                                                     | false     |                                                                                              |
| /usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                              |
| /home/dir/subdir/somefile.d.ts                                                               | /home/dir/subdir                                                                             | false     |                                                                                              |
| /home/username/dir/subdir/somefile.d.ts                                                      | /home/username/dir/subdir                                                                    | false     |                                                                                              |
| /home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                              |
| /workspaces/dir/subdir/somefile.d.ts                                                         | /workspaces/dir/subdir                                                                       | false     |                                                                                              |
| /workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | /workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | /workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | /workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | /workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                              |

## RootDirForResolution: /folderAtRoot

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /dir/subdir/somefile.d.ts                                                                    |                                                                                              |           |                                                                                              |
| /folderAtRoot/dir/subdir/somefile.d.ts                                                       | /folderAtRoot/dir/subdir                                                                     | false     |                                                                                              |
| /folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | /folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                              |
| /users/dir/subdir/somefile.d.ts                                                              | /users/dir/subdir                                                                            | false     |                                                                                              |
| /users/username/dir/subdir/somefile.d.ts                                                     | /users/username/dir/subdir                                                                   | false     |                                                                                              |
| /users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                              |
| /user/dir/subdir/somefile.d.ts                                                               | /user/dir/subdir                                                                             | false     |                                                                                              |
| /user/username/dir/subdir/somefile.d.ts                                                      | /user/username/dir/subdir                                                                    | false     |                                                                                              |
| /user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                              |
| /usr/dir/subdir/somefile.d.ts                                                                | /usr/dir/subdir                                                                              | false     |                                                                                              |
| /usr/username/dir/subdir/somefile.d.ts                                                       | /usr/username/dir/subdir                                                                     | false     |                                                                                              |
| /usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                              |
| /home/dir/subdir/somefile.d.ts                                                               | /home/dir/subdir                                                                             | false     |                                                                                              |
| /home/username/dir/subdir/somefile.d.ts                                                      | /home/username/dir/subdir                                                                    | false     |                                                                                              |
| /home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                              |
| /workspaces/dir/subdir/somefile.d.ts                                                         | /workspaces/dir/subdir                                                                       | false     |                                                                                              |
| /workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | /workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | /workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | /workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | /workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                              |

## RootDirForResolution: /folderAtRoot/folder1

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /dir/subdir/somefile.d.ts                                                                    |                                                                                              |           |                                                                                              |
| /folderAtRoot/dir/subdir/somefile.d.ts                                                       | /folderAtRoot/dir/subdir                                                                     | false     |                                                                                              |
| /folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | /folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                              |
| /users/dir/subdir/somefile.d.ts                                                              | /users/dir/subdir                                                                            | false     |                                                                                              |
| /users/username/dir/subdir/somefile.d.ts                                                     | /users/username/dir/subdir                                                                   | false     |                                                                                              |
| /users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                              |
| /user/dir/subdir/somefile.d.ts                                                               | /user/dir/subdir                                                                             | false     |                                                                                              |
| /user/username/dir/subdir/somefile.d.ts                                                      | /user/username/dir/subdir                                                                    | false     |                                                                                              |
| /user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                              |
| /usr/dir/subdir/somefile.d.ts                                                                | /usr/dir/subdir                                                                              | false     |                                                                                              |
| /usr/username/dir/subdir/somefile.d.ts                                                       | /usr/username/dir/subdir                                                                     | false     |                                                                                              |
| /usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                              |
| /home/dir/subdir/somefile.d.ts                                                               | /home/dir/subdir                                                                             | false     |                                                                                              |
| /home/username/dir/subdir/somefile.d.ts                                                      | /home/username/dir/subdir                                                                    | false     |                                                                                              |
| /home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                              |
| /workspaces/dir/subdir/somefile.d.ts                                                         | /workspaces/dir/subdir                                                                       | false     |                                                                                              |
| /workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | /workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | /workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | /workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | /workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                              |

## RootDirForResolution: /folderAtRoot/folder1/folder2

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /dir/subdir/somefile.d.ts                                                                    |                                                                                              |           |                                                                                              |
| /folderAtRoot/dir/subdir/somefile.d.ts                                                       | /folderAtRoot/dir/subdir                                                                     | false     |                                                                                              |
| /folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | /folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                              |
| /users/dir/subdir/somefile.d.ts                                                              | /users/dir/subdir                                                                            | false     |                                                                                              |
| /users/username/dir/subdir/somefile.d.ts                                                     | /users/username/dir/subdir                                                                   | false     |                                                                                              |
| /users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                              |
| /user/dir/subdir/somefile.d.ts                                                               | /user/dir/subdir                                                                             | false     |                                                                                              |
| /user/username/dir/subdir/somefile.d.ts                                                      | /user/username/dir/subdir                                                                    | false     |                                                                                              |
| /user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                              |
| /usr/dir/subdir/somefile.d.ts                                                                | /usr/dir/subdir                                                                              | false     |                                                                                              |
| /usr/username/dir/subdir/somefile.d.ts                                                       | /usr/username/dir/subdir                                                                     | false     |                                                                                              |
| /usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                              |
| /home/dir/subdir/somefile.d.ts                                                               | /home/dir/subdir                                                                             | false     |                                                                                              |
| /home/username/dir/subdir/somefile.d.ts                                                      | /home/username/dir/subdir                                                                    | false     |                                                                                              |
| /home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                              |
| /workspaces/dir/subdir/somefile.d.ts                                                         | /workspaces/dir/subdir                                                                       | false     |                                                                                              |
| /workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | /workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | /workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | /workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | /workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                              |

## RootDirForResolution: /folderAtRoot/folder1/folder2/folder3

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /dir/subdir/somefile.d.ts                                                                    |                                                                                              |           |                                                                                              |
| /folderAtRoot/dir/subdir/somefile.d.ts                                                       | /folderAtRoot/dir/subdir                                                                     | false     |                                                                                              |
| /folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | /folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2/folder3/dir                                                    | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2/folder3/folder4                                                | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2/folder3/folder4                                                | true      |                                                                                              |
| /users/dir/subdir/somefile.d.ts                                                              | /users/dir/subdir                                                                            | false     |                                                                                              |
| /users/username/dir/subdir/somefile.d.ts                                                     | /users/username/dir/subdir                                                                   | false     |                                                                                              |
| /users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                              |
| /user/dir/subdir/somefile.d.ts                                                               | /user/dir/subdir                                                                             | false     |                                                                                              |
| /user/username/dir/subdir/somefile.d.ts                                                      | /user/username/dir/subdir                                                                    | false     |                                                                                              |
| /user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                              |
| /usr/dir/subdir/somefile.d.ts                                                                | /usr/dir/subdir                                                                              | false     |                                                                                              |
| /usr/username/dir/subdir/somefile.d.ts                                                       | /usr/username/dir/subdir                                                                     | false     |                                                                                              |
| /usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                              |
| /home/dir/subdir/somefile.d.ts                                                               | /home/dir/subdir                                                                             | false     |                                                                                              |
| /home/username/dir/subdir/somefile.d.ts                                                      | /home/username/dir/subdir                                                                    | false     |                                                                                              |
| /home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                              |
| /workspaces/dir/subdir/somefile.d.ts                                                         | /workspaces/dir/subdir                                                                       | false     |                                                                                              |
| /workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | /workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | /workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | /workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | /workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                              |

## RootDirForResolution: /folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /dir/subdir/somefile.d.ts                                                                    |                                                                                              |           |                                                                                              |
| /folderAtRoot/dir/subdir/somefile.d.ts                                                       | /folderAtRoot/dir/subdir                                                                     | false     |                                                                                              |
| /folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | /folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2/folder3/folder4/dir                                            | true      |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | true      |                                                                                              |
| /users/dir/subdir/somefile.d.ts                                                              | /users/dir/subdir                                                                            | false     |                                                                                              |
| /users/username/dir/subdir/somefile.d.ts                                                     | /users/username/dir/subdir                                                                   | false     |                                                                                              |
| /users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                              |
| /user/dir/subdir/somefile.d.ts                                                               | /user/dir/subdir                                                                             | false     |                                                                                              |
| /user/username/dir/subdir/somefile.d.ts                                                      | /user/username/dir/subdir                                                                    | false     |                                                                                              |
| /user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                              |
| /usr/dir/subdir/somefile.d.ts                                                                | /usr/dir/subdir                                                                              | false     |                                                                                              |
| /usr/username/dir/subdir/somefile.d.ts                                                       | /usr/username/dir/subdir                                                                     | false     |                                                                                              |
| /usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                              |
| /home/dir/subdir/somefile.d.ts                                                               | /home/dir/subdir                                                                             | false     |                                                                                              |
| /home/username/dir/subdir/somefile.d.ts                                                      | /home/username/dir/subdir                                                                    | false     |                                                                                              |
| /home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                              |
| /workspaces/dir/subdir/somefile.d.ts                                                         | /workspaces/dir/subdir                                                                       | false     |                                                                                              |
| /workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | /workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | /workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | /workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | /workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                              |

## RootDirForResolution: /folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /dir/subdir/somefile.d.ts                                                                    |                                                                                              |           |                                                                                              |
| /folderAtRoot/dir/subdir/somefile.d.ts                                                       | /folderAtRoot/dir/subdir                                                                     | false     |                                                                                              |
| /folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | /folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                                    | true      |                                                                                              |
| /users/dir/subdir/somefile.d.ts                                                              | /users/dir/subdir                                                                            | false     |                                                                                              |
| /users/username/dir/subdir/somefile.d.ts                                                     | /users/username/dir/subdir                                                                   | false     |                                                                                              |
| /users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                              |
| /user/dir/subdir/somefile.d.ts                                                               | /user/dir/subdir                                                                             | false     |                                                                                              |
| /user/username/dir/subdir/somefile.d.ts                                                      | /user/username/dir/subdir                                                                    | false     |                                                                                              |
| /user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                              |
| /usr/dir/subdir/somefile.d.ts                                                                | /usr/dir/subdir                                                                              | false     |                                                                                              |
| /usr/username/dir/subdir/somefile.d.ts                                                       | /usr/username/dir/subdir                                                                     | false     |                                                                                              |
| /usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                              |
| /home/dir/subdir/somefile.d.ts                                                               | /home/dir/subdir                                                                             | false     |                                                                                              |
| /home/username/dir/subdir/somefile.d.ts                                                      | /home/username/dir/subdir                                                                    | false     |                                                                                              |
| /home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                              |
| /workspaces/dir/subdir/somefile.d.ts                                                         | /workspaces/dir/subdir                                                                       | false     |                                                                                              |
| /workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | /workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | /workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | /workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | /workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                              |

## RootDirForResolution: /users

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /dir/subdir/somefile.d.ts                                                                    |                                                                                              |           |                                                                                              |
| /folderAtRoot/dir/subdir/somefile.d.ts                                                       | /folderAtRoot/dir/subdir                                                                     | false     |                                                                                              |
| /folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | /folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                              |
| /users/dir/subdir/somefile.d.ts                                                              | /users/dir/subdir                                                                            | false     |                                                                                              |
| /users/username/dir/subdir/somefile.d.ts                                                     | /users/username/dir/subdir                                                                   | false     |                                                                                              |
| /users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                              |
| /user/dir/subdir/somefile.d.ts                                                               | /user/dir/subdir                                                                             | false     |                                                                                              |
| /user/username/dir/subdir/somefile.d.ts                                                      | /user/username/dir/subdir                                                                    | false     |                                                                                              |
| /user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                              |
| /usr/dir/subdir/somefile.d.ts                                                                | /usr/dir/subdir                                                                              | false     |                                                                                              |
| /usr/username/dir/subdir/somefile.d.ts                                                       | /usr/username/dir/subdir                                                                     | false     |                                                                                              |
| /usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                              |
| /home/dir/subdir/somefile.d.ts                                                               | /home/dir/subdir                                                                             | false     |                                                                                              |
| /home/username/dir/subdir/somefile.d.ts                                                      | /home/username/dir/subdir                                                                    | false     |                                                                                              |
| /home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                              |
| /workspaces/dir/subdir/somefile.d.ts                                                         | /workspaces/dir/subdir                                                                       | false     |                                                                                              |
| /workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | /workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | /workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | /workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | /workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                              |

## RootDirForResolution: /users/username

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /dir/subdir/somefile.d.ts                                                                    |                                                                                              |           |                                                                                              |
| /folderAtRoot/dir/subdir/somefile.d.ts                                                       | /folderAtRoot/dir/subdir                                                                     | false     |                                                                                              |
| /folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | /folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                              |
| /users/dir/subdir/somefile.d.ts                                                              | /users/dir/subdir                                                                            | false     |                                                                                              |
| /users/username/dir/subdir/somefile.d.ts                                                     | /users/username/dir/subdir                                                                   | false     |                                                                                              |
| /users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                              |
| /user/dir/subdir/somefile.d.ts                                                               | /user/dir/subdir                                                                             | false     |                                                                                              |
| /user/username/dir/subdir/somefile.d.ts                                                      | /user/username/dir/subdir                                                                    | false     |                                                                                              |
| /user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                              |
| /usr/dir/subdir/somefile.d.ts                                                                | /usr/dir/subdir                                                                              | false     |                                                                                              |
| /usr/username/dir/subdir/somefile.d.ts                                                       | /usr/username/dir/subdir                                                                     | false     |                                                                                              |
| /usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                              |
| /home/dir/subdir/somefile.d.ts                                                               | /home/dir/subdir                                                                             | false     |                                                                                              |
| /home/username/dir/subdir/somefile.d.ts                                                      | /home/username/dir/subdir                                                                    | false     |                                                                                              |
| /home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                              |
| /workspaces/dir/subdir/somefile.d.ts                                                         | /workspaces/dir/subdir                                                                       | false     |                                                                                              |
| /workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | /workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | /workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | /workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | /workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                              |

## RootDirForResolution: /users/username/folderAtRoot

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /dir/subdir/somefile.d.ts                                                                    |                                                                                              |           |                                                                                              |
| /folderAtRoot/dir/subdir/somefile.d.ts                                                       | /folderAtRoot/dir/subdir                                                                     | false     |                                                                                              |
| /folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | /folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                              |
| /users/dir/subdir/somefile.d.ts                                                              | /users/dir/subdir                                                                            | false     |                                                                                              |
| /users/username/dir/subdir/somefile.d.ts                                                     | /users/username/dir/subdir                                                                   | false     |                                                                                              |
| /users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                              |
| /user/dir/subdir/somefile.d.ts                                                               | /user/dir/subdir                                                                             | false     |                                                                                              |
| /user/username/dir/subdir/somefile.d.ts                                                      | /user/username/dir/subdir                                                                    | false     |                                                                                              |
| /user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                              |
| /usr/dir/subdir/somefile.d.ts                                                                | /usr/dir/subdir                                                                              | false     |                                                                                              |
| /usr/username/dir/subdir/somefile.d.ts                                                       | /usr/username/dir/subdir                                                                     | false     |                                                                                              |
| /usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                              |
| /home/dir/subdir/somefile.d.ts                                                               | /home/dir/subdir                                                                             | false     |                                                                                              |
| /home/username/dir/subdir/somefile.d.ts                                                      | /home/username/dir/subdir                                                                    | false     |                                                                                              |
| /home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                              |
| /workspaces/dir/subdir/somefile.d.ts                                                         | /workspaces/dir/subdir                                                                       | false     |                                                                                              |
| /workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | /workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | /workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | /workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | /workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                              |

## RootDirForResolution: /users/username/folderAtRoot/folder1

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /dir/subdir/somefile.d.ts                                                                    |                                                                                              |           |                                                                                              |
| /folderAtRoot/dir/subdir/somefile.d.ts                                                       | /folderAtRoot/dir/subdir                                                                     | false     |                                                                                              |
| /folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | /folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                              |
| /users/dir/subdir/somefile.d.ts                                                              | /users/dir/subdir                                                                            | false     |                                                                                              |
| /users/username/dir/subdir/somefile.d.ts                                                     | /users/username/dir/subdir                                                                   | false     |                                                                                              |
| /users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot/folder1/dir                                                     | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot/folder1/folder2                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot/folder1/folder2                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot/folder1/folder2                                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /users/username/folderAtRoot/folder1/folder2                                                 | true      |                                                                                              |
| /user/dir/subdir/somefile.d.ts                                                               | /user/dir/subdir                                                                             | false     |                                                                                              |
| /user/username/dir/subdir/somefile.d.ts                                                      | /user/username/dir/subdir                                                                    | false     |                                                                                              |
| /user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                              |
| /usr/dir/subdir/somefile.d.ts                                                                | /usr/dir/subdir                                                                              | false     |                                                                                              |
| /usr/username/dir/subdir/somefile.d.ts                                                       | /usr/username/dir/subdir                                                                     | false     |                                                                                              |
| /usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                              |
| /home/dir/subdir/somefile.d.ts                                                               | /home/dir/subdir                                                                             | false     |                                                                                              |
| /home/username/dir/subdir/somefile.d.ts                                                      | /home/username/dir/subdir                                                                    | false     |                                                                                              |
| /home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                              |
| /workspaces/dir/subdir/somefile.d.ts                                                         | /workspaces/dir/subdir                                                                       | false     |                                                                                              |
| /workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | /workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | /workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | /workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | /workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                              |

## RootDirForResolution: /users/username/folderAtRoot/folder1/folder2

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /dir/subdir/somefile.d.ts                                                                    |                                                                                              |           |                                                                                              |
| /folderAtRoot/dir/subdir/somefile.d.ts                                                       | /folderAtRoot/dir/subdir                                                                     | false     |                                                                                              |
| /folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | /folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                              |
| /users/dir/subdir/somefile.d.ts                                                              | /users/dir/subdir                                                                            | false     |                                                                                              |
| /users/username/dir/subdir/somefile.d.ts                                                     | /users/username/dir/subdir                                                                   | false     |                                                                                              |
| /users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot/folder1/folder2/dir                                             | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot/folder1/folder2/folder3                                         | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot/folder1/folder2/folder3                                         | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /users/username/folderAtRoot/folder1/folder2/folder3                                         | true      |                                                                                              |
| /user/dir/subdir/somefile.d.ts                                                               | /user/dir/subdir                                                                             | false     |                                                                                              |
| /user/username/dir/subdir/somefile.d.ts                                                      | /user/username/dir/subdir                                                                    | false     |                                                                                              |
| /user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                              |
| /usr/dir/subdir/somefile.d.ts                                                                | /usr/dir/subdir                                                                              | false     |                                                                                              |
| /usr/username/dir/subdir/somefile.d.ts                                                       | /usr/username/dir/subdir                                                                     | false     |                                                                                              |
| /usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                              |
| /home/dir/subdir/somefile.d.ts                                                               | /home/dir/subdir                                                                             | false     |                                                                                              |
| /home/username/dir/subdir/somefile.d.ts                                                      | /home/username/dir/subdir                                                                    | false     |                                                                                              |
| /home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                              |
| /workspaces/dir/subdir/somefile.d.ts                                                         | /workspaces/dir/subdir                                                                       | false     |                                                                                              |
| /workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | /workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | /workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | /workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | /workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                              |

## RootDirForResolution: /users/username/folderAtRoot/folder1/folder2/folder3

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /dir/subdir/somefile.d.ts                                                                    |                                                                                              |           |                                                                                              |
| /folderAtRoot/dir/subdir/somefile.d.ts                                                       | /folderAtRoot/dir/subdir                                                                     | false     |                                                                                              |
| /folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | /folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                              |
| /users/dir/subdir/somefile.d.ts                                                              | /users/dir/subdir                                                                            | false     |                                                                                              |
| /users/username/dir/subdir/somefile.d.ts                                                     | /users/username/dir/subdir                                                                   | false     |                                                                                              |
| /users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot/folder1/folder2/folder3/dir                                     | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | true      |                                                                                              |
| /user/dir/subdir/somefile.d.ts                                                               | /user/dir/subdir                                                                             | false     |                                                                                              |
| /user/username/dir/subdir/somefile.d.ts                                                      | /user/username/dir/subdir                                                                    | false     |                                                                                              |
| /user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                              |
| /usr/dir/subdir/somefile.d.ts                                                                | /usr/dir/subdir                                                                              | false     |                                                                                              |
| /usr/username/dir/subdir/somefile.d.ts                                                       | /usr/username/dir/subdir                                                                     | false     |                                                                                              |
| /usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                              |
| /home/dir/subdir/somefile.d.ts                                                               | /home/dir/subdir                                                                             | false     |                                                                                              |
| /home/username/dir/subdir/somefile.d.ts                                                      | /home/username/dir/subdir                                                                    | false     |                                                                                              |
| /home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                              |
| /workspaces/dir/subdir/somefile.d.ts                                                         | /workspaces/dir/subdir                                                                       | false     |                                                                                              |
| /workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | /workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | /workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | /workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | /workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                              |

## RootDirForResolution: /users/username/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /dir/subdir/somefile.d.ts                                                                    |                                                                                              |           |                                                                                              |
| /folderAtRoot/dir/subdir/somefile.d.ts                                                       | /folderAtRoot/dir/subdir                                                                     | false     |                                                                                              |
| /folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | /folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                              |
| /users/dir/subdir/somefile.d.ts                                                              | /users/dir/subdir                                                                            | false     |                                                                                              |
| /users/username/dir/subdir/somefile.d.ts                                                     | /users/username/dir/subdir                                                                   | false     |                                                                                              |
| /users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                             | true      |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | true      |                                                                                              |
| /user/dir/subdir/somefile.d.ts                                                               | /user/dir/subdir                                                                             | false     |                                                                                              |
| /user/username/dir/subdir/somefile.d.ts                                                      | /user/username/dir/subdir                                                                    | false     |                                                                                              |
| /user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                              |
| /usr/dir/subdir/somefile.d.ts                                                                | /usr/dir/subdir                                                                              | false     |                                                                                              |
| /usr/username/dir/subdir/somefile.d.ts                                                       | /usr/username/dir/subdir                                                                     | false     |                                                                                              |
| /usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                              |
| /home/dir/subdir/somefile.d.ts                                                               | /home/dir/subdir                                                                             | false     |                                                                                              |
| /home/username/dir/subdir/somefile.d.ts                                                      | /home/username/dir/subdir                                                                    | false     |                                                                                              |
| /home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                              |
| /workspaces/dir/subdir/somefile.d.ts                                                         | /workspaces/dir/subdir                                                                       | false     |                                                                                              |
| /workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | /workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | /workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | /workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | /workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                              |

## RootDirForResolution: /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /dir/subdir/somefile.d.ts                                                                    |                                                                                              |           |                                                                                              |
| /folderAtRoot/dir/subdir/somefile.d.ts                                                       | /folderAtRoot/dir/subdir                                                                     | false     |                                                                                              |
| /folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | /folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                              |
| /users/dir/subdir/somefile.d.ts                                                              | /users/dir/subdir                                                                            | false     |                                                                                              |
| /users/username/dir/subdir/somefile.d.ts                                                     | /users/username/dir/subdir                                                                   | false     |                                                                                              |
| /users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                     | true      |                                                                                              |
| /user/dir/subdir/somefile.d.ts                                                               | /user/dir/subdir                                                                             | false     |                                                                                              |
| /user/username/dir/subdir/somefile.d.ts                                                      | /user/username/dir/subdir                                                                    | false     |                                                                                              |
| /user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                              |
| /usr/dir/subdir/somefile.d.ts                                                                | /usr/dir/subdir                                                                              | false     |                                                                                              |
| /usr/username/dir/subdir/somefile.d.ts                                                       | /usr/username/dir/subdir                                                                     | false     |                                                                                              |
| /usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                              |
| /home/dir/subdir/somefile.d.ts                                                               | /home/dir/subdir                                                                             | false     |                                                                                              |
| /home/username/dir/subdir/somefile.d.ts                                                      | /home/username/dir/subdir                                                                    | false     |                                                                                              |
| /home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                              |
| /workspaces/dir/subdir/somefile.d.ts                                                         | /workspaces/dir/subdir                                                                       | false     |                                                                                              |
| /workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | /workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | /workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | /workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | /workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                              |

## RootDirForResolution: /user

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /dir/subdir/somefile.d.ts                                                                    |                                                                                              |           |                                                                                              |
| /folderAtRoot/dir/subdir/somefile.d.ts                                                       | /folderAtRoot/dir/subdir                                                                     | false     |                                                                                              |
| /folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | /folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                              |
| /users/dir/subdir/somefile.d.ts                                                              | /users/dir/subdir                                                                            | false     |                                                                                              |
| /users/username/dir/subdir/somefile.d.ts                                                     | /users/username/dir/subdir                                                                   | false     |                                                                                              |
| /users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                              |
| /user/dir/subdir/somefile.d.ts                                                               | /user/dir/subdir                                                                             | false     |                                                                                              |
| /user/username/dir/subdir/somefile.d.ts                                                      | /user/username/dir/subdir                                                                    | false     |                                                                                              |
| /user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                              |
| /usr/dir/subdir/somefile.d.ts                                                                | /usr/dir/subdir                                                                              | false     |                                                                                              |
| /usr/username/dir/subdir/somefile.d.ts                                                       | /usr/username/dir/subdir                                                                     | false     |                                                                                              |
| /usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                              |
| /home/dir/subdir/somefile.d.ts                                                               | /home/dir/subdir                                                                             | false     |                                                                                              |
| /home/username/dir/subdir/somefile.d.ts                                                      | /home/username/dir/subdir                                                                    | false     |                                                                                              |
| /home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                              |
| /workspaces/dir/subdir/somefile.d.ts                                                         | /workspaces/dir/subdir                                                                       | false     |                                                                                              |
| /workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | /workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | /workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | /workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | /workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                              |

## RootDirForResolution: /user/username

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /dir/subdir/somefile.d.ts                                                                    |                                                                                              |           |                                                                                              |
| /folderAtRoot/dir/subdir/somefile.d.ts                                                       | /folderAtRoot/dir/subdir                                                                     | false     |                                                                                              |
| /folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | /folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                              |
| /users/dir/subdir/somefile.d.ts                                                              | /users/dir/subdir                                                                            | false     |                                                                                              |
| /users/username/dir/subdir/somefile.d.ts                                                     | /users/username/dir/subdir                                                                   | false     |                                                                                              |
| /users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                              |
| /user/dir/subdir/somefile.d.ts                                                               | /user/dir/subdir                                                                             | false     |                                                                                              |
| /user/username/dir/subdir/somefile.d.ts                                                      | /user/username/dir/subdir                                                                    | false     |                                                                                              |
| /user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                              |
| /usr/dir/subdir/somefile.d.ts                                                                | /usr/dir/subdir                                                                              | false     |                                                                                              |
| /usr/username/dir/subdir/somefile.d.ts                                                       | /usr/username/dir/subdir                                                                     | false     |                                                                                              |
| /usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                              |
| /home/dir/subdir/somefile.d.ts                                                               | /home/dir/subdir                                                                             | false     |                                                                                              |
| /home/username/dir/subdir/somefile.d.ts                                                      | /home/username/dir/subdir                                                                    | false     |                                                                                              |
| /home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                              |
| /workspaces/dir/subdir/somefile.d.ts                                                         | /workspaces/dir/subdir                                                                       | false     |                                                                                              |
| /workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | /workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | /workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | /workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | /workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                              |

## RootDirForResolution: /user/username/folderAtRoot

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /dir/subdir/somefile.d.ts                                                                    |                                                                                              |           |                                                                                              |
| /folderAtRoot/dir/subdir/somefile.d.ts                                                       | /folderAtRoot/dir/subdir                                                                     | false     |                                                                                              |
| /folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | /folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                              |
| /users/dir/subdir/somefile.d.ts                                                              | /users/dir/subdir                                                                            | false     |                                                                                              |
| /users/username/dir/subdir/somefile.d.ts                                                     | /users/username/dir/subdir                                                                   | false     |                                                                                              |
| /users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                              |
| /user/dir/subdir/somefile.d.ts                                                               | /user/dir/subdir                                                                             | false     |                                                                                              |
| /user/username/dir/subdir/somefile.d.ts                                                      | /user/username/dir/subdir                                                                    | false     |                                                                                              |
| /user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                              |
| /usr/dir/subdir/somefile.d.ts                                                                | /usr/dir/subdir                                                                              | false     |                                                                                              |
| /usr/username/dir/subdir/somefile.d.ts                                                       | /usr/username/dir/subdir                                                                     | false     |                                                                                              |
| /usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                              |
| /home/dir/subdir/somefile.d.ts                                                               | /home/dir/subdir                                                                             | false     |                                                                                              |
| /home/username/dir/subdir/somefile.d.ts                                                      | /home/username/dir/subdir                                                                    | false     |                                                                                              |
| /home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                              |
| /workspaces/dir/subdir/somefile.d.ts                                                         | /workspaces/dir/subdir                                                                       | false     |                                                                                              |
| /workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | /workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | /workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | /workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | /workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                              |

## RootDirForResolution: /user/username/folderAtRoot/folder1

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /dir/subdir/somefile.d.ts                                                                    |                                                                                              |           |                                                                                              |
| /folderAtRoot/dir/subdir/somefile.d.ts                                                       | /folderAtRoot/dir/subdir                                                                     | false     |                                                                                              |
| /folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | /folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                              |
| /users/dir/subdir/somefile.d.ts                                                              | /users/dir/subdir                                                                            | false     |                                                                                              |
| /users/username/dir/subdir/somefile.d.ts                                                     | /users/username/dir/subdir                                                                   | false     |                                                                                              |
| /users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                              |
| /user/dir/subdir/somefile.d.ts                                                               | /user/dir/subdir                                                                             | false     |                                                                                              |
| /user/username/dir/subdir/somefile.d.ts                                                      | /user/username/dir/subdir                                                                    | false     |                                                                                              |
| /user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot/folder1/dir                                                      | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot/folder1/folder2                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot/folder1/folder2                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot/folder1/folder2                                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /user/username/folderAtRoot/folder1/folder2                                                  | true      |                                                                                              |
| /usr/dir/subdir/somefile.d.ts                                                                | /usr/dir/subdir                                                                              | false     |                                                                                              |
| /usr/username/dir/subdir/somefile.d.ts                                                       | /usr/username/dir/subdir                                                                     | false     |                                                                                              |
| /usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                              |
| /home/dir/subdir/somefile.d.ts                                                               | /home/dir/subdir                                                                             | false     |                                                                                              |
| /home/username/dir/subdir/somefile.d.ts                                                      | /home/username/dir/subdir                                                                    | false     |                                                                                              |
| /home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                              |
| /workspaces/dir/subdir/somefile.d.ts                                                         | /workspaces/dir/subdir                                                                       | false     |                                                                                              |
| /workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | /workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | /workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | /workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | /workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                              |

## RootDirForResolution: /user/username/folderAtRoot/folder1/folder2

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /dir/subdir/somefile.d.ts                                                                    |                                                                                              |           |                                                                                              |
| /folderAtRoot/dir/subdir/somefile.d.ts                                                       | /folderAtRoot/dir/subdir                                                                     | false     |                                                                                              |
| /folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | /folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                              |
| /users/dir/subdir/somefile.d.ts                                                              | /users/dir/subdir                                                                            | false     |                                                                                              |
| /users/username/dir/subdir/somefile.d.ts                                                     | /users/username/dir/subdir                                                                   | false     |                                                                                              |
| /users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                              |
| /user/dir/subdir/somefile.d.ts                                                               | /user/dir/subdir                                                                             | false     |                                                                                              |
| /user/username/dir/subdir/somefile.d.ts                                                      | /user/username/dir/subdir                                                                    | false     |                                                                                              |
| /user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot/folder1/folder2/dir                                              | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot/folder1/folder2/folder3                                          | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot/folder1/folder2/folder3                                          | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /user/username/folderAtRoot/folder1/folder2/folder3                                          | true      |                                                                                              |
| /usr/dir/subdir/somefile.d.ts                                                                | /usr/dir/subdir                                                                              | false     |                                                                                              |
| /usr/username/dir/subdir/somefile.d.ts                                                       | /usr/username/dir/subdir                                                                     | false     |                                                                                              |
| /usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                              |
| /home/dir/subdir/somefile.d.ts                                                               | /home/dir/subdir                                                                             | false     |                                                                                              |
| /home/username/dir/subdir/somefile.d.ts                                                      | /home/username/dir/subdir                                                                    | false     |                                                                                              |
| /home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                              |
| /workspaces/dir/subdir/somefile.d.ts                                                         | /workspaces/dir/subdir                                                                       | false     |                                                                                              |
| /workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | /workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | /workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | /workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | /workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                              |

## RootDirForResolution: /user/username/folderAtRoot/folder1/folder2/folder3

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /dir/subdir/somefile.d.ts                                                                    |                                                                                              |           |                                                                                              |
| /folderAtRoot/dir/subdir/somefile.d.ts                                                       | /folderAtRoot/dir/subdir                                                                     | false     |                                                                                              |
| /folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | /folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                              |
| /users/dir/subdir/somefile.d.ts                                                              | /users/dir/subdir                                                                            | false     |                                                                                              |
| /users/username/dir/subdir/somefile.d.ts                                                     | /users/username/dir/subdir                                                                   | false     |                                                                                              |
| /users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                              |
| /user/dir/subdir/somefile.d.ts                                                               | /user/dir/subdir                                                                             | false     |                                                                                              |
| /user/username/dir/subdir/somefile.d.ts                                                      | /user/username/dir/subdir                                                                    | false     |                                                                                              |
| /user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot/folder1/folder2/folder3/dir                                      | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | true      |                                                                                              |
| /usr/dir/subdir/somefile.d.ts                                                                | /usr/dir/subdir                                                                              | false     |                                                                                              |
| /usr/username/dir/subdir/somefile.d.ts                                                       | /usr/username/dir/subdir                                                                     | false     |                                                                                              |
| /usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                              |
| /home/dir/subdir/somefile.d.ts                                                               | /home/dir/subdir                                                                             | false     |                                                                                              |
| /home/username/dir/subdir/somefile.d.ts                                                      | /home/username/dir/subdir                                                                    | false     |                                                                                              |
| /home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                              |
| /workspaces/dir/subdir/somefile.d.ts                                                         | /workspaces/dir/subdir                                                                       | false     |                                                                                              |
| /workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | /workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | /workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | /workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | /workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                              |

## RootDirForResolution: /user/username/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /dir/subdir/somefile.d.ts                                                                    |                                                                                              |           |                                                                                              |
| /folderAtRoot/dir/subdir/somefile.d.ts                                                       | /folderAtRoot/dir/subdir                                                                     | false     |                                                                                              |
| /folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | /folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                              |
| /users/dir/subdir/somefile.d.ts                                                              | /users/dir/subdir                                                                            | false     |                                                                                              |
| /users/username/dir/subdir/somefile.d.ts                                                     | /users/username/dir/subdir                                                                   | false     |                                                                                              |
| /users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                              |
| /user/dir/subdir/somefile.d.ts                                                               | /user/dir/subdir                                                                             | false     |                                                                                              |
| /user/username/dir/subdir/somefile.d.ts                                                      | /user/username/dir/subdir                                                                    | false     |                                                                                              |
| /user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | true      |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | true      |                                                                                              |
| /usr/dir/subdir/somefile.d.ts                                                                | /usr/dir/subdir                                                                              | false     |                                                                                              |
| /usr/username/dir/subdir/somefile.d.ts                                                       | /usr/username/dir/subdir                                                                     | false     |                                                                                              |
| /usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                              |
| /home/dir/subdir/somefile.d.ts                                                               | /home/dir/subdir                                                                             | false     |                                                                                              |
| /home/username/dir/subdir/somefile.d.ts                                                      | /home/username/dir/subdir                                                                    | false     |                                                                                              |
| /home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                              |
| /workspaces/dir/subdir/somefile.d.ts                                                         | /workspaces/dir/subdir                                                                       | false     |                                                                                              |
| /workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | /workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | /workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | /workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | /workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                              |

## RootDirForResolution: /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /dir/subdir/somefile.d.ts                                                                    |                                                                                              |           |                                                                                              |
| /folderAtRoot/dir/subdir/somefile.d.ts                                                       | /folderAtRoot/dir/subdir                                                                     | false     |                                                                                              |
| /folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | /folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                              |
| /users/dir/subdir/somefile.d.ts                                                              | /users/dir/subdir                                                                            | false     |                                                                                              |
| /users/username/dir/subdir/somefile.d.ts                                                     | /users/username/dir/subdir                                                                   | false     |                                                                                              |
| /users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                              |
| /user/dir/subdir/somefile.d.ts                                                               | /user/dir/subdir                                                                             | false     |                                                                                              |
| /user/username/dir/subdir/somefile.d.ts                                                      | /user/username/dir/subdir                                                                    | false     |                                                                                              |
| /user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | true      |                                                                                              |
| /usr/dir/subdir/somefile.d.ts                                                                | /usr/dir/subdir                                                                              | false     |                                                                                              |
| /usr/username/dir/subdir/somefile.d.ts                                                       | /usr/username/dir/subdir                                                                     | false     |                                                                                              |
| /usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                              |
| /home/dir/subdir/somefile.d.ts                                                               | /home/dir/subdir                                                                             | false     |                                                                                              |
| /home/username/dir/subdir/somefile.d.ts                                                      | /home/username/dir/subdir                                                                    | false     |                                                                                              |
| /home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                              |
| /workspaces/dir/subdir/somefile.d.ts                                                         | /workspaces/dir/subdir                                                                       | false     |                                                                                              |
| /workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | /workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | /workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | /workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | /workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                              |

## RootDirForResolution: /usr

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /dir/subdir/somefile.d.ts                                                                    |                                                                                              |           |                                                                                              |
| /folderAtRoot/dir/subdir/somefile.d.ts                                                       | /folderAtRoot/dir/subdir                                                                     | false     |                                                                                              |
| /folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | /folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                              |
| /users/dir/subdir/somefile.d.ts                                                              | /users/dir/subdir                                                                            | false     |                                                                                              |
| /users/username/dir/subdir/somefile.d.ts                                                     | /users/username/dir/subdir                                                                   | false     |                                                                                              |
| /users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                              |
| /user/dir/subdir/somefile.d.ts                                                               | /user/dir/subdir                                                                             | false     |                                                                                              |
| /user/username/dir/subdir/somefile.d.ts                                                      | /user/username/dir/subdir                                                                    | false     |                                                                                              |
| /user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                              |
| /usr/dir/subdir/somefile.d.ts                                                                | /usr/dir/subdir                                                                              | false     |                                                                                              |
| /usr/username/dir/subdir/somefile.d.ts                                                       | /usr/username/dir/subdir                                                                     | false     |                                                                                              |
| /usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                              |
| /home/dir/subdir/somefile.d.ts                                                               | /home/dir/subdir                                                                             | false     |                                                                                              |
| /home/username/dir/subdir/somefile.d.ts                                                      | /home/username/dir/subdir                                                                    | false     |                                                                                              |
| /home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                              |
| /workspaces/dir/subdir/somefile.d.ts                                                         | /workspaces/dir/subdir                                                                       | false     |                                                                                              |
| /workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | /workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | /workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | /workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | /workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                              |

## RootDirForResolution: /usr/username

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /dir/subdir/somefile.d.ts                                                                    |                                                                                              |           |                                                                                              |
| /folderAtRoot/dir/subdir/somefile.d.ts                                                       | /folderAtRoot/dir/subdir                                                                     | false     |                                                                                              |
| /folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | /folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                              |
| /users/dir/subdir/somefile.d.ts                                                              | /users/dir/subdir                                                                            | false     |                                                                                              |
| /users/username/dir/subdir/somefile.d.ts                                                     | /users/username/dir/subdir                                                                   | false     |                                                                                              |
| /users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                              |
| /user/dir/subdir/somefile.d.ts                                                               | /user/dir/subdir                                                                             | false     |                                                                                              |
| /user/username/dir/subdir/somefile.d.ts                                                      | /user/username/dir/subdir                                                                    | false     |                                                                                              |
| /user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                              |
| /usr/dir/subdir/somefile.d.ts                                                                | /usr/dir/subdir                                                                              | false     |                                                                                              |
| /usr/username/dir/subdir/somefile.d.ts                                                       | /usr/username/dir/subdir                                                                     | false     |                                                                                              |
| /usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                              |
| /home/dir/subdir/somefile.d.ts                                                               | /home/dir/subdir                                                                             | false     |                                                                                              |
| /home/username/dir/subdir/somefile.d.ts                                                      | /home/username/dir/subdir                                                                    | false     |                                                                                              |
| /home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                              |
| /workspaces/dir/subdir/somefile.d.ts                                                         | /workspaces/dir/subdir                                                                       | false     |                                                                                              |
| /workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | /workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | /workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | /workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | /workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                              |

## RootDirForResolution: /usr/username/folderAtRoot

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /dir/subdir/somefile.d.ts                                                                    |                                                                                              |           |                                                                                              |
| /folderAtRoot/dir/subdir/somefile.d.ts                                                       | /folderAtRoot/dir/subdir                                                                     | false     |                                                                                              |
| /folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | /folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                              |
| /users/dir/subdir/somefile.d.ts                                                              | /users/dir/subdir                                                                            | false     |                                                                                              |
| /users/username/dir/subdir/somefile.d.ts                                                     | /users/username/dir/subdir                                                                   | false     |                                                                                              |
| /users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                              |
| /user/dir/subdir/somefile.d.ts                                                               | /user/dir/subdir                                                                             | false     |                                                                                              |
| /user/username/dir/subdir/somefile.d.ts                                                      | /user/username/dir/subdir                                                                    | false     |                                                                                              |
| /user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                              |
| /usr/dir/subdir/somefile.d.ts                                                                | /usr/dir/subdir                                                                              | false     |                                                                                              |
| /usr/username/dir/subdir/somefile.d.ts                                                       | /usr/username/dir/subdir                                                                     | false     |                                                                                              |
| /usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                              |
| /home/dir/subdir/somefile.d.ts                                                               | /home/dir/subdir                                                                             | false     |                                                                                              |
| /home/username/dir/subdir/somefile.d.ts                                                      | /home/username/dir/subdir                                                                    | false     |                                                                                              |
| /home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                              |
| /workspaces/dir/subdir/somefile.d.ts                                                         | /workspaces/dir/subdir                                                                       | false     |                                                                                              |
| /workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | /workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | /workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | /workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | /workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                              |

## RootDirForResolution: /usr/username/folderAtRoot/folder1

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /dir/subdir/somefile.d.ts                                                                    |                                                                                              |           |                                                                                              |
| /folderAtRoot/dir/subdir/somefile.d.ts                                                       | /folderAtRoot/dir/subdir                                                                     | false     |                                                                                              |
| /folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | /folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                              |
| /users/dir/subdir/somefile.d.ts                                                              | /users/dir/subdir                                                                            | false     |                                                                                              |
| /users/username/dir/subdir/somefile.d.ts                                                     | /users/username/dir/subdir                                                                   | false     |                                                                                              |
| /users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                              |
| /user/dir/subdir/somefile.d.ts                                                               | /user/dir/subdir                                                                             | false     |                                                                                              |
| /user/username/dir/subdir/somefile.d.ts                                                      | /user/username/dir/subdir                                                                    | false     |                                                                                              |
| /user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                              |
| /usr/dir/subdir/somefile.d.ts                                                                | /usr/dir/subdir                                                                              | false     |                                                                                              |
| /usr/username/dir/subdir/somefile.d.ts                                                       | /usr/username/dir/subdir                                                                     | false     |                                                                                              |
| /usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot/folder1/dir                                                       | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot/folder1/folder2                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot/folder1/folder2                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot/folder1/folder2                                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot/folder1/folder2                                                   | true      |                                                                                              |
| /home/dir/subdir/somefile.d.ts                                                               | /home/dir/subdir                                                                             | false     |                                                                                              |
| /home/username/dir/subdir/somefile.d.ts                                                      | /home/username/dir/subdir                                                                    | false     |                                                                                              |
| /home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                              |
| /workspaces/dir/subdir/somefile.d.ts                                                         | /workspaces/dir/subdir                                                                       | false     |                                                                                              |
| /workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | /workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | /workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | /workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | /workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                              |

## RootDirForResolution: /usr/username/folderAtRoot/folder1/folder2

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /dir/subdir/somefile.d.ts                                                                    |                                                                                              |           |                                                                                              |
| /folderAtRoot/dir/subdir/somefile.d.ts                                                       | /folderAtRoot/dir/subdir                                                                     | false     |                                                                                              |
| /folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | /folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                              |
| /users/dir/subdir/somefile.d.ts                                                              | /users/dir/subdir                                                                            | false     |                                                                                              |
| /users/username/dir/subdir/somefile.d.ts                                                     | /users/username/dir/subdir                                                                   | false     |                                                                                              |
| /users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                              |
| /user/dir/subdir/somefile.d.ts                                                               | /user/dir/subdir                                                                             | false     |                                                                                              |
| /user/username/dir/subdir/somefile.d.ts                                                      | /user/username/dir/subdir                                                                    | false     |                                                                                              |
| /user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                              |
| /usr/dir/subdir/somefile.d.ts                                                                | /usr/dir/subdir                                                                              | false     |                                                                                              |
| /usr/username/dir/subdir/somefile.d.ts                                                       | /usr/username/dir/subdir                                                                     | false     |                                                                                              |
| /usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot/folder1/folder2/dir                                               | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot/folder1/folder2/folder3                                           | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot/folder1/folder2/folder3                                           | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot/folder1/folder2/folder3                                           | true      |                                                                                              |
| /home/dir/subdir/somefile.d.ts                                                               | /home/dir/subdir                                                                             | false     |                                                                                              |
| /home/username/dir/subdir/somefile.d.ts                                                      | /home/username/dir/subdir                                                                    | false     |                                                                                              |
| /home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                              |
| /workspaces/dir/subdir/somefile.d.ts                                                         | /workspaces/dir/subdir                                                                       | false     |                                                                                              |
| /workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | /workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | /workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | /workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | /workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                              |

## RootDirForResolution: /usr/username/folderAtRoot/folder1/folder2/folder3

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /dir/subdir/somefile.d.ts                                                                    |                                                                                              |           |                                                                                              |
| /folderAtRoot/dir/subdir/somefile.d.ts                                                       | /folderAtRoot/dir/subdir                                                                     | false     |                                                                                              |
| /folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | /folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                              |
| /users/dir/subdir/somefile.d.ts                                                              | /users/dir/subdir                                                                            | false     |                                                                                              |
| /users/username/dir/subdir/somefile.d.ts                                                     | /users/username/dir/subdir                                                                   | false     |                                                                                              |
| /users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                              |
| /user/dir/subdir/somefile.d.ts                                                               | /user/dir/subdir                                                                             | false     |                                                                                              |
| /user/username/dir/subdir/somefile.d.ts                                                      | /user/username/dir/subdir                                                                    | false     |                                                                                              |
| /user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                              |
| /usr/dir/subdir/somefile.d.ts                                                                | /usr/dir/subdir                                                                              | false     |                                                                                              |
| /usr/username/dir/subdir/somefile.d.ts                                                       | /usr/username/dir/subdir                                                                     | false     |                                                                                              |
| /usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot/folder1/folder2/folder3/dir                                       | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | true      |                                                                                              |
| /home/dir/subdir/somefile.d.ts                                                               | /home/dir/subdir                                                                             | false     |                                                                                              |
| /home/username/dir/subdir/somefile.d.ts                                                      | /home/username/dir/subdir                                                                    | false     |                                                                                              |
| /home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                              |
| /workspaces/dir/subdir/somefile.d.ts                                                         | /workspaces/dir/subdir                                                                       | false     |                                                                                              |
| /workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | /workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | /workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | /workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | /workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                              |

## RootDirForResolution: /usr/username/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /dir/subdir/somefile.d.ts                                                                    |                                                                                              |           |                                                                                              |
| /folderAtRoot/dir/subdir/somefile.d.ts                                                       | /folderAtRoot/dir/subdir                                                                     | false     |                                                                                              |
| /folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | /folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                              |
| /users/dir/subdir/somefile.d.ts                                                              | /users/dir/subdir                                                                            | false     |                                                                                              |
| /users/username/dir/subdir/somefile.d.ts                                                     | /users/username/dir/subdir                                                                   | false     |                                                                                              |
| /users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                              |
| /user/dir/subdir/somefile.d.ts                                                               | /user/dir/subdir                                                                             | false     |                                                                                              |
| /user/username/dir/subdir/somefile.d.ts                                                      | /user/username/dir/subdir                                                                    | false     |                                                                                              |
| /user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                              |
| /usr/dir/subdir/somefile.d.ts                                                                | /usr/dir/subdir                                                                              | false     |                                                                                              |
| /usr/username/dir/subdir/somefile.d.ts                                                       | /usr/username/dir/subdir                                                                     | false     |                                                                                              |
| /usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                               | true      |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | true      |                                                                                              |
| /home/dir/subdir/somefile.d.ts                                                               | /home/dir/subdir                                                                             | false     |                                                                                              |
| /home/username/dir/subdir/somefile.d.ts                                                      | /home/username/dir/subdir                                                                    | false     |                                                                                              |
| /home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                              |
| /workspaces/dir/subdir/somefile.d.ts                                                         | /workspaces/dir/subdir                                                                       | false     |                                                                                              |
| /workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | /workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | /workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | /workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | /workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                              |

## RootDirForResolution: /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /dir/subdir/somefile.d.ts                                                                    |                                                                                              |           |                                                                                              |
| /folderAtRoot/dir/subdir/somefile.d.ts                                                       | /folderAtRoot/dir/subdir                                                                     | false     |                                                                                              |
| /folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | /folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                              |
| /users/dir/subdir/somefile.d.ts                                                              | /users/dir/subdir                                                                            | false     |                                                                                              |
| /users/username/dir/subdir/somefile.d.ts                                                     | /users/username/dir/subdir                                                                   | false     |                                                                                              |
| /users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                              |
| /user/dir/subdir/somefile.d.ts                                                               | /user/dir/subdir                                                                             | false     |                                                                                              |
| /user/username/dir/subdir/somefile.d.ts                                                      | /user/username/dir/subdir                                                                    | false     |                                                                                              |
| /user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                              |
| /usr/dir/subdir/somefile.d.ts                                                                | /usr/dir/subdir                                                                              | false     |                                                                                              |
| /usr/username/dir/subdir/somefile.d.ts                                                       | /usr/username/dir/subdir                                                                     | false     |                                                                                              |
| /usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                       | true      |                                                                                              |
| /home/dir/subdir/somefile.d.ts                                                               | /home/dir/subdir                                                                             | false     |                                                                                              |
| /home/username/dir/subdir/somefile.d.ts                                                      | /home/username/dir/subdir                                                                    | false     |                                                                                              |
| /home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                              |
| /workspaces/dir/subdir/somefile.d.ts                                                         | /workspaces/dir/subdir                                                                       | false     |                                                                                              |
| /workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | /workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | /workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | /workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | /workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                              |

## RootDirForResolution: /home

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /dir/subdir/somefile.d.ts                                                                    |                                                                                              |           |                                                                                              |
| /folderAtRoot/dir/subdir/somefile.d.ts                                                       | /folderAtRoot/dir/subdir                                                                     | false     |                                                                                              |
| /folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | /folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                              |
| /users/dir/subdir/somefile.d.ts                                                              | /users/dir/subdir                                                                            | false     |                                                                                              |
| /users/username/dir/subdir/somefile.d.ts                                                     | /users/username/dir/subdir                                                                   | false     |                                                                                              |
| /users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                              |
| /user/dir/subdir/somefile.d.ts                                                               | /user/dir/subdir                                                                             | false     |                                                                                              |
| /user/username/dir/subdir/somefile.d.ts                                                      | /user/username/dir/subdir                                                                    | false     |                                                                                              |
| /user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                              |
| /usr/dir/subdir/somefile.d.ts                                                                | /usr/dir/subdir                                                                              | false     |                                                                                              |
| /usr/username/dir/subdir/somefile.d.ts                                                       | /usr/username/dir/subdir                                                                     | false     |                                                                                              |
| /usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                              |
| /home/dir/subdir/somefile.d.ts                                                               | /home/dir/subdir                                                                             | false     |                                                                                              |
| /home/username/dir/subdir/somefile.d.ts                                                      | /home/username/dir/subdir                                                                    | false     |                                                                                              |
| /home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                              |
| /workspaces/dir/subdir/somefile.d.ts                                                         | /workspaces/dir/subdir                                                                       | false     |                                                                                              |
| /workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | /workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | /workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | /workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | /workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                              |

## RootDirForResolution: /home/username

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /dir/subdir/somefile.d.ts                                                                    |                                                                                              |           |                                                                                              |
| /folderAtRoot/dir/subdir/somefile.d.ts                                                       | /folderAtRoot/dir/subdir                                                                     | false     |                                                                                              |
| /folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | /folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                              |
| /users/dir/subdir/somefile.d.ts                                                              | /users/dir/subdir                                                                            | false     |                                                                                              |
| /users/username/dir/subdir/somefile.d.ts                                                     | /users/username/dir/subdir                                                                   | false     |                                                                                              |
| /users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                              |
| /user/dir/subdir/somefile.d.ts                                                               | /user/dir/subdir                                                                             | false     |                                                                                              |
| /user/username/dir/subdir/somefile.d.ts                                                      | /user/username/dir/subdir                                                                    | false     |                                                                                              |
| /user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                              |
| /usr/dir/subdir/somefile.d.ts                                                                | /usr/dir/subdir                                                                              | false     |                                                                                              |
| /usr/username/dir/subdir/somefile.d.ts                                                       | /usr/username/dir/subdir                                                                     | false     |                                                                                              |
| /usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                              |
| /home/dir/subdir/somefile.d.ts                                                               | /home/dir/subdir                                                                             | false     |                                                                                              |
| /home/username/dir/subdir/somefile.d.ts                                                      | /home/username/dir/subdir                                                                    | false     |                                                                                              |
| /home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                              |
| /workspaces/dir/subdir/somefile.d.ts                                                         | /workspaces/dir/subdir                                                                       | false     |                                                                                              |
| /workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | /workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | /workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | /workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | /workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                              |

## RootDirForResolution: /home/username/folderAtRoot

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /dir/subdir/somefile.d.ts                                                                    |                                                                                              |           |                                                                                              |
| /folderAtRoot/dir/subdir/somefile.d.ts                                                       | /folderAtRoot/dir/subdir                                                                     | false     |                                                                                              |
| /folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | /folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                              |
| /users/dir/subdir/somefile.d.ts                                                              | /users/dir/subdir                                                                            | false     |                                                                                              |
| /users/username/dir/subdir/somefile.d.ts                                                     | /users/username/dir/subdir                                                                   | false     |                                                                                              |
| /users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                              |
| /user/dir/subdir/somefile.d.ts                                                               | /user/dir/subdir                                                                             | false     |                                                                                              |
| /user/username/dir/subdir/somefile.d.ts                                                      | /user/username/dir/subdir                                                                    | false     |                                                                                              |
| /user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                              |
| /usr/dir/subdir/somefile.d.ts                                                                | /usr/dir/subdir                                                                              | false     |                                                                                              |
| /usr/username/dir/subdir/somefile.d.ts                                                       | /usr/username/dir/subdir                                                                     | false     |                                                                                              |
| /usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                              |
| /home/dir/subdir/somefile.d.ts                                                               | /home/dir/subdir                                                                             | false     |                                                                                              |
| /home/username/dir/subdir/somefile.d.ts                                                      | /home/username/dir/subdir                                                                    | false     |                                                                                              |
| /home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                              |
| /workspaces/dir/subdir/somefile.d.ts                                                         | /workspaces/dir/subdir                                                                       | false     |                                                                                              |
| /workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | /workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | /workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | /workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | /workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                              |

## RootDirForResolution: /home/username/folderAtRoot/folder1

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /dir/subdir/somefile.d.ts                                                                    |                                                                                              |           |                                                                                              |
| /folderAtRoot/dir/subdir/somefile.d.ts                                                       | /folderAtRoot/dir/subdir                                                                     | false     |                                                                                              |
| /folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | /folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                              |
| /users/dir/subdir/somefile.d.ts                                                              | /users/dir/subdir                                                                            | false     |                                                                                              |
| /users/username/dir/subdir/somefile.d.ts                                                     | /users/username/dir/subdir                                                                   | false     |                                                                                              |
| /users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                              |
| /user/dir/subdir/somefile.d.ts                                                               | /user/dir/subdir                                                                             | false     |                                                                                              |
| /user/username/dir/subdir/somefile.d.ts                                                      | /user/username/dir/subdir                                                                    | false     |                                                                                              |
| /user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                              |
| /usr/dir/subdir/somefile.d.ts                                                                | /usr/dir/subdir                                                                              | false     |                                                                                              |
| /usr/username/dir/subdir/somefile.d.ts                                                       | /usr/username/dir/subdir                                                                     | false     |                                                                                              |
| /usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                              |
| /home/dir/subdir/somefile.d.ts                                                               | /home/dir/subdir                                                                             | false     |                                                                                              |
| /home/username/dir/subdir/somefile.d.ts                                                      | /home/username/dir/subdir                                                                    | false     |                                                                                              |
| /home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot/folder1/dir                                                      | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot/folder1/folder2                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot/folder1/folder2                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot/folder1/folder2                                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /home/username/folderAtRoot/folder1/folder2                                                  | true      |                                                                                              |
| /workspaces/dir/subdir/somefile.d.ts                                                         | /workspaces/dir/subdir                                                                       | false     |                                                                                              |
| /workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | /workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | /workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | /workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | /workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                              |

## RootDirForResolution: /home/username/folderAtRoot/folder1/folder2

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /dir/subdir/somefile.d.ts                                                                    |                                                                                              |           |                                                                                              |
| /folderAtRoot/dir/subdir/somefile.d.ts                                                       | /folderAtRoot/dir/subdir                                                                     | false     |                                                                                              |
| /folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | /folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                              |
| /users/dir/subdir/somefile.d.ts                                                              | /users/dir/subdir                                                                            | false     |                                                                                              |
| /users/username/dir/subdir/somefile.d.ts                                                     | /users/username/dir/subdir                                                                   | false     |                                                                                              |
| /users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                              |
| /user/dir/subdir/somefile.d.ts                                                               | /user/dir/subdir                                                                             | false     |                                                                                              |
| /user/username/dir/subdir/somefile.d.ts                                                      | /user/username/dir/subdir                                                                    | false     |                                                                                              |
| /user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                              |
| /usr/dir/subdir/somefile.d.ts                                                                | /usr/dir/subdir                                                                              | false     |                                                                                              |
| /usr/username/dir/subdir/somefile.d.ts                                                       | /usr/username/dir/subdir                                                                     | false     |                                                                                              |
| /usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                              |
| /home/dir/subdir/somefile.d.ts                                                               | /home/dir/subdir                                                                             | false     |                                                                                              |
| /home/username/dir/subdir/somefile.d.ts                                                      | /home/username/dir/subdir                                                                    | false     |                                                                                              |
| /home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot/folder1/folder2/dir                                              | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot/folder1/folder2/folder3                                          | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot/folder1/folder2/folder3                                          | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /home/username/folderAtRoot/folder1/folder2/folder3                                          | true      |                                                                                              |
| /workspaces/dir/subdir/somefile.d.ts                                                         | /workspaces/dir/subdir                                                                       | false     |                                                                                              |
| /workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | /workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | /workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | /workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | /workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                              |

## RootDirForResolution: /home/username/folderAtRoot/folder1/folder2/folder3

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /dir/subdir/somefile.d.ts                                                                    |                                                                                              |           |                                                                                              |
| /folderAtRoot/dir/subdir/somefile.d.ts                                                       | /folderAtRoot/dir/subdir                                                                     | false     |                                                                                              |
| /folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | /folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                              |
| /users/dir/subdir/somefile.d.ts                                                              | /users/dir/subdir                                                                            | false     |                                                                                              |
| /users/username/dir/subdir/somefile.d.ts                                                     | /users/username/dir/subdir                                                                   | false     |                                                                                              |
| /users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                              |
| /user/dir/subdir/somefile.d.ts                                                               | /user/dir/subdir                                                                             | false     |                                                                                              |
| /user/username/dir/subdir/somefile.d.ts                                                      | /user/username/dir/subdir                                                                    | false     |                                                                                              |
| /user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                              |
| /usr/dir/subdir/somefile.d.ts                                                                | /usr/dir/subdir                                                                              | false     |                                                                                              |
| /usr/username/dir/subdir/somefile.d.ts                                                       | /usr/username/dir/subdir                                                                     | false     |                                                                                              |
| /usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                              |
| /home/dir/subdir/somefile.d.ts                                                               | /home/dir/subdir                                                                             | false     |                                                                                              |
| /home/username/dir/subdir/somefile.d.ts                                                      | /home/username/dir/subdir                                                                    | false     |                                                                                              |
| /home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot/folder1/folder2/folder3/dir                                      | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | true      |                                                                                              |
| /workspaces/dir/subdir/somefile.d.ts                                                         | /workspaces/dir/subdir                                                                       | false     |                                                                                              |
| /workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | /workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | /workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | /workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | /workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                              |

## RootDirForResolution: /home/username/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /dir/subdir/somefile.d.ts                                                                    |                                                                                              |           |                                                                                              |
| /folderAtRoot/dir/subdir/somefile.d.ts                                                       | /folderAtRoot/dir/subdir                                                                     | false     |                                                                                              |
| /folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | /folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                              |
| /users/dir/subdir/somefile.d.ts                                                              | /users/dir/subdir                                                                            | false     |                                                                                              |
| /users/username/dir/subdir/somefile.d.ts                                                     | /users/username/dir/subdir                                                                   | false     |                                                                                              |
| /users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                              |
| /user/dir/subdir/somefile.d.ts                                                               | /user/dir/subdir                                                                             | false     |                                                                                              |
| /user/username/dir/subdir/somefile.d.ts                                                      | /user/username/dir/subdir                                                                    | false     |                                                                                              |
| /user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                              |
| /usr/dir/subdir/somefile.d.ts                                                                | /usr/dir/subdir                                                                              | false     |                                                                                              |
| /usr/username/dir/subdir/somefile.d.ts                                                       | /usr/username/dir/subdir                                                                     | false     |                                                                                              |
| /usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                              |
| /home/dir/subdir/somefile.d.ts                                                               | /home/dir/subdir                                                                             | false     |                                                                                              |
| /home/username/dir/subdir/somefile.d.ts                                                      | /home/username/dir/subdir                                                                    | false     |                                                                                              |
| /home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | true      |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | true      |                                                                                              |
| /workspaces/dir/subdir/somefile.d.ts                                                         | /workspaces/dir/subdir                                                                       | false     |                                                                                              |
| /workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | /workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | /workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | /workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | /workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                              |

## RootDirForResolution: /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /dir/subdir/somefile.d.ts                                                                    |                                                                                              |           |                                                                                              |
| /folderAtRoot/dir/subdir/somefile.d.ts                                                       | /folderAtRoot/dir/subdir                                                                     | false     |                                                                                              |
| /folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | /folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                              |
| /users/dir/subdir/somefile.d.ts                                                              | /users/dir/subdir                                                                            | false     |                                                                                              |
| /users/username/dir/subdir/somefile.d.ts                                                     | /users/username/dir/subdir                                                                   | false     |                                                                                              |
| /users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                              |
| /user/dir/subdir/somefile.d.ts                                                               | /user/dir/subdir                                                                             | false     |                                                                                              |
| /user/username/dir/subdir/somefile.d.ts                                                      | /user/username/dir/subdir                                                                    | false     |                                                                                              |
| /user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                              |
| /usr/dir/subdir/somefile.d.ts                                                                | /usr/dir/subdir                                                                              | false     |                                                                                              |
| /usr/username/dir/subdir/somefile.d.ts                                                       | /usr/username/dir/subdir                                                                     | false     |                                                                                              |
| /usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                              |
| /home/dir/subdir/somefile.d.ts                                                               | /home/dir/subdir                                                                             | false     |                                                                                              |
| /home/username/dir/subdir/somefile.d.ts                                                      | /home/username/dir/subdir                                                                    | false     |                                                                                              |
| /home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | true      |                                                                                              |
| /workspaces/dir/subdir/somefile.d.ts                                                         | /workspaces/dir/subdir                                                                       | false     |                                                                                              |
| /workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | /workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | /workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | /workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | /workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                              |

## RootDirForResolution: /workspaces

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /dir/subdir/somefile.d.ts                                                                    |                                                                                              |           |                                                                                              |
| /folderAtRoot/dir/subdir/somefile.d.ts                                                       | /folderAtRoot/dir/subdir                                                                     | false     |                                                                                              |
| /folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | /folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                              |
| /users/dir/subdir/somefile.d.ts                                                              | /users/dir/subdir                                                                            | false     |                                                                                              |
| /users/username/dir/subdir/somefile.d.ts                                                     | /users/username/dir/subdir                                                                   | false     |                                                                                              |
| /users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                              |
| /user/dir/subdir/somefile.d.ts                                                               | /user/dir/subdir                                                                             | false     |                                                                                              |
| /user/username/dir/subdir/somefile.d.ts                                                      | /user/username/dir/subdir                                                                    | false     |                                                                                              |
| /user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                              |
| /usr/dir/subdir/somefile.d.ts                                                                | /usr/dir/subdir                                                                              | false     |                                                                                              |
| /usr/username/dir/subdir/somefile.d.ts                                                       | /usr/username/dir/subdir                                                                     | false     |                                                                                              |
| /usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                              |
| /home/dir/subdir/somefile.d.ts                                                               | /home/dir/subdir                                                                             | false     |                                                                                              |
| /home/username/dir/subdir/somefile.d.ts                                                      | /home/username/dir/subdir                                                                    | false     |                                                                                              |
| /home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                              |
| /workspaces/dir/subdir/somefile.d.ts                                                         | /workspaces/dir/subdir                                                                       | false     |                                                                                              |
| /workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | /workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | /workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | /workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | /workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                              |

## RootDirForResolution: /workspaces/folderAtRoot

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /dir/subdir/somefile.d.ts                                                                    |                                                                                              |           |                                                                                              |
| /folderAtRoot/dir/subdir/somefile.d.ts                                                       | /folderAtRoot/dir/subdir                                                                     | false     |                                                                                              |
| /folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | /folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                              |
| /users/dir/subdir/somefile.d.ts                                                              | /users/dir/subdir                                                                            | false     |                                                                                              |
| /users/username/dir/subdir/somefile.d.ts                                                     | /users/username/dir/subdir                                                                   | false     |                                                                                              |
| /users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                              |
| /user/dir/subdir/somefile.d.ts                                                               | /user/dir/subdir                                                                             | false     |                                                                                              |
| /user/username/dir/subdir/somefile.d.ts                                                      | /user/username/dir/subdir                                                                    | false     |                                                                                              |
| /user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                              |
| /usr/dir/subdir/somefile.d.ts                                                                | /usr/dir/subdir                                                                              | false     |                                                                                              |
| /usr/username/dir/subdir/somefile.d.ts                                                       | /usr/username/dir/subdir                                                                     | false     |                                                                                              |
| /usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                              |
| /home/dir/subdir/somefile.d.ts                                                               | /home/dir/subdir                                                                             | false     |                                                                                              |
| /home/username/dir/subdir/somefile.d.ts                                                      | /home/username/dir/subdir                                                                    | false     |                                                                                              |
| /home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                              |
| /workspaces/dir/subdir/somefile.d.ts                                                         | /workspaces/dir/subdir                                                                       | false     |                                                                                              |
| /workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | /workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | /workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | /workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | /workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                              |

## RootDirForResolution: /workspaces/folderAtRoot/folder1

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /dir/subdir/somefile.d.ts                                                                    |                                                                                              |           |                                                                                              |
| /folderAtRoot/dir/subdir/somefile.d.ts                                                       | /folderAtRoot/dir/subdir                                                                     | false     |                                                                                              |
| /folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | /folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                              |
| /users/dir/subdir/somefile.d.ts                                                              | /users/dir/subdir                                                                            | false     |                                                                                              |
| /users/username/dir/subdir/somefile.d.ts                                                     | /users/username/dir/subdir                                                                   | false     |                                                                                              |
| /users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                              |
| /user/dir/subdir/somefile.d.ts                                                               | /user/dir/subdir                                                                             | false     |                                                                                              |
| /user/username/dir/subdir/somefile.d.ts                                                      | /user/username/dir/subdir                                                                    | false     |                                                                                              |
| /user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                              |
| /usr/dir/subdir/somefile.d.ts                                                                | /usr/dir/subdir                                                                              | false     |                                                                                              |
| /usr/username/dir/subdir/somefile.d.ts                                                       | /usr/username/dir/subdir                                                                     | false     |                                                                                              |
| /usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                              |
| /home/dir/subdir/somefile.d.ts                                                               | /home/dir/subdir                                                                             | false     |                                                                                              |
| /home/username/dir/subdir/somefile.d.ts                                                      | /home/username/dir/subdir                                                                    | false     |                                                                                              |
| /home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                              |
| /workspaces/dir/subdir/somefile.d.ts                                                         | /workspaces/dir/subdir                                                                       | false     |                                                                                              |
| /workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | /workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | /workspaces/folderAtRoot/folder1/dir                                                         | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | /workspaces/folderAtRoot/folder1/folder2                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | /workspaces/folderAtRoot/folder1/folder2                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | /workspaces/folderAtRoot/folder1/folder2                                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | /workspaces/folderAtRoot/folder1/folder2                                                     | true      |                                                                                              |

## RootDirForResolution: /workspaces/folderAtRoot/folder1/folder2

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /dir/subdir/somefile.d.ts                                                                    |                                                                                              |           |                                                                                              |
| /folderAtRoot/dir/subdir/somefile.d.ts                                                       | /folderAtRoot/dir/subdir                                                                     | false     |                                                                                              |
| /folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | /folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                              |
| /users/dir/subdir/somefile.d.ts                                                              | /users/dir/subdir                                                                            | false     |                                                                                              |
| /users/username/dir/subdir/somefile.d.ts                                                     | /users/username/dir/subdir                                                                   | false     |                                                                                              |
| /users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                              |
| /user/dir/subdir/somefile.d.ts                                                               | /user/dir/subdir                                                                             | false     |                                                                                              |
| /user/username/dir/subdir/somefile.d.ts                                                      | /user/username/dir/subdir                                                                    | false     |                                                                                              |
| /user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                              |
| /usr/dir/subdir/somefile.d.ts                                                                | /usr/dir/subdir                                                                              | false     |                                                                                              |
| /usr/username/dir/subdir/somefile.d.ts                                                       | /usr/username/dir/subdir                                                                     | false     |                                                                                              |
| /usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                              |
| /home/dir/subdir/somefile.d.ts                                                               | /home/dir/subdir                                                                             | false     |                                                                                              |
| /home/username/dir/subdir/somefile.d.ts                                                      | /home/username/dir/subdir                                                                    | false     |                                                                                              |
| /home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                              |
| /workspaces/dir/subdir/somefile.d.ts                                                         | /workspaces/dir/subdir                                                                       | false     |                                                                                              |
| /workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | /workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | /workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | /workspaces/folderAtRoot/folder1/folder2/dir                                                 | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | /workspaces/folderAtRoot/folder1/folder2/folder3                                             | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | /workspaces/folderAtRoot/folder1/folder2/folder3                                             | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | /workspaces/folderAtRoot/folder1/folder2/folder3                                             | true      |                                                                                              |

## RootDirForResolution: /workspaces/folderAtRoot/folder1/folder2/folder3

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /dir/subdir/somefile.d.ts                                                                    |                                                                                              |           |                                                                                              |
| /folderAtRoot/dir/subdir/somefile.d.ts                                                       | /folderAtRoot/dir/subdir                                                                     | false     |                                                                                              |
| /folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | /folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                              |
| /users/dir/subdir/somefile.d.ts                                                              | /users/dir/subdir                                                                            | false     |                                                                                              |
| /users/username/dir/subdir/somefile.d.ts                                                     | /users/username/dir/subdir                                                                   | false     |                                                                                              |
| /users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                              |
| /user/dir/subdir/somefile.d.ts                                                               | /user/dir/subdir                                                                             | false     |                                                                                              |
| /user/username/dir/subdir/somefile.d.ts                                                      | /user/username/dir/subdir                                                                    | false     |                                                                                              |
| /user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                              |
| /usr/dir/subdir/somefile.d.ts                                                                | /usr/dir/subdir                                                                              | false     |                                                                                              |
| /usr/username/dir/subdir/somefile.d.ts                                                       | /usr/username/dir/subdir                                                                     | false     |                                                                                              |
| /usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                              |
| /home/dir/subdir/somefile.d.ts                                                               | /home/dir/subdir                                                                             | false     |                                                                                              |
| /home/username/dir/subdir/somefile.d.ts                                                      | /home/username/dir/subdir                                                                    | false     |                                                                                              |
| /home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                              |
| /workspaces/dir/subdir/somefile.d.ts                                                         | /workspaces/dir/subdir                                                                       | false     |                                                                                              |
| /workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | /workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | /workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | /workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | /workspaces/folderAtRoot/folder1/folder2/folder3/dir                                         | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | true      |                                                                                              |

## RootDirForResolution: /workspaces/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /dir/subdir/somefile.d.ts                                                                    |                                                                                              |           |                                                                                              |
| /folderAtRoot/dir/subdir/somefile.d.ts                                                       | /folderAtRoot/dir/subdir                                                                     | false     |                                                                                              |
| /folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | /folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                              |
| /users/dir/subdir/somefile.d.ts                                                              | /users/dir/subdir                                                                            | false     |                                                                                              |
| /users/username/dir/subdir/somefile.d.ts                                                     | /users/username/dir/subdir                                                                   | false     |                                                                                              |
| /users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                              |
| /user/dir/subdir/somefile.d.ts                                                               | /user/dir/subdir                                                                             | false     |                                                                                              |
| /user/username/dir/subdir/somefile.d.ts                                                      | /user/username/dir/subdir                                                                    | false     |                                                                                              |
| /user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                              |
| /usr/dir/subdir/somefile.d.ts                                                                | /usr/dir/subdir                                                                              | false     |                                                                                              |
| /usr/username/dir/subdir/somefile.d.ts                                                       | /usr/username/dir/subdir                                                                     | false     |                                                                                              |
| /usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                              |
| /home/dir/subdir/somefile.d.ts                                                               | /home/dir/subdir                                                                             | false     |                                                                                              |
| /home/username/dir/subdir/somefile.d.ts                                                      | /home/username/dir/subdir                                                                    | false     |                                                                                              |
| /home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                              |
| /workspaces/dir/subdir/somefile.d.ts                                                         | /workspaces/dir/subdir                                                                       | false     |                                                                                              |
| /workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | /workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | /workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | /workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | /workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir                                 | true      |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | true      |                                                                                              |

## RootDirForResolution: /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive | Location if not symlink                                                                      |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------- |
| /dir/subdir/somefile.d.ts                                                                    |                                                                                              |           |                                                                                              |
| /folderAtRoot/dir/subdir/somefile.d.ts                                                       | /folderAtRoot/dir/subdir                                                                     | false     |                                                                                              |
| /folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | /folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                              |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                              |
| /users/dir/subdir/somefile.d.ts                                                              | /users/dir/subdir                                                                            | false     |                                                                                              |
| /users/username/dir/subdir/somefile.d.ts                                                     | /users/username/dir/subdir                                                                   | false     |                                                                                              |
| /users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                              |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                              |
| /user/dir/subdir/somefile.d.ts                                                               | /user/dir/subdir                                                                             | false     |                                                                                              |
| /user/username/dir/subdir/somefile.d.ts                                                      | /user/username/dir/subdir                                                                    | false     |                                                                                              |
| /user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                              |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                              |
| /usr/dir/subdir/somefile.d.ts                                                                | /usr/dir/subdir                                                                              | false     |                                                                                              |
| /usr/username/dir/subdir/somefile.d.ts                                                       | /usr/username/dir/subdir                                                                     | false     |                                                                                              |
| /usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                              |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                              |
| /home/dir/subdir/somefile.d.ts                                                               | /home/dir/subdir                                                                             | false     |                                                                                              |
| /home/username/dir/subdir/somefile.d.ts                                                      | /home/username/dir/subdir                                                                    | false     |                                                                                              |
| /home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                              |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                              |
| /workspaces/dir/subdir/somefile.d.ts                                                         | /workspaces/dir/subdir                                                                       | false     |                                                                                              |
| /workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | /workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | /workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | /workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | /workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                              |
| /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | /workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                         | true      |                                                                                              |

