namespace First {
    export enum E {
        a, b, c,
    }
}
namespace Abc {
    export enum E {
        a, b, c,
    }
    export enum Nope {
        a, b, c,
    }
}
namespace Abcd {
    export enum E {
        a, b, c, d,
    }
}
namespace Ab {
    export enum E {
        a, b,
    }
}
namespace Cd {
    export enum E {
        c, d,
    }
}
namespace Const {
    export const enum E {
        a, b, c,
    }
}
namespace Decl {
    export declare enum E {
        a, b, c = 3,
    }
}
namespace Merged {
    export enum E {
        a, b, 
    }
    export enum E {
        c = 3, d,
    }
}

namespace Merged2 {
    export enum E {
        a, b, c
    }
    export module E {
        export let d = 5;
    }
}

var abc: First.E;
var secondAbc: Abc.E;
var secondAbcd: Abcd.E;
var secondAb: Ab.E;
var secondCd: Cd.E;
var nope: Abc.Nope;
var k: Const.E;
var decl: Decl.E;
var merged: Merged.E;
var merged2: Merged2.E;
abc = secondAbc; // ok
abc = secondAbcd; // missing 'd'
abc = secondAb; // ok
abc = secondCd; // missing 'd'
abc = nope; // nope!
abc = decl; // bad - value of 'c' differs between these enums
secondAbc = abc; // ok
secondAbcd = abc; // ok
secondAb = abc; // missing 'c'
secondCd = abc; // missing 'a' and 'b'
nope = abc; // nope!
decl = abc; // bad - value of 'c' differs between these enums

// const is only assignable to itself
k = k;
abc = k; // error
k = abc;

// merged enums compare all their members
abc = merged; // missing 'd'
merged = abc; // bad - value of 'c' differs between these enums
abc = merged2; // ok
merged2 = abc; // ok