// @strict: true
// @noEmit: true

export type merge<base, props> = keyof base & keyof props extends never
  ? base & props
  : Omit<base, keyof props & keyof base> & props;

declare const merge: <l, r>(l: l, r: r) => merge<l, r>;

const o1 = merge({ p1: 1 }, { p2: 2 });
const o2 = merge(o1, { p2: 2, p3: 3 });
const o3 = merge(o2, { p3: 3, p4: 4 });
const o4 = merge(o3, { p4: 4, p5: 5 });
const o5 = merge(o4, { p5: 5, p6: 6 });
const o6 = merge(o5, { p6: 6, p7: 7 });
const o7 = merge(o6, { p7: 7, p8: 8 });
const o8 = merge(o7, { p8: 8, p9: 9 });
const o9 = merge(o8, { p9: 9, p10: 10 });
const o10 = merge(o9, { p10: 10, p11: 11 });
const o11 = merge(o10, { p11: 11, p12: 12 });
const o12 = merge(o11, { p12: 12, p13: 13 });
const o13 = merge(o12, { p13: 13, p14: 14 });
const o14 = merge(o13, { p14: 14, p15: 15 });
const o15 = merge(o14, { p15: 15, p16: 16 });
const o16 = merge(o15, { p16: 16, p17: 17 });
const o17 = merge(o16, { p17: 17, p18: 18 });
const o18 = merge(o17, { p18: 18, p19: 19 });
const o19 = merge(o18, { p19: 19, p20: 20 });
const o20 = merge(o19, { p20: 20, p21: 21 });
const o21 = merge(o20, { p21: 21, p22: 22 });
const o22 = merge(o21, { p22: 22, p23: 23 });
const o23 = merge(o22, { p23: 23, p24: 24 });
const o24 = merge(o23, { p24: 24, p25: 25 });
const o25 = merge(o24, { p25: 25, p26: 26 });
const o26 = merge(o25, { p26: 26, p27: 27 });
const o27 = merge(o26, { p27: 27, p28: 28 });
const o28 = merge(o27, { p28: 28, p29: 29 });
const o29 = merge(o28, { p29: 29, p30: 30 });
const o30 = merge(o29, { p30: 30, p31: 31 });
const o31 = merge(o30, { p31: 31, p32: 32 });
const o32 = merge(o31, { p32: 32, p33: 33 });
const o33 = merge(o32, { p33: 33, p34: 34 });
const o34 = merge(o33, { p34: 34, p35: 35 });
const o35 = merge(o34, { p35: 35, p36: 36 });
const o36 = merge(o35, { p36: 36, p37: 37 });
const o37 = merge(o36, { p37: 37, p38: 38 });
const o38 = merge(o37, { p38: 38, p39: 39 });
const o39 = merge(o38, { p39: 39, p40: 40 });
const o40 = merge(o39, { p40: 40, p41: 41 });
const o41 = merge(o40, { p41: 41, p42: 42 });
const o42 = merge(o41, { p42: 42, p43: 43 });
const o43 = merge(o42, { p43: 43, p44: 44 });
const o44 = merge(o43, { p44: 44, p45: 45 });
const o45 = merge(o44, { p45: 45, p46: 46 });
const o46 = merge(o45, { p46: 46, p47: 47 });
const o47 = merge(o46, { p47: 47, p48: 48 });
const o48 = merge(o47, { p48: 48, p49: 49 });
const o49 = merge(o48, { p49: 49, p50: 50 });
const o50 = merge(o49, { p50: 50, p51: 51 });

o1.p1;
o1.p51; // error

o2.p1;
o2.p2;
o2.p3;
o2.p4; // error

o25.p1;
o25.p10;
o25.p26;

o30.p1;
o30.p31;
o30.p38; // error
o30.p51; // error

o50.p1;
o50.p31;
o50.p38;
o50.p51;
