#define NoSuf     (b_Illegal|w_Illegal|l_Illegal|s_Illegal|x_Illegal|q_Illegal)
#define B_Suf     (w_Illegal|l_Illegal|s_Illegal|x_Illegal|q_Illegal)
#define W_Suf     (b_Illegal|l_Illegal|s_Illegal|x_Illegal|q_Illegal)
#define L_Suf     (b_Illegal|w_Illegal|s_Illegal|x_Illegal|q_Illegal)
#define Q_Suf     (b_Illegal|w_Illegal|s_Illegal|l_Illegal|x_Illegal)
#define X_Suf     (b_Illegal|w_Illegal|s_Illegal|l_Illegal|q_Illegal)
#define WL_Suf    (b_Illegal|s_Illegal|x_Illegal|q_Illegal)
#define WLQ_Suf   (b_Illegal|s_Illegal|x_Illegal)
#define LQ_Suf    (b_Illegal|w_Illegal|s_Illegal|x_Illegal)
#define WQ_Suf    (b_Illegal|l_Illegal|s_Illegal|x_Illegal)
#define SL_Suf    (b_Illegal|w_Illegal|x_Illegal|q_Illegal)
#define BWL_Suf   (s_Illegal|x_Illegal|q_Illegal)
#define BWLQ_Suf  (s_Illegal|x_Illegal)
#define FP        (NoSuf|IgnoreSize)
#define L_FP      (L_Suf|IgnoreSize)
#define X_FP      (X_Suf|IgnoreSize)
#define SL_FP     (SL_Suf|IgnoreSize)

#define X         (NO_EXTOPCODE)  /* no extension opcode available */


{"mov",      {Disp16|Disp32, Acc, 0},        {    0xa0, X, BWLQ_Suf|W, CPUNo64}},
{"mov",      {Acc, Disp16|Disp32, 0},        {    0xa2, X, BWLQ_Suf|W, CPUNo64}},
{"mov",      {Reg, Reg|AnyMem, 0},           {    0x88, X, BWLQ_Suf|W|M, 0}},
{"mov",      {Reg|AnyMem, Reg, 0},           {    0x8a, X, BWLQ_Suf|W|M, 0}},
{"mov",      {EncImm, Reg8|Reg16|Reg32, 0},  {    0xb0, X, BWL_Suf|W|ShortForm, 0}},
{"mov",      {EncImm, Reg|AnyMem, 0},        {    0xc6, 0, BWLQ_Suf|W|M, 0}},
{"mov",      {Imm64, Reg64, 0},              {    0xb0, X, Q_Suf|W|ShortForm, CPU64}},
{"mov",      {SegReg2, WordReg|WordMem, 0},  {    0x8c, X, WL_Suf|M, 0}},
{"mov",      {SegReg3, WordReg|WordMem, 0},  {    0x8c, X, WL_Suf|M, CPU386}},
{"mov",      {WordReg|WordMem, SegReg2, 0},  {    0x8e, X, WL_Suf|M|IgnoreSize, 0}},
{"mov",      {WordReg|WordMem, SegReg3, 0},  {    0x8e, X, WL_Suf|M|IgnoreSize, CPU386}},
{"mov",      {CtrlReg, Reg32|InvMem, 0},     {  0x0f20, X, L_Suf|M|IgnoreSize, CPU386|CPUNo64}},
{"mov",      {Reg32|InvMem, CtrlReg, 0},     {   0xf22, X, L_Suf|M|IgnoreSize, CPU386|CPUNo64}},
{"mov",      {CtrlReg, Reg64|InvMem, 0},     {  0x0f20, X, Q_Suf|M|IgnoreSize|NoRex64, CPU64}},
{"mov",      {Reg64|InvMem, CtrlReg, 0},     {   0xf22, X, Q_Suf|M|IgnoreSize|NoRex64, CPU64}},
{"mov",      {DebugReg, Reg32|InvMem, 0},    {  0x0f21, X, L_Suf|M|IgnoreSize, CPU386|CPUNo64}},
{"mov",      {Reg32|InvMem, DebugReg, 0},    {   0xf23, X, L_Suf|M|IgnoreSize, CPU386|CPUNo64}},
{"mov",      {DebugReg, Reg64|InvMem, 0},    {  0x0f21, X, Q_Suf|M|IgnoreSize|NoRex64, CPU64}},
{"mov",      {Reg64|InvMem, DebugReg, 0},    {   0xf23, X, Q_Suf|M|IgnoreSize|NoRex64, CPU64}},
{"mov",      {TestReg, Reg32|InvMem, 0},     {  0x0f24, X, L_Suf|M|IgnoreSize, CPU386}},
{"mov",      {Reg32|InvMem, TestReg, 0},     {   0xf26, X, L_Suf|M|IgnoreSize, CPU386}},
{"movabs",   {Disp64, Acc, 0},               {    0xa0, X, BWLQ_Suf|W, CPU64}},
{"movabs",   {Acc, Disp64, 0},               {    0xa2, X, BWLQ_Suf|W, CPU64}},
{"movabs",   {Imm64, Reg64, 0},              {    0xb0, X, Q_Suf|W|ShortForm, CPU64}},
{"movsbl",   {Reg8|ByteMem, Reg32, 0},       {  0x0fbe, X, NoSuf|M, CPU386}},
{"movsbw",   {Reg8|ByteMem, Reg16, 0},       {  0x0fbe, X, NoSuf|M, CPU386}},
{"movswl",   {Reg16|ShortMem, Reg32, 0},     {  0x0fbf, X, NoSuf|M, CPU386}},
{"movsbq",   {Reg8|ByteMem, Reg64, 0},       {  0x0fbe, X, NoSuf|M|Rex64, CPU64}},
{"movswq",   {Reg16|ShortMem, Reg64, 0},     {  0x0fbf, X, NoSuf|M|Rex64, CPU64}},
{"movslq",   {Reg32|WordMem, Reg64, 0},      {    0x63, X, NoSuf|M|Rex64, CPU64}},
{"movsx",    {Reg8|ByteMem, WordReg, 0},     {  0x0fbe, X, B_Suf|M, CPU386}},
{"movsx",    {Reg16|ShortMem, Reg32, 0},     {  0x0fbf, X, W_Suf|M, CPU386}},
{"movsx",    {Reg8|ByteMem, Reg64, 0},       {  0x0fbe, X, B_Suf|M|Rex64, CPU64}},
{"movsx",    {Reg16|ShortMem, Reg64, 0},     {  0x0fbf, X, W_Suf|M|Rex64, CPU64}},
{"movsx",    {Reg32|WordMem, Reg64, 0},      {    0x63, X, L_Suf|M|Rex64, CPU64}},
{"movzb",    {Reg8|ByteMem, WordReg, 0},     {  0x0fb6, X, WL_Suf|M, CPU386}},
{"movzwl",   {Reg16|ShortMem, Reg32, 0},     {  0x0fb7, X, NoSuf|M, CPU386}},
{"movzbq",   {Reg8|ByteMem, Reg64, 0},       {  0x0fb6, X, NoSuf|M|Rex64, CPU64}},
{"movzwq",   {Reg16|ShortMem, Reg64, 0},     {  0x0fb7, X, NoSuf|M|Rex64, CPU64}},
{"movzx",    {Reg8|ByteMem, WordReg, 0},     {  0x0fb6, X, B_Suf|M, CPU386}},
{"movzx",    {Reg16|ShortMem, Reg32, 0},     {  0x0fb7, X, W_Suf|M, CPU386}},
{"movzx",    {Reg8|ByteMem, Reg64, 0},       {  0x0fb6, X, B_Suf|M|Rex64, CPU386}},
{"movzx",    {Reg16|ShortMem, Reg64, 0},     {  0x0fb7, X, W_Suf|M|Rex64, CPU386}},
{"push",     {WordReg, 0, 0},                {    0x50, X, WL_Suf|ShortForm|DefaultSize, CPUNo64}},
{"push",     {WordReg|WordMem, 0, 0},        {    0xff, 6, WL_Suf|M|DefaultSize, CPUNo64}},
{"push",     {Imm8S, 0, 0},                  {    0x6a, X, WL_Suf|DefaultSize, CPU186|CPUNo64}},
{"push",     {Imm16|Imm32, 0, 0},            {    0x68, X, WL_Suf|DefaultSize, CPU186|CPUNo64}},
{"push",     {SegReg2, 0, 0},                {    0x06, X, WL_Suf|Seg2ShortForm|DefaultSize, 0|CPUNo64}},
{"push",     {SegReg3, 0, 0},                {  0x0fa0, X, WL_Suf|Seg3ShortForm|DefaultSize, CPU386|CPUNo64}},
{"push",     {WordReg, 0, 0},                {    0x50, X, WQ_Suf|ShortForm|DefaultSize|NoRex64, CPU64}},
{"push",     {WordReg|WordMem, 0, 0},        {    0xff, 6, WQ_Suf|M|DefaultSize|NoRex64, CPU64}},
{"push",     {Imm8S, 0, 0},                  {    0x6a, X, WQ_Suf|DefaultSize|NoRex64, CPU186|CPU64}},
{"push",     {Imm32S|Imm16, 0, 0},           {    0x68, X, WQ_Suf|DefaultSize|NoRex64, CPU186|CPU64}},
{"push",     {SegReg2, 0, 0},                {    0x06, X, WQ_Suf|Seg2ShortForm|DefaultSize|NoRex64, CPU64}},
{"push",     {SegReg3, 0, 0},                {  0x0fa0, X, WQ_Suf|Seg3ShortForm|DefaultSize|NoRex64, CPU386|CPU64}},
{"pusha",    {0, 0, 0},                      {    0x60, X, WL_Suf|DefaultSize, CPU186|CPUNo64}},
{"pop",      {WordReg, 0, 0},                {    0x58, X, WL_Suf|ShortForm|DefaultSize, CPUNo64}},
{"pop",      {WordReg|WordMem, 0, 0},        {    0x8f, 0, WL_Suf|M|DefaultSize, CPUNo64}},
{"pop",      {SegReg2, 0, 0},                {    0x07, X, WL_Suf|Seg2ShortForm|DefaultSize, CPUNo64}},
{"pop",      {SegReg3, 0, 0},                {  0x0fa1, X, WL_Suf|Seg3ShortForm|DefaultSize, CPU386|CPUNo64}},
{"pop",      {WordReg, 0, 0},                {    0x58, X, WQ_Suf|ShortForm|DefaultSize|NoRex64, CPU64}},
{"pop",      {WordReg|WordMem, 0, 0},        {    0x8f, 0, WQ_Suf|M|DefaultSize|NoRex64, CPU64}},
{"pop",      {SegReg2, 0, 0},                {    0x07, X, WQ_Suf|Seg2ShortForm|DefaultSize|NoRex64, CPU64}},
{"pop",      {SegReg3, 0, 0},                {  0x0fa1, X, WQ_Suf|Seg3ShortForm|DefaultSize|NoRex64, CPU64}},
{"popa",     {0, 0, 0},                      {    0x61, X, WL_Suf|DefaultSize, CPU186|CPUNo64}},
{"xchg",     {WordReg, Acc, 0},              {    0x90, X, WLQ_Suf|ShortForm, 0}},
{"xchg",     {Acc, WordReg, 0},              {    0x90, X, WLQ_Suf|ShortForm, 0}},
{"xchg",     {Reg, Reg|AnyMem, 0},           {    0x86, X, BWLQ_Suf|W|M, 0}},
{"xchg",     {Reg|AnyMem, Reg, 0},           {    0x86, X, BWLQ_Suf|W|M, 0}},
{"in",       {Imm8, Acc, 0},                 {    0xe4, X, BWL_Suf|W, 0}},
{"in",       {IOPortReg, Acc, 0},            {    0xec, X, BWL_Suf|W, 0}},
{"in",       {Imm8, 0, 0},                   {    0xe4, X, BWL_Suf|W, 0}},
{"in",       {IOPortReg, 0, 0},              {    0xec, X, BWL_Suf|W, 0}},
{"out",      {Acc, Imm8, 0},                 {    0xe6, X, BWL_Suf|W, 0}},
{"out",      {Acc, IOPortReg, 0},            {    0xee, X, BWL_Suf|W, 0}},
{"out",      {Imm8, 0, 0},                   {    0xe6, X, BWL_Suf|W, 0}},
{"out",      {IOPortReg, 0, 0},              {    0xee, X, BWL_Suf|W, 0}},
{"lea",      {WordMem, WordReg, 0},          {    0x8d, X, WLQ_Suf|M, 0}},
{"lds",      {WordMem, WordReg, 0},          {    0xc5, X, WLQ_Suf|M, CPUNo64}},
{"les",      {WordMem, WordReg, 0},          {    0xc4, X, WLQ_Suf|M, CPUNo64}},
{"lfs",      {WordMem, WordReg, 0},          {  0x0fb4, X, WLQ_Suf|M, CPU386}},
{"lgs",      {WordMem, WordReg, 0},          {  0x0fb5, X, WLQ_Suf|M, CPU386}},
{"lss",      {WordMem, WordReg, 0},          {  0x0fb2, X, WLQ_Suf|M, CPU386}},
{"clc",      {0, 0, 0},                      {    0xf8, X, NoSuf, 0}},
{"cld",      {0, 0, 0},                      {    0xfc, X, NoSuf, 0}},
{"cli",      {0, 0, 0},                      {    0xfa, X, NoSuf, 0}},
{"clts",     {0, 0, 0},                      {  0x0f06, X, NoSuf, CPU286}},
{"cmc",      {0, 0, 0},                      {    0xf5, X, NoSuf, 0}},
{"lahf",     {0, 0, 0},                      {    0x9f, X, NoSuf, CPUNo64}},
{"sahf",     {0, 0, 0},                      {    0x9e, X, NoSuf, CPUNo64}},
{"pushf",    {0, 0, 0},                      {    0x9c, X, WLQ_Suf|DefaultSize, CPUNo64}},
{"pushf",    {0, 0, 0},                      {    0x9c, X, WQ_Suf|DefaultSize|NoRex64, CPU64}},
{"popf",     {0, 0, 0},                      {    0x9d, X, WLQ_Suf|DefaultSize, CPUNo64}},
{"popf",     {0, 0, 0},                      {    0x9d, X, WQ_Suf|DefaultSize|NoRex64, CPU64}},
{"stc",      {0, 0, 0},                      {    0xf9, X, NoSuf, 0}},
{"std",      {0, 0, 0},                      {    0xfd, X, NoSuf, 0}},
{"sti",      {0, 0, 0},                      {    0xfb, X, NoSuf, 0}},
{"add",      {Reg, Reg|AnyMem, 0},           {    0x00, X, BWLQ_Suf|W|M, 0}},
{"add",      {Reg|AnyMem, Reg, 0},           {     0x2, X, BWLQ_Suf|W|M, 0}},
{"add",      {Imm8S, WordReg|WordMem, 0},    {    0x83, 0, WLQ_Suf|M, 0}},
{"add",      {EncImm, Acc, 0},               {    0x04, X, BWLQ_Suf|W, 0}},
{"add",      {EncImm, Reg|AnyMem, 0},        {    0x80, 0, BWLQ_Suf|W|M, 0}},
{"inc",      {WordReg, 0, 0},                {    0x40, X, WL_Suf|ShortForm, CPUNo64}},
{"inc",      {Reg|AnyMem, 0, 0},             {    0xfe, 0, BWLQ_Suf|W|M, 0}},
{"sub",      {Reg, Reg|AnyMem, 0},           {    0x28, X, BWLQ_Suf|W|M, 0}},
{"sub",      {Reg|AnyMem, Reg, 0},           {    0x2a, X, BWLQ_Suf|W|M, 0}},
{"sub",      {Imm8S, WordReg|WordMem, 0},    {    0x83, 5, WLQ_Suf|M, 0}},
{"sub",      {EncImm, Acc, 0},               {    0x2c, X, BWLQ_Suf|W, 0}},
{"sub",      {EncImm, Reg|AnyMem, 0},        {    0x80, 5, BWLQ_Suf|W|M, 0}},
{"dec",      {WordReg, 0, 0},                {    0x48, X, WL_Suf|ShortForm, CPUNo64}},
{"dec",      {Reg|AnyMem, 0, 0},             {    0xfe, 1, BWLQ_Suf|W|M, 0}},
{"sbb",      {Reg, Reg|AnyMem, 0},           {    0x18, X, BWLQ_Suf|W|M, 0}},
{"sbb",      {Reg|AnyMem, Reg, 0},           {    0x1a, X, BWLQ_Suf|W|M, 0}},
{"sbb",      {Imm8S, WordReg|WordMem, 0},    {    0x83, 3, WLQ_Suf|M, 0}},
{"sbb",      {EncImm, Acc, 0},               {    0x1c, X, BWLQ_Suf|W, 0}},
{"sbb",      {EncImm, Reg|AnyMem, 0},        {    0x80, 3, BWLQ_Suf|W|M, 0}},
{"cmp",      {Reg, Reg|AnyMem, 0},           {    0x38, X, BWLQ_Suf|W|M, 0}},
{"cmp",      {Reg|AnyMem, Reg, 0},           {    0x3a, X, BWLQ_Suf|W|M, 0}},
{"cmp",      {Imm8S, WordReg|WordMem, 0},    {    0x83, 7, WLQ_Suf|M, 0}},
{"cmp",      {EncImm, Acc, 0},               {    0x3c, X, BWLQ_Suf|W, 0}},
{"cmp",      {EncImm, Reg|AnyMem, 0},        {    0x80, 7, BWLQ_Suf|W|M, 0}},
{"test",     {Reg|AnyMem, Reg, 0},           {    0x84, X, BWLQ_Suf|W|M, 0}},
{"test",     {Reg, Reg|AnyMem, 0},           {    0x84, X, BWLQ_Suf|W|M, 0}},
{"test",     {EncImm, Acc, 0},               {    0xa8, X, BWLQ_Suf|W, 0}},
{"test",     {EncImm, Reg|AnyMem, 0},        {    0xf6, 0, BWLQ_Suf|W|M, 0}},
{"and",      {Reg, Reg|AnyMem, 0},           {    0x20, X, BWLQ_Suf|W|M, 0}},
{"and",      {Reg|AnyMem, Reg, 0},           {    0x22, X, BWLQ_Suf|W|M, 0}},
{"and",      {Imm8S, WordReg|WordMem, 0},    {    0x83, 4, WLQ_Suf|M, 0}},
{"and",      {EncImm, Acc, 0},               {    0x24, X, BWLQ_Suf|W, 0}},
{"and",      {EncImm, Reg|AnyMem, 0},        {    0x80, 4, BWLQ_Suf|W|M, 0}},
{"or",       {Reg, Reg|AnyMem, 0},           {    0x08, X, BWLQ_Suf|W|M, 0}},
{"or",       {Reg|AnyMem, Reg, 0},           {     0xa, X, BWLQ_Suf|W|M, 0}},
{"or",       {Imm8S, WordReg|WordMem, 0},    {    0x83, 1, WLQ_Suf|M, 0}},
{"or",       {EncImm, Acc, 0},               {    0x0c, X, BWLQ_Suf|W, 0}},
{"or",       {EncImm, Reg|AnyMem, 0},        {    0x80, 1, BWLQ_Suf|W|M, 0}},
{"xor",      {Reg, Reg|AnyMem, 0},           {    0x30, X, BWLQ_Suf|W|M, 0}},
{"xor",      {Reg|AnyMem, Reg, 0},           {    0x32, X, BWLQ_Suf|W|M, 0}},
{"xor",      {Imm8S, WordReg|WordMem, 0},    {    0x83, 6, WLQ_Suf|M, 0}},
{"xor",      {EncImm, Acc, 0},               {    0x34, X, BWLQ_Suf|W, 0}},
{"xor",      {EncImm, Reg|AnyMem, 0},        {    0x80, 6, BWLQ_Suf|W|M, 0}},
{"clr",      {Reg, 0, 0},                    {    0x30, X, BWLQ_Suf|W|M|FakeLastReg, 0}},
{"adc",      {Reg, Reg|AnyMem, 0},           {    0x10, X, BWLQ_Suf|W|M, 0}},
{"adc",      {Reg|AnyMem, Reg, 0},           {    0x12, X, BWLQ_Suf|W|M, 0}},
{"adc",      {Imm8S, WordReg|WordMem, 0},    {    0x83, 2, WLQ_Suf|M, 0}},
{"adc",      {EncImm, Acc, 0},               {    0x14, X, BWLQ_Suf|W, 0}},
{"adc",      {EncImm, Reg|AnyMem, 0},        {    0x80, 2, BWLQ_Suf|W|M, 0}},
{"neg",      {Reg|AnyMem, 0, 0},             {    0xf6, 3, BWLQ_Suf|W|M, 0}},
{"not",      {Reg|AnyMem, 0, 0},             {    0xf6, 2, BWLQ_Suf|W|M, 0}},
{"aaa",      {0, 0, 0},                      {    0x37, X, NoSuf, 0}},
{"aas",      {0, 0, 0},                      {    0x3f, X, NoSuf, 0}},
{"daa",      {0, 0, 0},                      {    0x27, X, NoSuf, 0}},
{"das",      {0, 0, 0},                      {    0x2f, X, NoSuf, 0}},
{"aad",      {0, 0, 0},                      {  0xd50a, X, NoSuf, 0}},
{"aad",      {Imm8S, 0, 0},                  {    0xd5, X, NoSuf, 0}},
{"aam",      {0, 0, 0},                      {  0xd40a, X, NoSuf, 0}},
{"aam",      {Imm8S, 0, 0},                  {    0xd4, X, NoSuf, 0}},
{"cbw",      {0, 0, 0},                      {    0x98, X, NoSuf|Size16, 0}},
{"cdqe",     {0, 0, 0},                      {    0x98, X, NoSuf|Size64, CPU64}},
{"cwde",     {0, 0, 0},                      {    0x98, X, NoSuf|Size32, 0}},
{"cwd",      {0, 0, 0},                      {    0x99, X, NoSuf|Size16, 0}},
{"cdq",      {0, 0, 0},                      {    0x99, X, NoSuf|Size32, 0}},
{"cqo",      {0, 0, 0},                      {    0x99, X, NoSuf|Size64, CPU64}},
{"cbtw",     {0, 0, 0},                      {    0x98, X, NoSuf|Size16, 0}},
{"cltq",     {0, 0, 0},                      {    0x98, X, NoSuf|Size64, CPU64}},
{"cwtl",     {0, 0, 0},                      {    0x98, X, NoSuf|Size32, 0}},
{"cwtd",     {0, 0, 0},                      {    0x99, X, NoSuf|Size16, 0}},
{"cltd",     {0, 0, 0},                      {    0x99, X, NoSuf|Size32, 0}},
{"cqto",     {0, 0, 0},                      {    0x99, X, NoSuf|Size64, CPU64}},
{"mul",      {Reg|AnyMem, 0, 0},             {    0xf6, 4, BWLQ_Suf|W|M, 0}},
{"imul",     {Reg|AnyMem, 0, 0},             {    0xf6, 5, BWLQ_Suf|W|M, 0}},
{"imul",     {WordReg|WordMem, WordReg, 0},  {  0x0faf, X, WLQ_Suf|M, CPU386}},
{"imul",     {Imm8S, WordReg|WordMem, WordReg},{    0x6b, X, WLQ_Suf|M, CPU186}},
{"imul",     {Imm16|Imm32S|Imm32, WordReg|WordMem, WordReg},{    0x69, X, WLQ_Suf|M, CPU186}},
{"imul",     {Imm8S, WordReg, 0},            {    0x6b, X, WLQ_Suf|M|FakeLastReg, CPU186}},
{"imul",     {Imm16|Imm32S|Imm32, WordReg, 0},{    0x69, X, WLQ_Suf|M|FakeLastReg, CPU186}},
{"div",      {Reg|AnyMem, 0, 0},             {    0xf6, 6, BWLQ_Suf|W|M, 0}},
{"div",      {Reg|AnyMem, Acc, 0},           {    0xf6, 6, BWLQ_Suf|W|M, 0}},
{"idiv",     {Reg|AnyMem, 0, 0},             {    0xf6, 7, BWLQ_Suf|W|M, 0}},
{"idiv",     {Reg|AnyMem, Acc, 0},           {    0xf6, 7, BWLQ_Suf|W|M, 0}},
{"rol",      {Imm1, Reg|AnyMem, 0},          {    0xd0, 0, BWLQ_Suf|W|M, 0}},
{"rol",      {Imm8, Reg|AnyMem, 0},          {    0xc0, 0, BWLQ_Suf|W|M, CPU186}},
{"rol",      {ShiftCntReg, Reg|AnyMem, 0},   {    0xd2, 0, BWLQ_Suf|W|M, 0}},
{"rol",      {Reg|AnyMem, 0, 0},             {    0xd0, 0, BWLQ_Suf|W|M, 0}},
{"ror",      {Imm1, Reg|AnyMem, 0},          {    0xd0, 1, BWLQ_Suf|W|M, 0}},
{"ror",      {Imm8, Reg|AnyMem, 0},          {    0xc0, 1, BWLQ_Suf|W|M, CPU186}},
{"ror",      {ShiftCntReg, Reg|AnyMem, 0},   {    0xd2, 1, BWLQ_Suf|W|M, 0}},
{"ror",      {Reg|AnyMem, 0, 0},             {    0xd0, 1, BWLQ_Suf|W|M, 0}},
{"rcl",      {Imm1, Reg|AnyMem, 0},          {    0xd0, 2, BWLQ_Suf|W|M, 0}},
{"rcl",      {Imm8, Reg|AnyMem, 0},          {    0xc0, 2, BWLQ_Suf|W|M, CPU186}},
{"rcl",      {ShiftCntReg, Reg|AnyMem, 0},   {    0xd2, 2, BWLQ_Suf|W|M, 0}},
{"rcl",      {Reg|AnyMem, 0, 0},             {    0xd0, 2, BWLQ_Suf|W|M, 0}},
{"rcr",      {Imm1, Reg|AnyMem, 0},          {    0xd0, 3, BWLQ_Suf|W|M, 0}},
{"rcr",      {Imm8, Reg|AnyMem, 0},          {    0xc0, 3, BWLQ_Suf|W|M, CPU186}},
{"rcr",      {ShiftCntReg, Reg|AnyMem, 0},   {    0xd2, 3, BWLQ_Suf|W|M, 0}},
{"rcr",      {Reg|AnyMem, 0, 0},             {    0xd0, 3, BWLQ_Suf|W|M, 0}},
{"sal",      {Imm1, Reg|AnyMem, 0},          {    0xd0, 4, BWLQ_Suf|W|M, 0}},
{"sal",      {Imm8, Reg|AnyMem, 0},          {    0xc0, 4, BWLQ_Suf|W|M, CPU186}},
{"sal",      {ShiftCntReg, Reg|AnyMem, 0},   {    0xd2, 4, BWLQ_Suf|W|M, 0}},
{"sal",      {Reg|AnyMem, 0, 0},             {    0xd0, 4, BWLQ_Suf|W|M, 0}},
{"shl",      {Imm1, Reg|AnyMem, 0},          {    0xd0, 4, BWLQ_Suf|W|M, 0}},
{"shl",      {Imm8, Reg|AnyMem, 0},          {    0xc0, 4, BWLQ_Suf|W|M, CPU186}},
{"shl",      {ShiftCntReg, Reg|AnyMem, 0},   {    0xd2, 4, BWLQ_Suf|W|M, 0}},
{"shl",      {Reg|AnyMem, 0, 0},             {    0xd0, 4, BWLQ_Suf|W|M, 0}},
{"shr",      {Imm1, Reg|AnyMem, 0},          {    0xd0, 5, BWLQ_Suf|W|M, 0}},
{"shr",      {Imm8, Reg|AnyMem, 0},          {    0xc0, 5, BWLQ_Suf|W|M, CPU186}},
{"shr",      {ShiftCntReg, Reg|AnyMem, 0},   {    0xd2, 5, BWLQ_Suf|W|M, 0}},
{"shr",      {Reg|AnyMem, 0, 0},             {    0xd0, 5, BWLQ_Suf|W|M, 0}},
{"sar",      {Imm1, Reg|AnyMem, 0},          {    0xd0, 7, BWLQ_Suf|W|M, 0}},
{"sar",      {Imm8, Reg|AnyMem, 0},          {    0xc0, 7, BWLQ_Suf|W|M, CPU186}},
{"sar",      {ShiftCntReg, Reg|AnyMem, 0},   {    0xd2, 7, BWLQ_Suf|W|M, 0}},
{"sar",      {Reg|AnyMem, 0, 0},             {    0xd0, 7, BWLQ_Suf|W|M, 0}},
{"shld",     {Imm8, WordReg, WordReg|WordMem},{ 0x0fa4, X, WLQ_Suf|M, CPU386}},
{"shld",     {ShiftCntReg, WordReg, WordReg|WordMem},{  0x0fa5, X, WLQ_Suf|M, CPU386}},
{"shld",     {WordReg, WordReg|WordMem, 0},  {  0x0fa5, X, WLQ_Suf|M, CPU386}},
{"shrd",     {Imm8, WordReg, WordReg|WordMem},{  0x0fac, X, WLQ_Suf|M, CPU386}},
{"shrd",     {ShiftCntReg, WordReg, WordReg|WordMem},{  0x0fad, X, WLQ_Suf|M, CPU386}},
{"shrd",     {WordReg, WordReg|WordMem, 0},  {  0x0fad, X, WLQ_Suf|M, CPU386}},
{"call",     {Disp16|Disp32, 0, 0},          {    0xe8, X, WLQ_Suf|JmpDword|DefaultSize, 0}},
{"call",     {WordReg|WordMem|JmpAbs, 0, 0}, {    0xff, 2, WL_Suf|M|DefaultSize, CPUNo64}},
{"call",     {WordReg|WordMem|JmpAbs, 0, 0}, {    0xff, 2, WQ_Suf|M|DefaultSize|NoRex64, CPU64}},
{"call",     {Imm16, Imm16|Imm32, 0},        {    0x9a, X, WLQ_Suf|JmpInterSeg|DefaultSize, CPUNo64}},
{"call",     {WordMem, 0, 0},                {    0xff, 3, X_Suf|M|DefaultSize, 0}},
{"lcall",    {Imm16, Imm16|Imm32, 0},        {    0x9a, X, WL_Suf|JmpInterSeg|DefaultSize, CPUNo64}},
{"lcall",    {WordMem|JmpAbs, 0, 0},         {    0xff, 3, WL_Suf|M|DefaultSize, CPUNo64}},
{"lcall",    {WordMem|JmpAbs, 0, 0},         {    0xff, 3, Q_Suf|M|DefaultSize|NoRex64, CPU64}},
{"jmp",      {Disp, 0, 0},                   {    0xeb, X, NoSuf|Jmp, 0}},
{"jmp",      {WordReg|WordMem|JmpAbs, 0, 0}, {    0xff, 4, WL_Suf|M, CPUNo64}},
{"jmp",      {WordReg|WordMem|JmpAbs, 0, 0}, {    0xff, 4, WQ_Suf|M|NoRex64, CPU64}},
{"jmp",      {Imm16, Imm16|Imm32, 0},        {    0xea, X, WL_Suf|JmpInterSeg, CPUNo64}},
{"jmp",      {WordMem, 0, 0},                {    0xff, 5, X_Suf|M, 0}},
{"ljmp",     {Imm16, Imm16|Imm32, 0},        {    0xea, X, WL_Suf|JmpInterSeg, CPUNo64}},
{"ljmp",     {WordMem|JmpAbs, 0, 0},         {    0xff, 5, WL_Suf|M, CPUNo64}},
{"ljmp",     {WordMem|JmpAbs, 0, 0},         {    0xff, 5, Q_Suf|M|NoRex64, CPU64}},
{"ret",      {0, 0, 0},                      {    0xc3, X, WLQ_Suf|DefaultSize, CPUNo64}},
{"ret",      {Imm16, 0, 0},                  {    0xc2, X, WLQ_Suf|DefaultSize, CPUNo64}},
{"ret",      {0, 0, 0},                      {    0xc3, X, Q_Suf|DefaultSize|NoRex64, CPU64}},
{"ret",      {Imm16, 0, 0},                  {    0xc2, X, Q_Suf|DefaultSize|NoRex64, CPU64}},
{"lret",     {0, 0, 0},                      {    0xcb, X, WLQ_Suf|DefaultSize, 0}},
{"lret",     {Imm16, 0, 0},                  {    0xca, X, WLQ_Suf|DefaultSize, 0}},
{"enter",    {Imm16, Imm8, 0},               {    0xc8, X, WLQ_Suf|DefaultSize, CPU186}},
{"leave",    {0, 0, 0},                      {    0xc9, X, WLQ_Suf|DefaultSize, CPU186}},
{"jo",       {Disp, 0, 0},                   {    0x70, X, NoSuf|Jmp, 0}},
{"jno",      {Disp, 0, 0},                   {    0x71, X, NoSuf|Jmp, 0}},
{"jb",       {Disp, 0, 0},                   {    0x72, X, NoSuf|Jmp, 0}},
{"jc",       {Disp, 0, 0},                   {    0x72, X, NoSuf|Jmp, 0}},
{"jnae",     {Disp, 0, 0},                   {    0x72, X, NoSuf|Jmp, 0}},
{"jnb",      {Disp, 0, 0},                   {    0x73, X, NoSuf|Jmp, 0}},
{"jnc",      {Disp, 0, 0},                   {    0x73, X, NoSuf|Jmp, 0}},
{"jae",      {Disp, 0, 0},                   {    0x73, X, NoSuf|Jmp, 0}},
{"je",       {Disp, 0, 0},                   {    0x74, X, NoSuf|Jmp, 0}},
{"jz",       {Disp, 0, 0},                   {    0x74, X, NoSuf|Jmp, 0}},
{"jne",      {Disp, 0, 0},                   {    0x75, X, NoSuf|Jmp, 0}},
{"jnz",      {Disp, 0, 0},                   {    0x75, X, NoSuf|Jmp, 0}},
{"jbe",      {Disp, 0, 0},                   {    0x76, X, NoSuf|Jmp, 0}},
{"jna",      {Disp, 0, 0},                   {    0x76, X, NoSuf|Jmp, 0}},
{"jnbe",     {Disp, 0, 0},                   {    0x77, X, NoSuf|Jmp, 0}},
{"ja",       {Disp, 0, 0},                   {    0x77, X, NoSuf|Jmp, 0}},
{"js",       {Disp, 0, 0},                   {    0x78, X, NoSuf|Jmp, 0}},
{"jns",      {Disp, 0, 0},                   {    0x79, X, NoSuf|Jmp, 0}},
{"jp",       {Disp, 0, 0},                   {    0x7a, X, NoSuf|Jmp, 0}},
{"jpe",      {Disp, 0, 0},                   {    0x7a, X, NoSuf|Jmp, 0}},
{"jnp",      {Disp, 0, 0},                   {    0x7b, X, NoSuf|Jmp, 0}},
{"jpo",      {Disp, 0, 0},                   {    0x7b, X, NoSuf|Jmp, 0}},
{"jl",       {Disp, 0, 0},                   {    0x7c, X, NoSuf|Jmp, 0}},
{"jnge",     {Disp, 0, 0},                   {    0x7c, X, NoSuf|Jmp, 0}},
{"jnl",      {Disp, 0, 0},                   {    0x7d, X, NoSuf|Jmp, 0}},
{"jge",      {Disp, 0, 0},                   {    0x7d, X, NoSuf|Jmp, 0}},
{"jle",      {Disp, 0, 0},                   {    0x7e, X, NoSuf|Jmp, 0}},
{"jng",      {Disp, 0, 0},                   {    0x7e, X, NoSuf|Jmp, 0}},
{"jnle",     {Disp, 0, 0},                   {    0x7f, X, NoSuf|Jmp, 0}},
{"jg",       {Disp, 0, 0},                   {    0x7f, X, NoSuf|Jmp, 0}},
{"jcxz",     {Disp, 0, 0},                   {    0xe3, X, NoSuf|JmpByte|Size16, CPUNo64}},
{"jecxz",    {Disp, 0, 0},                   {    0xe3, X, NoSuf|JmpByte|Size32, CPUNo64}},
{"jecxz",    {Disp, 0, 0},                   {  0x67e3, X, NoSuf|JmpByte|Size32, CPU64}},
{"jrcxz",    {Disp, 0, 0},                   {    0xe3, X, NoSuf|JmpByte|Size64|NoRex64, CPU64}},
{"loop",     {Disp, 0, 0},                   {    0xe2, X, WL_Suf|JmpByte, CPUNo64}},
{"loop",     {Disp, 0, 0},                   {    0xe2, X, LQ_Suf|JmpByte|NoRex64, CPU64}},
{"loopz",    {Disp, 0, 0},                   {    0xe1, X, WL_Suf|JmpByte, CPUNo64}},
{"loopz",    {Disp, 0, 0},                   {    0xe1, X, LQ_Suf|JmpByte|NoRex64, CPU64}},
{"loope",    {Disp, 0, 0},                   {    0xe1, X, WL_Suf|JmpByte, CPUNo64}},
{"loope",    {Disp, 0, 0},                   {    0xe1, X, LQ_Suf|JmpByte|NoRex64, CPU64}},
{"loopnz",   {Disp, 0, 0},                   {    0xe0, X, WL_Suf|JmpByte, CPUNo64}},
{"loopnz",   {Disp, 0, 0},                   {    0xe0, X, LQ_Suf|JmpByte|NoRex64, CPU64}},
{"loopne",   {Disp, 0, 0},                   {    0xe0, X, WL_Suf|JmpByte, CPUNo64}},
{"loopne",   {Disp, 0, 0},                   {    0xe0, X, LQ_Suf|JmpByte|NoRex64, CPU64}},
{"seto",     {Reg8|ByteMem, 0, 0},           {  0x0f90, 0, B_Suf|M, CPU386}},
{"setno",    {Reg8|ByteMem, 0, 0},           {  0x0f91, 0, B_Suf|M, CPU386}},
{"setb",     {Reg8|ByteMem, 0, 0},           {  0x0f92, 0, B_Suf|M, CPU386}},
{"setc",     {Reg8|ByteMem, 0, 0},           {  0x0f92, 0, B_Suf|M, CPU386}},
{"setnae",   {Reg8|ByteMem, 0, 0},           {  0x0f92, 0, B_Suf|M, CPU386}},
{"setnb",    {Reg8|ByteMem, 0, 0},           {  0x0f93, 0, B_Suf|M, CPU386}},
{"setnc",    {Reg8|ByteMem, 0, 0},           {  0x0f93, 0, B_Suf|M, CPU386}},
{"setae",    {Reg8|ByteMem, 0, 0},           {  0x0f93, 0, B_Suf|M, CPU386}},
{"sete",     {Reg8|ByteMem, 0, 0},           {  0x0f94, 0, B_Suf|M, CPU386}},
{"setz",     {Reg8|ByteMem, 0, 0},           {  0x0f94, 0, B_Suf|M, CPU386}},
{"setne",    {Reg8|ByteMem, 0, 0},           {  0x0f95, 0, B_Suf|M, CPU386}},
{"setnz",    {Reg8|ByteMem, 0, 0},           {  0x0f95, 0, B_Suf|M, CPU386}},
{"setbe",    {Reg8|ByteMem, 0, 0},           {  0x0f96, 0, B_Suf|M, CPU386}},
{"setna",    {Reg8|ByteMem, 0, 0},           {  0x0f96, 0, B_Suf|M, CPU386}},
{"setnbe",   {Reg8|ByteMem, 0, 0},           {  0x0f97, 0, B_Suf|M, CPU386}},
{"seta",     {Reg8|ByteMem, 0, 0},           {  0x0f97, 0, B_Suf|M, CPU386}},
{"sets",     {Reg8|ByteMem, 0, 0},           {  0x0f98, 0, B_Suf|M, CPU386}},
{"setns",    {Reg8|ByteMem, 0, 0},           {  0x0f99, 0, B_Suf|M, CPU386}},
{"setp",     {Reg8|ByteMem, 0, 0},           {  0x0f9a, 0, B_Suf|M, CPU386}},
{"setpe",    {Reg8|ByteMem, 0, 0},           {  0x0f9a, 0, B_Suf|M, CPU386}},
{"setnp",    {Reg8|ByteMem, 0, 0},           {  0x0f9b, 0, B_Suf|M, CPU386}},
{"setpo",    {Reg8|ByteMem, 0, 0},           {  0x0f9b, 0, B_Suf|M, CPU386}},
{"setl",     {Reg8|ByteMem, 0, 0},           {  0x0f9c, 0, B_Suf|M, CPU386}},
{"setnge",   {Reg8|ByteMem, 0, 0},           {  0x0f9c, 0, B_Suf|M, CPU386}},
{"setnl",    {Reg8|ByteMem, 0, 0},           {  0x0f9d, 0, B_Suf|M, CPU386}},
{"setge",    {Reg8|ByteMem, 0, 0},           {  0x0f9d, 0, B_Suf|M, CPU386}},
{"setle",    {Reg8|ByteMem, 0, 0},           {  0x0f9e, 0, B_Suf|M, CPU386}},
{"setng",    {Reg8|ByteMem, 0, 0},           {  0x0f9e, 0, B_Suf|M, CPU386}},
{"setnle",   {Reg8|ByteMem, 0, 0},           {  0x0f9f, 0, B_Suf|M, CPU386}},
{"setg",     {Reg8|ByteMem, 0, 0},           {  0x0f9f, 0, B_Suf|M, CPU386}},
{"cmps",     {0, 0, 0},                      {    0xa6, X, BWLQ_Suf|W|StrInst, 0}},
{"cmps",     {AnyMem|EsSeg, AnyMem, 0},      {    0xa6, X, BWLQ_Suf|W|StrInst, 0}},
{"scmp",     {0, 0, 0},                      {    0xa6, X, BWLQ_Suf|W|StrInst, 0}},
{"scmp",     {AnyMem|EsSeg, AnyMem, 0},      {    0xa6, X, BWLQ_Suf|W|StrInst, 0}},
{"ins",      {0, 0, 0},                      {    0x6c, X, BWL_Suf|W|StrInst, CPU186}},
{"ins",      {IOPortReg, AnyMem|EsSeg, 0},   {    0x6c, X, BWL_Suf|W|StrInst, CPU186}},
{"outs",     {0, 0, 0},                      {    0x6e, X, BWL_Suf|W|StrInst, CPU186}},
{"outs",     {AnyMem, IOPortReg, 0},         {    0x6e, X, BWL_Suf|W|StrInst, CPU186}},
{"lods",     {0, 0, 0},                      {    0xac, X, BWLQ_Suf|W|StrInst, 0}},
{"lods",     {AnyMem, 0, 0},                 {    0xac, X, BWLQ_Suf|W|StrInst, 0}},
{"lods",     {AnyMem, Acc, 0},               {    0xac, X, BWLQ_Suf|W|StrInst, 0}},
{"slod",     {0, 0, 0},                      {    0xac, X, BWLQ_Suf|W|StrInst, 0}},
{"slod",     {AnyMem, 0, 0},                 {    0xac, X, BWLQ_Suf|W|StrInst, 0}},
{"slod",     {AnyMem, Acc, 0},               {    0xac, X, BWLQ_Suf|W|StrInst, 0}},
{"movs",     {0, 0, 0},                      {    0xa4, X, BWLQ_Suf|W|StrInst, 0}},
{"movs",     {AnyMem, AnyMem|EsSeg, 0},      {    0xa4, X, BWLQ_Suf|W|StrInst, 0}},
{"smov",     {0, 0, 0},                      {    0xa4, X, BWLQ_Suf|W|StrInst, 0}},
{"smov",     {AnyMem, AnyMem|EsSeg, 0},      {    0xa4, X, BWLQ_Suf|W|StrInst, 0}},
{"scas",     {0, 0, 0},                      {    0xae, X, BWLQ_Suf|W|StrInst, 0}},
{"scas",     {AnyMem|EsSeg, 0, 0},           {    0xae, X, BWLQ_Suf|W|StrInst, 0}},
{"scas",     {AnyMem|EsSeg, Acc, 0},         {    0xae, X, BWLQ_Suf|W|StrInst, 0}},
{"ssca",     {0, 0, 0},                      {    0xae, X, BWLQ_Suf|W|StrInst, 0}},
{"ssca",     {AnyMem|EsSeg, 0, 0},           {    0xae, X, BWLQ_Suf|W|StrInst, 0}},
{"ssca",     {AnyMem|EsSeg, Acc, 0},         {    0xae, X, BWLQ_Suf|W|StrInst, 0}},
{"stos",     {0, 0, 0},                      {    0xaa, X, BWLQ_Suf|W|StrInst, 0}},
{"stos",     {AnyMem|EsSeg, 0, 0},           {    0xaa, X, BWLQ_Suf|W|StrInst, 0}},
{"stos",     {Acc, AnyMem|EsSeg, 0},         {    0xaa, X, BWLQ_Suf|W|StrInst, 0}},
{"ssto",     {0, 0, 0},                      {    0xaa, X, BWLQ_Suf|W|StrInst, 0}},
{"ssto",     {AnyMem|EsSeg, 0, 0},           {    0xaa, X, BWLQ_Suf|W|StrInst, 0}},
{"ssto",     {Acc, AnyMem|EsSeg, 0},         {    0xaa, X, BWLQ_Suf|W|StrInst, 0}},
{"xlat",     {0, 0, 0},                      {    0xd7, X, B_Suf|StrInst, 0}},
{"xlat",     {AnyMem, 0, 0},                 {    0xd7, X, B_Suf|StrInst, 0}},
{"bsf",      {WordReg|WordMem, WordReg, 0},  {  0x0fbc, X, WLQ_Suf|M, CPU386}},
{"bsr",      {WordReg|WordMem, WordReg, 0},  {  0x0fbd, X, WLQ_Suf|M, CPU386}},
{"bt",       {WordReg, WordReg|WordMem, 0},  {  0x0fa3, X, WLQ_Suf|M, CPU386}},
{"bt",       {Imm8, WordReg|WordMem, 0},     {  0x0fba, 4, WLQ_Suf|M, CPU386}},
{"btc",      {WordReg, WordReg|WordMem, 0},  {  0x0fbb, X, WLQ_Suf|M, CPU386}},
{"btc",      {Imm8, WordReg|WordMem, 0},     {  0x0fba, 7, WLQ_Suf|M, CPU386}},
{"btr",      {WordReg, WordReg|WordMem, 0},  {  0x0fb3, X, WLQ_Suf|M, CPU386}},
{"btr",      {Imm8, WordReg|WordMem, 0},     {  0x0fba, 6, WLQ_Suf|M, CPU386}},
{"bts",      {WordReg, WordReg|WordMem, 0},  {  0x0fab, X, WLQ_Suf|M, CPU386}},
{"bts",      {Imm8, WordReg|WordMem, 0},     {  0x0fba, 5, WLQ_Suf|M, CPU386}},
{"int",      {Imm8, 0, 0},                   {    0xcd, X, NoSuf, 0}},
{"int3",     {0, 0, 0},                      {    0xcc, X, NoSuf, 0}},
{"into",     {0, 0, 0},                      {    0xce, X, NoSuf, 0}},
{"iret",     {0, 0, 0},                      {    0xcf, X, WLQ_Suf|DefaultSize, 0}},
{"rsm",      {0, 0, 0},                      {  0x0faa, X, NoSuf, CPU386}},
{"bound",    {WordReg, WordMem, 0},          {    0x62, X, WLQ_Suf|M, CPU186}},
{"hlt",      {0, 0, 0},                      {    0xf4, X, NoSuf, 0}},
{"nop",      {0, 0, 0},                      {    0x90, X, NoSuf, 0}},
{"arpl",     {Reg16, Reg16|ShortMem, 0},     {    0x63, X, W_Suf|M|IgnoreSize, CPU286}},
{"lar",      {WordReg|WordMem, WordReg, 0},  {  0x0f02, X, WLQ_Suf|M, CPU286}},
{"lgdt",     {WordMem, 0, 0},                {  0x0f01, 2, WLQ_Suf|M, CPU286}},
{"lidt",     {WordMem, 0, 0},                {  0x0f01, 3, WLQ_Suf|M, CPU286}},
{"lldt",     {Reg16|ShortMem, 0, 0},         {  0x0f00, 2, W_Suf|M|IgnoreSize, CPU286}},
{"lmsw",     {Reg16|ShortMem, 0, 0},         {  0x0f01, 6, W_Suf|M|IgnoreSize, CPU286}},
{"lsl",      {WordReg|WordMem, WordReg, 0},  {  0x0f03, X, WLQ_Suf|M, CPU286}},
{"ltr",      {Reg16|ShortMem, 0, 0},         {  0x0f00, 3, W_Suf|M|IgnoreSize, CPU286}},
{"sgdt",     {WordMem, 0, 0},                {  0x0f01, 0, WLQ_Suf|M, CPU286}},
{"sidt",     {WordMem, 0, 0},                {  0x0f01, 1, WLQ_Suf|M, CPU286}},
{"sldt",     {WordReg|InvMem, 0, 0},         {  0x0f00, 0, WLQ_Suf|M, CPU286}},
{"sldt",     {ShortMem, 0, 0},               {  0x0f00, 0, W_Suf|M|IgnoreSize, CPU286}},
{"smsw",     {WordReg|InvMem, 0, 0},         {  0x0f01, 4, WLQ_Suf|M, CPU286}},
{"smsw",     {ShortMem, 0, 0},               {  0x0f01, 4, W_Suf|M|IgnoreSize, CPU286}},
{"str",      {WordReg|InvMem, 0, 0},         {  0x0f00, 1, WLQ_Suf|M, CPU286}},
{"str",      {ShortMem, 0, 0},               {  0x0f00, 1, W_Suf|M|IgnoreSize, CPU286}},
{"verr",     {Reg16|ShortMem, 0, 0},         {  0x0f00, 4, W_Suf|M|IgnoreSize, CPU286}},
{"verw",     {Reg16|ShortMem, 0, 0},         {  0x0f00, 5, W_Suf|M|IgnoreSize, CPU286}},
{"fld",      {FloatReg, 0, 0},               {  0xd9c0, X, FP|ShortForm, 0}},
{"fld",      {LongMem|LLongMem, 0, 0},       {    0xd9, 0, SL_FP|FloatMF|M, 0}},
{"fld",      {FloatReg, 0, 0},               {  0xd9c0, X, L_FP|ShortForm|Deprecated, 0}},
{"fld",      {LLongMem, 0, 0},               {    0xdb, 5, X_FP|M, 0}},
{"fild",     {ShortMem|LongMem, 0, 0},       {    0xdf, 0, SL_FP|FloatMF|M, 0}},
{"fildd",    {LLongMem, 0, 0},               {    0xdf, 5, FP|M, 0}},
{"fildq",    {LLongMem, 0, 0},               {    0xdf, 5, FP|M, 0}},
{"fildll",   {LLongMem, 0, 0},               {    0xdf, 5, FP|M, 0}},
{"fldt",     {LLongMem, 0, 0},               {    0xdb, 5, FP|M, 0}},
{"fbld",     {LLongMem, 0, 0},               {    0xdf, 4, FP|M, 0}},
{"fst",      {FloatReg, 0, 0},               {  0xddd0, X, FP|ShortForm, 0}},
{"fst",      {LongMem|LLongMem, 0, 0},       {    0xd9, 2, SL_FP|FloatMF|M, 0}},
{"fst",      {FloatReg, 0, 0},               {  0xddd0, X, L_FP|ShortForm|Deprecated, 0}},
{"fist",     {ShortMem|LongMem, 0, 0},       {    0xdf, 2, SL_FP|FloatMF|M, 0}},
{"fstp",     {FloatReg, 0, 0},               {  0xddd8, X, FP|ShortForm, 0}},
{"fstp",     {LongMem|LLongMem, 0, 0},       {    0xd9, 3, SL_FP|FloatMF|M, 0}},
{"fstp",     {FloatReg, 0, 0},               {  0xddd8, X, L_FP|ShortForm|Deprecated, 0}},
{"fstp",     {LLongMem, 0, 0},               {    0xdb, 7, X_FP|M, 0}},
{"fistp",    {ShortMem|LongMem, 0, 0},       {    0xdf, 3, SL_FP|FloatMF|M, 0}},
{"fistpd",   {LLongMem, 0, 0},               {    0xdf, 7, FP|M, 0}},
{"fistpq",   {LLongMem, 0, 0},               {    0xdf, 7, FP|M, 0}},
{"fistpll",  {LLongMem, 0, 0},               {    0xdf, 7, FP|M, 0}},
{"fstpt",    {LLongMem, 0, 0},               {    0xdb, 7, FP|M, 0}},
{"fbstp",    {LLongMem, 0, 0},               {    0xdf, 6, FP|M, 0}},
{"fxch",     {FloatReg, 0, 0},               {  0xd9c8, X, FP|ShortForm, 0}},
{"fxch",     {0, 0, 0},                      {  0xd9c9, X, FP, 0}},
{"fcom",     {FloatReg, 0, 0},               {  0xd8d0, X, FP|ShortForm, 0}},
{"fcom",     {0, 0, 0},                      {  0xd8d1, X, FP, 0}},
{"fcom",     {LongMem|LLongMem, 0, 0},       {    0xd8, 2, SL_FP|FloatMF|M, 0}},
{"fcom",     {FloatReg, 0, 0},               {  0xd8d0, X, L_FP|ShortForm|Deprecated, 0}},
{"ficom",    {ShortMem|LongMem, 0, 0},       {    0xde, 2, SL_FP|FloatMF|M, 0}},
{"fcomp",    {FloatReg, 0, 0},               {  0xd8d8, X, FP|ShortForm, 0}},
{"fcomp",    {0, 0, 0},                      {  0xd8d9, X, FP, 0}},
{"fcomp",    {LongMem|LLongMem, 0, 0},       {    0xd8, 3, SL_FP|FloatMF|M, 0}},
{"fcomp",    {FloatReg, 0, 0},               {  0xd8d8, X, L_FP|ShortForm|Deprecated, 0}},
{"ficomp",   {ShortMem|LongMem, 0, 0},       {    0xde, 3, SL_FP|FloatMF|M, 0}},
{"fcompp",   {0, 0, 0},                      {  0xded9, X, FP, 0}},
{"fucom",    {FloatReg, 0, 0},               {  0xdde0, X, FP|ShortForm, CPU286}},
{"fucom",    {0, 0, 0},                      {  0xdde1, X, FP, CPU286}},
{"fucomp",   {FloatReg, 0, 0},               {  0xdde8, X, FP|ShortForm, CPU286}},
{"fucomp",   {0, 0, 0},                      {  0xdde9, X, FP, CPU286}},
{"fucompp",  {0, 0, 0},                      {  0xdae9, X, FP, CPU286}},
{"ftst",     {0, 0, 0},                      {  0xd9e4, X, FP, 0}},
{"fxam",     {0, 0, 0},                      {  0xd9e5, X, FP, 0}},
{"fld1",     {0, 0, 0},                      {  0xd9e8, X, FP, 0}},
{"fldl2t",   {0, 0, 0},                      {  0xd9e9, X, FP, 0}},
{"fldl2e",   {0, 0, 0},                      {  0xd9ea, X, FP, 0}},
{"fldpi",    {0, 0, 0},                      {  0xd9eb, X, FP, 0}},
{"fldlg2",   {0, 0, 0},                      {  0xd9ec, X, FP, 0}},
{"fldln2",   {0, 0, 0},                      {  0xd9ed, X, FP, 0}},
{"fldz",     {0, 0, 0},                      {  0xd9ee, X, FP, 0}},
{"fadd",     {FloatReg, FloatAcc, 0},        {  0xd8c0, X, FP|ShortForm|FloatD, 0}},
{"fadd",     {FloatReg, 0, 0},               {  0xd8c0, X, FP|ShortForm, 0}},
{"fadd",     {0, 0, 0},                      {  0xdec1, X, FP|Deprecated, 0}},
{"fadd",     {LongMem|LLongMem, 0, 0},       {    0xd8, 0, SL_FP|FloatMF|M, 0}},
{"fiadd",    {ShortMem|LongMem, 0, 0},       {    0xde, 0, SL_FP|FloatMF|M, 0}},
{"faddp",    {FloatAcc, FloatReg, 0},        {  0xdec0, X, FP|ShortForm, 0}},
{"faddp",    {FloatReg, 0, 0},               {  0xdec0, X, FP|ShortForm, 0}},
{"faddp",    {0, 0, 0},                      {  0xdec1, X, FP, 0}},
{"faddp",    {FloatReg, FloatAcc, 0},        {  0xdec0, X, FP|ShortForm|Deprecated, 0}},
{"fsub",     {FloatReg, FloatAcc, 0},        {  0xd8e0, X, FP|ShortForm|FloatD|FloatR, 0}},
{"fsub",     {FloatReg, 0, 0},               {  0xd8e0, X, FP|ShortForm, 0}},
{"fsub",     {0, 0, 0},                      {  0xdee1, X, FP|Deprecated, 0}},
{"fsub",     {LongMem|LLongMem, 0, 0},       {    0xd8, 4, SL_FP|FloatMF|M, 0}},
{"fisub",    {ShortMem|LongMem, 0, 0},       {    0xde, 4, SL_FP|FloatMF|M, 0}},
{"fsubp",    {FloatAcc, FloatReg, 0},        {  0xdee0, X, FP|ShortForm, 0}},
{"fsubp",    {FloatReg, 0, 0},               {  0xdee0, X, FP|ShortForm, 0}},
{"fsubp",    {0, 0, 0},                      {  0xdee1, X, FP, 0}},
{"fsubp",    {FloatReg, FloatAcc, 0},        {  0xdee0, X, FP|ShortForm|Deprecated, 0}},
{"fsubp",    {FloatAcc, FloatReg, 0},        {  0xdee8, X, FP|ShortForm, 0}},
{"fsubp",    {FloatReg, 0, 0},               {  0xdee8, X, FP|ShortForm, 0}},
{"fsubp",    {0, 0, 0},                      {  0xdee9, X, FP, 0}},
{"fsubr",    {FloatReg, FloatAcc, 0},        {  0xd8e8, X, FP|ShortForm|FloatD|FloatR, 0}},
{"fsubr",    {FloatReg, 0, 0},               {  0xd8e8, X, FP|ShortForm, 0}},
{"fsubr",    {0, 0, 0},                      {  0xdee9, X, FP|Deprecated, 0}},
{"fsubr",    {LongMem|LLongMem, 0, 0},       {    0xd8, 5, SL_FP|FloatMF|M, 0}},
{"fisubr",   {ShortMem|LongMem, 0, 0},       {    0xde, 5, SL_FP|FloatMF|M, 0}},
{"fsubrp",   {FloatAcc, FloatReg, 0},        {  0xdee8, X, FP|ShortForm, 0}},
{"fsubrp",   {FloatReg, 0, 0},               {  0xdee8, X, FP|ShortForm, 0}},
{"fsubrp",   {0, 0, 0},                      {  0xdee9, X, FP, 0}},
{"fsubrp",   {FloatReg, FloatAcc, 0},        {  0xdee8, X, FP|ShortForm|Deprecated, 0}},
{"fsubrp",   {FloatAcc, FloatReg, 0},        {  0xdee0, X, FP|ShortForm, 0}},
{"fsubrp",   {FloatReg, 0, 0},               {  0xdee0, X, FP|ShortForm, 0}},
{"fsubrp",   {0, 0, 0},                      {  0xdee1, X, FP, 0}},
{"fmul",     {FloatReg, FloatAcc, 0},        {  0xd8c8, X, FP|ShortForm|FloatD, 0}},
{"fmul",     {FloatReg, 0, 0},               {  0xd8c8, X, FP|ShortForm, 0}},
{"fmul",     {0, 0, 0},                      {  0xdec9, X, FP|Deprecated, 0}},
{"fmul",     {LongMem|LLongMem, 0, 0},       {    0xd8, 1, SL_FP|FloatMF|M, 0}},
{"fimul",    {ShortMem|LongMem, 0, 0},       {    0xde, 1, SL_FP|FloatMF|M, 0}},
{"fmulp",    {FloatAcc, FloatReg, 0},        {  0xdec8, X, FP|ShortForm, 0}},
{"fmulp",    {FloatReg, 0, 0},               {  0xdec8, X, FP|ShortForm, 0}},
{"fmulp",    {0, 0, 0},                      {  0xdec9, X, FP, 0}},
{"fmulp",    {FloatReg, FloatAcc, 0},        {  0xdec8, X, FP|ShortForm|Deprecated, 0}},
{"fdiv",     {FloatReg, FloatAcc, 0},        {  0xd8f0, X, FP|ShortForm|FloatD|FloatR, 0}},
{"fdiv",     {FloatReg, 0, 0},               {  0xd8f0, X, FP|ShortForm, 0}},
{"fdiv",     {0, 0, 0},                      {  0xdef1, X, FP|Deprecated, 0}},
{"fdiv",     {LongMem|LLongMem, 0, 0},       {    0xd8, 6, SL_FP|FloatMF|M, 0}},
{"fidiv",    {ShortMem|LongMem, 0, 0},       {    0xde, 6, SL_FP|FloatMF|M, 0}},
{"fdivp",    {FloatAcc, FloatReg, 0},        {  0xdef0, X, FP|ShortForm, 0}},
{"fdivp",    {FloatReg, 0, 0},               {  0xdef0, X, FP|ShortForm, 0}},
{"fdivp",    {0, 0, 0},                      {  0xdef1, X, FP, 0}},
{"fdivp",    {FloatReg, FloatAcc, 0},        {  0xdef0, X, FP|ShortForm|Deprecated, 0}},
{"fdivp",    {FloatAcc, FloatReg, 0},        {  0xdef8, X, FP|ShortForm, 0}},
{"fdivp",    {FloatReg, 0, 0},               {  0xdef8, X, FP|ShortForm, 0}},
{"fdivp",    {0, 0, 0},                      {  0xdef9, X, FP, 0}},
{"fdivr",    {FloatReg, FloatAcc, 0},        {  0xd8f8, X, FP|ShortForm|FloatD|FloatR, 0}},
{"fdivr",    {FloatReg, 0, 0},               {  0xd8f8, X, FP|ShortForm, 0}},
{"fdivr",    {0, 0, 0},                      {  0xdef9, X, FP|Deprecated, 0}},
{"fdivr",    {LongMem|LLongMem, 0, 0},       {    0xd8, 7, SL_FP|FloatMF|M, 0}},
{"fidivr",   {ShortMem|LongMem, 0, 0},       {    0xde, 7, SL_FP|FloatMF|M, 0}},
{"fdivrp",   {FloatAcc, FloatReg, 0},        {  0xdef8, X, FP|ShortForm, 0}},
{"fdivrp",   {FloatReg, 0, 0},               {  0xdef8, X, FP|ShortForm, 0}},
{"fdivrp",   {0, 0, 0},                      {  0xdef9, X, FP, 0}},
{"fdivrp",   {FloatReg, FloatAcc, 0},        {  0xdef8, X, FP|ShortForm|Deprecated, 0}},
{"fdivrp",   {FloatAcc, FloatReg, 0},        {  0xdef0, X, FP|ShortForm, 0}},
{"fdivrp",   {FloatReg, 0, 0},               {  0xdef0, X, FP|ShortForm, 0}},
{"fdivrp",   {0, 0, 0},                      {  0xdef1, X, FP, 0}},
{"f2xm1",    {0, 0, 0},                      {  0xd9f0, X, FP, 0}},
{"fyl2x",    {0, 0, 0},                      {  0xd9f1, X, FP, 0}},
{"fptan",    {0, 0, 0},                      {  0xd9f2, X, FP, 0}},
{"fpatan",   {0, 0, 0},                      {  0xd9f3, X, FP, 0}},
{"fxtract",  {0, 0, 0},                      {  0xd9f4, X, FP, 0}},
{"fprem1",   {0, 0, 0},                      {  0xd9f5, X, FP, CPU286}},
{"fdecstp",  {0, 0, 0},                      {  0xd9f6, X, FP, 0}},
{"fincstp",  {0, 0, 0},                      {  0xd9f7, X, FP, 0}},
{"fprem",    {0, 0, 0},                      {  0xd9f8, X, FP, 0}},
{"fyl2xp1",  {0, 0, 0},                      {  0xd9f9, X, FP, 0}},
{"fsqrt",    {0, 0, 0},                      {  0xd9fa, X, FP, 0}},
{"fsincos",  {0, 0, 0},                      {  0xd9fb, X, FP, CPU286}},
{"frndint",  {0, 0, 0},                      {  0xd9fc, X, FP, 0}},
{"fscale",   {0, 0, 0},                      {  0xd9fd, X, FP, 0}},
{"fsin",     {0, 0, 0},                      {  0xd9fe, X, FP, CPU286}},
{"fcos",     {0, 0, 0},                      {  0xd9ff, X, FP, CPU286}},
{"fchs",     {0, 0, 0},                      {  0xd9e0, X, FP, 0}},
{"fabs",     {0, 0, 0},                      {  0xd9e1, X, FP, 0}},
{"fninit",   {0, 0, 0},                      {  0xdbe3, X, FP, 0}},
{"finit",    {0, 0, 0},                      {  0xdbe3, X, FP|FWait, 0}},
{"fldcw",    {ShortMem, 0, 0},               {    0xd9, 5, FP|M, 0}},
{"fnstcw",   {ShortMem, 0, 0},               {    0xd9, 7, FP|M, 0}},
{"fstcw",    {ShortMem, 0, 0},               {    0xd9, 7, FP|FWait|M, 0}},
{"fnstsw",   {Acc, 0, 0},                    {  0xdfe0, X, FP, 0}},
{"fnstsw",   {ShortMem, 0, 0},               {    0xdd, 7, FP|M, 0}},
{"fnstsw",   {0, 0, 0},                      {  0xdfe0, X, FP, 0}},
{"fstsw",    {Acc, 0, 0},                    {  0xdfe0, X, FP|FWait, 0}},
{"fstsw",    {ShortMem, 0, 0},               {    0xdd, 7, FP|FWait|M, 0}},
{"fstsw",    {0, 0, 0},                      {  0xdfe0, X, FP|FWait, 0}},
{"fnclex",   {0, 0, 0},                      {  0xdbe2, X, FP, 0}},
{"fclex",    {0, 0, 0},                      {  0xdbe2, X, FP|FWait, 0}},
{"fnstenv",  {LLongMem, 0, 0},               {    0xd9, 6, SL_Suf|M, 0}},
{"fstenv",   {LLongMem, 0, 0},               {    0xd9, 6, SL_Suf|FWait|M, 0}},
{"fldenv",   {LLongMem, 0, 0},               {    0xd9, 4, SL_Suf|M, 0}},
{"fnsave",   {LLongMem, 0, 0},               {    0xdd, 6, SL_Suf|M, 0}},
{"fsave",    {LLongMem, 0, 0},               {    0xdd, 6, SL_Suf|FWait|M, 0}},
{"frstor",   {LLongMem, 0, 0},               {    0xdd, 4, SL_Suf|M, 0}},
{"ffree",    {FloatReg, 0, 0},               {  0xddc0, X, FP|ShortForm, 0}},
{"ffreep",   {FloatReg, 0, 0},               {  0xdfc0, X, FP|ShortForm, CPU686}},
{"fnop",     {0, 0, 0},                      {  0xd9d0, X, FP, 0}},
{"fwait",    {0, 0, 0},                      {    0x9b, X, FP, 0}},
{"addr16",   {0, 0, 0},                      {    0x67, X, NoSuf|IsPrefix|Size16|IgnoreSize, CPU386}},
{"addr32",   {0, 0, 0},                      {    0x67, X, NoSuf|IsPrefix|Size32|IgnoreSize, CPU386}},
{"aword",    {0, 0, 0},                      {    0x67, X, NoSuf|IsPrefix|Size16|IgnoreSize, CPU386}},
{"adword",   {0, 0, 0},                      {    0x67, X, NoSuf|IsPrefix|Size32|IgnoreSize, CPU386}},
{"data16",   {0, 0, 0},                      {    0x66, X, NoSuf|IsPrefix|Size16|IgnoreSize, CPU386}},
{"data32",   {0, 0, 0},                      {    0x66, X, NoSuf|IsPrefix|Size32|IgnoreSize, CPU386}},
{"word",     {0, 0, 0},                      {    0x66, X, NoSuf|IsPrefix|Size16|IgnoreSize, CPU386}},
{"dword",    {0, 0, 0},                      {    0x66, X, NoSuf|IsPrefix|Size32|IgnoreSize, CPU386}},
{"lock",     {0, 0, 0},                      {    0xf0, X, NoSuf|IsPrefix, 0}},
{"wait",     {0, 0, 0},                      {    0x9b, X, NoSuf|IsPrefix, 0}},
{"cs",       {0, 0, 0},                      {    0x2e, X, NoSuf|IsPrefix, 0}},
{"ds",       {0, 0, 0},                      {    0x3e, X, NoSuf|IsPrefix, 0}},
{"es",       {0, 0, 0},                      {    0x26, X, NoSuf|IsPrefix, 0}},
{"fs",       {0, 0, 0},                      {    0x64, X, NoSuf|IsPrefix, CPU386}},
{"gs",       {0, 0, 0},                      {    0x65, X, NoSuf|IsPrefix, CPU386}},
{"ss",       {0, 0, 0},                      {    0x36, X, NoSuf|IsPrefix, 0}},
{"rep",      {0, 0, 0},                      {    0xf3, X, NoSuf|IsPrefix, 0}},
{"repe",     {0, 0, 0},                      {    0xf3, X, NoSuf|IsPrefix, 0}},
{"repz",     {0, 0, 0},                      {    0xf3, X, NoSuf|IsPrefix, 0}},
{"repne",    {0, 0, 0},                      {    0xf2, X, NoSuf|IsPrefix, 0}},
{"repnz",    {0, 0, 0},                      {    0xf2, X, NoSuf|IsPrefix, 0}},
{"rex",      {0, 0, 0},                      {    0x40, X, NoSuf|IsPrefix, CPU64}},
{"rexz",     {0, 0, 0},                      {    0x41, X, NoSuf|IsPrefix, CPU64}},
{"rexy",     {0, 0, 0},                      {    0x42, X, NoSuf|IsPrefix, CPU64}},
{"rexyz",    {0, 0, 0},                      {    0x43, X, NoSuf|IsPrefix, CPU64}},
{"rexx",     {0, 0, 0},                      {    0x44, X, NoSuf|IsPrefix, CPU64}},
{"rexxz",    {0, 0, 0},                      {    0x45, X, NoSuf|IsPrefix, CPU64}},
{"rexxy",    {0, 0, 0},                      {    0x46, X, NoSuf|IsPrefix, CPU64}},
{"rexxyz",   {0, 0, 0},                      {    0x47, X, NoSuf|IsPrefix, CPU64}},
{"rex64",    {0, 0, 0},                      {    0x48, X, NoSuf|IsPrefix, CPU64}},
{"rex64z",   {0, 0, 0},                      {    0x49, X, NoSuf|IsPrefix, CPU64}},
{"rex64y",   {0, 0, 0},                      {    0x4a, X, NoSuf|IsPrefix, CPU64}},
{"rex64yz",  {0, 0, 0},                      {    0x4b, X, NoSuf|IsPrefix, CPU64}},
{"rex64x",   {0, 0, 0},                      {    0x4c, X, NoSuf|IsPrefix, CPU64}},
{"rex64xz",  {0, 0, 0},                      {    0x4d, X, NoSuf|IsPrefix, CPU64}},
{"rex64xy",  {0, 0, 0},                      {    0x4e, X, NoSuf|IsPrefix, CPU64}},
{"rex64xyz", {0, 0, 0},                      {    0x4f, X, NoSuf|IsPrefix, CPU64}},
{"bswap",    {Reg32|Reg64, 0, 0},            {  0x0fc8, X, LQ_Suf|ShortForm, CPU486}},
{"xadd",     {Reg, Reg|AnyMem, 0},           {  0x0fc0, X, BWLQ_Suf|W|M, CPU486}},
{"cmpxchg",  {Reg, Reg|AnyMem, 0},           {  0x0fb0, X, BWLQ_Suf|W|M, CPU486}},
{"invd",     {0, 0, 0},                      {  0x0f08, X, NoSuf, CPU486}},
{"wbinvd",   {0, 0, 0},                      {  0x0f09, X, NoSuf, CPU486}},
{"invlpg",   {AnyMem, 0, 0},                 {  0x0f01, 7, NoSuf|M, CPU486}},
{"cpuid",    {0, 0, 0},                      {  0x0fa2, X, NoSuf, CPU486}},
{"wrmsr",    {0, 0, 0},                      {  0x0f30, X, NoSuf, CPU586}},
{"rdtsc",    {0, 0, 0},                      {  0x0f31, X, NoSuf, CPU586}},
{"rdmsr",    {0, 0, 0},                      {  0x0f32, X, NoSuf, CPU586}},
{"cmpxchg8b",{LLongMem, 0, 0},               {  0x0fc7, 1, NoSuf|M, CPU586}},
{"sysenter", {0, 0, 0},                      {  0x0f34, X, NoSuf, CPU686}},
{"sysexit",  {0, 0, 0},                      {  0x0f35, X, NoSuf, CPU686}},
{"fxsave",   {LLongMem, 0, 0},               {  0x0fae, 0, FP|M, CPU686}},
{"fxrstor",  {LLongMem, 0, 0},               {  0x0fae, 1, FP|M, CPU686}},
{"rdpmc",    {0, 0, 0},                      {  0x0f33, X, NoSuf, CPU686}},
{"ud2",      {0, 0, 0},                      {  0x0f0b, X, NoSuf, CPU686}},
{"ud2a",     {0, 0, 0},                      {  0x0f0b, X, NoSuf, CPU686}},
{"ud2b",     {0, 0, 0},                      {  0x0fb9, X, NoSuf, CPU686}},
{"cmovo",    {WordReg|WordMem, WordReg, 0},  {  0x0f40, X, WLQ_Suf|M, CPU686}},
{"cmovno",   {WordReg|WordMem, WordReg, 0},  {  0x0f41, X, WLQ_Suf|M, CPU686}},
{"cmovb",    {WordReg|WordMem, WordReg, 0},  {  0x0f42, X, WLQ_Suf|M, CPU686}},
{"cmovc",    {WordReg|WordMem, WordReg, 0},  {  0x0f42, X, WLQ_Suf|M, CPU686}},
{"cmovnae",  {WordReg|WordMem, WordReg, 0},  {  0x0f42, X, WLQ_Suf|M, CPU686}},
{"cmovae",   {WordReg|WordMem, WordReg, 0},  {  0x0f43, X, WLQ_Suf|M, CPU686}},
{"cmovnc",   {WordReg|WordMem, WordReg, 0},  {  0x0f43, X, WLQ_Suf|M, CPU686}},
{"cmovnb",   {WordReg|WordMem, WordReg, 0},  {  0x0f43, X, WLQ_Suf|M, CPU686}},
{"cmove",    {WordReg|WordMem, WordReg, 0},  {  0x0f44, X, WLQ_Suf|M, CPU686}},
{"cmovz",    {WordReg|WordMem, WordReg, 0},  {  0x0f44, X, WLQ_Suf|M, CPU686}},
{"cmovne",   {WordReg|WordMem, WordReg, 0},  {  0x0f45, X, WLQ_Suf|M, CPU686}},
{"cmovnz",   {WordReg|WordMem, WordReg, 0},  {  0x0f45, X, WLQ_Suf|M, CPU686}},
{"cmovbe",   {WordReg|WordMem, WordReg, 0},  {  0x0f46, X, WLQ_Suf|M, CPU686}},
{"cmovna",   {WordReg|WordMem, WordReg, 0},  {  0x0f46, X, WLQ_Suf|M, CPU686}},
{"cmova",    {WordReg|WordMem, WordReg, 0},  {  0x0f47, X, WLQ_Suf|M, CPU686}},
{"cmovnbe",  {WordReg|WordMem, WordReg, 0},  {  0x0f47, X, WLQ_Suf|M, CPU686}},
{"cmovs",    {WordReg|WordMem, WordReg, 0},  {  0x0f48, X, WLQ_Suf|M, CPU686}},
{"cmovns",   {WordReg|WordMem, WordReg, 0},  {  0x0f49, X, WLQ_Suf|M, CPU686}},
{"cmovp",    {WordReg|WordMem, WordReg, 0},  {  0x0f4a, X, WLQ_Suf|M, CPU686}},
{"cmovnp",   {WordReg|WordMem, WordReg, 0},  {  0x0f4b, X, WLQ_Suf|M, CPU686}},
{"cmovl",    {WordReg|WordMem, WordReg, 0},  {  0x0f4c, X, WLQ_Suf|M, CPU686}},
{"cmovnge",  {WordReg|WordMem, WordReg, 0},  {  0x0f4c, X, WLQ_Suf|M, CPU686}},
{"cmovge",   {WordReg|WordMem, WordReg, 0},  {  0x0f4d, X, WLQ_Suf|M, CPU686}},
{"cmovnl",   {WordReg|WordMem, WordReg, 0},  {  0x0f4d, X, WLQ_Suf|M, CPU686}},
{"cmovle",   {WordReg|WordMem, WordReg, 0},  {  0x0f4e, X, WLQ_Suf|M, CPU686}},
{"cmovng",   {WordReg|WordMem, WordReg, 0},  {  0x0f4e, X, WLQ_Suf|M, CPU686}},
{"cmovg",    {WordReg|WordMem, WordReg, 0},  {  0x0f4f, X, WLQ_Suf|M, CPU686}},
{"cmovnle",  {WordReg|WordMem, WordReg, 0},  {  0x0f4f, X, WLQ_Suf|M, CPU686}},
{"fcmovb",   {FloatReg, FloatAcc, 0},        {  0xdac0, X, FP|ShortForm, CPU686}},
{"fcmovnae", {FloatReg, FloatAcc, 0},        {  0xdac0, X, FP|ShortForm, CPU686}},
{"fcmove",   {FloatReg, FloatAcc, 0},        {  0xdac8, X, FP|ShortForm, CPU686}},
{"fcmovbe",  {FloatReg, FloatAcc, 0},        {  0xdad0, X, FP|ShortForm, CPU686}},
{"fcmovna",  {FloatReg, FloatAcc, 0},        {  0xdad0, X, FP|ShortForm, CPU686}},
{"fcmovu",   {FloatReg, FloatAcc, 0},        {  0xdad8, X, FP|ShortForm, CPU686}},
{"fcmovae",  {FloatReg, FloatAcc, 0},        {  0xdbc0, X, FP|ShortForm, CPU686}},
{"fcmovnb",  {FloatReg, FloatAcc, 0},        {  0xdbc0, X, FP|ShortForm, CPU686}},
{"fcmovne",  {FloatReg, FloatAcc, 0},        {  0xdbc8, X, FP|ShortForm, CPU686}},
{"fcmova",   {FloatReg, FloatAcc, 0},        {  0xdbd0, X, FP|ShortForm, CPU686}},
{"fcmovnbe", {FloatReg, FloatAcc, 0},        {  0xdbd0, X, FP|ShortForm, CPU686}},
{"fcmovnu",  {FloatReg, FloatAcc, 0},        {  0xdbd8, X, FP|ShortForm, CPU686}},
{"fcomi",    {FloatReg, FloatAcc, 0},        {  0xdbf0, X, FP|ShortForm, CPU686}},
{"fcomi",    {0, 0, 0},                      {  0xdbf1, X, FP|ShortForm, CPU686}},
{"fcomi",    {FloatReg, 0, 0},               {  0xdbf0, X, FP|ShortForm, CPU686}},
{"fucomi",   {FloatReg, FloatAcc, 0},        {  0xdbe8, X, FP|ShortForm, CPU686}},
{"fucomi",   {0, 0, 0},                      {  0xdbe9, X, FP|ShortForm, CPU686}},
{"fucomi",   {FloatReg, 0, 0},               {  0xdbe8, X, FP|ShortForm, CPU686}},
{"fcomip",   {FloatReg, FloatAcc, 0},        {  0xdff0, X, FP|ShortForm, CPU686}},
{"fcompi",   {FloatReg, FloatAcc, 0},        {  0xdff0, X, FP|ShortForm, CPU686}},
{"fcompi",   {0, 0, 0},                      {  0xdff1, X, FP|ShortForm, CPU686}},
{"fcompi",   {FloatReg, 0, 0},               {  0xdff0, X, FP|ShortForm, CPU686}},
{"fucomip",  {FloatReg, FloatAcc, 0},        {  0xdfe8, X, FP|ShortForm, CPU686}},
{"fucompi",  {FloatReg, FloatAcc, 0},        {  0xdfe8, X, FP|ShortForm, CPU686}},
{"fucompi",  {0, 0, 0},                      {  0xdfe9, X, FP|ShortForm, CPU686}},
{"fucompi",  {FloatReg, 0, 0},               {  0xdfe8, X, FP|ShortForm, CPU686}},
{"movnti",   {WordReg, WordMem, 0},          {  0x0fc3, X, FP|M, CPUP4}},
{"clflush",  {ByteMem, 0, 0},                {  0x0fae, 7, FP|M, CPUP4}},
{"lfence",   {0, 0, 0},                      {  0x0fae, 0xe8, FP|ImmExt, CPUP4}},
{"mfence",   {0, 0, 0},                      {  0x0fae, 0xf0, FP|ImmExt, CPUP4}},
{"pause",    {0, 0, 0},                      {  0xf390, X, FP, CPUP4}},
{"emms",     {0, 0, 0},                      {  0x0f77, X, FP, CPUMMX}},
{"movd",     {Reg32|LongMem, MMXReg, 0},     {  0x0f6e, X, FP|M, CPUMMX}},
{"movd",     {MMXReg, Reg32|LongMem, 0},     {  0x0f7e, X, FP|M, CPUMMX}},
{"movd",     {Reg32|LLongMem, XMMReg, 0},    {0x660f6e, X, FP|M, CPUSSE2}},
{"movd",     {XMMReg, Reg32|LLongMem, 0},    {0x660f7e, X, FP|M, CPUSSE2}},
{"movd",     {Reg64|LLongMem, MMXReg, 0},    {  0x0f6e, X, FP|M, CPUMMX}},
{"movd",     {MMXReg, Reg64|LLongMem, 0},    {  0x0f7e, X, FP|M, CPUMMX}},
{"movd",     {Reg64|LLongMem, XMMReg, 0},    {0x660f6e, X, FP|M, CPUSSE2}},
{"movd",     {XMMReg, Reg64|LLongMem, 0},    {0x660f7e, X, FP|M, CPUSSE2}},
{"movq",     {MMXReg|LongMem, MMXReg, 0},    {  0x0f6f, X, FP|M, CPUMMX}},
{"movq",     {MMXReg, MMXReg|LongMem, 0},    {  0x0f7f, X, FP|M, CPUMMX}},
{"movq",     {XMMReg|LLongMem, XMMReg, 0},   {0xf30f7e, X, FP|M, CPUSSE2}},
{"movq",     {XMMReg, XMMReg|LLongMem, 0},   {0x660fd6, X, FP|M, CPUSSE2}},
{"movq",     {Reg64, Reg64|AnyMem, 0},       {    0x88, X, NoSuf|W|M|Size64, CPU64}},
{"movq",     {Reg64|AnyMem, Reg64, 0},       {    0x8a, X, NoSuf|W|M|Size64, CPU64}},
{"movq",     {Imm32S, Reg64|WordMem, 0},     {    0xc6, 0, NoSuf|W|M|Size64, CPU64}},
{"movq",     {Imm64, Reg64, 0},              {    0xb0, X, NoSuf|W|ShortForm|Size64, CPU64}},
{"movq",     {CtrlReg, Reg64|InvMem, 0},     {  0x0f20, X, NoSuf|M|IgnoreSize|NoRex64|Size64, CPU64}},
{"movq",     {Reg64|InvMem, CtrlReg, 0},     {   0xf22, X, NoSuf|M|IgnoreSize|NoRex64|Size64, CPU64}},
{"movq",     {DebugReg, Reg64|InvMem, 0},    {  0x0f21, X, NoSuf|M|IgnoreSize|NoRex64|Size64, CPU64}},
{"movq",     {Reg64|InvMem, DebugReg, 0},    {   0xf23, X, NoSuf|M|IgnoreSize|NoRex64|Size64, CPU64}},
{"packssdw", {MMXReg|LongMem, MMXReg, 0},    {  0x0f6b, X, FP|M, CPUMMX}},
{"packssdw", {XMMReg|LLongMem, XMMReg, 0},   {0x660f6b, X, FP|M, CPUSSE2}},
{"packsswb", {MMXReg|LongMem, MMXReg, 0},    {  0x0f63, X, FP|M, CPUMMX}},
{"packsswb", {XMMReg|LLongMem, XMMReg, 0},   {0x660f63, X, FP|M, CPUSSE2}},
{"packuswb", {MMXReg|LongMem, MMXReg, 0},    {  0x0f67, X, FP|M, CPUMMX}},
{"packuswb", {XMMReg|LLongMem, XMMReg, 0},   {0x660f67, X, FP|M, CPUSSE2}},
{"paddb",    {MMXReg|LongMem, MMXReg, 0},    {  0x0ffc, X, FP|M, CPUMMX}},
{"paddb",    {XMMReg|LLongMem, XMMReg, 0},   {0x660ffc, X, FP|M, CPUSSE2}},
{"paddw",    {MMXReg|LongMem, MMXReg, 0},    {  0x0ffd, X, FP|M, CPUMMX}},
{"paddw",    {XMMReg|LLongMem, XMMReg, 0},   {0x660ffd, X, FP|M, CPUSSE2}},
{"paddd",    {MMXReg|LongMem, MMXReg, 0},    {  0x0ffe, X, FP|M, CPUMMX}},
{"paddd",    {XMMReg|LLongMem, XMMReg, 0},   {0x660ffe, X, FP|M, CPUSSE2}},
{"paddq",    {MMXReg|LLongMem, MMXReg, 0},   {  0x0fd4, X, FP|M, CPUMMX}},
{"paddq",    {XMMReg|LLongMem, XMMReg, 0},   {0x660fd4, X, FP|M, CPUSSE2}},
{"paddsb",   {MMXReg|LongMem, MMXReg, 0},    {  0x0fec, X, FP|M, CPUMMX}},
{"paddsb",   {XMMReg|LLongMem, XMMReg, 0},   {0x660fec, X, FP|M, CPUSSE2}},
{"paddsw",   {MMXReg|LongMem, MMXReg, 0},    {  0x0fed, X, FP|M, CPUMMX}},
{"paddsw",   {XMMReg|LLongMem, XMMReg, 0},   {0x660fed, X, FP|M, CPUSSE2}},
{"paddusb",  {MMXReg|LongMem, MMXReg, 0},    {  0x0fdc, X, FP|M, CPUMMX}},
{"paddusb",  {XMMReg|LLongMem, XMMReg, 0},   {0x660fdc, X, FP|M, CPUSSE2}},
{"paddusw",  {MMXReg|LongMem, MMXReg, 0},    {  0x0fdd, X, FP|M, CPUMMX}},
{"paddusw",  {XMMReg|LLongMem, XMMReg, 0},   {0x660fdd, X, FP|M, CPUSSE2}},
{"pand",     {MMXReg|LongMem, MMXReg, 0},    {  0x0fdb, X, FP|M, CPUMMX}},
{"pand",     {XMMReg|LLongMem, XMMReg, 0},   {0x660fdb, X, FP|M, CPUSSE2}},
{"pandn",    {MMXReg|LongMem, MMXReg, 0},    {  0x0fdf, X, FP|M, CPUMMX}},
{"pandn",    {XMMReg|LLongMem, XMMReg, 0},   {0x660fdf, X, FP|M, CPUSSE2}},
{"pcmpeqb",  {MMXReg|LongMem, MMXReg, 0},    {  0x0f74, X, FP|M, CPUMMX}},
{"pcmpeqb",  {XMMReg|LLongMem, XMMReg, 0},   {0x660f74, X, FP|M, CPUSSE2}},
{"pcmpeqw",  {MMXReg|LongMem, MMXReg, 0},    {  0x0f75, X, FP|M, CPUMMX}},
{"pcmpeqw",  {XMMReg|LLongMem, XMMReg, 0},   {0x660f75, X, FP|M, CPUSSE2}},
{"pcmpeqd",  {MMXReg|LongMem, MMXReg, 0},    {  0x0f76, X, FP|M, CPUMMX}},
{"pcmpeqd",  {XMMReg|LLongMem, XMMReg, 0},   {0x660f76, X, FP|M, CPUSSE2}},
{"pcmpgtb",  {MMXReg|LongMem, MMXReg, 0},    {  0x0f64, X, FP|M, CPUMMX}},
{"pcmpgtb",  {XMMReg|LLongMem, XMMReg, 0},   {0x660f64, X, FP|M, CPUSSE2}},
{"pcmpgtw",  {MMXReg|LongMem, MMXReg, 0},    {  0x0f65, X, FP|M, CPUMMX}},
{"pcmpgtw",  {XMMReg|LLongMem, XMMReg, 0},   {0x660f65, X, FP|M, CPUSSE2}},
{"pcmpgtd",  {MMXReg|LongMem, MMXReg, 0},    {  0x0f66, X, FP|M, CPUMMX}},
{"pcmpgtd",  {XMMReg|LLongMem, XMMReg, 0},   {0x660f66, X, FP|M, CPUSSE2}},
{"pmaddwd",  {MMXReg|LongMem, MMXReg, 0},    {  0x0ff5, X, FP|M, CPUMMX}},
{"pmaddwd",  {XMMReg|LLongMem, XMMReg, 0},   {0x660ff5, X, FP|M, CPUSSE2}},
{"pmulhw",   {MMXReg|LongMem, MMXReg, 0},    {  0x0fe5, X, FP|M, CPUMMX}},
{"pmulhw",   {XMMReg|LLongMem, XMMReg, 0},   {0x660fe5, X, FP|M, CPUSSE2}},
{"pmullw",   {MMXReg|LongMem, MMXReg, 0},    {  0x0fd5, X, FP|M, CPUMMX}},
{"pmullw",   {XMMReg|LLongMem, XMMReg, 0},   {0x660fd5, X, FP|M, CPUSSE2}},
{"por",      {MMXReg|LongMem, MMXReg, 0},    {  0x0feb, X, FP|M, CPUMMX}},
{"por",      {XMMReg|LLongMem, XMMReg, 0},   {0x660feb, X, FP|M, CPUSSE2}},
{"psllw",    {MMXReg|LongMem, MMXReg, 0},    {  0x0ff1, X, FP|M, CPUMMX}},
{"psllw",    {XMMReg|LLongMem, XMMReg, 0},   {0x660ff1, X, FP|M, CPUSSE2}},
{"psllw",    {Imm8, MMXReg, 0},              {  0x0f71, 6, FP|M, CPUMMX}},
{"psllw",    {Imm8, XMMReg, 0},              {0x660f71, 6, FP|M, CPUSSE2}},
{"pslld",    {MMXReg|LongMem, MMXReg, 0},    {  0x0ff2, X, FP|M, CPUMMX}},
{"pslld",    {XMMReg|LLongMem, XMMReg, 0},   {0x660ff2, X, FP|M, CPUSSE2}},
{"pslld",    {Imm8, MMXReg, 0},              {  0x0f72, 6, FP|M, CPUMMX}},
{"pslld",    {Imm8, XMMReg, 0},              {0x660f72, 6, FP|M, CPUSSE2}},
{"psllq",    {MMXReg|LongMem, MMXReg, 0},    {  0x0ff3, X, FP|M, CPUMMX}},
{"psllq",    {XMMReg|LLongMem, XMMReg, 0},   {0x660ff3, X, FP|M, CPUSSE2}},
{"psllq",    {Imm8, MMXReg, 0},              {  0x0f73, 6, FP|M, CPUMMX}},
{"psllq",    {Imm8, XMMReg, 0},              {0x660f73, 6, FP|M, CPUSSE2}},
{"psraw",    {MMXReg|LongMem, MMXReg, 0},    {  0x0fe1, X, FP|M, CPUMMX}},
{"psraw",    {XMMReg|LLongMem, XMMReg, 0},   {0x660fe1, X, FP|M, CPUSSE2}},
{"psraw",    {Imm8, MMXReg, 0},              {  0x0f71, 4, FP|M, CPUMMX}},
{"psraw",    {Imm8, XMMReg, 0},              {0x660f71, 4, FP|M, CPUSSE2}},
{"psrad",    {MMXReg|LongMem, MMXReg, 0},    {  0x0fe2, X, FP|M, CPUMMX}},
{"psrad",    {XMMReg|LLongMem, XMMReg, 0},   {0x660fe2, X, FP|M, CPUSSE2}},
{"psrad",    {Imm8, MMXReg, 0},              {  0x0f72, 4, FP|M, CPUMMX}},
{"psrad",    {Imm8, XMMReg, 0},              {0x660f72, 4, FP|M, CPUSSE2}},
{"psrlw",    {MMXReg|LongMem, MMXReg, 0},    {  0x0fd1, X, FP|M, CPUMMX}},
{"psrlw",    {XMMReg|LLongMem, XMMReg, 0},   {0x660fd1, X, FP|M, CPUSSE2}},
{"psrlw",    {Imm8, MMXReg, 0},              {  0x0f71, 2, FP|M, CPUMMX}},
{"psrlw",    {Imm8, XMMReg, 0},              {0x660f71, 2, FP|M, CPUSSE2}},
{"psrld",    {MMXReg|LongMem, MMXReg, 0},    {  0x0fd2, X, FP|M, CPUMMX}},
{"psrld",    {XMMReg|LLongMem, XMMReg, 0},   {0x660fd2, X, FP|M, CPUSSE2}},
{"psrld",    {Imm8, MMXReg, 0},              {  0x0f72, 2, FP|M, CPUMMX}},
{"psrld",    {Imm8, XMMReg, 0},              {0x660f72, 2, FP|M, CPUSSE2}},
{"psrlq",    {MMXReg|LongMem, MMXReg, 0},    {  0x0fd3, X, FP|M, CPUMMX}},
{"psrlq",    {XMMReg|LLongMem, XMMReg, 0},   {0x660fd3, X, FP|M, CPUSSE2}},
{"psrlq",    {Imm8, MMXReg, 0},              {  0x0f73, 2, FP|M, CPUMMX}},
{"psrlq",    {Imm8, XMMReg, 0},              {0x660f73, 2, FP|M, CPUSSE2}},
{"psubb",    {MMXReg|LongMem, MMXReg, 0},    {  0x0ff8, X, FP|M, CPUMMX}},
{"psubb",    {XMMReg|LLongMem, XMMReg, 0},   {0x660ff8, X, FP|M, CPUSSE2}},
{"psubw",    {MMXReg|LongMem, MMXReg, 0},    {  0x0ff9, X, FP|M, CPUMMX}},
{"psubw",    {XMMReg|LLongMem, XMMReg, 0},   {0x660ff9, X, FP|M, CPUSSE2}},
{"psubd",    {MMXReg|LongMem, MMXReg, 0},    {  0x0ffa, X, FP|M, CPUMMX}},
{"psubd",    {XMMReg|LLongMem, XMMReg, 0},   {0x660ffa, X, FP|M, CPUSSE2}},
{"psubq",    {MMXReg|LLongMem, MMXReg, 0},   {  0x0ffb, X, FP|M, CPUMMX}},
{"psubq",    {XMMReg|LLongMem, XMMReg, 0},   {0x660ffb, X, FP|M, CPUSSE2}},
{"psubsb",   {MMXReg|LongMem, MMXReg, 0},    {  0x0fe8, X, FP|M, CPUMMX}},
{"psubsb",   {XMMReg|LLongMem, XMMReg, 0},   {0x660fe8, X, FP|M, CPUSSE2}},
{"psubsw",   {MMXReg|LongMem, MMXReg, 0},    {  0x0fe9, X, FP|M, CPUMMX}},
{"psubsw",   {XMMReg|LLongMem, XMMReg, 0},   {0x660fe9, X, FP|M, CPUSSE2}},
{"psubusb",  {MMXReg|LongMem, MMXReg, 0},    {  0x0fd8, X, FP|M, CPUMMX}},
{"psubusb",  {XMMReg|LLongMem, XMMReg, 0},   {0x660fd8, X, FP|M, CPUSSE2}},
{"psubusw",  {MMXReg|LongMem, MMXReg, 0},    {  0x0fd9, X, FP|M, CPUMMX}},
{"psubusw",  {XMMReg|LLongMem, XMMReg, 0},   {0x660fd9, X, FP|M, CPUSSE2}},
{"punpckhbw",{MMXReg|LongMem, MMXReg, 0},    {  0x0f68, X, FP|M, CPUMMX}},
{"punpckhbw",{XMMReg|LLongMem, XMMReg, 0},   {0x660f68, X, FP|M, CPUSSE2}},
{"punpckhwd",{MMXReg|LongMem, MMXReg, 0},    {  0x0f69, X, FP|M, CPUMMX}},
{"punpckhwd",{XMMReg|LLongMem, XMMReg, 0},   {0x660f69, X, FP|M, CPUSSE2}},
{"punpckhdq",{MMXReg|LongMem, MMXReg, 0},    {  0x0f6a, X, FP|M, CPUMMX}},
{"punpckhdq",{XMMReg|LLongMem, XMMReg, 0},   {0x660f6a, X, FP|M, CPUSSE2}},
{"punpcklbw",{MMXReg|LongMem, MMXReg, 0},    {  0x0f60, X, FP|M, CPUMMX}},
{"punpcklbw",{XMMReg|LLongMem, XMMReg, 0},   {0x660f60, X, FP|M, CPUSSE2}},
{"punpcklwd",{MMXReg|LongMem, MMXReg, 0},    {  0x0f61, X, FP|M, CPUMMX}},
{"punpcklwd",{XMMReg|LLongMem, XMMReg, 0},   {0x660f61, X, FP|M, CPUSSE2}},
{"punpckldq",{MMXReg|LongMem, MMXReg, 0},    {  0x0f62, X, FP|M, CPUMMX}},
{"punpckldq",{XMMReg|LLongMem, XMMReg, 0},   {0x660f62, X, FP|M, CPUSSE2}},
{"pxor",     {MMXReg|LongMem, MMXReg, 0},    {  0x0fef, X, FP|M, CPUMMX}},
{"pxor",     {XMMReg|LLongMem, XMMReg, 0},   {0x660fef, X, FP|M, CPUSSE2}},
{"addps",    {XMMReg|LLongMem, XMMReg, 0},   {  0x0f58, X, FP|M, CPUSSE}},
{"addss",    {XMMReg|WordMem, XMMReg, 0},    {0xf30f58, X, FP|M, CPUSSE}},
{"andnps",   {XMMReg|LLongMem, XMMReg, 0},   {  0x0f55, X, FP|M, CPUSSE}},
{"andps",    {XMMReg|WordMem, XMMReg, 0},    {  0x0f54, X, FP|M, CPUSSE}},
{"cmpeqps",  {XMMReg|LLongMem, XMMReg, 0},   {  0x0fc2, 0, FP|M|ImmExt, CPUSSE}},
{"cmpeqss",  {XMMReg|WordMem, XMMReg, 0},    {0xf30fc2, 0, FP|M|ImmExt, CPUSSE}},
{"cmpleps",  {XMMReg|LLongMem, XMMReg, 0},   {  0x0fc2, 2, FP|M|ImmExt, CPUSSE}},
{"cmpless",  {XMMReg|WordMem, XMMReg, 0},    {0xf30fc2, 2, FP|M|ImmExt, CPUSSE}},
{"cmpltps",  {XMMReg|LLongMem, XMMReg, 0},   {  0x0fc2, 1, FP|M|ImmExt, CPUSSE}},
{"cmpltss",  {XMMReg|WordMem, XMMReg, 0},    {0xf30fc2, 1, FP|M|ImmExt, CPUSSE}},
{"cmpneqps", {XMMReg|LLongMem, XMMReg, 0},   {  0x0fc2, 4, FP|M|ImmExt, CPUSSE}},
{"cmpneqss", {XMMReg|WordMem, XMMReg, 0},    {0xf30fc2, 4, FP|M|ImmExt, CPUSSE}},
{"cmpnleps", {XMMReg|LLongMem, XMMReg, 0},   {  0x0fc2, 6, FP|M|ImmExt, CPUSSE}},
{"cmpnless", {XMMReg|WordMem, XMMReg, 0},    {0xf30fc2, 6, FP|M|ImmExt, CPUSSE}},
{"cmpnltps", {XMMReg|LLongMem, XMMReg, 0},   {  0x0fc2, 5, FP|M|ImmExt, CPUSSE}},
{"cmpnltss", {XMMReg|WordMem, XMMReg, 0},    {0xf30fc2, 5, FP|M|ImmExt, CPUSSE}},
{"cmpordps", {XMMReg|LLongMem, XMMReg, 0},   {  0x0fc2, 7, FP|M|ImmExt, CPUSSE}},
{"cmpordss", {XMMReg|WordMem, XMMReg, 0},    {0xf30fc2, 7, FP|M|ImmExt, CPUSSE}},
{"cmpunordps",{XMMReg|LLongMem, XMMReg, 0},   {  0x0fc2, 3, FP|M|ImmExt, CPUSSE}},
{"cmpunordss",{XMMReg|WordMem, XMMReg, 0},    {0xf30fc2, 3, FP|M|ImmExt, CPUSSE}},
{"cmpps",    {Imm8, XMMReg|LLongMem, XMMReg},{  0x0fc2, X, FP|M, CPUSSE}},
{"cmpss",    {Imm8, XMMReg|WordMem, XMMReg}, {0xf30fc2, X, FP|M, CPUSSE}},
{"comiss",   {XMMReg|WordMem, XMMReg, 0},    {  0x0f2f, X, FP|M, CPUSSE}},
{"cvtpi2ps", {MMXReg|LLongMem, XMMReg, 0},   {  0x0f2a, X, FP|M, CPUSSE}},
{"cvtps2pi", {XMMReg|LLongMem, MMXReg, 0},   {  0x0f2d, X, FP|M, CPUSSE}},
{"cvtsi2ss", {Reg32|Reg64|WordMem|LLongMem, XMMReg, 0},{0xf30f2a, X, LQ_Suf|IgnoreSize|M, CPUSSE}},
{"cvtss2si", {XMMReg|WordMem, Reg32|Reg64, 0},{0xf30f2d, X, LQ_Suf|IgnoreSize|M, CPUSSE}},
{"cvttps2pi",{XMMReg|LLongMem, MMXReg, 0},   {  0x0f2c, X, FP|M, CPUSSE}},
{"cvttss2si",{XMMReg|WordMem, Reg32|Reg64, 0},{0xf30f2c, X, LQ_Suf|IgnoreSize|M, CPUSSE}},
{"divps",    {XMMReg|LLongMem, XMMReg, 0},   {  0x0f5e, X, FP|M, CPUSSE}},
{"divss",    {XMMReg|WordMem, XMMReg, 0},    {0xf30f5e, X, FP|M, CPUSSE}},
{"ldmxcsr",  {WordMem, 0, 0},                {  0x0fae, 2, FP|M, CPUSSE}},
{"maskmovq", {MMXReg|InvMem, MMXReg, 0},     {  0x0ff7, X, FP|M, CPUSSE}},
{"maxps",    {XMMReg|LLongMem, XMMReg, 0},   {  0x0f5f, X, FP|M, CPUSSE}},
{"maxss",    {XMMReg|WordMem, XMMReg, 0},    {0xf30f5f, X, FP|M, CPUSSE}},
{"minps",    {XMMReg|LLongMem, XMMReg, 0},   {  0x0f5d, X, FP|M, CPUSSE}},
{"minss",    {XMMReg|WordMem, XMMReg, 0},    {0xf30f5d, X, FP|M, CPUSSE}},
{"movaps",   {XMMReg|LLongMem, XMMReg, 0},   {  0x0f28, X, FP|M, CPUSSE}},
{"movaps",   {XMMReg, XMMReg|LLongMem, 0},   {  0x0f29, X, FP|M, CPUSSE}},
{"movhlps",  {XMMReg|InvMem, XMMReg, 0},     {  0x0f12, X, FP|M, CPUSSE}},
{"movhps",   {LLongMem, XMMReg, 0},          {  0x0f16, X, FP|M, CPUSSE}},
{"movhps",   {XMMReg, LLongMem, 0},          {  0x0f17, X, FP|M, CPUSSE}},
{"movlhps",  {XMMReg|InvMem, XMMReg, 0},     {  0x0f16, X, FP|M, CPUSSE}},
{"movlps",   {LLongMem, XMMReg, 0},          {  0x0f12, X, FP|M, CPUSSE}},
{"movlps",   {XMMReg, LLongMem, 0},          {  0x0f13, X, FP|M, CPUSSE}},
{"movmskps", {XMMReg|InvMem, Reg32|Reg64, 0},{  0x0f50, X, LQ_Suf|IgnoreSize|M, CPUSSE}},
{"movntps",  {XMMReg, LLongMem, 0},          {  0x0f2b, X, FP|M, CPUSSE}},
{"movntq",   {MMXReg, LLongMem, 0},          {  0x0fe7, X, FP|M, CPUSSE}},
{"movntdq",  {XMMReg, LLongMem, 0},          {0x660fe7, X, FP|M, CPUSSE2}},
{"movss",    {XMMReg|WordMem, XMMReg, 0},    {0xf30f10, X, FP|M, CPUSSE}},
{"movss",    {XMMReg, XMMReg|WordMem, 0},    {0xf30f11, X, FP|M, CPUSSE}},
{"movups",   {XMMReg|LLongMem, XMMReg, 0},   {  0x0f10, X, FP|M, CPUSSE}},
{"movups",   {XMMReg, XMMReg|LLongMem, 0},   {  0x0f11, X, FP|M, CPUSSE}},
{"mulps",    {XMMReg|LLongMem, XMMReg, 0},   {  0x0f59, X, FP|M, CPUSSE}},
{"mulss",    {XMMReg|WordMem, XMMReg, 0},    {0xf30f59, X, FP|M, CPUSSE}},
{"orps",     {XMMReg|LLongMem, XMMReg, 0},   {  0x0f56, X, FP|M, CPUSSE}},
{"pavgb",    {MMXReg|LLongMem, MMXReg, 0},   {  0x0fe0, X, FP|M, CPUSSE}},
{"pavgb",    {XMMReg|LLongMem, XMMReg, 0},   {0x660fe0, X, FP|M, CPUSSE2}},
{"pavgw",    {MMXReg|LLongMem, MMXReg, 0},   {  0x0fe3, X, FP|M, CPUSSE}},
{"pavgw",    {XMMReg|LLongMem, XMMReg, 0},   {0x660fe3, X, FP|M, CPUSSE2}},
{"pextrw",   {Imm8, MMXReg|InvMem, Reg32|Reg64},{  0x0fc5, X, LQ_Suf|IgnoreSize|M, CPUSSE}},
{"pextrw",   {Imm8, XMMReg|InvMem, Reg32|Reg64},{0x660fc5, X, LQ_Suf|IgnoreSize|M, CPUSSE2}},
{"pinsrw",   {Imm8, Reg32|Reg64|ShortMem, MMXReg},{  0x0fc4, X, LQ_Suf|IgnoreSize|M, CPUSSE}},
{"pinsrw",   {Imm8, Reg32|Reg64|ShortMem, XMMReg},{0x660fc4, X, LQ_Suf|IgnoreSize|M, CPUSSE2}},
{"pmaxsw",   {MMXReg|LLongMem, MMXReg, 0},   {  0x0fee, X, FP|M, CPUSSE}},
{"pmaxsw",   {XMMReg|LLongMem, XMMReg, 0},   {0x660fee, X, FP|M, CPUSSE2}},
{"pmaxub",   {MMXReg|LLongMem, MMXReg, 0},   {  0x0fde, X, FP|M, CPUSSE}},
{"pmaxub",   {XMMReg|LLongMem, XMMReg, 0},   {0x660fde, X, FP|M, CPUSSE2}},
{"pminsw",   {MMXReg|LLongMem, MMXReg, 0},   {  0x0fea, X, FP|M, CPUSSE}},
{"pminsw",   {XMMReg|LLongMem, XMMReg, 0},   {0x660fea, X, FP|M, CPUSSE2}},
{"pminub",   {MMXReg|LLongMem, MMXReg, 0},   {  0x0fda, X, FP|M, CPUSSE}},
{"pminub",   {XMMReg|LLongMem, XMMReg, 0},   {0x660fda, X, FP|M, CPUSSE2}},
{"pmovmskb", {MMXReg|InvMem, Reg32|Reg64, 0},{  0x0fd7, X, LQ_Suf|IgnoreSize|M, CPUSSE}},
{"pmovmskb", {XMMReg|InvMem, Reg32|Reg64, 0},{0x660fd7, X, LQ_Suf|IgnoreSize|M, CPUSSE2}},
{"pmulhuw",  {MMXReg|LLongMem, MMXReg, 0},   {  0x0fe4, X, FP|M, CPUSSE}},
{"pmulhuw",  {XMMReg|LLongMem, XMMReg, 0},   {0x660fe4, X, FP|M, CPUSSE2}},
{"prefetchnta",{LLongMem, 0, 0},               {  0x0f18, 0, FP|M, CPUSSE}},
{"prefetcht0",{LLongMem, 0, 0},               {  0x0f18, 1, FP|M, CPUSSE}},
{"prefetcht1",{LLongMem, 0, 0},               {  0x0f18, 2, FP|M, CPUSSE}},
{"prefetcht2",{LLongMem, 0, 0},               {  0x0f18, 3, FP|M, CPUSSE}},
{"psadbw",   {MMXReg|LLongMem, MMXReg, 0},   {  0x0ff6, X, FP|M, CPUSSE}},
{"psadbw",   {XMMReg|LLongMem, XMMReg, 0},   {0x660ff6, X, FP|M, CPUSSE2}},
{"pshufw",   {Imm8, MMXReg|LLongMem, MMXReg},{  0x0f70, X, FP|M, CPUSSE}},
{"rcpps",    {XMMReg|LLongMem, XMMReg, 0},   {  0x0f53, X, FP|M, CPUSSE}},
{"rcpss",    {XMMReg|WordMem, XMMReg, 0},    {0xf30f53, X, FP|M, CPUSSE}},
{"rsqrtps",  {XMMReg|LLongMem, XMMReg, 0},   {  0x0f52, X, FP|M, CPUSSE}},
{"rsqrtss",  {XMMReg|WordMem, XMMReg, 0},    {0xf30f52, X, FP|M, CPUSSE}},
{"sfence",   {0, 0, 0},                      {  0x0fae, 0xf8, FP|ImmExt, CPUSSE}},
{"shufps",   {Imm8, XMMReg|LLongMem, XMMReg},{  0x0fc6, X, FP|M, CPUSSE}},
{"sqrtps",   {XMMReg|LLongMem, XMMReg, 0},   {  0x0f51, X, FP|M, CPUSSE}},
{"sqrtss",   {XMMReg|WordMem, XMMReg, 0},    {0xf30f51, X, FP|M, CPUSSE}},
{"stmxcsr",  {WordMem, 0, 0},                {  0x0fae, 3, FP|M, CPUSSE}},
{"subps",    {XMMReg|LLongMem, XMMReg, 0},   {  0x0f5c, X, FP|M, CPUSSE}},
{"subss",    {XMMReg|WordMem, XMMReg, 0},    {0xf30f5c, X, FP|M, CPUSSE}},
{"ucomiss",  {XMMReg|WordMem, XMMReg, 0},    {  0x0f2e, X, FP|M, CPUSSE}},
{"unpckhps", {XMMReg|LLongMem, XMMReg, 0},   {  0x0f15, X, FP|M, CPUSSE}},
{"unpcklps", {XMMReg|LLongMem, XMMReg, 0},   {  0x0f14, X, FP|M, CPUSSE}},
{"xorps",    {XMMReg|LLongMem, XMMReg, 0},   {  0x0f57, X, FP|M, CPUSSE}},
{"addpd",    {XMMReg|LLongMem, XMMReg, 0},   {0x660f58, X, FP|M, CPUSSE2}},
{"addsd",    {XMMReg|LongMem, XMMReg, 0},    {0xf20f58, X, FP|M, CPUSSE2}},
{"andnpd",   {XMMReg|LLongMem, XMMReg, 0},   {0x660f55, X, FP|M, CPUSSE2}},
{"andpd",    {XMMReg|WordMem, XMMReg, 0},    {0x660f54, X, FP|M, CPUSSE2}},
{"cmpeqpd",  {XMMReg|LLongMem, XMMReg, 0},   {0x660fc2, 0, FP|M|ImmExt, CPUSSE2}},
{"cmpeqsd",  {XMMReg|LongMem, XMMReg, 0},    {0xf20fc2, 0, FP|M|ImmExt, CPUSSE2}},
{"cmplepd",  {XMMReg|LLongMem, XMMReg, 0},   {0x660fc2, 2, FP|M|ImmExt, CPUSSE2}},
{"cmplesd",  {XMMReg|LongMem, XMMReg, 0},    {0xf20fc2, 2, FP|M|ImmExt, CPUSSE2}},
{"cmpltpd",  {XMMReg|LLongMem, XMMReg, 0},   {0x660fc2, 1, FP|M|ImmExt, CPUSSE2}},
{"cmpltsd",  {XMMReg|LongMem, XMMReg, 0},    {0xf20fc2, 1, FP|M|ImmExt, CPUSSE2}},
{"cmpneqpd", {XMMReg|LLongMem, XMMReg, 0},   {0x660fc2, 4, FP|M|ImmExt, CPUSSE2}},
{"cmpneqsd", {XMMReg|LongMem, XMMReg, 0},    {0xf20fc2, 4, FP|M|ImmExt, CPUSSE2}},
{"cmpnlepd", {XMMReg|LLongMem, XMMReg, 0},   {0x660fc2, 6, FP|M|ImmExt, CPUSSE2}},
{"cmpnlesd", {XMMReg|LongMem, XMMReg, 0},    {0xf20fc2, 6, FP|M|ImmExt, CPUSSE2}},
{"cmpnltpd", {XMMReg|LLongMem, XMMReg, 0},   {0x660fc2, 5, FP|M|ImmExt, CPUSSE2}},
{"cmpnltsd", {XMMReg|LongMem, XMMReg, 0},    {0xf20fc2, 5, FP|M|ImmExt, CPUSSE2}},
{"cmpordpd", {XMMReg|LLongMem, XMMReg, 0},   {0x660fc2, 7, FP|M|ImmExt, CPUSSE2}},
{"cmpordsd", {XMMReg|LongMem, XMMReg, 0},    {0xf20fc2, 7, FP|M|ImmExt, CPUSSE2}},
{"cmpunordpd",{XMMReg|LLongMem, XMMReg, 0},   {0x660fc2, 3, FP|M|ImmExt, CPUSSE2}},
{"cmpunordsd",{XMMReg|LongMem, XMMReg, 0},    {0xf20fc2, 3, FP|M|ImmExt, CPUSSE2}},
{"cmppd",    {Imm8, XMMReg|LLongMem, XMMReg},{0x660fc2, X, FP|M, CPUSSE2}},
{"cmpsd",    {0, 0, 0},                      {    0xa7, X, NoSuf|Size32|StrInst, 0}},
{"cmpsd",    {AnyMem, AnyMem|EsSeg, 0},      {    0xa7, X, NoSuf|Size32|StrInst, 0}},
{"cmpsd",    {Imm8, XMMReg|LongMem, XMMReg}, {0xf20fc2, X, FP|M, CPUSSE2}},
{"comisd",   {XMMReg|LongMem, XMMReg, 0},    {0x660f2f, X, FP|M, CPUSSE2}},
{"cvtpi2pd", {MMXReg|LLongMem, XMMReg, 0},   {0x660f2a, X, FP|M, CPUSSE2}},
{"cvtsi2sd", {Reg32|Reg64|WordMem|LLongMem, XMMReg, 0},{0xf20f2a, X, LQ_Suf|IgnoreSize|M, CPUSSE2}},
{"divpd",    {XMMReg|LLongMem, XMMReg, 0},   {0x660f5e, X, FP|M, CPUSSE2}},
{"divsd",    {XMMReg|LongMem, XMMReg, 0},    {0xf20f5e, X, FP|M, CPUSSE2}},
{"maxpd",    {XMMReg|LLongMem, XMMReg, 0},   {0x660f5f, X, FP|M, CPUSSE2}},
{"maxsd",    {XMMReg|LongMem, XMMReg, 0},    {0xf20f5f, X, FP|M, CPUSSE2}},
{"minpd",    {XMMReg|LLongMem, XMMReg, 0},   {0x660f5d, X, FP|M, CPUSSE2}},
{"minsd",    {XMMReg|LongMem, XMMReg, 0},    {0xf20f5d, X, FP|M, CPUSSE2}},
{"movapd",   {XMMReg|LLongMem, XMMReg, 0},   {0x660f28, X, FP|M, CPUSSE2}},
{"movapd",   {XMMReg, XMMReg|LLongMem, 0},   {0x660f29, X, FP|M, CPUSSE2}},
{"movhpd",   {LLongMem, XMMReg, 0},          {0x660f16, X, FP|M, CPUSSE2}},
{"movhpd",   {XMMReg, LLongMem, 0},          {0x660f17, X, FP|M, CPUSSE2}},
{"movlpd",   {LLongMem, XMMReg, 0},          {0x660f12, X, FP|M, CPUSSE2}},
{"movlpd",   {XMMReg, LLongMem, 0},          {0x660f13, X, FP|M, CPUSSE2}},
{"movmskpd", {XMMReg|InvMem, Reg32|Reg64, 0},{0x660f50, X, LQ_Suf|IgnoreSize|M, CPUSSE2}},
{"movntpd",  {XMMReg, LLongMem, 0},          {0x660f2b, X, FP|M, CPUSSE2}},
{"movsd",    {0, 0, 0},                      {    0xa5, X, NoSuf|Size32|StrInst, 0}},
{"movsd",    {AnyMem, AnyMem|EsSeg, 0},      {    0xa5, X, NoSuf|Size32|StrInst, 0}},
{"movsd",    {XMMReg|LongMem, XMMReg, 0},    {0xf20f10, X, FP|M, CPUSSE2}},
{"movsd",    {XMMReg, XMMReg|LongMem, 0},    {0xf20f11, X, FP|M, CPUSSE2}},
{"movupd",   {XMMReg|LLongMem, XMMReg, 0},   {0x660f10, X, FP|M, CPUSSE2}},
{"movupd",   {XMMReg, XMMReg|LLongMem, 0},   {0x660f11, X, FP|M, CPUSSE2}},
{"mulpd",    {XMMReg|LLongMem, XMMReg, 0},   {0x660f59, X, FP|M, CPUSSE2}},
{"mulsd",    {XMMReg|LongMem, XMMReg, 0},    {0xf20f59, X, FP|M, CPUSSE2}},
{"orpd",     {XMMReg|LLongMem, XMMReg, 0},   {0x660f56, X, FP|M, CPUSSE2}},
{"shufpd",   {Imm8, XMMReg|LLongMem, XMMReg},{0x660fc6, X, FP|M, CPUSSE2}},
{"sqrtpd",   {XMMReg|LLongMem, XMMReg, 0},   {0x660f51, X, FP|M, CPUSSE2}},
{"sqrtsd",   {XMMReg|LongMem, XMMReg, 0},    {0xf20f51, X, FP|M, CPUSSE2}},
{"subpd",    {XMMReg|LLongMem, XMMReg, 0},   {0x660f5c, X, FP|M, CPUSSE2}},
{"subsd",    {XMMReg|LongMem, XMMReg, 0},    {0xf20f5c, X, FP|M, CPUSSE2}},
{"ucomisd",  {XMMReg|LongMem, XMMReg, 0},    {0x660f2e, X, FP|M, CPUSSE2}},
{"unpckhpd", {XMMReg|LLongMem, XMMReg, 0},   {0x660f15, X, FP|M, CPUSSE2}},
{"unpcklpd", {XMMReg|LLongMem, XMMReg, 0},   {0x660f14, X, FP|M, CPUSSE2}},
{"xorpd",    {XMMReg|LLongMem, XMMReg, 0},   {0x660f57, X, FP|M, CPUSSE2}},
{"cvtdq2pd", {XMMReg|LLongMem, XMMReg, 0},   {0xf30fe6, X, FP|M, CPUSSE2}},
{"cvtpd2dq", {XMMReg|LLongMem, XMMReg, 0},   {0xf20fe6, X, FP|M, CPUSSE2}},
{"cvtdq2ps", {XMMReg|LLongMem, XMMReg, 0},   {  0x0f5b, X, FP|M, CPUSSE2}},
{"cvtpd2pi", {XMMReg|LLongMem, MMXReg, 0},   {0x660f2d, X, FP|M, CPUSSE2}},
{"cvtpd2ps", {XMMReg|LLongMem, XMMReg, 0},   {0x660f5a, X, FP|M, CPUSSE2}},
{"cvtps2pd", {XMMReg|LLongMem, XMMReg, 0},   {  0x0f5a, X, FP|M, CPUSSE2}},
{"cvtps2dq", {XMMReg|LLongMem, XMMReg, 0},   {0x660f5b, X, FP|M, CPUSSE2}},
{"cvtsd2si", {XMMReg|LLongMem, Reg32|Reg64, 0},{0xf20f2d, X, LQ_Suf|IgnoreSize|M, CPUSSE2}},
{"cvtsd2ss", {XMMReg|LLongMem, XMMReg, 0},   {0xf20f5a, X, FP|M, CPUSSE2}},
{"cvtss2sd", {XMMReg|LLongMem, XMMReg, 0},   {0xf30f5a, X, FP|M, CPUSSE2}},
{"cvttpd2pi",{XMMReg|LLongMem, MMXReg, 0},   {0x660f2c, X, FP|M, CPUSSE2}},
{"cvttsd2si",{XMMReg|WordMem, Reg32|Reg64, 0},{0xf20f2c, X, LQ_Suf|IgnoreSize|M, CPUSSE2}},
{"cvttpd2dq",{XMMReg|LLongMem, XMMReg, 0},   {0x660fe6, X, FP|M, CPUSSE2}},
{"cvttps2dq",{XMMReg|LLongMem, XMMReg, 0},   {0xf30f5b, X, FP|M, CPUSSE2}},
{"maskmovdqu",{XMMReg|InvMem, XMMReg, 0},     {0x660ff7, X, FP|M, CPUSSE2}},
{"movdqa",   {XMMReg|LLongMem, XMMReg, 0},   {0x660f6f, X, FP|M, CPUSSE2}},
{"movdqa",   {XMMReg, XMMReg|LLongMem, 0},   {0x660f7f, X, FP|M, CPUSSE2}},
{"movdqu",   {XMMReg|LLongMem, XMMReg, 0},   {0xf30f6f, X, FP|M, CPUSSE2}},
{"movdqu",   {XMMReg, XMMReg|LLongMem, 0},   {0xf30f7f, X, FP|M, CPUSSE2}},
{"movdq2q",  {XMMReg|InvMem, MMXReg, 0},     {0xf20fd6, X, FP|M, CPUSSE2}},
{"movq2dq",  {MMXReg|InvMem, XMMReg, 0},     {0xf30fd6, X, FP|M, CPUSSE2}},
{"pmuludq",  {MMXReg|LongMem, MMXReg, 0},    {  0x0ff4, X, FP|M, CPUSSE2}},
{"pmuludq",  {XMMReg|LongMem, XMMReg, 0},    {0x660ff4, X, FP|M, CPUSSE2}},
{"pshufd",   {Imm8, XMMReg|LLongMem, XMMReg},{0x660f70, X, FP|M, CPUSSE2}},
{"pshufhw",  {Imm8, XMMReg|LLongMem, XMMReg},{0xf30f70, X, FP|M, CPUSSE2}},
{"pshuflw",  {Imm8, XMMReg|LLongMem, XMMReg},{0xf20f70, X, FP|M, CPUSSE2}},
{"pslldq",   {Imm8, XMMReg, 0},              {0x660f73, 7, FP|M, CPUSSE2}},
{"psrldq",   {Imm8, XMMReg, 0},              {0x660f73, 3, FP|M, CPUSSE2}},
{"punpckhqdq",{XMMReg|LLongMem, XMMReg, 0},   {0x660f6d, X, FP|M, CPUSSE2}},
{"punpcklqdq",{XMMReg|LLongMem, XMMReg, 0},   {0x660f6c, X, FP|M, CPUSSE2}},
{"addsubpd", {XMMReg|LLongMem, XMMReg, 0},   {0x660fd0, X, FP|M, CPUPNI}},
{"addsubps", {XMMReg|LLongMem, XMMReg, 0},   {0xf20fd0, X, FP|M, CPUPNI}},
{"fisttp",   {ShortMem|LongMem, 0, 0},       {    0xdf, 1, SL_FP|FloatMF|M, CPUPNI}},
{"fisttpd",  {LLongMem, 0, 0},               {    0xdd, 1, FP|M, CPUPNI}},
{"fisttpq",  {LLongMem, 0, 0},               {    0xdd, 1, FP|M, CPUPNI}},
{"fisttpll", {LLongMem, 0, 0},               {    0xdd, 1, FP|M, CPUPNI}},
{"haddpd",   {XMMReg|LLongMem, XMMReg, 0},   {0x660f7c, X, FP|M, CPUPNI}},
{"haddps",   {XMMReg|LLongMem, XMMReg, 0},   {0xf20f7c, X, FP|M, CPUPNI}},
{"hsubpd",   {XMMReg|LLongMem, XMMReg, 0},   {0x660f7d, X, FP|M, CPUPNI}},
{"hsubps",   {XMMReg|LLongMem, XMMReg, 0},   {0xf20f7d, X, FP|M, CPUPNI}},
{"lddqu",    {LLongMem, XMMReg, 0},          {0xf20ff0, X, FP|M, CPUPNI}},
{"monitor",  {0, 0, 0},                      {  0x0f01, 0xc8, FP|ImmExt, CPUPNI}},
{"monitor",  {Reg32, Reg32, Reg32},          {  0x0f01, 0xc8, FP|ImmExt, CPUPNI}},
{"movddup",  {XMMReg|LLongMem, XMMReg, 0},   {0xf20f12, X, FP|M, CPUPNI}},
{"movshdup", {XMMReg|LLongMem, XMMReg, 0},   {0xf30f16, X, FP|M, CPUPNI}},
{"movsldup", {XMMReg|LLongMem, XMMReg, 0},   {0xf30f12, X, FP|M, CPUPNI}},
{"mwait",    {0, 0, 0},                      {  0x0f01, 0xc9, FP|ImmExt, CPUPNI}},
{"mwait",    {Reg32, Reg32, 0},              {  0x0f01, 0xc9, FP|ImmExt, CPUPNI}},
{"prefetch", {ByteMem, 0, 0},                {  0x0f0d, 0, FP|M, CPU3dnow}},
{"prefetchw",{ByteMem, 0, 0},                {  0x0f0d, 1, FP|M, CPU3dnow}},
{"femms",    {0, 0, 0},                      {  0x0f0e, X, FP, CPU3dnow}},
{"pavgusb",  {MMXReg|LongMem, MMXReg, 0},    {  0x0f0f, 0xbf, FP|M|ImmExt, CPU3dnow}},
{"pf2id",    {MMXReg|LongMem, MMXReg, 0},    {  0x0f0f, 0x1d, FP|M|ImmExt, CPU3dnow}},
{"pf2iw",    {MMXReg|LongMem, MMXReg, 0},    {  0x0f0f, 0x1c, FP|M|ImmExt, CPU3dnow|CPU686}},
{"pfacc",    {MMXReg|LongMem, MMXReg, 0},    {  0x0f0f, 0xae, FP|M|ImmExt, CPU3dnow}},
{"pfadd",    {MMXReg|LongMem, MMXReg, 0},    {  0x0f0f, 0x9e, FP|M|ImmExt, CPU3dnow}},
{"pfcmpeq",  {MMXReg|LongMem, MMXReg, 0},    {  0x0f0f, 0xb0, FP|M|ImmExt, CPU3dnow}},
{"pfcmpge",  {MMXReg|LongMem, MMXReg, 0},    {  0x0f0f, 0x90, FP|M|ImmExt, CPU3dnow}},
{"pfcmpgt",  {MMXReg|LongMem, MMXReg, 0},    {  0x0f0f, 0xa0, FP|M|ImmExt, CPU3dnow}},
{"pfmax",    {MMXReg|LongMem, MMXReg, 0},    {  0x0f0f, 0xa4, FP|M|ImmExt, CPU3dnow}},
{"pfmin",    {MMXReg|LongMem, MMXReg, 0},    {  0x0f0f, 0x94, FP|M|ImmExt, CPU3dnow}},
{"pfmul",    {MMXReg|LongMem, MMXReg, 0},    {  0x0f0f, 0xb4, FP|M|ImmExt, CPU3dnow}},
{"pfnacc",   {MMXReg|LongMem, MMXReg, 0},    {  0x0f0f, 0x8a, FP|M|ImmExt, CPU3dnow|CPU686}},
{"pfpnacc",  {MMXReg|LongMem, MMXReg, 0},    {  0x0f0f, 0x8e, FP|M|ImmExt, CPU3dnow|CPU686}},
{"pfrcp",    {MMXReg|LongMem, MMXReg, 0},    {  0x0f0f, 0x96, FP|M|ImmExt, CPU3dnow}},
{"pfrcpit1", {MMXReg|LongMem, MMXReg, 0},    {  0x0f0f, 0xa6, FP|M|ImmExt, CPU3dnow}},
{"pfrcpit2", {MMXReg|LongMem, MMXReg, 0},    {  0x0f0f, 0xb6, FP|M|ImmExt, CPU3dnow}},
{"pfrsqit1", {MMXReg|LongMem, MMXReg, 0},    {  0x0f0f, 0xa7, FP|M|ImmExt, CPU3dnow}},
{"pfrsqrt",  {MMXReg|LongMem, MMXReg, 0},    {  0x0f0f, 0x97, FP|M|ImmExt, CPU3dnow}},
{"pfsub",    {MMXReg|LongMem, MMXReg, 0},    {  0x0f0f, 0x9a, FP|M|ImmExt, CPU3dnow}},
{"pfsubr",   {MMXReg|LongMem, MMXReg, 0},    {  0x0f0f, 0xaa, FP|M|ImmExt, CPU3dnow}},
{"pi2fd",    {MMXReg|LongMem, MMXReg, 0},    {  0x0f0f, 0x0d, FP|M|ImmExt, CPU3dnow}},
{"pi2fw",    {MMXReg|LongMem, MMXReg, 0},    {  0x0f0f, 0x0c, FP|M|ImmExt, CPU3dnow|CPU686}},
{"pmulhrw",  {MMXReg|LongMem, MMXReg, 0},    {  0x0f0f, 0xb7, FP|M|ImmExt, CPU3dnow}},
{"pswapd",   {MMXReg|LongMem, MMXReg, 0},    {  0x0f0f, 0xbb, FP|M|ImmExt, CPU3dnow|CPU686}},
{"syscall",  {0, 0, 0},                      {  0x0f05, X, NoSuf, CPUK6}},
{"sysret",   {0, 0, 0},                      {  0x0f07, X, LQ_Suf|DefaultSize, CPUK6}},
{"swapgs",   {0, 0, 0},                      {  0x0f01, 0xf8, NoSuf|ImmExt, CPU64}},
{"",         {0, 0, 0},                      {       0,    0, NoSuf, 0}}


#undef NoSuf
#undef B_Suf
#undef W_Suf
#undef L_Suf
#undef Q_Suf
#undef X_Suf
#undef WL_Suf
#undef WLQ_Suf
#undef LQ_Suf
#undef WQ_Suf
#undef SL_Suf
#undef BWL_Suf
#undef BWLQ_Suf
#undef FP
#undef L_FP
#undef X_FP
#undef SL_FP
#undef X
