/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.asm.sparc;

import sun.jvm.hotspot.asm.RTLDataTypes;
import sun.jvm.hotspot.asm.sparc.SPARCFloatRegister;
import sun.jvm.hotspot.asm.sparc.SPARCFloatRegisters;
import sun.jvm.hotspot.asm.sparc.SPARCRegister;
import sun.jvm.hotspot.asm.sparc.SPARCRegisters;

class RegisterDecoder
implements RTLDataTypes {
    RegisterDecoder() {
    }

    private static SPARCFloatRegister decodeDouble(int num) {
        boolean lsb;
        boolean bl = lsb = (1 & num) != 0;
        if (lsb) {
            num |= 0x20;
        }
        if (num % 2 != 0) {
            return null;
        }
        return SPARCFloatRegisters.getRegister(num);
    }

    private static SPARCFloatRegister decodeQuad(int num) {
        boolean lsb;
        boolean bl = lsb = (1 & num) != 0;
        if (lsb) {
            num |= 0x20;
        }
        if (num % 4 != 0) {
            return null;
        }
        return SPARCFloatRegisters.getRegister(num);
    }

    static SPARCRegister decode(int dataType, int regNum) {
        regNum &= 0x1F;
        SPARCRegister result = null;
        switch (dataType) {
            case 10: {
                result = SPARCFloatRegisters.getRegister(regNum);
                break;
            }
            case 11: {
                result = RegisterDecoder.decodeDouble(regNum);
                break;
            }
            case 13: {
                result = RegisterDecoder.decodeQuad(regNum);
                break;
            }
            case 0x7FFFFFFF: {
                result = null;
                break;
            }
            default: {
                result = SPARCRegisters.getRegister(regNum);
            }
        }
        return result;
    }
}

