/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.asm.x86;

import sun.jvm.hotspot.asm.Immediate;
import sun.jvm.hotspot.asm.ImmediateOrRegister;
import sun.jvm.hotspot.asm.Operand;
import sun.jvm.hotspot.asm.Register;
import sun.jvm.hotspot.asm.ShiftInstruction;
import sun.jvm.hotspot.asm.SymbolFinder;
import sun.jvm.hotspot.asm.x86.X86Instruction;

public class X86ShiftInstruction
extends X86Instruction
implements ShiftInstruction {
    private final int operation;
    private final Operand operand1;
    private final ImmediateOrRegister operand2;

    public X86ShiftInstruction(String name, int operation, Operand operand1, ImmediateOrRegister operand2, int size, int prefixes) {
        super(name, size, prefixes);
        this.operand1 = operand1;
        this.operand2 = operand2;
        this.operation = operation;
    }

    @Override
    public String asString(long currentPc, SymbolFinder symFinder) {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getPrefixString());
        buf.append(this.getName());
        buf.append(spaces);
        buf.append(this.getOperandAsString(this.operand1));
        if (this.operand2 != null) {
            buf.append(comma);
            if (this.operand2 instanceof Register) {
                buf.append(this.operand2.toString());
            } else {
                Number number = ((Immediate)this.operand2).getNumber();
                buf.append("0x");
                buf.append(Integer.toHexString(number.intValue()));
            }
        }
        return buf.toString();
    }

    public int getOperation() {
        return this.operation;
    }

    @Override
    public Operand getShiftDestination() {
        return this.operand1;
    }

    @Override
    public Operand getShiftLength() {
        return this.operand2;
    }

    @Override
    public Operand getShiftSource() {
        return this.operand1;
    }

    @Override
    public boolean isShift() {
        return true;
    }

    protected String getOperand2String() {
        return this.operand2.toString();
    }
}

