/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.oops;

import java.io.PrintStream;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.oops.Klass;
import sun.jvm.hotspot.oops.ObjectHeap;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.types.WrongTypeException;

public class KlassKlass
extends Klass {
    private static long headerSize;

    private static synchronized void initialize(TypeDataBase db) throws WrongTypeException {
        Type type = db.lookupType("klassKlass");
        headerSize = type.getSize() + Oop.getHeaderSize();
    }

    KlassKlass(OopHandle handle, ObjectHeap heap) {
        super(handle, heap);
    }

    @Override
    public long getObjectSize() {
        return KlassKlass.alignObjectSize(headerSize);
    }

    @Override
    public void printValueOn(PrintStream tty) {
        tty.print("KlassKlass");
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                KlassKlass.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

