/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParametersSpi;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.MGF1ParameterSpec;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;
import sun.security.util.Debug;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AlgorithmId;

public final class OAEPParameters
extends AlgorithmParametersSpi {
    private String mdName;
    private MGF1ParameterSpec mgfSpec;
    private byte[] p;
    private static ObjectIdentifier OID_MGF1;
    private static ObjectIdentifier OID_PSpecified;

    @Override
    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (!(algorithmParameterSpec instanceof OAEPParameterSpec)) {
            throw new InvalidParameterSpecException("Inappropriate parameter specification");
        }
        OAEPParameterSpec oAEPParameterSpec = (OAEPParameterSpec)algorithmParameterSpec;
        this.mdName = oAEPParameterSpec.getDigestAlgorithm();
        String string = oAEPParameterSpec.getMGFAlgorithm();
        if (!string.equalsIgnoreCase("MGF1")) {
            throw new InvalidParameterSpecException("Unsupported mgf " + string + "; MGF1 only");
        }
        AlgorithmParameterSpec algorithmParameterSpec2 = oAEPParameterSpec.getMGFParameters();
        if (!(algorithmParameterSpec2 instanceof MGF1ParameterSpec)) {
            throw new InvalidParameterSpecException("Inappropriate mgf parameters; non-null MGF1ParameterSpec only");
        }
        this.mgfSpec = (MGF1ParameterSpec)algorithmParameterSpec2;
        PSource pSource = oAEPParameterSpec.getPSource();
        if (!pSource.getAlgorithm().equals("PSpecified")) {
            throw new InvalidParameterSpecException("Unsupported pSource " + pSource.getAlgorithm() + "; PSpecified only");
        }
        this.p = ((PSource.PSpecified)pSource).getValue();
    }

    @Override
    protected void engineInit(byte[] byArray) throws IOException {
        DerInputStream derInputStream = new DerInputStream(byArray);
        this.mdName = "SHA-1";
        this.mgfSpec = MGF1ParameterSpec.SHA1;
        this.p = new byte[0];
        DerValue[] derValueArray = derInputStream.getSequence(3);
        for (int i = 0; i < derValueArray.length; ++i) {
            Object object;
            byte[] byArray2;
            AlgorithmId algorithmId;
            DerValue derValue = derValueArray[i];
            if (derValue.isContextSpecific((byte)0)) {
                this.mdName = AlgorithmId.getStandardDigestName((String)AlgorithmId.parse(derValue.data.getDerValue()).getName());
                continue;
            }
            if (derValue.isContextSpecific((byte)1)) {
                algorithmId = AlgorithmId.parse(derValue.data.getDerValue());
                if (!algorithmId.getOID().equals(OID_MGF1)) {
                    throw new IOException("Only MGF1 mgf is supported");
                }
                byArray2 = algorithmId.getEncodedParams();
                if (byArray2 == null) {
                    throw new IOException("Missing MGF1 parameters");
                }
                object = AlgorithmId.parse(new DerValue(byArray2));
                String string = AlgorithmId.getStandardDigestName((String)((AlgorithmId)object).getName());
                if (string.equals("SHA-1")) {
                    this.mgfSpec = MGF1ParameterSpec.SHA1;
                    continue;
                }
                if (string.equals("SHA-224")) {
                    this.mgfSpec = new MGF1ParameterSpec("SHA-224");
                    continue;
                }
                if (string.equals("SHA-256")) {
                    this.mgfSpec = MGF1ParameterSpec.SHA256;
                    continue;
                }
                if (string.equals("SHA-384")) {
                    this.mgfSpec = MGF1ParameterSpec.SHA384;
                    continue;
                }
                if (string.equals("SHA-512")) {
                    this.mgfSpec = MGF1ParameterSpec.SHA512;
                    continue;
                }
                throw new IOException("Unrecognized message digest algorithm");
            }
            if (derValue.isContextSpecific((byte)2)) {
                algorithmId = AlgorithmId.parse(derValue.data.getDerValue());
                if (!algorithmId.getOID().equals(OID_PSpecified)) {
                    throw new IOException("Wrong OID for pSpecified");
                }
                byArray2 = algorithmId.getEncodedParams();
                if (byArray2 == null) {
                    throw new IOException("Missing pSpecified label");
                }
                object = new DerInputStream(byArray2);
                this.p = ((DerInputStream)object).getOctetString();
                if (((DerInputStream)object).available() == 0) continue;
                throw new IOException("Extra data for pSpecified");
            }
            throw new IOException("Invalid encoded OAEPParameters");
        }
    }

    @Override
    protected void engineInit(byte[] byArray, String string) throws IOException {
        if (string != null && !string.equalsIgnoreCase("ASN.1")) {
            throw new IllegalArgumentException("Only support ASN.1 format");
        }
        this.engineInit(byArray);
    }

    @Override
    protected <T extends AlgorithmParameterSpec> T engineGetParameterSpec(Class<T> clazz) throws InvalidParameterSpecException {
        if (OAEPParameterSpec.class.isAssignableFrom(clazz)) {
            return (T)((AlgorithmParameterSpec)clazz.cast(new OAEPParameterSpec(this.mdName, "MGF1", this.mgfSpec, new PSource.PSpecified(this.p))));
        }
        throw new InvalidParameterSpecException("Inappropriate parameter specification");
    }

    @Override
    protected byte[] engineGetEncoded() throws IOException {
        AlgorithmId algorithmId;
        AlgorithmId algorithmId2;
        DerOutputStream derOutputStream = new DerOutputStream();
        try {
            algorithmId2 = AlgorithmId.get(this.mdName);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IOException("AlgorithmId " + this.mdName + " impl not found");
        }
        DerOutputStream derOutputStream2 = new DerOutputStream();
        algorithmId2.derEncode(derOutputStream2);
        derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)0), derOutputStream2);
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.putOID(OID_MGF1);
        try {
            algorithmId = AlgorithmId.get(this.mgfSpec.getDigestAlgorithm());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IOException("AlgorithmId " + this.mgfSpec.getDigestAlgorithm() + " impl not found");
        }
        algorithmId.encode(derOutputStream2);
        DerOutputStream derOutputStream3 = new DerOutputStream();
        derOutputStream3.write((byte)48, derOutputStream2);
        derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)1), derOutputStream3);
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.putOID(OID_PSpecified);
        derOutputStream2.putOctetString(this.p);
        derOutputStream3 = new DerOutputStream();
        derOutputStream3.write((byte)48, derOutputStream2);
        derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)2), derOutputStream3);
        DerOutputStream derOutputStream4 = new DerOutputStream();
        derOutputStream4.write((byte)48, derOutputStream);
        return derOutputStream4.toByteArray();
    }

    @Override
    protected byte[] engineGetEncoded(String string) throws IOException {
        if (string != null && !string.equalsIgnoreCase("ASN.1")) {
            throw new IllegalArgumentException("Only support ASN.1 format");
        }
        return this.engineGetEncoded();
    }

    @Override
    protected String engineToString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("MD: " + this.mdName + "\n");
        stringBuffer.append("MGF: MGF1" + this.mgfSpec.getDigestAlgorithm() + "\n");
        stringBuffer.append("PSource: PSpecified " + (this.p.length == 0 ? "" : Debug.toHexString(new BigInteger(this.p))) + "\n");
        return stringBuffer.toString();
    }

    static {
        try {
            OID_MGF1 = new ObjectIdentifier(new int[]{1, 2, 840, 113549, 1, 1, 8});
        }
        catch (IOException iOException) {
            OID_MGF1 = null;
        }
        try {
            OID_PSpecified = new ObjectIdentifier(new int[]{1, 2, 840, 113549, 1, 1, 9});
        }
        catch (IOException iOException) {
            OID_PSpecified = null;
        }
    }
}

