/*
 * Decompiled with CFR 0.152.
 */
package com.sun.imageio.plugins.png;

import com.sun.imageio.plugins.common.ReaderUtil;
import com.sun.imageio.plugins.png.PNGImageDataEnumeration;
import com.sun.imageio.plugins.png.PNGMetadata;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import javax.imageio.IIOException;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import sun.awt.image.ByteInterleavedRaster;

public class PNGImageReader
extends ImageReader {
    static final int IHDR_TYPE = 1229472850;
    static final int PLTE_TYPE = 1347179589;
    static final int IDAT_TYPE = 1229209940;
    static final int IEND_TYPE = 1229278788;
    static final int bKGD_TYPE = 1649100612;
    static final int cHRM_TYPE = 1665684045;
    static final int gAMA_TYPE = 1732332865;
    static final int hIST_TYPE = 1749635924;
    static final int iCCP_TYPE = 1766015824;
    static final int iTXt_TYPE = 1767135348;
    static final int pHYs_TYPE = 1883789683;
    static final int sBIT_TYPE = 1933723988;
    static final int sPLT_TYPE = 1934642260;
    static final int sRGB_TYPE = 1934772034;
    static final int tEXt_TYPE = 1950701684;
    static final int tIME_TYPE = 1950960965;
    static final int tRNS_TYPE = 1951551059;
    static final int zTXt_TYPE = 2052348020;
    static final int PNG_COLOR_GRAY = 0;
    static final int PNG_COLOR_RGB = 2;
    static final int PNG_COLOR_PALETTE = 3;
    static final int PNG_COLOR_GRAY_ALPHA = 4;
    static final int PNG_COLOR_RGB_ALPHA = 6;
    static final int[] inputBandsForColorType = new int[]{1, -1, 3, 1, 2, -1, 4};
    static final int PNG_FILTER_NONE = 0;
    static final int PNG_FILTER_SUB = 1;
    static final int PNG_FILTER_UP = 2;
    static final int PNG_FILTER_AVERAGE = 3;
    static final int PNG_FILTER_PAETH = 4;
    static final int[] adam7XOffset = new int[]{0, 4, 0, 2, 0, 1, 0};
    static final int[] adam7YOffset = new int[]{0, 0, 4, 0, 2, 0, 1};
    static final int[] adam7XSubsampling = new int[]{8, 8, 4, 4, 2, 2, 1, 1};
    static final int[] adam7YSubsampling = new int[]{8, 8, 8, 4, 4, 2, 2, 1};
    private static final boolean debug = true;
    ImageInputStream stream = null;
    boolean gotHeader = false;
    boolean gotMetadata = false;
    ImageReadParam lastParam = null;
    long imageStartPosition = -1L;
    Rectangle sourceRegion = null;
    int sourceXSubsampling = -1;
    int sourceYSubsampling = -1;
    int sourceMinProgressivePass = 0;
    int sourceMaxProgressivePass = 6;
    int[] sourceBands = null;
    int[] destinationBands = null;
    Point destinationOffset = new Point(0, 0);
    PNGMetadata metadata = new PNGMetadata();
    DataInputStream pixelStream = null;
    BufferedImage theImage = null;
    int pixelsDone = 0;
    int totalPixels;
    private static final int[][] bandOffsets = new int[][]{null, {0}, {0, 1}, {0, 1, 2}, {0, 1, 2, 3}};

    public PNGImageReader(ImageReaderSpi imageReaderSpi) {
        super(imageReaderSpi);
    }

    @Override
    public void setInput(Object object, boolean bl, boolean bl2) {
        super.setInput(object, bl, bl2);
        this.stream = (ImageInputStream)object;
        this.resetStreamSettings();
    }

    private String readNullTerminatedString(String string, int n) throws IOException {
        int n2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n3 = 0;
        while (n > n3++ && (n2 = this.stream.read()) != 0) {
            if (n2 == -1) {
                throw new EOFException();
            }
            byteArrayOutputStream.write(n2);
        }
        return new String(byteArrayOutputStream.toByteArray(), string);
    }

    private void readHeader() throws IIOException {
        if (this.gotHeader) {
            return;
        }
        if (this.stream == null) {
            throw new IllegalStateException("Input source not set!");
        }
        try {
            byte[] byArray = new byte[8];
            this.stream.readFully(byArray);
            if (byArray[0] != -119 || byArray[1] != 80 || byArray[2] != 78 || byArray[3] != 71 || byArray[4] != 13 || byArray[5] != 10 || byArray[6] != 26 || byArray[7] != 10) {
                throw new IIOException("Bad PNG signature!");
            }
            int n = this.stream.readInt();
            if (n != 13) {
                throw new IIOException("Bad length for IHDR chunk!");
            }
            int n2 = this.stream.readInt();
            if (n2 != 1229472850) {
                throw new IIOException("Bad type for IHDR chunk!");
            }
            this.metadata = new PNGMetadata();
            int n3 = this.stream.readInt();
            int n4 = this.stream.readInt();
            this.stream.readFully(byArray, 0, 5);
            int n5 = byArray[0] & 0xFF;
            int n6 = byArray[1] & 0xFF;
            int n7 = byArray[2] & 0xFF;
            int n8 = byArray[3] & 0xFF;
            int n9 = byArray[4] & 0xFF;
            this.stream.skipBytes(4);
            this.stream.flushBefore(this.stream.getStreamPosition());
            if (n3 == 0) {
                throw new IIOException("Image width == 0!");
            }
            if (n4 == 0) {
                throw new IIOException("Image height == 0!");
            }
            if (n5 != 1 && n5 != 2 && n5 != 4 && n5 != 8 && n5 != 16) {
                throw new IIOException("Bit depth must be 1, 2, 4, 8, or 16!");
            }
            if (n6 != 0 && n6 != 2 && n6 != 3 && n6 != 4 && n6 != 6) {
                throw new IIOException("Color type must be 0, 2, 3, 4, or 6!");
            }
            if (n6 == 3 && n5 == 16) {
                throw new IIOException("Bad color type/bit depth combination!");
            }
            if ((n6 == 2 || n6 == 6 || n6 == 4) && n5 != 8 && n5 != 16) {
                throw new IIOException("Bad color type/bit depth combination!");
            }
            if (n7 != 0) {
                throw new IIOException("Unknown compression method (not 0)!");
            }
            if (n8 != 0) {
                throw new IIOException("Unknown filter method (not 0)!");
            }
            if (n9 != 0 && n9 != 1) {
                throw new IIOException("Unknown interlace method (not 0 or 1)!");
            }
            this.metadata.IHDR_present = true;
            this.metadata.IHDR_width = n3;
            this.metadata.IHDR_height = n4;
            this.metadata.IHDR_bitDepth = n5;
            this.metadata.IHDR_colorType = n6;
            this.metadata.IHDR_compressionMethod = n7;
            this.metadata.IHDR_filterMethod = n8;
            this.metadata.IHDR_interlaceMethod = n9;
            this.gotHeader = true;
        }
        catch (IOException iOException) {
            throw new IIOException("I/O error reading PNG header!", iOException);
        }
    }

    private void parse_PLTE_chunk(int n) throws IOException {
        int n2;
        if (this.metadata.PLTE_present) {
            this.processWarningOccurred("A PNG image may not contain more than one PLTE chunk.\nThe chunk wil be ignored.");
            return;
        }
        if (this.metadata.IHDR_colorType == 0 || this.metadata.IHDR_colorType == 4) {
            this.processWarningOccurred("A PNG gray or gray alpha image cannot have a PLTE chunk.\nThe chunk wil be ignored.");
            return;
        }
        byte[] byArray = new byte[n];
        this.stream.readFully(byArray);
        int n3 = n / 3;
        if (this.metadata.IHDR_colorType == 3) {
            n2 = 1 << this.metadata.IHDR_bitDepth;
            if (n3 > n2) {
                this.processWarningOccurred("PLTE chunk contains too many entries for bit depth, ignoring extras.");
                n3 = n2;
            }
            n3 = Math.min(n3, n2);
        }
        n2 = n3 > 16 ? 256 : (n3 > 4 ? 16 : (n3 > 2 ? 4 : 2));
        this.metadata.PLTE_present = true;
        this.metadata.PLTE_red = new byte[n2];
        this.metadata.PLTE_green = new byte[n2];
        this.metadata.PLTE_blue = new byte[n2];
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            this.metadata.PLTE_red[i] = byArray[n4++];
            this.metadata.PLTE_green[i] = byArray[n4++];
            this.metadata.PLTE_blue[i] = byArray[n4++];
        }
    }

    private void parse_bKGD_chunk() throws IOException {
        if (this.metadata.IHDR_colorType == 3) {
            this.metadata.bKGD_colorType = 3;
            this.metadata.bKGD_index = this.stream.readUnsignedByte();
        } else if (this.metadata.IHDR_colorType == 0 || this.metadata.IHDR_colorType == 4) {
            this.metadata.bKGD_colorType = 0;
            this.metadata.bKGD_gray = this.stream.readUnsignedShort();
        } else {
            this.metadata.bKGD_colorType = 2;
            this.metadata.bKGD_red = this.stream.readUnsignedShort();
            this.metadata.bKGD_green = this.stream.readUnsignedShort();
            this.metadata.bKGD_blue = this.stream.readUnsignedShort();
        }
        this.metadata.bKGD_present = true;
    }

    private void parse_cHRM_chunk() throws IOException {
        this.metadata.cHRM_whitePointX = this.stream.readInt();
        this.metadata.cHRM_whitePointY = this.stream.readInt();
        this.metadata.cHRM_redX = this.stream.readInt();
        this.metadata.cHRM_redY = this.stream.readInt();
        this.metadata.cHRM_greenX = this.stream.readInt();
        this.metadata.cHRM_greenY = this.stream.readInt();
        this.metadata.cHRM_blueX = this.stream.readInt();
        this.metadata.cHRM_blueY = this.stream.readInt();
        this.metadata.cHRM_present = true;
    }

    private void parse_gAMA_chunk() throws IOException {
        int n;
        this.metadata.gAMA_gamma = n = this.stream.readInt();
        this.metadata.gAMA_present = true;
    }

    private void parse_hIST_chunk(int n) throws IOException, IIOException {
        if (!this.metadata.PLTE_present) {
            throw new IIOException("hIST chunk without prior PLTE chunk!");
        }
        this.metadata.hIST_histogram = new char[n / 2];
        this.stream.readFully(this.metadata.hIST_histogram, 0, this.metadata.hIST_histogram.length);
        this.metadata.hIST_present = true;
    }

    private void parse_iCCP_chunk(int n) throws IOException {
        String string;
        this.metadata.iCCP_profileName = string = this.readNullTerminatedString("ISO-8859-1", 80);
        this.metadata.iCCP_compressionMethod = this.stream.readUnsignedByte();
        byte[] byArray = new byte[n - string.length() - 2];
        this.stream.readFully(byArray);
        this.metadata.iCCP_compressedProfile = byArray;
        this.metadata.iCCP_present = true;
    }

    private void parse_iTXt_chunk(int n) throws IOException {
        long l = this.stream.getStreamPosition();
        String string = this.readNullTerminatedString("ISO-8859-1", 80);
        this.metadata.iTXt_keyword.add(string);
        int n2 = this.stream.readUnsignedByte();
        this.metadata.iTXt_compressionFlag.add(n2 == 1);
        int n3 = this.stream.readUnsignedByte();
        this.metadata.iTXt_compressionMethod.add(n3);
        String string2 = this.readNullTerminatedString("UTF8", 80);
        this.metadata.iTXt_languageTag.add(string2);
        long l2 = this.stream.getStreamPosition();
        int n4 = (int)(l + (long)n - l2);
        String string3 = this.readNullTerminatedString("UTF8", n4);
        this.metadata.iTXt_translatedKeyword.add(string3);
        l2 = this.stream.getStreamPosition();
        byte[] byArray = new byte[(int)(l + (long)n - l2)];
        this.stream.readFully(byArray);
        String string4 = n2 == 1 ? new String(PNGImageReader.inflate(byArray), "UTF8") : new String(byArray, "UTF8");
        this.metadata.iTXt_text.add(string4);
    }

    private void parse_pHYs_chunk() throws IOException {
        this.metadata.pHYs_pixelsPerUnitXAxis = this.stream.readInt();
        this.metadata.pHYs_pixelsPerUnitYAxis = this.stream.readInt();
        this.metadata.pHYs_unitSpecifier = this.stream.readUnsignedByte();
        this.metadata.pHYs_present = true;
    }

    private void parse_sBIT_chunk() throws IOException {
        int n = this.metadata.IHDR_colorType;
        if (n == 0 || n == 4) {
            this.metadata.sBIT_grayBits = this.stream.readUnsignedByte();
        } else if (n == 2 || n == 3 || n == 6) {
            this.metadata.sBIT_redBits = this.stream.readUnsignedByte();
            this.metadata.sBIT_greenBits = this.stream.readUnsignedByte();
            this.metadata.sBIT_blueBits = this.stream.readUnsignedByte();
        }
        if (n == 4 || n == 6) {
            this.metadata.sBIT_alphaBits = this.stream.readUnsignedByte();
        }
        this.metadata.sBIT_colorType = n;
        this.metadata.sBIT_present = true;
    }

    private void parse_sPLT_chunk(int n) throws IOException, IIOException {
        int n2;
        this.metadata.sPLT_paletteName = this.readNullTerminatedString("ISO-8859-1", 80);
        this.metadata.sPLT_sampleDepth = n2 = this.stream.readUnsignedByte();
        int n3 = (n -= this.metadata.sPLT_paletteName.length() + 1) / (4 * (n2 / 8) + 2);
        this.metadata.sPLT_red = new int[n3];
        this.metadata.sPLT_green = new int[n3];
        this.metadata.sPLT_blue = new int[n3];
        this.metadata.sPLT_alpha = new int[n3];
        this.metadata.sPLT_frequency = new int[n3];
        if (n2 == 8) {
            for (int i = 0; i < n3; ++i) {
                this.metadata.sPLT_red[i] = this.stream.readUnsignedByte();
                this.metadata.sPLT_green[i] = this.stream.readUnsignedByte();
                this.metadata.sPLT_blue[i] = this.stream.readUnsignedByte();
                this.metadata.sPLT_alpha[i] = this.stream.readUnsignedByte();
                this.metadata.sPLT_frequency[i] = this.stream.readUnsignedShort();
            }
        } else if (n2 == 16) {
            for (int i = 0; i < n3; ++i) {
                this.metadata.sPLT_red[i] = this.stream.readUnsignedShort();
                this.metadata.sPLT_green[i] = this.stream.readUnsignedShort();
                this.metadata.sPLT_blue[i] = this.stream.readUnsignedShort();
                this.metadata.sPLT_alpha[i] = this.stream.readUnsignedShort();
                this.metadata.sPLT_frequency[i] = this.stream.readUnsignedShort();
            }
        } else {
            throw new IIOException("sPLT sample depth not 8 or 16!");
        }
        this.metadata.sPLT_present = true;
    }

    private void parse_sRGB_chunk() throws IOException {
        this.metadata.sRGB_renderingIntent = this.stream.readUnsignedByte();
        this.metadata.sRGB_present = true;
    }

    private void parse_tEXt_chunk(int n) throws IOException {
        String string = this.readNullTerminatedString("ISO-8859-1", 80);
        this.metadata.tEXt_keyword.add(string);
        byte[] byArray = new byte[n - string.length() - 1];
        this.stream.readFully(byArray);
        this.metadata.tEXt_text.add(new String(byArray, "ISO-8859-1"));
    }

    private void parse_tIME_chunk() throws IOException {
        this.metadata.tIME_year = this.stream.readUnsignedShort();
        this.metadata.tIME_month = this.stream.readUnsignedByte();
        this.metadata.tIME_day = this.stream.readUnsignedByte();
        this.metadata.tIME_hour = this.stream.readUnsignedByte();
        this.metadata.tIME_minute = this.stream.readUnsignedByte();
        this.metadata.tIME_second = this.stream.readUnsignedByte();
        this.metadata.tIME_present = true;
    }

    private void parse_tRNS_chunk(int n) throws IOException {
        int n2 = this.metadata.IHDR_colorType;
        if (n2 == 3) {
            if (!this.metadata.PLTE_present) {
                this.processWarningOccurred("tRNS chunk without prior PLTE chunk, ignoring it.");
                return;
            }
            int n3 = n;
            int n4 = this.metadata.PLTE_red.length;
            if (n3 > n4) {
                this.processWarningOccurred("tRNS chunk has more entries than prior PLTE chunk, ignoring extras.");
                n3 = n4;
            }
            this.metadata.tRNS_alpha = new byte[n3];
            this.metadata.tRNS_colorType = 3;
            this.stream.read(this.metadata.tRNS_alpha, 0, n3);
            this.stream.skipBytes(n - n3);
        } else if (n2 == 0) {
            if (n != 2) {
                this.processWarningOccurred("tRNS chunk for gray image must have length 2, ignoring chunk.");
                this.stream.skipBytes(n);
                return;
            }
            this.metadata.tRNS_gray = this.stream.readUnsignedShort();
            this.metadata.tRNS_colorType = 0;
        } else if (n2 == 2) {
            if (n != 6) {
                this.processWarningOccurred("tRNS chunk for RGB image must have length 6, ignoring chunk.");
                this.stream.skipBytes(n);
                return;
            }
            this.metadata.tRNS_red = this.stream.readUnsignedShort();
            this.metadata.tRNS_green = this.stream.readUnsignedShort();
            this.metadata.tRNS_blue = this.stream.readUnsignedShort();
            this.metadata.tRNS_colorType = 2;
        } else {
            this.processWarningOccurred("Gray+Alpha and RGBS images may not have a tRNS chunk, ignoring it.");
            return;
        }
        this.metadata.tRNS_present = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] inflate(byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (InflaterInputStream inflaterInputStream = new InflaterInputStream(byteArrayInputStream);){
            int n;
            while ((n = ((InputStream)inflaterInputStream).read()) != -1) {
                byteArrayOutputStream.write(n);
            }
        }
        return byteArrayOutputStream.toByteArray();
    }

    private void parse_zTXt_chunk(int n) throws IOException {
        String string = this.readNullTerminatedString("ISO-8859-1", 80);
        this.metadata.zTXt_keyword.add(string);
        int n2 = this.stream.readUnsignedByte();
        this.metadata.zTXt_compressionMethod.add(new Integer(n2));
        byte[] byArray = new byte[n - string.length() - 2];
        this.stream.readFully(byArray);
        this.metadata.zTXt_text.add(new String(PNGImageReader.inflate(byArray), "ISO-8859-1"));
    }

    private void readMetadata() throws IIOException {
        block31: {
            if (this.gotMetadata) {
                return;
            }
            this.readHeader();
            int n = this.metadata.IHDR_colorType;
            if (this.ignoreMetadata && n != 3) {
                try {
                    while (true) {
                        int n2 = this.stream.readInt();
                        int n3 = this.stream.readInt();
                        if (n3 == 1229209940) {
                            this.stream.skipBytes(-8);
                            this.imageStartPosition = this.stream.getStreamPosition();
                            break;
                        }
                        this.stream.skipBytes(n2 + 4);
                    }
                }
                catch (IOException iOException) {
                    throw new IIOException("Error skipping PNG metadata", iOException);
                }
                this.gotMetadata = true;
                return;
            }
            try {
                while (true) {
                    int n4 = this.stream.readInt();
                    int n5 = this.stream.readInt();
                    switch (n5) {
                        case 1229209940: {
                            this.stream.skipBytes(-8);
                            this.imageStartPosition = this.stream.getStreamPosition();
                            break block31;
                        }
                        case 1347179589: {
                            this.parse_PLTE_chunk(n4);
                            break;
                        }
                        case 1649100612: {
                            this.parse_bKGD_chunk();
                            break;
                        }
                        case 1665684045: {
                            this.parse_cHRM_chunk();
                            break;
                        }
                        case 1732332865: {
                            this.parse_gAMA_chunk();
                            break;
                        }
                        case 1749635924: {
                            this.parse_hIST_chunk(n4);
                            break;
                        }
                        case 1766015824: {
                            this.parse_iCCP_chunk(n4);
                            break;
                        }
                        case 1767135348: {
                            if (this.ignoreMetadata) {
                                this.stream.skipBytes(n4);
                                break;
                            }
                            this.parse_iTXt_chunk(n4);
                            break;
                        }
                        case 1883789683: {
                            this.parse_pHYs_chunk();
                            break;
                        }
                        case 1933723988: {
                            this.parse_sBIT_chunk();
                            break;
                        }
                        case 1934642260: {
                            this.parse_sPLT_chunk(n4);
                            break;
                        }
                        case 1934772034: {
                            this.parse_sRGB_chunk();
                            break;
                        }
                        case 1950701684: {
                            this.parse_tEXt_chunk(n4);
                            break;
                        }
                        case 1950960965: {
                            this.parse_tIME_chunk();
                            break;
                        }
                        case 1951551059: {
                            this.parse_tRNS_chunk(n4);
                            break;
                        }
                        case 2052348020: {
                            if (this.ignoreMetadata) {
                                this.stream.skipBytes(n4);
                                break;
                            }
                            this.parse_zTXt_chunk(n4);
                            break;
                        }
                        default: {
                            byte[] byArray = new byte[n4];
                            this.stream.readFully(byArray);
                            StringBuilder stringBuilder = new StringBuilder(4);
                            stringBuilder.append((char)(n5 >>> 24));
                            stringBuilder.append((char)(n5 >> 16 & 0xFF));
                            stringBuilder.append((char)(n5 >> 8 & 0xFF));
                            stringBuilder.append((char)(n5 & 0xFF));
                            int n6 = n5 >>> 28;
                            if (n6 == 0) {
                                this.processWarningOccurred("Encountered unknown chunk with critical bit set!");
                            }
                            this.metadata.unknownChunkType.add(stringBuilder.toString());
                            this.metadata.unknownChunkData.add(byArray);
                        }
                    }
                    int n7 = this.stream.readInt();
                    this.stream.flushBefore(this.stream.getStreamPosition());
                }
            }
            catch (IOException iOException) {
                throw new IIOException("Error reading PNG metadata", iOException);
            }
        }
        this.gotMetadata = true;
    }

    private static void decodeSubFilter(byte[] byArray, int n, int n2, int n3) {
        for (int i = n3; i < n2; ++i) {
            int n4 = byArray[i + n] & 0xFF;
            byArray[i + n] = (byte)(n4 += byArray[i + n - n3] & 0xFF);
        }
    }

    private static void decodeUpFilter(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        for (int i = 0; i < n3; ++i) {
            int n4 = byArray[i + n] & 0xFF;
            int n5 = byArray2[i + n2] & 0xFF;
            byArray[i + n] = (byte)(n4 + n5);
        }
    }

    private static void decodeAverageFilter(byte[] byArray, int n, byte[] byArray2, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        for (n7 = 0; n7 < n4; ++n7) {
            n6 = byArray[n7 + n] & 0xFF;
            n5 = byArray2[n7 + n2] & 0xFF;
            byArray[n7 + n] = (byte)(n6 + n5 / 2);
        }
        for (n7 = n4; n7 < n3; ++n7) {
            n6 = byArray[n7 + n] & 0xFF;
            int n8 = byArray[n7 + n - n4] & 0xFF;
            n5 = byArray2[n7 + n2] & 0xFF;
            byArray[n7 + n] = (byte)(n6 + (n8 + n5) / 2);
        }
    }

    private static int paethPredictor(int n, int n2, int n3) {
        int n4 = n + n2 - n3;
        int n5 = Math.abs(n4 - n);
        int n6 = Math.abs(n4 - n2);
        int n7 = Math.abs(n4 - n3);
        if (n5 <= n6 && n5 <= n7) {
            return n;
        }
        if (n6 <= n7) {
            return n2;
        }
        return n3;
    }

    private static void decodePaethFilter(byte[] byArray, int n, byte[] byArray2, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        for (n7 = 0; n7 < n4; ++n7) {
            n6 = byArray[n7 + n] & 0xFF;
            n5 = byArray2[n7 + n2] & 0xFF;
            byArray[n7 + n] = (byte)(n6 + n5);
        }
        for (n7 = n4; n7 < n3; ++n7) {
            n6 = byArray[n7 + n] & 0xFF;
            int n8 = byArray[n7 + n - n4] & 0xFF;
            n5 = byArray2[n7 + n2] & 0xFF;
            int n9 = byArray2[n7 + n2 - n4] & 0xFF;
            byArray[n7 + n] = (byte)(n6 + PNGImageReader.paethPredictor(n8, n5, n9));
        }
    }

    private WritableRaster createRaster(int n, int n2, int n3, int n4, int n5) {
        WritableRaster writableRaster = null;
        Point point = new Point(0, 0);
        if (n5 < 8 && n3 == 1) {
            DataBufferByte dataBufferByte = new DataBufferByte(n2 * n4);
            writableRaster = Raster.createPackedRaster(dataBufferByte, n, n2, n5, point);
        } else if (n5 <= 8) {
            DataBufferByte dataBufferByte = new DataBufferByte(n2 * n4);
            writableRaster = Raster.createInterleavedRaster(dataBufferByte, n, n2, n4, n3, bandOffsets[n3], point);
        } else {
            DataBufferUShort dataBufferUShort = new DataBufferUShort(n2 * n4);
            writableRaster = Raster.createInterleavedRaster(dataBufferUShort, n, n2, n4, n3, bandOffsets[n3], point);
        }
        return writableRaster;
    }

    private void skipPass(int n, int n2) throws IOException, IIOException {
        if (n == 0 || n2 == 0) {
            return;
        }
        int n3 = inputBandsForColorType[this.metadata.IHDR_colorType];
        int n4 = (n3 * n * this.metadata.IHDR_bitDepth + 7) / 8;
        for (int i = 0; i < n2; ++i) {
            this.pixelStream.skipBytes(1 + n4);
            if (!this.abortRequested()) continue;
            return;
        }
    }

    private void updateImageProgress(int n) {
        this.pixelsDone += n;
        this.processImageProgress(100.0f * (float)this.pixelsDone / (float)this.totalPixels);
    }

    private void decodePass(int n, int n2, int n3, int n4, int n5, int n6, int n7) throws IOException {
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        if (n6 == 0 || n7 == 0) {
            return;
        }
        WritableRaster writableRaster = this.theImage.getWritableTile(0, 0);
        int n14 = writableRaster.getMinX();
        int n15 = n14 + writableRaster.getWidth() - 1;
        int n16 = writableRaster.getMinY();
        int n17 = n16 + writableRaster.getHeight() - 1;
        int[] nArray = ReaderUtil.computeUpdatedPixels(this.sourceRegion, this.destinationOffset, n14, n16, n15, n17, this.sourceXSubsampling, this.sourceYSubsampling, n2, n3, n6, n7, n4, n5);
        int n18 = nArray[0];
        int n19 = nArray[1];
        int n20 = nArray[2];
        int n21 = nArray[4];
        int n22 = nArray[5];
        int n23 = this.metadata.IHDR_bitDepth;
        int n24 = inputBandsForColorType[this.metadata.IHDR_colorType];
        int n25 = n23 == 16 ? 2 : 1;
        n25 *= n24;
        int n26 = (n24 * n6 * n23 + 7) / 8;
        int n27 = n13 = n23 == 16 ? n26 / 2 : n26;
        if (n20 == 0) {
            for (int i = 0; i < n7; ++i) {
                this.updateImageProgress(n6);
                this.pixelStream.skipBytes(1 + n26);
            }
            return;
        }
        int n28 = (n18 - this.destinationOffset.x) * this.sourceXSubsampling + this.sourceRegion.x;
        int n29 = (n28 - n2) / n4;
        int n30 = n21 * this.sourceXSubsampling / n4;
        byte[] byArray = null;
        short[] sArray = null;
        byte[] byArray2 = new byte[n26];
        byte[] byArray3 = new byte[n26];
        WritableRaster writableRaster2 = this.createRaster(n6, 1, n24, n13, n23);
        int[] nArray2 = writableRaster2.getPixel(0, 0, (int[])null);
        DataBuffer dataBuffer = writableRaster2.getDataBuffer();
        int n31 = dataBuffer.getDataType();
        if (n31 == 0) {
            byArray = ((DataBufferByte)dataBuffer).getData();
        } else {
            sArray = ((DataBufferUShort)dataBuffer).getData();
        }
        this.processPassStarted(this.theImage, n, this.sourceMinProgressivePass, this.sourceMaxProgressivePass, n18, n19, n21, n22, this.destinationBands);
        if (this.sourceBands != null) {
            writableRaster2 = writableRaster2.createWritableChild(0, 0, writableRaster2.getWidth(), 1, 0, 0, this.sourceBands);
        }
        if (this.destinationBands != null) {
            writableRaster = writableRaster.createWritableChild(0, 0, writableRaster.getWidth(), writableRaster.getHeight(), 0, 0, this.destinationBands);
        }
        boolean bl = false;
        int[] nArray3 = writableRaster.getSampleModel().getSampleSize();
        int n32 = nArray3.length;
        for (int i = 0; i < n32; ++i) {
            if (nArray3[i] == n23) continue;
            bl = true;
            break;
        }
        Object object = null;
        if (bl) {
            n12 = (1 << n23) - 1;
            n11 = n12 / 2;
            object = new int[n32][];
            for (n10 = 0; n10 < n32; ++n10) {
                n9 = (1 << nArray3[n10]) - 1;
                object[n10] = new int[n12 + 1];
                for (n8 = 0; n8 <= n12; ++n8) {
                    object[n10][n8] = (n8 * n9 + n11) / n12;
                }
            }
        }
        int n33 = n12 = n30 == 1 && n21 == 1 && !bl && writableRaster instanceof ByteInterleavedRaster ? 1 : 0;
        if (n12 != 0) {
            writableRaster2 = writableRaster2.createWritableChild(n29, 0, n20, 1, 0, 0, null);
        }
        for (n11 = 0; n11 < n7; ++n11) {
            this.updateImageProgress(n6);
            n10 = this.pixelStream.read();
            byte[] byArray4 = byArray3;
            byArray3 = byArray2;
            byArray2 = byArray4;
            this.pixelStream.readFully(byArray2, 0, n26);
            switch (n10) {
                case 0: {
                    break;
                }
                case 1: {
                    PNGImageReader.decodeSubFilter(byArray2, 0, n26, n25);
                    break;
                }
                case 2: {
                    PNGImageReader.decodeUpFilter(byArray2, 0, byArray3, 0, n26);
                    break;
                }
                case 3: {
                    PNGImageReader.decodeAverageFilter(byArray2, 0, byArray3, 0, n26, n25);
                    break;
                }
                case 4: {
                    PNGImageReader.decodePaethFilter(byArray2, 0, byArray3, 0, n26, n25);
                    break;
                }
                default: {
                    throw new IIOException("Unknown row filter type (= " + n10 + ")!");
                }
            }
            if (n23 < 16) {
                System.arraycopy(byArray2, 0, byArray, 0, n26);
            } else {
                int n34 = 0;
                for (n8 = 0; n8 < n13; ++n8) {
                    sArray[n8] = (short)(byArray2[n34] << 8 | byArray2[n34 + 1] & 0xFF);
                    n34 += 2;
                }
            }
            n9 = n11 * n5 + n3;
            if (n9 < this.sourceRegion.y || n9 >= this.sourceRegion.y + this.sourceRegion.height || (n9 - this.sourceRegion.y) % this.sourceYSubsampling != 0 || (n8 = this.destinationOffset.y + (n9 - this.sourceRegion.y) / this.sourceYSubsampling) < n16) continue;
            if (n8 > n17) break;
            if (n12 != 0) {
                writableRaster.setRect(n18, n8, writableRaster2);
            } else {
                int n35 = n29;
                for (int i = n18; i < n18 + n20; i += n21) {
                    writableRaster2.getPixel(n35, 0, nArray2);
                    if (bl) {
                        for (int j = 0; j < n32; ++j) {
                            nArray2[j] = object[j][nArray2[j]];
                        }
                    }
                    writableRaster.setPixel(i, n8, nArray2);
                    n35 += n30;
                }
            }
            this.processImageUpdate(this.theImage, n18, n8, n20, 1, n21, n22, this.destinationBands);
            if (!this.abortRequested()) continue;
            return;
        }
        this.processPassComplete(this.theImage);
    }

    private void decodeImage() throws IOException, IIOException {
        int n = this.metadata.IHDR_width;
        int n2 = this.metadata.IHDR_height;
        this.pixelsDone = 0;
        this.totalPixels = n * n2;
        this.clearAbortRequest();
        if (this.metadata.IHDR_interlaceMethod == 0) {
            this.decodePass(0, 0, 0, 1, 1, n, n2);
        } else {
            for (int i = 0; i <= this.sourceMaxProgressivePass; ++i) {
                int n3 = adam7XOffset[i];
                int n4 = adam7YOffset[i];
                int n5 = adam7XSubsampling[i];
                int n6 = adam7YSubsampling[i];
                int n7 = adam7XSubsampling[i + 1] - 1;
                int n8 = adam7YSubsampling[i + 1] - 1;
                if (i >= this.sourceMinProgressivePass) {
                    this.decodePass(i, n3, n4, n5, n6, (n + n7) / n5, (n2 + n8) / n6);
                } else {
                    this.skipPass((n + n7) / n5, (n2 + n8) / n6);
                }
                if (!this.abortRequested()) continue;
                return;
            }
        }
    }

    private void readImage(ImageReadParam imageReadParam) throws IIOException {
        this.readMetadata();
        int n = this.metadata.IHDR_width;
        int n2 = this.metadata.IHDR_height;
        if ((long)n * (long)n2 > 0x7FFFFFFDL) {
            throw new IIOException("Can not read image of the size " + n + " by " + n2);
        }
        this.sourceXSubsampling = 1;
        this.sourceYSubsampling = 1;
        this.sourceMinProgressivePass = 0;
        this.sourceMaxProgressivePass = 6;
        this.sourceBands = null;
        this.destinationBands = null;
        this.destinationOffset = new Point(0, 0);
        if (imageReadParam != null) {
            this.sourceXSubsampling = imageReadParam.getSourceXSubsampling();
            this.sourceYSubsampling = imageReadParam.getSourceYSubsampling();
            this.sourceMinProgressivePass = Math.max(imageReadParam.getSourceMinProgressivePass(), 0);
            this.sourceMaxProgressivePass = Math.min(imageReadParam.getSourceMaxProgressivePass(), 6);
            this.sourceBands = imageReadParam.getSourceBands();
            this.destinationBands = imageReadParam.getDestinationBands();
            this.destinationOffset = imageReadParam.getDestinationOffset();
        }
        Inflater inflater = null;
        try {
            this.stream.seek(this.imageStartPosition);
            PNGImageDataEnumeration pNGImageDataEnumeration = new PNGImageDataEnumeration(this.stream);
            InputStream inputStream = new SequenceInputStream(pNGImageDataEnumeration);
            inflater = new Inflater();
            inputStream = new InflaterInputStream(inputStream, inflater);
            inputStream = new BufferedInputStream(inputStream);
            this.pixelStream = new DataInputStream(inputStream);
            this.theImage = PNGImageReader.getDestination(imageReadParam, this.getImageTypes(0), n, n2);
            Rectangle rectangle = new Rectangle(0, 0, 0, 0);
            this.sourceRegion = new Rectangle(0, 0, 0, 0);
            PNGImageReader.computeRegions(imageReadParam, n, n2, this.theImage, this.sourceRegion, rectangle);
            this.destinationOffset.setLocation(rectangle.getLocation());
            int n3 = this.metadata.IHDR_colorType;
            PNGImageReader.checkReadParamBandSettings(imageReadParam, inputBandsForColorType[n3], this.theImage.getSampleModel().getNumBands());
            this.processImageStarted(0);
            this.decodeImage();
            if (this.abortRequested()) {
                this.processReadAborted();
            } else {
                this.processImageComplete();
            }
        }
        catch (IOException iOException) {
            throw new IIOException("Error reading PNG image data", iOException);
        }
        finally {
            if (inflater != null) {
                inflater.end();
            }
        }
    }

    @Override
    public int getNumImages(boolean bl) throws IIOException {
        if (this.stream == null) {
            throw new IllegalStateException("No input source set!");
        }
        if (this.seekForwardOnly && bl) {
            throw new IllegalStateException("seekForwardOnly and allowSearch can't both be true!");
        }
        return 1;
    }

    @Override
    public int getWidth(int n) throws IIOException {
        if (n != 0) {
            throw new IndexOutOfBoundsException("imageIndex != 0!");
        }
        this.readHeader();
        return this.metadata.IHDR_width;
    }

    @Override
    public int getHeight(int n) throws IIOException {
        if (n != 0) {
            throw new IndexOutOfBoundsException("imageIndex != 0!");
        }
        this.readHeader();
        return this.metadata.IHDR_height;
    }

    @Override
    public Iterator<ImageTypeSpecifier> getImageTypes(int n) throws IIOException {
        if (n != 0) {
            throw new IndexOutOfBoundsException("imageIndex != 0!");
        }
        this.readHeader();
        ArrayList<ImageTypeSpecifier> arrayList = new ArrayList<ImageTypeSpecifier>(1);
        int n2 = this.metadata.IHDR_bitDepth;
        int n3 = this.metadata.IHDR_colorType;
        int n4 = n2 <= 8 ? 0 : 1;
        switch (n3) {
            case 0: {
                arrayList.add(ImageTypeSpecifier.createGrayscale(n2, n4, false));
                break;
            }
            case 2: {
                if (n2 == 8) {
                    arrayList.add(ImageTypeSpecifier.createFromBufferedImageType(5));
                    arrayList.add(ImageTypeSpecifier.createFromBufferedImageType(1));
                    arrayList.add(ImageTypeSpecifier.createFromBufferedImageType(4));
                }
                ColorSpace colorSpace = ColorSpace.getInstance(1000);
                int[] nArray = new int[]{0, 1, 2};
                arrayList.add(ImageTypeSpecifier.createInterleaved(colorSpace, nArray, n4, false, false));
                break;
            }
            case 3: {
                this.readMetadata();
                int n5 = 1 << n2;
                byte[] byArray = this.metadata.PLTE_red;
                byte[] byArray2 = this.metadata.PLTE_green;
                byte[] byArray3 = this.metadata.PLTE_blue;
                if (this.metadata.PLTE_red.length < n5) {
                    byArray = Arrays.copyOf(this.metadata.PLTE_red, n5);
                    Arrays.fill(byArray, this.metadata.PLTE_red.length, n5, this.metadata.PLTE_red[this.metadata.PLTE_red.length - 1]);
                    byArray2 = Arrays.copyOf(this.metadata.PLTE_green, n5);
                    Arrays.fill(byArray2, this.metadata.PLTE_green.length, n5, this.metadata.PLTE_green[this.metadata.PLTE_green.length - 1]);
                    byArray3 = Arrays.copyOf(this.metadata.PLTE_blue, n5);
                    Arrays.fill(byArray3, this.metadata.PLTE_blue.length, n5, this.metadata.PLTE_blue[this.metadata.PLTE_blue.length - 1]);
                }
                byte[] byArray4 = null;
                if (this.metadata.tRNS_present && this.metadata.tRNS_alpha != null) {
                    if (this.metadata.tRNS_alpha.length == byArray.length) {
                        byArray4 = this.metadata.tRNS_alpha;
                    } else {
                        byArray4 = Arrays.copyOf(this.metadata.tRNS_alpha, byArray.length);
                        Arrays.fill(byArray4, this.metadata.tRNS_alpha.length, byArray.length, (byte)-1);
                    }
                }
                arrayList.add(ImageTypeSpecifier.createIndexed(byArray, byArray2, byArray3, byArray4, n2, 0));
                break;
            }
            case 4: {
                ColorSpace colorSpace = ColorSpace.getInstance(1003);
                int[] nArray = new int[]{0, 1};
                arrayList.add(ImageTypeSpecifier.createInterleaved(colorSpace, nArray, n4, true, false));
                break;
            }
            case 6: {
                if (n2 == 8) {
                    arrayList.add(ImageTypeSpecifier.createFromBufferedImageType(6));
                    arrayList.add(ImageTypeSpecifier.createFromBufferedImageType(2));
                }
                ColorSpace colorSpace = ColorSpace.getInstance(1000);
                int[] nArray = new int[]{0, 1, 2, 3};
                arrayList.add(ImageTypeSpecifier.createInterleaved(colorSpace, nArray, n4, true, false));
                break;
            }
        }
        return arrayList.iterator();
    }

    @Override
    public ImageTypeSpecifier getRawImageType(int n) throws IOException {
        Iterator<ImageTypeSpecifier> iterator = this.getImageTypes(n);
        ImageTypeSpecifier imageTypeSpecifier = null;
        do {
            imageTypeSpecifier = iterator.next();
        } while (iterator.hasNext());
        return imageTypeSpecifier;
    }

    @Override
    public ImageReadParam getDefaultReadParam() {
        return new ImageReadParam();
    }

    @Override
    public IIOMetadata getStreamMetadata() throws IIOException {
        return null;
    }

    @Override
    public IIOMetadata getImageMetadata(int n) throws IIOException {
        if (n != 0) {
            throw new IndexOutOfBoundsException("imageIndex != 0!");
        }
        this.readMetadata();
        return this.metadata;
    }

    @Override
    public BufferedImage read(int n, ImageReadParam imageReadParam) throws IIOException {
        if (n != 0) {
            throw new IndexOutOfBoundsException("imageIndex != 0!");
        }
        this.readImage(imageReadParam);
        return this.theImage;
    }

    @Override
    public void reset() {
        super.reset();
        this.resetStreamSettings();
    }

    private void resetStreamSettings() {
        this.gotHeader = false;
        this.gotMetadata = false;
        this.metadata = null;
        this.pixelStream = null;
    }
}

