/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import com.sun.jndi.ldap.VersionHelper;
import java.net.MalformedURLException;
import java.net.URLClassLoader;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.misc.SharedSecrets;
import sun.security.action.GetPropertyAction;

final class VersionHelper12
extends VersionHelper {
    private static final String TRUST_URL_CODEBASE_PROPERTY = "com.sun.jndi.ldap.object.trustURLCodebase";
    private static final String TRUST_SERIAL_DATA_PROPERTY = "com.sun.jndi.ldap.object.trustSerialData";
    private static final boolean trustSerialData;
    private static final boolean trustURLCodebase;

    private static String getPrivilegedProperty(String string, String string2) {
        GetPropertyAction getPropertyAction = new GetPropertyAction(string, string2);
        if (System.getSecurityManager() == null) {
            return (String)getPropertyAction.run();
        }
        return AccessController.doPrivileged(getPropertyAction);
    }

    VersionHelper12() {
    }

    public static boolean isSerialDataAllowed() {
        return trustSerialData;
    }

    @Override
    ClassLoader getURLClassLoader(String[] stringArray) throws MalformedURLException {
        ClassLoader classLoader = this.getContextClassLoader();
        if (stringArray != null && trustURLCodebase) {
            return URLClassLoader.newInstance(VersionHelper12.getUrlArray(stringArray), classLoader);
        }
        return classLoader;
    }

    @Override
    Class<?> loadClass(String string) throws ClassNotFoundException {
        ClassLoader classLoader = this.getContextClassLoader();
        return Class.forName(string, true, classLoader);
    }

    private ClassLoader getContextClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    @Override
    Thread createThread(final Runnable runnable) {
        final AccessControlContext accessControlContext = AccessController.getContext();
        return AccessController.doPrivileged(new PrivilegedAction<Thread>(){

            @Override
            public Thread run() {
                return SharedSecrets.getJavaLangAccess().newThreadWithAcc(runnable, accessControlContext);
            }
        });
    }

    static {
        String string = VersionHelper12.getPrivilegedProperty(TRUST_URL_CODEBASE_PROPERTY, "false");
        trustURLCodebase = "true".equalsIgnoreCase(string);
        String string2 = VersionHelper12.getPrivilegedProperty(TRUST_SERIAL_DATA_PROPERTY, "true");
        trustSerialData = "true".equalsIgnoreCase(string2);
    }
}

