/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.httpserver.spi;

import com.sun.net.httpserver.HttpServer;
import com.sun.net.httpserver.HttpsServer;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.ServiceLoader;
import sun.misc.ServiceConfigurationError;
import sun.net.httpserver.DefaultHttpServerProvider;

public abstract class HttpServerProvider {
    private static final Object lock = new Object();
    private static HttpServerProvider provider = null;

    public abstract HttpServer createHttpServer(InetSocketAddress var1, int var2) throws IOException;

    public abstract HttpsServer createHttpsServer(InetSocketAddress var1, int var2) throws IOException;

    protected HttpServerProvider() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission("httpServerProvider"));
        }
    }

    private static boolean loadProviderFromProperty() {
        String string = System.getProperty("com.sun.net.httpserver.HttpServerProvider");
        if (string == null) {
            return false;
        }
        try {
            Class<?> clazz = Class.forName(string, true, ClassLoader.getSystemClassLoader());
            provider = (HttpServerProvider)clazz.newInstance();
            return true;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | SecurityException exception) {
            throw new ServiceConfigurationError(exception);
        }
    }

    private static boolean loadProviderAsService() {
        Iterator<HttpServerProvider> iterator = ServiceLoader.load(HttpServerProvider.class, ClassLoader.getSystemClassLoader()).iterator();
        while (true) {
            try {
                if (!iterator.hasNext()) {
                    return false;
                }
                provider = iterator.next();
                return true;
            }
            catch (ServiceConfigurationError serviceConfigurationError) {
                if (serviceConfigurationError.getCause() instanceof SecurityException) continue;
                throw serviceConfigurationError;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpServerProvider provider() {
        Object object = lock;
        synchronized (object) {
            if (provider != null) {
                return provider;
            }
            return (HttpServerProvider)AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    if (HttpServerProvider.loadProviderFromProperty()) {
                        return provider;
                    }
                    if (HttpServerProvider.loadProviderAsService()) {
                        return provider;
                    }
                    provider = (HttpServerProvider)new DefaultHttpServerProvider();
                    return provider;
                }
            });
        }
    }
}

