/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.HeapCharBufferR;

class HeapCharBuffer
extends CharBuffer {
    HeapCharBuffer(int n, int n2) {
        super(-1, 0, n2, n, new char[n], 0);
    }

    HeapCharBuffer(char[] cArray, int n, int n2) {
        super(-1, n, n + n2, cArray.length, cArray, 0);
    }

    protected HeapCharBuffer(char[] cArray, int n, int n2, int n3, int n4, int n5) {
        super(n, n2, n3, n4, cArray, n5);
    }

    @Override
    public CharBuffer slice() {
        int n;
        int n2 = this.position();
        int n3 = n2 <= (n = this.limit()) ? n - n2 : 0;
        return new HeapCharBuffer(this.hb, -1, 0, n3, n3, n2 + this.offset);
    }

    @Override
    public CharBuffer duplicate() {
        return new HeapCharBuffer(this.hb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset);
    }

    @Override
    public CharBuffer asReadOnlyBuffer() {
        return new HeapCharBufferR(this.hb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset);
    }

    protected int ix(int n) {
        return n + this.offset;
    }

    @Override
    public char get() {
        return this.hb[this.ix(this.nextGetIndex())];
    }

    @Override
    public char get(int n) {
        return this.hb[this.ix(this.checkIndex(n))];
    }

    @Override
    public CharBuffer get(char[] cArray, int n, int n2) {
        HeapCharBuffer.checkBounds(n, n2, cArray.length);
        int n3 = this.position();
        if (n2 > this.limit() - n3) {
            throw new BufferUnderflowException();
        }
        System.arraycopy(this.hb, this.ix(n3), cArray, n, n2);
        this.position(n3 + n2);
        return this;
    }

    @Override
    public boolean isDirect() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public CharBuffer put(char c) {
        this.hb[this.ix((int)this.nextPutIndex())] = c;
        return this;
    }

    @Override
    public CharBuffer put(int n, char c) {
        this.hb[this.ix((int)this.checkIndex((int)n))] = c;
        return this;
    }

    @Override
    public CharBuffer put(char[] cArray, int n, int n2) {
        HeapCharBuffer.checkBounds(n, n2, cArray.length);
        int n3 = this.position();
        if (n2 > this.limit() - n3) {
            throw new BufferOverflowException();
        }
        System.arraycopy(cArray, n, this.hb, this.ix(n3), n2);
        this.position(n3 + n2);
        return this;
    }

    @Override
    public CharBuffer put(CharBuffer charBuffer) {
        if (charBuffer instanceof HeapCharBuffer) {
            if (charBuffer == this) {
                throw new IllegalArgumentException();
            }
            HeapCharBuffer heapCharBuffer = (HeapCharBuffer)charBuffer;
            int n = this.position();
            int n2 = heapCharBuffer.position();
            int n3 = heapCharBuffer.limit() - n2;
            if (n3 > this.limit() - n) {
                throw new BufferOverflowException();
            }
            System.arraycopy(heapCharBuffer.hb, heapCharBuffer.ix(n2), this.hb, this.ix(n), n3);
            heapCharBuffer.position(n2 + n3);
            this.position(n + n3);
        } else if (charBuffer.isDirect()) {
            int n = charBuffer.remaining();
            int n4 = this.position();
            if (n > this.limit() - n4) {
                throw new BufferOverflowException();
            }
            charBuffer.get(this.hb, this.ix(n4), n);
            this.position(n4 + n);
        } else {
            super.put(charBuffer);
        }
        return this;
    }

    @Override
    public CharBuffer compact() {
        int n = this.position();
        int n2 = this.limit();
        assert (n <= n2);
        int n3 = n <= n2 ? n2 - n : 0;
        System.arraycopy(this.hb, this.ix(n), this.hb, this.ix(0), n3);
        this.position(n3);
        this.limit(this.capacity());
        this.discardMark();
        return this;
    }

    @Override
    String toString(int n, int n2) {
        try {
            return new String(this.hb, n + this.offset, n2 - n);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new IndexOutOfBoundsException();
        }
    }

    @Override
    public CharBuffer subSequence(int n, int n2) {
        if (n < 0 || n2 > this.length() || n > n2) {
            throw new IndexOutOfBoundsException();
        }
        int n3 = this.position();
        return new HeapCharBuffer(this.hb, -1, n3 + n, n3 + n2, this.capacity(), this.offset);
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.nativeOrder();
    }
}

