/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.SortedSet;
import java.util.TreeMap;

public class TreeSet<E>
extends AbstractSet<E>
implements NavigableSet<E>,
Cloneable,
Serializable {
    private transient NavigableMap<E, Object> m;
    private static final Object PRESENT = new Object();
    private static final long serialVersionUID = -2479143000061671589L;

    TreeSet(NavigableMap<E, Object> navigableMap) {
        this.m = navigableMap;
    }

    public TreeSet() {
        this(new TreeMap());
    }

    public TreeSet(Comparator<? super E> comparator) {
        this(new TreeMap(comparator));
    }

    public TreeSet(Collection<? extends E> collection) {
        this();
        this.addAll(collection);
    }

    public TreeSet(SortedSet<E> sortedSet) {
        this(sortedSet.comparator());
        this.addAll(sortedSet);
    }

    @Override
    public Iterator<E> iterator() {
        return this.m.navigableKeySet().iterator();
    }

    @Override
    public Iterator<E> descendingIterator() {
        return this.m.descendingKeySet().iterator();
    }

    @Override
    public NavigableSet<E> descendingSet() {
        return new TreeSet<E>(this.m.descendingMap());
    }

    @Override
    public int size() {
        return this.m.size();
    }

    @Override
    public boolean isEmpty() {
        return this.m.isEmpty();
    }

    @Override
    public boolean contains(Object object) {
        return this.m.containsKey(object);
    }

    @Override
    public boolean add(E e) {
        return this.m.put(e, PRESENT) == null;
    }

    @Override
    public boolean remove(Object object) {
        return this.m.remove(object) == PRESENT;
    }

    @Override
    public void clear() {
        this.m.clear();
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        if (this.m.size() == 0 && collection.size() > 0 && collection instanceof SortedSet && this.m instanceof TreeMap) {
            Comparator comparator;
            SortedSet sortedSet = (SortedSet)collection;
            TreeMap treeMap = (TreeMap)this.m;
            Comparator comparator2 = sortedSet.comparator();
            if (comparator2 == (comparator = treeMap.comparator()) || comparator2 != null && comparator2.equals(comparator)) {
                treeMap.addAllForTreeSet(sortedSet, PRESENT);
                return true;
            }
        }
        return super.addAll(collection);
    }

    @Override
    public NavigableSet<E> subSet(E e, boolean bl, E e2, boolean bl2) {
        return new TreeSet<E>(this.m.subMap(e, bl, e2, bl2));
    }

    @Override
    public NavigableSet<E> headSet(E e, boolean bl) {
        return new TreeSet<E>(this.m.headMap(e, bl));
    }

    @Override
    public NavigableSet<E> tailSet(E e, boolean bl) {
        return new TreeSet<E>(this.m.tailMap(e, bl));
    }

    @Override
    public SortedSet<E> subSet(E e, E e2) {
        return this.subSet(e, true, e2, false);
    }

    @Override
    public SortedSet<E> headSet(E e) {
        return this.headSet(e, false);
    }

    @Override
    public SortedSet<E> tailSet(E e) {
        return this.tailSet(e, true);
    }

    @Override
    public Comparator<? super E> comparator() {
        return this.m.comparator();
    }

    @Override
    public E first() {
        return (E)this.m.firstKey();
    }

    @Override
    public E last() {
        return (E)this.m.lastKey();
    }

    @Override
    public E lower(E e) {
        return this.m.lowerKey(e);
    }

    @Override
    public E floor(E e) {
        return this.m.floorKey(e);
    }

    @Override
    public E ceiling(E e) {
        return this.m.ceilingKey(e);
    }

    @Override
    public E higher(E e) {
        return this.m.higherKey(e);
    }

    @Override
    public E pollFirst() {
        Map.Entry<E, Object> entry = this.m.pollFirstEntry();
        return entry == null ? null : (E)entry.getKey();
    }

    @Override
    public E pollLast() {
        Map.Entry<E, Object> entry = this.m.pollLastEntry();
        return entry == null ? null : (E)entry.getKey();
    }

    public Object clone() {
        TreeSet treeSet;
        try {
            treeSet = (TreeSet)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        treeSet.m = new TreeMap<E, Object>(this.m);
        return treeSet;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.m.comparator());
        objectOutputStream.writeInt(this.m.size());
        for (Object k : this.m.keySet()) {
            objectOutputStream.writeObject(k);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Comparator comparator = (Comparator)objectInputStream.readObject();
        TreeMap<E, Object> treeMap = new TreeMap<E, Object>(comparator);
        this.m = treeMap;
        int n = objectInputStream.readInt();
        treeMap.readTreeSet(n, objectInputStream, PRESENT);
    }
}

