/*
 * Decompiled with CFR 0.152.
 */
package javax.sql.rowset.serial;

import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import javax.sql.rowset.serial.SerialException;

public class SerialClob
implements Clob,
Serializable,
Cloneable {
    private char[] buf;
    private final Clob clob;
    private long len;
    private final long origLen;
    static final long serialVersionUID = -1662519690087375313L;

    public SerialClob(char[] cArray) throws SerialException, SQLException {
        this.len = cArray.length;
        this.buf = new char[(int)this.len];
        int n = 0;
        while ((long)n < this.len) {
            this.buf[n] = cArray[n];
            ++n;
        }
        this.origLen = this.len;
        this.clob = null;
    }

    public SerialClob(Clob clob) throws SerialException, SQLException {
        if (clob == null) {
            throw new SQLException("Cannot instantiate a SerialClob object with a null Clob object");
        }
        this.len = clob.length();
        this.clob = clob;
        this.buf = new char[(int)this.len];
        int n = 0;
        int n2 = 0;
        try (Reader reader = clob.getCharacterStream();){
            if (reader == null) {
                throw new SQLException("Invalid Clob object. The call to getCharacterStream returned null which cannot be serialized.");
            }
            try (Closeable closeable = clob.getAsciiStream();){
                if (closeable == null) {
                    throw new SQLException("Invalid Clob object. The call to getAsciiStream returned null which cannot be serialized.");
                }
            }
            closeable = new BufferedReader(reader);
            var7_10 = null;
            try {
                do {
                    n = ((Reader)closeable).read(this.buf, n2, (int)(this.len - (long)n2));
                    n2 += n;
                } while (n > 0);
            }
            catch (Throwable throwable) {
                var7_10 = throwable;
                throw throwable;
            }
            finally {
                if (closeable != null) {
                    if (var7_10 != null) {
                        try {
                            ((Reader)closeable).close();
                        }
                        catch (Throwable throwable) {
                            var7_10.addSuppressed(throwable);
                        }
                    } else {
                        ((Reader)closeable).close();
                    }
                }
            }
        }
        catch (IOException iOException) {
            throw new SerialException("SerialClob: " + iOException.getMessage());
        }
        this.origLen = this.len;
    }

    @Override
    public long length() throws SerialException {
        return this.len;
    }

    @Override
    public Reader getCharacterStream() throws SerialException {
        return new CharArrayReader(this.buf);
    }

    @Override
    public InputStream getAsciiStream() throws SerialException, SQLException {
        if (this.clob != null) {
            return this.clob.getAsciiStream();
        }
        throw new SerialException("Unsupported operation. SerialClob cannot return a the CLOB value as an ascii stream, unless instantiated with a fully implemented Clob object.");
    }

    @Override
    public String getSubString(long l, int n) throws SerialException {
        if (l < 1L || l > this.length()) {
            throw new SerialException("Invalid position in BLOB object set");
        }
        if (l - 1L + (long)n > this.length()) {
            throw new SerialException("Invalid position and substring length");
        }
        try {
            return new String(this.buf, (int)l - 1, n);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new SerialException("StringIndexOutOfBoundsException: " + stringIndexOutOfBoundsException.getMessage());
        }
    }

    @Override
    public long position(String string, long l) throws SerialException, SQLException {
        if (l < 1L || l > this.len) {
            return -1L;
        }
        char[] cArray = string.toCharArray();
        int n = (int)l - 1;
        int n2 = 0;
        long l2 = cArray.length;
        while ((long)n < this.len) {
            if (cArray[n2] == this.buf[n]) {
                if ((long)(n2 + 1) == l2) {
                    return (long)(n + 1) - (l2 - 1L);
                }
                ++n2;
                ++n;
                continue;
            }
            if (cArray[n2] == this.buf[n]) continue;
            ++n;
        }
        return -1L;
    }

    @Override
    public long position(Clob clob, long l) throws SerialException, SQLException {
        return this.position(clob.getSubString(1L, (int)clob.length()), l);
    }

    @Override
    public int setString(long l, String string) throws SerialException {
        return this.setString(l, string, 0, string.length());
    }

    @Override
    public int setString(long l, String string, int n, int n2) throws SerialException {
        int n3;
        String string2 = string.substring(n);
        char[] cArray = string2.toCharArray();
        if (n < 0 || n > string.length()) {
            throw new SerialException("Invalid offset in byte array set");
        }
        if (l < 1L || l > this.length()) {
            throw new SerialException("Invalid position in BLOB object set");
        }
        if ((long)n2 > this.origLen) {
            throw new SerialException("Buffer is not sufficient to hold the value");
        }
        if (n2 + n > string.length()) {
            throw new SerialException("Invalid OffSet. Cannot have combined offset  and length that is greater that the Blob buffer");
        }
        --l;
        for (n3 = 0; n3 < n2 || n + n3 + 1 < string.length() - n; ++n3) {
            this.buf[(int)l + n3] = cArray[n + n3];
        }
        return n3;
    }

    @Override
    public OutputStream setAsciiStream(long l) throws SerialException, SQLException {
        if (this.clob.setAsciiStream(l) != null) {
            return this.clob.setAsciiStream(l);
        }
        throw new SerialException("Unsupported operation. SerialClob cannot return a writable ascii stream\n unless instantiated with a Clob object that has a setAsciiStream() implementation");
    }

    @Override
    public Writer setCharacterStream(long l) throws SerialException, SQLException {
        if (this.clob.setCharacterStream(l) != null) {
            return this.clob.setCharacterStream(l);
        }
        throw new SerialException("Unsupported operation. SerialClob cannot return a writable character stream\n unless instantiated with a Clob object that has a setCharacterStream implementation");
    }

    @Override
    public void truncate(long l) throws SerialException {
        if (l > this.len) {
            throw new SerialException("Length more than what can be truncated");
        }
        this.len = l;
        this.buf = this.len == 0L ? new char[0] : this.getSubString(1L, (int)this.len).toCharArray();
    }

    @Override
    public Reader getCharacterStream(long l, long l2) throws SQLException {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public void free() throws SQLException {
        throw new UnsupportedOperationException("Not supported");
    }
}

