/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicInternalFrameTitlePane;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthGraphicsUtils;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.plaf.synth.SynthUI;
import sun.swing.SwingUtilities2;

class SynthInternalFrameTitlePane
extends BasicInternalFrameTitlePane
implements SynthUI,
PropertyChangeListener {
    protected JPopupMenu systemPopupMenu;
    protected JButton menuButton;
    private SynthStyle style;
    private int titleSpacing;
    private int buttonSpacing;
    private int titleAlignment;

    public SynthInternalFrameTitlePane(JInternalFrame jInternalFrame) {
        super(jInternalFrame);
    }

    @Override
    public String getUIClassID() {
        return "InternalFrameTitlePaneUI";
    }

    @Override
    public SynthContext getContext(JComponent jComponent) {
        return this.getContext(jComponent, this.getComponentState(jComponent));
    }

    public SynthContext getContext(JComponent jComponent, int n) {
        return SynthContext.getContext(SynthContext.class, jComponent, SynthLookAndFeel.getRegion(jComponent), this.style, n);
    }

    private Region getRegion(JComponent jComponent) {
        return SynthLookAndFeel.getRegion(jComponent);
    }

    private int getComponentState(JComponent jComponent) {
        if (this.frame != null && this.frame.isSelected()) {
            return 512;
        }
        return SynthLookAndFeel.getComponentState(jComponent);
    }

    @Override
    protected void addSubComponents() {
        this.menuButton.setName("InternalFrameTitlePane.menuButton");
        this.iconButton.setName("InternalFrameTitlePane.iconifyButton");
        this.maxButton.setName("InternalFrameTitlePane.maximizeButton");
        this.closeButton.setName("InternalFrameTitlePane.closeButton");
        this.add(this.menuButton);
        this.add(this.iconButton);
        this.add(this.maxButton);
        this.add(this.closeButton);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.frame.addPropertyChangeListener(this);
        this.addPropertyChangeListener(this);
    }

    @Override
    protected void uninstallListeners() {
        this.frame.removePropertyChangeListener(this);
        this.removePropertyChangeListener(this);
        super.uninstallListeners();
    }

    private void updateStyle(JComponent jComponent) {
        SynthContext synthContext = this.getContext(this, 1);
        SynthStyle synthStyle = this.style;
        this.style = SynthLookAndFeel.updateStyle(synthContext, this);
        if (this.style != synthStyle) {
            this.maxIcon = this.style.getIcon(synthContext, "InternalFrameTitlePane.maximizeIcon");
            this.minIcon = this.style.getIcon(synthContext, "InternalFrameTitlePane.minimizeIcon");
            this.iconIcon = this.style.getIcon(synthContext, "InternalFrameTitlePane.iconifyIcon");
            this.closeIcon = this.style.getIcon(synthContext, "InternalFrameTitlePane.closeIcon");
            this.titleSpacing = this.style.getInt(synthContext, "InternalFrameTitlePane.titleSpacing", 2);
            this.buttonSpacing = this.style.getInt(synthContext, "InternalFrameTitlePane.buttonSpacing", 2);
            String string = (String)this.style.get(synthContext, "InternalFrameTitlePane.titleAlignment");
            this.titleAlignment = 10;
            if (string != null) {
                if ((string = string.toUpperCase()).equals("TRAILING")) {
                    this.titleAlignment = 11;
                } else if (string.equals("CENTER")) {
                    this.titleAlignment = 0;
                }
            }
        }
        synthContext.dispose();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.updateStyle(this);
    }

    @Override
    protected void uninstallDefaults() {
        SynthContext synthContext = this.getContext(this, 1);
        this.style.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.style = null;
        JInternalFrame.JDesktopIcon jDesktopIcon = this.frame.getDesktopIcon();
        if (jDesktopIcon != null && jDesktopIcon.getComponentPopupMenu() == this.systemPopupMenu) {
            jDesktopIcon.setComponentPopupMenu(null);
        }
        super.uninstallDefaults();
    }

    @Override
    protected void assembleSystemMenu() {
        this.systemPopupMenu = new JPopupMenuUIResource();
        this.addSystemMenuItems(this.systemPopupMenu);
        this.enableActions();
        this.menuButton = this.createNoFocusButton();
        this.updateMenuIcon();
        this.menuButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                try {
                    SynthInternalFrameTitlePane.this.frame.setSelected(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
                SynthInternalFrameTitlePane.this.showSystemMenu();
            }
        });
        JPopupMenu jPopupMenu = this.frame.getComponentPopupMenu();
        if (jPopupMenu == null || jPopupMenu instanceof UIResource) {
            this.frame.setComponentPopupMenu(this.systemPopupMenu);
        }
        if (this.frame.getDesktopIcon() != null && ((jPopupMenu = this.frame.getDesktopIcon().getComponentPopupMenu()) == null || jPopupMenu instanceof UIResource)) {
            this.frame.getDesktopIcon().setComponentPopupMenu(this.systemPopupMenu);
        }
        this.setInheritsPopupMenu(true);
    }

    protected void addSystemMenuItems(JPopupMenu jPopupMenu) {
        JMenuItem jMenuItem = jPopupMenu.add(this.restoreAction);
        jMenuItem.setMnemonic(SynthInternalFrameTitlePane.getButtonMnemonic("restore"));
        jMenuItem = jPopupMenu.add(this.moveAction);
        jMenuItem.setMnemonic(SynthInternalFrameTitlePane.getButtonMnemonic("move"));
        jMenuItem = jPopupMenu.add(this.sizeAction);
        jMenuItem.setMnemonic(SynthInternalFrameTitlePane.getButtonMnemonic("size"));
        jMenuItem = jPopupMenu.add(this.iconifyAction);
        jMenuItem.setMnemonic(SynthInternalFrameTitlePane.getButtonMnemonic("minimize"));
        jMenuItem = jPopupMenu.add(this.maximizeAction);
        jMenuItem.setMnemonic(SynthInternalFrameTitlePane.getButtonMnemonic("maximize"));
        jPopupMenu.add(new JSeparator());
        jMenuItem = jPopupMenu.add(this.closeAction);
        jMenuItem.setMnemonic(SynthInternalFrameTitlePane.getButtonMnemonic("close"));
    }

    private static int getButtonMnemonic(String string) {
        try {
            return Integer.parseInt(UIManager.getString("InternalFrameTitlePane." + string + "Button.mnemonic"));
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    @Override
    protected void showSystemMenu() {
        Insets insets = this.frame.getInsets();
        if (!this.frame.isIcon()) {
            this.systemPopupMenu.show(this.frame, this.menuButton.getX(), this.getY() + this.getHeight());
        } else {
            this.systemPopupMenu.show(this.menuButton, this.getX() - insets.left - insets.right, this.getY() - this.systemPopupMenu.getPreferredSize().height - insets.bottom - insets.top);
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        SynthContext synthContext = this.getContext(this);
        SynthLookAndFeel.update(synthContext, graphics);
        synthContext.getPainter().paintInternalFrameTitlePaneBackground(synthContext, graphics, 0, 0, this.getWidth(), this.getHeight());
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    protected void paint(SynthContext synthContext, Graphics graphics) {
        String string = this.frame.getTitle();
        if (string != null) {
            int n;
            int n2;
            SynthStyle synthStyle = synthContext.getStyle();
            graphics.setColor(synthStyle.getColor(synthContext, ColorType.TEXT_FOREGROUND));
            graphics.setFont(synthStyle.getFont(synthContext));
            FontMetrics fontMetrics = SwingUtilities2.getFontMetrics((JComponent)this.frame, graphics);
            int n3 = (this.getHeight() + fontMetrics.getAscent() - fontMetrics.getLeading() - fontMetrics.getDescent()) / 2;
            JButton jButton = null;
            if (this.frame.isIconifiable()) {
                jButton = this.iconButton;
            } else if (this.frame.isMaximizable()) {
                jButton = this.maxButton;
            } else if (this.frame.isClosable()) {
                jButton = this.closeButton;
            }
            boolean bl = SynthLookAndFeel.isLeftToRight(this.frame);
            int n4 = this.titleAlignment;
            if (bl) {
                n2 = jButton != null ? jButton.getX() - this.titleSpacing : this.frame.getWidth() - this.frame.getInsets().right - this.titleSpacing;
                n = this.menuButton.getX() + this.menuButton.getWidth() + this.titleSpacing;
            } else {
                n = jButton != null ? jButton.getX() + jButton.getWidth() + this.titleSpacing : this.frame.getInsets().left + this.titleSpacing;
                n2 = this.menuButton.getX() - this.titleSpacing;
                if (n4 == 10) {
                    n4 = 11;
                } else if (n4 == 11) {
                    n4 = 10;
                }
            }
            String string2 = this.getTitle(string, fontMetrics, n2 - n);
            if (string2 == string) {
                if (n4 == 11) {
                    n = n2 - synthStyle.getGraphicsUtils(synthContext).computeStringWidth(synthContext, graphics.getFont(), fontMetrics, string);
                } else if (n4 == 0) {
                    int n5 = synthStyle.getGraphicsUtils(synthContext).computeStringWidth(synthContext, graphics.getFont(), fontMetrics, string);
                    n = Math.max(n, (this.getWidth() - n5) / 2);
                    n = Math.min(n2 - n5, n);
                }
            }
            synthStyle.getGraphicsUtils(synthContext).paintText(synthContext, graphics, string2, n, n3 - fontMetrics.getAscent(), -1);
        }
    }

    @Override
    public void paintBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        synthContext.getPainter().paintInternalFrameTitlePaneBorder(synthContext, graphics, n, n2, n3, n4);
    }

    @Override
    protected LayoutManager createLayout() {
        SynthContext synthContext = this.getContext(this);
        LayoutManager layoutManager = (LayoutManager)this.style.get(synthContext, "InternalFrameTitlePane.titlePaneLayout");
        synthContext.dispose();
        return layoutManager != null ? layoutManager : new SynthTitlePaneLayout();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() == this) {
            if (SynthLookAndFeel.shouldUpdateStyle(propertyChangeEvent)) {
                this.updateStyle(this);
            }
        } else if (propertyChangeEvent.getPropertyName() == "frameIcon") {
            this.updateMenuIcon();
        }
    }

    private void updateMenuIcon() {
        Icon icon = this.frame.getFrameIcon();
        SynthContext synthContext = this.getContext(this);
        if (icon != null) {
            Dimension dimension = (Dimension)synthContext.getStyle().get(synthContext, "InternalFrameTitlePane.maxFrameIconSize");
            int n = 16;
            int n2 = 16;
            if (dimension != null) {
                n = dimension.width;
                n2 = dimension.height;
            }
            if ((icon.getIconWidth() > n || icon.getIconHeight() > n2) && icon instanceof ImageIcon) {
                icon = new ImageIcon(((ImageIcon)icon).getImage().getScaledInstance(n, n2, 4));
            }
        }
        synthContext.dispose();
        this.menuButton.setIcon(icon);
    }

    private JButton createNoFocusButton() {
        JButton jButton = new JButton();
        jButton.setFocusable(false);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        return jButton;
    }

    class SynthTitlePaneLayout
    implements LayoutManager {
        SynthTitlePaneLayout() {
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
        }

        @Override
        public void removeLayoutComponent(Component component) {
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            return this.minimumLayoutSize(container);
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            int n;
            int n2;
            Dimension dimension;
            SynthContext synthContext = SynthInternalFrameTitlePane.this.getContext(SynthInternalFrameTitlePane.this);
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            if (SynthInternalFrameTitlePane.this.frame.isClosable()) {
                dimension = SynthInternalFrameTitlePane.this.closeButton.getPreferredSize();
                n3 += dimension.width;
                n4 = Math.max(dimension.height, n4);
                ++n5;
            }
            if (SynthInternalFrameTitlePane.this.frame.isMaximizable()) {
                dimension = SynthInternalFrameTitlePane.this.maxButton.getPreferredSize();
                n3 += dimension.width;
                n4 = Math.max(dimension.height, n4);
                ++n5;
            }
            if (SynthInternalFrameTitlePane.this.frame.isIconifiable()) {
                dimension = SynthInternalFrameTitlePane.this.iconButton.getPreferredSize();
                n3 += dimension.width;
                n4 = Math.max(dimension.height, n4);
                ++n5;
            }
            dimension = SynthInternalFrameTitlePane.this.menuButton.getPreferredSize();
            n3 += dimension.width;
            n4 = Math.max(dimension.height, n4);
            n3 += Math.max(0, (n5 - 1) * SynthInternalFrameTitlePane.this.buttonSpacing);
            FontMetrics fontMetrics = SynthInternalFrameTitlePane.this.getFontMetrics(SynthInternalFrameTitlePane.this.getFont());
            SynthGraphicsUtils synthGraphicsUtils = synthContext.getStyle().getGraphicsUtils(synthContext);
            String string = SynthInternalFrameTitlePane.this.frame.getTitle();
            int n6 = string != null ? synthGraphicsUtils.computeStringWidth(synthContext, fontMetrics.getFont(), fontMetrics, string) : 0;
            int n7 = n2 = string != null ? string.length() : 0;
            n3 = n2 > 3 ? (n3 += n6 < (n = synthGraphicsUtils.computeStringWidth(synthContext, fontMetrics.getFont(), fontMetrics, string.substring(0, 3) + "...")) ? n6 : n) : (n3 += n6);
            n4 = Math.max(fontMetrics.getHeight() + 2, n4);
            n3 += SynthInternalFrameTitlePane.this.titleSpacing + SynthInternalFrameTitlePane.this.titleSpacing;
            Insets insets = SynthInternalFrameTitlePane.this.getInsets();
            synthContext.dispose();
            return new Dimension(n3 += insets.left + insets.right, n4 += insets.top + insets.bottom);
        }

        private int center(Component component, Insets insets, int n, boolean bl) {
            Dimension dimension = component.getPreferredSize();
            if (bl) {
                n -= dimension.width;
            }
            component.setBounds(n, insets.top + (SynthInternalFrameTitlePane.this.getHeight() - insets.top - insets.bottom - dimension.height) / 2, dimension.width, dimension.height);
            if (dimension.width > 0) {
                if (bl) {
                    return n - SynthInternalFrameTitlePane.this.buttonSpacing;
                }
                return n + dimension.width + SynthInternalFrameTitlePane.this.buttonSpacing;
            }
            return n;
        }

        @Override
        public void layoutContainer(Container container) {
            Insets insets = container.getInsets();
            if (SynthLookAndFeel.isLeftToRight(SynthInternalFrameTitlePane.this.frame)) {
                this.center(SynthInternalFrameTitlePane.this.menuButton, insets, insets.left, false);
                int n = SynthInternalFrameTitlePane.this.getWidth() - insets.right;
                if (SynthInternalFrameTitlePane.this.frame.isClosable()) {
                    n = this.center(SynthInternalFrameTitlePane.this.closeButton, insets, n, true);
                }
                if (SynthInternalFrameTitlePane.this.frame.isMaximizable()) {
                    n = this.center(SynthInternalFrameTitlePane.this.maxButton, insets, n, true);
                }
                if (SynthInternalFrameTitlePane.this.frame.isIconifiable()) {
                    n = this.center(SynthInternalFrameTitlePane.this.iconButton, insets, n, true);
                }
            } else {
                this.center(SynthInternalFrameTitlePane.this.menuButton, insets, SynthInternalFrameTitlePane.this.getWidth() - insets.right, true);
                int n = insets.left;
                if (SynthInternalFrameTitlePane.this.frame.isClosable()) {
                    n = this.center(SynthInternalFrameTitlePane.this.closeButton, insets, n, false);
                }
                if (SynthInternalFrameTitlePane.this.frame.isMaximizable()) {
                    n = this.center(SynthInternalFrameTitlePane.this.maxButton, insets, n, false);
                }
                if (SynthInternalFrameTitlePane.this.frame.isIconifiable()) {
                    n = this.center(SynthInternalFrameTitlePane.this.iconButton, insets, n, false);
                }
            }
        }
    }

    private static class JPopupMenuUIResource
    extends JPopupMenu
    implements UIResource {
        private JPopupMenuUIResource() {
        }
    }
}

