/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.Canvas;
import java.awt.Component;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.Window;
import java.awt.peer.ComponentPeer;
import java.awt.peer.KeyboardFocusManagerPeer;
import sun.awt.AWTAccessor;
import sun.awt.CausedFocusEvent;
import sun.awt.SunToolkit;
import sun.util.logging.PlatformLogger;

public abstract class KeyboardFocusManagerPeerImpl
implements KeyboardFocusManagerPeer {
    private static final PlatformLogger focusLog = PlatformLogger.getLogger("sun.awt.focus.KeyboardFocusManagerPeerImpl");
    private static AWTAccessor.KeyboardFocusManagerAccessor kfmAccessor = AWTAccessor.getKeyboardFocusManagerAccessor();
    public static final int SNFH_FAILURE = 0;
    public static final int SNFH_SUCCESS_HANDLED = 1;
    public static final int SNFH_SUCCESS_PROCEED = 2;

    @Override
    public void clearGlobalFocusOwner(Window window) {
        if (window != null) {
            Component component = window.getFocusOwner();
            if (focusLog.isLoggable(PlatformLogger.Level.FINE)) {
                focusLog.fine("Clearing global focus owner " + component);
            }
            if (component != null) {
                CausedFocusEvent causedFocusEvent = new CausedFocusEvent(component, 1005, false, null, CausedFocusEvent.Cause.CLEAR_GLOBAL_FOCUS_OWNER);
                SunToolkit.postPriorityEvent(causedFocusEvent);
            }
        }
    }

    public static boolean shouldFocusOnClick(Component component) {
        boolean bl = false;
        if (component instanceof Canvas || component instanceof Scrollbar) {
            bl = true;
        } else if (component instanceof Panel) {
            bl = ((Panel)component).getComponentCount() == 0;
        } else {
            ComponentPeer componentPeer = component != null ? component.getPeer() : null;
            bl = componentPeer != null ? componentPeer.isFocusable() : false;
        }
        return bl && AWTAccessor.getComponentAccessor().canBeFocusOwner(component);
    }

    public static boolean deliverFocus(Component component, Component component2, boolean bl, boolean bl2, long l, CausedFocusEvent.Cause cause, Component component3) {
        CausedFocusEvent causedFocusEvent;
        Component component4;
        if (component == null) {
            component = component2;
        }
        if ((component4 = component3) != null && component4.getPeer() == null) {
            component4 = null;
        }
        if (component4 != null) {
            causedFocusEvent = new CausedFocusEvent(component4, 1005, false, component, cause);
            if (focusLog.isLoggable(PlatformLogger.Level.FINER)) {
                focusLog.finer("Posting focus event: " + causedFocusEvent);
            }
            SunToolkit.postPriorityEvent(causedFocusEvent);
        }
        causedFocusEvent = new CausedFocusEvent(component, 1004, false, component4, cause);
        if (focusLog.isLoggable(PlatformLogger.Level.FINER)) {
            focusLog.finer("Posting focus event: " + causedFocusEvent);
        }
        SunToolkit.postPriorityEvent(causedFocusEvent);
        return true;
    }

    public static boolean requestFocusFor(Component component, CausedFocusEvent.Cause cause) {
        return AWTAccessor.getComponentAccessor().requestFocus(component, cause);
    }

    public static int shouldNativelyFocusHeavyweight(Component component, Component component2, boolean bl, boolean bl2, long l, CausedFocusEvent.Cause cause) {
        return kfmAccessor.shouldNativelyFocusHeavyweight(component, component2, bl, bl2, l, cause);
    }

    public static void removeLastFocusRequest(Component component) {
        kfmAccessor.removeLastFocusRequest(component);
    }

    public static boolean processSynchronousLightweightTransfer(Component component, Component component2, boolean bl, boolean bl2, long l) {
        return kfmAccessor.processSynchronousLightweightTransfer(component, component2, bl, bl2, l);
    }
}

