/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.peer.MenuItemPeer;
import sun.awt.AWTAccessor;
import sun.awt.X11.XBaseMenuWindow;
import sun.awt.X11.XPopupMenuPeer;
import sun.awt.X11.XWindow;

public class XMenuItemPeer
implements MenuItemPeer {
    private XBaseMenuWindow container;
    private MenuItem target;
    private Rectangle bounds;
    private Point textOrigin;
    private static final int SEPARATOR_WIDTH = 20;
    private static final int SEPARATOR_HEIGHT = 5;
    private TextMetrics textMetrics;

    XMenuItemPeer(MenuItem menuItem) {
        this.target = menuItem;
    }

    @Override
    public void dispose() {
    }

    @Override
    public void setFont(Font font) {
        this.resetTextMetrics();
        this.repaintIfShowing();
    }

    @Override
    public void setLabel(String string) {
        this.resetTextMetrics();
        this.repaintIfShowing();
    }

    @Override
    public void setEnabled(boolean bl) {
        this.repaintIfShowing();
    }

    public void enable() {
        this.setEnabled(true);
    }

    public void disable() {
        this.setEnabled(false);
    }

    MenuItem getTarget() {
        return this.target;
    }

    Font getTargetFont() {
        if (this.target == null) {
            return XWindow.getDefaultFont();
        }
        return AWTAccessor.getMenuComponentAccessor().getFont_NoClientCode(this.target);
    }

    String getTargetLabel() {
        if (this.target == null) {
            return "";
        }
        String string = AWTAccessor.getMenuItemAccessor().getLabel(this.target);
        return string == null ? "" : string;
    }

    boolean isTargetEnabled() {
        if (this.target == null) {
            return false;
        }
        return AWTAccessor.getMenuItemAccessor().isEnabled(this.target);
    }

    boolean isTargetItemEnabled() {
        if (this.target == null) {
            return false;
        }
        return AWTAccessor.getMenuItemAccessor().isItemEnabled(this.target);
    }

    String getTargetActionCommand() {
        if (this.target == null) {
            return "";
        }
        return AWTAccessor.getMenuItemAccessor().getActionCommandImpl(this.target);
    }

    MenuShortcut getTargetShortcut() {
        if (this.target == null) {
            return null;
        }
        return AWTAccessor.getMenuItemAccessor().getShortcut(this.target);
    }

    String getShortcutText() {
        if (this.container == null) {
            return null;
        }
        if (this.container.getRootMenuWindow() instanceof XPopupMenuPeer) {
            return null;
        }
        MenuShortcut menuShortcut = this.getTargetShortcut();
        return menuShortcut == null ? null : menuShortcut.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setContainer(XBaseMenuWindow xBaseMenuWindow) {
        Object object = XBaseMenuWindow.getMenuTreeLock();
        synchronized (object) {
            this.container = xBaseMenuWindow;
        }
    }

    XBaseMenuWindow getContainer() {
        return this.container;
    }

    boolean isSeparator() {
        boolean bl = this.getTargetLabel().equals("-");
        return bl;
    }

    boolean isContainerShowing() {
        if (this.container == null) {
            return false;
        }
        return this.container.isShowing();
    }

    void repaintIfShowing() {
        if (this.isContainerShowing()) {
            this.container.postPaintEvent();
        }
    }

    void action(long l) {
        if (!this.isSeparator() && this.isTargetItemEnabled()) {
            XWindow.postEventStatic(new ActionEvent(this.target, 1001, this.getTargetActionCommand(), l, 0));
        }
    }

    TextMetrics getTextMetrics() {
        TextMetrics textMetrics = this.textMetrics;
        if (textMetrics == null) {
            this.textMetrics = textMetrics = this.calcTextMetrics();
        }
        return textMetrics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TextMetrics calcTextMetrics() {
        if (this.container == null) {
            return null;
        }
        if (this.isSeparator()) {
            return new TextMetrics(new Dimension(20, 5), 0, 0);
        }
        Graphics graphics = this.container.getGraphics();
        if (graphics == null) {
            return null;
        }
        try {
            graphics.setFont(this.getTargetFont());
            FontMetrics fontMetrics = graphics.getFontMetrics();
            String string = this.getTargetLabel();
            int n = fontMetrics.stringWidth(string);
            int n2 = fontMetrics.getHeight();
            Dimension dimension = new Dimension(n, n2);
            int n3 = fontMetrics.getHeight() - fontMetrics.getAscent();
            String string2 = this.getShortcutText();
            int n4 = string2 == null ? 0 : fontMetrics.stringWidth(string2);
            TextMetrics textMetrics = new TextMetrics(dimension, n4, n3);
            return textMetrics;
        }
        finally {
            graphics.dispose();
        }
    }

    void resetTextMetrics() {
        this.textMetrics = null;
        if (this.container != null) {
            this.container.updateSize();
        }
    }

    void map(Rectangle rectangle, Point point) {
        this.bounds = rectangle;
        this.textOrigin = point;
    }

    Rectangle getBounds() {
        return this.bounds;
    }

    Point getTextOrigin() {
        return this.textOrigin;
    }

    static class TextMetrics
    implements Cloneable {
        private Dimension textDimension;
        private int shortcutWidth;
        private int textBaseline;

        TextMetrics(Dimension dimension, int n, int n2) {
            this.textDimension = dimension;
            this.shortcutWidth = n;
            this.textBaseline = n2;
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new InternalError();
            }
        }

        Dimension getTextDimension() {
            return this.textDimension;
        }

        int getShortcutWidth() {
            return this.shortcutWidth;
        }

        int getTextBaseline() {
            return this.textBaseline;
        }
    }
}

