/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.xr;

import java.awt.AlphaComposite;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import sun.awt.SunToolkit;
import sun.awt.X11ComponentPeer;
import sun.font.FontManagerNativeLibrary;
import sun.java2d.InvalidPipeException;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;
import sun.java2d.SurfaceDataProxy;
import sun.java2d.jules.JulesPathBuf;
import sun.java2d.jules.JulesShapePipe;
import sun.java2d.loops.CompositeType;
import sun.java2d.loops.MaskFill;
import sun.java2d.loops.RenderLoops;
import sun.java2d.loops.SurfaceType;
import sun.java2d.loops.XORComposite;
import sun.java2d.pipe.PixelToShapeConverter;
import sun.java2d.pipe.Region;
import sun.java2d.pipe.ShapeDrawPipe;
import sun.java2d.pipe.TextPipe;
import sun.java2d.pipe.ValidatePipe;
import sun.java2d.x11.XSurfaceData;
import sun.java2d.xr.XRBackend;
import sun.java2d.xr.XRCompositeManager;
import sun.java2d.xr.XRDrawImage;
import sun.java2d.xr.XRGraphicsConfig;
import sun.java2d.xr.XRMaskBlit;
import sun.java2d.xr.XRMaskFill;
import sun.java2d.xr.XRPMBlitLoops;
import sun.java2d.xr.XRPaints;
import sun.java2d.xr.XRRenderer;
import sun.java2d.xr.XRSurfaceDataProxy;
import sun.java2d.xr.XRUtils;

public abstract class XRSurfaceData
extends XSurfaceData {
    X11ComponentPeer peer;
    XRGraphicsConfig graphicsConfig;
    XRBackend renderQueue;
    private RenderLoops solidloops;
    protected int depth;
    public static final String DESC_BYTE_A8_X11 = "Byte A8 Pixmap";
    public static final String DESC_INT_RGB_X11 = "Integer RGB Pixmap";
    public static final String DESC_INT_ARGB_X11 = "Integer ARGB-Pre Pixmap";
    public static final SurfaceType ByteA8X11 = SurfaceType.ByteGray.deriveSubType("Byte A8 Pixmap");
    public static final SurfaceType IntRgbX11 = SurfaceType.IntRgb.deriveSubType("Integer RGB Pixmap");
    public static final SurfaceType IntArgbPreX11 = SurfaceType.IntArgbPre.deriveSubType("Integer ARGB-Pre Pixmap");
    protected XRRenderer xrpipe;
    protected PixelToShapeConverter xrtxpipe;
    protected TextPipe xrtextpipe;
    protected XRDrawImage xrDrawImage;
    protected ShapeDrawPipe aaShapePipe;
    protected PixelToShapeConverter aaPixelToShapeConv;
    private long xgc;
    private int validatedGCForegroundPixel = 0;
    private XORComposite validatedXorComp;
    private int xid;
    public int picture;
    public XRCompositeManager maskBuffer;
    private Region validatedClip;
    private Region validatedGCClip;
    private boolean validatedExposures = true;
    boolean transformInUse = false;
    AffineTransform validatedSourceTransform = new AffineTransform();
    int validatedRepeat = 0;
    int validatedFilter = 0;

    private static native void initIDs();

    protected native void XRInitSurface(int var1, int var2, int var3, long var4, int var6);

    native void initXRPicture(long var1, int var3);

    native void freeXSDOPicture(long var1);

    @Override
    public Raster getRaster(int n, int n2, int n3, int n4) {
        throw new InternalError("not implemented yet");
    }

    public static void initXRSurfaceData() {
        if (!XRSurfaceData.isX11SurfaceDataInitialized()) {
            FontManagerNativeLibrary.load();
            XRSurfaceData.initIDs();
            XRPMBlitLoops.register();
            XRMaskFill.register();
            XRMaskBlit.register();
            XRSurfaceData.setX11SurfaceDataInitialized();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isXRDrawableValid() {
        try {
            SunToolkit.awtLock();
            boolean bl = this.isDrawableValid();
            return bl;
        }
        finally {
            SunToolkit.awtUnlock();
        }
    }

    @Override
    public SurfaceDataProxy makeProxyFor(SurfaceData surfaceData) {
        return XRSurfaceDataProxy.createProxy(surfaceData, this.graphicsConfig);
    }

    @Override
    public void validatePipe(SunGraphics2D sunGraphics2D) {
        TextPipe textPipe;
        boolean bl = false;
        if (!(sunGraphics2D.compositeState >= 2 || sunGraphics2D.paintState >= 5 && sunGraphics2D.composite != null && sunGraphics2D.composite instanceof AlphaComposite && ((AlphaComposite)sunGraphics2D.composite).getAlpha() != 1.0f)) {
            textPipe = this.xrtextpipe;
        } else {
            super.validatePipe(sunGraphics2D);
            textPipe = sunGraphics2D.textpipe;
            bl = true;
        }
        PixelToShapeConverter pixelToShapeConverter = null;
        XRRenderer xRRenderer = null;
        if (sunGraphics2D.antialiasHint != 2) {
            if (sunGraphics2D.paintState <= 1) {
                if (sunGraphics2D.compositeState <= 2) {
                    pixelToShapeConverter = this.xrtxpipe;
                    xRRenderer = this.xrpipe;
                }
            } else if (sunGraphics2D.compositeState <= 1 && XRPaints.isValid(sunGraphics2D)) {
                pixelToShapeConverter = this.xrtxpipe;
                xRRenderer = this.xrpipe;
            }
        }
        if (sunGraphics2D.antialiasHint == 2 && JulesPathBuf.isCairoAvailable()) {
            sunGraphics2D.shapepipe = this.aaShapePipe;
            sunGraphics2D.drawpipe = this.aaPixelToShapeConv;
            sunGraphics2D.fillpipe = this.aaPixelToShapeConv;
        } else if (pixelToShapeConverter != null) {
            if (sunGraphics2D.transformState >= 3) {
                sunGraphics2D.drawpipe = pixelToShapeConverter;
                sunGraphics2D.fillpipe = pixelToShapeConverter;
            } else if (sunGraphics2D.strokeState != 0) {
                sunGraphics2D.drawpipe = pixelToShapeConverter;
                sunGraphics2D.fillpipe = xRRenderer;
            } else {
                sunGraphics2D.drawpipe = xRRenderer;
                sunGraphics2D.fillpipe = xRRenderer;
            }
            sunGraphics2D.shapepipe = xRRenderer;
        } else if (!bl) {
            super.validatePipe(sunGraphics2D);
        }
        sunGraphics2D.textpipe = textPipe;
        sunGraphics2D.imagepipe = this.xrDrawImage;
    }

    @Override
    protected MaskFill getMaskFill(SunGraphics2D sunGraphics2D) {
        if (sunGraphics2D.paintState > 1 && !XRPaints.isValid(sunGraphics2D)) {
            return null;
        }
        return super.getMaskFill(sunGraphics2D);
    }

    @Override
    public RenderLoops getRenderLoops(SunGraphics2D sunGraphics2D) {
        if (sunGraphics2D.paintState <= 1 && sunGraphics2D.compositeState <= 1) {
            return this.solidloops;
        }
        return super.getRenderLoops(sunGraphics2D);
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        return this.graphicsConfig;
    }

    public static XRWindowSurfaceData createData(X11ComponentPeer x11ComponentPeer) {
        XRGraphicsConfig xRGraphicsConfig = XRSurfaceData.getGC(x11ComponentPeer);
        return new XRWindowSurfaceData(x11ComponentPeer, xRGraphicsConfig, xRGraphicsConfig.getSurfaceType());
    }

    public static XRPixmapSurfaceData createData(XRGraphicsConfig xRGraphicsConfig, int n, int n2, ColorModel colorModel, Image image, long l, int n3) {
        int n4 = n3 > 1 ? 32 : 24;
        colorModel = n4 == 24 ? new DirectColorModel(n4, 0xFF0000, 65280, 255) : new DirectColorModel(n4, 0xFF0000, 65280, 255, -16777216);
        return new XRPixmapSurfaceData(xRGraphicsConfig, n, n2, image, XRSurfaceData.getSurfaceType(xRGraphicsConfig, n3), colorModel, l, n3, XRUtils.getPictureFormatForTransparency(n3), n4);
    }

    protected XRSurfaceData(X11ComponentPeer x11ComponentPeer, XRGraphicsConfig xRGraphicsConfig, SurfaceType surfaceType, ColorModel colorModel, int n, int n2) {
        super(surfaceType, colorModel);
        this.peer = x11ComponentPeer;
        this.graphicsConfig = xRGraphicsConfig;
        this.solidloops = this.graphicsConfig.getSolidLoops(surfaceType);
        this.depth = n;
        this.initOps(x11ComponentPeer, this.graphicsConfig, n);
        this.setBlitProxyKey(xRGraphicsConfig.getProxyKey());
    }

    protected XRSurfaceData(XRBackend xRBackend) {
        super(IntRgbX11, new DirectColorModel(24, 0xFF0000, 65280, 255));
        this.renderQueue = xRBackend;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initXRender(int n) {
        try {
            SunToolkit.awtLock();
            this.initXRPicture(this.getNativeOps(), n);
            this.renderQueue = XRCompositeManager.getInstance(this).getBackend();
            this.maskBuffer = XRCompositeManager.getInstance(this);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        finally {
            SunToolkit.awtUnlock();
        }
    }

    public static XRGraphicsConfig getGC(X11ComponentPeer x11ComponentPeer) {
        if (x11ComponentPeer != null) {
            return (XRGraphicsConfig)x11ComponentPeer.getGraphicsConfiguration();
        }
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        return (XRGraphicsConfig)graphicsDevice.getDefaultConfiguration();
    }

    public abstract boolean canSourceSendExposures(int var1, int var2, int var3, int var4);

    public void validateCopyAreaGC(Region region, boolean bl) {
        if (this.validatedGCClip != region) {
            if (region != null) {
                this.renderQueue.setGCClipRectangles(this.xgc, region);
            }
            this.validatedGCClip = region;
        }
        if (this.validatedExposures != bl) {
            this.validatedExposures = bl;
            this.renderQueue.setGCExposures(this.xgc, bl);
        }
        if (this.validatedXorComp != null) {
            this.renderQueue.setGCMode(this.xgc, true);
            this.renderQueue.setGCForeground(this.xgc, this.validatedGCForegroundPixel);
            this.validatedXorComp = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean copyArea(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.xrpipe == null) {
            if (!this.isXRDrawableValid()) {
                return true;
            }
            this.makePipes();
        }
        CompositeType compositeType = sunGraphics2D.imageComp;
        if (sunGraphics2D.transformState < 3 && (CompositeType.SrcOverNoEa.equals(compositeType) || CompositeType.SrcNoEa.equals(compositeType))) {
            n += sunGraphics2D.transX;
            n2 += sunGraphics2D.transY;
            try {
                SunToolkit.awtLock();
                boolean bl = this.canSourceSendExposures(n, n2, n3, n4);
                this.validateCopyAreaGC(sunGraphics2D.getCompClip(), bl);
                this.renderQueue.copyArea(this.xid, this.xid, this.xgc, n, n2, n3, n4, n + n5, n2 + n6);
            }
            finally {
                SunToolkit.awtUnlock();
            }
            return true;
        }
        return false;
    }

    public static SurfaceType getSurfaceType(XRGraphicsConfig xRGraphicsConfig, int n) {
        SurfaceType surfaceType = null;
        switch (n) {
            case 1: {
                surfaceType = IntRgbX11;
                break;
            }
            case 2: 
            case 3: {
                surfaceType = IntArgbPreX11;
            }
        }
        return surfaceType;
    }

    @Override
    public void invalidate() {
        if (this.isValid()) {
            this.setInvalid();
            super.invalidate();
        }
    }

    void validateAsSource(AffineTransform affineTransform, int n, int n2) {
        if (this.validatedClip != null) {
            this.validatedClip = null;
            this.renderQueue.setClipRectangles(this.picture, null);
        }
        if (this.validatedRepeat != n && n != -1) {
            this.validatedRepeat = n;
            this.renderQueue.setPictureRepeat(this.picture, n);
        }
        if (affineTransform == null) {
            if (this.transformInUse) {
                this.validatedSourceTransform.setToIdentity();
                this.renderQueue.setPictureTransform(this.picture, this.validatedSourceTransform);
                this.transformInUse = false;
            }
        } else if (!this.transformInUse || this.transformInUse && !affineTransform.equals(this.validatedSourceTransform)) {
            this.validatedSourceTransform.setTransform(affineTransform.getScaleX(), affineTransform.getShearY(), affineTransform.getShearX(), affineTransform.getScaleY(), affineTransform.getTranslateX(), affineTransform.getTranslateY());
            this.renderQueue.setPictureTransform(this.picture, this.validatedSourceTransform);
            this.transformInUse = true;
        }
        if (n2 != this.validatedFilter && n2 != -1) {
            this.renderQueue.setFilter(this.picture, n2);
            this.validatedFilter = n2;
        }
    }

    public void validateAsDestination(SunGraphics2D sunGraphics2D, Region region) {
        if (!this.isValid()) {
            throw new InvalidPipeException("bounds changed");
        }
        boolean bl = false;
        if (region != this.validatedClip) {
            this.renderQueue.setClipRectangles(this.picture, region);
            this.validatedClip = region;
            bl = true;
        }
        if (sunGraphics2D != null && sunGraphics2D.compositeState == 2) {
            if (this.validatedXorComp != sunGraphics2D.getComposite()) {
                this.validatedXorComp = (XORComposite)sunGraphics2D.getComposite();
                int n = this.validatedXorComp.getXorPixel();
                this.renderQueue.setGCMode(this.xgc, false);
                int n2 = sunGraphics2D.pixel;
                if (this.validatedGCForegroundPixel != n2) {
                    this.renderQueue.setGCForeground(this.xgc, n2 ^ n);
                    this.validatedGCForegroundPixel = n2;
                }
            }
            if (bl) {
                this.renderQueue.setGCClipRectangles(this.xgc, region);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void makePipes() {
        if (this.xrpipe == null) {
            try {
                SunToolkit.awtLock();
                this.xgc = XRSurfaceData.XCreateGC(this.getNativeOps());
                this.xrpipe = new XRRenderer(this.maskBuffer.getMaskBuffer());
                this.xrtxpipe = new PixelToShapeConverter(this.xrpipe);
                this.xrtextpipe = this.maskBuffer.getTextRenderer();
                this.xrDrawImage = new XRDrawImage();
                if (JulesPathBuf.isCairoAvailable()) {
                    this.aaShapePipe = new JulesShapePipe(XRCompositeManager.getInstance(this));
                    this.aaPixelToShapeConv = new PixelToShapeConverter(this.aaShapePipe);
                }
            }
            finally {
                SunToolkit.awtUnlock();
            }
        }
    }

    public long getGC() {
        return this.xgc;
    }

    public int getPicture() {
        return this.picture;
    }

    public int getXid() {
        return this.xid;
    }

    public XRGraphicsConfig getGraphicsConfig() {
        return this.graphicsConfig;
    }

    public static class LazyPipe
    extends ValidatePipe {
        @Override
        public boolean validate(SunGraphics2D sunGraphics2D) {
            XRSurfaceData xRSurfaceData = (XRSurfaceData)sunGraphics2D.surfaceData;
            if (!xRSurfaceData.isXRDrawableValid()) {
                return false;
            }
            xRSurfaceData.makePipes();
            return super.validate(sunGraphics2D);
        }
    }

    public static class XRPixmapSurfaceData
    extends XRSurfaceData {
        Image offscreenImage;
        int width;
        int height;
        int transparency;

        public XRPixmapSurfaceData(XRGraphicsConfig xRGraphicsConfig, int n, int n2, Image image, SurfaceType surfaceType, ColorModel colorModel, long l, int n3, int n4, int n5) {
            super(null, xRGraphicsConfig, surfaceType, colorModel, n5, n3);
            this.width = n;
            this.height = n2;
            this.offscreenImage = image;
            this.transparency = n3;
            this.initSurface(n5, n, n2, l, n4);
            this.initXRender(n4);
            this.makePipes();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void initSurface(int n, int n2, int n3, long l, int n4) {
            try {
                SunToolkit.awtLock();
                this.XRInitSurface(n, n2, n3, l, n4);
            }
            finally {
                SunToolkit.awtUnlock();
            }
        }

        @Override
        public SurfaceData getReplacement() {
            return XRPixmapSurfaceData.restoreContents(this.offscreenImage);
        }

        @Override
        public int getTransparency() {
            return this.transparency;
        }

        @Override
        public Rectangle getBounds() {
            return new Rectangle(this.width, this.height);
        }

        @Override
        public boolean canSourceSendExposures(int n, int n2, int n3, int n4) {
            return n < 0 || n2 < 0 || n + n3 > this.width || n2 + n4 > this.height;
        }

        @Override
        public void flush() {
            this.invalidate();
            this.flushNativeSurface();
        }

        @Override
        public Object getDestination() {
            return this.offscreenImage;
        }
    }

    public static class XRInternalSurfaceData
    extends XRSurfaceData {
        public XRInternalSurfaceData(XRBackend xRBackend, int n, AffineTransform affineTransform) {
            super(xRBackend);
            this.picture = n;
            this.validatedSourceTransform = affineTransform;
            if (this.validatedSourceTransform != null) {
                this.transformInUse = true;
            }
        }

        @Override
        public boolean canSourceSendExposures(int n, int n2, int n3, int n4) {
            return false;
        }

        @Override
        public Rectangle getBounds() {
            return null;
        }

        @Override
        public Object getDestination() {
            return null;
        }

        @Override
        public SurfaceData getReplacement() {
            return null;
        }
    }

    public static class XRWindowSurfaceData
    extends XRSurfaceData {
        public XRWindowSurfaceData(X11ComponentPeer x11ComponentPeer, XRGraphicsConfig xRGraphicsConfig, SurfaceType surfaceType) {
            super(x11ComponentPeer, xRGraphicsConfig, surfaceType, x11ComponentPeer.getColorModel(), x11ComponentPeer.getColorModel().getPixelSize(), 1);
            if (this.isXRDrawableValid()) {
                this.initXRender(XRUtils.getPictureFormatForTransparency(1));
                this.makePipes();
            }
        }

        @Override
        public SurfaceData getReplacement() {
            return this.peer.getSurfaceData();
        }

        @Override
        public Rectangle getBounds() {
            Rectangle rectangle = this.peer.getBounds();
            rectangle.y = 0;
            rectangle.x = 0;
            return rectangle;
        }

        @Override
        public boolean canSourceSendExposures(int n, int n2, int n3, int n4) {
            return true;
        }

        @Override
        public Object getDestination() {
            return this.peer.getTarget();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void invalidate() {
            try {
                SunToolkit.awtLock();
                this.freeXSDOPicture(this.getNativeOps());
            }
            finally {
                SunToolkit.awtUnlock();
            }
            super.invalidate();
        }
    }
}

