/*
 * Decompiled with CFR 0.152.
 */
package sun.net.httpserver;

import java.io.IOException;
import java.io.InputStream;
import sun.net.httpserver.ExchangeImpl;
import sun.net.httpserver.LeftOverInputStream;

class FixedLengthInputStream
extends LeftOverInputStream {
    private long remaining;

    FixedLengthInputStream(ExchangeImpl exchangeImpl, InputStream inputStream, long l) {
        super(exchangeImpl, inputStream);
        if (l < 0L) {
            throw new IllegalArgumentException("Content-Length: " + l);
        }
        this.remaining = l;
    }

    @Override
    protected int readImpl(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        boolean bl = this.eof = this.remaining == 0L;
        if (this.eof) {
            return -1;
        }
        if ((long)n2 > this.remaining) {
            n2 = (int)this.remaining;
        }
        if ((n3 = this.in.read(byArray, n, n2)) > -1) {
            this.remaining -= (long)n3;
            if (this.remaining == 0L) {
                this.t.getServerImpl().requestCompleted(this.t.getConnection());
            }
        }
        return n3;
    }

    @Override
    public int available() throws IOException {
        if (this.eof) {
            return 0;
        }
        int n = this.in.available();
        return (long)n < this.remaining ? n : (int)this.remaining;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int n) {
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }
}

