/*
 * Decompiled with CFR 0.152.
 */
package sun.net.util;

import java.net.URL;
import java.nio.CharBuffer;
import java.util.Arrays;
import sun.security.action.GetPropertyAction;

public class IPAddressUtil {
    private static final int INADDR4SZ = 4;
    private static final int INADDR16SZ = 16;
    private static final int INT16SZ = 2;
    private static final long L_IPV6_DELIMS = 0L;
    private static final long H_IPV6_DELIMS = 0x28000000L;
    private static final long L_GEN_DELIMS = -8935000888854970368L;
    private static final long H_GEN_DELIMS = 671088641L;
    private static final long L_AUTH_DELIMS = 0x400000000000000L;
    private static final long H_AUTH_DELIMS = 671088641L;
    private static final long L_COLON = 0x400000000000000L;
    private static final long H_COLON = 0L;
    private static final long L_SLASH = 0x800000000000L;
    private static final long H_SLASH = 0L;
    private static final long L_BACKSLASH = 0L;
    private static final long H_BACKSLASH = 0x10000000L;
    private static final long L_NON_PRINTABLE = 0xFFFFFFFFL;
    private static final long H_NON_PRINTABLE = Long.MIN_VALUE;
    private static final long L_EXCLUDE = -8935000884560003073L;
    private static final long H_EXCLUDE = -9223372035915251711L;
    private static final char[] OTHERS = new char[]{'\u2047', '\u2048', '\u2049', '\u2100', '\u2101', '\u2105', '\u2106', '\u2a74', '\ufe55', '\ufe56', '\ufe5f', '\ufe6b', '\uff03', '\uff0f', '\uff1a', '\uff1f', '\uff20'};
    private static final int HEXADECIMAL = 16;
    private static final int DECIMAL = 10;
    private static final int OCTAL = 8;
    private static final int[] SUPPORTED_RADIXES = new int[]{16, 8, 10};
    private static final long CANT_PARSE_IN_RADIX = -1L;
    private static final long TERMINAL_PARSE_ERROR = -2L;
    private static final String ALLOW_AMBIGUOUS_IPADDRESS_LITERALS_SP = "jdk.net.allowAmbiguousIPAddressLiterals";
    private static final boolean ALLOW_AMBIGUOUS_IPADDRESS_LITERALS_SP_VALUE = Boolean.valueOf(GetPropertyAction.privilegedGetProperty("jdk.net.allowAmbiguousIPAddressLiterals", "false"));

    public static byte[] textToNumericFormatV4(String string) {
        if (string.length() == 0) {
            return null;
        }
        byte[] byArray = new byte[4];
        String[] stringArray = string.split("\\.", -1);
        try {
            switch (stringArray.length) {
                case 1: {
                    long l = Long.parseLong(stringArray[0]);
                    if (l < 0L || l > 0xFFFFFFFFL) {
                        return null;
                    }
                    byArray[0] = (byte)(l >> 24 & 0xFFL);
                    byArray[1] = (byte)((l & 0xFFFFFFL) >> 16 & 0xFFL);
                    byArray[2] = (byte)((l & 0xFFFFL) >> 8 & 0xFFL);
                    byArray[3] = (byte)(l & 0xFFL);
                    break;
                }
                case 2: {
                    long l = Integer.parseInt(stringArray[0]);
                    if (l < 0L || l > 255L) {
                        return null;
                    }
                    byArray[0] = (byte)(l & 0xFFL);
                    l = Integer.parseInt(stringArray[1]);
                    if (l < 0L || l > 0xFFFFFFL) {
                        return null;
                    }
                    byArray[1] = (byte)(l >> 16 & 0xFFL);
                    byArray[2] = (byte)((l & 0xFFFFL) >> 8 & 0xFFL);
                    byArray[3] = (byte)(l & 0xFFL);
                    break;
                }
                case 3: {
                    long l;
                    for (int i = 0; i < 2; ++i) {
                        l = Integer.parseInt(stringArray[i]);
                        if (l < 0L || l > 255L) {
                            return null;
                        }
                        byArray[i] = (byte)(l & 0xFFL);
                    }
                    l = Integer.parseInt(stringArray[2]);
                    if (l < 0L || l > 65535L) {
                        return null;
                    }
                    byArray[2] = (byte)(l >> 8 & 0xFFL);
                    byArray[3] = (byte)(l & 0xFFL);
                    break;
                }
                case 4: {
                    for (int i = 0; i < 4; ++i) {
                        long l = Integer.parseInt(stringArray[i]);
                        if (l < 0L || l > 255L) {
                            return null;
                        }
                        byArray[i] = (byte)(l & 0xFFL);
                    }
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        return byArray;
    }

    public static byte[] validateNumericFormatV4(String string) {
        byte[] byArray = IPAddressUtil.textToNumericFormatV4(string);
        if (!ALLOW_AMBIGUOUS_IPADDRESS_LITERALS_SP_VALUE && byArray == null && IPAddressUtil.isBsdParsableV4(string)) {
            throw new IllegalArgumentException("Invalid IP address literal: " + string);
        }
        return byArray;
    }

    public static byte[] textToNumericFormatV6(String string) {
        int n;
        if (string.length() < 2) {
            return null;
        }
        char[] cArray = string.toCharArray();
        byte[] byArray = new byte[16];
        int n2 = cArray.length;
        int n3 = string.indexOf("%");
        if (n3 == n2 - 1) {
            return null;
        }
        if (n3 != -1) {
            n2 = n3;
        }
        int n4 = -1;
        int n5 = 0;
        int n6 = 0;
        if (cArray[n5] == ':' && cArray[++n5] != ':') {
            return null;
        }
        int n7 = n5;
        boolean bl = false;
        int n8 = 0;
        while (n5 < n2) {
            char c;
            if ((n = IPAddressUtil.digit(c = cArray[n5++], 16)) != -1) {
                n8 <<= 4;
                if ((n8 |= n) > 65535) {
                    return null;
                }
                bl = true;
                continue;
            }
            if (c == ':') {
                n7 = n5;
                if (!bl) {
                    if (n4 != -1) {
                        return null;
                    }
                    n4 = n6;
                    continue;
                }
                if (n5 == n2) {
                    return null;
                }
                if (n6 + 2 > 16) {
                    return null;
                }
                byArray[n6++] = (byte)(n8 >> 8 & 0xFF);
                byArray[n6++] = (byte)(n8 & 0xFF);
                bl = false;
                n8 = 0;
                continue;
            }
            if (c == '.' && n6 + 4 <= 16) {
                String string2 = string.substring(n7, n2);
                int n9 = 0;
                int n10 = 0;
                while ((n10 = string2.indexOf(46, n10)) != -1) {
                    ++n9;
                    ++n10;
                }
                if (n9 != 3) {
                    return null;
                }
                byte[] byArray2 = IPAddressUtil.textToNumericFormatV4(string2);
                if (byArray2 == null) {
                    return null;
                }
                for (int i = 0; i < 4; ++i) {
                    byArray[n6++] = byArray2[i];
                }
                bl = false;
                break;
            }
            return null;
        }
        if (bl) {
            if (n6 + 2 > 16) {
                return null;
            }
            byArray[n6++] = (byte)(n8 >> 8 & 0xFF);
            byArray[n6++] = (byte)(n8 & 0xFF);
        }
        if (n4 != -1) {
            n = n6 - n4;
            if (n6 == 16) {
                return null;
            }
            for (n5 = 1; n5 <= n; ++n5) {
                byArray[16 - n5] = byArray[n4 + n - n5];
                byArray[n4 + n - n5] = 0;
            }
            n6 = 16;
        }
        if (n6 != 16) {
            return null;
        }
        byte[] byArray3 = IPAddressUtil.convertFromIPv4MappedAddress(byArray);
        if (byArray3 != null) {
            return byArray3;
        }
        return byArray;
    }

    public static boolean isIPv4LiteralAddress(String string) {
        return IPAddressUtil.textToNumericFormatV4(string) != null;
    }

    public static boolean isIPv6LiteralAddress(String string) {
        return IPAddressUtil.textToNumericFormatV6(string) != null;
    }

    public static byte[] convertFromIPv4MappedAddress(byte[] byArray) {
        if (IPAddressUtil.isIPv4MappedAddress(byArray)) {
            byte[] byArray2 = new byte[4];
            System.arraycopy(byArray, 12, byArray2, 0, 4);
            return byArray2;
        }
        return null;
    }

    private static boolean isIPv4MappedAddress(byte[] byArray) {
        if (byArray.length < 16) {
            return false;
        }
        return byArray[0] == 0 && byArray[1] == 0 && byArray[2] == 0 && byArray[3] == 0 && byArray[4] == 0 && byArray[5] == 0 && byArray[6] == 0 && byArray[7] == 0 && byArray[8] == 0 && byArray[9] == 0 && byArray[10] == -1 && byArray[11] == -1;
    }

    public static boolean match(char c, long l, long l2) {
        if (c < '@') {
            return (1L << c & l) != 0L;
        }
        if (c < '\u0080') {
            return (1L << c - 64 & l2) != 0L;
        }
        return false;
    }

    public static int scan(String string, long l, long l2) {
        int n;
        int n2 = -1;
        if (string == null || (n = string.length()) == 0) {
            return -1;
        }
        boolean bl = false;
        while (++n2 < n && !(bl = IPAddressUtil.match(string.charAt(n2), l, l2))) {
        }
        if (bl) {
            return n2;
        }
        return -1;
    }

    public static int scan(String string, long l, long l2, char[] cArray) {
        char c;
        int n;
        int n2 = -1;
        if (string == null || (n = string.length()) == 0) {
            return -1;
        }
        boolean bl = false;
        char c2 = cArray[0];
        while (++n2 < n && !(bl = IPAddressUtil.match(c = string.charAt(n2), l, l2))) {
            if (c < c2 || Arrays.binarySearch(cArray, c) <= -1) continue;
            bl = true;
            break;
        }
        if (bl) {
            return n2;
        }
        return -1;
    }

    private static String describeChar(char c) {
        if (c < ' ' || c == '\u007f') {
            if (c == '\n') {
                return "LF";
            }
            if (c == '\r') {
                return "CR";
            }
            return "control char (code=" + c + ")";
        }
        if (c == '\\') {
            return "'\\'";
        }
        return "'" + c + "'";
    }

    private static String checkUserInfo(String string) {
        int n = IPAddressUtil.scan(string, -9223231260711714817L, -9223372035915251711L);
        if (n >= 0) {
            return "Illegal character found in user-info: " + IPAddressUtil.describeChar(string.charAt(n));
        }
        return null;
    }

    private static String checkHost(String string) {
        if (string.startsWith("[") && string.endsWith("]")) {
            if (IPAddressUtil.isIPv6LiteralAddress(string = string.substring(1, string.length() - 1))) {
                int n = string.indexOf(37);
                if (n >= 0 && (n = IPAddressUtil.scan(string = string.substring(n), 0xFFFFFFFFL, -9223372036183687168L)) >= 0) {
                    return "Illegal character found in IPv6 scoped address: " + IPAddressUtil.describeChar(string.charAt(n));
                }
                return null;
            }
            return "Unrecognized IPv6 address format";
        }
        int n = IPAddressUtil.scan(string, -8935000884560003073L, -9223372035915251711L);
        if (n >= 0) {
            return "Illegal character found in host: " + IPAddressUtil.describeChar(string.charAt(n));
        }
        return null;
    }

    private static String checkAuth(String string) {
        int n = IPAddressUtil.scan(string, -9223231260711714817L, -9223372036586340352L);
        if (n >= 0) {
            return "Illegal character found in authority: " + IPAddressUtil.describeChar(string.charAt(n));
        }
        return null;
    }

    public static String checkAuthority(URL uRL) {
        if (uRL == null) {
            return null;
        }
        String string = uRL.getUserInfo();
        String string2 = IPAddressUtil.checkUserInfo(string);
        if (string2 != null) {
            return string2;
        }
        String string3 = uRL.getHost();
        string2 = IPAddressUtil.checkHost(string3);
        if (string2 != null) {
            return string2;
        }
        if (string3 == null && string == null) {
            return IPAddressUtil.checkAuth(uRL.getAuthority());
        }
        return null;
    }

    public static String checkExternalForm(URL uRL) {
        if (uRL == null) {
            return null;
        }
        String string = uRL.getUserInfo();
        int n = IPAddressUtil.scan(string, 0x8000FFFFFFFFL, Long.MIN_VALUE);
        if (n >= 0) {
            return "Illegal character found in authority: " + IPAddressUtil.describeChar(string.charAt(n));
        }
        string = IPAddressUtil.checkHostString(uRL.getHost());
        if (string != null) {
            return string;
        }
        return null;
    }

    public static String checkHostString(String string) {
        if (string == null) {
            return null;
        }
        int n = IPAddressUtil.scan(string, 0x8000FFFFFFFFL, Long.MIN_VALUE, OTHERS);
        if (n >= 0) {
            return "Illegal character found in host: " + IPAddressUtil.describeChar(string.charAt(n));
        }
        return null;
    }

    public static int digit(char c, int n) {
        if (ALLOW_AMBIGUOUS_IPADDRESS_LITERALS_SP_VALUE) {
            return Character.digit(c, n);
        }
        return IPAddressUtil.parseAsciiDigit(c, n);
    }

    public static boolean isBsdParsableV4(String string) {
        char c = string.charAt(0);
        if (IPAddressUtil.parseAsciiDigit(c, 10) == -1) {
            return false;
        }
        char c2 = string.charAt(string.length() - 1);
        if (c2 == '.' || IPAddressUtil.parseAsciiHexDigit(c2) == -1) {
            return false;
        }
        CharBuffer charBuffer = CharBuffer.wrap(string);
        int n = 0;
        while (charBuffer.hasRemaining()) {
            long l = -1L;
            for (int n2 : SUPPORTED_RADIXES) {
                l = IPAddressUtil.parseV4FieldBsd(n2, charBuffer, n);
                if (l >= 0L) {
                    ++n;
                    break;
                }
                if (l != -2L) continue;
                return false;
            }
            if (l >= 0L) continue;
            return false;
        }
        return true;
    }

    private static long parseV4FieldBsd(int n, CharBuffer charBuffer, int n2) {
        long l;
        int n3 = charBuffer.position();
        long l2 = 0L;
        int n4 = 0;
        if (!IPAddressUtil.checkPrefix(charBuffer, n)) {
            l2 = -1L;
        }
        boolean bl = false;
        while (charBuffer.hasRemaining() && l2 != -1L && !bl) {
            char c = charBuffer.get();
            if (c == '.') {
                bl = true;
                if (n2 == 3) {
                    return -2L;
                }
                if (n4 == 0) {
                    return -2L;
                }
                if (l2 <= 255L) continue;
                return -2L;
            }
            int n5 = IPAddressUtil.parseAsciiDigit(c, n);
            if (n5 >= 0) {
                ++n4;
                l2 *= (long)n;
                l2 += (long)n5;
                continue;
            }
            return -2L;
        }
        if (l2 == -1L) {
            charBuffer.position(n3);
        } else if (!bl && l2 > (l = (1L << (4 - n2) * 8) - 1L)) {
            return -2L;
        }
        return l2;
    }

    private static boolean checkPrefix(CharBuffer charBuffer, int n) {
        switch (n) {
            case 8: {
                return IPAddressUtil.isOctalFieldStart(charBuffer);
            }
            case 10: {
                return IPAddressUtil.isDecimalFieldStart(charBuffer);
            }
            case 16: {
                return IPAddressUtil.isHexFieldStart(charBuffer);
            }
        }
        throw new AssertionError((Object)"Not supported radix");
    }

    private static boolean isOctalFieldStart(CharBuffer charBuffer) {
        boolean bl;
        if (charBuffer.remaining() < 2) {
            return false;
        }
        int n = charBuffer.position();
        char c = charBuffer.get();
        char c2 = charBuffer.get();
        boolean bl2 = bl = c == '0' && c2 != '.';
        if (bl) {
            charBuffer.position(n + 1);
        }
        return bl;
    }

    private static boolean isDecimalFieldStart(CharBuffer charBuffer) {
        return charBuffer.hasRemaining();
    }

    private static boolean isHexFieldStart(CharBuffer charBuffer) {
        if (charBuffer.remaining() < 2) {
            return false;
        }
        char c = charBuffer.get();
        char c2 = charBuffer.get();
        return c == '0' && (c2 == 'x' || c2 == 'X');
    }

    private static int parseAsciiDigit(char c, int n) {
        assert (n == 8 || n == 10 || n == 16);
        if (n == 16) {
            return IPAddressUtil.parseAsciiHexDigit(c);
        }
        int n2 = c - 48;
        return n2 < 0 || n2 >= n ? -1 : n2;
    }

    private static int parseAsciiHexDigit(char c) {
        char c2 = Character.toLowerCase(c);
        if (c2 >= 'a' && c2 <= 'f') {
            return c2 - 97 + 10;
        }
        return IPAddressUtil.parseAsciiDigit(c2, 10);
    }
}

