/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import com.sun.nio.sctp.AbstractNotificationHandler;
import com.sun.nio.sctp.Association;
import com.sun.nio.sctp.AssociationChangeNotification;
import com.sun.nio.sctp.HandlerResult;
import com.sun.nio.sctp.IllegalUnbindException;
import com.sun.nio.sctp.InvalidStreamException;
import com.sun.nio.sctp.MessageInfo;
import com.sun.nio.sctp.NotificationHandler;
import com.sun.nio.sctp.SctpChannel;
import com.sun.nio.sctp.SctpSocketOption;
import com.sun.nio.sctp.SctpStandardSocketOptions;
import java.io.FileDescriptor;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.AlreadyConnectedException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ConnectionPendingException;
import java.nio.channels.NoConnectionPendingException;
import java.nio.channels.NotYetBoundException;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.spi.SelectorProvider;
import java.security.AccessController;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import sun.nio.ch.DirectBuffer;
import sun.nio.ch.IOStatus;
import sun.nio.ch.IOUtil;
import sun.nio.ch.NativeThread;
import sun.nio.ch.Net;
import sun.nio.ch.SctpAssocChange;
import sun.nio.ch.SctpAssociationImpl;
import sun.nio.ch.SctpNet;
import sun.nio.ch.SctpNotification;
import sun.nio.ch.SctpResultContainer;
import sun.nio.ch.SelChImpl;
import sun.nio.ch.SelectionKeyImpl;
import sun.nio.ch.Util;
import sun.security.action.LoadLibraryAction;

public class SctpChannelImpl
extends SctpChannel
implements SelChImpl {
    private final FileDescriptor fd;
    private final int fdVal;
    private volatile long receiverThread = 0L;
    private volatile long senderThread = 0L;
    private final Object receiveLock = new Object();
    private final Object sendLock = new Object();
    private final ThreadLocal<Boolean> receiveInvoked = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };
    private final Object stateLock = new Object();
    private ChannelState state = ChannelState.UNINITIALIZED;
    int port = -1;
    private HashSet<InetSocketAddress> localAddresses = new HashSet();
    private boolean wildcard;
    private boolean readyToConnect;
    private boolean isShutdown;
    private Association association;
    private Set<SocketAddress> remoteAddresses = Collections.emptySet();
    private InternalNotificationHandler internalNotificationHandler = new InternalNotificationHandler();

    public SctpChannelImpl(SelectorProvider selectorProvider) throws IOException {
        super(selectorProvider);
        this.fd = SctpNet.socket(true);
        this.fdVal = IOUtil.fdVal(this.fd);
        this.state = ChannelState.UNCONNECTED;
    }

    public SctpChannelImpl(SelectorProvider selectorProvider, FileDescriptor fileDescriptor) throws IOException {
        this(selectorProvider, fileDescriptor, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SctpChannelImpl(SelectorProvider selectorProvider, FileDescriptor fileDescriptor, Association association) throws IOException {
        super(selectorProvider);
        this.fd = fileDescriptor;
        this.fdVal = IOUtil.fdVal(fileDescriptor);
        this.state = ChannelState.CONNECTED;
        this.port = Net.localAddress(fileDescriptor).getPort();
        if (association != null) {
            this.association = association;
        } else {
            ByteBuffer byteBuffer = Util.getTemporaryDirectBuffer(50);
            try {
                this.receive(byteBuffer, null, null, true);
            }
            finally {
                Util.releaseTemporaryDirectBuffer(byteBuffer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SctpChannel bind(SocketAddress socketAddress) throws IOException {
        Object object = this.receiveLock;
        synchronized (object) {
            Object object2 = this.sendLock;
            synchronized (object2) {
                Object object3 = this.stateLock;
                synchronized (object3) {
                    this.ensureOpenAndUnconnected();
                    if (this.isBound()) {
                        SctpNet.throwAlreadyBoundException();
                    }
                    InetSocketAddress inetSocketAddress = socketAddress == null ? new InetSocketAddress(0) : Net.checkAddress(socketAddress);
                    SecurityManager securityManager = System.getSecurityManager();
                    if (securityManager != null) {
                        securityManager.checkListen(inetSocketAddress.getPort());
                    }
                    Net.bind(this.fd, inetSocketAddress.getAddress(), inetSocketAddress.getPort());
                    InetSocketAddress inetSocketAddress2 = Net.localAddress(this.fd);
                    this.port = inetSocketAddress2.getPort();
                    this.localAddresses.add(inetSocketAddress);
                    if (inetSocketAddress.getAddress().isAnyLocalAddress()) {
                        this.wildcard = true;
                    }
                }
            }
        }
        return this;
    }

    @Override
    public SctpChannel bindAddress(InetAddress inetAddress) throws IOException {
        this.bindUnbindAddress(inetAddress, true);
        this.localAddresses.add(new InetSocketAddress(inetAddress, this.port));
        return this;
    }

    @Override
    public SctpChannel unbindAddress(InetAddress inetAddress) throws IOException {
        this.bindUnbindAddress(inetAddress, false);
        this.localAddresses.remove(new InetSocketAddress(inetAddress, this.port));
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SctpChannel bindUnbindAddress(InetAddress inetAddress, boolean bl) throws IOException {
        if (inetAddress == null) {
            throw new IllegalArgumentException();
        }
        Object object = this.receiveLock;
        synchronized (object) {
            Object object2 = this.sendLock;
            synchronized (object2) {
                Object object3 = this.stateLock;
                synchronized (object3) {
                    if (!this.isOpen()) {
                        throw new ClosedChannelException();
                    }
                    if (!this.isBound()) {
                        throw new NotYetBoundException();
                    }
                    if (this.wildcard) {
                        throw new IllegalStateException("Cannot add or remove addresses from a channel that is bound to the wildcard address");
                    }
                    if (inetAddress.isAnyLocalAddress()) {
                        throw new IllegalArgumentException("Cannot add or remove the wildcard address");
                    }
                    if (bl) {
                        for (InetSocketAddress object4 : this.localAddresses) {
                            if (!object4.getAddress().equals(inetAddress)) continue;
                            SctpNet.throwAlreadyBoundException();
                        }
                    } else {
                        if (this.localAddresses.size() <= 1) {
                            throw new IllegalUnbindException("Cannot remove address from a channel with only one address bound");
                        }
                        boolean bl2 = false;
                        for (InetSocketAddress inetSocketAddress : this.localAddresses) {
                            if (!inetSocketAddress.getAddress().equals(inetAddress)) continue;
                            bl2 = true;
                            break;
                        }
                        if (!bl2) {
                            throw new IllegalUnbindException("Cannot remove address from a channel that is not bound to that address");
                        }
                    }
                    SctpNet.bindx(this.fdVal, new InetAddress[]{inetAddress}, this.port, bl);
                    if (bl) {
                        this.localAddresses.add(new InetSocketAddress(inetAddress, this.port));
                    } else {
                        for (InetSocketAddress inetSocketAddress : this.localAddresses) {
                            if (!inetSocketAddress.getAddress().equals(inetAddress)) continue;
                            this.localAddresses.remove(inetSocketAddress);
                            break;
                        }
                    }
                }
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isBound() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.port != -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isConnected() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.state == ChannelState.CONNECTED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureOpenAndUnconnected() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            if (this.isConnected()) {
                throw new AlreadyConnectedException();
            }
            if (this.state == ChannelState.PENDING) {
                throw new ConnectionPendingException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean ensureReceiveOpen() throws ClosedChannelException {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            if (!this.isConnected()) {
                throw new NotYetConnectedException();
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureSendOpen() throws ClosedChannelException {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            if (this.isShutdown) {
                throw new ClosedChannelException();
            }
            if (!this.isConnected()) {
                throw new NotYetConnectedException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiverCleanup() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            this.receiverThread = 0L;
            if (this.state == ChannelState.KILLPENDING) {
                this.kill();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void senderCleanup() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            this.senderThread = 0L;
            if (this.state == ChannelState.KILLPENDING) {
                this.kill();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Association association() throws ClosedChannelException {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            if (!this.isConnected()) {
                return null;
            }
            return this.association;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public boolean connect(SocketAddress socketAddress) throws IOException {
        Object object;
        Object object2 = this.receiveLock;
        // MONITORENTER : object2
        Object object3 = this.sendLock;
        // MONITORENTER : object3
        this.ensureOpenAndUnconnected();
        InetSocketAddress inetSocketAddress = Net.checkAddress(socketAddress);
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkConnect(inetSocketAddress.getAddress().getHostAddress(), inetSocketAddress.getPort());
        }
        Object object4 = this.blockingLock();
        // MONITORENTER : object4
        int n = 0;
        try {
            block32: {
                this.begin();
                object = this.stateLock;
                // MONITORENTER : object
                if (this.isOpen()) break block32;
                boolean bl = false;
                // MONITOREXIT : object
                this.receiverCleanup();
                this.end(n > 0 || n == -2);
                assert (IOStatus.check(n));
                // MONITOREXIT : object4
                // MONITOREXIT : object3
                // MONITOREXIT : object2
                return bl;
            }
            try {
                this.receiverThread = NativeThread.current();
                // MONITOREXIT : object
                do {
                    if (!((InetAddress)(object = inetSocketAddress.getAddress())).isAnyLocalAddress()) continue;
                    object = InetAddress.getLocalHost();
                } while ((n = SctpNet.connect(this.fdVal, (InetAddress)object, inetSocketAddress.getPort())) == -3 && this.isOpen());
            }
            catch (Throwable throwable) {
                this.receiverCleanup();
                this.end(n > 0 || n == -2);
                if ($assertionsDisabled) throw throwable;
                if (IOStatus.check(n)) throw throwable;
                throw new AssertionError();
            }
            this.receiverCleanup();
            this.end(n > 0 || n == -2);
            assert (IOStatus.check(n));
        }
        catch (IOException iOException) {
            this.close();
            throw iOException;
        }
        if (n > 0) {
            Object object5;
            object = this.stateLock;
            // MONITORENTER : object
            this.state = ChannelState.CONNECTED;
            if (!this.isBound()) {
                object5 = Net.localAddress(this.fd);
                this.port = ((InetSocketAddress)object5).getPort();
            }
            object5 = Util.getTemporaryDirectBuffer(50);
            try {
                this.receive((ByteBuffer)object5, null, null, true);
            }
            finally {
                Util.releaseTemporaryDirectBuffer((ByteBuffer)object5);
            }
            try {
                this.remoteAddresses = this.getRemoteAddresses();
                return true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return true;
        }
        object = this.stateLock;
        // MONITORENTER : object
        if (!this.isBlocking()) {
            this.state = ChannelState.PENDING;
            return false;
        }
        assert (false);
        // MONITOREXIT : object
        // MONITOREXIT : object4
        // MONITOREXIT : object3
        // MONITOREXIT : object2
        return false;
    }

    @Override
    public boolean connect(SocketAddress socketAddress, int n, int n2) throws IOException {
        this.ensureOpenAndUnconnected();
        return this.setOption(SctpStandardSocketOptions.SCTP_INIT_MAXSTREAMS, SctpStandardSocketOptions.InitMaxStreams.create(n2, n)).connect(socketAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConnectionPending() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.state == ChannelState.PENDING;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public boolean finishConnect() throws IOException {
        Object object;
        Object object2;
        Object object3 = this.receiveLock;
        // MONITORENTER : object3
        Object object4 = this.sendLock;
        // MONITORENTER : object4
        Object object5 = this.stateLock;
        // MONITORENTER : object5
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        if (this.isConnected()) {
            // MONITOREXIT : object5
            // MONITOREXIT : object4
            // MONITOREXIT : object3
            return true;
        }
        if (this.state != ChannelState.PENDING) {
            throw new NoConnectionPendingException();
        }
        // MONITOREXIT : object5
        int n = 0;
        try {
            block44: {
                this.begin();
                object2 = this.blockingLock();
                // MONITORENTER : object2
                object = this.stateLock;
                // MONITORENTER : object
                if (this.isOpen()) break block44;
                boolean bl = false;
                // MONITOREXIT : object
                // MONITOREXIT : object2
                Object object6 = this.stateLock;
                // MONITORENTER : object6
                this.receiverThread = 0L;
                if (this.state == ChannelState.KILLPENDING) {
                    this.kill();
                    n = 0;
                }
                // MONITOREXIT : object6
                this.end(n > 0 || n == -2);
                assert (IOStatus.check(n));
                // MONITOREXIT : object4
                // MONITOREXIT : object3
                return bl;
            }
            try {
                this.receiverThread = NativeThread.current();
                // MONITOREXIT : object
                if (!this.isBlocking()) {
                    while ((n = SctpChannelImpl.checkConnect(this.fd, false, this.readyToConnect)) == -3 && this.isOpen()) {
                    }
                } else {
                    while ((n = SctpChannelImpl.checkConnect(this.fd, true, this.readyToConnect)) == 0 || n == -3 && this.isOpen()) {
                    }
                }
                // MONITOREXIT : object2
                object2 = this.stateLock;
            }
            catch (Throwable throwable) {
                Object object7 = this.stateLock;
                // MONITORENTER : object7
                this.receiverThread = 0L;
                if (this.state == ChannelState.KILLPENDING) {
                    this.kill();
                    n = 0;
                }
                // MONITOREXIT : object7
                this.end(n > 0 || n == -2);
                if ($assertionsDisabled) throw throwable;
                if (IOStatus.check(n)) throw throwable;
                throw new AssertionError();
            }
            this.receiverThread = 0L;
            if (this.state == ChannelState.KILLPENDING) {
                this.kill();
                n = 0;
            }
            // MONITOREXIT : object2
            this.end(n > 0 || n == -2);
            assert (IOStatus.check(n));
        }
        catch (IOException iOException) {
            this.close();
            throw iOException;
        }
        if (n <= 0) {
            // MONITOREXIT : object4
            // MONITOREXIT : object3
            return false;
        }
        object2 = this.stateLock;
        // MONITORENTER : object2
        this.state = ChannelState.CONNECTED;
        if (!this.isBound()) {
            object = Net.localAddress(this.fd);
            this.port = ((InetSocketAddress)object).getPort();
        }
        object = Util.getTemporaryDirectBuffer(50);
        try {
            this.receive((ByteBuffer)object, null, null, true);
        }
        finally {
            Util.releaseTemporaryDirectBuffer((ByteBuffer)object);
        }
        try {
            this.remoteAddresses = this.getRemoteAddresses();
            return true;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    @Override
    protected void implConfigureBlocking(boolean bl) throws IOException {
        IOUtil.configureBlocking(this.fd, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void implCloseSelectableChannel() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            SctpNet.preClose(this.fdVal);
            if (this.receiverThread != 0L) {
                NativeThread.signal(this.receiverThread);
            }
            if (this.senderThread != 0L) {
                NativeThread.signal(this.senderThread);
            }
            if (!this.isRegistered()) {
                this.kill();
            }
        }
    }

    @Override
    public FileDescriptor getFD() {
        return this.fd;
    }

    @Override
    public int getFDVal() {
        return this.fdVal;
    }

    private boolean translateReadyOps(int n, int n2, SelectionKeyImpl selectionKeyImpl) {
        int n3 = selectionKeyImpl.nioInterestOps();
        int n4 = selectionKeyImpl.nioReadyOps();
        int n5 = n2;
        if ((n & Net.POLLNVAL) != 0) {
            return false;
        }
        if ((n & (Net.POLLERR | Net.POLLHUP)) != 0) {
            n5 = n3;
            selectionKeyImpl.nioReadyOps(n5);
            this.readyToConnect = true;
            return (n5 & ~n4) != 0;
        }
        if ((n & Net.POLLIN) != 0 && (n3 & 1) != 0 && this.isConnected()) {
            n5 |= 1;
        }
        if ((n & Net.POLLCONN) != 0 && (n3 & 8) != 0 && (this.state == ChannelState.UNCONNECTED || this.state == ChannelState.PENDING)) {
            n5 |= 8;
            this.readyToConnect = true;
        }
        if ((n & Net.POLLOUT) != 0 && (n3 & 4) != 0 && this.isConnected()) {
            n5 |= 4;
        }
        selectionKeyImpl.nioReadyOps(n5);
        return (n5 & ~n4) != 0;
    }

    @Override
    public boolean translateAndUpdateReadyOps(int n, SelectionKeyImpl selectionKeyImpl) {
        return this.translateReadyOps(n, selectionKeyImpl.nioReadyOps(), selectionKeyImpl);
    }

    @Override
    public boolean translateAndSetReadyOps(int n, SelectionKeyImpl selectionKeyImpl) {
        return this.translateReadyOps(n, 0, selectionKeyImpl);
    }

    @Override
    public void translateAndSetInterestOps(int n, SelectionKeyImpl selectionKeyImpl) {
        int n2 = 0;
        if ((n & 1) != 0) {
            n2 |= Net.POLLIN;
        }
        if ((n & 4) != 0) {
            n2 |= Net.POLLOUT;
        }
        if ((n & 8) != 0) {
            n2 |= Net.POLLCONN;
        }
        selectionKeyImpl.selector.putEventOps(selectionKeyImpl, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void kill() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == ChannelState.KILLED) {
                return;
            }
            if (this.state == ChannelState.UNINITIALIZED) {
                this.state = ChannelState.KILLED;
                return;
            }
            assert (!this.isOpen() && !this.isRegistered());
            if (this.receiverThread == 0L && this.senderThread == 0L) {
                SctpNet.close(this.fdVal);
                this.state = ChannelState.KILLED;
            } else {
                this.state = ChannelState.KILLPENDING;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> SctpChannel setOption(SctpSocketOption<T> sctpSocketOption, T t) throws IOException {
        if (sctpSocketOption == null) {
            throw new NullPointerException();
        }
        if (!this.supportedOptions().contains(sctpSocketOption)) {
            throw new UnsupportedOperationException("'" + sctpSocketOption + "' not supported");
        }
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            SctpNet.setSocketOption(this.fdVal, sctpSocketOption, t, 0);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getOption(SctpSocketOption<T> sctpSocketOption) throws IOException {
        if (sctpSocketOption == null) {
            throw new NullPointerException();
        }
        if (!this.supportedOptions().contains(sctpSocketOption)) {
            throw new UnsupportedOperationException("'" + sctpSocketOption + "' not supported");
        }
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            return (T)SctpNet.getSocketOption(this.fdVal, sctpSocketOption, 0);
        }
    }

    @Override
    public final Set<SctpSocketOption<?>> supportedOptions() {
        return DefaultOptionsHolder.defaultOptions;
    }

    @Override
    public <T> MessageInfo receive(ByteBuffer byteBuffer, T t, NotificationHandler<T> notificationHandler) throws IOException {
        return this.receive(byteBuffer, t, notificationHandler, false);
    }

    /*
     * Exception decompiling
     */
    private <T> MessageInfo receive(ByteBuffer var1_1, T var2_2, NotificationHandler<T> var3_3, boolean var4_4) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 14[MONITOR]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int receive(int n, ByteBuffer byteBuffer, SctpResultContainer sctpResultContainer, boolean bl) throws IOException {
        int n2;
        int n3 = byteBuffer.position();
        int n4 = byteBuffer.limit();
        assert (n3 <= n4);
        int n5 = n2 = n3 <= n4 ? n4 - n3 : 0;
        if (byteBuffer instanceof DirectBuffer && n2 > 0) {
            return this.receiveIntoNativeBuffer(n, sctpResultContainer, byteBuffer, n2, n3, bl);
        }
        int n6 = Math.max(n2, 1);
        ByteBuffer byteBuffer2 = Util.getTemporaryDirectBuffer(n6);
        try {
            int n7 = this.receiveIntoNativeBuffer(n, sctpResultContainer, byteBuffer2, n6, 0, bl);
            byteBuffer2.flip();
            if (n7 > 0 && n2 > 0) {
                byteBuffer.put(byteBuffer2);
            }
            int n8 = n7;
            return n8;
        }
        finally {
            Util.releaseTemporaryDirectBuffer(byteBuffer2);
        }
    }

    private int receiveIntoNativeBuffer(int n, SctpResultContainer sctpResultContainer, ByteBuffer byteBuffer, int n2, int n3, boolean bl) throws IOException {
        int n4 = SctpChannelImpl.receive0(n, sctpResultContainer, ((DirectBuffer)((Object)byteBuffer)).address() + (long)n3, n2, bl);
        if (n4 > 0) {
            byteBuffer.position(n3 + n4);
        }
        return n4;
    }

    private void handleNotificationInternal(SctpResultContainer sctpResultContainer) {
        this.invokeNotificationHandler(sctpResultContainer, this.internalNotificationHandler, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> HandlerResult invokeNotificationHandler(SctpResultContainer sctpResultContainer, NotificationHandler<T> notificationHandler, T t) {
        SctpNotification sctpNotification = sctpResultContainer.notification();
        Object object = this.stateLock;
        synchronized (object) {
            sctpNotification.setAssociation(this.association);
        }
        if (!(notificationHandler instanceof AbstractNotificationHandler)) {
            return notificationHandler.handleNotification(sctpNotification, t);
        }
        object = (AbstractNotificationHandler)notificationHandler;
        switch (sctpResultContainer.type()) {
            case 3: {
                return ((AbstractNotificationHandler)object).handleNotification(sctpResultContainer.getAssociationChanged(), t);
            }
            case 4: {
                return ((AbstractNotificationHandler)object).handleNotification(sctpResultContainer.getPeerAddressChanged(), t);
            }
            case 2: {
                return ((AbstractNotificationHandler)object).handleNotification(sctpResultContainer.getSendFailed(), t);
            }
            case 5: {
                return ((AbstractNotificationHandler)object).handleNotification(sctpResultContainer.getShutdown(), t);
            }
        }
        return ((AbstractNotificationHandler)object).handleNotification(sctpResultContainer.notification(), t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAssociation(Association association) {
        Object object = this.stateLock;
        synchronized (object) {
            if (association != null && !association.equals(this.association)) {
                throw new IllegalArgumentException("Cannot send to another association");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkStreamNumber(int n) {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.association != null && (n < 0 || n >= this.association.maxOutboundStreams())) {
                throw new InvalidStreamException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public int send(ByteBuffer byteBuffer, MessageInfo messageInfo) throws IOException {
        int n;
        int n2;
        block13: {
            if (byteBuffer == null) {
                throw new IllegalArgumentException("buffer cannot be null");
            }
            if (messageInfo == null) {
                throw new IllegalArgumentException("messageInfo cannot be null");
            }
            this.checkAssociation(messageInfo.association());
            this.checkStreamNumber(messageInfo.streamNumber());
            Object object = this.sendLock;
            // MONITORENTER : object
            this.ensureSendOpen();
            n2 = 0;
            this.begin();
            Object object2 = this.stateLock;
            // MONITORENTER : object2
            if (this.isOpen()) break block13;
            int n3 = 0;
            // MONITOREXIT : object2
            this.senderCleanup();
            this.end(n2 > 0 || n2 == -2);
            assert (IOStatus.check(n2));
            // MONITOREXIT : object
            return n3;
        }
        try {
            this.senderThread = NativeThread.current();
            // MONITOREXIT : object2
            while ((n2 = this.send(this.fdVal, byteBuffer, messageInfo)) == -3 && this.isOpen()) {
            }
            n = IOStatus.normalize(n2);
        }
        catch (Throwable throwable) {
            this.senderCleanup();
            this.end(n2 > 0 || n2 == -2);
            if ($assertionsDisabled) throw throwable;
            if (IOStatus.check(n2)) throw throwable;
            throw new AssertionError();
        }
        this.senderCleanup();
        this.end(n2 > 0 || n2 == -2);
        assert (IOStatus.check(n2));
        // MONITOREXIT : object
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int send(int n, ByteBuffer byteBuffer, MessageInfo messageInfo) throws IOException {
        int n2 = messageInfo.streamNumber();
        SocketAddress socketAddress = messageInfo.address();
        boolean bl = messageInfo.isUnordered();
        int n3 = messageInfo.payloadProtocolID();
        if (byteBuffer instanceof DirectBuffer) {
            return this.sendFromNativeBuffer(n, byteBuffer, socketAddress, n2, bl, n3);
        }
        int n4 = byteBuffer.position();
        int n5 = byteBuffer.limit();
        assert (n4 <= n5 && n2 >= 0);
        int n6 = n4 <= n5 ? n5 - n4 : 0;
        ByteBuffer byteBuffer2 = Util.getTemporaryDirectBuffer(n6);
        try {
            byteBuffer2.put(byteBuffer);
            byteBuffer2.flip();
            byteBuffer.position(n4);
            int n7 = this.sendFromNativeBuffer(n, byteBuffer2, socketAddress, n2, bl, n3);
            if (n7 > 0) {
                byteBuffer.position(n4 + n7);
            }
            int n8 = n7;
            return n8;
        }
        finally {
            Util.releaseTemporaryDirectBuffer(byteBuffer2);
        }
    }

    private int sendFromNativeBuffer(int n, ByteBuffer byteBuffer, SocketAddress socketAddress, int n2, boolean bl, int n3) throws IOException {
        InetAddress inetAddress = null;
        int n4 = 0;
        if (socketAddress != null) {
            InetSocketAddress inetSocketAddress = Net.checkAddress(socketAddress);
            inetAddress = inetSocketAddress.getAddress();
            n4 = inetSocketAddress.getPort();
        }
        int n5 = byteBuffer.position();
        int n6 = byteBuffer.limit();
        assert (n5 <= n6);
        int n7 = n5 <= n6 ? n6 - n5 : 0;
        int n8 = SctpChannelImpl.send0(n, ((DirectBuffer)((Object)byteBuffer)).address() + (long)n5, n7, inetAddress, n4, -1, n2, bl, n3);
        if (n8 > 0) {
            byteBuffer.position(n5 + n8);
        }
        return n8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SctpChannel shutdown() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.isShutdown) {
                return this;
            }
            this.ensureSendOpen();
            SctpNet.shutdown(this.fdVal, -1);
            if (this.senderThread != 0L) {
                NativeThread.signal(this.senderThread);
            }
            this.isShutdown = true;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<SocketAddress> getAllLocalAddresses() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            if (!this.isBound()) {
                return Collections.emptySet();
            }
            return SctpNet.getLocalAddresses(this.fdVal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<SocketAddress> getRemoteAddresses() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            if (!this.isConnected() || this.isShutdown) {
                return Collections.emptySet();
            }
            try {
                return SctpNet.getRemoteAddresses(this.fdVal, 0);
            }
            catch (SocketException socketException) {
                return this.remoteAddresses;
            }
        }
    }

    private static native void initIDs();

    static native int receive0(int var0, SctpResultContainer var1, long var2, int var4, boolean var5) throws IOException;

    static native int send0(int var0, long var1, int var3, InetAddress var4, int var5, int var6, int var7, boolean var8, int var9) throws IOException;

    private static native int checkConnect(FileDescriptor var0, boolean var1, boolean var2) throws IOException;

    static {
        IOUtil.load();
        AccessController.doPrivileged(new LoadLibraryAction("sctp"));
        SctpChannelImpl.initIDs();
    }

    private class InternalNotificationHandler
    extends AbstractNotificationHandler<Object> {
        private InternalNotificationHandler() {
        }

        @Override
        public HandlerResult handleNotification(AssociationChangeNotification associationChangeNotification, Object object) {
            if (associationChangeNotification.event().equals((Object)AssociationChangeNotification.AssocChangeEvent.COMM_UP) && SctpChannelImpl.this.association == null) {
                SctpAssocChange sctpAssocChange = (SctpAssocChange)associationChangeNotification;
                SctpChannelImpl.this.association = new SctpAssociationImpl(sctpAssocChange.assocId(), sctpAssocChange.maxInStreams(), sctpAssocChange.maxOutStreams());
            }
            return HandlerResult.CONTINUE;
        }
    }

    private static class DefaultOptionsHolder {
        static final Set<SctpSocketOption<?>> defaultOptions = DefaultOptionsHolder.defaultOptions();

        private DefaultOptionsHolder() {
        }

        private static Set<SctpSocketOption<?>> defaultOptions() {
            HashSet<SctpSocketOption<Object>> hashSet = new HashSet<SctpSocketOption<Object>>(10);
            hashSet.add(SctpStandardSocketOptions.SCTP_DISABLE_FRAGMENTS);
            hashSet.add(SctpStandardSocketOptions.SCTP_EXPLICIT_COMPLETE);
            hashSet.add(SctpStandardSocketOptions.SCTP_FRAGMENT_INTERLEAVE);
            hashSet.add(SctpStandardSocketOptions.SCTP_INIT_MAXSTREAMS);
            hashSet.add(SctpStandardSocketOptions.SCTP_NODELAY);
            hashSet.add(SctpStandardSocketOptions.SCTP_PRIMARY_ADDR);
            hashSet.add(SctpStandardSocketOptions.SCTP_SET_PEER_PRIMARY_ADDR);
            hashSet.add(SctpStandardSocketOptions.SO_SNDBUF);
            hashSet.add(SctpStandardSocketOptions.SO_RCVBUF);
            hashSet.add(SctpStandardSocketOptions.SO_LINGER);
            return Collections.unmodifiableSet(hashSet);
        }
    }

    private static enum ChannelState {
        UNINITIALIZED,
        UNCONNECTED,
        PENDING,
        CONNECTED,
        KILLPENDING,
        KILLED;

    }
}

