/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal;

import java.io.IOException;
import sun.security.krb5.Credentials;
import sun.security.krb5.KrbException;
import sun.security.krb5.KrbTgsReq;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.Realm;
import sun.security.krb5.internal.Krb5;
import sun.security.krb5.internal.KrbApErrException;

public class CredentialsUtil {
    private static boolean DEBUG = Krb5.DEBUG;

    public static Credentials acquireServiceCreds(String string, Credentials credentials) throws KrbException, IOException {
        PrincipalName principalName = new PrincipalName(string);
        String string2 = principalName.getRealmString();
        String string3 = credentials.getClient().getRealmString();
        if (string3.equals(string2)) {
            if (DEBUG) {
                System.out.println(">>> Credentials acquireServiceCreds: same realm");
            }
            return CredentialsUtil.serviceCreds(principalName, credentials);
        }
        String[] stringArray = Realm.getRealmsList(string3, string2);
        boolean bl = true;
        if (stringArray == null || stringArray.length == 0) {
            if (DEBUG) {
                System.out.println(">>> Credentials acquireServiceCreds: no realms list");
            }
            return null;
        }
        int n = 0;
        int n2 = 0;
        Credentials credentials2 = null;
        Credentials credentials3 = null;
        Credentials credentials4 = null;
        PrincipalName principalName2 = null;
        Object var13_13 = null;
        String string4 = null;
        String string5 = null;
        credentials2 = credentials;
        n = 0;
        while (n < stringArray.length) {
            principalName2 = PrincipalName.tgsService(string2, stringArray[n]);
            if (DEBUG) {
                System.out.println(">>> Credentials acquireServiceCreds: main loop: [" + n + "] tempService=" + principalName2);
            }
            try {
                credentials3 = CredentialsUtil.serviceCreds(principalName2, credentials2);
            }
            catch (Exception exception) {
                credentials3 = null;
            }
            if (credentials3 == null) {
                if (DEBUG) {
                    System.out.println(">>> Credentials acquireServiceCreds: no tgt; searching backwards");
                }
                credentials3 = null;
                for (n2 = n + 1; credentials3 == null && n2 < stringArray.length; ++n2) {
                    principalName2 = PrincipalName.tgsService(stringArray[n2], stringArray[n]);
                    if (DEBUG) {
                        System.out.println(">>> Credentials acquireServiceCreds: inner loop: [" + n2 + "] tempService=" + principalName2);
                    }
                    try {
                        credentials3 = CredentialsUtil.serviceCreds(principalName2, credentials2);
                        continue;
                    }
                    catch (Exception exception) {
                        credentials3 = null;
                    }
                }
            }
            if (credentials3 == null) {
                if (!DEBUG) break;
                System.out.println(">>> Credentials acquireServiceCreds: no tgt; cannot get creds");
                break;
            }
            string4 = credentials3.getServer().getInstanceComponent();
            if (bl && !credentials3.checkDelegate()) {
                if (DEBUG) {
                    System.out.println(">>> Credentials acquireServiceCreds: global OK-AS-DELEGATE turned off at " + credentials3.getServer());
                }
                bl = false;
            }
            if (DEBUG) {
                System.out.println(">>> Credentials acquireServiceCreds: got tgt");
            }
            if (string4.equals(string2)) {
                credentials4 = credentials3;
                string5 = string4;
                break;
            }
            for (n2 = n + 1; n2 < stringArray.length && !string4.equals(stringArray[n2]); ++n2) {
            }
            if (n2 >= stringArray.length) break;
            n = n2;
            credentials2 = credentials3;
            if (!DEBUG) continue;
            System.out.println(">>> Credentials acquireServiceCreds: continuing with main loop counter reset to " + n);
        }
        Credentials credentials5 = null;
        if (credentials4 != null) {
            if (DEBUG) {
                System.out.println(">>> Credentials acquireServiceCreds: got right tgt");
                System.out.println(">>> Credentials acquireServiceCreds: obtaining service creds for " + principalName);
            }
            try {
                credentials5 = CredentialsUtil.serviceCreds(principalName, credentials4);
            }
            catch (Exception exception) {
                if (DEBUG) {
                    System.out.println(exception);
                }
                credentials5 = null;
            }
        }
        if (credentials5 != null) {
            if (DEBUG) {
                System.out.println(">>> Credentials acquireServiceCreds: returning creds:");
                Credentials.printDebug(credentials5);
            }
            if (!bl) {
                credentials5.resetDelegate();
            }
            return credentials5;
        }
        throw new KrbApErrException(63, "No service creds");
    }

    private static Credentials serviceCreds(PrincipalName principalName, Credentials credentials) throws KrbException, IOException {
        return new KrbTgsReq(credentials, principalName).sendAndGetCreds();
    }
}

