/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal.rcache;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import sun.security.krb5.internal.KerberosTime;
import sun.security.krb5.internal.Krb5;
import sun.security.krb5.internal.KrbApErrException;
import sun.security.krb5.internal.ReplayCache;
import sun.security.krb5.internal.rcache.AuthList;
import sun.security.krb5.internal.rcache.AuthTimeWithHash;

public class MemoryCache
extends ReplayCache {
    private static final int lifespan = KerberosTime.getDefaultSkew();
    private static final boolean DEBUG = Krb5.DEBUG;
    private final ConcurrentMap<String, AuthList> content = new ConcurrentHashMap<String, AuthList>();

    @Override
    public synchronized void checkAndStore(KerberosTime kerberosTime, AuthTimeWithHash authTimeWithHash) throws KrbApErrException {
        AuthList authList;
        String string = authTimeWithHash.client + "|" + authTimeWithHash.server;
        AuthList authList2 = this.content.putIfAbsent(string, authList = new AuthList(lifespan));
        if (authList2 == null) {
            authList2 = authList;
        }
        authList2.put(authTimeWithHash, kerberosTime);
        if (DEBUG) {
            System.out.println("MemoryCache: add " + authTimeWithHash + " to " + string);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (AuthList authList : this.content.values()) {
            stringBuilder.append(authList.toString());
        }
        return stringBuilder.toString();
    }
}

