/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.cert.CRLException;
import java.security.cert.CRLSelector;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.CertStoreParameters;
import java.security.cert.CertStoreSpi;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLSelector;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import sun.security.action.GetIntegerAction;
import sun.security.provider.certpath.CertStoreHelper;
import sun.security.provider.certpath.PKIX;
import sun.security.util.Cache;
import sun.security.util.Debug;
import sun.security.x509.AccessDescription;
import sun.security.x509.GeneralNameInterface;
import sun.security.x509.URIName;

class URICertStore
extends CertStoreSpi {
    private static final Debug debug = Debug.getInstance("certpath");
    private static final int CHECK_INTERVAL = 30000;
    private static final int CACHE_SIZE = 185;
    private final CertificateFactory factory;
    private Collection<X509Certificate> certs = Collections.emptySet();
    private X509CRL crl;
    private long lastChecked;
    private long lastModified;
    private URI uri;
    private boolean ldap = false;
    private CertStoreHelper ldapHelper;
    private CertStore ldapCertStore;
    private String ldapPath;
    private static final int DEFAULT_CRL_CONNECT_TIMEOUT = 15000;
    private static final int CRL_CONNECT_TIMEOUT = URICertStore.initializeTimeout();
    private static final Cache certStoreCache = Cache.newSoftMemoryCache(185);

    private static int initializeTimeout() {
        Integer n = AccessController.doPrivileged(new GetIntegerAction("com.sun.security.crl.timeout"));
        if (n == null || n < 0) {
            return 15000;
        }
        return n * 1000;
    }

    URICertStore(CertStoreParameters certStoreParameters) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        super(certStoreParameters);
        if (!(certStoreParameters instanceof URICertStoreParameters)) {
            throw new InvalidAlgorithmParameterException("params must be instanceof URICertStoreParameters");
        }
        this.uri = ((URICertStoreParameters)certStoreParameters).uri;
        if (this.uri.getScheme().toLowerCase(Locale.ENGLISH).equals("ldap")) {
            this.ldap = true;
            this.ldapHelper = CertStoreHelper.getInstance("LDAP");
            this.ldapCertStore = this.ldapHelper.getCertStore(this.uri);
            this.ldapPath = this.uri.getPath();
            if (this.ldapPath.charAt(0) == '/') {
                this.ldapPath = this.ldapPath.substring(1);
            }
        }
        try {
            this.factory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException certificateException) {
            throw new RuntimeException();
        }
    }

    static synchronized CertStore getInstance(URICertStoreParameters uRICertStoreParameters) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        CertStore certStore;
        if (debug != null) {
            debug.println("CertStore URI:" + uRICertStoreParameters.uri);
        }
        if ((certStore = (CertStore)certStoreCache.get(uRICertStoreParameters)) == null) {
            certStore = new UCS(new URICertStore(uRICertStoreParameters), null, "URI", uRICertStoreParameters);
            certStoreCache.put(uRICertStoreParameters, certStore);
        } else if (debug != null) {
            debug.println("URICertStore.getInstance: cache hit");
        }
        return certStore;
    }

    static CertStore getInstance(AccessDescription accessDescription) {
        if (!accessDescription.getAccessMethod().equals((Object)AccessDescription.Ad_CAISSUERS_Id)) {
            return null;
        }
        GeneralNameInterface generalNameInterface = accessDescription.getAccessLocation().getName();
        if (!(generalNameInterface instanceof URIName)) {
            return null;
        }
        URI uRI = ((URIName)generalNameInterface).getURI();
        try {
            return URICertStore.getInstance(new URICertStoreParameters(uRI));
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.println("exception creating CertStore: " + exception);
                exception.printStackTrace();
            }
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized Collection<X509Certificate> engineGetCertificates(CertSelector certSelector) throws CertStoreException {
        if (this.ldap) {
            X509CertSelector x509CertSelector = (X509CertSelector)certSelector;
            try {
                x509CertSelector = this.ldapHelper.wrap(x509CertSelector, x509CertSelector.getSubject(), this.ldapPath);
                return this.ldapCertStore.getCertificates(x509CertSelector);
            }
            catch (IOException iOException) {
                throw new CertStoreException(iOException);
            }
        }
        long l = System.currentTimeMillis();
        if (l - this.lastChecked < 30000L) {
            if (debug == null) return URICertStore.getMatchingCerts(this.certs, certSelector);
            debug.println("Returning certificates from cache");
            return URICertStore.getMatchingCerts(this.certs, certSelector);
        }
        this.lastChecked = l;
        try {
            URLConnection uRLConnection = this.uri.toURL().openConnection();
            if (this.lastModified != 0L) {
                uRLConnection.setIfModifiedSince(this.lastModified);
            }
            long l2 = this.lastModified;
            try (InputStream inputStream = uRLConnection.getInputStream();){
                this.lastModified = uRLConnection.getLastModified();
                if (l2 != 0L) {
                    HttpURLConnection httpURLConnection;
                    if (l2 == this.lastModified) {
                        if (debug != null) {
                            debug.println("Not modified, using cached copy");
                        }
                        Collection<X509Certificate> collection = URICertStore.getMatchingCerts(this.certs, certSelector);
                        return collection;
                    }
                    if (uRLConnection instanceof HttpURLConnection && (httpURLConnection = (HttpURLConnection)uRLConnection).getResponseCode() == 304) {
                        if (debug != null) {
                            debug.println("Not modified, using cached copy");
                        }
                        Collection<X509Certificate> collection = URICertStore.getMatchingCerts(this.certs, certSelector);
                        return collection;
                    }
                }
                if (debug != null) {
                    debug.println("Downloading new certificates...");
                }
                this.certs = this.factory.generateCertificates(inputStream);
                return URICertStore.getMatchingCerts(this.certs, certSelector);
            }
        }
        catch (IOException | CertificateException exception) {
            if (debug != null) {
                debug.println("Exception fetching certificates:");
                exception.printStackTrace();
            }
            this.lastModified = 0L;
            this.certs = Collections.emptySet();
            return this.certs;
        }
    }

    private static Collection<X509Certificate> getMatchingCerts(Collection<X509Certificate> collection, CertSelector certSelector) {
        if (certSelector == null) {
            return collection;
        }
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>(collection.size());
        for (X509Certificate x509Certificate : collection) {
            if (!certSelector.match(x509Certificate)) continue;
            arrayList.add(x509Certificate);
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized Collection<X509CRL> engineGetCRLs(CRLSelector cRLSelector) throws CertStoreException {
        if (this.ldap) {
            X509CRLSelector x509CRLSelector = (X509CRLSelector)cRLSelector;
            try {
                x509CRLSelector = this.ldapHelper.wrap(x509CRLSelector, null, this.ldapPath);
            }
            catch (IOException iOException) {
                throw new CertStoreException(iOException);
            }
            try {
                return this.ldapCertStore.getCRLs(x509CRLSelector);
            }
            catch (CertStoreException certStoreException) {
                throw new PKIX.CertStoreTypeException("LDAP", certStoreException);
            }
        }
        long l = System.currentTimeMillis();
        if (l - this.lastChecked < 30000L) {
            if (debug == null) return URICertStore.getMatchingCRLs(this.crl, cRLSelector);
            debug.println("Returning CRL from cache");
            return URICertStore.getMatchingCRLs(this.crl, cRLSelector);
        }
        this.lastChecked = l;
        try {
            URLConnection uRLConnection = this.uri.toURL().openConnection();
            if (this.lastModified != 0L) {
                uRLConnection.setIfModifiedSince(this.lastModified);
            }
            long l2 = this.lastModified;
            uRLConnection.setConnectTimeout(CRL_CONNECT_TIMEOUT);
            try (InputStream inputStream = uRLConnection.getInputStream();){
                this.lastModified = uRLConnection.getLastModified();
                if (l2 != 0L) {
                    HttpURLConnection httpURLConnection;
                    if (l2 == this.lastModified) {
                        if (debug != null) {
                            debug.println("Not modified, using cached copy");
                        }
                        Collection<X509CRL> collection = URICertStore.getMatchingCRLs(this.crl, cRLSelector);
                        return collection;
                    }
                    if (uRLConnection instanceof HttpURLConnection && (httpURLConnection = (HttpURLConnection)uRLConnection).getResponseCode() == 304) {
                        if (debug != null) {
                            debug.println("Not modified, using cached copy");
                        }
                        Collection<X509CRL> collection = URICertStore.getMatchingCRLs(this.crl, cRLSelector);
                        return collection;
                    }
                }
                if (debug != null) {
                    debug.println("Downloading new CRL...");
                }
                this.crl = (X509CRL)this.factory.generateCRL(inputStream);
                return URICertStore.getMatchingCRLs(this.crl, cRLSelector);
            }
        }
        catch (IOException | CRLException exception) {
            if (debug != null) {
                debug.println("Exception fetching CRL:");
                exception.printStackTrace();
            }
            this.lastModified = 0L;
            this.crl = null;
            throw new PKIX.CertStoreTypeException("URI", new CertStoreException(exception));
        }
    }

    private static Collection<X509CRL> getMatchingCRLs(X509CRL x509CRL, CRLSelector cRLSelector) {
        if (cRLSelector == null || x509CRL != null && cRLSelector.match(x509CRL)) {
            return Collections.singletonList(x509CRL);
        }
        return Collections.emptyList();
    }

    private static class UCS
    extends CertStore {
        protected UCS(CertStoreSpi certStoreSpi, Provider provider, String string, CertStoreParameters certStoreParameters) {
            super(certStoreSpi, provider, string, certStoreParameters);
        }
    }

    static class URICertStoreParameters
    implements CertStoreParameters {
        private final URI uri;
        private volatile int hashCode = 0;

        URICertStoreParameters(URI uRI) {
            this.uri = uRI;
        }

        public boolean equals(Object object) {
            if (!(object instanceof URICertStoreParameters)) {
                return false;
            }
            URICertStoreParameters uRICertStoreParameters = (URICertStoreParameters)object;
            return this.uri.equals(uRICertStoreParameters.uri);
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                int n = 17;
                this.hashCode = n = 37 * n + this.uri.hashCode();
            }
            return this.hashCode;
        }

        @Override
        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new InternalError(cloneNotSupportedException.toString());
            }
        }
    }
}

