/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.security.ProviderException;
import java.util.List;
import sun.security.util.BiFunction;
import sun.security.util.Function;
import sun.security.util.Preconditions;

public final class ArrayUtil {
    private static final Function<String, ArrayIndexOutOfBoundsException> aioobeGenerator = new Function<String, ArrayIndexOutOfBoundsException>(){

        @Override
        public ArrayIndexOutOfBoundsException apply(String string) {
            return new ArrayIndexOutOfBoundsException(string);
        }
    };
    private static final BiFunction<String, List<Integer>, ArrayIndexOutOfBoundsException> AIOOBE_SUPPLIER = Preconditions.outOfBoundsExceptionFormatter(aioobeGenerator);

    public static void blockSizeCheck(int n, int n2) {
        if (n % n2 != 0) {
            throw new ProviderException("Internal error in input buffering");
        }
    }

    public static void nullAndBoundsCheck(byte[] byArray, int n, int n2) {
        Preconditions.checkFromIndexSize(n, n2, byArray.length, AIOOBE_SUPPLIER);
    }

    private static void swap(byte[] byArray, int n, int n2) {
        byte by = byArray[n];
        byArray[n] = byArray[n2];
        byArray[n2] = by;
    }

    public static void reverse(byte[] byArray) {
        int n = 0;
        for (int i = byArray.length - 1; n < i; ++n, --i) {
            ArrayUtil.swap(byArray, n, i);
        }
    }
}

