/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Date;
import sun.security.util.BitArray;
import sun.util.calendar.CalendarDate;
import sun.util.calendar.CalendarSystem;
import sun.util.calendar.Gregorian;

class DerInputBuffer
extends ByteArrayInputStream
implements Cloneable {
    boolean allowBER = true;

    DerInputBuffer(byte[] byArray) {
        this(byArray, true);
    }

    DerInputBuffer(byte[] byArray, boolean bl) {
        super(byArray);
        this.allowBER = bl;
    }

    DerInputBuffer(byte[] byArray, int n, int n2, boolean bl) {
        super(byArray, n, n2);
        this.allowBER = bl;
    }

    DerInputBuffer dup() {
        try {
            DerInputBuffer derInputBuffer = (DerInputBuffer)this.clone();
            derInputBuffer.mark(Integer.MAX_VALUE);
            return derInputBuffer;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalArgumentException(cloneNotSupportedException.toString());
        }
    }

    byte[] toByteArray() {
        int n = this.available();
        if (n <= 0) {
            return null;
        }
        byte[] byArray = new byte[n];
        System.arraycopy(this.buf, this.pos, byArray, 0, n);
        return byArray;
    }

    int peek() throws IOException {
        if (this.pos >= this.count) {
            throw new IOException("out of data");
        }
        return this.buf[this.pos];
    }

    public boolean equals(Object object) {
        if (object instanceof DerInputBuffer) {
            return this.equals((DerInputBuffer)object);
        }
        return false;
    }

    boolean equals(DerInputBuffer derInputBuffer) {
        if (this == derInputBuffer) {
            return true;
        }
        int n = this.available();
        if (derInputBuffer.available() != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (this.buf[this.pos + i] == derInputBuffer.buf[derInputBuffer.pos + i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 0;
        int n2 = this.available();
        int n3 = this.pos;
        for (int i = 0; i < n2; ++i) {
            n += this.buf[n3 + i] * i;
        }
        return n;
    }

    void truncate(int n) throws IOException {
        if (n > this.available()) {
            throw new IOException("insufficient data");
        }
        this.count = this.pos + n;
    }

    BigInteger getBigInteger(int n, boolean bl) throws IOException {
        if (n > this.available()) {
            throw new IOException("short read of integer");
        }
        if (n == 0) {
            throw new IOException("Invalid encoding: zero length Int value");
        }
        byte[] byArray = new byte[n];
        System.arraycopy(this.buf, this.pos, byArray, 0, n);
        this.skip(n);
        if (!this.allowBER && n >= 2 && byArray[0] == 0 && byArray[1] >= 0) {
            throw new IOException("Invalid encoding: redundant leading 0s");
        }
        if (bl) {
            return new BigInteger(1, byArray);
        }
        return new BigInteger(byArray);
    }

    public int getInteger(int n) throws IOException {
        BigInteger bigInteger = this.getBigInteger(n, false);
        if (bigInteger.compareTo(BigInteger.valueOf(Integer.MIN_VALUE)) < 0) {
            throw new IOException("Integer below minimum valid value");
        }
        if (bigInteger.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) > 0) {
            throw new IOException("Integer exceeds maximum valid value");
        }
        return bigInteger.intValue();
    }

    private static int checkPaddedBits(int n, byte[] byArray, int n2, int n3, boolean bl) throws IOException {
        if (n < 0 || n > 7) {
            throw new IOException("Invalid number of padding bits");
        }
        int n4 = (n3 - n2 << 3) - n;
        if (n4 < 0) {
            throw new IOException("Not enough bytes in BitString");
        }
        if (!bl && n != 0 && (byArray[n3 - 1] & 255 >>> 8 - n) != 0) {
            throw new IOException("Invalid value of padding bits");
        }
        return n4;
    }

    public byte[] getBitString(int n) throws IOException {
        if (n > this.available()) {
            throw new IOException("short read of bit string");
        }
        if (n == 0) {
            throw new IOException("Invalid encoding: zero length bit string");
        }
        int n2 = this.pos;
        int n3 = n2 + n;
        this.skip(n);
        byte by = this.buf[n2++];
        DerInputBuffer.checkPaddedBits(by, this.buf, n2, n3, this.allowBER);
        byte[] byArray = new byte[n - 1];
        System.arraycopy(this.buf, n2, byArray, 0, n - 1);
        if (this.allowBER && by != 0) {
            int n4 = byArray.length - 1;
            byArray[n4] = (byte)(byArray[n4] & 255 << by);
        }
        return byArray;
    }

    byte[] getBitString() throws IOException {
        return this.getBitString(this.available());
    }

    BitArray getUnalignedBitString() throws IOException {
        return this.getUnalignedBitString(this.available());
    }

    BitArray getUnalignedBitString(int n) throws IOException {
        if (this.pos >= this.count) {
            return null;
        }
        int n2 = this.pos;
        int n3 = n2 + n;
        this.pos = this.count;
        byte by = this.buf[n2++];
        int n4 = DerInputBuffer.checkPaddedBits(by, this.buf, n2, n3, this.allowBER);
        return new BitArray(n4, this.buf, n2);
    }

    public Date getUTCTime(int n) throws IOException {
        if (n > this.available()) {
            throw new IOException("short read of DER UTC Time");
        }
        if (n < 11 || n > 17) {
            throw new IOException("DER UTC Time length error");
        }
        return this.getTime(n, false);
    }

    public Date getGeneralizedTime(int n) throws IOException {
        if (n > this.available()) {
            throw new IOException("short read of DER Generalized Time");
        }
        if (n < 13) {
            throw new IOException("DER Generalized Time length error");
        }
        return this.getTime(n, true);
    }

    private Date getTime(int n, boolean bl) throws IOException {
        int n2;
        int n3;
        String string = null;
        if (bl) {
            string = "Generalized";
            n3 = 1000 * DerInputBuffer.toDigit(this.buf[this.pos++], string);
            n3 += 100 * DerInputBuffer.toDigit(this.buf[this.pos++], string);
            n3 += 10 * DerInputBuffer.toDigit(this.buf[this.pos++], string);
            n3 += DerInputBuffer.toDigit(this.buf[this.pos++], string);
            n -= 2;
        } else {
            string = "UTC";
            n3 = 10 * DerInputBuffer.toDigit(this.buf[this.pos++], string);
            n3 = (n3 += DerInputBuffer.toDigit(this.buf[this.pos++], string)) < 50 ? (n3 += 2000) : (n3 += 1900);
        }
        int n4 = 10 * DerInputBuffer.toDigit(this.buf[this.pos++], string);
        n4 += DerInputBuffer.toDigit(this.buf[this.pos++], string);
        int n5 = 10 * DerInputBuffer.toDigit(this.buf[this.pos++], string);
        n5 += DerInputBuffer.toDigit(this.buf[this.pos++], string);
        int n6 = 10 * DerInputBuffer.toDigit(this.buf[this.pos++], string);
        n6 += DerInputBuffer.toDigit(this.buf[this.pos++], string);
        int n7 = 10 * DerInputBuffer.toDigit(this.buf[this.pos++], string);
        n7 += DerInputBuffer.toDigit(this.buf[this.pos++], string);
        int n8 = 0;
        if ((n -= 10) > 2) {
            n2 = 10 * DerInputBuffer.toDigit(this.buf[this.pos++], string);
            n2 += DerInputBuffer.toDigit(this.buf[this.pos++], string);
            n -= 2;
            if (bl && (this.buf[this.pos] == 46 || this.buf[this.pos] == 44)) {
                if (--n == 0) {
                    throw new IOException("Parse " + string + " time, empty fractional part");
                }
                ++this.pos;
                int n9 = 0;
                while (this.buf[this.pos] != 90 && this.buf[this.pos] != 43 && this.buf[this.pos] != 45) {
                    int n10 = DerInputBuffer.toDigit(this.buf[this.pos], string);
                    ++n9;
                    if (--n == 0) {
                        throw new IOException("Parse " + string + " time, invalid fractional part");
                    }
                    ++this.pos;
                    switch (n9) {
                        case 1: {
                            n8 += 100 * n10;
                            break;
                        }
                        case 2: {
                            n8 += 10 * n10;
                            break;
                        }
                        case 3: {
                            n8 += n10;
                        }
                    }
                }
                if (n9 == 0) {
                    throw new IOException("Parse " + string + " time, empty fractional part");
                }
            }
        } else {
            n2 = 0;
        }
        if (n4 == 0 || n5 == 0 || n4 > 12 || n5 > 31 || n6 >= 24 || n7 >= 60 || n2 >= 60) {
            throw new IOException("Parse " + string + " time, invalid format");
        }
        Gregorian gregorian = CalendarSystem.getGregorianCalendar();
        CalendarDate calendarDate = ((CalendarSystem)gregorian).newCalendarDate(null);
        calendarDate.setDate(n3, n4, n5);
        calendarDate.setTimeOfDay(n6, n7, n2, n8);
        long l = ((CalendarSystem)gregorian).getTime(calendarDate);
        if (n != 1 && n != 5) {
            throw new IOException("Parse " + string + " time, invalid offset");
        }
        switch (this.buf[this.pos++]) {
            case 43: {
                if (n != 5) {
                    throw new IOException("Parse " + string + " time, invalid offset");
                }
                int n11 = 10 * DerInputBuffer.toDigit(this.buf[this.pos++], string);
                int n12 = 10 * DerInputBuffer.toDigit(this.buf[this.pos++], string);
                if ((n11 += DerInputBuffer.toDigit(this.buf[this.pos++], string)) >= 24 || (n12 += DerInputBuffer.toDigit(this.buf[this.pos++], string)) >= 60) {
                    throw new IOException("Parse " + string + " time, +hhmm");
                }
                l -= (long)((n11 * 60 + n12) * 60 * 1000);
                break;
            }
            case 45: {
                if (n != 5) {
                    throw new IOException("Parse " + string + " time, invalid offset");
                }
                int n13 = 10 * DerInputBuffer.toDigit(this.buf[this.pos++], string);
                int n14 = 10 * DerInputBuffer.toDigit(this.buf[this.pos++], string);
                if ((n13 += DerInputBuffer.toDigit(this.buf[this.pos++], string)) >= 24 || (n14 += DerInputBuffer.toDigit(this.buf[this.pos++], string)) >= 60) {
                    throw new IOException("Parse " + string + " time, -hhmm");
                }
                l += (long)((n13 * 60 + n14) * 60 * 1000);
                break;
            }
            case 90: {
                if (n == 1) break;
                throw new IOException("Parse " + string + " time, invalid format");
            }
            default: {
                throw new IOException("Parse " + string + " time, garbage offset");
            }
        }
        return new Date(l);
    }

    private static int toDigit(byte by, String string) throws IOException {
        if (by < 48 || by > 57) {
            throw new IOException("Parse " + string + " time, invalid format");
        }
        return by - 48;
    }
}

