/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.Date;
import java.util.Vector;
import sun.security.util.BitArray;
import sun.security.util.DerIndefLenConverter;
import sun.security.util.DerInputBuffer;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;

public class DerInputStream {
    DerInputBuffer buffer;
    public byte tag;

    public DerInputStream(byte[] byArray) throws IOException {
        this.init(byArray, 0, byArray.length, true);
    }

    public DerInputStream(byte[] byArray, int n, int n2, boolean bl) throws IOException {
        this.init(byArray, n, n2, bl);
    }

    public DerInputStream(byte[] byArray, int n, int n2) throws IOException {
        this.init(byArray, n, n2, true);
    }

    private void init(byte[] byArray, int n, int n2, boolean bl) throws IOException {
        if (n + 2 > byArray.length || n + n2 > byArray.length) {
            throw new IOException("Encoding bytes too short");
        }
        if (DerIndefLenConverter.isIndefinite(byArray[n + 1])) {
            if (!bl) {
                throw new IOException("Indefinite length BER encoding found");
            }
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, n, byArray2, 0, n2);
            DerIndefLenConverter derIndefLenConverter = new DerIndefLenConverter();
            byte[] byArray3 = derIndefLenConverter.convertBytes(byArray2);
            if (byArray3 == null) {
                throw new IOException("not all indef len BER resolved");
            }
            this.buffer = new DerInputBuffer(byArray3, bl);
        } else {
            this.buffer = new DerInputBuffer(byArray, n, n2, bl);
        }
        this.buffer.mark(Integer.MAX_VALUE);
    }

    DerInputStream(DerInputBuffer derInputBuffer) {
        this.buffer = derInputBuffer;
        this.buffer.mark(Integer.MAX_VALUE);
    }

    public DerInputStream subStream(int n, boolean bl) throws IOException {
        DerInputBuffer derInputBuffer = this.buffer.dup();
        derInputBuffer.truncate(n);
        if (bl) {
            this.buffer.skip(n);
        }
        return new DerInputStream(derInputBuffer);
    }

    public byte[] toByteArray() {
        return this.buffer.toByteArray();
    }

    public int getInteger() throws IOException {
        if (this.buffer.read() != 2) {
            throw new IOException("DER input, Integer tag error");
        }
        return this.buffer.getInteger(DerInputStream.getDefiniteLength(this.buffer));
    }

    public BigInteger getBigInteger() throws IOException {
        if (this.buffer.read() != 2) {
            throw new IOException("DER input, Integer tag error");
        }
        return this.buffer.getBigInteger(DerInputStream.getDefiniteLength(this.buffer), false);
    }

    public BigInteger getPositiveBigInteger() throws IOException {
        if (this.buffer.read() != 2) {
            throw new IOException("DER input, Integer tag error");
        }
        return this.buffer.getBigInteger(DerInputStream.getDefiniteLength(this.buffer), true);
    }

    public int getEnumerated() throws IOException {
        if (this.buffer.read() != 10) {
            throw new IOException("DER input, Enumerated tag error");
        }
        return this.buffer.getInteger(DerInputStream.getDefiniteLength(this.buffer));
    }

    public byte[] getBitString() throws IOException {
        if (this.buffer.read() != 3) {
            throw new IOException("DER input not an bit string");
        }
        return this.buffer.getBitString(DerInputStream.getDefiniteLength(this.buffer));
    }

    public BitArray getUnalignedBitString() throws IOException {
        if (this.buffer.read() != 3) {
            throw new IOException("DER input not a bit string");
        }
        return this.buffer.getUnalignedBitString(DerInputStream.getDefiniteLength(this.buffer));
    }

    public byte[] getOctetString() throws IOException {
        if (this.buffer.read() != 4) {
            throw new IOException("DER input not an octet string");
        }
        int n = DerInputStream.getDefiniteLength(this.buffer);
        byte[] byArray = new byte[n];
        if (n != 0 && this.buffer.read(byArray) != n) {
            throw new IOException("Short read of DER octet string");
        }
        return byArray;
    }

    public void getBytes(byte[] byArray) throws IOException {
        if (byArray.length != 0 && this.buffer.read(byArray) != byArray.length) {
            throw new IOException("Short read of DER octet string");
        }
    }

    public void getNull() throws IOException {
        if (this.buffer.read() != 5 || this.buffer.read() != 0) {
            throw new IOException("getNull, bad data");
        }
    }

    public ObjectIdentifier getOID() throws IOException {
        return new ObjectIdentifier(this);
    }

    public DerValue[] getSequence(int n) throws IOException {
        this.tag = (byte)this.buffer.read();
        if (this.tag != 48) {
            throw new IOException("Sequence tag error");
        }
        return this.readVector(n);
    }

    public DerValue[] getSet(int n) throws IOException {
        this.tag = (byte)this.buffer.read();
        if (this.tag != 49) {
            throw new IOException("Set tag error");
        }
        return this.readVector(n);
    }

    public DerValue[] getSet(int n, boolean bl) throws IOException {
        this.tag = (byte)this.buffer.read();
        if (!bl && this.tag != 49) {
            throw new IOException("Set tag error");
        }
        return this.readVector(n);
    }

    protected DerValue[] readVector(int n) throws IOException {
        byte by = (byte)this.buffer.read();
        int n2 = DerInputStream.getLength(by, this.buffer);
        if (n2 == -1) {
            this.buffer = new DerInputBuffer(DerIndefLenConverter.convertStream(this.buffer, by, this.tag), this.buffer.allowBER);
            if (this.tag != this.buffer.read()) {
                throw new IOException("Indefinite length encoding not supported");
            }
            n2 = DerInputStream.getDefiniteLength(this.buffer);
        }
        if (n2 == 0) {
            return new DerValue[0];
        }
        DerInputStream derInputStream = this.buffer.available() == n2 ? this : this.subStream(n2, true);
        Vector<DerValue> vector = new Vector<DerValue>(n);
        do {
            DerValue derValue = new DerValue(derInputStream.buffer, this.buffer.allowBER);
            vector.addElement(derValue);
        } while (derInputStream.available() > 0);
        if (derInputStream.available() != 0) {
            throw new IOException("Extra data at end of vector");
        }
        int n3 = vector.size();
        DerValue[] derValueArray = new DerValue[n3];
        for (int i = 0; i < n3; ++i) {
            derValueArray[i] = (DerValue)vector.elementAt(i);
        }
        return derValueArray;
    }

    public DerValue getDerValue() throws IOException {
        return new DerValue(this.buffer);
    }

    public String getUTF8String() throws IOException {
        return this.readString((byte)12, "UTF-8", "UTF8");
    }

    public String getPrintableString() throws IOException {
        return this.readString((byte)19, "Printable", "ASCII");
    }

    public String getT61String() throws IOException {
        return this.readString((byte)20, "T61", "ISO-8859-1");
    }

    public String getIA5String() throws IOException {
        return this.readString((byte)22, "IA5", "ASCII");
    }

    public String getBMPString() throws IOException {
        return this.readString((byte)30, "BMP", "UnicodeBigUnmarked");
    }

    public String getGeneralString() throws IOException {
        return this.readString((byte)27, "General", "ASCII");
    }

    private String readString(byte by, String string, String string2) throws IOException {
        if (this.buffer.read() != by) {
            throw new IOException("DER input not a " + string + " string");
        }
        int n = DerInputStream.getDefiniteLength(this.buffer);
        byte[] byArray = new byte[n];
        if (n != 0 && this.buffer.read(byArray) != n) {
            throw new IOException("Short read of DER " + string + " string");
        }
        return new String(byArray, string2);
    }

    public Date getUTCTime() throws IOException {
        if (this.buffer.read() != 23) {
            throw new IOException("DER input, UTCtime tag invalid ");
        }
        return this.buffer.getUTCTime(DerInputStream.getDefiniteLength(this.buffer));
    }

    public Date getGeneralizedTime() throws IOException {
        if (this.buffer.read() != 24) {
            throw new IOException("DER input, GeneralizedTime tag invalid ");
        }
        return this.buffer.getGeneralizedTime(DerInputStream.getDefiniteLength(this.buffer));
    }

    int getByte() throws IOException {
        return 0xFF & this.buffer.read();
    }

    public int peekByte() throws IOException {
        return this.buffer.peek();
    }

    int getLength() throws IOException {
        return DerInputStream.getLength(this.buffer);
    }

    static int getLength(InputStream inputStream) throws IOException {
        return DerInputStream.getLength(inputStream.read(), inputStream);
    }

    static int getLength(int n, InputStream inputStream) throws IOException {
        int n2;
        if (n == -1) {
            throw new IOException("Short read of DER length");
        }
        String string = "DerInputStream.getLength(): ";
        int n3 = n;
        if ((n3 & 0x80) == 0) {
            n2 = n3;
        } else {
            if ((n3 &= 0x7F) == 0) {
                return -1;
            }
            if (n3 < 0 || n3 > 4) {
                throw new IOException(string + "lengthTag=" + n3 + ", " + (n3 < 0 ? "incorrect DER encoding." : "too big."));
            }
            n2 = 0xFF & inputStream.read();
            --n3;
            if (n2 == 0) {
                throw new IOException(string + "Redundant length bytes found");
            }
            while (n3-- > 0) {
                n2 <<= 8;
                n2 += 0xFF & inputStream.read();
            }
            if (n2 < 0) {
                throw new IOException(string + "Invalid length bytes");
            }
            if (n2 <= 127) {
                throw new IOException(string + "Should use short form for length");
            }
        }
        return n2;
    }

    int getDefiniteLength() throws IOException {
        return DerInputStream.getDefiniteLength(this.buffer);
    }

    static int getDefiniteLength(InputStream inputStream) throws IOException {
        int n = DerInputStream.getLength(inputStream);
        if (n < 0) {
            throw new IOException("Indefinite length encoding not supported");
        }
        return n;
    }

    public void mark(int n) {
        this.buffer.mark(n);
    }

    public void reset() {
        this.buffer.reset();
    }

    public int available() {
        return this.buffer.available();
    }
}

