/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.AlgorithmParameters;
import java.security.CryptoPrimitive;
import java.security.Key;
import java.security.cert.CertPathValidatorException;
import java.security.interfaces.ECKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sun.misc.JavaUtilCalendarAccess;
import sun.misc.SharedSecrets;
import sun.security.util.AbstractAlgorithmConstraints;
import sun.security.util.AlgorithmDecomposer;
import sun.security.util.ConstraintsParameters;
import sun.security.util.CurveDB;
import sun.security.util.Debug;
import sun.security.util.KeyUtil;
import sun.security.util.NamedCurve;

public class DisabledAlgorithmConstraints
extends AbstractAlgorithmConstraints {
    private static final Debug debug = Debug.getInstance("certpath");
    public static final String PROPERTY_CERTPATH_DISABLED_ALGS = "jdk.certpath.disabledAlgorithms";
    public static final String PROPERTY_TLS_DISABLED_ALGS = "jdk.tls.disabledAlgorithms";
    public static final String PROPERTY_JAR_DISABLED_ALGS = "jdk.jar.disabledAlgorithms";
    private static final String PROPERTY_DISABLED_EC_CURVES = "jdk.disabled.namedCurves";
    private final List<String> disabledAlgorithms;
    private final Constraints algorithmConstraints;

    public static DisabledAlgorithmConstraints certPathConstraints() {
        return CertPathHolder.CONSTRAINTS;
    }

    public static DisabledAlgorithmConstraints jarConstraints() {
        return JarHolder.CONSTRAINTS;
    }

    public DisabledAlgorithmConstraints(String string) {
        this(string, new AlgorithmDecomposer());
    }

    public DisabledAlgorithmConstraints(String string, AlgorithmDecomposer algorithmDecomposer) {
        super(algorithmDecomposer);
        this.disabledAlgorithms = DisabledAlgorithmConstraints.getAlgorithms(string);
        int n = -1;
        int n2 = 0;
        for (String string2 : this.disabledAlgorithms) {
            if (string2.regionMatches(true, 0, "include ", 0, 8) && string2.regionMatches(true, 8, PROPERTY_DISABLED_EC_CURVES, 0, PROPERTY_DISABLED_EC_CURVES.length())) {
                n = n2;
                break;
            }
            ++n2;
        }
        if (n > -1) {
            this.disabledAlgorithms.remove(n);
            this.disabledAlgorithms.addAll(n, DisabledAlgorithmConstraints.getAlgorithms(PROPERTY_DISABLED_EC_CURVES));
        }
        this.algorithmConstraints = new Constraints(string, this.disabledAlgorithms);
    }

    @Override
    public final boolean permits(Set<CryptoPrimitive> set, String string, AlgorithmParameters algorithmParameters) {
        if (!DisabledAlgorithmConstraints.checkAlgorithm(this.disabledAlgorithms, string, this.decomposer)) {
            return false;
        }
        if (algorithmParameters != null) {
            return this.algorithmConstraints.permits(string, algorithmParameters);
        }
        return true;
    }

    @Override
    public final boolean permits(Set<CryptoPrimitive> set, Key key) {
        return this.checkConstraints(set, "", key, null);
    }

    @Override
    public final boolean permits(Set<CryptoPrimitive> set, String string, Key key, AlgorithmParameters algorithmParameters) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("No algorithm name specified");
        }
        return this.checkConstraints(set, string, key, algorithmParameters);
    }

    public final void permits(String string, AlgorithmParameters algorithmParameters, ConstraintsParameters constraintsParameters) throws CertPathValidatorException {
        this.permits(string, constraintsParameters);
        if (algorithmParameters != null) {
            this.permits(algorithmParameters, constraintsParameters);
        }
    }

    private void permits(AlgorithmParameters algorithmParameters, ConstraintsParameters constraintsParameters) throws CertPathValidatorException {
        switch (algorithmParameters.getAlgorithm().toUpperCase(Locale.ENGLISH)) {
            case "RSASSA-PSS": {
                this.permitsPSSParams(algorithmParameters, constraintsParameters);
                break;
            }
        }
    }

    private void permitsPSSParams(AlgorithmParameters algorithmParameters, ConstraintsParameters constraintsParameters) throws CertPathValidatorException {
        try {
            String string;
            PSSParameterSpec pSSParameterSpec = algorithmParameters.getParameterSpec(PSSParameterSpec.class);
            String string2 = pSSParameterSpec.getDigestAlgorithm();
            this.permits(string2, constraintsParameters);
            AlgorithmParameterSpec algorithmParameterSpec = pSSParameterSpec.getMGFParameters();
            if (algorithmParameterSpec instanceof MGF1ParameterSpec && !(string = ((MGF1ParameterSpec)algorithmParameterSpec).getDigestAlgorithm()).equalsIgnoreCase(string2)) {
                this.permits(string, constraintsParameters);
            }
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            // empty catch block
        }
    }

    public final void permits(String string, ConstraintsParameters constraintsParameters) throws CertPathValidatorException {
        for (Key key : constraintsParameters.getKeys()) {
            for (String string2 : DisabledAlgorithmConstraints.getNamedCurveFromKey(key)) {
                if (DisabledAlgorithmConstraints.checkAlgorithm(this.disabledAlgorithms, string2, this.decomposer)) continue;
                throw new CertPathValidatorException("Algorithm constraints check failed on disabled algorithm: " + string2, null, null, -1, CertPathValidatorException.BasicReason.ALGORITHM_CONSTRAINED);
            }
        }
        this.algorithmConstraints.permits(string, constraintsParameters);
    }

    private static List<String> getNamedCurveFromKey(Key key) {
        if (key instanceof ECKey) {
            NamedCurve namedCurve = CurveDB.lookup(((ECKey)((Object)key)).getParams());
            return namedCurve == null ? Collections.emptyList() : Arrays.asList(CurveDB.getNamesByOID(namedCurve.getObjectId()));
        }
        return Collections.emptyList();
    }

    private boolean checkConstraints(Set<CryptoPrimitive> set, String string, Key key, AlgorithmParameters algorithmParameters) {
        if (key == null) {
            throw new IllegalArgumentException("The key cannot be null");
        }
        if (string != null && string.length() != 0 && !this.permits(set, string, algorithmParameters)) {
            return false;
        }
        if (!this.permits(set, key.getAlgorithm(), null)) {
            return false;
        }
        for (String string2 : DisabledAlgorithmConstraints.getNamedCurveFromKey(key)) {
            if (this.permits(set, string2, null)) continue;
            return false;
        }
        return this.algorithmConstraints.permits(key);
    }

    private static class AvailableCalendarTypes {
        private static final Set<String> SET;

        private AvailableCalendarTypes() {
        }

        static {
            HashSet<String> hashSet = new HashSet<String>(3);
            hashSet.add("gregory");
            hashSet.add("buddhist");
            hashSet.add("japanese");
            SET = Collections.unmodifiableSet(hashSet);
        }
    }

    private static class CalendarBuilder {
        private static final int NFIELDS = 18;
        private static final int WEEK_YEAR = 17;
        private static final int UNSET = 0;
        private static final int COMPUTED = 1;
        private static final int MINIMUM_USER_STAMP = 2;
        private long instant;
        private int[] fields;
        private int nextStamp;
        private int maxFieldIndex;
        private String type;
        private TimeZone zone;
        private boolean lenient = true;
        private Locale locale;
        private int firstDayOfWeek;
        private int minimalDaysInFirstWeek;

        public CalendarBuilder setInstant(long l) {
            if (this.fields != null) {
                throw new IllegalStateException();
            }
            this.instant = l;
            this.nextStamp = 1;
            return this;
        }

        public CalendarBuilder setInstant(Date date) {
            return this.setInstant(date.getTime());
        }

        public CalendarBuilder set(int n, int n2) {
            if (n < 0 || n >= 17) {
                throw new IllegalArgumentException("field is invalid");
            }
            if (this.isInstantSet()) {
                throw new IllegalStateException("instant has been set");
            }
            this.allocateFields();
            this.internalSet(n, n2);
            return this;
        }

        public CalendarBuilder setFields(int ... nArray) {
            int n = nArray.length;
            if (n % 2 != 0) {
                throw new IllegalArgumentException();
            }
            if (this.isInstantSet()) {
                throw new IllegalStateException("instant has been set");
            }
            if (this.nextStamp + n / 2 < 0) {
                throw new IllegalStateException("stamp counter overflow");
            }
            this.allocateFields();
            int n2 = 0;
            while (n2 < n) {
                int n3;
                if ((n3 = nArray[n2++]) < 0 || n3 >= 17) {
                    throw new IllegalArgumentException("field is invalid");
                }
                this.internalSet(n3, nArray[n2++]);
            }
            return this;
        }

        public CalendarBuilder setDate(int n, int n2, int n3) {
            return this.setFields(1, n, 2, n2, 5, n3);
        }

        public CalendarBuilder setTimeOfDay(int n, int n2, int n3) {
            return this.setTimeOfDay(n, n2, n3, 0);
        }

        public CalendarBuilder setTimeOfDay(int n, int n2, int n3, int n4) {
            return this.setFields(11, n, 12, n2, 13, n3, 14, n4);
        }

        public CalendarBuilder setWeekDate(int n, int n2, int n3) {
            this.allocateFields();
            this.internalSet(17, n);
            this.internalSet(3, n2);
            this.internalSet(7, n3);
            return this;
        }

        public CalendarBuilder setTimeZone(TimeZone timeZone) {
            if (timeZone == null) {
                throw new NullPointerException();
            }
            this.zone = timeZone;
            return this;
        }

        public CalendarBuilder setLenient(boolean bl) {
            this.lenient = bl;
            return this;
        }

        public CalendarBuilder setCalendarType(String string) {
            if (string.equals("gregorian")) {
                string = "gregory";
            }
            if (!AvailableCalendarTypes.SET.contains(string) && !string.equals("iso8601")) {
                throw new IllegalArgumentException("unknown calendar type: " + string);
            }
            if (this.type == null) {
                this.type = string;
            } else if (!this.type.equals(string)) {
                throw new IllegalStateException("calendar type override");
            }
            return this;
        }

        public CalendarBuilder setLocale(Locale locale) {
            if (locale == null) {
                throw new NullPointerException();
            }
            this.locale = locale;
            return this;
        }

        public CalendarBuilder setWeekDefinition(int n, int n2) {
            if (!this.isValidWeekParameter(n) || !this.isValidWeekParameter(n2)) {
                throw new IllegalArgumentException();
            }
            this.firstDayOfWeek = n;
            this.minimalDaysInFirstWeek = n2;
            return this;
        }

        public Calendar build() {
            GregorianCalendar gregorianCalendar;
            if (this.locale == null) {
                this.locale = Locale.getDefault();
            }
            if (this.zone == null) {
                this.zone = TimeZone.getDefault();
            }
            JavaUtilCalendarAccess javaUtilCalendarAccess = SharedSecrets.getJavaUtilCalendarAccess();
            if (this.type == null) {
                this.type = this.locale.getUnicodeLocaleType("ca");
            }
            if (this.type == null) {
                this.type = this.locale.getCountry() == "TH" && this.locale.getLanguage() == "th" ? "buddhist" : "gregory";
            }
            String string = this.type;
            int n = -1;
            switch (string.hashCode()) {
                case 283776265: {
                    if (!string.equals("gregory")) break;
                    n = 0;
                    break;
                }
                case 2095190916: {
                    if (!string.equals("iso8601")) break;
                    n = 1;
                }
            }
            switch (n) {
                case 0: {
                    gregorianCalendar = javaUtilCalendarAccess.createCalendar(this.zone, this.locale);
                    break;
                }
                case 1: {
                    GregorianCalendar gregorianCalendar2 = javaUtilCalendarAccess.createCalendar(this.zone, this.locale);
                    gregorianCalendar2.setGregorianChange(new Date(Long.MIN_VALUE));
                    this.setWeekDefinition(2, 4);
                    gregorianCalendar = gregorianCalendar2;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown calendar type: " + this.type);
                }
            }
            gregorianCalendar.setLenient(this.lenient);
            if (this.firstDayOfWeek != 0) {
                gregorianCalendar.setFirstDayOfWeek(this.firstDayOfWeek);
                gregorianCalendar.setMinimalDaysInFirstWeek(this.minimalDaysInFirstWeek);
            }
            if (this.isInstantSet()) {
                gregorianCalendar.setTimeInMillis(this.instant);
                javaUtilCalendarAccess.complete(gregorianCalendar);
                return gregorianCalendar;
            }
            if (this.fields != null) {
                boolean bl;
                boolean bl2 = bl = this.isSet(17) && this.fields[17] > this.fields[1];
                if (bl && !((Calendar)gregorianCalendar).isWeekDateSupported()) {
                    throw new IllegalArgumentException("week date is unsupported by " + this.type);
                }
                block8: for (n = 2; n < this.nextStamp; ++n) {
                    for (int i = 0; i <= this.maxFieldIndex; ++i) {
                        if (this.fields[i] != n) continue;
                        gregorianCalendar.set(i, this.fields[18 + i]);
                        continue block8;
                    }
                }
                if (bl) {
                    n = this.isSet(3) ? this.fields[21] : 1;
                    int n2 = this.isSet(7) ? this.fields[25] : gregorianCalendar.getFirstDayOfWeek();
                    ((Calendar)gregorianCalendar).setWeekDate(this.fields[35], n, n2);
                }
                javaUtilCalendarAccess.complete(gregorianCalendar);
            }
            return gregorianCalendar;
        }

        private void allocateFields() {
            if (this.fields == null) {
                this.fields = new int[36];
                this.nextStamp = 2;
                this.maxFieldIndex = -1;
            }
        }

        private void internalSet(int n, int n2) {
            ++this.nextStamp;
            if (this.nextStamp < 0) {
                throw new IllegalStateException("stamp counter overflow");
            }
            this.fields[18 + n] = n2;
            if (n > this.maxFieldIndex && n < 17) {
                this.maxFieldIndex = n;
            }
        }

        private boolean isInstantSet() {
            return this.nextStamp == 1;
        }

        private boolean isSet(int n) {
            return this.fields != null && this.fields[n] > 0;
        }

        private boolean isValidWeekParameter(int n) {
            return n > 0 && n <= 7;
        }
    }

    private static class DisabledConstraint
    extends Constraint {
        DisabledConstraint(String string) {
            this.algorithm = string;
        }

        @Override
        public void permits(ConstraintsParameters constraintsParameters) throws CertPathValidatorException {
            throw new CertPathValidatorException("Algorithm constraints check failed on disabled algorithm: " + this.algorithm + constraintsParameters.extendedExceptionMsg(), null, null, -1, CertPathValidatorException.BasicReason.ALGORITHM_CONSTRAINED);
        }

        @Override
        public boolean permits(Key key) {
            return false;
        }
    }

    private static class KeySizeConstraint
    extends Constraint {
        private int minSize;
        private int maxSize;
        private int prohibitedSize = -1;

        public KeySizeConstraint(String string, Constraint.Operator operator, int n) {
            this.algorithm = string;
            switch (operator) {
                case EQ: {
                    this.minSize = 0;
                    this.maxSize = Integer.MAX_VALUE;
                    this.prohibitedSize = n;
                    break;
                }
                case NE: {
                    this.minSize = n;
                    this.maxSize = n;
                    break;
                }
                case LT: {
                    this.minSize = n;
                    this.maxSize = Integer.MAX_VALUE;
                    break;
                }
                case LE: {
                    this.minSize = n + 1;
                    this.maxSize = Integer.MAX_VALUE;
                    break;
                }
                case GT: {
                    this.minSize = 0;
                    this.maxSize = n;
                    break;
                }
                case GE: {
                    this.minSize = 0;
                    this.maxSize = n > 1 ? n - 1 : 0;
                    break;
                }
                default: {
                    this.minSize = Integer.MAX_VALUE;
                    this.maxSize = -1;
                }
            }
        }

        @Override
        public void permits(ConstraintsParameters constraintsParameters) throws CertPathValidatorException {
            for (Key key : constraintsParameters.getKeys()) {
                if (this.permitsImpl(key)) continue;
                if (this.nextConstraint != null) {
                    this.nextConstraint.permits(constraintsParameters);
                    continue;
                }
                throw new CertPathValidatorException("Algorithm constraints check failed on keysize limits: " + this.algorithm + " " + KeyUtil.getKeySize(key) + " bit key" + constraintsParameters.extendedExceptionMsg(), null, null, -1, CertPathValidatorException.BasicReason.ALGORITHM_CONSTRAINED);
            }
        }

        @Override
        public boolean permits(Key key) {
            if (this.nextConstraint != null && this.nextConstraint.permits(key)) {
                return true;
            }
            if (debug != null) {
                debug.println("KeySizeConstraints.permits(): " + this.algorithm);
            }
            return this.permitsImpl(key);
        }

        @Override
        public boolean permits(AlgorithmParameters algorithmParameters) {
            Collection<String> collection;
            String string = algorithmParameters.getAlgorithm();
            if (!this.algorithm.equalsIgnoreCase(algorithmParameters.getAlgorithm()) && !(collection = AlgorithmDecomposer.getAliases(this.algorithm)).contains(string)) {
                return true;
            }
            int n = KeyUtil.getKeySize(algorithmParameters);
            if (n == 0) {
                return false;
            }
            if (n > 0) {
                return n >= this.minSize && n <= this.maxSize && this.prohibitedSize != n;
            }
            return true;
        }

        private boolean permitsImpl(Key key) {
            if (this.algorithm.compareToIgnoreCase(key.getAlgorithm()) != 0) {
                return true;
            }
            int n = KeyUtil.getKeySize(key);
            if (n == 0) {
                return false;
            }
            if (n > 0) {
                return n >= this.minSize && n <= this.maxSize && this.prohibitedSize != n;
            }
            return true;
        }
    }

    private static class UsageConstraint
    extends Constraint {
        String[] usages;

        UsageConstraint(String string, String[] stringArray) {
            this.algorithm = string;
            this.usages = stringArray;
        }

        @Override
        public void permits(ConstraintsParameters constraintsParameters) throws CertPathValidatorException {
            String string = constraintsParameters.getVariant();
            for (String string2 : this.usages) {
                boolean bl = false;
                switch (string2.toLowerCase()) {
                    case "tlsserver": {
                        bl = string.equals("tls server");
                        break;
                    }
                    case "tlsclient": {
                        bl = string.equals("tls client");
                        break;
                    }
                    case "signedjar": {
                        boolean bl2 = bl = string.equals("plugin code signing") || string.equals("code signing") || string.equals("tsa server");
                    }
                }
                if (debug != null) {
                    debug.println("Checking if usage constraint \"" + string2 + "\" matches \"" + constraintsParameters.getVariant() + "\"");
                    Object object = new ByteArrayOutputStream();
                    PrintStream printStream = new PrintStream((OutputStream)object);
                    new Exception().printStackTrace(printStream);
                    debug.println(((ByteArrayOutputStream)object).toString());
                }
                if (!bl) continue;
                if (this.next(constraintsParameters)) {
                    return;
                }
                throw new CertPathValidatorException("Usage constraint " + string2 + " check failed: " + this.algorithm + constraintsParameters.extendedExceptionMsg(), null, null, -1, CertPathValidatorException.BasicReason.ALGORITHM_CONSTRAINED);
            }
        }
    }

    private static class DenyAfterConstraint
    extends Constraint {
        private Date denyAfterDate;
        private static final SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, MMM d HH:mm:ss z yyyy");

        DenyAfterConstraint(String string, int n, int n2, int n3) {
            Calendar calendar;
            this.algorithm = string;
            if (debug != null) {
                debug.println("DenyAfterConstraint read in as:  year " + n + ", month = " + n2 + ", day = " + n3);
            }
            if (n > (calendar = new CalendarBuilder().setTimeZone(TimeZone.getTimeZone("GMT")).setDate(n, n2 - 1, n3).build()).getActualMaximum(1) || n < calendar.getActualMinimum(1)) {
                throw new IllegalArgumentException("Invalid year given in constraint: " + n);
            }
            if (n2 - 1 > calendar.getActualMaximum(2) || n2 - 1 < calendar.getActualMinimum(2)) {
                throw new IllegalArgumentException("Invalid month given in constraint: " + n2);
            }
            if (n3 > calendar.getActualMaximum(5) || n3 < calendar.getActualMinimum(5)) {
                throw new IllegalArgumentException("Invalid Day of Month given in constraint: " + n3);
            }
            this.denyAfterDate = calendar.getTime();
            if (debug != null) {
                debug.println("DenyAfterConstraint date set to: " + dateFormat.format(this.denyAfterDate));
            }
        }

        @Override
        public void permits(ConstraintsParameters constraintsParameters) throws CertPathValidatorException {
            Date date = constraintsParameters.getDate() != null ? constraintsParameters.getDate() : new Date();
            if (!this.denyAfterDate.after(date)) {
                if (this.next(constraintsParameters)) {
                    return;
                }
                throw new CertPathValidatorException("denyAfter constraint check failed: " + this.algorithm + " used with Constraint date: " + dateFormat.format(this.denyAfterDate) + "; params date: " + dateFormat.format(date) + constraintsParameters.extendedExceptionMsg(), null, null, -1, CertPathValidatorException.BasicReason.ALGORITHM_CONSTRAINED);
            }
        }

        @Override
        public boolean permits(Key key) {
            if (this.next(key)) {
                return true;
            }
            if (debug != null) {
                debug.println("DenyAfterConstraints.permits(): " + this.algorithm);
            }
            return this.denyAfterDate.after(new Date());
        }
    }

    private static class jdkCAConstraint
    extends Constraint {
        jdkCAConstraint(String string) {
            this.algorithm = string;
        }

        @Override
        public void permits(ConstraintsParameters constraintsParameters) throws CertPathValidatorException {
            if (debug != null) {
                debug.println("jdkCAConstraints.permits(): " + this.algorithm);
            }
            if (constraintsParameters.anchorIsJdkCA()) {
                if (this.next(constraintsParameters)) {
                    return;
                }
                throw new CertPathValidatorException("Algorithm constraints check failed on certificate anchor limits. " + this.algorithm + constraintsParameters.extendedExceptionMsg(), null, null, -1, CertPathValidatorException.BasicReason.ALGORITHM_CONSTRAINED);
            }
        }
    }

    private static abstract class Constraint {
        String algorithm;
        Constraint nextConstraint = null;

        private Constraint() {
        }

        public boolean permits(Key key) {
            return true;
        }

        public boolean permits(AlgorithmParameters algorithmParameters) {
            return true;
        }

        public abstract void permits(ConstraintsParameters var1) throws CertPathValidatorException;

        boolean next(ConstraintsParameters constraintsParameters) throws CertPathValidatorException {
            if (this.nextConstraint != null) {
                this.nextConstraint.permits(constraintsParameters);
                return true;
            }
            return false;
        }

        boolean next(Key key) {
            return this.nextConstraint != null && this.nextConstraint.permits(key);
        }

        static enum Operator {
            EQ,
            NE,
            LT,
            LE,
            GT,
            GE;


            static Operator of(String string) {
                switch (string) {
                    case "==": {
                        return EQ;
                    }
                    case "!=": {
                        return NE;
                    }
                    case "<": {
                        return LT;
                    }
                    case "<=": {
                        return LE;
                    }
                    case ">": {
                        return GT;
                    }
                    case ">=": {
                        return GE;
                    }
                }
                throw new IllegalArgumentException("Error in security property. " + string + " is not a legal Operator");
            }
        }
    }

    private static class Constraints {
        private Map<String, List<Constraint>> constraintsMap = new HashMap<String, List<Constraint>>();

        /*
         * WARNING - void declaration
         */
        public Constraints(String string, List<String> list) {
            for (String string2 : list) {
                List<Constraint> list2;
                int n;
                String string3;
                List<Constraint> list3;
                if (string2 == null || string2.isEmpty()) continue;
                string2 = string2.trim();
                if (debug != null) {
                    debug.println("Constraints: " + string2);
                }
                if ((list3 = this.constraintsMap.get((string3 = AlgorithmDecomposer.hashName((n = string2.indexOf(32)) > 0 ? string2.substring(0, n) : string2)).toUpperCase(Locale.ENGLISH))) == null) {
                    list3 = new ArrayList<Constraint>(1);
                }
                for (String string4 : AlgorithmDecomposer.getAliases(string3)) {
                    list2 = this.constraintsMap.get(string4);
                    if (list2 != null) continue;
                    this.constraintsMap.put(string4.toUpperCase(Locale.ENGLISH), list3);
                }
                if (n <= 0 || CurveDB.lookup(string2) != null) {
                    list3.add(new DisabledConstraint(string3));
                    continue;
                }
                String string4 = string2.substring(n + 1);
                list2 = null;
                boolean bl = false;
                boolean bl2 = false;
                for (String string5 : string4.split("&")) {
                    void var9_15;
                    Matcher matcher;
                    String[] stringArray;
                    if ((string5 = string5.trim()).startsWith("keySize")) {
                        if (debug != null) {
                            debug.println("Constraints set to keySize: " + string5);
                        }
                        if (!"keySize".equals((stringArray = new StringTokenizer(string5)).nextToken())) {
                            throw new IllegalArgumentException("Error in security property. Constraint unknown: " + string5);
                        }
                        KeySizeConstraint keySizeConstraint = new KeySizeConstraint(string3, Constraint.Operator.of(stringArray.nextToken()), Integer.parseInt(stringArray.nextToken()));
                    } else if (string5.equalsIgnoreCase("jdkCA")) {
                        if (debug != null) {
                            debug.println("Constraints set to jdkCA.");
                        }
                        if (bl) {
                            throw new IllegalArgumentException("Only one jdkCA entry allowed in property. Constraint: " + string2);
                        }
                        jdkCAConstraint jdkCAConstraint2 = new jdkCAConstraint(string3);
                        bl = true;
                    } else if (string5.startsWith("denyAfter") && (matcher = Holder.DENY_AFTER_PATTERN.matcher(string5)).matches()) {
                        if (debug != null) {
                            debug.println("Constraints set to denyAfter");
                        }
                        if (bl2) {
                            throw new IllegalArgumentException("Only one denyAfter entry allowed in property. Constraint: " + string2);
                        }
                        int n2 = Integer.parseInt(matcher.group(1));
                        int n3 = Integer.parseInt(matcher.group(2));
                        int n4 = Integer.parseInt(matcher.group(3));
                        DenyAfterConstraint denyAfterConstraint = new DenyAfterConstraint(string3, n2, n3, n4);
                        bl2 = true;
                    } else if (string5.startsWith("usage")) {
                        stringArray = string5.substring(5).trim().split(" ");
                        UsageConstraint usageConstraint = new UsageConstraint(string3, stringArray);
                        if (debug != null) {
                            debug.println("Constraints usage length is " + stringArray.length);
                        }
                    } else {
                        throw new IllegalArgumentException("Error in security property. Constraint unknown: " + string5);
                    }
                    if (list2 == null) {
                        list3.add((Constraint)var9_15);
                    } else {
                        ((Constraint)((Object)list2)).nextConstraint = var9_15;
                    }
                    list2 = var9_15;
                }
            }
        }

        private List<Constraint> getConstraints(String string) {
            return this.constraintsMap.get(string.toUpperCase(Locale.ENGLISH));
        }

        public boolean permits(Key key) {
            List<Constraint> list = this.getConstraints(key.getAlgorithm());
            if (list == null) {
                return true;
            }
            for (Constraint constraint : list) {
                if (constraint.permits(key)) continue;
                if (debug != null) {
                    debug.println("Constraints: failed key sizeconstraint check " + KeyUtil.getKeySize(key));
                }
                return false;
            }
            return true;
        }

        public boolean permits(String string, AlgorithmParameters algorithmParameters) {
            List<Constraint> list = this.getConstraints(string);
            if (list == null) {
                return true;
            }
            for (Constraint constraint : list) {
                if (constraint.permits(algorithmParameters)) continue;
                if (debug != null) {
                    debug.println("Constraints: failed algorithm parameters constraint check " + algorithmParameters);
                }
                return false;
            }
            return true;
        }

        public void permits(String string, ConstraintsParameters constraintsParameters) throws CertPathValidatorException {
            if (debug != null) {
                debug.println("Constraints.permits(): " + string + ", " + constraintsParameters.toString());
            }
            HashSet<String> hashSet = new HashSet<String>();
            if (string != null) {
                hashSet.addAll(AlgorithmDecomposer.decomposeOneHash(string));
                hashSet.add(string);
            }
            for (Key object : constraintsParameters.getKeys()) {
                hashSet.add(object.getAlgorithm());
            }
            for (String string2 : hashSet) {
                List<Constraint> list = this.getConstraints(string2);
                if (list == null) continue;
                for (Constraint constraint : list) {
                    constraint.permits(constraintsParameters);
                }
            }
        }

        private static class Holder {
            private static final Pattern DENY_AFTER_PATTERN = Pattern.compile("denyAfter\\s+(\\d{4})-(\\d{2})-(\\d{2})");

            private Holder() {
            }
        }
    }

    private static class JarHolder {
        static final DisabledAlgorithmConstraints CONSTRAINTS = new DisabledAlgorithmConstraints("jdk.jar.disabledAlgorithms");

        private JarHolder() {
        }
    }

    private static class CertPathHolder {
        static final DisabledAlgorithmConstraints CONSTRAINTS = new DisabledAlgorithmConstraints("jdk.certpath.disabledAlgorithms");

        private CertPathHolder() {
        }
    }
}

