/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import sun.security.util.Cache;

class MemoryCache
extends Cache {
    private static final float LOAD_FACTOR = 0.75f;
    private static final boolean DEBUG = false;
    private final Map<Object, CacheEntry> cacheMap;
    private int maxSize;
    private long lifetime;
    private final ReferenceQueue<Object> queue;

    public MemoryCache(boolean bl, int n) {
        this(bl, n, 0);
    }

    public MemoryCache(boolean bl, int n, int n2) {
        this.maxSize = n;
        this.lifetime = n2 * 1000;
        this.queue = bl ? new ReferenceQueue() : null;
        int n3 = (int)((float)n / 0.75f) + 1;
        this.cacheMap = new LinkedHashMap<Object, CacheEntry>(n3, 0.75f, true);
    }

    private void emptyQueue() {
        CacheEntry cacheEntry;
        if (this.queue == null) {
            return;
        }
        int n = this.cacheMap.size();
        while ((cacheEntry = (CacheEntry)((Object)this.queue.poll())) != null) {
            CacheEntry cacheEntry2;
            Object object = cacheEntry.getKey();
            if (object == null || (cacheEntry2 = this.cacheMap.remove(object)) == null || cacheEntry == cacheEntry2) continue;
            this.cacheMap.put(object, cacheEntry2);
        }
    }

    private void expungeExpiredEntries() {
        this.emptyQueue();
        if (this.lifetime == 0L) {
            return;
        }
        int n = 0;
        long l = System.currentTimeMillis();
        Iterator<CacheEntry> iterator = this.cacheMap.values().iterator();
        while (iterator.hasNext()) {
            CacheEntry cacheEntry = iterator.next();
            if (cacheEntry.isValid(l)) continue;
            iterator.remove();
            ++n;
        }
    }

    @Override
    public synchronized int size() {
        this.expungeExpiredEntries();
        return this.cacheMap.size();
    }

    @Override
    public synchronized void clear() {
        if (this.queue != null) {
            for (CacheEntry cacheEntry : this.cacheMap.values()) {
                cacheEntry.invalidate();
            }
            while (this.queue.poll() != null) {
            }
        }
        this.cacheMap.clear();
    }

    @Override
    public synchronized void put(Object object, Object object2) {
        this.emptyQueue();
        long l = this.lifetime == 0L ? 0L : System.currentTimeMillis() + this.lifetime;
        CacheEntry cacheEntry = this.newEntry(object, object2, l, this.queue);
        CacheEntry cacheEntry2 = this.cacheMap.put(object, cacheEntry);
        if (cacheEntry2 != null) {
            cacheEntry2.invalidate();
            return;
        }
        if (this.maxSize > 0 && this.cacheMap.size() > this.maxSize) {
            this.expungeExpiredEntries();
            if (this.cacheMap.size() > this.maxSize) {
                Iterator<CacheEntry> iterator = this.cacheMap.values().iterator();
                CacheEntry cacheEntry3 = iterator.next();
                iterator.remove();
                cacheEntry3.invalidate();
            }
        }
    }

    @Override
    public synchronized Object get(Object object) {
        long l;
        this.emptyQueue();
        CacheEntry cacheEntry = this.cacheMap.get(object);
        if (cacheEntry == null) {
            return null;
        }
        long l2 = l = this.lifetime == 0L ? 0L : System.currentTimeMillis();
        if (!cacheEntry.isValid(l)) {
            this.cacheMap.remove(object);
            return null;
        }
        return cacheEntry.getValue();
    }

    @Override
    public synchronized void remove(Object object) {
        this.emptyQueue();
        CacheEntry cacheEntry = this.cacheMap.remove(object);
        if (cacheEntry != null) {
            cacheEntry.invalidate();
        }
    }

    @Override
    public synchronized void setCapacity(int n) {
        this.expungeExpiredEntries();
        if (n > 0 && this.cacheMap.size() > n) {
            Iterator<CacheEntry> iterator = this.cacheMap.values().iterator();
            for (int i = this.cacheMap.size() - n; i > 0; --i) {
                CacheEntry cacheEntry = iterator.next();
                iterator.remove();
                cacheEntry.invalidate();
            }
        }
        this.maxSize = n > 0 ? n : 0;
    }

    @Override
    public synchronized void setTimeout(int n) {
        this.emptyQueue();
        this.lifetime = n > 0 ? (long)n * 1000L : 0L;
    }

    @Override
    public synchronized void accept(Cache.CacheVisitor cacheVisitor) {
        this.expungeExpiredEntries();
        Map<Object, Object> map = this.getCachedEntries();
        cacheVisitor.visit(map);
    }

    private Map<Object, Object> getCachedEntries() {
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>(this.cacheMap.size());
        for (CacheEntry cacheEntry : this.cacheMap.values()) {
            hashMap.put(cacheEntry.getKey(), cacheEntry.getValue());
        }
        return hashMap;
    }

    protected CacheEntry newEntry(Object object, Object object2, long l, ReferenceQueue<Object> referenceQueue) {
        if (referenceQueue != null) {
            return new SoftCacheEntry(object, object2, l, referenceQueue);
        }
        return new HardCacheEntry(object, object2, l);
    }

    private static class SoftCacheEntry
    extends SoftReference<Object>
    implements CacheEntry {
        private Object key;
        private long expirationTime;

        SoftCacheEntry(Object object, Object object2, long l, ReferenceQueue<Object> referenceQueue) {
            super(object2, referenceQueue);
            this.key = object;
            this.expirationTime = l;
        }

        @Override
        public Object getKey() {
            return this.key;
        }

        @Override
        public Object getValue() {
            return this.get();
        }

        @Override
        public boolean isValid(long l) {
            boolean bl;
            boolean bl2 = bl = l <= this.expirationTime && this.get() != null;
            if (!bl) {
                this.invalidate();
            }
            return bl;
        }

        @Override
        public void invalidate() {
            this.clear();
            this.key = null;
            this.expirationTime = -1L;
        }
    }

    private static class HardCacheEntry
    implements CacheEntry {
        private Object key;
        private Object value;
        private long expirationTime;

        HardCacheEntry(Object object, Object object2, long l) {
            this.key = object;
            this.value = object2;
            this.expirationTime = l;
        }

        @Override
        public Object getKey() {
            return this.key;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public boolean isValid(long l) {
            boolean bl;
            boolean bl2 = bl = l <= this.expirationTime;
            if (!bl) {
                this.invalidate();
            }
            return bl;
        }

        @Override
        public void invalidate() {
            this.key = null;
            this.value = null;
            this.expirationTime = -1L;
        }
    }

    private static interface CacheEntry {
        public boolean isValid(long var1);

        public void invalidate();

        public Object getKey();

        public Object getValue();
    }
}

