/*
 * Decompiled with CFR 0.152.
 */
package sun.security.validator;

import java.io.Serializable;
import java.security.AccessController;
import java.security.AlgorithmConstraints;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.PublicKey;
import java.security.Timestamp;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathValidator;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import sun.security.action.GetBooleanAction;
import sun.security.action.GetPropertyAction;
import sun.security.provider.certpath.AlgorithmChecker;
import sun.security.provider.certpath.PKIXExtendedParameters;
import sun.security.validator.Validator;
import sun.security.validator.ValidatorException;

public final class PKIXValidator
extends Validator {
    private static final boolean checkTLSRevocation = AccessController.doPrivileged(new GetBooleanAction("com.sun.net.ssl.checkRevocation"));
    private static final boolean TRY_VALIDATOR = true;
    private static final boolean ALLOW_NON_CA_ANCHOR = PKIXValidator.allowNonCaAnchor();
    private final Set<X509Certificate> trustedCerts;
    private final PKIXBuilderParameters parameterTemplate;
    private int certPathLength = -1;
    private final Map<X500Principal, List<PublicKey>> trustedSubjects;
    private final CertificateFactory factory;
    private final boolean plugin;

    private static boolean allowNonCaAnchor() {
        String string = GetPropertyAction.privilegedGetProperty("jdk.security.allowNonCaAnchor");
        return string != null && (string.isEmpty() || string.equalsIgnoreCase("true"));
    }

    PKIXValidator(String string, Collection<X509Certificate> collection) {
        super("PKIX", string);
        this.trustedCerts = collection instanceof Set ? (Set<Object>)collection : new HashSet<X509Certificate>(collection);
        HashSet<TrustAnchor> hashSet = new HashSet<TrustAnchor>();
        for (X509Certificate x509Certificate : collection) {
            hashSet.add(new TrustAnchor(x509Certificate, null));
        }
        try {
            this.parameterTemplate = new PKIXBuilderParameters(hashSet, null);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new RuntimeException("Unexpected error: " + invalidAlgorithmParameterException.toString(), invalidAlgorithmParameterException);
        }
        this.setDefaultParameters(string);
        this.trustedSubjects = new HashMap<X500Principal, List<PublicKey>>();
        for (X509Certificate x509Certificate : collection) {
            List<Object> list;
            X500Principal x500Principal = x509Certificate.getSubjectX500Principal();
            if (this.trustedSubjects.containsKey(x500Principal)) {
                list = this.trustedSubjects.get(x500Principal);
            } else {
                list = new ArrayList();
                this.trustedSubjects.put(x500Principal, list);
            }
            list.add(x509Certificate.getPublicKey());
        }
        try {
            this.factory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException certificateException) {
            throw new RuntimeException("Internal error", certificateException);
        }
        this.plugin = string.equals("plugin code signing");
    }

    PKIXValidator(String string, PKIXBuilderParameters pKIXBuilderParameters) {
        super("PKIX", string);
        Serializable serializable;
        this.trustedCerts = new HashSet<X509Certificate>();
        for (TrustAnchor object : pKIXBuilderParameters.getTrustAnchors()) {
            serializable = object.getTrustedCert();
            if (serializable == null) continue;
            this.trustedCerts.add((X509Certificate)serializable);
        }
        this.parameterTemplate = pKIXBuilderParameters;
        this.trustedSubjects = new HashMap<X500Principal, List<PublicKey>>();
        for (X509Certificate x509Certificate : this.trustedCerts) {
            List<Object> list;
            serializable = x509Certificate.getSubjectX500Principal();
            if (this.trustedSubjects.containsKey(serializable)) {
                list = this.trustedSubjects.get(serializable);
            } else {
                list = new ArrayList();
                this.trustedSubjects.put((X500Principal)serializable, list);
            }
            list.add(x509Certificate.getPublicKey());
        }
        try {
            this.factory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException certificateException) {
            throw new RuntimeException("Internal error", certificateException);
        }
        this.plugin = string.equals("plugin code signing");
    }

    @Override
    public Collection<X509Certificate> getTrustedCertificates() {
        return this.trustedCerts;
    }

    public int getCertPathLength() {
        return this.certPathLength;
    }

    private void setDefaultParameters(String string) {
        if (string == "tls server" || string == "tls client") {
            this.parameterTemplate.setRevocationEnabled(checkTLSRevocation);
        } else {
            this.parameterTemplate.setRevocationEnabled(false);
        }
    }

    public PKIXBuilderParameters getParameters() {
        return this.parameterTemplate;
    }

    @Override
    X509Certificate[] engineValidate(X509Certificate[] x509CertificateArray, Collection<X509Certificate> collection, AlgorithmConstraints algorithmConstraints, Object object) throws CertificateException {
        X500Principal x500Principal;
        Serializable serializable;
        if (x509CertificateArray == null || x509CertificateArray.length == 0) {
            throw new CertificateException("null or zero-length certificate chain");
        }
        PKIXParameters pKIXParameters = null;
        try {
            pKIXParameters = new PKIXExtendedParameters((PKIXBuilderParameters)this.parameterTemplate.clone(), object instanceof Timestamp ? (Timestamp)object : null, this.variant);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            // empty catch block
        }
        if (algorithmConstraints != null) {
            pKIXParameters.addCertPathChecker(new AlgorithmChecker(algorithmConstraints, this.variant));
        }
        X500Principal x500Principal2 = null;
        for (int i = 0; i < x509CertificateArray.length; ++i) {
            serializable = x509CertificateArray[i];
            x500Principal = ((X509Certificate)serializable).getSubjectX500Principal();
            if (i == 0) {
                if (this.trustedCerts.contains(serializable)) {
                    return new X509Certificate[]{x509CertificateArray[0]};
                }
            } else {
                if (!x500Principal.equals(x500Principal2)) {
                    return this.doBuild(x509CertificateArray, collection, (PKIXBuilderParameters)pKIXParameters);
                }
                if (this.trustedCerts.contains(serializable) || this.trustedSubjects.containsKey(x500Principal) && this.trustedSubjects.get(x500Principal).contains(((Certificate)serializable).getPublicKey())) {
                    X509Certificate[] x509CertificateArray2 = new X509Certificate[i];
                    System.arraycopy(x509CertificateArray, 0, x509CertificateArray2, 0, i);
                    return this.doValidate(x509CertificateArray2, (PKIXBuilderParameters)pKIXParameters);
                }
            }
            x500Principal2 = ((X509Certificate)serializable).getIssuerX500Principal();
        }
        X509Certificate x509Certificate = x509CertificateArray[x509CertificateArray.length - 1];
        serializable = x509Certificate.getIssuerX500Principal();
        x500Principal = x509Certificate.getSubjectX500Principal();
        if (this.trustedSubjects.containsKey(serializable) && this.isSignatureValid(this.trustedSubjects.get(serializable), x509Certificate)) {
            return this.doValidate(x509CertificateArray, (PKIXBuilderParameters)pKIXParameters);
        }
        if (this.plugin) {
            if (x509CertificateArray.length > 1) {
                X509Certificate[] x509CertificateArray3 = new X509Certificate[x509CertificateArray.length - 1];
                System.arraycopy(x509CertificateArray, 0, x509CertificateArray3, 0, x509CertificateArray3.length);
                try {
                    pKIXParameters.setTrustAnchors(Collections.singleton(new TrustAnchor(x509CertificateArray[x509CertificateArray.length - 1], null)));
                }
                catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                    throw new CertificateException(invalidAlgorithmParameterException);
                }
                this.doValidate(x509CertificateArray3, (PKIXBuilderParameters)pKIXParameters);
            }
            throw new ValidatorException(ValidatorException.T_NO_TRUST_ANCHOR);
        }
        return this.doBuild(x509CertificateArray, collection, (PKIXBuilderParameters)pKIXParameters);
    }

    private boolean isSignatureValid(List<PublicKey> list, X509Certificate x509Certificate) {
        if (this.plugin) {
            for (PublicKey publicKey : list) {
                try {
                    x509Certificate.verify(publicKey);
                    return true;
                }
                catch (Exception exception) {
                }
            }
            return false;
        }
        return true;
    }

    private static X509Certificate[] toArray(CertPath certPath, TrustAnchor trustAnchor) throws CertificateException {
        X509Certificate x509Certificate = trustAnchor.getTrustedCert();
        if (x509Certificate == null) {
            throw new ValidatorException("TrustAnchor must be specified as certificate");
        }
        PKIXValidator.verifyTrustAnchor(x509Certificate);
        List<? extends Certificate> list = certPath.getCertificates();
        X509Certificate[] x509CertificateArray = new X509Certificate[list.size() + 1];
        list.toArray(x509CertificateArray);
        x509CertificateArray[x509CertificateArray.length - 1] = x509Certificate;
        return x509CertificateArray;
    }

    private void setDate(PKIXBuilderParameters pKIXBuilderParameters) {
        Date date = this.validationDate;
        if (date != null) {
            pKIXBuilderParameters.setDate(date);
        }
    }

    private X509Certificate[] doValidate(X509Certificate[] x509CertificateArray, PKIXBuilderParameters pKIXBuilderParameters) throws CertificateException {
        try {
            this.setDate(pKIXBuilderParameters);
            CertPathValidator certPathValidator = CertPathValidator.getInstance("PKIX");
            CertPath certPath = this.factory.generateCertPath(Arrays.asList(x509CertificateArray));
            this.certPathLength = x509CertificateArray.length;
            PKIXCertPathValidatorResult pKIXCertPathValidatorResult = (PKIXCertPathValidatorResult)certPathValidator.validate(certPath, pKIXBuilderParameters);
            return PKIXValidator.toArray(certPath, pKIXCertPathValidatorResult.getTrustAnchor());
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new ValidatorException("PKIX path validation failed: " + generalSecurityException.toString(), generalSecurityException);
        }
    }

    private static void verifyTrustAnchor(X509Certificate x509Certificate) throws ValidatorException {
        if (ALLOW_NON_CA_ANCHOR) {
            return;
        }
        if (x509Certificate.getVersion() < 3) {
            return;
        }
        if (x509Certificate.getBasicConstraints() == -1) {
            throw new ValidatorException("TrustAnchor with subject \"" + x509Certificate.getSubjectX500Principal() + "\" is not a CA certificate");
        }
        boolean[] blArray = x509Certificate.getKeyUsage();
        if (blArray != null && !blArray[5]) {
            throw new ValidatorException("TrustAnchor with subject \"" + x509Certificate.getSubjectX500Principal() + "\" does not have keyCertSign bit set in KeyUsage extension");
        }
    }

    private X509Certificate[] doBuild(X509Certificate[] x509CertificateArray, Collection<X509Certificate> collection, PKIXBuilderParameters pKIXBuilderParameters) throws CertificateException {
        try {
            this.setDate(pKIXBuilderParameters);
            X509CertSelector x509CertSelector = new X509CertSelector();
            x509CertSelector.setCertificate(x509CertificateArray[0]);
            pKIXBuilderParameters.setTargetCertConstraints(x509CertSelector);
            ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
            arrayList.addAll(Arrays.asList(x509CertificateArray));
            if (collection != null) {
                arrayList.addAll(collection);
            }
            CertStore certStore = CertStore.getInstance("Collection", new CollectionCertStoreParameters(arrayList));
            pKIXBuilderParameters.addCertStore(certStore);
            CertPathBuilder certPathBuilder = CertPathBuilder.getInstance("PKIX");
            PKIXCertPathBuilderResult pKIXCertPathBuilderResult = (PKIXCertPathBuilderResult)certPathBuilder.build(pKIXBuilderParameters);
            return PKIXValidator.toArray(pKIXCertPathBuilderResult.getCertPath(), pKIXCertPathBuilderResult.getTrustAnchor());
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new ValidatorException("PKIX path building failed: " + generalSecurityException.toString(), generalSecurityException);
        }
    }
}

