/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.security.AccessController;
import java.security.AlgorithmConstraints;
import java.security.AlgorithmParameters;
import java.security.CryptoPrimitive;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLProtocolException;
import sun.security.action.GetPropertyAction;
import sun.security.ssl.Debug;
import sun.security.ssl.ExtensionType;
import sun.security.ssl.HandshakeInStream;
import sun.security.ssl.HandshakeOutStream;
import sun.security.ssl.HelloExtension;
import sun.security.ssl.JsseJce;
import sun.security.ssl.SunJSSE;

final class EllipticCurvesExtension
extends HelloExtension {
    private static final Debug debug;
    private static final int ARBITRARY_PRIME = 65281;
    private static final int ARBITRARY_CHAR2 = 65282;
    private static final Map<String, Integer> oidToIdMap;
    private static final Map<Integer, String> idToOidMap;
    private static final Map<Integer, AlgorithmParameters> idToParams;
    private static final int[] supportedCurveIds;
    private final int[] curveIds;

    private static boolean isAvailableCurve(int n) {
        String string = idToOidMap.get(n);
        if (string != null) {
            AlgorithmParameters algorithmParameters = null;
            try {
                algorithmParameters = JsseJce.getAlgorithmParameters("EC");
                algorithmParameters.init(new ECGenParameterSpec(string));
            }
            catch (Exception exception) {
                return false;
            }
            idToParams.put(n, algorithmParameters);
            return true;
        }
        return false;
    }

    private EllipticCurvesExtension(int[] nArray) {
        super(ExtensionType.EXT_ELLIPTIC_CURVES);
        this.curveIds = nArray;
    }

    EllipticCurvesExtension(HandshakeInStream handshakeInStream, int n) throws IOException {
        super(ExtensionType.EXT_ELLIPTIC_CURVES);
        int n2 = handshakeInStream.getInt16();
        if ((n & 1) != 0 || n2 + 2 != n) {
            throw new SSLProtocolException("Invalid " + this.type + " extension");
        }
        this.curveIds = new int[n2 >> 1];
        for (int i = 0; i < this.curveIds.length; ++i) {
            this.curveIds[i] = handshakeInStream.getInt16();
        }
    }

    static int getActiveCurves(AlgorithmConstraints algorithmConstraints) {
        return EllipticCurvesExtension.getPreferredCurve(supportedCurveIds, algorithmConstraints);
    }

    static boolean hasActiveCurves(AlgorithmConstraints algorithmConstraints) {
        return EllipticCurvesExtension.getActiveCurves(algorithmConstraints) >= 0;
    }

    static EllipticCurvesExtension createExtension(AlgorithmConstraints algorithmConstraints) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(supportedCurveIds.length);
        for (int n : supportedCurveIds) {
            if (!algorithmConstraints.permits(EnumSet.of(CryptoPrimitive.KEY_AGREEMENT), "EC", idToParams.get(n))) continue;
            arrayList.add(n);
        }
        if (!arrayList.isEmpty()) {
            int[] nArray = new int[arrayList.size()];
            int n = 0;
            for (Integer n2 : arrayList) {
                nArray[n++] = n2;
            }
            return new EllipticCurvesExtension(nArray);
        }
        return null;
    }

    int getPreferredCurve(AlgorithmConstraints algorithmConstraints) {
        return EllipticCurvesExtension.getPreferredCurve(this.curveIds, algorithmConstraints);
    }

    private static int getPreferredCurve(int[] nArray, AlgorithmConstraints algorithmConstraints) {
        for (int n : nArray) {
            if (!EllipticCurvesExtension.isSupported(n) || !algorithmConstraints.permits(EnumSet.of(CryptoPrimitive.KEY_AGREEMENT), "EC", idToParams.get(n))) continue;
            return n;
        }
        return -1;
    }

    boolean contains(int n) {
        for (int n2 : this.curveIds) {
            if (n != n2) continue;
            return true;
        }
        return false;
    }

    @Override
    int length() {
        return 6 + (this.curveIds.length << 1);
    }

    @Override
    void send(HandshakeOutStream handshakeOutStream) throws IOException {
        handshakeOutStream.putInt16(this.type.id);
        int n = this.curveIds.length << 1;
        handshakeOutStream.putInt16(n + 2);
        handshakeOutStream.putInt16(n);
        for (int n2 : this.curveIds) {
            handshakeOutStream.putInt16(n2);
        }
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Extension " + this.type + ", curve names: {");
        boolean bl = true;
        for (int n : this.curveIds) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(", ");
            }
            String string = EllipticCurvesExtension.getCurveName(n);
            if (string != null) {
                stringBuilder.append(string);
                continue;
            }
            if (n == 65281) {
                stringBuilder.append("arbitrary_explicit_prime_curves");
                continue;
            }
            if (n == 65282) {
                stringBuilder.append("arbitrary_explicit_char2_curves");
                continue;
            }
            stringBuilder.append("unknown curve " + n);
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    static boolean isSupported(int n) {
        for (int n2 : supportedCurveIds) {
            if (n != n2) continue;
            return true;
        }
        return false;
    }

    static int getCurveIndex(ECParameterSpec eCParameterSpec) {
        String string = JsseJce.getNamedCurveOid(eCParameterSpec);
        if (string == null) {
            return -1;
        }
        Integer n = oidToIdMap.get(string);
        return n == null ? -1 : n;
    }

    static String getCurveOid(int n) {
        return idToOidMap.get(n);
    }

    static ECGenParameterSpec getECGenParamSpec(int n) {
        AlgorithmParameters algorithmParameters = idToParams.get(n);
        try {
            return algorithmParameters.getParameterSpec(ECGenParameterSpec.class);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            String string = EllipticCurvesExtension.getCurveOid(n);
            return new ECGenParameterSpec(string);
        }
    }

    private static String getCurveName(int n) {
        for (NamedEllipticCurve namedEllipticCurve : NamedEllipticCurve.values()) {
            if (namedEllipticCurve.id != n) continue;
            return namedEllipticCurve.name;
        }
        return null;
    }

    static {
        ArrayList<Integer> arrayList;
        Object[] objectArray;
        debug = Debug.getInstance("ssl");
        oidToIdMap = new HashMap<String, Integer>();
        idToOidMap = new HashMap<Integer, String>();
        idToParams = new HashMap<Integer, AlgorithmParameters>();
        boolean bl = SunJSSE.isFIPS();
        NamedEllipticCurve namedEllipticCurve = NamedEllipticCurve.getCurve("secp256r1", false);
        String string = AccessController.doPrivileged(new GetPropertyAction("jdk.tls.namedGroups"));
        if (string != null && string.length() != 0 && string.length() > 1 && string.charAt(0) == '\"' && string.charAt(string.length() - 1) == '\"') {
            string = string.substring(1, string.length() - 1);
        }
        if (string != null && string.length() != 0) {
            objectArray = string.split(",");
            arrayList = new ArrayList<Integer>(objectArray.length);
            for (String string2 : objectArray) {
                NamedEllipticCurve namedEllipticCurve2;
                if ((string2 = string2.trim()).isEmpty() || (namedEllipticCurve2 = NamedEllipticCurve.getCurve(string2, bl)) == null || !EllipticCurvesExtension.isAvailableCurve(namedEllipticCurve2.id)) continue;
                arrayList.add(namedEllipticCurve2.id);
            }
            if (arrayList.isEmpty() && JsseJce.isEcAvailable()) {
                throw new IllegalArgumentException("System property jdk.tls.namedGroups(" + string + ") " + "contains no supported elliptic curves");
            }
        } else {
            objectArray = new int[]{23, 24, 25};
            arrayList = new ArrayList(objectArray.length);
            for (String string3 : objectArray) {
                if (!EllipticCurvesExtension.isAvailableCurve((int)string3)) continue;
                arrayList.add((int)string3);
            }
        }
        if (debug != null && arrayList.isEmpty()) {
            debug.println("Initialized [jdk.tls.namedGroups|default] list contains no available elliptic curves. " + (string != null ? "(" + string + ")" : "[Default]"));
        }
        supportedCurveIds = new int[arrayList.size()];
        int n = 0;
        for (Integer n2 : arrayList) {
            EllipticCurvesExtension.supportedCurveIds[n++] = n2;
        }
    }

    private static enum NamedEllipticCurve {
        T163_K1(1, "sect163k1", "1.3.132.0.1", true),
        T163_R1(2, "sect163r1", "1.3.132.0.2", false),
        T163_R2(3, "sect163r2", "1.3.132.0.15", true),
        T193_R1(4, "sect193r1", "1.3.132.0.24", false),
        T193_R2(5, "sect193r2", "1.3.132.0.25", false),
        T233_K1(6, "sect233k1", "1.3.132.0.26", true),
        T233_R1(7, "sect233r1", "1.3.132.0.27", true),
        T239_K1(8, "sect239k1", "1.3.132.0.3", false),
        T283_K1(9, "sect283k1", "1.3.132.0.16", true),
        T283_R1(10, "sect283r1", "1.3.132.0.17", true),
        T409_K1(11, "sect409k1", "1.3.132.0.36", true),
        T409_R1(12, "sect409r1", "1.3.132.0.37", true),
        T571_K1(13, "sect571k1", "1.3.132.0.38", true),
        T571_R1(14, "sect571r1", "1.3.132.0.39", true),
        P160_K1(15, "secp160k1", "1.3.132.0.9", false),
        P160_R1(16, "secp160r1", "1.3.132.0.8", false),
        P160_R2(17, "secp160r2", "1.3.132.0.30", false),
        P192_K1(18, "secp192k1", "1.3.132.0.31", false),
        P192_R1(19, "secp192r1", "1.2.840.10045.3.1.1", true),
        P224_K1(20, "secp224k1", "1.3.132.0.32", false),
        P224_R1(21, "secp224r1", "1.3.132.0.33", true),
        P256_K1(22, "secp256k1", "1.3.132.0.10", false),
        P256_R1(23, "secp256r1", "1.2.840.10045.3.1.7", true),
        P384_R1(24, "secp384r1", "1.3.132.0.34", true),
        P521_R1(25, "secp521r1", "1.3.132.0.35", true);

        int id;
        String name;
        String oid;
        boolean isFips;

        private NamedEllipticCurve(int n2, String string2, String string3, boolean bl) {
            this.id = n2;
            this.name = string2;
            this.oid = string3;
            this.isFips = bl;
            if (oidToIdMap.put(string3, n2) != null || idToOidMap.put(n2, string3) != null) {
                throw new RuntimeException("Duplicate named elliptic curve definition: " + string2);
            }
        }

        static NamedEllipticCurve getCurve(String string, boolean bl) {
            for (NamedEllipticCurve namedEllipticCurve : NamedEllipticCurve.values()) {
                if (!namedEllipticCurve.name.equals(string) || bl && !namedEllipticCurve.isFips) continue;
                return namedEllipticCurve;
            }
            return null;
        }
    }
}

