/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.security.SecureRandom;
import java.util.Arrays;
import javax.net.ssl.SSLProtocolException;
import sun.security.ssl.ProtocolVersion;
import sun.security.ssl.RandomCookie;

final class SessionId {
    static int MAX_LENGTH = 32;
    private byte[] sessionId;

    SessionId(boolean bl, SecureRandom secureRandom) {
        this.sessionId = bl ? new RandomCookie((SecureRandom)secureRandom).random_bytes : new byte[0];
    }

    SessionId(byte[] byArray) {
        this.sessionId = byArray;
    }

    int length() {
        return this.sessionId.length;
    }

    byte[] getId() {
        return (byte[])this.sessionId.clone();
    }

    public String toString() {
        int n = this.sessionId.length;
        StringBuffer stringBuffer = new StringBuffer(10 + 2 * n);
        stringBuffer.append("{");
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(0xFF & this.sessionId[i]);
            if (i == n - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public int hashCode() {
        return Arrays.hashCode(this.sessionId);
    }

    public boolean equals(Object object) {
        if (!(object instanceof SessionId)) {
            return false;
        }
        SessionId sessionId = (SessionId)object;
        byte[] byArray = sessionId.getId();
        if (this.sessionId == byArray) {
            return true;
        }
        if (this.sessionId == null || byArray == null) {
            return false;
        }
        if (byArray.length != this.sessionId.length) {
            return false;
        }
        int n = 0;
        for (int i = 0; i < this.sessionId.length; ++i) {
            n |= this.sessionId[i] ^ byArray[i];
        }
        return n == 0;
    }

    void checkLength(ProtocolVersion protocolVersion) throws SSLProtocolException {
        if (this.sessionId.length > MAX_LENGTH) {
            throw new SSLProtocolException("Invalid session ID length (" + this.sessionId.length + " bytes)");
        }
    }
}

