/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client.service;

import com.azul.crs.client.service.FileTailer;
import com.azul.crs.client.service.FileTailerListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;

public class GCRotatingLogTailer
extends FileTailer {
    private static final String CURRENT = "current";
    private long startTime;
    private int logCount;

    protected GCRotatingLogTailer(String string, File file, FileTailerListener fileTailerListener, long l, boolean bl, int n, int n2, long l2) {
        super(string, file, fileTailerListener, l, false, bl, n);
        this.logCount = n2;
        this.startTime = l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void run() {
        FileInputStream fileInputStream = null;
        try {
            String string = this.file.getPath();
            int n = 0;
            File file = null;
            long l = this.startTime;
            this.logger().info("looking for current file of GC log %s", string);
            while (this.running) {
                try {
                    n = 0;
                    file = new File(String.format("%s.%d.%s", string, n, CURRENT));
                    if (file.lastModified() > l) {
                        fileInputStream = new FileInputStream(file);
                        l = file.lastModified();
                        this.readBytes(fileInputStream);
                        break;
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.listener.fileNotFound();
                }
                n = (n + 1) % this.logCount;
                Thread.sleep(this.delayTimeout / (long)this.logCount);
            }
            this.logger().info("tailing GC log starting from file %s", file.getName());
            while (this.running) {
                this.readBytes(fileInputStream);
                if (!file.exists()) {
                    while (this.running) {
                        Throwable throwable;
                        FileInputStream fileInputStream2;
                        n = (n + 1) % this.logCount;
                        file = new File(String.format("%s.%d.%s", string, n, CURRENT));
                        if (file.lastModified() > l) {
                            try {
                                fileInputStream2 = fileInputStream;
                                throwable = null;
                                try {
                                    fileInputStream = new FileInputStream(file);
                                    l = file.lastModified();
                                    this.listener.fileRotated("current log number " + n);
                                    this.readBytes(fileInputStream);
                                    break;
                                }
                                catch (Throwable throwable2) {
                                    throwable = throwable2;
                                    throw throwable2;
                                }
                                finally {
                                    if (fileInputStream2 != null) {
                                        if (throwable != null) {
                                            try {
                                                fileInputStream2.close();
                                            }
                                            catch (Throwable throwable3) {
                                                throwable.addSuppressed(throwable3);
                                            }
                                        } else {
                                            fileInputStream2.close();
                                        }
                                    }
                                }
                            }
                            catch (FileNotFoundException fileNotFoundException) {
                                // empty catch block
                            }
                        }
                        if ((file = new File(String.format("%s.%d", string, n))).lastModified() > l) {
                            try {
                                fileInputStream2 = fileInputStream;
                                throwable = null;
                                try {
                                    fileInputStream = new FileInputStream(file);
                                    l = file.lastModified();
                                    this.listener.fileRotated("next log number " + n);
                                    this.readBytes(fileInputStream);
                                    continue;
                                }
                                catch (Throwable throwable4) {
                                    throwable = throwable4;
                                    throw throwable4;
                                }
                                finally {
                                    if (fileInputStream2 == null) continue;
                                    if (throwable != null) {
                                        try {
                                            fileInputStream2.close();
                                        }
                                        catch (Throwable throwable5) {
                                            throwable.addSuppressed(throwable5);
                                        }
                                        continue;
                                    }
                                    fileInputStream2.close();
                                    continue;
                                }
                            }
                            catch (FileNotFoundException fileNotFoundException) {
                                this.listener.fileNotFound();
                            }
                        }
                        n = (n - 1) % this.logCount;
                    }
                }
                Thread.sleep(this.delayTimeout);
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            this.listener.interrupted();
        }
        catch (Exception exception) {
            this.listener.handle(exception);
        }
        finally {
            this.closeReader(fileInputStream);
            this.running = false;
        }
    }

    public static class Builder
    extends FileTailer.Builder<Builder> {
        private int logCount;
        private long startTime;

        public Builder(File file) {
            super(file);
        }

        public Builder logCount(int n) {
            this.logCount = n;
            return this;
        }

        public Builder startTime(long l) {
            this.startTime = l;
            return this;
        }

        @Override
        public GCRotatingLogTailer build() {
            return new GCRotatingLogTailer(this.serviceName, this.file, this.listener, this.delayTimeout, this.completeOnStop, this.bufSize, this.logCount, this.startTime);
        }
    }
}

