# General

* [About](about.md)
<br />About Boriel BASIC SDK

* [ChangeLog](https://github.com/boriel-basic/zxbasic/blob/master/CHANGELOG.md)
<br />A reduced list of changes/bugfixes

* [Installation](installation.md)
<br />How to install Boriel BASIC SDK in your system, and prerequisites for doing so.

* [SDK tools](tools.md)
<br />Tools available in the SDK.

* [Command line options](zxb.md#Command-Line-Options)
<br />Command line options table for the compiler (zxb)

## Download
Get the latest version of Boriel BASIC from the [archive](archive.md).

## Released programs

* [Released programs](released_programs.md)
<br />A list of third-party released programs (mostly games) for the ZX-Spectrum developed with Boriel BASIC.

## Learning Boriel BASIC

### Language Reference
* [Language syntax](syntax.md)
<br />Language Syntax is very close to the original Sinclair BASIC, but it's expanded and enhanced.

* [Data types](types.md)
<br />Language data types: Instead of working always with Floating Point numbers (also available), there are also some integer types which are faster an take less memory.

* [Reserved words](identifier.md)
<br />Comprehensive list (alphabetically ordered) of identifiers you shouldn't use as a ''variable name''. E.g. `FOR`, `PRINT`. If you want usage instructions on a statement, also look here.

* [Standard libraries](library/stdlib.md)
<br />Standard libraries that comes bundled with Boriel BASIC compiler.

### Tutorials
* [Programming tutorials](tutorials.md)
<br />A collection of third-party tutorials about development with Boriel BASIC.

* [Sample Programs](sample_programs.md)
<br />Sample programs you can try to see what Boriel BASIC looks like and how fast it runs.

* [Sample Games](sample_programs.md#Game Examples)
<br />Some little games examples.

## Help and Support

* [Community Forum](https://forum.boriel.com/)
<br />Have a question? Need help or comment a report a bug? Go to the [Boriel BASIC forum](https://forum.boriel.com/)

## External resources

* Here you are [external resources](external_resources.md): other tools, IDEs, graphic designers and projects related to Boriel BASIC. Have a look!

### External libraries

* [Library](library.md)
<br />Library of functions and subroutines you can use in your programs. You might find them really useful.

## Inline assembler
Embedding inline assembler in your code is pretty easy. There's a [tutorial](tutorials.md#how-to-use-inline-assembly) on it.

## Compiler internals
Only for true hackers: This explains how the compiler does its job, how to expand it, etc.
This is `work in progress`.

## Other Architectures
Boriel BASIC was designed from the base as a Retargeable Compiler, so it should be not hard to extend
it to other architectures. This is `work in progress`. See [other architectures](other_architectures.md) for more info.

## Contributing
You can issue a Pull Request to the [GitHub repository](https://github.com/boriel-basic/zxbasic), report bugs in the forum
when using the compiler, suggest new features...

[![ko-fi](https://www.ko-fi.com/img/githubbutton_sm.svg)](https://ko-fi.com/H2H81J0OU)
