# Sample Programs

## Examples

Tutorials and examples are the fastest way (in my opinion) to learn a new language.
Well, ZX BASIC is not so _new_ if you are used to Sinclair BASIC.
The following is a list of examples, some of them already bundled with
the ZX BASIC distribution in the `examples/` directory:

* [CIRCLE.BAS](examples/circle.bas.md)
<br />Draws a circle pixel by pixel using [PLOT](plot.md) primitive
* [CLOCK.BAS](examples/clock.bas.md)
<br />Sample clock which uses the FRAMES variable (taken from the ZX Spectrum 48K user manual)
* [CLOCK2.BAS](examples/clock2.bas.md)
<br />Like above, but a bit improved.
* [COLORS.BAS](examples/colors.bas.md)
<br />Colors example from the ZX Spectrum user manual
* [LINES.BAS](examples/lines.bas.md)
<br />Random color lines example from the ZX Spectrum 48K user manual.
* [FACT.BAS](examples/fact.bas.md)
<br />Factorial ''recursive'' test.
* [FREREGUSTAV.BAS](examples/freregustav.bas.md)
<br />A sound demo (taken from the ZX Spectrum 48K user manual)
* [FLAG.BAS](examples/flag.bas.md)
<br /> UK Flag drawing (taken from the ZX Spectrum 48K / 128K user manual)
* [FRACTAL.BAS](examples/fractal.bas.md)
<br /> Mandelbrot fractal by @Britlion

### Games
* [SNAKE.BAS](examples/snake.bas.md)<br />
The snake game by Federico J. Álvarez Valero (2003-02-05) (English version)

* [4INAROW.BAS](examples/4inarow.bas.md)<br />
A _4 in a Row_ program with <abbr title="Artificial Intelligence">A.I.</abbr> that plays against you and fit
in just 16Kb. Published on the 80's in the Spanish
[MicroHobby magazine, issue 18](https://microhobby.speccy.cz/mhforever/numero018.htm)
