/*
 * Decompiled with CFR 0.152.
 */
package arc.assets.loaders;

import arc.assets.AssetDescriptor;
import arc.assets.AssetLoaderParameters;
import arc.assets.AssetManager;
import arc.assets.loaders.AsynchronousAssetLoader;
import arc.assets.loaders.FileHandleResolver;
import arc.files.Fi;
import arc.graphics.Cubemap;
import arc.graphics.CubemapData;
import arc.graphics.Pixmap;
import arc.graphics.Texture;
import arc.struct.Seq;

public class CubemapLoader
extends AsynchronousAssetLoader<Cubemap, CubemapParameter> {
    CubemapLoaderInfo info = new CubemapLoaderInfo();

    public CubemapLoader(FileHandleResolver resolver) {
        super(resolver);
    }

    @Override
    public void loadAsync(AssetManager manager, String fileName, Fi file, CubemapParameter parameter) {
        this.info.filename = fileName;
        if (parameter == null || parameter.cubemapData == null) {
            this.info.cubemap = null;
            if (parameter != null) {
                this.info.cubemap = parameter.cubemap;
            }
        } else {
            this.info.data = parameter.cubemapData;
            this.info.cubemap = parameter.cubemap;
        }
        if (!this.info.data.isPrepared()) {
            this.info.data.prepare();
        }
    }

    @Override
    public Cubemap loadSync(AssetManager manager, String fileName, Fi file, CubemapParameter parameter) {
        if (this.info == null) {
            return null;
        }
        Cubemap cubemap = this.info.cubemap;
        if (cubemap != null) {
            cubemap.load(this.info.data);
        } else {
            cubemap = new Cubemap(this.info.data);
        }
        if (parameter != null) {
            cubemap.setFilter(parameter.minFilter, parameter.magFilter);
            cubemap.setWrap(parameter.wrapU, parameter.wrapV);
        }
        return cubemap;
    }

    @Override
    public Seq<AssetDescriptor> getDependencies(String fileName, Fi file, CubemapParameter parameter) {
        return null;
    }

    public static class CubemapParameter
    extends AssetLoaderParameters<Cubemap> {
        public Pixmap.Format format = null;
        public Cubemap cubemap = null;
        public CubemapData cubemapData = null;
        public Texture.TextureFilter minFilter = Texture.TextureFilter.nearest;
        public Texture.TextureFilter magFilter = Texture.TextureFilter.nearest;
        public Texture.TextureWrap wrapU = Texture.TextureWrap.clampToEdge;
        public Texture.TextureWrap wrapV = Texture.TextureWrap.clampToEdge;
    }

    public static class CubemapLoaderInfo {
        String filename;
        CubemapData data;
        Cubemap cubemap;
    }
}

