/*
 * Decompiled with CFR 0.152.
 */
package arc.audio;

import arc.ApplicationListener;
import arc.Core;
import arc.audio.AudioBus;
import arc.audio.AudioFilter;
import arc.audio.AudioSource;
import arc.audio.Music;
import arc.audio.Soloud;
import arc.audio.Sound;
import arc.files.Fi;
import arc.util.Disposable;
import arc.util.Log;
import arc.util.Nullable;

public class Audio
implements Disposable {
    public float globalPitch = 1.0f;
    public float falloff = 16000.0f;
    boolean initialized;
    public AudioBus soundBus = new AudioBus();
    public AudioBus musicBus = new AudioBus();

    public Audio() {
        this.initialize();
    }

    public Audio(boolean enabled) {
        if (enabled) {
            this.initialize();
        }
    }

    public boolean initialized() {
        return this.initialized;
    }

    protected void initialize() {
        try {
            Soloud.init();
            Log.info("[Audio] Initialized SoLoud @ using @ at @hz / @ samples / @ channels", Soloud.version(), Soloud.backendString(), Soloud.backendSamplerate(), Soloud.backendBufferSize(), Soloud.backendChannels());
            this.initialized = true;
            this.soundBus = new AudioBus().init();
            this.musicBus = new AudioBus().init();
            Core.app.addListener(new ApplicationListener(){

                @Override
                public void pause() {
                    if (Core.app.isMobile()) {
                        Soloud.pauseAll(true);
                    }
                }

                @Override
                public void resume() {
                    if (Core.app.isMobile()) {
                        Soloud.pauseAll(false);
                    }
                }
            });
        }
        catch (Throwable error) {
            Log.err("Failed to initialize audio, disabling sound", error);
        }
    }

    public Sound newSound(Fi file) {
        if (!this.initialized) {
            return new Sound();
        }
        try {
            return new Sound(file);
        }
        catch (Throwable t) {
            Log.err("Error loading sound: " + file, t);
            return new Sound();
        }
    }

    public Music newMusic(Fi file) {
        if (!this.initialized) {
            return new Music();
        }
        try {
            return new Music(file);
        }
        catch (Throwable t) {
            Log.err("Error loading music: " + file, t);
            return new Music();
        }
    }

    public boolean isPlaying(int soundId) {
        if (!this.initialized) {
            return false;
        }
        return Soloud.idValid(soundId);
    }

    public void protect(int voice, boolean protect) {
        if (!this.initialized) {
            return;
        }
        Soloud.idProtected(voice, protect);
    }

    public int play(AudioSource source, float volume, float pitch, float pan, boolean loop) {
        if (!this.initialized || source.handle == 0L) {
            return -1;
        }
        return Soloud.sourcePlay(source.handle, volume, pitch, pan, loop);
    }

    public void stop(AudioSource source) {
        if (!this.initialized || source.handle == 0L) {
            return;
        }
        Soloud.sourceStop(source.handle);
    }

    public void stop(int soundId) {
        if (!this.initialized) {
            return;
        }
        Soloud.idStop(soundId);
    }

    public void setPaused(int soundId, boolean paused) {
        if (!this.initialized) {
            return;
        }
        Soloud.idPause(soundId, paused);
    }

    public void setLooping(int soundId, boolean looping) {
        if (!this.initialized) {
            return;
        }
        Soloud.idLooping(soundId, looping);
    }

    public void setPitch(int soundId, float pitch) {
        if (!this.initialized) {
            return;
        }
        Soloud.idPitch(soundId, pitch);
    }

    public void setVolume(int soundId, float volume) {
        if (!this.initialized) {
            return;
        }
        Soloud.idVolume(soundId, volume);
    }

    public void set(int soundId, float pan, float volume) {
        if (!this.initialized) {
            return;
        }
        Soloud.idVolume(soundId, volume);
        Soloud.idPan(soundId, pan);
    }

    public void fadeFilterParam(int voice, int filter, int attribute, float value, float timeSec) {
        if (!this.initialized) {
            return;
        }
        Soloud.filterFade(voice, filter, attribute, value, timeSec);
    }

    public void setFilterParam(int voice, int filter, int attribute, float value) {
        if (!this.initialized) {
            return;
        }
        Soloud.filterSet(voice, filter, attribute, value);
    }

    public void setFilter(int index, @Nullable AudioFilter filter) {
        if (!this.initialized) {
            return;
        }
        Soloud.setGlobalFilter(index, filter == null ? 0L : filter.handle);
    }

    public int countPlaying(AudioSource source) {
        if (!this.initialized || source.handle <= 0L) {
            return 0;
        }
        return Soloud.sourceCount(source.handle);
    }

    @Override
    public void dispose() {
        if (!this.initialized) {
            return;
        }
        Soloud.stopAll();
        Soloud.deinit();
        this.initialized = false;
    }
}

