/*
 * Decompiled with CFR 0.152.
 */
package arc.discord;

import arc.func.Cons;
import arc.func.Cons2;
import arc.util.Nullable;
import arc.util.OS;
import arc.util.Strings;
import arc.util.serialization.Jval;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.UUID;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;

public final class DiscordRPC {
    private static int pid;
    private static long clientId;
    private static Pipe pipe;
    public static Cons<String> onActivityJoin;
    public static Cons<String> onActivitySpectate;
    public static Cons2<String, User> onActivityJoinRequest;
    public static Runnable onReady;
    public static Cons<Throwable> onDisconnected;
    public static Cons<Jval> onClose;

    public static void connect(long clientId) throws Exception {
        int major;
        DiscordRPC.clientId = clientId;
        String version = OS.javaVersion;
        int n = major = version.contains(".") ? Strings.parseInt(version.substring(0, version.indexOf(46))) : Strings.parseInt(version);
        if (!(major >= 16 || OS.isWindows && major >= 9)) {
            throw new Exception("Discord RPC is not supported on < Java " + (OS.isWindows ? "9" : "16") + ". Your version: " + version);
        }
        Class<?> c = Class.forName("java.lang.ProcessHandle");
        Object current = c.getMethod("current", new Class[0]).invoke(null, new Object[0]);
        pid = ((Long)c.getMethod("pid", new Class[0]).invoke(current, new Object[0])).intValue();
        DiscordRPC.checkConnected(false);
        try {
            FutureTask<Pipe> task = new FutureTask<Pipe>(() -> Pipe.openPipe(clientId));
            task.run();
            pipe = task.get(500L, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            throw new NoDiscordClientException();
        }
        onReady.run();
        Thread t = new Thread(DiscordRPC::lambda$connect$7);
        t.setDaemon(true);
        t.start();
    }

    public static void send(RichPresence presence) {
        DiscordRPC.checkConnected(true);
        pipe.send(PacketOp.frame, Jval.newObject().put("cmd", "SET_ACTIVITY").put("args", Jval.newObject().put("pid", pid).put("activity", presence == null ? null : presence.toJson())));
    }

    public static void subscribe() {
        DiscordRPC.checkConnected(true);
        for (String value : new String[]{"ACTIVITY_JOIN", "ACTIVITY_SPECTATE", "ACTIVITY_JOIN_REQUEST"}) {
            pipe.send(PacketOp.frame, Jval.newObject().put("cmd", "SUBSCRIBE").put("evt", value));
        }
    }

    public static PipeStatus getStatus() {
        return pipe == null ? PipeStatus.uninitialized : DiscordRPC.pipe.status;
    }

    public static void close() {
        if (DiscordRPC.getStatus() != PipeStatus.connected) {
            return;
        }
        try {
            pipe.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void checkConnected(boolean connected) {
        if (connected && DiscordRPC.getStatus() != PipeStatus.connected) {
            throw new IllegalStateException(String.format("IPCClient (ID: %d) is not connected!", clientId));
        }
        if (!connected && DiscordRPC.getStatus() == PipeStatus.connected) {
            throw new IllegalStateException(String.format("IPCClient (ID: %d) is already connected!", clientId));
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static /* synthetic */ void lambda$connect$7() {
        try {
            while (true) lbl-1000:
            // 5 sources

            {
                p = DiscordRPC.pipe.read();
                if (p.op == PacketOp.close) {
                    DiscordRPC.pipe.status = PipeStatus.disconnected;
                    DiscordRPC.onClose.get(p.data);
                    return;
                }
                json = p.data;
                if (!json.has("cmd") || !json.getString("cmd").equals("DISPATCH")) continue;
                try {
                    data = json.get("data");
                    var3_5 = json.getString("evt");
                    var4_6 = -1;
                    switch (var3_5.hashCode()) {
                        case 2109357146: {
                            if (!var3_5.equals("ACTIVITY_JOIN")) break;
                            var4_6 = 0;
                            break;
                        }
                        case 934942473: {
                            if (!var3_5.equals("ACTIVITY_SPECTATE")) break;
                            var4_6 = 1;
                            break;
                        }
                        case 1182230410: {
                            if (!var3_5.equals("ACTIVITY_JOIN_REQUEST")) break;
                            var4_6 = 2;
                            break;
                        }
                    }
                    switch (var4_6) {
                        case 0: {
                            DiscordRPC.onActivityJoin.get(data.getString("secret"));
                            break;
                        }
                        case 1: {
                            DiscordRPC.onActivitySpectate.get(data.getString("secret"));
                            break;
                        }
                        case 2: {
                            u = data.get("user");
                            DiscordRPC.onActivityJoinRequest.get(data.getString("secret", null), new User(u.getString("username"), u.getString("discriminator"), Long.parseLong(u.getString("id")), u.getString("avatar", null)));
                        }
                    }
                }
                catch (Exception var2_4) {
                    continue;
                }
                break;
            }
        }
        catch (Throwable ex) {
            DiscordRPC.pipe.status = PipeStatus.disconnected;
            DiscordRPC.onDisconnected.get(ex);
        }
        ** GOTO lbl-1000
    }

    static {
        onActivityJoin = secret -> {};
        onActivitySpectate = secret -> {};
        onActivityJoinRequest = (secret, user) -> {};
        onReady = () -> {};
        onDisconnected = error -> {};
        onClose = json -> {};
    }

    static class WindowsPipe
    extends Pipe {
        private final RandomAccessFile file;

        WindowsPipe(String location) throws Exception {
            this.file = new RandomAccessFile(location, "rw");
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.file.write(b);
        }

        @Override
        public Packet read() throws Exception {
            while (this.file.length() == 0L && this.status == PipeStatus.connected) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.status == PipeStatus.disconnected) {
                throw new IOException("Disconnected!");
            }
            if (this.status == PipeStatus.closed) {
                return new Packet(PacketOp.close, null);
            }
            PacketOp op = PacketOp.values()[Integer.reverseBytes(this.file.readInt())];
            int len = Integer.reverseBytes(this.file.readInt());
            byte[] d = new byte[len];
            this.file.readFully(d);
            return new Packet(op, Jval.read(d));
        }

        @Override
        public void close() throws IOException {
            this.send(PacketOp.close, Jval.newObject());
            this.status = PipeStatus.closed;
            this.file.close();
        }
    }

    static class UnixPipe
    extends Pipe {
        private final SocketChannel socket;
        private final ByteBuffer buffer = ByteBuffer.allocate(32768);

        UnixPipe(String location) throws Exception {
            Method method = SocketChannel.class.getMethod("open", SocketAddress.class);
            Class<?> addressc = Class.forName("java.net.UnixDomainSocketAddress");
            Method construct = addressc.getMethod("of", String.class);
            this.socket = (SocketChannel)method.invoke(null, construct.invoke(null, location));
            this.socket.configureBlocking(true);
        }

        @Override
        public Packet read() throws Exception {
            this.buffer.position(0);
            while (this.socket.read(this.buffer) <= 0 && this.status == PipeStatus.connected) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.buffer.position(0);
            if (this.status == PipeStatus.disconnected) {
                throw new IOException("Disconnected!");
            }
            if (this.status == PipeStatus.closed) {
                return new Packet(PacketOp.close, null);
            }
            PacketOp op = PacketOp.values()[Integer.reverseBytes(this.buffer.getInt())];
            byte[] data = new byte[Integer.reverseBytes(this.buffer.getInt())];
            this.buffer.get(data);
            return new Packet(op, Jval.read(data));
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.socket.write(ByteBuffer.wrap(b));
        }

        @Override
        public void close() throws IOException {
            this.send(PacketOp.close, Jval.newObject());
            this.status = PipeStatus.closed;
            this.socket.close();
        }
    }

    static abstract class Pipe {
        private static final int version = 1;
        private static final String[] unixPaths = new String[]{"XDG_RUNTIME_DIR", "TMPDIR", "TMP", "TEMP"};
        public PipeStatus status = PipeStatus.connecting;

        Pipe() {
        }

        public static Pipe openPipe(long clientId) throws Exception {
            for (int i = 0; i < 10; ++i) {
                try {
                    Pipe pipe;
                    String location = Pipe.getPipeLocation(i);
                    if (OS.isWindows) {
                        pipe = new WindowsPipe(location);
                    } else if (OS.isLinux || OS.isMac) {
                        pipe = new UnixPipe(location);
                    } else {
                        throw new RuntimeException("Unsupported OS: " + OS.osName);
                    }
                    pipe.send(PacketOp.handshake, Jval.newObject().put("v", 1).put("client_id", Long.toString(clientId)));
                    pipe.status = PipeStatus.connected;
                    pipe.read();
                    return pipe;
                }
                catch (IOException iOException) {
                    continue;
                }
            }
            throw new Exception("No Discord client found.");
        }

        private static String getPipeLocation(int i) {
            String str;
            if (OS.isWindows) {
                return "\\\\?\\pipe\\discord-ipc-" + i;
            }
            String tmppath = null;
            String[] stringArray = unixPaths;
            int n = stringArray.length;
            for (int j = 0; j < n && (tmppath = System.getenv(str = stringArray[j])) == null; ++j) {
            }
            if (tmppath == null) {
                tmppath = "/tmp";
            }
            return tmppath + "/discord-ipc-" + i;
        }

        public void send(PacketOp op, Jval data) {
            try {
                this.write(new Packet(op, data.put("nonce", UUID.randomUUID().toString())).toBytes());
            }
            catch (IOException ex) {
                this.status = PipeStatus.disconnected;
            }
        }

        public abstract Packet read() throws Exception;

        public abstract void write(byte[] var1) throws IOException;

        public abstract void close() throws IOException;
    }

    public static enum PipeStatus {
        uninitialized,
        connecting,
        connected,
        closed,
        disconnected;

    }

    public static class RichPresence {
        public String state;
        public String details;
        public long startTimestamp;
        public long endTimestamp;
        public String largeImageKey;
        public String largeImageText;
        public String smallImageKey;
        public String smallImageText;
        public String partyId;
        public int partySize;
        public int partyMax;
        public String matchSecret;
        public String joinSecret;
        public String spectateSecret;
        public String label1;
        public String url1;
        public String label2;
        public String url2;
        public boolean instance;

        public Jval toJson() {
            boolean useButtons = this.joinSecret == null && this.matchSecret == null && this.spectateSecret == null && (this.label1 != null && this.url1 != null || this.label2 != null && this.url2 != null);
            return Jval.newObject().put("state", this.state).put("details", this.details).put("timestamps", Jval.newObject().put("start", this.startTimestamp == 0L ? null : Long.valueOf(this.startTimestamp)).put("end", this.endTimestamp == 0L ? null : Long.valueOf(this.endTimestamp))).put("assets", Jval.newObject().put("large_image", this.largeImageKey).put("large_text", this.largeImageText).put("small_image", this.smallImageKey).put("small_text", this.smallImageText)).put("party", this.partyId == null ? null : Jval.newObject().put("id", this.partyId).put("size", Jval.newArray().add(this.partySize).add(this.partyMax))).put("secrets", useButtons ? null : Jval.newObject().put("join", this.joinSecret).put("spectate", this.spectateSecret).put("match", this.matchSecret)).put("buttons", useButtons ? this.buttons() : null).put("instance", this.instance);
        }

        Jval buttons() {
            Jval buttons = Jval.newArray();
            if (this.label1 != null && this.url1 != null) {
                buttons.add(Jval.newObject().put("label", this.label1).put("url", this.url1));
            }
            if (this.label2 != null && this.url2 != null) {
                buttons.add(Jval.newObject().put("label", this.label2).put("url", this.url2));
            }
            return buttons;
        }
    }

    public static class User {
        public final String name;
        public final String discriminator;
        public final long id;
        @Nullable
        public final String avatar;

        public User(String name, String discriminator, long id, String avatar) {
            this.name = name;
            this.discriminator = discriminator;
            this.id = id;
            this.avatar = avatar;
        }
    }

    public static class NoDiscordClientException
    extends RuntimeException {
    }

    static enum PacketOp {
        handshake,
        frame,
        close,
        ping,
        pong;

    }

    static class Packet {
        public final PacketOp op;
        public final Jval data;

        public Packet(PacketOp op, Jval data) {
            this.op = op;
            this.data = data;
        }

        public byte[] toBytes() {
            byte[] d = this.data.toString().getBytes(Strings.utf8);
            ByteBuffer packet = ByteBuffer.allocate(d.length + 8);
            packet.putInt(Integer.reverseBytes(this.op.ordinal()));
            packet.putInt(Integer.reverseBytes(d.length));
            packet.put(d);
            return packet.array();
        }

        public String toString() {
            return "Pkt:" + (Object)((Object)this.op) + this.data.toString();
        }
    }
}

