/*
 * Decompiled with CFR 0.152.
 */
package arc.struct;

import java.lang.reflect.Array;

public class EnumSet<T extends Enum<T>> {
    private int mask;
    public T[] array;
    public int size;

    EnumSet() {
    }

    EnumSet(int size) {
        this.size = size;
    }

    public static <T extends Enum<T>> EnumSet<T> of(T ... arr) {
        EnumSet<T> set = new EnumSet<T>(arr.length);
        set.array = arr;
        for (T t : arr) {
            set.mask |= 1 << ((Enum)t).ordinal();
        }
        return set;
    }

    public EnumSet<T> with(T add) {
        if (!this.contains(add)) {
            Enum[] copy = (Enum[])Array.newInstance(this.array.getClass().getComponentType(), this.array.length + 1);
            System.arraycopy(this.array, 0, copy, 0, this.array.length);
            copy[copy.length - 1] = add;
            return EnumSet.of((Enum[])copy);
        }
        return this;
    }

    public boolean contains(T t) {
        return (this.mask & 1 << ((Enum)t).ordinal()) != 0;
    }
}

