/*
 * Decompiled with CFR 0.152.
 */
package arc.util.serialization;

import arc.struct.ArrayMap;
import arc.struct.ObjectMap;
import arc.struct.Seq;
import arc.util.ArcRuntimeException;
import arc.util.Nullable;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.regex.Pattern;

public class Jval {
    public static final Jval TRUE = new Jval(true);
    public static final Jval FALSE = new Jval(false);
    public static final Jval NULL = new Jval(null);
    @Nullable
    private Object value;

    Jval(Object value) {
        this.value = value;
        if (this.getType() == null) {
            throw new IllegalArgumentException("Invalid JSON value: " + value);
        }
    }

    public static Jval newObject() {
        return new Jval(new JsonMap());
    }

    public static Jval newArray() {
        return new Jval(new JsonArray());
    }

    public static Jval read(Reader reader) {
        try {
            return new Hparser(reader).parse();
        }
        catch (IOException e) {
            throw new ArcRuntimeException(e);
        }
    }

    public static Jval read(byte[] bytes) {
        try {
            return new Hparser(new InputStreamReader(new ByteArrayInputStream(bytes))).parse();
        }
        catch (IOException e) {
            throw new ArcRuntimeException(e);
        }
    }

    public static Jval read(String text) {
        try {
            return new Hparser(text).parse();
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    public Jtype getType() {
        return this.value == null ? Jtype.nil : (this.value instanceof Number ? Jtype.number : (this.value instanceof String ? Jtype.string : (this.value instanceof Boolean ? Jtype.bool : (this.value instanceof JsonMap ? Jtype.object : (this.value instanceof JsonArray ? Jtype.array : null)))));
    }

    public static Jval valueOf(int value) {
        return new Jval(value);
    }

    public static Jval valueOf(long value) {
        return new Jval(value);
    }

    public static Jval valueOf(float value) {
        return new Jval(Float.valueOf(value));
    }

    public static Jval valueOf(double value) {
        return new Jval(value);
    }

    public static Jval valueOf(String string) {
        return string == null ? NULL : new Jval(string);
    }

    public static Jval valueOf(boolean value) {
        return value ? TRUE : FALSE;
    }

    public boolean isObject() {
        return this.value instanceof JsonMap;
    }

    public boolean isArray() {
        return this.value instanceof JsonArray;
    }

    public boolean isNumber() {
        return this.value instanceof Number;
    }

    public boolean isString() {
        return this.value instanceof String;
    }

    public boolean isBoolean() {
        return this.value instanceof Boolean;
    }

    public boolean isTrue() {
        return this.value == Boolean.TRUE;
    }

    public boolean isFalse() {
        return this.value == Boolean.FALSE;
    }

    public boolean isNull() {
        return this.value == null;
    }

    public JsonMap asObject() {
        if (!(this.value instanceof JsonMap)) {
            throw new UnsupportedOperationException("Not an object: " + this);
        }
        return (JsonMap)this.value;
    }

    public JsonArray asArray() {
        if (!(this.value instanceof JsonArray)) {
            throw new UnsupportedOperationException("Not an array: " + this);
        }
        return (JsonArray)this.value;
    }

    public int asInt() {
        return this.asNumber().intValue();
    }

    public long asLong() {
        return this.asNumber().longValue();
    }

    public float asFloat() {
        return this.asNumber().floatValue();
    }

    public double asDouble() {
        return this.asNumber().doubleValue();
    }

    public String asString() {
        if (!(this.value instanceof String) && !(this.value instanceof Number)) {
            throw new UnsupportedOperationException("Not a string: " + this);
        }
        return String.valueOf(this.value);
    }

    public boolean asBool() {
        if (!(this.value instanceof Boolean)) {
            throw new UnsupportedOperationException("Not a bool: " + this);
        }
        return (Boolean)this.value;
    }

    public Number asNumber() {
        if (!(this.value instanceof Number)) {
            throw new UnsupportedOperationException("Not a number: " + this);
        }
        return (Number)this.value;
    }

    public Jval get(String name) {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        return (Jval)this.asObject().get(name);
    }

    public void add(String name, Jval val) {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        this.asObject().put(name, val == null ? NULL : val);
    }

    public void add(String name, String val) {
        this.add(name, Jval.valueOf(val));
    }

    public Jval add(Jval value) {
        this.asArray().add(value);
        return this;
    }

    public Jval add(String value) {
        this.asArray().add(new Jval(value));
        return this;
    }

    public Jval add(Number value) {
        this.asArray().add(new Jval(value));
        return this;
    }

    public Jval add(boolean value) {
        this.asArray().add(new Jval(value));
        return this;
    }

    public Jval put(String name, Jval val) {
        if (val != null) {
            this.add(name, val);
        }
        return this;
    }

    public Jval put(String name, String val) {
        if (val != null) {
            this.add(name, val);
        }
        return this;
    }

    public Jval put(String name, Number val) {
        if (val != null) {
            this.add(name, new Jval(val));
        }
        return this;
    }

    public Jval put(String name, boolean val) {
        this.add(name, new Jval(val));
        return this;
    }

    public Jval remove(String name) {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        return (Jval)this.asObject().removeKey(name);
    }

    public boolean has(String name) {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        return this.asObject().containsKey(name);
    }

    public int getInt(String name, int defaultValue) {
        Jval value = this.get(name);
        return value != null ? value.asInt() : defaultValue;
    }

    public long getLong(String name, long defaultValue) {
        Jval value = this.get(name);
        return value != null ? value.asLong() : defaultValue;
    }

    public float getFloat(String name, float defaultValue) {
        Jval value = this.get(name);
        return value != null ? value.asFloat() : defaultValue;
    }

    public double getDouble(String name, double defaultValue) {
        Jval value = this.get(name);
        return value != null ? value.asDouble() : defaultValue;
    }

    public boolean getBool(String name, boolean defaultValue) {
        Jval value = this.get(name);
        return value != null ? value.asBool() : defaultValue;
    }

    @Nullable
    public String getString(String name) {
        return this.getString(name, "");
    }

    public String getString(String name, String defaultValue) {
        Jval value = this.get(name);
        return value != null && !value.isNull() ? value.asString() : defaultValue;
    }

    public void writeTo(Writer writer) throws IOException {
        this.writeTo(writer, Jformat.plain);
    }

    public void writeTo(Writer writer, Jformat format) throws IOException {
        WritingBuffer buffer = new WritingBuffer(writer, 128);
        switch (format) {
            case plain: {
                new Jwriter(false).save(this, buffer, 0);
                break;
            }
            case formatted: {
                new Jwriter(true).save(this, buffer, 0);
                break;
            }
            case hjson: {
                new Hwriter().save(this, buffer, -1, "", true);
            }
        }
        buffer.flush();
    }

    public String toString() {
        Jtype type = this.getType();
        switch (type) {
            case nil: {
                return "null";
            }
            case number: {
                return (this.value.toString().endsWith(".0") ? this.value.toString().replace(".0", "") : this.value.toString()).replace('E', 'e');
            }
            case string: 
            case bool: {
                return this.value.toString();
            }
        }
        return this.toString(Jformat.plain);
    }

    public String toString(Jformat format) {
        StringWriter writer = new StringWriter();
        try {
            this.writeTo(writer, format);
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
        return writer.toString();
    }

    public boolean equals(Object object) {
        return object != null && object.getClass() == this.getClass() && (this.value == null && ((Jval)object).value == null || ((Jval)object).value != null && this.value != null && this.value.equals(((Jval)object).value));
    }

    static class Jwriter {
        boolean format;

        public Jwriter(boolean format) {
            this.format = format;
        }

        void nl(Writer tw, int level) throws IOException {
            if (this.format) {
                tw.write(10);
                for (int i = 0; i < level; ++i) {
                    tw.write("  ");
                }
            }
        }

        public void save(Jval value, Writer tw, int level) throws IOException {
            boolean following = false;
            switch (value.getType()) {
                case object: {
                    JsonMap obj = value.asObject();
                    tw.write(123);
                    for (ObjectMap.Entry pair : obj) {
                        if (following) {
                            tw.write(",");
                        }
                        this.nl(tw, level + 1);
                        tw.write(34);
                        tw.write(Jwriter.escapeString((String)pair.key));
                        tw.write("\":");
                        Jval v = (Jval)pair.value;
                        Jtype vType = v.getType();
                        if (this.format && vType != Jtype.array && vType != Jtype.object) {
                            tw.write(" ");
                        }
                        this.save(v, tw, level + 1);
                        following = true;
                    }
                    if (following) {
                        this.nl(tw, level);
                    }
                    tw.write(125);
                    break;
                }
                case array: {
                    JsonArray arr = value.asArray();
                    int n = arr.size;
                    if (level != 0) {
                        tw.write(32);
                    }
                    tw.write(91);
                    for (int i = 0; i < n; ++i) {
                        Jval v;
                        Jtype vType;
                        if (following) {
                            tw.write(",");
                        }
                        if ((vType = (v = (Jval)arr.get(i)).getType()) != Jtype.array) {
                            this.nl(tw, level + 1);
                        }
                        this.save(v, tw, level + 1);
                        following = true;
                    }
                    if (following) {
                        this.nl(tw, level);
                    }
                    tw.write(93);
                    break;
                }
                case bool: {
                    tw.write(value.isTrue() ? "true" : "false");
                    break;
                }
                case string: {
                    tw.write(34);
                    tw.write(Jwriter.escapeString(value.asString()));
                    tw.write(34);
                    break;
                }
                default: {
                    tw.write(value.toString());
                }
            }
        }

        static String escapeString(String src) {
            if (src == null) {
                return null;
            }
            for (int i = 0; i < src.length(); ++i) {
                if (Jwriter.getEscapedChar(src.charAt(i)) == null) continue;
                StringBuilder sb = new StringBuilder();
                if (i > 0) {
                    sb.append(src, 0, i);
                }
                return Jwriter.doEscapeString(sb, src, i);
            }
            return src;
        }

        private static String doEscapeString(StringBuilder sb, String src, int cur) {
            int start = cur;
            for (int i = cur; i < src.length(); ++i) {
                String escaped = Jwriter.getEscapedChar(src.charAt(i));
                if (escaped == null) continue;
                sb.append(src, start, i);
                sb.append(escaped);
                start = i + 1;
            }
            sb.append(src, start, src.length());
            return sb.toString();
        }

        private static String getEscapedChar(char c) {
            switch (c) {
                case '\"': {
                    return "\\\"";
                }
                case '\t': {
                    return "\\t";
                }
                case '\n': {
                    return "\\n";
                }
                case '\r': {
                    return "\\r";
                }
                case '\f': {
                    return "\\f";
                }
                case '\b': {
                    return "\\b";
                }
                case '\\': {
                    return "\\\\";
                }
            }
            return null;
        }
    }

    static class Hwriter {
        static Pattern needsEscapeName = Pattern.compile("[,\\{\\[\\}\\]\\s:#\"']|//|/\\*");

        Hwriter() {
        }

        void nl(Writer tw, int level) throws IOException {
            tw.write(10);
            for (int i = 0; i < level; ++i) {
                tw.write("  ");
            }
        }

        public void save(Jval value, Writer tw, int level, String separator, boolean noIndent) throws IOException {
            if (value == null) {
                tw.write(separator);
                tw.write("null");
                return;
            }
            switch (value.getType()) {
                case object: {
                    JsonMap obj = value.asObject();
                    if (!noIndent) {
                        tw.write(" ");
                    }
                    if (level >= 0) {
                        tw.write(123);
                    }
                    int index = 0;
                    for (ObjectMap.Entry pair : obj) {
                        if (index++ != 0 || level >= 0) {
                            this.nl(tw, level + 1);
                        }
                        tw.write(Hwriter.escapeName((String)pair.key));
                        tw.write(":");
                        this.save((Jval)pair.value, tw, level + 1, " ", false);
                    }
                    if (obj.size > 0) {
                        this.nl(tw, level);
                    }
                    if (level < 0) break;
                    tw.write(125);
                    break;
                }
                case array: {
                    JsonArray arr = value.asArray();
                    int n = arr.size;
                    if (!noIndent) {
                        tw.write(" ");
                    }
                    tw.write(91);
                    for (int i = 0; i < n; ++i) {
                        this.nl(tw, level + 1);
                        this.save((Jval)arr.get(i), tw, level + 1, "", true);
                    }
                    if (n > 0) {
                        this.nl(tw, level);
                    }
                    tw.write(93);
                    break;
                }
                case bool: {
                    tw.write(separator);
                    tw.write(value.isTrue() ? "true" : "false");
                    break;
                }
                case string: {
                    this.writeString(value.asString(), tw, level, separator);
                    break;
                }
                default: {
                    tw.write(separator);
                    tw.write(value.toString());
                }
            }
        }

        static String escapeName(String name) {
            if (name.length() == 0 || needsEscapeName.matcher(name).find()) {
                return "\"" + Jwriter.escapeString(name) + "\"";
            }
            return name;
        }

        void writeString(String value, Writer tw, int level, String separator) throws IOException {
            char[] valuec;
            if (value.length() == 0) {
                tw.write(separator + "\"\"");
                return;
            }
            char left = value.charAt(0);
            char right = value.charAt(value.length() - 1);
            char left1 = value.length() > 1 ? value.charAt(1) : (char)'\u0000';
            boolean doEscape = false;
            for (char ch : valuec = value.toCharArray()) {
                if (!Hwriter.needsQuotes(ch)) continue;
                doEscape = true;
                break;
            }
            if (doEscape || Hparser.isWhiteSpace(left) || Hparser.isWhiteSpace(right) || left == '\"' || left == '\'' || left == '#' || left == '/' && (left1 == '*' || left1 == '/') || Hwriter.isPunctuatorChar(left) || Hparser.tryParseNumber(value) != null || Hwriter.startsWithKeyword(value)) {
                boolean noEscape = true;
                for (char ch : valuec) {
                    if (!Hwriter.needsEscape(ch)) continue;
                    noEscape = false;
                    break;
                }
                if (noEscape) {
                    tw.write(separator + "\"" + value + "\"");
                    return;
                }
                boolean noEscapeML = true;
                boolean allWhite = true;
                for (char ch : valuec) {
                    if (Hwriter.needsEscapeML(ch)) {
                        noEscapeML = false;
                        break;
                    }
                    if (Hparser.isWhiteSpace(ch)) continue;
                    allWhite = false;
                }
                if (noEscapeML && !allWhite && !value.contains("'''")) {
                    this.writeMLString(value, tw, level, separator);
                } else {
                    tw.write(separator + "\"" + Jwriter.escapeString(value) + "\"");
                }
            } else {
                tw.write(separator + value);
            }
        }

        void writeMLString(String value, Writer tw, int level, String separator) throws IOException {
            String[] lines = value.replace("\r", "").split("\n", -1);
            if (lines.length == 1) {
                tw.write(separator + "'''");
                tw.write(lines[0]);
                tw.write("'''");
            } else {
                this.nl(tw, ++level);
                tw.write("'''");
                for (String line : lines) {
                    this.nl(tw, line.length() > 0 ? level : 0);
                    tw.write(line);
                }
                this.nl(tw, level);
                tw.write("'''");
            }
        }

        static boolean startsWithKeyword(String text) {
            int p;
            if (text.startsWith("true") || text.startsWith("null")) {
                p = 4;
            } else if (text.startsWith("false")) {
                p = 5;
            } else {
                return false;
            }
            while (p < text.length() && Hparser.isWhiteSpace(text.charAt(p))) {
                ++p;
            }
            if (p == text.length()) {
                return true;
            }
            char ch = text.charAt(p);
            return ch == ',' || ch == '}' || ch == ']' || ch == '#' || ch == '/' && text.length() > p + 1 && (text.charAt(p + 1) == '/' || text.charAt(p + 1) == '*');
        }

        static boolean isPunctuatorChar(int c) {
            return c == 123 || c == 125 || c == 91 || c == 93 || c == 44 || c == 58;
        }

        static boolean needsQuotes(char c) {
            return c == '\t' || c == '\f' || c == '\b' || c == '\n' || c == '\r';
        }

        static boolean needsEscape(char c) {
            return c == '\"' || c == '\\' || Hwriter.needsQuotes(c);
        }

        static boolean needsEscapeML(char c) {
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': {
                    return false;
                }
            }
            return Hwriter.needsQuotes(c);
        }
    }

    public static class JsonParseException
    extends RuntimeException {
        public final int offset;
        public final int line;
        public final int column;

        JsonParseException(String message, int offset, int line, int column) {
            super(message + " at " + line + ":" + column);
            this.offset = offset;
            this.line = line;
            this.column = column;
        }
    }

    static class Hparser {
        private final String buffer;
        private Reader reader;
        private int index;
        private int line;
        private int lineOffset;
        private int current;
        private StringBuilder captureBuffer;
        private StringBuilder peek;
        private boolean capture;
        private boolean isArray;

        Hparser(String string) {
            this.buffer = string;
            this.reset();
        }

        Hparser(Reader reader) throws IOException {
            this(Hparser.readToEnd(reader));
        }

        static String readToEnd(Reader reader) throws IOException {
            int n;
            char[] part = new char[8192];
            StringBuilder sb = new StringBuilder();
            while ((n = reader.read(part, 0, part.length)) != -1) {
                sb.append(part, 0, n);
            }
            return sb.toString();
        }

        static boolean isWhiteSpace(int ch) {
            return ch == 32 || ch == 9 || ch == 10 || ch == 13;
        }

        void reset() {
            this.current = 0;
            this.lineOffset = 0;
            this.index = 0;
            this.line = 1;
            this.peek = new StringBuilder();
            this.reader = new StringReader(this.buffer);
            this.capture = false;
            this.captureBuffer = null;
        }

        Jval parse() throws IOException {
            this.read();
            this.skipWhiteSpace();
            switch (this.current) {
                case 91: 
                case 123: {
                    return this.checkTrailing(this.readValue());
                }
            }
            try {
                return this.checkTrailing(this.readObject(true));
            }
            catch (Exception exception) {
                this.reset();
                this.read();
                this.skipWhiteSpace();
                try {
                    return this.checkTrailing(this.readValue());
                }
                catch (Exception exception2) {
                    throw exception;
                }
            }
        }

        Jval checkTrailing(Jval v) throws JsonParseException, IOException {
            this.skipWhiteSpace();
            if (!this.isEndOfText()) {
                throw this.error("Extra characters in input: " + this.current);
            }
            return v;
        }

        private Jval readValue() throws IOException {
            switch (this.current) {
                case 34: 
                case 39: {
                    return this.readString();
                }
                case 91: {
                    return this.readArray();
                }
                case 123: {
                    return this.readObject(false);
                }
            }
            return this.readTfnns();
        }

        private Jval readTfnns() throws IOException {
            StringBuilder value = new StringBuilder();
            int first = this.current;
            if (Hwriter.isPunctuatorChar(first)) {
                throw this.error("Found a punctuator character '" + (char)first + "' when expecting a quoteless string (check your syntax)");
            }
            value.append((char)this.current);
            while (true) {
                boolean isEol;
                this.read();
                boolean bl = isEol = this.current < 0 || this.current == 13 || this.current == 10 || this.current == 44 && this.isArray || this.current == 93;
                if (isEol || this.current == 44 || this.current == 125 || this.current == 35 || this.current == 47 && (this.peek() == 47 || this.peek() == 42)) {
                    switch (first) {
                        case 102: 
                        case 110: 
                        case 116: {
                            String svalue;
                            switch (svalue = value.toString().trim()) {
                                case "false": {
                                    return FALSE;
                                }
                                case "null": {
                                    return NULL;
                                }
                                case "true": {
                                    return TRUE;
                                }
                            }
                            break;
                        }
                        default: {
                            Jval n;
                            if (first != 45 && (first < 48 || first > 57) || (n = Hparser.tryParseNumber(value, false)) == null) break;
                            return n;
                        }
                    }
                    if (isEol) {
                        if (value.length() > 0 && value.charAt(value.length() - 1) == ',') {
                            value.setLength(value.length() - 1);
                        }
                        return new Jval(value.toString().trim());
                    }
                }
                value.append((char)this.current);
            }
        }

        private Jval readArray() throws IOException {
            JsonArray array;
            block3: {
                this.isArray = true;
                this.read();
                array = new JsonArray();
                this.skipWhiteSpace();
                if (this.readIf(']')) {
                    return new Jval(array);
                }
                do {
                    this.skipWhiteSpace();
                    array.add(this.readValue());
                    this.skipWhiteSpace();
                    if (this.readIf(',')) {
                        this.skipWhiteSpace();
                    }
                    if (this.readIf(']')) break block3;
                } while (!this.isEndOfText());
                throw this.error("End of input while parsing an array (did you forget a closing ']'?)");
            }
            this.isArray = false;
            return new Jval(array);
        }

        private Jval readObject(boolean objectWithoutBraces) throws IOException {
            if (!objectWithoutBraces) {
                this.read();
            }
            JsonMap object = new JsonMap();
            this.skipWhiteSpace();
            while (true) {
                if (objectWithoutBraces) {
                    if (this.isEndOfText()) {
                        break;
                    }
                } else {
                    if (this.isEndOfText()) {
                        throw this.error("End of input while parsing an object (did you forget a closing '}'?)");
                    }
                    if (this.readIf('}')) break;
                }
                String name = this.readName();
                this.skipWhiteSpace();
                if (!this.readIf(':')) {
                    throw this.expected("':'");
                }
                this.skipWhiteSpace();
                object.put(name, this.readValue());
                this.skipWhiteSpace();
                if (!this.readIf(',')) continue;
                this.skipWhiteSpace();
            }
            return new Jval(object);
        }

        private String readName() throws IOException {
            if (this.current == 34 || this.current == 39) {
                return this.readStringInternal(false);
            }
            StringBuilder name = new StringBuilder();
            int space = -1;
            int start = this.index;
            while (true) {
                if (this.current == 58) {
                    if (name.length() == 0) {
                        throw this.error("Found ':' but no key name (for an empty key name use quotes)");
                    }
                    if (space >= 0 && space != name.length()) {
                        this.index = start + space;
                        throw this.error("Found whitespace in your key name (use quotes to include)");
                    }
                    return name.toString();
                }
                if (Hparser.isWhiteSpace(this.current)) {
                    if (space < 0) {
                        space = name.length();
                    }
                } else {
                    if (this.current < 32) {
                        throw this.error("Name is not closed");
                    }
                    if (Hwriter.isPunctuatorChar(this.current)) {
                        throw this.error("Found '" + (char)this.current + "' where a key name was expected (check your syntax or use quotes if the key name includes {}[],: or whitespace)");
                    }
                    name.append((char)this.current);
                }
                this.read();
            }
        }

        private String readMlString() throws IOException {
            StringBuilder sb = new StringBuilder();
            int triple = 0;
            int indent = this.index - this.lineOffset - 4;
            while (Hparser.isWhiteSpace(this.current) && this.current != 10) {
                this.read();
            }
            if (this.current == 10) {
                this.read();
                this.skipIndent(indent);
            }
            while (true) {
                if (this.current < 0) {
                    throw this.error("Bad multiline string");
                }
                if (this.current == 39) {
                    this.read();
                    if (++triple != 3) continue;
                    if (sb.charAt(sb.length() - 1) == '\n') {
                        sb.deleteCharAt(sb.length() - 1);
                    }
                    return sb.toString();
                }
                while (triple > 0) {
                    sb.append('\'');
                    --triple;
                }
                if (this.current == 10) {
                    sb.append('\n');
                    this.read();
                    this.skipIndent(indent);
                    continue;
                }
                if (this.current != 13) {
                    sb.append((char)this.current);
                }
                this.read();
            }
        }

        private void skipIndent(int indent) throws IOException {
            while (indent-- > 0 && Hparser.isWhiteSpace(this.current) && this.current != 10) {
                this.read();
            }
        }

        private Jval readString() throws IOException {
            return new Jval(this.readStringInternal(true));
        }

        private String readStringInternal(boolean allowML) throws IOException {
            int exitCh = this.current;
            this.read();
            this.startCapture();
            while (this.current >= 0 && this.current != exitCh) {
                if (this.current == 92) {
                    this.readEscape();
                    continue;
                }
                this.read();
            }
            String string = this.endCapture();
            this.read();
            if (allowML && exitCh == 39 && this.current == 39 && string.length() == 0) {
                this.read();
                return this.readMlString();
            }
            return string;
        }

        private void readEscape() throws IOException {
            this.pauseCapture();
            this.read();
            switch (this.current) {
                case 34: 
                case 35: 
                case 39: 
                case 47: 
                case 92: {
                    this.captureBuffer.append((char)this.current);
                    break;
                }
                case 98: {
                    this.captureBuffer.append('\b');
                    break;
                }
                case 102: {
                    this.captureBuffer.append('\f');
                    break;
                }
                case 110: {
                    this.captureBuffer.append('\n');
                    break;
                }
                case 114: {
                    this.captureBuffer.append('\r');
                    break;
                }
                case 116: {
                    this.captureBuffer.append('\t');
                    break;
                }
                case 117: {
                    char[] hexChars = new char[4];
                    for (int i = 0; i < 4; ++i) {
                        this.read();
                        if (!this.isHexDigit()) {
                            throw this.expected("hexadecimal digit");
                        }
                        hexChars[i] = (char)this.current;
                    }
                    this.captureBuffer.append((char)Integer.parseInt(new String(hexChars), 16));
                    break;
                }
                default: {
                    throw this.expected("valid escape sequence");
                }
            }
            this.capture = true;
            this.read();
        }

        private static boolean isDigit(char ch) {
            return ch >= '0' && ch <= '9';
        }

        static Jval tryParseNumber(StringBuilder value, boolean stopAtNext) {
            char ch;
            char first;
            int idx = 0;
            int len = value.length();
            if (idx < len && value.charAt(idx) == '-') {
                ++idx;
            }
            if (idx >= len) {
                return null;
            }
            if (!Hparser.isDigit(first = value.charAt(idx++))) {
                return null;
            }
            if (first == '0' && idx < len && Hparser.isDigit(value.charAt(idx))) {
                return null;
            }
            while (idx < len && Hparser.isDigit(value.charAt(idx))) {
                ++idx;
            }
            if (idx < len && value.charAt(idx) == '.') {
                if (++idx >= len || !Hparser.isDigit(value.charAt(idx++))) {
                    return null;
                }
                while (idx < len && Hparser.isDigit(value.charAt(idx))) {
                    ++idx;
                }
            }
            int last = idx;
            while (idx < len && Hparser.isWhiteSpace(value.charAt(idx))) {
                ++idx;
            }
            boolean foundStop = false;
            if (idx < len && stopAtNext && ((ch = value.charAt(idx)) == ',' || ch == '}' || ch == ']' || ch == '#' || ch == '/' && len > idx + 1 && (value.charAt(idx + 1) == '/' || value.charAt(idx + 1) == '*'))) {
                foundStop = true;
            }
            if (idx < len && !foundStop) {
                return null;
            }
            String str = value.substring(0, last);
            if (!(str.contains(".") || str.contains(",") || str.contains("e"))) {
                try {
                    return new Jval(Long.parseLong(str));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return new Jval(Double.parseDouble(str));
        }

        static Jval tryParseNumber(String value) throws IOException {
            return Hparser.tryParseNumber(new StringBuilder(value), true);
        }

        private boolean readIf(char ch) throws IOException {
            if (this.current != ch) {
                return false;
            }
            this.read();
            return true;
        }

        private void skipWhiteSpace() throws IOException {
            while (!this.isEndOfText()) {
                while (this.isWhiteSpace()) {
                    this.read();
                }
                if (this.current == 35 || this.current == 47 && this.peek() == 47) {
                    do {
                        this.read();
                    } while (this.current >= 0 && this.current != 10);
                    continue;
                }
                if (this.current != 47 || this.peek() != 42) break;
                this.read();
                do {
                    this.read();
                } while (this.current >= 0 && (this.current != 42 || this.peek() != 47));
                this.read();
                this.read();
            }
        }

        private int peek(int idx) throws IOException {
            while (idx >= this.peek.length()) {
                int c = this.reader.read();
                if (c < 0) {
                    return c;
                }
                this.peek.append((char)c);
            }
            return this.peek.charAt(idx);
        }

        private int peek() throws IOException {
            return this.peek(0);
        }

        private boolean read() throws IOException {
            if (this.current == 10) {
                ++this.line;
                this.lineOffset = this.index;
            }
            if (this.peek.length() > 0) {
                this.current = this.peek.charAt(0);
                this.peek.deleteCharAt(0);
            } else {
                this.current = this.reader.read();
            }
            if (this.current < 0) {
                return false;
            }
            ++this.index;
            if (this.capture) {
                this.captureBuffer.append((char)this.current);
            }
            return true;
        }

        private void startCapture() {
            if (this.captureBuffer == null) {
                this.captureBuffer = new StringBuilder();
            }
            this.capture = true;
            this.captureBuffer.append((char)this.current);
        }

        private void pauseCapture() {
            int len = this.captureBuffer.length();
            if (len > 0) {
                this.captureBuffer.deleteCharAt(len - 1);
            }
            this.capture = false;
        }

        private String endCapture() {
            String captured;
            this.pauseCapture();
            if (this.captureBuffer.length() > 0) {
                captured = this.captureBuffer.toString();
                this.captureBuffer.setLength(0);
            } else {
                captured = "";
            }
            this.capture = false;
            return captured;
        }

        private JsonParseException expected(String expected) {
            if (this.isEndOfText()) {
                return this.error("Unexpected end of input");
            }
            return this.error("Expected " + expected);
        }

        private JsonParseException error(String message) {
            int column = this.index - this.lineOffset;
            int offset = this.isEndOfText() ? this.index : this.index - 1;
            return new JsonParseException(message, offset, this.line, column - 1);
        }

        private boolean isWhiteSpace() {
            return Hparser.isWhiteSpace((char)this.current);
        }

        private boolean isHexDigit() {
            return this.current >= 48 && this.current <= 57 || this.current >= 97 && this.current <= 102 || this.current >= 65 && this.current <= 70;
        }

        private boolean isEndOfText() {
            return this.current == -1;
        }
    }

    public static enum Jtype {
        string,
        number,
        object,
        array,
        bool,
        nil;

    }

    public static enum Jformat {
        plain,
        formatted,
        hjson;

    }

    static class WritingBuffer
    extends Writer {
        private final Writer writer;
        private final char[] buffer;
        private int fill = 0;

        WritingBuffer(Writer writer, int bufferSize) {
            this.writer = writer;
            this.buffer = new char[bufferSize];
        }

        @Override
        public void write(int c) throws IOException {
            if (this.fill > this.buffer.length - 1) {
                this.flush();
            }
            this.buffer[this.fill++] = (char)c;
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            if (this.fill > this.buffer.length - len) {
                this.flush();
                if (len > this.buffer.length) {
                    this.writer.write(cbuf, off, len);
                    return;
                }
            }
            System.arraycopy(cbuf, off, this.buffer, this.fill, len);
            this.fill += len;
        }

        @Override
        public void write(String str, int off, int len) throws IOException {
            if (this.fill > this.buffer.length - len) {
                this.flush();
                if (len > this.buffer.length) {
                    this.writer.write(str, off, len);
                    return;
                }
            }
            str.getChars(off, off + len, this.buffer, this.fill);
            this.fill += len;
        }

        @Override
        public void flush() throws IOException {
            this.writer.write(this.buffer, 0, this.fill);
            this.fill = 0;
        }

        @Override
        public void close() {
        }
    }

    public static class JsonArray
    extends Seq<Jval> {
    }

    public static class JsonMap
    extends ArrayMap<String, Jval> {
    }
}

