/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ai;

import arc.Core;
import arc.func.Prov;
import arc.math.Mathf;
import arc.struct.ObjectMap;
import arc.struct.Seq;
import arc.util.Nullable;
import arc.util.Tmp;
import java.io.IOException;
import mindustry.Vars;
import mindustry.ctype.Content;
import mindustry.ctype.UnlockableContent;
import mindustry.game.Schematic;
import mindustry.game.Schematics;
import mindustry.type.Item;
import mindustry.type.Liquid;
import mindustry.world.Block;
import mindustry.world.blocks.environment.Floor;
import mindustry.world.blocks.environment.OreBlock;
import mindustry.world.blocks.production.Drill;
import mindustry.world.blocks.production.Pump;
import mindustry.world.blocks.sandbox.ItemSource;
import mindustry.world.blocks.sandbox.LiquidSource;
import mindustry.world.blocks.storage.CoreBlock;
import mindustry.world.meta.BuildVisibility;

public class BaseRegistry {
    public Seq<BasePart> cores = new Seq();
    public Seq<BasePart> parts = new Seq();
    public ObjectMap<Content, Seq<BasePart>> reqParts = new ObjectMap();
    public ObjectMap<Item, OreBlock> ores = new ObjectMap();
    public ObjectMap<Item, Floor> oreFloors = new ObjectMap();

    public Seq<BasePart> forResource(Content item) {
        return (Seq)((Object)this.reqParts.get(item, (Seq<BasePart>)((Object)((Prov<Seq>)Seq::new))));
    }

    public void load() {
        String[] names;
        this.cores.clear();
        this.parts.clear();
        this.reqParts.clear();
        for (Block block : Vars.content.blocks()) {
            if (block instanceof OreBlock) {
                OreBlock ore = (OreBlock)block;
                if (ore.itemDrop != null && !ore.wallOre && !this.ores.containsKey(ore.itemDrop)) {
                    this.ores.put(ore.itemDrop, ore);
                    continue;
                }
            }
            if (!block.isFloor() || block.asFloor().itemDrop == null || this.oreFloors.containsKey(block.asFloor().itemDrop)) continue;
            this.oreFloors.put(block.asFloor().itemDrop, block.asFloor());
        }
        for (String name : names = Core.files.internal("basepartnames").readString().split("\n")) {
            try {
                Schematic schem = Schematics.read(Core.files.internal("baseparts/" + name));
                BasePart part = new BasePart(schem);
                Tmp.v1.setZero();
                int drills = 0;
                for (Schematic.Stile tile : schem.tiles) {
                    UnlockableContent config;
                    if (tile.block instanceof CoreBlock) {
                        part.core = tile.block;
                    }
                    if (tile.block instanceof ItemSource && (config = (Item)tile.config) != null) {
                        part.required = config;
                    }
                    if (tile.block instanceof LiquidSource && (config = (Liquid)tile.config) != null) {
                        part.required = config;
                    }
                    if (!(tile.block instanceof Drill) && !(tile.block instanceof Pump)) continue;
                    Tmp.v1.add((float)(tile.x * 8) + tile.block.offset, (float)(tile.y * 8) + tile.block.offset);
                    ++drills;
                }
                schem.tiles.removeAll(s -> s.block.buildVisibility == BuildVisibility.sandboxOnly);
                part.tier = schem.tiles.sumf(s -> Mathf.pow(s.block.buildCost / s.block.buildCostMultiplier, 1.4f));
                if (part.core != null) {
                    this.cores.add(part);
                } else if (part.required == null) {
                    this.parts.add(part);
                }
                if (drills > 0) {
                    Tmp.v1.scl(1.0f / (float)drills).scl(0.125f);
                    part.centerX = (int)Tmp.v1.x;
                    part.centerY = (int)Tmp.v1.y;
                } else {
                    part.centerX = part.schematic.width / 2;
                    part.centerY = part.schematic.height / 2;
                }
                if (part.required == null || part.core != null) continue;
                ((Seq)((Object)this.reqParts.get(part.required, (Seq<BasePart>)((Object)((Prov<Seq>)Seq::new))))).add(part);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.cores.sort(b -> b.tier);
        this.parts.sort();
        this.reqParts.each((key, arr) -> arr.sort());
    }

    public static class BasePart
    implements Comparable<BasePart> {
        public final Schematic schematic;
        public int centerX;
        public int centerY;
        @Nullable
        public Content required;
        @Nullable
        public Block core;
        public float tier;

        public BasePart(Schematic schematic) {
            this.schematic = schematic;
        }

        @Override
        public int compareTo(BasePart other) {
            return Float.compare(this.tier, other.tier);
        }
    }
}

