/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ai;

import arc.Core;
import arc.Events;
import arc.func.Boolf;
import arc.func.Prov;
import arc.math.geom.Geometry;
import arc.math.geom.Point2;
import arc.math.geom.Position;
import arc.struct.IntQueue;
import arc.struct.IntSeq;
import arc.struct.Seq;
import arc.util.Log;
import arc.util.Nullable;
import arc.util.TaskQueue;
import arc.util.Time;
import mindustry.Vars;
import mindustry.core.World;
import mindustry.game.EventType;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.PathTile;
import mindustry.world.Tile;
import mindustry.world.blocks.environment.Floor;
import mindustry.world.blocks.storage.CoreBlock;
import mindustry.world.meta.BlockFlag;

public class Pathfinder
implements Runnable {
    private static final long maxUpdate = Time.millisToNanos(8L);
    private static final int updateFPS = 60;
    private static final int updateInterval = 16;
    static int wwidth;
    static int wheight;
    static final int impassable = -1;
    public static final int fieldCore = 0;
    public static final Seq<Prov<Flowfield>> fieldTypes;
    public static final int costGround = 0;
    public static final int costLegs = 1;
    public static final int costNaval = 2;
    public static final Seq<PathCost> costTypes;
    int[] tiles = new int[0];
    Flowfield[][][] cache;
    Seq<Flowfield> threadList = new Seq();
    Seq<Flowfield> mainList = new Seq();
    TaskQueue queue = new TaskQueue();
    @Nullable
    Thread thread;
    IntSeq tmpArray = new IntSeq();

    public Pathfinder() {
        this.clearCache();
        Events.on(EventType.WorldLoadEvent.class, event -> {
            this.stop();
            this.tiles = new int[Vars.world.width() * Vars.world.height()];
            wwidth = Vars.world.width();
            wheight = Vars.world.height();
            this.threadList = new Seq();
            this.mainList = new Seq();
            this.clearCache();
            for (int i = 0; i < this.tiles.length; ++i) {
                Tile tile = Vars.world.tiles.geti(i);
                this.tiles[i] = this.packTile(tile);
            }
            if (Vars.state.rules.waveTeam.needsFlowField() && !Vars.net.client()) {
                this.preloadPath(this.getField(Vars.state.rules.waveTeam, 0, 0));
                Log.debug("Preloading ground enemy flowfield.");
                if (Vars.spawner.getSpawns().contains((Tile)((Object)((Boolf<Tile>)t -> t.floor().isLiquid)))) {
                    this.preloadPath(this.getField(Vars.state.rules.waveTeam, 2, 0));
                    Log.debug("Preloading naval enemy flowfield.");
                }
            }
            this.start();
        });
        Events.on(EventType.ResetEvent.class, event -> this.stop());
        Events.on(EventType.TileChangeEvent.class, event -> this.updateTile(event.tile));
        Events.on(EventType.TilePreChangeEvent.class, event -> {
            Tile tile = event.tile;
            if (tile.solid()) {
                for (int i = 0; i < 4; ++i) {
                    Tile other = tile.nearby(i);
                    if (other == null || other.solid()) continue;
                    boolean otherNearSolid = false;
                    for (int j = 0; j < 4; ++j) {
                        Tile othernear = other.nearby(i);
                        if (othernear == null || !othernear.solid()) continue;
                        otherNearSolid = true;
                        break;
                    }
                    int arr = other.array();
                    if (otherNearSolid || this.tiles.length <= arr) continue;
                    int n = arr;
                    this.tiles[n] = this.tiles[n] & 0xFFDFFFFF;
                }
            }
        });
    }

    private void clearCache() {
        this.cache = new Flowfield[256][5][5];
    }

    public int packTile(Tile tile) {
        boolean nearLiquid = false;
        boolean nearSolid = false;
        boolean nearLegSolid = false;
        boolean nearGround = false;
        boolean solid = tile.solid();
        boolean allDeep = tile.floor().isDeep();
        for (int i = 0; i < 4; ++i) {
            Tile other = tile.nearby(i);
            if (other == null) continue;
            Floor floor = other.floor();
            boolean osolid = other.solid();
            if (floor.isLiquid) {
                nearLiquid = true;
            }
            if (osolid && !other.block().teamPassable) {
                nearSolid = true;
            }
            if (!floor.isLiquid) {
                nearGround = true;
            }
            if (!floor.isDeep()) {
                allDeep = false;
            }
            if (other.legSolid()) {
                nearLegSolid = true;
            }
            if (!solid || tile.block().teamPassable) continue;
            int n = other.array();
            this.tiles[n] = this.tiles[n] | 0x200000;
        }
        int tid = tile.getTeamID();
        return PathTile.get(tile.build == null || !solid || tile.block() instanceof CoreBlock ? 0 : Math.min((int)(tile.build.health / 40.0f), 80), tid == 0 && tile.build != null && Vars.state.rules.coreCapture ? 255 : tid, solid, tile.floor().isLiquid, tile.legSolid(), nearLiquid, nearGround, nearSolid, nearLegSolid, tile.floor().isDeep(), tile.floor().damageTaken > 1.0E-5f, allDeep, tile.block().teamPassable);
    }

    public int get(int x, int y) {
        return this.tiles[x + y * wwidth];
    }

    private void start() {
        this.stop();
        if (Vars.net.client()) {
            return;
        }
        this.thread = new Thread((Runnable)this, "Pathfinder");
        this.thread.setPriority(1);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    private void stop() {
        if (this.thread != null) {
            this.thread.interrupt();
            this.thread = null;
        }
        this.queue.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTile(Tile tile) {
        if (Vars.net.client()) {
            return;
        }
        tile.getLinkedTiles(t -> {
            int pos = t.array();
            if (pos < this.tiles.length) {
                this.tiles[pos] = this.packTile((Tile)t);
            }
        });
        for (Flowfield path : this.mainList) {
            if (path == null) continue;
            IntSeq intSeq = path.targets;
            synchronized (intSeq) {
                path.updateTargetPositions();
            }
        }
        this.queue.post(() -> {
            for (Flowfield data : this.threadList) {
                data.dirty = true;
            }
        });
    }

    @Override
    public void run() {
        while (!Vars.net.client()) {
            try {
                if (Vars.state.isPlaying()) {
                    this.queue.run();
                    for (Flowfield data : this.threadList) {
                        if (data.dirty && data.frontier.size == 0) {
                            this.updateTargets(data);
                            data.dirty = false;
                        }
                        this.updateFrontier(data, maxUpdate);
                    }
                }
                try {
                    Thread.sleep(16L);
                    continue;
                }
                catch (InterruptedException e) {
                    return;
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
        return;
    }

    public Flowfield getField(Team team, int costType, int fieldType) {
        if (this.cache[team.id][costType][fieldType] == null) {
            Flowfield field = fieldTypes.get(fieldType).get();
            field.team = team;
            field.cost = costTypes.get(costType);
            field.targets.clear();
            field.getPositions(field.targets);
            this.cache[team.id][costType][fieldType] = field;
            this.queue.post(() -> this.registerPath(field));
        }
        return this.cache[team.id][costType][fieldType];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Tile getTargetTile(Tile tile, Flowfield path) {
        if (tile == null) {
            return null;
        }
        if (!path.initialized) {
            return tile;
        }
        if (path.refreshRate > 0 && Time.timeSinceMillis(path.lastUpdateTime) > (long)path.refreshRate) {
            path.lastUpdateTime = Time.millis();
            this.tmpArray.clear();
            path.getPositions(this.tmpArray);
            IntSeq intSeq = path.targets;
            synchronized (intSeq) {
                if (path.targets.size != 1 || this.tmpArray.size != 1 || path.targets.first() != this.tmpArray.first()) {
                    path.updateTargetPositions();
                    this.queue.post(() -> this.updateTargets(path));
                }
            }
        }
        int[] values = path.hasComplete ? path.completeWeights : path.weights;
        int apos = tile.array();
        int value = values[apos];
        Tile current = null;
        int tl = 0;
        for (Point2 point : Geometry.d8) {
            int packed;
            int dx = tile.x + point.x;
            int dy = tile.y + point.y;
            Tile other = Vars.world.tile(dx, dy);
            if (other == null || values[packed = Vars.world.packArray(dx, dy)] >= value || current != null && values[packed] >= tl || !path.passable(packed) || point.x != 0 && point.y != 0 && (!path.passable(Vars.world.packArray(tile.x + point.x, tile.y)) || !path.passable(Vars.world.packArray(tile.x, tile.y + point.y)))) continue;
            current = other;
            tl = values[packed];
        }
        if (current == null || tl == -1 || path.cost == ((PathCost[])Pathfinder.costTypes.items)[0] && current.dangerous() && !tile.dangerous()) {
            return tile;
        }
        return current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTargets(Flowfield path) {
        ++path.search;
        IntSeq intSeq = path.targets;
        synchronized (intSeq) {
            for (int i = 0; i < path.targets.size; ++i) {
                int pos = path.targets.get(i);
                path.weights[pos] = 0;
                path.searches[pos] = path.search;
                path.frontier.addFirst(pos);
            }
        }
    }

    private void preloadPath(Flowfield path) {
        path.updateTargetPositions();
        this.registerPath(path);
        this.updateFrontier(path, -1L);
    }

    private void registerPath(Flowfield path) {
        int i;
        path.lastUpdateTime = Time.millis();
        path.setup(this.tiles.length);
        this.threadList.add(path);
        Core.app.post(() -> this.mainList.add(path));
        for (i = 0; i < this.tiles.length; ++i) {
            path.weights[i] = -1;
        }
        for (i = 0; i < path.targets.size; ++i) {
            int pos = path.targets.get(i);
            path.weights[pos] = 0;
            path.frontier.addFirst(pos);
        }
    }

    private void updateFrontier(Flowfield path, long nsToRun) {
        boolean hadAny = path.frontier.size > 0;
        long start = Time.nanos();
        int counter = 0;
        while (path.frontier.size > 0) {
            int tile = path.frontier.removeLast();
            if (path.weights == null) {
                return;
            }
            int cost = path.weights[tile];
            if (path.frontier.size >= Vars.world.width() * Vars.world.height()) {
                path.frontier.clear();
                return;
            }
            if (cost != -1) {
                for (Point2 point : Geometry.d4) {
                    int otherCost;
                    int newPos;
                    int dx = tile % wwidth + point.x;
                    int dy = tile / wwidth + point.y;
                    if (dx < 0 || dy < 0 || dx >= wwidth || dy >= wheight || path.weights[newPos = tile + point.x + point.y * wwidth] <= cost + (otherCost = path.cost.getCost(path.team.id, this.tiles[newPos])) && path.searches[newPos] >= path.search || otherCost == -1) continue;
                    path.frontier.addFirst(newPos);
                    path.weights[newPos] = cost + otherCost;
                    path.searches[newPos] = (short)path.search;
                }
            }
            if (nsToRun < 0L || counter++ < 200) continue;
            counter = 0;
            if (Time.timeSinceNanos(start) < nsToRun) continue;
            return;
        }
        if (hadAny && path.frontier.size == 0) {
            System.arraycopy(path.weights, 0, path.completeWeights, 0, path.weights.length);
            path.hasComplete = true;
        }
    }

    static {
        fieldTypes = Seq.with(EnemyCoreField::new);
        costTypes = Seq.with((team, tile) -> PathTile.allDeep(tile) || (PathTile.team(tile) == team && !PathTile.teamPassable(tile) || PathTile.team(tile) == 0) && PathTile.solid(tile) ? -1 : 1 + PathTile.health(tile) * 5 + (PathTile.nearSolid(tile) ? 2 : 0) + (PathTile.nearLiquid(tile) ? 6 : 0) + (PathTile.deep(tile) ? 6000 : 0) + (PathTile.damages(tile) ? 30 : 0), (team, tile) -> PathTile.legSolid(tile) ? -1 : 1 + (PathTile.deep(tile) ? 6000 : 0) + (PathTile.solid(tile) ? 5 : 0), (team, tile) -> (!PathTile.liquid(tile) ? 6000 : 1) + PathTile.health(tile) * 5 + (PathTile.nearGround(tile) || PathTile.nearSolid(tile) ? 14 : 0) + (PathTile.deep(tile) ? 0 : 1) + (PathTile.damages(tile) ? 35 : 0));
    }

    public static abstract class Flowfield {
        protected int refreshRate;
        protected Team team = Team.derelict;
        protected PathCost cost = costTypes.get(0);
        protected volatile boolean hasComplete;
        protected boolean dirty = false;
        public int[] weights;
        public int[] searches;
        public int[] completeWeights;
        IntQueue frontier = new IntQueue();
        final IntSeq targets = new IntSeq();
        int search = 1;
        long lastUpdateTime;
        boolean initialized;

        void setup(int length) {
            this.weights = new int[length];
            this.searches = new int[length];
            this.completeWeights = new int[length];
            this.frontier.ensureCapacity(length / 4);
            this.initialized = true;
        }

        public boolean hasCompleteWeights() {
            return this.hasComplete && this.completeWeights != null;
        }

        public void updateTargetPositions() {
            this.targets.clear();
            this.getPositions(this.targets);
        }

        protected boolean passable(int pos) {
            int amount = this.cost.getCost(this.team.id, Vars.pathfinder.tiles[pos]);
            return amount != -1 && (this.cost != costTypes.get(2) || amount < 6000);
        }

        protected abstract void getPositions(IntSeq var1);
    }

    public static interface PathCost {
        public int getCost(int var1, int var2);
    }

    class PathTileStruct {
        int health;
        int team;
        boolean solid;
        boolean liquid;
        boolean legSolid;
        boolean nearLiquid;
        boolean nearGround;
        boolean nearSolid;
        boolean nearLegSolid;
        boolean deep;
        boolean damages;
        boolean allDeep;
        boolean teamPassable;

        PathTileStruct() {
        }
    }

    public static class PositionTarget
    extends Flowfield {
        public final Position position;

        public PositionTarget(Position position) {
            this.position = position;
            this.refreshRate = 900;
        }

        @Override
        public void getPositions(IntSeq out) {
            out.add(Vars.world.packArray(World.toTile(this.position.getX()), World.toTile(this.position.getY())));
        }
    }

    public static class EnemyCoreField
    extends Flowfield {
        @Override
        protected void getPositions(IntSeq out) {
            for (Building building : Vars.indexer.getEnemy(this.team, BlockFlag.core)) {
                out.add(building.tile.array());
            }
            if (Vars.state.rules.waves && this.team == Vars.state.rules.defaultTeam) {
                for (Tile tile : Vars.spawner.getSpawns()) {
                    out.add(tile.array());
                }
            }
        }
    }
}

